/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.cli;

import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.Arrays;
import org.schemaspy.SchemaAnalyzer;
import org.schemaspy.cli.CommandLineArgumentParser;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.input.dbms.MissingParameterException;
import org.schemaspy.input.dbms.exceptions.ConnectionFailure;
import org.schemaspy.model.EmptySchemaException;
import org.schemaspy.model.InvalidConfigurationException;
import org.schemaspy.util.DbSpecificConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.stereotype.Component;

@Component
public class SchemaSpyRunner
implements ExitCodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int EXIT_CODE_OK = 0;
    private static final int EXIT_CODE_GENERIC_ERROR = 1;
    private static final int EXIT_CODE_EMPTY_SCHEMA = 2;
    private static final int EXIT_CODE_CONNECTION_ERROR = 3;
    private static final int EXIT_CODE_CONFIG_ERROR = 4;
    private static final int EXIT_CODE_MISSING_PARAMETER = 5;
    private final SchemaAnalyzer analyzer;
    private final CommandLineArguments arguments;
    private final CommandLineArgumentParser commandLineArgumentParser;
    private final LoggingSystem loggingSystem;
    private int exitCode = 0;

    @Autowired
    public SchemaSpyRunner(SchemaAnalyzer analyzer, CommandLineArguments arguments, CommandLineArgumentParser commandLineArgumentParser, LoggingSystem loggingSystem) {
        this.analyzer = analyzer;
        this.arguments = arguments;
        this.commandLineArgumentParser = commandLineArgumentParser;
        this.loggingSystem = loggingSystem;
    }

    public void run(String ... args) {
        try {
            this.commandLineArgumentParser.parse(args);
        }
        catch (ParameterException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.exitCode = 1;
            return;
        }
        if (this.arguments.isHelpRequired()) {
            this.commandLineArgumentParser.printUsage();
            return;
        }
        if (this.arguments.isDbHelpRequired()) {
            this.commandLineArgumentParser.printDatabaseTypesHelp();
            return;
        }
        if (this.arguments.isDebug()) {
            this.enableDebug();
        }
        this.runAnalyzer(args);
    }

    public void enableDebug() {
        this.loggingSystem.setLogLevel("org.schemaspy", LogLevel.DEBUG);
        LOGGER.debug("Debug enabled");
    }

    private void runAnalyzer(String ... args) {
        this.exitCode = 1;
        try {
            this.exitCode = this.analyzer.analyze() == null ? 1 : 0;
        }
        catch (ConnectionFailure couldntConnect) {
            LOGGER.warn("Connection Failure", (Throwable)couldntConnect);
            this.exitCode = 3;
        }
        catch (EmptySchemaException noData) {
            LOGGER.warn("Empty schema", (Throwable)noData);
            this.exitCode = 2;
        }
        catch (InvalidConfigurationException badConfig) {
            this.exitCode = 4;
            LOGGER.debug("Command line parameters: {}", Arrays.asList(args));
            if (badConfig.getParamName() != null) {
                LOGGER.error("Bad parameter: '{} = {}'", new Object[]{badConfig.getParamName(), badConfig.getParamValue(), badConfig});
            } else {
                LOGGER.error("Bad config", (Throwable)badConfig);
            }
        }
        catch (MissingParameterException mrpe) {
            this.exitCode = 5;
            LOGGER.error("*** {} ***", (Object)mrpe.getMessage());
            LOGGER.info("Missing required connection parameters for '-t {}'", (Object)this.arguments.getConnectionConfig().getDatabaseType());
            new DbSpecificConfig(this.arguments.getConnectionConfig().getDatabaseType(), this.arguments.getConnectionConfig().getDatabaseTypeProperties()).dumpUsage();
        }
        catch (SQLException e) {
            LOGGER.error("SqlException", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

