/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.schemaspy.input.dbms.config.PropertiesFinder;
import org.schemaspy.input.dbms.config.PropertiesResolver;
import org.schemaspy.input.dbms.config.ResolutionInfo;
import org.schemaspy.input.dbms.config.ResourceFinder;
import org.schemaspy.input.dbms.exceptions.ResourceNotFoundException;
import org.schemaspy.input.dbms.exceptions.RuntimeIOException;
import org.schemaspy.model.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePropertiesResolver
implements PropertiesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ResourceFinder resourceFinder;
    private static final Predicate<Map.Entry> isInclude = e -> {
        if (e.getKey().toString().startsWith("include.")) {
            if (e.getValue().toString().split("::").length == 2) {
                return true;
            }
            String msg = "Include directive is incorrect {" + e.getKey().toString() + "=" + e.getValue().toString() + "}";
            throw new InvalidConfigurationException(msg);
        }
        return false;
    };

    public SimplePropertiesResolver() {
        this.resourceFinder = new PropertiesFinder();
    }

    public SimplePropertiesResolver(ResourceFinder resourceFinder) {
        this.resourceFinder = resourceFinder;
    }

    public Properties getDbProperties(String dbType) {
        try {
            ResolutionInfo resolutionInfo = new ResolutionInfo(dbType);
            URL url = this.resourceFinder.find(dbType);
            resolutionInfo.addTrace(url);
            Properties props = this.fromURL(url);
            this.processIncludes(props, resolutionInfo);
            this.processExtends(props, resolutionInfo);
            LOGGER.debug(resolutionInfo.getTrace());
            return props;
        }
        catch (ResourceNotFoundException rnfe) {
            throw new InvalidConfigurationException("Unable to resolve databaseType: " + dbType, (Throwable)rnfe, "-t", dbType);
        }
    }

    private Properties fromURL(URL url) {
        Properties properties = new Properties();
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failed to load properties from: " + url.getFile(), (Throwable)e);
        }
        return properties;
    }

    private void processIncludes(Properties props, ResolutionInfo resolutionInfo) {
        Map<String, String> includes = props.entrySet().stream().filter(isInclude).collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        includes.keySet().forEach(props::remove);
        includes.values().stream().map(s -> s.split("::")).forEach(ref -> {
            Properties refProps = this.resolve(ref[0], resolutionInfo);
            props.putIfAbsent(ref[1], refProps.getProperty(ref[1]));
        });
    }

    private void processExtends(Properties props, ResolutionInfo resolutionInfo) {
        String parentDbType = (String)props.remove("extends");
        if (Objects.nonNull(parentDbType)) {
            Properties parentProperties = this.resolve(parentDbType.trim(), resolutionInfo);
            parentProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)props::putIfAbsent));
        }
    }

    private Properties resolve(String dbType, ResolutionInfo resolutionInfo) {
        URL url = this.resourceFinder.find(dbType);
        resolutionInfo.addTrace(url);
        Properties props = this.fromURL(url);
        this.processIncludes(props, resolutionInfo);
        this.processExtends(props, resolutionInfo);
        return props;
    }
}

