
--
-- Ensure correct encoding
--
SET NAMES utf8mb4;


--
-- Table structure for table `lang_languages`
--


DROP TABLE IF EXISTS `lang_languages`;
CREATE TABLE `lang_languages` (
  `lang_id` int(11) NOT NULL auto_increment,
  `lang_code` char(2) NOT NULL default '',
  `lang_description` varchar(100) default NULL,
  `lang_is_rtl` TINYINT DEFAULT 0,
  UNIQUE KEY `lang_id` (`lang_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 ;


--
-- Dumping data for table `lang_languages`
--

INSERT INTO `lang_languages`   (`lang_id`, `lang_code`, `lang_description`, `lang_is_rtl`) VALUES
(1, 'en', 'English (Standard)', 0),
(2, 'se', 'Swedish', 0),
(3, 'es', 'Spanish (Spain)', 0),
(4, 'el', 'Spanish (Latin American)', 0),
(5, 'de', 'German', 0),
(6, 'du', 'Dutch', 0),
(7, 'he', 'Hebrew', 1),
(8, 'fr', 'French (Standard)', 0),
(9, 'fq', 'French (Canadian)', 0),
(10, 'zh', 'Chinese (Simplified)', 0),
(11, 'zt', 'Chinese (Traditional)', 0),
(12, 'ru', 'Russian', 0),
(13, 'hy', 'Armenian', 0),
(14, 'id', 'Bahasa Indonesia', 0),
(15, 'gr', 'Greek', 0),
(16, 'ei', 'English (Indian)', 0),
(17, 'pe', 'Portuguese (European)', 0),
(18, 'pt', 'Portuguese (Brazilian)', 0),
(19, 'pa', 'Portuguese (Angolan)', 0),
(20, 'ar', 'Arabic', 1),
(21, 'da', 'Danish', 0),
(22, 'tr', 'Turkish', 0),
(23, 'po', 'Polish', 0),
(24, 'it', 'Italian', 0),
(25, 'hi', 'Hindi', 0),
(26, 'ro', 'Romanian', 0),
(27, 'vi', 'Vietnamese', 0),
(28, 'sq', 'Albanian', 0),
(29, 'cs', 'Czech', 0),
(30, 'uk', 'Ukrainian', 0),
(31, 'fa', 'Persian', 1),
(32, 'ja', 'Japanese', 0),
(33, 'fi', 'Finnish', 0),
(34, 'mr', 'Marathi', 0),
(35, 'ta', 'Tamil', 0),
(36, 'au', 'English (Australian)', 0),
(37, 'dd', 'dummy', 0);

--


--
-- Table structure for table `lang_constants`
--


DROP TABLE IF EXISTS `lang_constants`;
CREATE TABLE `lang_constants` (
  `cons_id` int(11) NOT NULL auto_increment,
  `constant_name` mediumtext BINARY,
  UNIQUE KEY `cons_id` (`cons_id`),
  KEY `constant_name` (`constant_name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=13235 ;


--
-- Dumping data for table `lang_constants`
--

INSERT INTO `lang_constants`   (`cons_id`, `constant_name`) VALUES
(1, 'A'),
(2, 'A check number or claim number to identify the payment'),
(3, 'A claim must be selected to enable this menu.'),
(4, 'A client certificate for the admin user'),
(5, 'A Clinical Decision Rule is patient specific information that is filtered and presented at appropriate times to enhance health and health care'),
(6, 'A clinical document is attached'),
(7, 'A clinical document is attached.'),
(8, 'A code of this type is already selected. Erase the field first if you need to replace it.'),
(9, 'A dated reminder message can be either forwarded by clicking the Forward button or removed from the dated reminders list by clicking on the Set As Completed button'),
(10, 'A dedicated security key needs to be purchased'),
(11, 'A default code is optional as the needed code can be entered at the time of placing the actual order'),
(12, 'A detailed guide on how to enable and setup a Clinical Decision rule is found here'),
(13, 'A distributor is required'),
(14, 'A due date can be specified or a specific time period can be chosen for the dated reminder to to show up'),
(15, 'A few words to indicate the reason for the visit'),
(16, 'A followup appointment can also be scheduled right from the fee sheet.'),
(17, 'A GCAC visit form should be added to this visit.'),
(18, 'A HL7 v2.x message simply consists of several lines of text, each line is called a segment and is further divided into fields by using the pipe (|) character'),
(19, 'A large application like openEMR is used by a multitude of users with varying roles and degrees of responsibility. It is imperative that access to various parts of the program be granted to users on a need to know basis. To achieve this - Access Control Lists (ACL) are used.'),
(20, 'A lot number is required'),
(21, 'A lot number is required!'),
(22, 'A lowercase letter'),
(23, 'A New Appointment'),
(24, 'A new feature helps to group frequently ordered tests so that they can be ordered together'),
(25, 'A new message can thus be sent to a single or multiple users and/or can be about a single or multiple patients'),
(26, 'A new patients credentials could not be sent after portal registration.'),
(27, 'A new tab sub menu will be visible at the top of the Message center page'),
(28, 'A number'),
(29, 'A Patient Must Be Selected to Generate This Report'),
(30, 'A patient with this ID already exists.'),
(31, 'A patient with this name already exists.'),
(32, 'A patient with this SS already exists.'),
(33, 'A Payment is Required!. Please input a payment line item entry.'),
(34, 'A place to document and display the patient\'s past medical history, family history, personal history'),
(35, 'A popup box will alert you about success or failure'),
(36, 'A positive number will show that many past appointments on a Widget in the Patient Summary screen (a negative number will show the past appointments in descending order)'),
(37, 'A positive number will show that many past appointments on a Widget in the Patient Summary screen.'),
(38, 'A product was selected but there is no product section in this form.'),
(39, 'A provider or warehouse can be selected in the dropwdown box. For this option to be displayed \'Support provider in line item in fee sheet\' box must be checked in Administration > Globals> Billing page'),
(40, 'A quantity is required'),
(41, 'A Recurring Appointment. Please contact your appointment desk for any changes.'),
(42, 'A Referral has an additional action - to print the referral or save it as a pdf file'),
(43, 'A Referral is the most common type of transaction'),
(44, 'A referral source may be specified for each visit.'),
(45, 'A related IPPF code is required!'),
(46, 'A secure (HTTPS) web connection is required for U2F'),
(47, 'A short description of this group that will appear when you hover over the newly created group (ARO).'),
(48, 'A short description of this group, Serum chemistry tests'),
(49, 'A short description of this procedure or result code'),
(50, 'A signature is required for this document. Please sign document where required'),
(51, 'A source lot is required'),
(52, 'A special character'),
(53, 'A standardized form called the Health Insurance Claim Form is used to submit claims'),
(54, 'A third alternative is to scan the results and save it as a document - TIFF, JPEG or PDF in the patient\'s chart under documents'),
(55, 'A two tabbed form will be revealed'),
(56, 'A unique value to identify this field, not visible to the user'),
(57, 'A useful start would be to obtain a paper lab slip from a few labs and look at the way the tests are organized on the lab slip'),
(58, 'A valid UDI has not been processed yet.'),
(59, 'A visit already exists for this group today. Click Cancel to open it, or OK to proceed with creating a new one.'),
(60, 'A visit already exists for this patient today. Click Cancel to open it, or OK to proceed with creating a new one.'),
(61, 'A warehouse is required'),
(62, 'a.c.'),
(63, 'a.m.'),
(64, 'A/C{{anterior chamber}}'),
(65, 'A/F Level Right:'),
(66, 'AAA Segments'),
(67, 'AB'),
(68, 'Abbreviation'),
(69, 'Abcess:'),
(70, 'Abdominal'),
(71, 'Able to Bear Weight four (4) steps:'),
(72, 'Abn'),
(73, 'ABN is required but not signed!'),
(74, 'ABN Status'),
(75, 'ABN1'),
(76, 'ABNL'),
(77, 'Abnormal'),
(78, 'Abnormal Blood Test'),
(79, 'Abnormal Hair Growth'),
(80, 'Abnormal Mammogram'),
(81, 'Abort'),
(82, 'Aborted since querystring hash was invalid'),
(83, 'Aborted since unable to complete transaction'),
(84, 'Aborted since unable to obtain token'),
(85, 'Aborted since unable to submit transaction'),
(86, 'Abortion'),
(87, 'Abortion Issues'),
(88, 'Abortion Method'),
(89, 'Abortion-Related Categories'),
(90, 'Abortions'),
(91, 'About'),
(92, 'About Portal Dashboard'),
(93, 'About the calendar'),
(94, 'About Your Portal'),
(95, 'Above upper panic limits'),
(96, 'Absences by Diagnosis'),
(97, 'Absolute path to node binary'),
(98, 'Accept'),
(99, 'Accept Assignment'),
(100, 'Accept Credit Card transactions from Front Payments'),
(101, 'Accept Payment'),
(102, 'Accept Payment for'),
(103, 'Accept Payment for '),
(104, 'Accepts Assignment'),
(105, 'Access can be given to other groups by editing User Memberships or Groups and Access Controls in Administration > ACL'),
(106, 'Access Control'),
(107, 'Access Control List Administration'),
(108, 'Access Control List Help'),
(109, 'Access Control Lists'),
(110, 'Access core data set of patient information at the beginning of an encounter'),
(111, 'Access date'),
(112, 'Access denied'),
(113, 'Access is then granted selectively to portions of the program on a need to know basis.'),
(114, 'access not allowed'),
(115, 'Access not allowed'),
(116, 'Access Not Authorized'),
(117, 'Access Tokens'),
(118, 'Access Your Medical Records'),
(119, 'Access Your Patient Portal'),
(120, 'Accident'),
(121, 'Account'),
(122, 'Account Id'),
(123, 'Account Id issued for NewCrop eRx service, used to separate multi-facility accounts.'),
(124, 'Account Id issued for Weno eRx service.'),
(125, 'Account Id issued for Your clinics eRx service.'),
(126, 'Account is validated. Send new credentials?'),
(127, 'Account Name'),
(128, 'Account Name issued for NewCrop eRx service.'),
(129, 'Account Password issued for NewCrop eRx service.'),
(130, 'Account Registration'),
(131, 'Accounting'),
(132, 'Accounting (acct)'),
(133, 'Accounting Transactions Export'),
(134, 'Accounting transactions export to CSV'),
(135, 'Accountings'),
(136, 'Acct'),
(137, 'ACD{{anterior chamber depth}}'),
(138, 'Aches'),
(139, 'Acknowledge as my Electronic Signature'),
(140, 'Acknowledgment Requested (ISA14)'),
(141, 'Acknowledgments, Licensing and Certification'),
(142, 'ACL'),
(143, 'ACL Administration'),
(144, 'ACL Administration (acl)'),
(145, 'ACL Administration Not Authorized'),
(146, 'ACL check failed'),
(147, 'ACL Fine Granular Control'),
(148, 'ACL Updated Successfully'),
(149, 'Acne'),
(150, 'ACO'),
(151, 'ACOM{{Anterior Segment}}'),
(152, 'Act'),
(153, 'Act Date'),
(154, 'Action'),
(155, 'Action Taken'),
(156, 'Action Taken Time'),
(157, 'Action User'),
(158, 'Actions'),
(159, 'Activate'),
(160, 'Activate CCR/CCD Reporting'),
(161, 'activate to sort column ascending'),
(162, 'activate to sort column descending'),
(163, 'Activate UB04/837I Claim Support'),
(164, 'Activates custom work flow logic'),
(165, 'Active'),
(166, 'Active - By default any value added here will be set to Active, to prevent/remove an item from showing up in the drop-down list just uncheck and deactivate'),
(167, 'Active Alert'),
(168, 'Active Alert - that presents as a pop-up notification when a patient\'s chart is entered'),
(169, 'Active Alert Rules'),
(170, 'Active Alerts/Reminders'),
(171, 'Active Chart'),
(172, 'Active Codes'),
(173, 'Active Directory - Domains Base'),
(174, 'Active Directory - Domains Controllers'),
(175, 'Active Directory - Suffix Of Account'),
(176, 'Active Encounter'),
(177, 'Active Issue Codes'),
(178, 'Active lists'),
(179, 'Active Messages'),
(180, 'Active Patient'),
(181, 'Active Plans'),
(182, 'Active Templates'),
(183, 'Active{{Appointment}}'),
(184, 'Active{{Code}}'),
(185, 'Active{{Drug}}'),
(186, 'Active{{Issue}}'),
(187, 'Active{{Item}}'),
(188, 'Active{{Note}}'),
(189, 'Active{{Plan}}'),
(190, 'Active{{Service}}'),
(191, 'Activity'),
(192, 'Activity Type'),
(193, 'Actual Receipts'),
(194, 'Acuity'),
(195, 'ACUITY'),
(196, 'Acuity with Autorefraction'),
(197, 'Acuity with Contact Lenses'),
(198, 'Acuity with correction'),
(199, 'Acuity with Cycloplegic Refraction'),
(200, 'Acuity with Manifest Refraction'),
(201, 'Acuity with Pinhole'),
(202, 'Acuity without correction'),
(203, 'Acute Intoxication/Withdrawal'),
(204, 'Acute Manifestation of a Chronic Condition'),
(205, 'Acute on Chronic'),
(206, 'Ad Reviewed'),
(207, 'Add'),
(208, 'add'),
(209, 'ADD'),
(210, 'Add a Company'),
(211, 'Add a condition'),
(212, 'ADD A NEW RECALL'),
(213, 'Add a New Recall'),
(214, 'Add a note to the biller'),
(215, 'Add a Pharmacy'),
(216, 'Add all needed providers in a similar manner'),
(217, 'Add all rules to plan'),
(218, 'add an event for '),
(219, 'Add as a new message'),
(220, 'Add as a new note'),
(221, 'Add as New'),
(222, 'Add as new patient'),
(223, 'Add Bottom Border Row'),
(224, 'Add Buttons'),
(225, 'Add Buttons for Special Chars,Texts to be Displayed on Top of the Editor for inclusion to the text on a Click'),
(226, 'Add Category'),
(227, 'Add Constant'),
(228, 'Add Context'),
(229, 'Add Copay'),
(230, 'Add criteria'),
(231, 'Add Custom Button'),
(232, 'Add Data Bottom Border'),
(233, 'Add desired privileges by moving items (ACOs) from the \'Inactive\' column to the \'Active\' column.'),
(234, 'Add Diagnosis'),
(235, 'Add Drug'),
(236, 'Add Edit Transactions Help'),
(237, 'Add encounter'),
(238, 'Add Encounter'),
(239, 'Add encounter/notes'),
(240, 'Add Facility'),
(241, 'Add Field'),
(242, 'Add following lines to the Apache configuration file'),
(243, 'Add Group'),
(244, 'Add group'),
(245, 'Add ICD Code'),
(246, 'Add Immunization'),
(247, 'Add is not authorized!'),
(248, 'Add Issue'),
(249, 'Add item to track'),
(250, 'Add Language'),
(251, 'Add Lot'),
(252, 'Add manually'),
(253, 'Add Missing Context Template.'),
(254, 'Add Mode'),
(255, 'Add modifiers for this field type. You may select more than one.'),
(256, 'Add More Items'),
(257, 'Add New'),
(258, 'Add new'),
(259, 'Add new category : '),
(260, 'Add new certificates to the Apache configuration file'),
(261, 'Add New Component'),
(262, 'Add New Components'),
(263, 'Add new database'),
(264, 'Add New Entry'),
(265, 'Add New Event'),
(266, 'Add New Form'),
(267, 'ADD NEW GROUP'),
(268, 'Add New Group'),
(269, 'Add New Issue'),
(270, 'Add new lot and transaction'),
(271, 'Add New Message'),
(272, 'Add New Note'),
(273, 'Add new note'),
(274, 'Add New Partner'),
(275, 'Add New Patient'),
(276, 'Add New Plan'),
(277, 'ADD NEW PLAN'),
(278, 'Add New...'),
(279, 'Add New{{Event}}'),
(280, 'Add New{{Message}}'),
(281, 'Add New{{Provider}}'),
(282, 'Add new{{Rule}}'),
(283, 'Add New{{Type}}'),
(284, 'Add Note'),
(285, 'Add Onsite Portal Activity'),
(286, 'Add Package'),
(287, 'Add Patient'),
(288, 'Add Patient Record'),
(289, 'Add Prescription'),
(290, 'Add Procedure'),
(291, 'Add Provider Number'),
(292, 'Add Recall'),
(293, 'Add Rehab'),
(294, 'Add Row'),
(295, 'Add Rule'),
(296, 'Add the remaining codes, in order to do so the CPT code must already exist in the database'),
(297, 'Add Time to Date'),
(298, 'Add to'),
(299, 'ADD TO EXISTING MESSAGE'),
(300, 'Add To Existing Message'),
(301, 'Add to History'),
(302, 'Add to list'),
(303, 'Add to Medication List'),
(304, 'Add Top Level'),
(305, 'Add Transaction'),
(306, 'Add User'),
(307, 'Add User To Group'),
(308, 'Add.{{Additional Measurements}}'),
(309, 'Add/Edit eRx'),
(310, 'Add/Edit Issue'),
(311, 'Add/Edit Patient Transaction'),
(312, 'added'),
(313, 'Adding'),
(314, 'Adding a participant'),
(315, 'Adding demographics is not authorized.'),
(316, 'Adding item to track failed'),
(317, 'Addison Syndrom'),
(318, 'Addison Syndrome'),
(319, 'Additional Attributes'),
(320, 'Additional Data Points'),
(321, 'Additional Date:'),
(322, 'Additional Diagnosis:'),
(323, 'Additional Findings'),
(324, 'Additional functionality including the ability to send SMS text messages, automated phone dialing, emails etc. can be accessed by enabling the optional MedEx Communication Service'),
(325, 'Additional help to fill out this form is available by hovering over labels of each box and clicking on the dark blue help ? icon that is revealed'),
(326, 'Additional help to fill out this form is available by hovering over labels of each box and clicking on the dark blue help ? icon that is revealed. On mobile devices tap once on the label to reveal the help icon and tap on the icon to show the help section'),
(327, 'Additional History'),
(328, 'Additional history notes'),
(329, 'Additional Info'),
(330, 'Additional information about the individual pages can be found in their respective help files'),
(331, 'Additional information may be available'),
(332, 'Additional information to process paper claims'),
(333, 'Additional Labs'),
(334, 'Additional Notes'),
(335, 'Additional Notes field is for local use in openEMR'),
(336, 'Additional notes for this result or recommendation'),
(337, 'Additional Notes:'),
(338, 'Additional Notes: '),
(339, 'additional scopes'),
(340, 'Additional X-RAY Notes:'),
(341, 'Additionally, the corresponding US Snomed Extension Package can be imported separately after installing the International (English version) Snomed Release'),
(342, 'Additionally, to the right is a toggle to select if you want to use the pop out window or dialog editor. The window allows having multiple editors open at the same time where the dialog is more appropriate for making quick edits'),
(343, 'Additonal Rx{{Additional glasses}}'),
(344, 'addonly'),
(345, 'addonly - can read and add but not modify'),
(346, 'Addr Bk'),
(347, 'Addr Book'),
(348, 'Address'),
(349, 'Address and Postal Code'),
(350, 'Address and State'),
(351, 'Address Book'),
(352, 'Address book entry for the company performing this procedure'),
(353, 'Address book entry for the distributor'),
(354, 'Address book entry for the vendor'),
(355, 'Address Book Types'),
(356, 'Address Label'),
(357, 'Address Labels'),
(358, 'Address Line 1'),
(359, 'Address Line 2'),
(360, 'Address Only'),
(361, 'Address, City, State and Postal Code'),
(362, 'Address, City, State, Postal Code, Payer ID'),
(363, 'Address, State and Postal Code'),
(364, 'Address1'),
(365, 'Address2'),
(366, 'ADDRESSED TO'),
(367, 'ADDRESSEE'),
(368, 'ADD{{Bifocal Add}}'),
(369, 'ADD{{Near Add}}'),
(370, 'Adj'),
(371, 'Adj Amount'),
(372, 'Adj Amt'),
(373, 'Adj Type'),
(374, 'Adjust'),
(375, 'Adjust Type'),
(376, 'Adjustment'),
(377, 'Adjustment Amt'),
(378, 'Adjustment Reasons'),
(379, 'Adjustment type is required for each line with an adjustment.'),
(380, 'Adjustment type is required for every line item.'),
(381, 'Adjustment value for code'),
(382, 'Adjustment value for code '),
(383, 'Adjustment, Consumption, Return, or Edit'),
(384, 'Adjustments'),
(385, 'Adjustments at Checkout'),
(386, 'Adm adjust'),
(387, 'Admin'),
(388, 'Admin Email Address'),
(389, 'Administer Via'),
(390, 'Administer Via is not relevant in this context and can be left Unassigned'),
(391, 'Administered'),
(392, 'Administered By'),
(393, 'Administered Date'),
(394, 'Administered Site'),
(395, 'Administration'),
(396, 'Administration (admin)'),
(397, 'Administration Site'),
(398, 'Administrator Assign'),
(399, 'Administrators'),
(400, 'Administrators can do anything'),
(401, 'Admit Date'),
(402, 'Adnexa'),
(403, 'Adopted Child'),
(404, 'Adult Weight Screening and Follow-Up'),
(405, 'Adult Weight Screening and Follow-Up (CQM)'),
(406, 'Advance Directive'),
(407, 'Advance Directives'),
(408, 'Advance Directives Warning'),
(409, 'Advance Options'),
(410, 'Advanced'),
(411, 'Advanced - Finer Access Control'),
(412, 'Advantages and Disadvantages of TOTP and U2F'),
(413, 'Advice'),
(414, 'Afar'),
(415, 'Affect normal'),
(416, 'Afrikaans'),
(417, 'after'),
(418, 'after (PM)'),
(419, 'After hrs calls'),
(420, 'After migration from the old password mechanisms where passwords are stored in the users table without salt is complete, this flag should be set to false so that only authentication by the new method is possible'),
(421, 'After performing above configurations, import the admin client certificate to the browser and restart Apache server (empty password).'),
(422, 'After saving the PDF'),
(423, 'After saving the PDF, click [View Log] to check for errors.'),
(424, 'After saving the PDF, click[View Log] to check for errors.'),
(425, 'After saving the TEXT file'),
(426, 'After saving the TEXT file(s), click [View Log] to check for errors.'),
(427, 'After saving the TEXT file(s), click[View Log] to check for errors.'),
(428, 'After saving your batch'),
(429, 'After saving your batch, click [View Log] to check for errors.'),
(430, 'After saving your batch, click[View Log] to check for errors.'),
(431, 'After that the Match column will show the selected patient ID, or 0 to create.'),
(432, 'After the information is correctly entered, click the Save button.'),
(433, 'After Uploading click the button \"Import\"'),
(434, 'After Uploading, click \"Import\"'),
(435, 'After you filled in the spreadsheet with the relevant ICD categories and ICD codes go to Administration > Lists. Select \'Service Category\' from the dropdown box'),
(436, 'After you have finished entering all the ICD 10 codes go to Adminstration > Lists and select \'Code Types\' from the dropdown box. Select \'ICD10 Diagnosis\' from the last dropdown box under ICD 10'),
(437, 'AfterCare Planning'),
(438, 'Afterwards however, you may change your portal credentials anytime from portal menu.'),
(439, 'Again'),
(440, 'Age'),
(441, 'Age at death'),
(442, 'Age By'),
(443, 'Age Category'),
(444, 'Age data is out of range.'),
(445, 'Age Display Format'),
(446, 'Age format for \"age from\" is not valid'),
(447, 'Age format for \"age up to\" is not valid'),
(448, 'Age From'),
(449, 'Age in Years for Display Format Change'),
(450, 'Age max'),
(451, 'Age min'),
(452, 'Age Range'),
(453, 'Aging Columns'),
(454, 'Aging Columns:'),
(455, 'Aging Days'),
(456, 'Akan'),
(457, 'Albanian'),
(458, 'Alcohol'),
(459, 'Alcohol consumption'),
(460, 'Alcohol Use'),
(461, 'Alert'),
(462, 'Alert Count'),
(463, 'Alert Notice'),
(464, 'Alert on and after birthday'),
(465, 'Alert on and up to 28 days after birthday'),
(466, 'Alert on patient birthday'),
(467, 'Alert only on birthday'),
(468, 'Alert Time'),
(469, 'Alerts'),
(470, 'Alerts Log'),
(471, 'Alerts/Reminders'),
(472, 'Alert{{Mental Status}}'),
(473, 'ALEUT'),
(474, 'All'),
(475, 'ALL'),
(476, 'all'),
(477, 'All (Collated Format A)'),
(478, 'All (Collated Format B)'),
(479, 'All (Cumulative)'),
(480, 'All Alerts'),
(481, 'All Automated Measure Calculations (AMC)'),
(482, 'All Categories'),
(483, 'All Clinical Quality Measures (CQM)'),
(484, 'All Codes'),
(485, 'All credential fields are case sensitive!'),
(486, 'All Dates'),
(487, 'All Day'),
(488, 'All day event'),
(489, 'All demographics fields, with search and duplication check'),
(490, 'All done.'),
(491, 'All Encounters'),
(492, 'All Facilities'),
(493, 'All Injuries/Problems/Issues'),
(494, 'All Labs'),
(495, 'All Languages Allowed'),
(496, 'All Messages'),
(497, 'All Official Clinical Quality Measures (CQM) Measure Groups'),
(498, 'All or part of the first name'),
(499, 'All or part of the last name'),
(500, 'All or part of the organization'),
(501, 'All patient interactions in OpenEMR are linked to encounters'),
(502, 'All Patients'),
(503, 'All pending messages are displayed on the MY MESSAGES pane'),
(504, 'All Product Types'),
(505, 'All Products'),
(506, 'All Providers'),
(507, 'All Reviewed and Negative:'),
(508, 'All scores have been cleared.'),
(509, 'All search inputs are case sensitive and must match entries in your profile.'),
(510, 'All sections are not required, rather, they are available based on the information a practitioner believes is critical data for the patient at any given moment in time'),
(511, 'All set. Click Send Request below to finish registration'),
(512, 'All set. Click Send Request below to finish registration.'),
(513, 'All Topics'),
(514, 'All TOTP authenticator apps use the same algorithm and secure hash function - HMAC-SHA1 to generate the unique key'),
(515, 'All Transactions for the patient will appear on the Transactions page in descending order of its date of creation'),
(516, 'All Users'),
(517, 'All Warehouses'),
(518, 'Allergic'),
(519, 'Allergic to'),
(520, 'Allergies'),
(521, 'Allergies - will show the allergies listed under Issues > Allergies. If eRx is enabled the allergy list has to be entered on the eRx page'),
(522, 'Allergies/Alerting Data'),
(523, 'Allergies:'),
(524, 'Allergy'),
(525, 'Allergy import successfully completed'),
(526, 'Allergy Issue List'),
(527, 'Allergy Reaction'),
(528, 'ALLERGY WARNING'),
(529, 'Allergy Warning'),
(530, 'Allocate'),
(531, 'Allow'),
(532, 'Allow Administrators to Delete Patients'),
(533, 'Allow all available languages as choices on menu at login.'),
(534, 'Allow Check In before the appointment\'s time.'),
(535, 'Allow creation of claims containing diagnoses but not procedures or charges. Most clinics do not want this.'),
(536, 'Allow Debugging Language'),
(537, 'Allow Double Click to select Nation Note text template from any encounter form text area'),
(538, 'Allow Early Check In'),
(539, 'Allow Email'),
(540, 'Allow email messages?'),
(541, 'Allow Email?'),
(542, 'Allow Encounter Claims'),
(543, 'Allow Encounter For Each Appointment'),
(544, 'Allow Health Info Exchange'),
(545, 'Allow Health Information Exchange'),
(546, 'Allow Immunization Info Share'),
(547, 'Allow Immunization Info Sharing'),
(548, 'Allow Immunization Registry Use'),
(549, 'Allow in person credit card payments using Stripe Verifone P400. Ensure Stripe gateway is enabled.'),
(550, 'Allow institutional claims support.'),
(551, 'Allow insurance eligibility checks using Office Ally'),
(552, 'Allow Mail Message'),
(553, 'Allow manual entry and authorise credit card payments. Ensure a gateway is enabled.'),
(554, 'Allow more than one insurance'),
(555, 'Allow More than one MA/IPPF code mapping'),
(556, 'Allow multiple databases'),
(557, 'Allow New Patient Registration Widget'),
(558, 'Allow Notice'),
(559, 'Allow Online Appointments'),
(560, 'Allow Online Payments'),
(561, 'Allow Online Secure Chat'),
(562, 'Allow only one insurance'),
(563, 'Allow Onsite New Patient Registration Widget'),
(564, 'Allow Onsite Online Appointments'),
(565, 'Allow Onsite Online Payments'),
(566, 'Allow Onsite Online Secure Chat'),
(567, 'Allow Onsite Patient Ledger'),
(568, 'Allow Onsite Patient to make and view appointments online.'),
(569, 'Allow Onsite Patient to make payments online.'),
(570, 'Allow Onsite Patient to use Secure Chat Application.'),
(571, 'Allow Onsite Patient to view their accounting ledger online.'),
(572, 'Allow Onsite Patients to Reset Credentials'),
(573, 'Allow Patient Flow Board to Select Patients for Drug Testing.'),
(574, 'Allow Patient Ledger'),
(575, 'Allow Patient Portal'),
(576, 'Allow Patient to make and view appointments online.'),
(577, 'Allow Patient to make payments online.'),
(578, 'Allow Patient to use Secure Chat Application.'),
(579, 'Allow Patient to view their accounting ledger online.'),
(580, 'Allow Patients to Reset Credentials'),
(581, 'Allow Postal Mail'),
(582, 'Allow self-signed certificate for SSL (encrypted) connection to CouchDB'),
(583, 'Allow SMS'),
(584, 'Allow SMS (text messages)?'),
(585, 'Allow Statement Exclusions from Printing'),
(586, 'Allow submitted events to be made active instantly?'),
(587, 'Allow telephone messages?'),
(588, 'Allow to use with multiple database'),
(589, 'Allow users to publish Global Events'),
(590, 'Allow users to publish Personal Calendars'),
(591, 'Allow Version 2 Onsite New Patient Registration Widget'),
(592, 'Allow Version 2 Onsite Online Payments'),
(593, 'Allow Version 2 Onsite Patient to make payments online.'),
(594, 'Allow Version 2 Patients to Reset Credentials'),
(595, 'Allow Voice Call'),
(596, 'Allow Voice Message'),
(597, 'Allowed'),
(598, 'Allowed Languages'),
(599, 'Allowed to discount prices (in Fee Sheet or Checkout form) (disc)'),
(600, 'Allowed(c)'),
(601, 'Allows E-Sign on the entire encounter'),
(602, 'Allows E-Signing Individual Forms'),
(603, 'Allows Mail'),
(604, 'Allows Voice msgs'),
(605, 'All{{Mails}}'),
(606, 'All{{Recipients}}'),
(607, 'Already a Care Plan form for this encounter. Using existing Care Plan form.'),
(608, 'Already a Clinical Notes form for this encounter. Using existing Clinical Notes form.'),
(609, 'Already at the top of the page'),
(610, 'already exists'),
(611, 'already exists! Please try again.'),
(612, 'already exists.'),
(613, 'Already registered'),
(614, 'Already used, choose another identifier'),
(615, 'Already used, choose another title'),
(616, 'Also provides a short description of the visit in Patient Reports'),
(617, 'Alt Address'),
(618, 'Alt City'),
(619, 'Alt Postal code'),
(620, 'Alt State'),
(621, 'alter'),
(622, 'Alternate Cover Test'),
(623, 'Alternatively a CPT code can be used. It is 84550 for Serum Uric Acid'),
(624, 'Alternatively download a sample spreadsheet by clicking on the Download button'),
(625, 'Alternatively it can be accessed by clicking in the Messages menu item in the top navigation bar'),
(626, 'Alternatively you could clear all selections and select only the items that you want to be a part of the report'),
(627, 'Alternatively, you may choose to upload an electronic remittance (X12 835) file that you have obtained from your payer or clearinghouse. You can do this by first selecting the \'ERA upload\' option in the initial \'Select Method\' section. This brings up the \'ERA Upload\' Section.'),
(628, 'Alternatively, you may use the search page to upload an electronic remittance (X12 835) file that you have obtained from your payer or clearinghouse.  You can do this by clicking the Browse button and selecting the file to upload, and then clicking Search to perform the upload and display the corresponding invoices.  In this case the other parameters mentioned above do not apply and will be ignored.  Uploading saves the file but does not yet process its contents -- that is done separately as described below.'),
(629, 'Although the HCFA-1500 originally was developed for submitting Medicare claims, it eventually was accepted by all commercial/ private insurance carriers to facilitate the standardization of the claims process'),
(630, 'Always'),
(631, 'AM'),
(632, 'AM Program'),
(633, 'Amblyopia'),
(634, 'Ambulance - Air or Water'),
(635, 'Ambulance - Land'),
(636, 'Ambulatory Surgical Center'),
(637, 'AMC'),
(638, 'AMC Tracking'),
(639, 'AMC-2011'),
(640, 'AMC-2014'),
(641, 'AMC-2014 Stage I'),
(642, 'AMC-2014 Stage II'),
(643, 'AMD{{age related macular degeneration}}'),
(644, 'Amend Existing Message'),
(645, 'Amend Existing Note'),
(646, 'Amendment'),
(647, 'Amendment From'),
(648, 'Amendment List'),
(649, 'Amendment Status'),
(650, 'Amendments'),
(651, 'Amendments (write,addonly optional)'),
(652, 'Amendments (write,addonly optional) (amendment)'),
(653, 'Amendments - Enable a user to electronically select the record affected by a patient’s request for amendment and either append the amendment to the affected record or include a link that indicates the amendment’s location'),
(654, 'Amendments for'),
(655, 'American Indian'),
(656, 'American Indian or Alaska Native'),
(657, 'AMEX'),
(658, 'Amharic'),
(659, 'Amount'),
(660, 'Amount Administered'),
(661, 'Amount Charged'),
(662, 'Amount Charges'),
(663, 'Amount Charges:'),
(664, 'Amount Due'),
(665, 'Amount for Past Balance'),
(666, 'Amount for This Visit'),
(667, 'Amount Paid'),
(668, 'Amount:'),
(669, 'Amplitudes'),
(670, 'Amsler'),
(671, 'Amt Billed'),
(672, 'An appointment can be scheduled by clicking on the calendar icon in that cell'),
(673, 'An e-mail with your new account credentials will be sent to the e-mail address supplied earlier. You may still review or edit any part of your information by using the top step buttons to go to the appropriate panels. If after receiving credentials and you have trouble with access to the portal, please contact administration.'),
(674, 'An e-mail with your new account credentials will be sent to the e-mail address supplied earlier. You may still review or edit any part of your information by using the top step buttons to go to the appropriate panels. Note to be sure you have given your correct e-mail address. If after receiving credentials and you have trouble with access to the portal, please contact administration.'),
(675, 'An electronic order and the returned result is in the form of a message called the HL7 message. HL7 stands for Health Level (Application Layer) 7. HL7’s prime objective is to simplify the implementation of interfaces between healthcare software applications and various vendors so as to reduce the pain and cost involved in custom interface programming'),
(676, 'An end date later than the start date is required for repeated events!'),
(677, 'An error occured signing the form'),
(678, 'An error occurred while dumping OpenEMR web directory tree'),
(679, 'An error occurred while dumping phpGACL web directory tree'),
(680, 'An error occurred while dumping SQL-Ledger web directory tree'),
(681, 'An error occurred: Missing file to upload. Returning to form.'),
(682, 'An error occurred: Missing file to upload: Use back button!'),
(683, 'An important concept to grasp is that once the secret key delivered via the QR code is captured by the authenticator app there is no further communication between the app and OpenEMR, each will use the current UNIX time and its copy of the user-specific shared secret key to generate the same unique 6 digit number'),
(684, 'An important point to remember is that the various individuals tests in each panel are listed as Results, the fruit, you cannot directly order these individual tests'),
(685, 'An incomplete GCAC issue has been created and linked. Someone will need to complete it later.'),
(686, 'An internal server error occurred'),
(687, 'An Issue concerns matters relating to the patient\'s health'),
(688, 'An issue is a medical problem, allergy, medication, surgery or dental issue'),
(689, 'An onset/hospitalization date may be specified for each visit.'),
(690, 'An order has now been successfully created, however a place to receive and document the returned result does not exist as yet and needs to be created'),
(691, 'An Outcome for the problem - Resolved, Improved, Status Quo, Worse, Pending Followup or leave as Unassigned'),
(692, 'An undefined error occurred, please contact your systems administrator.'),
(693, 'An unexpected error has occurred.'),
(694, 'An unknown system error occurred during the export for resource'),
(695, 'An Updated Appointment'),
(696, 'An uppercase letter'),
(697, 'Analyzed'),
(698, 'and'),
(699, 'And'),
(700, 'AND'),
(701, 'and '),
(702, 'and all subordinate data? This action will be logged'),
(703, 'and modifier'),
(704, 'and processed.'),
(705, 'and resetting claim status.'),
(706, 'and restart Apache server.'),
(707, 'and the Reason is'),
(708, 'android'),
(709, 'Anemia'),
(710, 'Ankle'),
(711, 'Ankle + heel'),
(712, 'Ankle Evaluation Form'),
(713, 'Ankle Problems'),
(714, 'Ankylosing Sondlilitis'),
(715, 'Ankylosing Spondlilitis'),
(716, 'Anorexia'),
(717, 'Another thing you can do in the posting window is request secondary billing. If you select this checkbox before saving, then the original claim will be re-opened and queued on the Billing page, and will be processed during the next billing run.'),
(718, 'Another way to select an ICD code to justify the CPT4 code is to click on the label CPT4 at the beginning of the row'),
(719, 'Answering Service'),
(720, 'Ant'),
(721, 'ante'),
(722, 'Anterior Chamber Depth'),
(723, 'Anterior Segment'),
(724, 'Anterior Segment Default Values'),
(725, 'ant{{anterior}}'),
(726, 'Anus nl, no rectal tenderness/mass'),
(727, 'Anxiety'),
(728, 'any'),
(729, 'Any'),
(730, 'Any additional information pertaining to this provider'),
(731, 'Any carotid bruits appreciated?'),
(732, 'Any Category'),
(733, 'Any changes here will be reviewed by provider staff before commiting to chart. The following apply'),
(734, 'Any changes here will be reviewed by provider staff before committing to your chart. The following apply'),
(735, 'Any changes that you need to make to this particular line item should be made here and saved'),
(736, 'any date'),
(737, 'Any Demographic Search'),
(738, 'Any part of the desired code or its description'),
(739, 'Any part of the desired NPI'),
(740, 'Any part of the desired specialty'),
(741, 'Any part of the drug id or drug name'),
(742, 'Any part of the immunization id or immunization name'),
(743, 'Any part of the patient name, or \"last,first\", or \"X-Y\"'),
(744, 'Anyother Relevant Information'),
(745, 'Anything else occur at the same time?'),
(746, 'Any{{Gender}}'),
(747, 'AOE Q&A'),
(748, 'APD{{afferent pupillary defect}}'),
(749, 'API'),
(750, 'API key for SMS Gateway.'),
(751, 'API Log Option'),
(752, 'API Log Option (Full includes requests and responses).'),
(753, 'API logging'),
(754, 'Apnea'),
(755, 'App'),
(756, 'App Launch URI'),
(757, 'App Logout URI'),
(758, 'App Name'),
(759, 'App Redirect URI'),
(760, 'App Registration Form'),
(761, 'Appearance'),
(762, 'Appearance:'),
(763, 'Append'),
(764, 'Append this message'),
(765, 'Append this note'),
(766, 'Append to the existing message'),
(767, 'Append to the existing note'),
(768, 'Append to this note'),
(769, 'Append to This Note'),
(770, 'Appendectomy'),
(771, 'appendectomy'),
(772, 'Applicable only for family planning clinics'),
(773, 'Applicable Patients'),
(774, 'Application'),
(775, 'Application name for login page and main window title.'),
(776, 'Application name used throughout the user interface.'),
(777, 'Application Receiver Code (GS03 - If blank ISA08 will be used)'),
(778, 'Application Sender Code (GS02)'),
(779, 'Application Title'),
(780, 'Applies to the Vitals form and Growth Chart'),
(781, 'Applies to this visit only'),
(782, 'Applies to Vitals form'),
(783, 'Apply the changes to the Current event only, to this and all Future occurrences, or to All occurrences?'),
(784, 'apply to affected area'),
(785, 'apply to skin'),
(786, 'Applying'),
(787, 'Applying Patch to site'),
(788, 'Appointment'),
(789, 'Appointment Category'),
(790, 'Appointment Date'),
(791, 'Appointment Display Sets - Color 1'),
(792, 'Appointment Display Sets - Color 2'),
(793, 'Appointment Display Sets - Color 3'),
(794, 'Appointment Display Sets - Color 4'),
(795, 'Appointment Display Sets - Ignore Display Limit (Last Set)'),
(796, 'Appointment Display Style'),
(797, 'Appointment made by'),
(798, 'Appointment Reminder Rule'),
(799, 'Appointment Reminders'),
(800, 'Appointment status'),
(801, 'Appointment Statuses'),
(802, 'Appointment within'),
(803, 'Appointment/Event Color'),
(804, 'Appointments'),
(805, 'Appointments (write optional)'),
(806, 'Appointments (write,wsome optional)'),
(807, 'Appointments (write,wsome optional) (appt)'),
(808, 'Appointments - Group Summary - Number to Display'),
(809, 'Appointments - Onsite Patient Portal - Number to Display'),
(810, 'Appointments - Patient Summary - Number to Display'),
(811, 'Appointments - shows all future appointments as well as Recalls'),
(812, 'Appointments and Encounters'),
(813, 'Appointments for'),
(814, 'Appointments Report'),
(815, 'Appointments-Encounters Report'),
(816, 'Appropriate Results'),
(817, 'Appropriate Testing for Children with Pharyngitis (CQM)'),
(818, 'Approve'),
(819, 'Approve Order'),
(820, 'Approve the patient from Patient/Client->Import->Pending Approval'),
(821, 'Approved'),
(822, 'Approved Events Administration'),
(823, 'Approved Successfully'),
(824, 'Apps'),
(825, 'Appt Date'),
(826, 'Appt Status'),
(827, 'Appt Time'),
(828, 'Appt-Enc'),
(829, 'Appt. Reminders'),
(830, 'Appts'),
(831, 'Appt{{Abbreviation for appointment}}'),
(832, 'App{{Applanation abbreviation}}'),
(833, 'Apr'),
(834, 'April'),
(835, 'AP{{applanation}}'),
(836, 'Arabic'),
(837, 'Aragonese'),
(838, 'Archive'),
(839, 'Archive Log Files'),
(840, 'Archive old files'),
(841, 'Are access control group names to be translated?'),
(842, 'Are appointment category names to be translated?'),
(843, 'Are document category names to be translated?'),
(844, 'Are fees charged for this type?'),
(845, 'are off'),
(846, 'are on'),
(847, 'Are patient note titles to be translated?'),
(848, 'Are the codes stored in external sql tables (0-No, 1-ICD10, 2-SNOMED(RF1), 3-SNOMED(RF2)) ?'),
(849, 'are unanswered'),
(850, 'Are you prepared to complete a new GCAC issue for this visit?'),
(851, 'Are you sure to clear chat history?'),
(852, 'Are you sure to post for today?'),
(853, 'Are you sure you want to approve these events?'),
(854, 'Are you sure you want to cancel your changes?'),
(855, 'Are you sure you want to clear chats session history?'),
(856, 'Are you sure you want to completely remove this form?'),
(857, 'Are you sure you want to continue?'),
(858, 'Are you sure you want to delete'),
(859, 'Are you sure you want to delete this disclosure?'),
(860, 'Are you sure you want to delete this event?'),
(861, 'Are you sure you want to delete this item from the database?'),
(862, 'Are you sure you want to delete this message?'),
(863, 'Are You Sure you want to delete this name?'),
(864, 'Are you sure you want to delete this note?'),
(865, 'Are you sure you want to delete this plan?'),
(866, 'Are you sure you want to edit these events?'),
(867, 'Are you sure you want to hide these events?'),
(868, 'Are you sure you want to remove namespace'),
(869, 'Are you sure you want to transmit it again?'),
(870, 'Are you sure you want to view these events?'),
(871, 'Are you sure you wish to delete the entire group named'),
(872, 'Are you sure you wish to delete the entire list'),
(873, 'Are you sure you wish to delete the field in'),
(874, 'Are you sure you wish to delete the selected fields?'),
(875, 'Are you sure you wish to delete this entire group?'),
(876, 'Are you sure you\'d like to quit without saving your answers?'),
(877, 'Are you sure you\'d like to continue with these actions?'),
(878, 'Are you sure?'),
(879, 'Area not specified'),
(880, 'Arm'),
(881, 'Armenian'),
(882, 'ARNear{{Auto-refraction near acuity}}'),
(883, 'ARNear{{autorefraction near}}'),
(884, 'Arrival'),
(885, 'Arrive Time'),
(886, 'Arrived'),
(887, 'Arrived late'),
(888, 'Arrythmia'),
(889, 'Arthritis'),
(890, 'Arthritis / degen joint diseas'),
(891, 'Arthritis / degen joint disease'),
(892, 'Article'),
(893, 'AR{{Autorefraction Acuity}}'),
(894, 'AR{{autorefraction}}'),
(895, 'as'),
(896, 'As appears on documents'),
(897, 'as billed'),
(898, 'As Button'),
(899, 'As Large Text Link'),
(900, 'As Of'),
(901, 'As Text Link'),
(902, 'As the first step choose Group or Custom Favorite Group, as the case may be, as the Top Level Tier 1 and fill in the required details'),
(903, 'As the secret key need by the authenticator is stored on the mobile phone malware can steal these keys and thus compromise authentication'),
(904, 'As this is an infrequently performed process additional help in provided by clicking on the help icon that is revealed when you hover over the label for each box'),
(905, 'As we are creating a Custom Group for manual entry of returned results we need to create a place to enter these results'),
(906, 'As will appear on documents.'),
(907, 'ASC'),
(908, 'Asian'),
(909, 'Asked but no answer'),
(910, 'Assamese'),
(911, 'Assess Penicillin Allergy'),
(912, 'Assessment'),
(913, 'Assign'),
(914, 'Assign it to this one?'),
(915, 'Assign Severity and Save'),
(916, 'Assign the dosage values etc. and click Save'),
(917, 'Assign the message to the correct patient by clicking Patient: Click to select, assign a Type and forward the message on to the correct clinician or staff member'),
(918, 'Assigned Groups'),
(919, 'Assigned Templates'),
(920, 'Assigned To'),
(921, 'Assistant'),
(922, 'Assisted Living Facility'),
(923, 'Associate'),
(924, 'Associated'),
(925, 'Associated Notes.'),
(926, 'Assume patients permit Messaging'),
(927, 'Assume patients receive HIPAA policy'),
(928, 'Asthma'),
(929, 'at'),
(930, 'At least one diagnosis is required! Please add a diagnosis for this order.'),
(931, 'At least one search parameter is required if you select All.'),
(932, 'At present e-prescribing from openEMR is possible only in the United States'),
(933, 'At present only Continuity of Care Record (CCR) Continuity of Care Document (CCD) can be sent using phiMail'),
(934, 'At the Navicular'),
(935, 'At the Navicular:'),
(936, 'Athletic team'),
(937, 'Athletic Team'),
(938, 'Athletic/Injury'),
(939, 'ATNA audit CA certificate'),
(940, 'ATNA audit host'),
(941, 'ATNA audit local certificate'),
(942, 'ATNA audit port'),
(943, 'Atropine 1%'),
(944, 'Attending physician'),
(945, 'Attention'),
(946, 'Attention: Pending Documents'),
(947, 'Attn'),
(948, 'Attributes'),
(949, 'Aud URI (use this in the \"aud\" claim of your JWT)'),
(950, 'Audiological physician'),
(951, 'Audit all Emergency User Queries'),
(952, 'Audit CDR Engine Queries'),
(953, 'Audit Changes'),
(954, 'Audit Log Tamper'),
(955, 'Audit Log Tamper Report'),
(956, 'Audit log tampering evident at entry number'),
(957, 'Audit Log Validated Successfully'),
(958, 'Audit Log Validation Failed'),
(959, 'Audit Logging Backups'),
(960, 'Audit Logging Miscellaneous'),
(961, 'Audit Logging Order'),
(962, 'Audit Logging Patient Record'),
(963, 'Audit Logging Scheduling'),
(964, 'Audit Logging Security Administration'),
(965, 'Audit Logging SELECT Query'),
(966, 'Audit Payment'),
(967, 'Audits'),
(968, 'Aug'),
(969, 'August'),
(970, 'Aunt'),
(971, 'Auth'),
(972, 'Auth/notes'),
(973, 'Authenticate TOTP'),
(974, 'Authenticate U2F'),
(975, 'Authenticated API Users'),
(976, 'Authenticating'),
(977, 'Authenticating the user thus becomes an important factor in this endeavor'),
(978, 'Authentication Argon Hash Memory Cost'),
(979, 'Authentication argon hash memory cost. Suggest PHP Default unless you know what you are doing.'),
(980, 'Authentication Argon Hash Thread Number'),
(981, 'Authentication argon hash thread number. Suggest PHP Default unless you know what you are doing.'),
(982, 'Authentication Argon Hash Time Cost'),
(983, 'Authentication argon hash time cost. Suggest PHP Default unless you know what you are doing.'),
(984, 'Authentication Bcrypt Hash Cost'),
(985, 'Authentication bcrypt hash cost. Suggest PHP Default unless you know what you are doing.'),
(986, 'Authentication Error'),
(987, 'Authentication SHA512 Hash Rounds Number'),
(988, 'Authentication SHA512 hash rounds number.'),
(989, 'Authenticator'),
(990, 'Authenticator apps are available for both ios and android devices at their respective app stores and is free to use'),
(991, 'Author'),
(992, 'Authorization'),
(993, 'Authorization group'),
(994, 'Authorization Status'),
(995, 'Authorizations'),
(996, 'Authorize'),
(997, 'Authorize - any encounters'),
(998, 'Authorize - any encounters (auth_a)'),
(999, 'Authorize - my encounters'),
(1000, 'Authorize - my encounters (auth)'),
(1001, 'Authorize as my Electronic Signature.'),
(1002, 'Authorize or not as needed'),
(1003, 'Authorize.net'),
(1004, 'Authorize.Net'),
(1005, 'Authorized'),
(1006, 'Authorized Id'),
(1007, 'Authorized Only'),
(1008, 'Authorized Users'),
(1009, 'Authorizing'),
(1010, 'Authy'),
(1011, 'Auto Refraction'),
(1012, 'Auto Send'),
(1013, 'Auto Sign-Off [days]'),
(1014, 'Auto Transfer'),
(1015, 'Auto-Create New Encounters'),
(1016, 'Auto-generated'),
(1017, 'Auto-Refraction'),
(1018, 'Automated Measure Calculations (AMC)'),
(1019, 'Automated Measure Calculations (AMC) - 2011'),
(1020, 'Automated Measure Calculations (AMC) - 2014'),
(1021, 'Automated Measure Calculations (AMC) - 2014 Stage I'),
(1022, 'Automated Measure Calculations (AMC) - 2014 Stage II'),
(1023, 'Automated Measure Calculations (AMC) Tracking'),
(1024, 'Automated Measures (AMC)'),
(1025, 'Automated Voice Message permission'),
(1026, 'Automatic'),
(1027, 'Automatic from sale'),
(1028, 'Automatically applies correct extension on successful upload'),
(1029, 'Automatically create a new encounter when an appointment check in status is selected.'),
(1030, 'Automatically create a new encounter when appointment status is set to \"@\" (arrived).'),
(1031, 'Automatically Create Prescriptions'),
(1032, 'Automatically replicate justification codes in Fee Sheet'),
(1033, 'Automatically replicate justification codes in Fee Sheet (basically fills in the blanks with the justification code above it).'),
(1034, 'Automatically SFTP Claims To X12 Partner'),
(1035, 'Automobile Medical'),
(1036, 'AutoRef'),
(1037, 'autosaved'),
(1038, 'Auto{{autorefraction}}'),
(1039, 'Available Appointments Calendar'),
(1040, 'Available categories'),
(1041, 'Available Document'),
(1042, 'Available Recipients'),
(1043, 'Available Services'),
(1044, 'Available Templates'),
(1045, 'Available Times'),
(1046, 'Available Tracks'),
(1047, 'Avaric'),
(1048, 'Avery Label type for printing patient labels from popups in left nav screen'),
(1049, 'Avestan'),
(1050, 'Avg Monthly'),
(1051, 'AVM'),
(1052, 'AVM Confirmed'),
(1053, 'AVM OK'),
(1054, 'Avulsion / avulsion fracture'),
(1055, 'Avulsion lateral malleolus'),
(1056, 'Avulsion medial malleolus '),
(1057, 'Awareness-Based'),
(1058, 'Axial Length'),
(1059, 'Axillary'),
(1060, 'Axis{{Axis in a glasses prescription}}'),
(1061, 'Axis{{Axis of a glasses prescription}}'),
(1062, 'AXIS{{Axis of a glasses prescription}}'),
(1063, 'AxLength{{axial Length}}'),
(1064, 'Aymara'),
(1065, 'Azerbaijani'),
(1066, 'b.i.d.'),
(1067, 'Back'),
(1068, 'back'),
(1069, 'Back eight visits'),
(1070, 'Back eleven visits'),
(1071, 'Back five visits'),
(1072, 'Back four visits'),
(1073, 'Back nine visits'),
(1074, 'Back one visit'),
(1075, 'Back Pain'),
(1076, 'Back Problems'),
(1077, 'Back seven visits'),
(1078, 'Back six visits'),
(1079, 'Back Surgery'),
(1080, 'Back ten visits'),
(1081, 'Back three visits'),
(1082, 'Back to Admin Page'),
(1083, 'Back to Client List'),
(1084, 'Back To Editor'),
(1085, 'Back to encounter'),
(1086, 'Back to Patient'),
(1087, 'Back To Patient'),
(1088, 'Back to patient dashboard'),
(1089, 'Back to Users'),
(1090, 'Back To View'),
(1091, 'Back twelve visits'),
(1092, 'Back two visits'),
(1093, 'Background Services'),
(1094, 'Backup'),
(1095, 'Backup Failed missing generated file'),
(1096, 'Backup file has been created. Will now send download.'),
(1097, 'Backup List'),
(1098, 'Backup Successfully taken in'),
(1099, 'Backup/Delete Log Data'),
(1100, 'Bad check'),
(1101, 'Bad debt'),
(1102, 'Bahasa Indonesia'),
(1103, 'Bal'),
(1104, 'Bal Due'),
(1105, 'Bal-Due'),
(1106, 'Balance'),
(1107, 'balance'),
(1108, 'Balance Amt'),
(1109, 'Balance Due'),
(1110, 'Balance Payment'),
(1111, 'Balanced'),
(1112, 'Bambara'),
(1113, 'Bank Draft'),
(1114, 'Barcode Label'),
(1115, 'Barcode Label Type'),
(1116, 'Barcode type for printing barcode labels from popups in left nav screen.'),
(1117, 'Base of fifth (5th) Metarsal'),
(1118, 'Base of fifth (5th) Metarsal:'),
(1119, 'Base URL for FHIR Server.'),
(1120, 'Base URL for FHIR Server. Url should end with /'),
(1121, 'Based on the individual practice\'s need the tests can be organized into various groups'),
(1122, 'Bashkir'),
(1123, 'Basic patient information is included, such as patient and provider information, insurance, patient health status, recent care provided, care plan information, and reason for referral or transfer'),
(1124, 'Basic Units'),
(1125, 'Basque'),
(1126, 'Batch Claim'),
(1127, 'Batch Communication Tool'),
(1128, 'Batch Communication Tool (batchcom)'),
(1129, 'Batch Payment Entry'),
(1130, 'Batch Payments'),
(1131, 'Batch processing initiated; this may take a while.'),
(1132, 'Batch Results'),
(1133, 'BatchCom'),
(1134, 'BAT{{Brightness Acuity Testing}}'),
(1135, 'BC{{Base Curve}}'),
(1136, 'Be careful with this feature. Back up your database and documents before using it!'),
(1137, 'Be patient, some files can take several minutes to process!'),
(1138, 'Be patient, this can take a while.'),
(1139, 'Be sure to branch it off the Well Woman Tests line (Tier 1), if properly branched both TSH and vitamin D should have a Tier value of 2'),
(1140, 'because that id does not exist.'),
(1141, 'Becoming easily annoyed or irritable'),
(1142, 'before'),
(1143, 'before (PM)'),
(1144, 'Before beginning to use the Fee Sheet read through this help page and do some preliminary setup.'),
(1145, 'Before proceeding to configuring the tests themselves you would need to review the values included in the standard release and make changes according to need'),
(1146, 'Before we proceed to create a Custom Group of Tests and save it as a Favorite a quick recap of the principles involved'),
(1147, 'Before you begin customization please ensure that all the ICD and CPT codes you will be needing have been entered into the database'),
(1148, 'Before you start entering data check the spreadsheet once again and make adjustments as needed'),
(1149, 'Before you try out electronic ordering you need to understand the issues involved'),
(1150, 'Begin'),
(1151, 'Begin and End date if information is available'),
(1152, 'Begin Date'),
(1153, 'Begin date if known'),
(1154, 'Beginning Account Balance'),
(1155, 'Beginning Date for Ledger Report'),
(1156, 'Beginning date of service yyyy-mm-dd'),
(1157, 'Beginning hour of day for calendar events.'),
(1158, 'Beginning of Current Work Week'),
(1159, 'Being a software application it can be compromised by malware that steals the secret key or by social engineering'),
(1160, 'Being irritable'),
(1161, 'Being restless'),
(1162, 'Being so restless that it\'s hard to sit still'),
(1163, 'Belarusian'),
(1164, 'Belching'),
(1165, 'Below link is only valid for one hour.'),
(1166, 'Below lower panic limits'),
(1167, 'Below this is a table that contains the existing transactions, if any, pertaining to the current patient'),
(1168, 'Benefit Type'),
(1169, 'Bengali'),
(1170, 'Bengali- Bangla'),
(1171, 'Best of Luck.'),
(1172, 'Best practice is to select Location(s) then a Category for the location then click the appropriate action button.'),
(1173, 'between'),
(1174, 'bg{{image canvas label}}'),
(1175, 'Bibliographic Citation'),
(1176, 'Bidirectional'),
(1177, 'Bifocal'),
(1178, 'Bifocals'),
(1179, 'Bihari'),
(1180, 'Bilateral'),
(1181, 'Bilateral:'),
(1182, 'Bill'),
(1183, 'Bill Date'),
(1184, 'Bill Date:'),
(1185, 'Bill Type'),
(1186, 'Bill/Collect'),
(1187, 'Billed'),
(1188, 'Billed Date'),
(1189, 'Billing'),
(1190, 'Billing (write optional)'),
(1191, 'Billing (write optional) (bill)'),
(1192, 'Billing - provides a summary of the balances - Patient Balance Due, Insurance Balance Due, Total Balance Due and lists the name of the Primary Insurance along with its effective date'),
(1193, 'Billing Address'),
(1194, 'Billing Attn'),
(1195, 'Billing Code Descriptions'),
(1196, 'Billing Code for Requested Service'),
(1197, 'Billing codes'),
(1198, 'Billing Data'),
(1199, 'Billing Department'),
(1200, 'Billing Facility'),
(1201, 'Billing Facility lets you choose the facility used for billing. To create and edit the billing facility go to Administration  > Facilities'),
(1202, 'Billing Information'),
(1203, 'Billing Location'),
(1204, 'Billing Log'),
(1205, 'Billing Log Append'),
(1206, 'Billing log is empty'),
(1207, 'Billing Log Option'),
(1208, 'Billing Log Overwrite'),
(1209, 'Billing log setting to append or overwrite the log file.'),
(1210, 'Billing Manager'),
(1211, 'Billing Note'),
(1212, 'Billing Note for '),
(1213, 'Billing Note:'),
(1214, 'Billing queue results'),
(1215, 'Billing queue results:'),
(1216, 'Billing Report'),
(1217, 'Billing Status'),
(1218, 'Billing Status = Unbilled'),
(1219, 'billing to '),
(1220, 'Billing View'),
(1221, 'Binocular Pupillary Diameter - Distance'),
(1222, 'Binocular Pupillary Diameter - Near'),
(1223, 'Biopsy'),
(1224, 'Birth Certificate'),
(1225, 'Birth Date'),
(1226, 'Birth-24 months'),
(1227, 'Birthing Center'),
(1228, 'Bislama'),
(1229, 'Black'),
(1230, 'Black lines show previously existing information.'),
(1231, 'Black list'),
(1232, 'Black Lung'),
(1233, 'Black or African American'),
(1234, 'Bladder Cancer'),
(1235, 'Bladder Infections'),
(1236, 'Blank'),
(1237, 'Blank Forms'),
(1238, 'Bleeding Problems'),
(1239, 'Blind Spots'),
(1240, 'Blindness'),
(1241, 'Bloating'),
(1242, 'Block all files types that are not found in the White List. Can find interface to edit the White List at Administration->Files.'),
(1243, 'Blocked'),
(1244, 'Blood'),
(1245, 'Blood Pressure'),
(1246, 'Blood pressure'),
(1247, 'Bloody Nose'),
(1248, 'Blue Cross Blue Shield'),
(1249, 'Blue lines in this report are informational.'),
(1250, 'Blue lines in this report are informational. Black lines show previously existing information.  Green lines show changes that were successfully applied.  Red lines indicate errors, or changes that were not applied; these must be processed manually.  Currently denied claims and payment reversals are not handled automatically and so will appear in red.'),
(1251, 'Blurred Vision'),
(1252, 'BMI'),
(1253, 'BMI Status'),
(1254, 'Body'),
(1255, 'Body Region'),
(1256, 'Body Site'),
(1257, 'Body site, if applicable'),
(1258, 'Bone Tenderness:'),
(1259, 'Bone Tenderness: Medial Malleolus'),
(1260, 'Boolean'),
(1261, 'Bosnian'),
(1262, 'Bot'),
(1263, 'Both'),
(1264, 'Both Ears'),
(1265, 'both ears'),
(1266, 'Both Name and Category will be highlighted yellow to provide an additional visual clue that this is an order. A fact that will be appreciated when several orders are entered in the system along with their respective groups and results'),
(1267, 'Both rendering and supervising providers can be set here'),
(1268, 'Bottom'),
(1269, 'Bottom Margin (px)'),
(1270, 'Box 10 - This information indicates whether the patient’s illness or injury is related to employment, auto accident, or other accident'),
(1271, 'Box 10 A. Employment related'),
(1272, 'BOX 10 A. Employment related '),
(1273, 'Box 10 B. Auto Accident'),
(1274, 'BOX 10 B. Auto Accident '),
(1275, 'Box 10 C. Other Accident'),
(1276, 'BOX 10 C. Other Accident '),
(1277, 'Box 10 D - Is used to submit the Early and Periodic Screening, Diagnosis and Treatment (EPSDT) Referral Code'),
(1278, 'Box 10 D. EPSDT Referral Code'),
(1279, 'BOX 10 D. EPSDT Referral Code'),
(1280, 'Box 10. a. Employment related:'),
(1281, 'Box 10. b. Auto Accident:'),
(1282, 'Box 10. c. Other Accident:'),
(1283, 'Box 10. d. EPSDT Referral Code:'),
(1284, 'Box 14 - It identifies the first date of onset of illness, the actual date of injury, or the LMP for pregnancy. Enter the date in the first box and select either Onset of Current Symptoms or Illness or LMP from the drop-down box'),
(1285, 'BOX 14 Date Qualifier'),
(1286, 'BOX 14. Is Populated from the Encounter Screen as the Onset Date'),
(1287, 'Box 14. Onset Date:'),
(1288, 'Box 15 - The Other Date identifies additional date information about the patient’s condition or treatment. Enter the date in the first box and select a qualifier from the drop-down box'),
(1289, 'BOX 15 Other Date Qualifier'),
(1290, 'BOX 15. Date of same or similar illness (yyyy-mm-dd):'),
(1291, 'BOX 15. Date of same or similar illness/Other Date (yyyy-mm-dd):'),
(1292, 'Box 15. Other Date:'),
(1293, 'Box 16 - Dates Patient Unable to Work in Current Occupation - is the time span the patient is or was unable to work'),
(1294, 'Box 16. Date unable to work from'),
(1295, 'BOX 16. Date unable to work from'),
(1296, 'BOX 16. Date unable to work from (yyyy-mm-dd):'),
(1297, 'Box 16. Date unable to work from:'),
(1298, 'Box 16. Date unable to work to'),
(1299, 'BOX 16. Date unable to work to'),
(1300, 'BOX 16. Date unable to work to (yyyy-mm-dd):'),
(1301, 'Box 16. Date unable to work to:'),
(1302, 'Box 17 - The name entered is the referring provider, ordering provider or supervising provider who referred, ordered, or supervised the service(s) or supply(ies) on the claim. If multiple providers are involved, enter one provider using the following priority order: 1. Referring Provider, 2. Ordering Provider, 3. Supervising Provider.'),
(1303, 'Box 17. Provider'),
(1304, 'BOX 17. Provider'),
(1305, 'Box 17. Provider Qualifier'),
(1306, 'BOX 17. Provider Qualifier'),
(1307, 'Box 17. Provider Qualifier:'),
(1308, 'Box 17. Provider:'),
(1309, 'Box 18 - The “Hospitalization Dates Related to Current Services” would refer to an inpatient stay and indicates the admission and discharge dates associated with the service(s) on the claim'),
(1310, 'Box 18. Hospitalization date from'),
(1311, 'BOX 18. Hospitalization date from'),
(1312, 'BOX 18. Hospitalization date from (yyyy-mm-dd): '),
(1313, 'Box 18. Hospitalization date from:'),
(1314, 'Box 18. Hospitalization date to'),
(1315, 'BOX 18. Hospitalization date to'),
(1316, 'BOX 18. Hospitalization date to (yyyy-mm-dd): '),
(1317, 'Box 18. Hospitalization date to:'),
(1318, 'Box 20 - Indicates that services have been rendered by an independent provider as indicated in Box 32 (Service Facility Location Information) and the related costs'),
(1319, 'Box 20. Is Outside Lab used?'),
(1320, 'BOX 20. Is Outside Lab used?'),
(1321, 'Box 22 - Medicaid Resubmission Code and Original Reference Number is the code and original reference number assigned by the destination payer or receiver to indicate a previously submitted claim or encounter'),
(1322, 'Box 22. Medicaid Resubmission Code (ICD-10)'),
(1323, 'Box 22. Medicaid Resubmission Code (ICD-9) '),
(1324, 'BOX 22. Medicaid Resubmission Code (ICD-9) '),
(1325, 'Box 23 - Prior Authorization Number is the payer assigned number authorizing the service(s)'),
(1326, 'Box 23. Prior Authorization No.'),
(1327, 'Box 23. Prior Authorization No. '),
(1328, 'BOX 23. Prior Authorization No. '),
(1329, 'BP'),
(1330, 'BP Diastolic'),
(1331, 'BP Systolic'),
(1332, 'BPD'),
(1333, 'Bpd'),
(1334, 'BPD-D{{abbreviation for Binocular Pupillary Diameter - Distance}}'),
(1335, 'BPD-N{{abbreviation for Binocular Pupillary Diameter - Near}}'),
(1336, 'BPS'),
(1337, 'Bps'),
(1338, 'Brand'),
(1339, 'Brand Name'),
(1340, 'Brazilian Portuguese'),
(1341, 'Breast'),
(1342, 'Breast Biopsy'),
(1343, 'Breast Discharge'),
(1344, 'Breast Disease'),
(1345, 'Breast Exam'),
(1346, 'Breast Mass'),
(1347, 'Breath'),
(1348, 'Breath Sounds:'),
(1349, 'Breton'),
(1350, 'Brightness Acuity Testing'),
(1351, 'Broken Bones'),
(1352, 'broken form'),
(1353, 'Bronchitis Form'),
(1354, 'Brother'),
(1355, 'Brow'),
(1356, 'Browse'),
(1357, 'Browse for Record'),
(1358, 'Bruising/haematoma'),
(1359, 'Build diagnoses list by clicking appropriate code button.'),
(1360, 'Build Your Plan'),
(1361, 'Bulgarian'),
(1362, 'Bulging Right:'),
(1363, 'Burmese'),
(1364, 'Burning with Urination'),
(1365, 'Burning With Urination'),
(1366, 'Business Associate Agreement'),
(1367, 'Business Phone'),
(1368, 'Busy'),
(1369, 'but Needs Review'),
(1370, 'but not yet processed.'),
(1371, 'Buttock'),
(1372, 'Buttock + S.I.'),
(1373, 'button to clear Location selections, \"Send\" button to send templates to patient(s) or profiles'),
(1374, 'by'),
(1375, 'By'),
(1376, 'By default Active Messages are displayed as indicated in the section below the Messages caption'),
(1377, 'By default all codes are selected, uncheck the codes you do not want and click \'Add\'. These codes will then be added to the current encounter'),
(1378, 'By default only Demographics and Billing information is selected'),
(1379, 'By default only five dated reminders are shown at a time'),
(1380, 'By default the User Memberships section is selected and all the active registered users will be listed in alphabetical order by their user names.'),
(1381, 'by mouth'),
(1382, 'By selecting a payment method the rates calculated for that payment method will be automatically displayed in \'Selected Fee Sheet Codes and Charges for Current Encounter\' section'),
(1383, 'By/Source'),
(1384, 'By:'),
(1385, 'by{{made by/manufacturer}}'),
(1386, 'B{{both sides}}'),
(1387, 'C'),
(1388, 'C/D Ratio{{cup to disc ration}}'),
(1389, 'C3 statistical reports.'),
(1390, 'C3 Statistics Reporting'),
(1391, 'CA Certificate for verifying the RFC 5425 TLS syslog server.'),
(1392, 'Cache Lifetime (in seconds)'),
(1393, 'Cache template output?'),
(1394, 'Caffeine'),
(1395, 'Caffeine consumption'),
(1396, 'Calendar'),
(1397, 'Calendar Ending Hour'),
(1398, 'Calendar Interval'),
(1399, 'Calendar Screen'),
(1400, 'Calendar Settings'),
(1401, 'Calendar Settings (calendar)'),
(1402, 'Calendar Starting Hour'),
(1403, 'Calendar UI'),
(1404, 'Calendar View'),
(1405, 'calendar_external to events'),
(1406, 'Call Back Notes'),
(1407, 'Call to addForm() goes here.<br>'),
(1408, 'Callback'),
(1409, 'Callback Performed'),
(1410, 'Callback requested'),
(1411, 'Calories'),
(1412, 'Cambodian'),
(1413, 'CAMOS'),
(1414, 'Can not determine OS!'),
(1415, 'Can not find where to insert.'),
(1416, 'Can not set this unless the Summary of Care Sent toggle is set.'),
(1417, 'Can\'t find file!'),
(1418, 'Can\'t upload'),
(1419, 'Canada'),
(1420, 'Cancel'),
(1421, 'cancel'),
(1422, 'Cancel Appointment'),
(1423, 'Cancel Changes'),
(1424, 'Cancel Payment'),
(1425, 'Cancel/Exit'),
(1426, 'Canceled'),
(1427, 'Canceled < 24h'),
(1428, 'Cancelled'),
(1429, 'Cancer'),
(1430, 'Cancer Screening: Colon Cancer Screening'),
(1431, 'Cancer Screening: Mammogram'),
(1432, 'Cancer Screening: Pap Smear'),
(1433, 'Cancer Screening: Prostate Cancer Screening'),
(1434, 'Cannot add this entry because it already exists!'),
(1435, 'Cannot add to archive'),
(1436, 'Cannot add/update this entry because a duplicate already exists!'),
(1437, 'cannot be archived, ignored'),
(1438, 'cannot be converted to JPEG. Perhaps ImageMagick is not installed?'),
(1439, 'cannot be deleted, ignored'),
(1440, 'cannot be displayed inline because its type is not supported by the browser.'),
(1441, 'cannot be displayed inline becuase its type is not supported by the browser'),
(1442, 'cannot be displayed inline becuase its type is not supported by the browser.'),
(1443, 'Cannot be used in case of the absence of the cellular coverage'),
(1444, 'Cannot close because there are charges. Check out instead.'),
(1445, 'Cannot create'),
(1446, 'Cannot create file'),
(1447, 'Cannot delete (from SFTP server) file'),
(1448, 'Cannot delete file'),
(1449, 'Cannot determine a destination filename'),
(1450, 'Cannot find '),
(1451, 'Cannot find a destination filename'),
(1452, 'Cannot find a skip source field for'),
(1453, 'Cannot find a skip target field for'),
(1454, 'Cannot find patient from SQL-Ledger customer id'),
(1455, 'Cannot find postscript document reference in '),
(1456, 'Cannot find provider from SQL-Ledger employee = '),
(1457, 'Cannot Modify Payments.Undistributed is Negative.'),
(1458, 'Cannot open'),
(1459, 'Cannot open '),
(1460, 'Cannot Post for Insurance.The Paying Entity selected is Patient.'),
(1461, 'Cannot Post for Patient.The Paying Entity selected is Insurance.'),
(1462, 'Cannot Post Payments.Undistributed is Negative.'),
(1463, 'Cannot read'),
(1464, 'Cannot read directory'),
(1465, 'Cannot update because you are not editing an existing entry!'),
(1466, 'Capitalize'),
(1467, 'Capitalize all'),
(1468, 'capsule'),
(1469, 'Card'),
(1470, 'Card CVV'),
(1471, 'Card Expiry Date'),
(1472, 'Card Expiry Date and Card Holders Zip'),
(1473, 'Card Holder Zip'),
(1474, 'Card Name'),
(1475, 'Card Number'),
(1476, 'Card Type'),
(1477, 'Cardiac'),
(1478, 'Cardiac Catheterization'),
(1479, 'Cardiac Echo'),
(1480, 'Cardiovascular'),
(1481, 'Care Coordination'),
(1482, 'Care Coordination Only'),
(1483, 'Care documentation'),
(1484, 'Care giver'),
(1485, 'Care Plan'),
(1486, 'Care Plan Form'),
(1487, 'Care plan recommendations'),
(1488, 'Care Team'),
(1489, 'Careful planning is essential before entering the tests to ensure subsequent ease of use and proper display of results'),
(1490, 'Carotid Bruit'),
(1491, 'Carotid{{carotid arteries}}'),
(1492, 'Cartilage / chondral / disc damage'),
(1493, 'Cartilage injury'),
(1494, 'Cartoid pulsations nl, pedal pulses nl'),
(1495, 'CAR{{carotid arteries}}'),
(1496, 'cash'),
(1497, 'Cash'),
(1498, 'Cash Rec'),
(1499, 'Cash Receipts by Provider'),
(1500, 'Catalan- Valencian'),
(1501, 'Cataract'),
(1502, 'Cataract Surgery'),
(1503, 'Cataracts'),
(1504, 'Categories'),
(1505, 'Categories for'),
(1506, 'Category'),
(1507, 'category'),
(1508, 'Category '),
(1509, 'Category - Order, Result and Recommendation need an identifying code'),
(1510, 'Category changed.'),
(1511, 'Category Color Schema'),
(1512, 'Category Details'),
(1513, 'Category Limits'),
(1514, 'Category Name'),
(1515, 'Category name is empty'),
(1516, 'Category/Title'),
(1517, 'Caucasian'),
(1518, 'Causes Receipts to Print Encounter/Primary Provider Info'),
(1519, 'cc Distance{{with correction at distance}}'),
(1520, 'cc Near{{with correction at Near}}'),
(1521, 'CCD'),
(1522, 'CCDA'),
(1523, 'CCDA or QRDA Cat I'),
(1524, 'ccDist{{ACT with Correction Distance}}'),
(1525, 'ccDist{{with correction distance}}'),
(1526, 'ccNear{{ACT with Correction Near}}'),
(1527, 'ccNear{{with correction at near}}'),
(1528, 'CCR'),
(1529, 'CCR Approve'),
(1530, 'CCR Patient Review'),
(1531, 'CCR Review and Approve'),
(1532, 'CC{{Chief Complaint}}'),
(1533, 'cc{{with correction}}'),
(1534, 'CC{{with correction}}'),
(1535, 'CDA defines building blocks which can be used to contain healthcare data elements that can be captured, stored, accessed, displayed and transmitted electronically for use and reuse in many formats'),
(1536, 'CDA or Clinical Document Architecture is a document standard developed by the HL7 organization'),
(1537, 'CDC Code'),
(1538, 'CDC-NIP Code'),
(1539, 'CDR'),
(1540, 'CDR Reports Processing Priority'),
(1541, 'Cell'),
(1542, 'Cell Phone'),
(1543, 'Cell phone number'),
(1544, 'Cell Phone Number'),
(1545, 'Centered Layout'),
(1546, 'Central Certification'),
(1547, 'Central Macular Thickness'),
(1548, 'Central/South American'),
(1549, 'Certificate Authority crt file location cannot be empty'),
(1550, 'Certificate Authority key file location cannot be empty'),
(1551, 'Certificate to send to RFC 5425 TLS syslog server.'),
(1552, 'Certificate User'),
(1553, 'Certificates'),
(1554, 'Cervical Cancer Reporting'),
(1555, 'Cervical cancer statistical reports.'),
(1556, 'Chamorro'),
(1557, 'ChampUS'),
(1558, 'ChampUSVA'),
(1559, 'change'),
(1560, 'Change'),
(1561, 'Change Activity'),
(1562, 'Change any item available and when ready click Send for review. The changes will be flagged and staff notified to review changes before commiting them to chart. During the time period before changes are reviewed the Revised button will show Pending and profile data is still available for changes. When accessing profile in pending state all previous edits will appear in Blue and current chart values in Red. You may revert any edit to chart value by clicking that red item (or vica versa) but remember that when you click Send for Review then items that populate the field items are the ones that are sent. Revert Edits button changes everything back to chart values and you may make changes from there. So to recap: Items in BLUE are patient edits with items in RED being original values before any edits.'),
(1563, 'Change any item available and when ready click Send for review. The changes will be flagged and staff notified to review changes before committing them to chart. During the time period before changes are reviewed the Revised button will show Pending and profile data is still available for changes. When accessing profile in pending state all previous edits will appear in Blue and current chart values in Red. You may revert any edit to chart value by clicking that red item (or vica versa) but remember that when you click Send for Review then items that populate the field items are the ones that are sent. Revert Edits button changes everything back to chart values and you may make changes from there. So to recap: Items in BLUE are patient edits with items in RED being original values before any edits.'),
(1564, 'Change Credentials'),
(1565, 'Change failed! CouchDB connect error?'),
(1566, 'Change in Vision'),
(1567, 'Change In Vision'),
(1568, 'Change or keep current. Enter 12 to 80 characters. Recommended to include symbols and numbers but not required.'),
(1569, 'Change Password'),
(1570, 'Change Password for'),
(1571, 'Change Portal Credentials'),
(1572, 'Change Status for'),
(1573, 'Change your password before it expires on'),
(1574, 'Changed'),
(1575, 'Changed Bowel'),
(1576, 'Changes the current theme to be more compact.'),
(1577, 'Changes the layout of the login page.'),
(1578, 'Changing patient ID for document'),
(1579, 'Changing the status to Done will remove the message from the active message list'),
(1580, 'Changing the status to New will achieve the same result'),
(1581, 'Changing the status to Read would leave it as a read message in the active messages list of the current user'),
(1582, 'Channels'),
(1583, 'Characteristics'),
(1584, 'Characters Remaining'),
(1585, 'Charge'),
(1586, 'Charge adjustment'),
(1587, 'Charge Coded'),
(1588, 'Charge Total'),
(1589, 'Charges'),
(1590, 'Charges for'),
(1591, 'Chart'),
(1592, 'Chart Activity'),
(1593, 'Chart Check-in/out Activity Report'),
(1594, 'Chart History'),
(1595, 'Chart ID'),
(1596, 'Chart ID:'),
(1597, 'Chart Label'),
(1598, 'Chart Location Activity'),
(1599, 'Chart Note'),
(1600, 'Chart Number'),
(1601, 'Chart pulled'),
(1602, 'Chart Storage Locations'),
(1603, 'Chart to'),
(1604, 'Chart to Category'),
(1605, 'Chart Tracker'),
(1606, 'Chart Trk'),
(1607, 'Chart View'),
(1608, 'Charting History.'),
(1609, 'Charts Checked Out'),
(1610, 'Charts Out'),
(1611, 'Chat'),
(1612, 'Chat history'),
(1613, 'Chat Messaging'),
(1614, 'Chechen'),
(1615, 'Check'),
(1616, 'check'),
(1617, 'Check All'),
(1618, 'Check All - Components'),
(1619, 'Check Amount'),
(1620, 'Check and adjust the settings in the standard release'),
(1621, 'Check Date'),
(1622, 'Check expiration dates.'),
(1623, 'Check for differences of translations with custom language table.'),
(1624, 'Check if a help file exists for this page in'),
(1625, 'Check if this is a cognitive status. Unchecked is a functional status'),
(1626, 'Check if you plan to print postcards locally'),
(1627, 'Check if you plan to send postcards via MedEx'),
(1628, 'Check if you plan to use Avery Labels for Reminders or Recalls'),
(1629, 'Check In'),
(1630, 'Check In To'),
(1631, 'Check Input Data'),
(1632, 'Check items to graph'),
(1633, 'Check Lab Results'),
(1634, 'Check mark indicates reviewed'),
(1635, 'Check No'),
(1636, 'Check Number'),
(1637, 'Check or Reference Number'),
(1638, 'Check Out'),
(1639, 'Check Out Time'),
(1640, 'Check Payment'),
(1641, 'Check the box if this is an encrypted file'),
(1642, 'Check the CPOE (Computerized Provider Order Entry) check-box'),
(1643, 'Check the Enable phiMail Direct Messaging Service check-box'),
(1644, 'Check the Sequence numbers'),
(1645, 'Check this if you want providers to see all appointments by default and not just their own.'),
(1646, 'Check this to go live. Not checked is testing mode.'),
(1647, 'Check to create problem from this diagnosis'),
(1648, 'Check your email inbox (and possibly your spam folder) for further instructions to register. If you have not received an email, then recommend contacting the clinic.'),
(1649, 'Check your email inbox (and possibly your spam folder) for further instructions to reset your password. If you have not received an email, then recommend contacting the clinic.'),
(1650, 'Check/EOB Date'),
(1651, 'Check/EOB Date:'),
(1652, 'Check/EOB No.'),
(1653, 'Check/EOB No.:'),
(1654, 'Check/Ref Number'),
(1655, 'Check/Reference Number'),
(1656, 'Checkbox list'),
(1657, 'checkbox list'),
(1658, 'checkbox w/ text'),
(1659, 'Checkbox w/text'),
(1660, 'Checkbox(es)'),
(1661, 'Checkboxes above indicate if you want to reject and delete the HL7 file.'),
(1662, 'Checkboxes w/text'),
(1663, 'Checked'),
(1664, 'checked'),
(1665, 'Checked box = yes ,  empty = no'),
(1666, 'Checked box = yes, empty = no'),
(1667, 'Checked Drug Formulary?'),
(1668, 'Checked Out'),
(1669, 'Checked out'),
(1670, 'Checking any of the check boxes will result in a Yes on the CMS 1500 form'),
(1671, 'Checking the Groups and Access Controls checkbox will reveal this section that lists all the categories with sub-categories (ACOs), i.e. the parts of the program controlled by the access control list privileges.'),
(1672, 'Checking the lock checkbox will prevent any futher edits on any forms in this encounter.'),
(1673, 'Checking the Postcards check box will let you print a postcard that can be mailed to a patient'),
(1674, 'Checkout'),
(1675, 'Checkout Receipt Note'),
(1676, 'Checkout Receipt Ref'),
(1677, 'checksum'),
(1678, 'Checksum'),
(1679, 'Chest'),
(1680, 'Chest CTAB'),
(1681, 'Chest Pain'),
(1682, 'Chest Pain:'),
(1683, 'Chest Pains'),
(1684, 'Chest physician'),
(1685, 'Chg'),
(1686, 'Chichewa- Chewa- Nyanja'),
(1687, 'Chief Complaint'),
(1688, 'Chief Complaint 2'),
(1689, 'Chief Complaint 3'),
(1690, 'Child'),
(1691, 'Child in-law'),
(1692, 'Childhood immunization Status (CQM)'),
(1693, 'Chills'),
(1694, 'Chinese'),
(1695, 'Chinese (Simplified)'),
(1696, 'Chinese (Traditional)'),
(1697, 'Chiropractic'),
(1698, 'Choices'),
(1699, 'Cholecystectomy'),
(1700, 'cholecystectomy'),
(1701, 'Cholecystestomy'),
(1702, 'Choose'),
(1703, 'choose'),
(1704, 'Choose a period or dates (YYYY-MM-DD)'),
(1705, 'Choose a section and click an item within it; then in the other section you will see the related items highlighted, and you can click in that section to add and delete relationships.'),
(1706, 'Choose constant column'),
(1707, 'Choose Criteria'),
(1708, 'Choose CSV table'),
(1709, 'Choose definition column'),
(1710, 'Choose Download or Display Inline'),
(1711, 'Choose either current provider or current logged in provider'),
(1712, 'Choose file'),
(1713, 'Choose File'),
(1714, 'Choose from list'),
(1715, 'Choose Layout Direction'),
(1716, 'Choose list'),
(1717, 'Choose one if appropriate'),
(1718, 'Choose one of the four return values that reflect varying degrees of privilege.'),
(1719, 'Choose Paper Size'),
(1720, 'Choose Patient'),
(1721, 'Choose PDF languange Preference'),
(1722, 'Choose print format for this encounter report.'),
(1723, 'Choose the layout (need to logout and then login to see this new setting).'),
(1724, 'Choose your default encounter view'),
(1725, 'Chrome browser version 41 and above, Mozilla Firefox browser version 64 and above, Microsoft Edge browser version 19 and above, Safari browser version 13 and above, Opera browser version 40 and Opera browser version 42 and above support FIDO U2F API'),
(1726, 'Chronic Bronchitis'),
(1727, 'Chronic Joint Pain'),
(1728, 'Chronic Kidney Disease (CKD)'),
(1729, 'Chronic or Inactive Problems'),
(1730, 'Chronic Problems'),
(1731, 'Chronic synovitis / effusion / joint pain / gout'),
(1732, 'Chronic/Inactive Problems'),
(1733, 'Chronic/Recurrent'),
(1734, 'Chuvash'),
(1735, 'Cigs'),
(1736, 'Cipher failure check encryption key'),
(1737, 'Cirrhosis of the Liver'),
(1738, 'Cirrhosis Of The Liver'),
(1739, 'City'),
(1740, 'City and state must both be filled out'),
(1741, 'City Name'),
(1742, 'City, State'),
(1743, 'City, State Zip'),
(1744, 'City, State, ZIP'),
(1745, 'City,St,Zip'),
(1746, 'City/State'),
(1747, 'Claim'),
(1748, 'Claim '),
(1749, 'Claim Edit'),
(1750, 'Claim File Tracker'),
(1751, 'Claim Status'),
(1752, 'Claim test has completed running'),
(1753, 'Claim Type'),
(1754, 'Claim was generated to file'),
(1755, 'Claim was generated to file '),
(1756, 'Claims'),
(1757, 'claims selected.'),
(1758, 'Class'),
(1759, 'Classification'),
(1760, 'Clear'),
(1761, 'clear'),
(1762, 'Clear 2FA'),
(1763, 'CLEAR ACTIVE PATIENT'),
(1764, 'CLEAR ACTIVE THERAPY GROUP'),
(1765, 'Clear All'),
(1766, 'Clear Filters'),
(1767, 'Clear history'),
(1768, 'Clear HL7 Data'),
(1769, 'Clear Insurance Debt'),
(1770, 'Clear Justification'),
(1771, 'Clear Left side values'),
(1772, 'Clear Log'),
(1773, 'Clear OD{{right eye}} values'),
(1774, 'Clear Pad'),
(1775, 'Clear Right side values'),
(1776, 'Clear Signature'),
(1777, 'Clear Smarty Cache'),
(1778, 'Clear the log'),
(1779, 'Clearing house info required for EDI 270 batch creation.'),
(1780, 'CLIA Number'),
(1781, 'Click'),
(1782, 'Click \'export\' to export your Category, Subcategory, Item, Content data to a text file. Any resemblance of this file to an XML file is purely coincidental. The opening and closing tags must be on the same line, they must be lowercase with no spaces. To import, browse for a file and click \'import\'. If the data is completely different, it will merge with your existing data. If there are similar item names, The old one will be kept and the new one saved with a number added to the end.'),
(1783, 'Click \'Save\''),
(1784, 'Click \'Save\'. Now you will be able to use the Search feature to search all ICD 10 codes'),
(1785, 'Click a spot on the graphic to add a new annotation, click it again to remove it'),
(1786, 'Click and drag bottom right corner to resize this display'),
(1787, 'Click Browse and select one Electronic Remittance Advice (ERA) file...'),
(1788, 'Click Close to exit the Select Codes pop-up page'),
(1789, 'Click Download Certificate to download the certificates in the file ssl.zip'),
(1790, 'click for more'),
(1791, 'Click for more details'),
(1792, 'Click for order summary'),
(1793, 'Click for results'),
(1794, 'Click for Shorthand Help.'),
(1795, 'Click Got it icon to dismiss this alert forever.'),
(1796, 'Click here'),
(1797, 'Click Here to add a new patient.'),
(1798, 'Click here to add new injury change status and edit daily activity'),
(1799, 'Click here to add new row'),
(1800, 'Click here to choose a date'),
(1801, 'Click here to choose a date and time'),
(1802, 'Click here to choose a start date'),
(1803, 'Click here to choose date time'),
(1804, 'Click here to choose date time from'),
(1805, 'Click here to choose date time to'),
(1806, 'Click Here to Configure This module'),
(1807, 'Click here to delete all options'),
(1808, 'Click here to delete the row'),
(1809, 'Click here to delete the selection'),
(1810, 'Click Here to Disable This module'),
(1811, 'Click here to duplicate the row'),
(1812, 'Click here to edit list of available Lens Materials'),
(1813, 'Click here to edit list of available Lens Treatment Options'),
(1814, 'Click here to Edit the Contact Lens Brand List'),
(1815, 'Click here to Edit the Course/Occurrence List'),
(1816, 'Click here to Edit the Manufacter List'),
(1817, 'Click here to Edit the Supplier List'),
(1818, 'Click here to Edit this Doctor\'s Plan options'),
(1819, 'Click here to Edit this Doctor\'s Quick Pick list'),
(1820, 'Click here to Edit this Provider\'s Exam Default values'),
(1821, 'Click Here to Enable This module'),
(1822, 'Click Here to Install ACL for module'),
(1823, 'Click Here to Install SQL for module'),
(1824, 'Click Here to Install This module'),
(1825, 'click here to search'),
(1826, 'Click here to see observation results'),
(1827, 'Click Here to UnRegister this Module'),
(1828, 'click here to update priority, category and nickname settings'),
(1829, 'click here to update priority, category, nickname and access control settings'),
(1830, 'Click Here to Upgrade ACL for module'),
(1831, 'Click Here to Upgrade SQL for module'),
(1832, 'Click here to view all.'),
(1833, 'Click here to view and graph'),
(1834, 'Click here to view and graph all labdata.'),
(1835, 'Click here to view and graph all vitals.'),
(1836, 'Click here to view patient details'),
(1837, 'Click here to view them all.'),
(1838, 'Click here to view/edit more details'),
(1839, 'Click in signature'),
(1840, 'Click in signature on file'),
(1841, 'Click Install button to install database release from the following date'),
(1842, 'Click me to Open Patient Dashboard'),
(1843, 'Click OK if you are sure.'),
(1844, 'Click OK to Clear or Cancel to continue processing.'),
(1845, 'Click OK to import these patients into the patient input box'),
(1846, 'Click Okay if you are sure you want to cancel this appointment?'),
(1847, 'Click on Add to bring up the Add/Edit Issue pop-up page'),
(1848, 'Click on Add to List button to add to the bottom section'),
(1849, 'Click on any of the time parts to increase it'),
(1850, 'Click on Create New Transaction to open the Add/Edit Patient Transaction page'),
(1851, 'Click on either the Invoice Search button on the far right, for manual entry or ERA Upload button for uploading an entire electronic remittance advice ERA file'),
(1852, 'Click on the \'Add Group\' button to create this new group (ARO).'),
(1853, 'Click on the + sign adjacent to the Serum Uric Acid test Name to reveal the newly created Result line'),
(1854, 'Click on the + sign at the far end of the Blood Glucose line to bring up the Enter Details pop-up in the Add Mode'),
(1855, 'Click on the Add icon at the far end of the Serum Chemistry line'),
(1856, 'Click on the Add New dropdown box and select an option'),
(1857, 'Click on the Allergy/Intolerance button'),
(1858, 'Click on the black + sign at the far end of the Well Woman Tests line to create a direct descendant or child to this Custom Top Group'),
(1859, 'Click on the black + sign on the Electrolyte Panel line to create a direct descendant or child'),
(1860, 'Click on the blue + sign to see the Procedure Order that was saved'),
(1861, 'Click on the blue plus sign under Name to reveal test names'),
(1862, 'Click on the Diagnosis Codes box to open the Select Diagnosis Codes pop-up window'),
(1863, 'Click on the File menu item on the top left of the Message center page ansd select Setup MedEx'),
(1864, 'Click on the icon next to the \'Access Control List Administration\' title to go to the phpGACL page.'),
(1865, 'Click on the Issues menu item to bring up the Issues page'),
(1866, 'Click on the Ledger menu item in the navigation bar to to enter the Patient Ledger page'),
(1867, 'Click on the Name text box on the left section to bring up the patient finder pop-up'),
(1868, 'Click on the New Recall button to open a new recall scheduling page'),
(1869, 'Click on the the following link to learn more about what is involved.'),
(1870, 'Click Patient Name to Open Patient File'),
(1871, 'Click Refresh and click on the blue + mark that precedes the name Serum Chemistry'),
(1872, 'Click Refresh to view all results, or please input search criteria above to view specific results.'),
(1873, 'Click Register to register the TOTP'),
(1874, 'Click Save'),
(1875, 'Click Save and then Refresh'),
(1876, 'Click Save to close the pop-up'),
(1877, 'Click Save to close the pop-up window'),
(1878, 'Click Save to create a new line with a Name of Well Womans Tests preceded by a vertical line indicating that it has no descendants or children'),
(1879, 'Click Save to save and close the pop-up'),
(1880, 'Click Save to save this problem'),
(1881, 'Click the \'Add New Group\' button to display the \'New Group Information\' section.'),
(1882, 'Click the \'Delete Group\' button to completely remove this group.'),
(1883, 'Click the \'Remove Group\' button to display the \'Remove Group Form\'.'),
(1884, 'Click the \'Yes\' radio button.'),
(1885, 'Click the Clear button to clear the imported patient names and start afresh'),
(1886, 'Click the Clear button to start afresh'),
(1887, 'Click the Delete button to delete all selected codes or select individual codes to be deleted from the drop-down box adjacent to the delete button and then click the Delete button'),
(1888, 'Click the pencil icon to grant and remove access privileges to the selected user'),
(1889, 'Click the Save button'),
(1890, 'Click the Search for Allergy button'),
(1891, 'Click the slashed-eye icon to close.'),
(1892, 'Click the Submit button to display the main log'),
(1893, 'Click the Transmit button to reveal the Direct address box'),
(1894, 'Click this to display/hide additional tests'),
(1895, 'Click to activate and send to this recipient.'),
(1896, 'Click to add a diagnosis'),
(1897, 'Click to add diagnosis for this test'),
(1898, 'Click to add HCFA 1500 miscellaneous billing options'),
(1899, 'Click to add new components'),
(1900, 'Click to add new consultation'),
(1901, 'Click to add patient'),
(1902, 'Click to choose diagnoses to justify.'),
(1903, 'Click to Contract and set to henceforth open in Centered mode'),
(1904, 'Click to display shorthand field names.'),
(1905, 'Click to download'),
(1906, 'Click to edit'),
(1907, 'Click to edit description'),
(1908, 'Click to edit this event'),
(1909, 'Click to Expand and set to henceforth open in Expanded mode'),
(1910, 'Click to expand or collapse All active patient templates panel.'),
(1911, 'Click to expand or collapse Assigned Patients panel.'),
(1912, 'Click to expand or collapse Repository templates panel.'),
(1913, 'Click to generate the report'),
(1914, 'Click to go to page'),
(1915, 'Click to Hide'),
(1916, 'Click to hide advanced search'),
(1917, 'Click to Hide Filters'),
(1918, 'Click to hide search'),
(1919, 'Click to learn more about the Clinical Document Architecture (CDA) and Consolidated CDA (C-CDA)'),
(1920, 'Click to make chat this current recipient only...'),
(1921, 'Click to manually configure access control, recommended for advanced users'),
(1922, 'Click to match patient'),
(1923, 'Click to open in a new window or tab'),
(1924, 'Click to print'),
(1925, 'Click to Re-Send this fax'),
(1926, 'Click to receive (add) new lot'),
(1927, 'Click to reveal more information'),
(1928, 'Click to review the Directory of Service for this test'),
(1929, 'Click to search past and current diagnoses history'),
(1930, 'Click to see more information'),
(1931, 'Click to select'),
(1932, 'Click To Select'),
(1933, 'Click to select a default diagnosis or procedure code for this order'),
(1934, 'Click to select an industry-standard code for this procedure'),
(1935, 'Click to select diagnosis or procedure code to default to order'),
(1936, 'Click to select group'),
(1937, 'Click to select optional procedure code'),
(1938, 'Click to select or change coding'),
(1939, 'Click to select or change CVX code'),
(1940, 'Click to select or change diagnoses'),
(1941, 'Click to select or change service codes'),
(1942, 'Click to select patient'),
(1943, 'Click to select related code'),
(1944, 'Click to select RXCUI code'),
(1945, 'Click to select services to perform if this result is abnormal'),
(1946, 'Click to select services to perform if this result is abnormal.'),
(1947, 'Click to select services to perform if this result is abnormal. This is optional'),
(1948, 'Click to select the desired procedure'),
(1949, 'Click to Show'),
(1950, 'Click to show advanced search'),
(1951, 'Click to Show Filters'),
(1952, 'Click to show messages for all users'),
(1953, 'Click to show messages for only the current user'),
(1954, 'Click to show search'),
(1955, 'Click to sort'),
(1956, 'Click to start or end sql server activity checks.'),
(1957, 'Click to use procedure code from code popup'),
(1958, 'Click to view'),
(1959, 'Click to view Help'),
(1960, 'Click to view or edit'),
(1961, 'Click to view.'),
(1962, 'Click to view/edit'),
(1963, 'Click Update List to display billing information filtered by the selected Current Criteria'),
(1964, 'Click Upgrade button to upgrade database release from the following date'),
(1965, 'click View Log and review for errors.'),
(1966, 'Click where indicated above to match the patient.'),
(1967, 'Click:'),
(1968, 'Clicking on \'Review\' will list all the codes entered for previous encounters'),
(1969, 'Clicking on either the Enter Name or Enter ID tab will bring up the search box which you can use to select a patient'),
(1970, 'Clicking on Set As Completed will remove the reminder from the active display'),
(1971, 'Clicking on the + button on the patient header panel opens the New Encounter Form'),
(1972, 'Clicking on the Add Issue button brings up the add issue pop-up box'),
(1973, 'Clicking on the Coding cell will bring up the Educational materials pop-up that will let you search by ICD10 code'),
(1974, 'Clicking on the Create A Dated Reminder button will bring up the Send a Reminder popup'),
(1975, 'Clicking on the Create Online/Offsite Portal Credentials button will generate a username and password for the patient that has to be given to the patient'),
(1976, 'Clicking on the Delete button will delete the message'),
(1977, 'Clicking on the first cell under Title will bring up the Add/Edit Issue pop-up page that will let you edit this entry'),
(1978, 'Clicking on the icon next to the caption will display everyone\'s messages and the caption will change to All Messages'),
(1979, 'Clicking on the icon next to their name will bring up the \'Edit\' window.'),
(1980, 'Clicking on the Miscellaneous > MFA Management menu item or User Name > MFA Management menu item brings you to the landing page for managing the multi factor authentication page for that user'),
(1981, 'Clicking on the patient\'s name will reveal the message'),
(1982, 'Clicking on the pencil icon will enter the Edit mode and will display the Enter Details pop-up window that was used to create the entry displayed on this line'),
(1983, 'Clicking on the Show All or Show Inactive buttons will show the appropriate messages'),
(1984, 'Clicking on the slashed eye icon will hide the filters'),
(1985, 'Clicking on the View Log button will bring up the Dated Message Log popup'),
(1986, 'Clicking Options will present a multiselection drop menu to add behaviors to the selected data type. Typing after pull down activates allows search in options.'),
(1987, 'Clicking the button will reveal a popup that will list the E/M codes, check the appropriate code and click \'OK\''),
(1988, 'Clicking the Transmit button will open up a text box where the Direct address of the recipient needs to be entered'),
(1989, 'Client APP ID:'),
(1990, 'Client Certificate Expiration Days'),
(1991, 'Client certificate passphrase'),
(1992, 'Client certificate validation period'),
(1993, 'Client certificate validity should be a valid number.'),
(1994, 'Client Copy'),
(1995, 'Client failed to save. Check system logs'),
(1996, 'Client ID'),
(1997, 'Client List of IVE Activity'),
(1998, 'Client medical history summary'),
(1999, 'Client Name'),
(2000, 'Client Name / Client ID'),
(2001, 'Client Number'),
(2002, 'Client Profile - New Clients'),
(2003, 'Client Profile - Unique Clients'),
(2004, 'Client Receipt'),
(2005, 'Client Registrations'),
(2006, 'Client Secret APP ID:'),
(2007, 'Client Type'),
(2008, 'Clients'),
(2009, 'Clinic'),
(2010, 'Clinic Copy'),
(2011, 'Clinic Daily Record'),
(2012, 'Clinic ID'),
(2013, 'Clinical'),
(2014, 'Clinical Decision Rules Alert Manager'),
(2015, 'Clinical documents are produced by arranging or limiting CDA elements in defined ways using templates and Implementation Guides (IG)'),
(2016, 'Clinical History'),
(2017, 'Clinical Instructions'),
(2018, 'Clinical Instructions Form'),
(2019, 'Clinical Notes Form'),
(2020, 'Clinical Plans'),
(2021, 'Clinical Quality Measures (CQM)'),
(2022, 'Clinical Quality Measures (CQM) - 2011'),
(2023, 'Clinical Quality Measures (CQM) - 2014'),
(2024, 'Clinical Reminders'),
(2025, 'Clinical Reminders - is a widget that displays the Passive Alerts for a Clinical Decision Rule'),
(2026, 'Clinical Reminders/Alerts (write,addonly optional)'),
(2027, 'Clinical Reminders/Alerts (write,addonly optional) (alert)'),
(2028, 'Clinical Reports'),
(2029, 'Clinical Rule Action Category'),
(2030, 'Clinical Rule Action Item'),
(2031, 'Clinical Rule Filter Methods'),
(2032, 'Clinical Rule Target Methods'),
(2033, 'Clinical Rules'),
(2034, 'Clinical Rules Age Intervals'),
(2035, 'Clinical Rules Comparisons'),
(2036, 'Clinical Rules Encounter Types'),
(2037, 'Clinical Rules Reminder Due Options'),
(2038, 'Clinical Rules Reminder Inactivation Options'),
(2039, 'Clinical Rules Reminder Intervals'),
(2040, 'Clinical Rules Reminder Methods'),
(2041, 'Clinical Rules Target Intervals'),
(2042, 'Clinical targets'),
(2043, 'Clinical Term'),
(2044, 'Clinical Term Code(s)'),
(2045, 'Clinical View'),
(2046, 'Clinicians'),
(2047, 'Clone'),
(2048, 'Clone Past Visit'),
(2049, 'Close'),
(2050, 'close'),
(2051, 'Close All Current Rx Panels and make this a Preference to stay closed'),
(2052, 'Close and make this a Preference to stay closed'),
(2053, 'Close form without saving answers'),
(2054, 'Close Patient Chart'),
(2055, 'Close this panel and delete this Rx'),
(2056, 'Close this panel and make this a Preference to stay closed'),
(2057, 'Close Window'),
(2058, 'close window'),
(2059, 'Close...'),
(2060, 'Closed'),
(2061, 'cm'),
(2062, 'CMS 1500 Form'),
(2063, 'CMS 1500 incl FORM'),
(2064, 'CMS 1500 Margins'),
(2065, 'CMS 1500 Margins Left'),
(2066, 'CMS 1500 Paper Form Format'),
(2067, 'CMS 1500 PDF'),
(2068, 'CMS 1500 PREPRINTED FORM'),
(2069, 'CMS 1500 TEXT'),
(2070, 'CMS 1500 was revised on 2012-02-01 and is hence called Form 1500 (02-12) and is set to expire on 2020-03-31. As of April 1, 2014 only the revised, 02-12 version is accepted.'),
(2071, 'CMS 1500: Box 31 Format'),
(2072, 'CMS 1500: Date in Box 31 (Signature)'),
(2073, 'CMS ID'),
(2074, 'CMS ID For Encounter Claims'),
(2075, 'CMS Margins Left'),
(2076, 'CMS Portal'),
(2077, 'CMS Portal Login'),
(2078, 'CMS Portal Login ID'),
(2079, 'CMS Portal not enabled!'),
(2080, 'CMS Portal Password'),
(2081, 'CMS Portal Request'),
(2082, 'CMS Portal Site Address'),
(2083, 'CMS Portal Username'),
(2084, 'Cmsportal Login'),
(2085, 'CMT{{Central Macular Thickness}}'),
(2086, 'CN VII{{cranial nerve seven}}'),
(2087, 'CN V{{cranial nerve five}}'),
(2088, 'CN2-12 intact'),
(2089, 'CN5{{cranial nerve five}}'),
(2090, 'CN7{{cranial nerve seven}}'),
(2091, 'Co Pay'),
(2092, 'Co Pay Paid'),
(2093, 'Co-managing/referring provider'),
(2094, 'Co-Pay'),
(2095, 'CO-PAY'),
(2096, 'Co-Payment'),
(2097, 'Code'),
(2098, 'code'),
(2099, 'Code Description'),
(2100, 'Code Finder'),
(2101, 'Code must be two letter lowercase'),
(2102, 'Code or symbol to indicate currency'),
(2103, 'Code Search'),
(2104, 'Code Text'),
(2105, 'Code Type'),
(2106, 'code type'),
(2107, 'Code type not recognized'),
(2108, 'Code type not yet defined'),
(2109, 'Code Types'),
(2110, 'Code(s)'),
(2111, 'Coded'),
(2112, 'Codes'),
(2113, 'Codes - Leave blank'),
(2114, 'Coding'),
(2115, 'Coding (click for education)'),
(2116, 'Coding - any encounters (write,wsome optional)'),
(2117, 'Coding - any encounters (write,wsome optional) (coding_a)'),
(2118, 'Coding - my encounters (write,wsome optional)'),
(2119, 'Coding - my encounters (write,wsome optional) (coding)'),
(2120, 'Coding complete'),
(2121, 'Coding done'),
(2122, 'Coding Engine'),
(2123, 'Coding not authorized'),
(2124, 'Coffee'),
(2125, 'Coffee Use'),
(2126, 'Cognitive'),
(2127, 'Coins'),
(2128, 'Coinsurance'),
(2129, 'Coll w/o'),
(2130, 'Collaborator'),
(2131, 'Collapse'),
(2132, 'collapse'),
(2133, 'Collapse All'),
(2134, 'Collapse all'),
(2135, 'collapse all'),
(2136, 'Collect For'),
(2137, 'Collect Payment'),
(2138, 'Collected'),
(2139, 'Collected By'),
(2140, 'Collection Date'),
(2141, 'Collection Date/Time'),
(2142, 'Collections'),
(2143, 'Collections Report'),
(2144, 'Colon Cancer'),
(2145, 'Colon Cancer Screening'),
(2146, 'Colon Cancer Surgery'),
(2147, 'Colonoscopy'),
(2148, 'colonoscopy'),
(2149, 'Color'),
(2150, 'Color for even sets (except when last set is even and all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed) or not all member appointments are displayed).'),
(2151, 'Color for odd sets (except when last set is odd and all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed) or not all member appointments are displayed).'),
(2152, 'Color for the last set when all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed).'),
(2153, 'Color for the last set when not all member appointments are displayed.'),
(2154, 'Color Vision'),
(2155, 'Color:Abbr'),
(2156, 'Column'),
(2157, 'Columns'),
(2158, 'Combine Reminders'),
(2159, 'Combining Lots'),
(2160, 'Comma'),
(2161, 'Comma-separated list of login names to use normal authentication instead of LDAP; useful for setup and debugging.'),
(2162, 'Comment'),
(2163, 'Comments'),
(2164, 'comments'),
(2165, 'Comments about change request'),
(2166, 'Comments are required'),
(2167, 'Comments field entry present'),
(2168, 'Comments for this result or recommendation'),
(2169, 'Commercial Insurance Co.'),
(2170, 'Commit Changes'),
(2171, 'Committed Changes'),
(2172, 'Committing changes. Please Wait'),
(2173, 'Commonly used standards are HOTP (hash-based one-time password, RFC4226), TOTP (time-based one-time password or OCRA (OATH challenge-response algorithm, RFC6287) that were developed and are supported by the OATH (Initiative for Open Authentication)'),
(2174, 'Communication'),
(2175, 'Communication Engine'),
(2176, 'Communications'),
(2177, 'Community health physician'),
(2178, 'Community Mental Health Center'),
(2179, 'Company'),
(2180, 'Company Name'),
(2181, 'Complete'),
(2182, 'Complete Visit Time'),
(2183, 'Completed'),
(2184, 'completed'),
(2185, 'Completed Ad'),
(2186, 'Completed?'),
(2187, 'Completely remove the ability to display the Patient Flow Board.'),
(2188, 'Completion Status'),
(2189, 'Complications by Service Provider'),
(2190, 'Complications of Abortion'),
(2191, 'Components'),
(2192, 'Compose Message'),
(2193, 'Compose new'),
(2194, 'Compose New Message'),
(2195, 'Compose Reply Message'),
(2196, 'Comprehensive'),
(2197, 'Comprehensive Inpatient Rehabilitation Facility'),
(2198, 'Comprehensive Outpatient Rehabilitation Facility'),
(2199, 'Compute'),
(2200, 'Computer Aided Medical Ordering System'),
(2201, 'Concerning the General category. After being assigned to an active view, the General template will always appear as a base template in portal Pending documents i.e no category and as Default in the dashboard view.'),
(2202, 'Conclusions'),
(2203, 'Condition'),
(2204, 'Condition field not found'),
(2205, 'Condition Status'),
(2206, 'Conditions'),
(2207, 'Confidential'),
(2208, 'Confidential apps are applications that are able to safely and securely store a secret. Browser based and many mobile applications do not satisfy this security constraint'),
(2209, 'Config'),
(2210, 'Configuration'),
(2211, 'Configuration Export/Import'),
(2212, 'Configuration saved successfully'),
(2213, 'Configure Apache and OpenEMR to use Client side SSL certificates.'),
(2214, 'Configure Apache to use Client side SSL certificates'),
(2215, 'Configure Apache to use HTTPS.'),
(2216, 'Configure Openemr to use Client side SSL certificates'),
(2217, 'Configure Orders and Results'),
(2218, 'Configure Orders Help'),
(2219, 'Configure the lab test structure'),
(2220, 'Configure tracks'),
(2221, 'Configure Tracks'),
(2222, 'Configuring Multiple Orders'),
(2223, 'Configuring multiple orders'),
(2224, 'Confirm'),
(2225, 'Confirm Create New Patient'),
(2226, 'Confirm Email Address'),
(2227, 'Confirm New Password'),
(2228, 'Confirm Password'),
(2229, 'Confirm Payment'),
(2230, 'Confirm to Delete Current Thread?'),
(2231, 'Confirm to Delete Selected?'),
(2232, 'Confirm to remove item'),
(2233, 'Confirm Username'),
(2234, 'Confirmed'),
(2235, 'Conflicted Allergies'),
(2236, 'Conflicted Medications'),
(2237, 'Conflicted Problems'),
(2238, 'Congenital'),
(2239, 'Congratulations for enabling 2FA'),
(2240, 'Conjuntiva, pupils'),
(2241, 'Conj{{Conjunctiva}}'),
(2242, 'Connection error'),
(2243, 'Connectors'),
(2244, 'Cons'),
(2245, 'Constant'),
(2246, 'Constant Name'),
(2247, 'constant name'),
(2248, 'Constant name is blank'),
(2249, 'constants'),
(2250, 'Constipation'),
(2251, 'Constitutional'),
(2252, 'Construction Firm'),
(2253, 'Consultant physician'),
(2254, 'Consultation Brief Description'),
(2255, 'Consultation Notes - 2008'),
(2256, 'Consumable'),
(2257, 'Consumable Only'),
(2258, 'Consumption'),
(2259, 'Contact'),
(2260, 'Contact Email'),
(2261, 'Contact Email Address'),
(2262, 'Contact EMR Direct to subscribe to the phiMail Direct messaging service'),
(2263, 'Contact https://online.wenoexchange.com to sign up for Weno Free eRx service.'),
(2264, 'contact info'),
(2265, 'Contact Information'),
(2266, 'Contact Lens'),
(2267, 'Contact Lens Refraction'),
(2268, 'Contact Lenses'),
(2269, 'Contact Medical Information Integration, LLC at http://mi-squared.com for Lab Exchange Service.'),
(2270, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing the eRx service'),
(2271, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing to the NewCrop eRx service.'),
(2272, 'Contact mi-squared at http://www.mi-squared.com/products-services/openemr/ or ZH Healthcare at https://blueehr.com/contact-us/ for subscribing to the NewCrop eRx service.'),
(2273, 'Contact name'),
(2274, 'Contact Open Med Practice, www.openmedpractice.com for subscribing to the Weno Free eRx service.'),
(2275, 'Contact or Notify Phone'),
(2276, 'Contact Person'),
(2277, 'Contact Phone'),
(2278, 'Contact Phone Number'),
(2279, 'Contact Relationship'),
(2280, 'Contact your Lab representative.'),
(2281, 'Contact ZMG, LLC (zmghealth@gmail.com) for subscribing the eRx service'),
(2282, 'Contacts'),
(2283, 'contain at least three of the four following items:'),
(2284, 'Container Group Name'),
(2285, 'Content'),
(2286, 'content'),
(2287, 'Contents'),
(2288, 'Context'),
(2289, 'Context name can\'t be empty'),
(2290, 'Continue'),
(2291, 'Continue Assessment'),
(2292, 'Continue completes selected billing option normally.'),
(2293, 'Continuity of Care Document'),
(2294, 'Continuity of Care Document (CCD)'),
(2295, 'Continuity of Care Document (CCD) is an electronic document containing patient specific information that aids in continuity of care'),
(2296, 'Continuity of Care Document (CCD) is meant to be created at the conclusion of an encounter prior to transfer of care to enable the next provider to easily access such information'),
(2297, 'Continuity of Care Record (CCR)'),
(2298, 'Contra Clients'),
(2299, 'Contraception'),
(2300, 'Contraception Form; Acceptors New to Modern Contraception'),
(2301, 'Contraception Issues'),
(2302, 'Contraceptive Complication (specify)'),
(2303, 'Contraceptive Method'),
(2304, 'Contraceptive Products'),
(2305, 'Contraceptive services previously started'),
(2306, 'Contraceptives Start'),
(2307, 'Contrast Acuity'),
(2308, 'Contrast Acuity Testing'),
(2309, 'Contrastart'),
(2310, 'Contrast{{Constrast Visual Acuity}}'),
(2311, 'Control ID'),
(2312, 'Control No.'),
(2313, 'Controlled Substance?'),
(2314, 'Convergence'),
(2315, 'Convergence Amps'),
(2316, 'Conversation'),
(2317, 'Conversation from'),
(2318, 'Convert a JavaScript object into a JSON string, and send it to the server.'),
(2319, 'Convert between plus and minus cylinder'),
(2320, 'Coordinating Counselors'),
(2321, 'COPAY'),
(2322, 'Copay'),
(2323, 'CoPay'),
(2324, 'Copay not positive'),
(2325, 'Copay Paid'),
(2326, 'Copays'),
(2327, 'COPD'),
(2328, 'Copy Left to Right'),
(2329, 'Copy OD{{right eye}} values to'),
(2330, 'Copy OS{{left eye}} values to'),
(2331, 'Copy Pages to Patient Chart'),
(2332, 'Copy Right to Left'),
(2333, 'Copy these values into current visit.'),
(2334, 'Copy to Layout...'),
(2335, 'Copy Values'),
(2336, 'Copying the database file. This will take some time...'),
(2337, 'Copyright Notice'),
(2338, 'Cor Disease'),
(2339, 'Core'),
(2340, 'Cornea'),
(2341, 'Cornish'),
(2342, 'Coronary Artery Bypass'),
(2343, 'Coronary Artery Bypass Graft (CABG)'),
(2344, 'Corrected'),
(2345, 'Corsican'),
(2346, 'CouchDB'),
(2347, 'CouchDB Connection Failed.'),
(2348, 'CouchDB Connection SSL'),
(2349, 'CouchDB Database'),
(2350, 'CouchDB database name'),
(2351, 'CouchDB Error Log'),
(2352, 'CouchDB error log is empty'),
(2353, 'CouchDB host'),
(2354, 'CouchDB HostName'),
(2355, 'CouchDB Log Enable'),
(2356, 'CouchDB Password'),
(2357, 'CouchDB Port'),
(2358, 'CouchDB port'),
(2359, 'CouchDB save failed'),
(2360, 'CouchDB SSL Allow Selfsigned Certificate'),
(2361, 'CouchDB UserName'),
(2362, 'Cough'),
(2363, 'Cough:'),
(2364, 'could not connect to server'),
(2365, 'Could not create directory for X12 partner '),
(2366, 'Could not find RxNorm Table! Please install.'),
(2367, 'Could not import the document. Please contact the EMR vendor.'),
(2368, 'could not install ACL'),
(2369, 'could not open table'),
(2370, 'Could not read file'),
(2371, 'Could not read the file'),
(2372, 'could not run sql query'),
(2373, 'Could not send email due to a server problem, '),
(2374, 'Could not send email due to a server problem.'),
(2375, 'Could not send email due to a server problem. '),
(2376, 'Couldn\'t create backup dir:'),
(2377, 'Couldn\'t remove dir:'),
(2378, 'Couldn\'t remove old backup file:'),
(2379, 'Couldn\'t remove old export file: '),
(2380, 'Coumadin Management - INR Monitoring'),
(2381, 'Couns by Method'),
(2382, 'Counseling'),
(2383, 'Counseling activities'),
(2384, 'Counselors'),
(2385, 'Counter Referral Form'),
(2386, 'COUNTER REFERRAL FORM'),
(2387, 'Counter-Referral'),
(2388, 'Country'),
(2389, 'Country Code'),
(2390, 'Country Data Type'),
(2391, 'Country list'),
(2392, 'Country List (write,addonly optional)'),
(2393, 'Country List (write,addonly optional) (country)'),
(2394, 'Country Name should be represent in two letters. (Example: United States is US)'),
(2395, 'county'),
(2396, 'County'),
(2397, 'Coupon'),
(2398, 'Course'),
(2399, 'Cousin'),
(2400, 'Coverage Level'),
(2401, 'Coverage Period'),
(2402, 'Coverage Type'),
(2403, 'CPOE'),
(2404, 'CPT'),
(2405, 'CPT Code'),
(2406, 'CPT Codes'),
(2407, 'CPT4 Procedure/Service'),
(2408, 'CPTII Performance Measures'),
(2409, 'CQM'),
(2410, 'CQM (Mixed Types) Value Set'),
(2411, 'CR (Wet)'),
(2412, 'Crackles:'),
(2413, 'Cranial Nerve 5: Trigeminal Nerve'),
(2414, 'Cranial Nerve 7: Facial Nerve'),
(2415, 'cream'),
(2416, 'Create'),
(2417, 'Create a Client side SSL certificate for each user or client machine.'),
(2418, 'Create a client side SSL certificate for either a user or a client hostname.'),
(2419, 'CREATE A COUNTER-REFERRAL'),
(2420, 'Create A Dated Reminder'),
(2421, 'CREATE A LOCATION FOR RESULTS'),
(2422, 'Create a new track'),
(2423, 'CREATE A REFERRAL'),
(2424, 'Create a reminder to schedule a future visit'),
(2425, 'Create a reminder to schedule a future visit.'),
(2426, 'CREATE A SIMPLE TRANSACTION TYPE'),
(2427, 'Create a spreadsheet in openoffice/LibreOffice, have 5 columns - CPT Code, Description, Standard, Credit Card and Cash. Fill in the values. From this spreadsheet manually copy and paste the values via Administration > Codes'),
(2428, 'CREATE A TOP LEVEL CUSTOM GROUP'),
(2429, 'CREATE A TOP LEVEL ENTRY'),
(2430, 'Create an Event'),
(2431, 'CREATE AN ORDER'),
(2432, 'Create an Order for a Panel of Tests'),
(2433, 'Create an Order for a Single Test'),
(2434, 'Create and download a full backup'),
(2435, 'Create and modify tracks'),
(2436, 'Create Backup'),
(2437, 'Create batch'),
(2438, 'Create Client Certificate'),
(2439, 'Create Client side SSL certificates'),
(2440, 'Create custom white list of MIME content type of a files to secure your documents system'),
(2441, 'Create Date'),
(2442, 'Create Duplicate'),
(2443, 'Create Encounter'),
(2444, 'Create Eventlog Backup'),
(2445, 'Create follow-up encounter'),
(2446, 'Create new issue'),
(2447, 'Create New Message'),
(2448, 'Create New Patient'),
(2449, 'Create New Referral'),
(2450, 'Create new Track'),
(2451, 'Create New Transaction'),
(2452, 'Create Offsite Portal Credentials'),
(2453, 'Create Online Portal Credentials'),
(2454, 'Create Onsite Portal Credentials'),
(2455, 'Create Patient'),
(2456, 'Create Patient Note'),
(2457, 'CREATE THE CUSTOM ORDERS'),
(2458, 'Create the SSL Certificate Authority and Server certificates.'),
(2459, 'Create Visit'),
(2460, 'Created'),
(2461, 'Created Definitions'),
(2462, 'Created Definitions List'),
(2463, 'Creates a report that contains various sections of the patient\'s medical record'),
(2464, 'Creating a Custom Favorite Group to order frequently ordered tests together '),
(2465, 'Creating a Custom Group of Tests as Favorites'),
(2466, 'CREATING A NEW DATED REMINDER'),
(2467, 'CREATING A NEW MESSAGE'),
(2468, 'Creating and Managing Encounters'),
(2469, 'Creating anyway'),
(2470, 'Creating export file'),
(2471, 'Creating new track failed'),
(2472, 'Creating this file on remote host failed'),
(2473, 'Creator'),
(2474, 'Credentials Reset. Below link is only valid for one hour.'),
(2475, 'credit'),
(2476, 'Credit'),
(2477, 'Credit Card'),
(2478, 'Credit Card Pay'),
(2479, 'Credit Card Pay in Person'),
(2480, 'Credit Card Pay over Phone'),
(2481, 'Credit Charge'),
(2482, 'Credit or Debit Card'),
(2483, 'Credits'),
(2484, 'Cree'),
(2485, 'Criteria'),
(2486, 'Criteria Actions'),
(2487, 'Croatian'),
(2488, 'Crohn\'s Disease'),
(2489, 'Crohns Disease'),
(2490, 'crt_user'),
(2491, 'CR{{Cycloplegic Refraction}}'),
(2492, 'CSV'),
(2493, 'CSV Export'),
(2494, 'CSV File'),
(2495, 'CSV Tables'),
(2496, 'CSV to calendar_external table'),
(2497, 'CTL'),
(2498, 'CTL{{Contact Lens Vision}}'),
(2499, 'CTL{{Contact Lens}}'),
(2500, 'CU.MM'),
(2501, 'Cuban'),
(2502, 'Cup'),
(2503, 'Currency Decimal Places'),
(2504, 'Currency Decimal Point Symbol'),
(2505, 'Currency Designator'),
(2506, 'Currency Thousands Separator'),
(2507, 'Current'),
(2508, 'Current Alcohol'),
(2509, 'Current Authentication Method for'),
(2510, 'Current Authentication Method for the logged in user'),
(2511, 'Current Charges'),
(2512, 'Current Consultation'),
(2513, 'Current Criteria'),
(2514, 'Current Day'),
(2515, 'Current day highlight color'),
(2516, 'Current every day smoker'),
(2517, 'Current Eye Meds'),
(2518, 'Current file name was changed to'),
(2519, 'Current Glasses'),
(2520, 'Current Hash'),
(2521, 'Current Location'),
(2522, 'Current Logged in User'),
(2523, 'Current Medications'),
(2524, 'Current on record trusted email'),
(2525, 'Current Password'),
(2526, 'Current password to authorize changes.'),
(2527, 'Current Patient'),
(2528, 'Current Patient Only'),
(2529, 'Current patient unavailable here. Use Patient Documents'),
(2530, 'Current Physician'),
(2531, 'Current Provider'),
(2532, 'Current Pt Only'),
(2533, 'Current Recipients'),
(2534, 'Current Recreational Drugs'),
(2535, 'Current RX'),
(2536, 'Current some day smoker'),
(2537, 'Current Status'),
(2538, 'Current Status Time'),
(2539, 'Current Target'),
(2540, 'Current trusted email address on record.'),
(2541, 'Current user'),
(2542, 'Current Value'),
(2543, 'Current Working Procedure Diagnoses'),
(2544, 'Currently Active'),
(2545, 'Currently Busy'),
(2546, 'Currently Busy{{Service}}'),
(2547, 'Currently off-line'),
(2548, 'Currently Running'),
(2549, 'Currently there are 5 types of transactions in OpenEMR'),
(2550, 'Currently there are no facilities.'),
(2551, 'Currently working on making this document'),
(2552, 'Cushing Syndrom'),
(2553, 'Cushing Syndrome'),
(2554, 'Custodial Care Facility'),
(2555, 'Custodian'),
(2556, 'Custom'),
(2557, 'Custom Billing Phone Number'),
(2558, 'Custom Checkout Receipt'),
(2559, 'Custom Favorite Group - to group individual tests '),
(2560, 'Custom Favorite Group > Custom Favorite Item > Discrete results'),
(2561, 'Custom Favorite Group and Custom Favorite Item is used to create customized groups of orders'),
(2562, 'Custom Favorite Item  - for individual orders or tests'),
(2563, 'Custom Greeting'),
(2564, 'Custom input?'),
(2565, 'Custom Order'),
(2566, 'Custom Report'),
(2567, 'Custom Statement message'),
(2568, 'Custom Sub Group'),
(2569, 'Custom Table'),
(2570, 'Custom text for Flow Board postcards. After changing text, print samples before printing mass quantities!'),
(2571, 'Custom Top Group'),
(2572, 'Customer'),
(2573, 'Customers in Checkout and Receipt'),
(2574, 'Customize the Fee Sheet'),
(2575, 'Customize the Transaction Form'),
(2576, 'CVV'),
(2577, 'Cvx Code'),
(2578, 'CVX Code'),
(2579, 'CVX Code Mapping'),
(2580, 'CVX Immunization'),
(2581, 'CV{{Cardiovascular}}'),
(2582, 'Cycle'),
(2583, 'Cyclo 1%'),
(2584, 'CycloMydril'),
(2585, 'Cycloplegic (Wet) Refraction'),
(2586, 'Cyl{{Cylinder}}'),
(2587, 'CYL{{Cylinder}}'),
(2588, 'CYP'),
(2589, 'CYP Factor'),
(2590, 'CYP Report'),
(2591, 'CYP statistical reports.'),
(2592, 'CYP Statistics Reporting'),
(2593, 'Czech'),
(2594, 'D'),
(2595, 'D&C'),
(2596, 'D&E'),
(2597, 'D&V Full OU{{Ductions and Versions full both eyes}}'),
(2598, 'D.O.B.'),
(2599, 'daily'),
(2600, 'Daily Record'),
(2601, 'Daily Report'),
(2602, 'Daily statistical reports.'),
(2603, 'Daily Statistics Reporting'),
(2604, 'Daily Summary Report'),
(2605, 'Danish'),
(2606, 'Dashboard'),
(2607, 'Dashboard - summarizes all patient related information'),
(2608, 'Dashboard{{patient file}}'),
(2609, 'Data Alike is already in database, please change code and/or description'),
(2610, 'Data Alike is already in database, please change constant name'),
(2611, 'Data Cols'),
(2612, 'Data Enterer'),
(2613, 'Data Entry - Social Security Number'),
(2614, 'Data Error'),
(2615, 'Data from'),
(2616, 'Data integrity has been compromised'),
(2617, 'data of all encounters so far'),
(2618, 'Data Section'),
(2619, 'Data Type'),
(2620, 'Database'),
(2621, 'Database and Access Control upgrade finished.'),
(2622, 'Database is not installed.'),
(2623, 'Database name'),
(2624, 'Database Patch'),
(2625, 'Database Reporting'),
(2626, 'Database Reporting (database)'),
(2627, 'Database upgrade finished.'),
(2628, 'DataCols must be a number between 1 and 999'),
(2629, 'Date'),
(2630, 'date'),
(2631, 'DATE'),
(2632, 'Date & Time Administered'),
(2633, 'Date / Time'),
(2634, 'Date Administered'),
(2635, 'Date and time of sample collection'),
(2636, 'Date and time of this observation'),
(2637, 'Date and time of this report'),
(2638, 'Date and time that the sample was collected'),
(2639, 'Date Cannot be greater than Today'),
(2640, 'Date contraceptive services initially provided'),
(2641, 'Date Created'),
(2642, 'Date Deceased'),
(2643, 'Date Destroyed'),
(2644, 'Date Display Format'),
(2645, 'Date format for \"appointment end\" is not valid'),
(2646, 'Date format for \"appointment start\" is not valid'),
(2647, 'Date format for \"Next Appointment\" is not valid'),
(2648, 'Date format for \"not seen since\" is not valid'),
(2649, 'Date format for \"seen before\" is not valid'),
(2650, 'Date format for \"seen since\" is not valid'),
(2651, 'Date Immunization Information Statements Given'),
(2652, 'Date is missing for code '),
(2653, 'Date Master Criteria'),
(2654, 'Date of appointments'),
(2655, 'Date of appointments mm/dd/yyyy'),
(2656, 'Date of bank deposit yyyy-mm-dd'),
(2657, 'Date of Billing'),
(2658, 'Date of Birth'),
(2659, 'Date of birth'),
(2660, 'Date Of Birth'),
(2661, 'Date of Birth and Age'),
(2662, 'Date of Birth Missing'),
(2663, 'Date of Entry'),
(2664, 'Date of exit'),
(2665, 'Date of Injury'),
(2666, 'Date of Onset'),
(2667, 'Date of onset or hospitalization'),
(2668, 'Date of onset, surgery or start of medication'),
(2669, 'Date of payment yyyy-mm-dd'),
(2670, 'Date of recovery or end of medication'),
(2671, 'Date of referral'),
(2672, 'Date of registration'),
(2673, 'Date of reply'),
(2674, 'Date of Report'),
(2675, 'Date of Service'),
(2676, 'Date of service'),
(2677, 'Date Of Service'),
(2678, 'Date of Service = Today'),
(2679, 'Date of Service is today\'s date by default. If needed it can be changed to any valid date'),
(2680, 'Date of service mm/dd/yyyy'),
(2681, 'Date of Service:'),
(2682, 'Date Of Signature'),
(2683, 'Date of Status Change'),
(2684, 'Date of this letter'),
(2685, 'Date of this order'),
(2686, 'Date of this report'),
(2687, 'Date of VIS Statement'),
(2688, 'Date Ordered'),
(2689, 'Date Range'),
(2690, 'Date Registered'),
(2691, 'Date Selector'),
(2692, 'Date selector'),
(2693, 'Date Sent'),
(2694, 'Date The Message Was Sent'),
(2695, 'Date Time'),
(2696, 'Date Updated'),
(2697, 'Date values Cannot be Blank.'),
(2698, 'Date VIS Presented'),
(2699, 'Date VIS Published'),
(2700, 'Date/Appt'),
(2701, 'Date/Notes'),
(2702, 'Date/Notes of Last'),
(2703, 'Date/Time'),
(2704, 'Date:'),
(2705, 'Dated'),
(2706, 'dated'),
(2707, 'Dated Message Log'),
(2708, 'Dated Reminders'),
(2709, 'Dated reminders maximum alerts to show'),
(2710, 'Day'),
(2711, 'day'),
(2712, 'day ago'),
(2713, 'Day Sheet Report'),
(2714, 'Day View'),
(2715, 'Day(s)'),
(2716, 'Day(s) M-F'),
(2717, 'days'),
(2718, 'Days'),
(2719, 'days ago'),
(2720, 'Days and Games Missed'),
(2721, 'Days From Last Encounter'),
(2722, 'Days Missed'),
(2723, 'days of each other'),
(2724, 'Days Of Week'),
(2725, 'Days per Column:'),
(2726, 'Days/Col'),
(2727, 'Days/Col:'),
(2728, 'DB installed'),
(2729, 'DD/MM/YYYY'),
(2730, 'De Identification'),
(2731, 'De Identification Process is completed'),
(2732, 'De Identification Process is ongoing'),
(2733, 'De Identification process is started and running in background'),
(2734, 'De Identified data may not be complete'),
(2735, 'De-identification files will be saved in'),
(2736, 'DEA'),
(2737, 'DEA Number'),
(2738, 'DEA number'),
(2739, 'Deactivate'),
(2740, 'Deactivated'),
(2741, 'Deadline (CST)'),
(2742, 'Deaf'),
(2743, 'Debt'),
(2744, 'Debug Error Logging'),
(2745, 'Debug Hash Verification Time'),
(2746, 'Debug Information'),
(2747, 'DEBUG OUTPUT'),
(2748, 'Debugging'),
(2749, 'Dec'),
(2750, 'Deceased'),
(2751, 'DECEASED'),
(2752, 'DECEASED (1 day ago)'),
(2753, 'DECEASED (Today)'),
(2754, 'Deceased Date'),
(2755, 'Deceased Date should not be greater than Today'),
(2756, 'DECEASED NOTIFICATION'),
(2757, 'Deceased Reason'),
(2758, 'December'),
(2759, 'Decide on the code categories and the order you want them to appear, these will be displayed on the buttons in the \'Select Codes\' section'),
(2760, 'Decide on the Identifying Codes and Standard Codes, remember the Identifying code has to be unique to ensure proper display of results'),
(2761, 'Decide whether or not you will want to order individual tests which are a part of a panel of tests'),
(2762, 'Decimal pounds or pounds and ounces separated by #(e.g. 5#4)'),
(2763, 'Declined To Specify'),
(2764, 'Deductible'),
(2765, 'Deductible Met'),
(2766, 'deep'),
(2767, 'Default'),
(2768, 'Default - Check any check box and this value will show up in the displayed drop-down box as the default value'),
(2769, 'Default Adjust Type'),
(2770, 'Default Calendar View'),
(2771, 'Default Customer'),
(2772, 'Default Eligibility X12 Partner'),
(2773, 'Default Encounter Form ID'),
(2774, 'Default Encounter View'),
(2775, 'Default Exam Values'),
(2776, 'Default Facility'),
(2777, 'Default font'),
(2778, 'Default font (need to logout/login after change this setting)'),
(2779, 'Default font size'),
(2780, 'Default font size (need to logout/login after change this setting)'),
(2781, 'Default Language'),
(2782, 'Default language if no other is allowed or chosen.'),
(2783, 'Default left print margin for CMS 1500'),
(2784, 'Default left print margin for UB04'),
(2785, 'Default List (write,addonly optional)'),
(2786, 'Default List (write,addonly optional) (default)'),
(2787, 'Default Method'),
(2788, 'Default Password Expiration Days'),
(2789, 'Default password expiration period in days. 0 means this feature is disabled.'),
(2790, 'Default Patient Country'),
(2791, 'Default Patient Country sent to NewCrop eRx, only if patient country is not set.'),
(2792, 'Default Patient Templates'),
(2793, 'Default Price Level'),
(2794, 'Default Priority'),
(2795, 'Default Procedure Type'),
(2796, 'Default Provider'),
(2797, 'Default provider changed'),
(2798, 'Default Range'),
(2799, 'Default Reason for Visit'),
(2800, 'Default Rendering Provider in Fee Sheet'),
(2801, 'Default Search Code Type'),
(2802, 'Default Second Tab'),
(2803, 'Default selection for rendering provider in fee sheet.'),
(2804, 'Default Setting'),
(2805, 'Default Sort Direction'),
(2806, 'Default state of New Window checkbox in the patient list.'),
(2807, 'Default Template'),
(2808, 'Default to a provider for line item in the fee sheet'),
(2809, 'Default to a provider for line item in the fee sheet.(only applicable if Support line item billing in option above)'),
(2810, 'Default to previous value'),
(2811, 'Default top print margin for CMS 1500'),
(2812, 'Default top print margin for UB04'),
(2813, 'Default Units'),
(2814, 'Default Units and Range as appropriate'),
(2815, 'Default Value'),
(2816, 'Default Values'),
(2817, 'Default Visit Category'),
(2818, 'Default Warehouse'),
(2819, 'Default X12 Partner'),
(2820, 'Default/Global'),
(2821, 'Default: Checked. When checked, messages are processed for patients with Patient Demographic Choice (Phone/Text/Email) set to \'Unassigned\' or \'Yes\'. If this is unchecked, a given type of message can only be sent if its Demographic Choice = \'Yes\'.'),
(2822, 'Defaults'),
(2823, 'Define a default visit category'),
(2824, 'Define lab service locations'),
(2825, 'Definition Exists'),
(2826, 'Definition Not Updated'),
(2827, 'Del'),
(2828, 'del'),
(2829, 'Delayed Recurrence (> 12 Mo)'),
(2830, 'Delete'),
(2831, 'delete'),
(2832, 'Delete Categories with ID(s) : '),
(2833, 'Delete Category'),
(2834, 'Delete Document'),
(2835, 'Delete Encounter Form'),
(2836, 'Delete failed!'),
(2837, 'Delete Group'),
(2838, 'Delete List'),
(2839, 'Delete Log Entries'),
(2840, 'Delete Onsite Portal Activity'),
(2841, 'Delete OS{{left eye}} values'),
(2842, 'Delete Pages'),
(2843, 'Delete Patient, Encounter, Form, Issue, Document, Payment, Billing or Transaction'),
(2844, 'Delete Plan'),
(2845, 'Delete Row'),
(2846, 'Delete Selected Items'),
(2847, 'Delete Selected Requests'),
(2848, 'Delete Successful'),
(2849, 'Delete successful.'),
(2850, 'Delete this document'),
(2851, 'Delete this form'),
(2852, 'Delete this message'),
(2853, 'Delete this note'),
(2854, 'Deleted Successfully'),
(2855, 'Deleted Successfully.'),
(2856, 'Deleting'),
(2857, 'Deleting this event cannot be undone. It cannot be recovered once it is gone. Are you sure you wish to delete this event?'),
(2858, 'Deletion failed because group has appointments or encounters'),
(2859, 'Delivered'),
(2860, 'Delivery Confirmed'),
(2861, 'Delivery is not allowed to the specified Direct Address.'),
(2862, 'Delivery is not allowed to the specified Direct Address:'),
(2863, 'Delivery is not currently permitted to the specified Direct Address.'),
(2864, 'Delivery of the attached clinical document was requested by the patient'),
(2865, 'Delivery of the attached clinical document was requested by the patient.'),
(2866, 'Dementia'),
(2867, 'Demographic changes made here are recorded system-wide'),
(2868, 'Demographics'),
(2869, 'Demographics (write,addonly optional)'),
(2870, 'Demographics (write,addonly optional) (demo)'),
(2871, 'Demographics - patient demographics and insurance information'),
(2872, 'Demographics Fields'),
(2873, 'Demographics filter criteria'),
(2874, 'Demographics Legend Red: Charted Values. Blue: Patient Edits'),
(2875, 'Demographics not authorized'),
(2876, 'Demographics not authorized.'),
(2877, 'Denied'),
(2878, 'denies'),
(2879, 'Denominator'),
(2880, 'Denominator Exception'),
(2881, 'Denominator Exclusion'),
(2882, 'Dental'),
(2883, 'Dental Issue List'),
(2884, 'Dental Issues'),
(2885, 'Dep Date'),
(2886, 'Dependency Modules'),
(2887, 'Dependency Problem'),
(2888, 'Depending on the level of access you can View/Edit the Transaction'),
(2889, 'Depending on the type of bill you are testing you will see HCFA like output on a blank page for HCFA bills, you will see many lines of somewhat garbled text  and information if you are testing an X12 claim. That garbled text is the X12 EDI 4010A format. Occasionally you will see odd characters that look like dominoes or  squiglies, these are control characters such as page feeds and are normal.'),
(2890, 'Depending on whether or not NewCrop eRx module is enabled the method of entry will vary'),
(2891, 'Deposit Date'),
(2892, 'Deposit Date Cannot be greater than Today'),
(2893, 'Deposit Date:'),
(2894, 'Depressed'),
(2895, 'Depression'),
(2896, 'Dept'),
(2897, 'Dermatology'),
(2898, 'Derm{{dermatologic}}'),
(2899, 'DERM{{Dermatology}}'),
(2900, 'DESC'),
(2901, 'Description'),
(2902, 'description'),
(2903, 'Description is default text'),
(2904, 'Description is Placeholder'),
(2905, 'Description of the Disclosure'),
(2906, 'Description of this procedure or result code'),
(2907, 'Description Translation'),
(2908, 'Desired Filename'),
(2909, 'Destination'),
(2910, 'Destination Filename'),
(2911, 'Destination Warehouse'),
(2912, 'Destroy'),
(2913, 'Destroy Lot'),
(2914, 'Destroy...'),
(2915, 'Destroyed'),
(2916, 'Destroyed Drugs'),
(2917, 'Destroyed Drugs Report'),
(2918, 'Destruction'),
(2919, 'Detail'),
(2920, 'Detail\'s group was saved successfully'),
(2921, 'Detailed exam'),
(2922, 'Detailed HPI'),
(2923, 'Detailed information on how to setup and troubleshoot phiMail messages is available here'),
(2924, 'Details'),
(2925, 'Details Not Available'),
(2926, 'Developer'),
(2927, 'Developer error missing form \'patientForm\''),
(2928, 'Developer error missing hidden form element \'selectedPatient\''),
(2929, 'Developer error. Patient id is missing from dataset'),
(2930, 'Developmental abnormality'),
(2931, 'Deviation'),
(2932, 'DI (Device Identifier)'),
(2933, 'Diabetes'),
(2934, 'Diabetes Mellitus'),
(2935, 'Diabetes: Blood Pressure Management (CQM)'),
(2936, 'Diabetes: Eye Exam'),
(2937, 'Diabetes: Eye Exam (CQM)'),
(2938, 'Diabetes: Foot Exam'),
(2939, 'Diabetes: Foot Exam (CQM)'),
(2940, 'Diabetes: HbA1c Poor Control (CQM)'),
(2941, 'Diabetes: Hemoglobin A1C'),
(2942, 'Diabetes: LDL Management & Control (CQM)'),
(2943, 'Diabetes: Urine Microalbumin'),
(2944, 'Diag'),
(2945, 'Diagnoses'),
(2946, 'Diagnosis'),
(2947, 'Diagnosis Code'),
(2948, 'Diagnosis Codes'),
(2949, 'Diagnosis Codes History'),
(2950, 'Diagnosis Date'),
(2951, 'Diagnosis Description'),
(2952, 'Diagnosis must be coded into a linked encounter'),
(2953, 'Diagnosis Name'),
(2954, 'Diagnosis Report'),
(2955, 'Diagnosis Reporting'),
(2956, 'Diagnosis Reporting Only'),
(2957, 'Diagnosis Title'),
(2958, 'Diagnosis:'),
(2959, 'Diagnosis: '),
(2960, 'Diagnostic'),
(2961, 'Diagnostic Tests:'),
(2962, 'Diagnostics'),
(2963, 'Dials'),
(2964, 'Diam{{Diameter}}'),
(2965, 'DIAM{{Diameter}}'),
(2966, 'Diaphragms/Caps'),
(2967, 'Diarrhea'),
(2968, 'Diastolic'),
(2969, 'Dicom Viewer'),
(2970, 'Dictation'),
(2971, 'Dictation: '),
(2972, 'Did you receive a copy of the HIPAA Notice?'),
(2973, 'Difference'),
(2974, 'Difficulty working etc.'),
(2975, 'Diffuse:'),
(2976, 'Digitally Signed'),
(2977, 'Dilated with'),
(2978, 'Dilation'),
(2979, 'Dilation orders/risks reviewed'),
(2980, 'Dilation Time'),
(2981, 'Dim'),
(2982, 'Direct'),
(2983, 'DIRECT ADDRESS'),
(2984, 'Direct Address'),
(2985, 'Direct Email'),
(2986, 'Direct Mail'),
(2987, 'Direct Message Log'),
(2988, 'Direct Message Received.'),
(2989, 'Direct messaging is currently unavailable.'),
(2990, 'Direct Messaging Send Failure.'),
(2991, 'Directions'),
(2992, 'Directives'),
(2993, 'Director Name'),
(2994, 'Directory delete failed; continuing.'),
(2995, 'Disability'),
(2996, 'Disable'),
(2997, 'Disable Auto Adjustment Calculations in EOB Posting'),
(2998, 'Disable Auto Adjustments'),
(2999, 'Disable automatically calculating balance adjustments for invoice posting'),
(3000, 'Disable Calendar'),
(3001, 'Disable Chart Tracker'),
(3002, 'Disable Client'),
(3003, 'Disable Help Modal'),
(3004, 'Disable Immunizations'),
(3005, 'Disable Insurance Eligibility Reports Download'),
(3006, 'Disable Old Metric Vitals Form'),
(3007, 'Disable Patient Flow Board'),
(3008, 'Disable phiMail Test Mode'),
(3009, 'Disable phpMyAdmin'),
(3010, 'Disable Prescriptions'),
(3011, 'Disable the restriction of only one IPPF code per MA code in superbill'),
(3012, 'Disable User Groups'),
(3013, 'disabled'),
(3014, 'Disabled'),
(3015, 'Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)'),
(3016, 'Disabled Client'),
(3017, 'Disabling automatic checking would be appropriate if message checking is managed through another mechanism, such as a system cron job'),
(3018, 'Disadvantages being cost of device, potential for loss and running out of battery power'),
(3019, 'Disc'),
(3020, 'DISC'),
(3021, 'Discard'),
(3022, 'Discarded'),
(3023, 'Discharge'),
(3024, 'Discharge Disposition'),
(3025, 'Discharge From Urethra'),
(3026, 'Discharge Medications'),
(3027, 'Discharge Right'),
(3028, 'Discharge Right:'),
(3029, 'Discharge Summary'),
(3030, 'Discharge Summary - 2009'),
(3031, 'Discharge Time'),
(3032, 'Discharged'),
(3033, 'Disclaimer'),
(3034, 'Disclosure Info'),
(3035, 'Disclosure Type'),
(3036, 'Disclosure Types'),
(3037, 'Disclosures'),
(3038, 'Disclosures (write,addonly optional)'),
(3039, 'Disclosures (write,addonly optional) (disclosure)'),
(3040, 'Disclosures - Record disclosures made for treatment, payment, and health care operations with date, time, patient identification (name or number), user identification (name or number), and a description of the disclosure'),
(3041, 'Discontinue'),
(3042, 'Discount'),
(3043, 'Discount Amount'),
(3044, 'Discount Level'),
(3045, 'Discount Percentage'),
(3046, 'Discount/Adjustment'),
(3047, 'Discounts as Monetary Amounts'),
(3048, 'Discounts at checkout time are entered as money amounts, as opposed to percentage.'),
(3049, 'Discounts at checkout time may be entered per invoice or per line item or both.'),
(3050, 'Discrete Result'),
(3051, 'Discrete Results - for manual entry of returned result values'),
(3052, 'Disease'),
(3053, 'Disease with presumed immunity'),
(3054, 'Dislay main menu logo'),
(3055, 'Dislocation'),
(3056, 'Dismiss'),
(3057, 'Dismiss Form'),
(3058, 'Dismiss Help'),
(3059, 'Disp #'),
(3060, 'Dispatch'),
(3061, 'Dispatch Received Document'),
(3062, 'Dispense Rx'),
(3063, 'Dispense this Rx'),
(3064, 'Dispense this RX'),
(3065, 'Dispensed'),
(3066, 'Display'),
(3067, 'Display Additional measurements (Ks, IOL cals, etc)'),
(3068, 'Display advance directives in the demographics page.'),
(3069, 'Display Application Errors Only'),
(3070, 'Display Documents'),
(3071, 'Display event dates in block?'),
(3072, 'Display Format for US Weights'),
(3073, 'Display how many events?'),
(3074, 'Display Invoice Number or Patient Name in the Cash Receipt Report'),
(3075, 'Display Invoice Number or Patient Name or Both in the Sales Report'),
(3076, 'Display limit reached'),
(3077, 'Display links to the acknowledgements page'),
(3078, 'Display location in block?'),
(3079, 'Display main menu logo'),
(3080, 'Display Name'),
(3081, 'Display Save and Close Visit button in LBFs'),
(3082, 'Display the Autorefraction Panel'),
(3083, 'Display the calendar?'),
(3084, 'Display the Contact Lens Panel'),
(3085, 'Display the Donations link on the About page'),
(3086, 'Display the Encounter Billing Note or Patient Billing Note or Both in the Billing Screen.'),
(3087, 'Display the Manifest Refraction panel'),
(3088, 'Display the patient\'s current glasses'),
(3089, 'Display the recurrent appointment widget in the patient summary.'),
(3090, 'Display the Review link on the About page'),
(3091, 'Display the Units Column on the Billing Screen'),
(3092, 'Display today\'s events in the block?'),
(3093, 'Display topic in block?'),
(3094, 'Display upcoming events in block?'),
(3095, 'Display Window Errors Only'),
(3096, 'Displayed Columns'),
(3097, 'Displaying the following number of most recent disclosures:'),
(3098, 'Displaying the following number of most recent messages'),
(3099, 'Displaying the following number of most recent notes'),
(3100, 'Displaying the following number of most recent notes:'),
(3101, 'Distance'),
(3102, 'Distance from the \'top\' of the envelope in mm'),
(3103, 'Distance from the right most edge of the envelope in portrait position in mm'),
(3104, 'Distribute'),
(3105, 'Distributed Edits'),
(3106, 'Distributed to Global'),
(3107, 'Distribution'),
(3108, 'Distributions'),
(3109, 'Distributor'),
(3110, 'Dist{{distance}}'),
(3111, 'Divehi- Dhivehi- Maldivian-'),
(3112, 'Divergence'),
(3113, 'Divergence Amps'),
(3114, 'Diverticulitis'),
(3115, 'Diverticulitis Surgery'),
(3116, 'Divirticulitis'),
(3117, 'Divirticulitis Surgery'),
(3118, 'Divorced'),
(3119, 'Dizziness:'),
(3120, 'Do not allow insurance eligibility report log download'),
(3121, 'Do not allow SQL queries to be outputted to screen.'),
(3122, 'Do not change'),
(3123, 'Do not display Allergies uploaded after visiting NewCrop eRx.'),
(3124, 'Do not display Allergy uploaded to NewCrop'),
(3125, 'Do not display Medications uploaded after visiting NewCrop eRx.'),
(3126, 'Do not display Medications uploaded to NewCrop'),
(3127, 'Do not display NewCrop eRx Allergy uploaded'),
(3128, 'Do not display NewCrop eRx Medications uploaded'),
(3129, 'Do not display the calendar.'),
(3130, 'Do not display the patient flow board.'),
(3131, 'Do not display the Recall Board.'),
(3132, 'Do not enter the server URL into your browser address bar, as this will not work'),
(3133, 'Do not inventory and sell any products'),
(3134, 'Do not know what to do!'),
(3135, 'Do Not Print'),
(3136, 'Do not require patient notes to be authorized'),
(3137, 'Do Not Resuscitate Order'),
(3138, 'do not save'),
(3139, 'do not substitute'),
(3140, 'Do Not Use Safe Apostrophe'),
(3141, 'Do not warn or prevent web browser refresh'),
(3142, 'do nothing'),
(3143, 'Do Nothing'),
(3144, 'Do you really want to change Warehouse?'),
(3145, 'Do you really want to clear the log?'),
(3146, 'Do You Really Want to Continue'),
(3147, 'Do you really want to delete'),
(3148, 'Do you really want to delete the selection?'),
(3149, 'Do you really want to delete this group'),
(3150, 'Do you really want to delete?'),
(3151, 'Do you really want to submit with no criteria selected?'),
(3152, 'Do you want to close the tabs?'),
(3153, 'Do you want to continue?'),
(3154, 'Do you want to delete this?'),
(3155, 'Do you want to delete?'),
(3156, 'Do you want to remove this record?'),
(3157, 'Do you wish to continue adding this new patient?'),
(3158, 'Do you wish to continue with the new name?'),
(3159, 'Do you wish to PERMANENTLY delete this immunization record?'),
(3160, 'DOB'),
(3161, 'Dob'),
(3162, 'DOB is missing, please enter if possible'),
(3163, 'Doc Id'),
(3164, 'Docs'),
(3165, 'Doctor'),
(3166, 'Doctor:'),
(3167, 'Doctor\'s name and signature'),
(3168, 'Document'),
(3169, 'document'),
(3170, 'document 3 and their status to reach the detailed HPI level'),
(3171, 'Document Categories'),
(3172, 'Document category for lab results does not exist'),
(3173, 'Document category name for storage of electronically received lab results.'),
(3174, 'Document category name for storage of electronically received MDM documents.'),
(3175, 'Document Category or Discard'),
(3176, 'Document Center'),
(3177, 'Document clinical findings in Shorthand Format'),
(3178, 'Document could not be moved to patient id'),
(3179, 'Document created'),
(3180, 'Document Date'),
(3181, 'Document date and issue updated successfully'),
(3182, 'Document ID'),
(3183, 'Document identifying information'),
(3184, 'Document Library'),
(3185, 'Document moved to new category'),
(3186, 'Document moved to patient id'),
(3187, 'Document passed integrity check'),
(3188, 'Document passed integrity check.'),
(3189, 'Document Storage Method'),
(3190, 'Document successfully renamed.'),
(3191, 'Document tagged to Encounter successfully'),
(3192, 'Document Template Management'),
(3193, 'Document Templates'),
(3194, 'Document Uploader/Viewer'),
(3195, 'Document(s)'),
(3196, 'Document/Imaging Store'),
(3197, 'Documentation for a Detailed HPI requires'),
(3198, 'Documents'),
(3199, 'documents'),
(3200, 'Documents (write,addonly optional)'),
(3201, 'Documents (write,addonly optional) (docs)'),
(3202, 'Documents - a repository of the patient\'s scanned/faxed paper documents. It also the place to download patient specific templates'),
(3203, 'Documents Delete'),
(3204, 'Documents Delete (docs_rm)'),
(3205, 'Documents History'),
(3206, 'Documents List'),
(3207, 'Documents setup error'),
(3208, 'DOC{{document format}}'),
(3209, 'DOE'),
(3210, 'Does anything make it better? Worse?'),
(3211, 'Does it occur in certain situations?'),
(3212, 'Does not equal'),
(3213, 'does not have enough data to graph'),
(3214, 'does not match the PV1 encounter number'),
(3215, 'does not seem valid'),
(3216, 'Does this type allow related codes?'),
(3217, 'Domestic Partner'),
(3218, 'Don\'t Save'),
(3219, 'Don\'t Save'),
(3220, 'Don\'t Save Changes'),
(3221, 'DONATE NOW!'),
(3222, 'Donation ID'),
(3223, 'Done'),
(3224, 'Done with'),
(3225, 'Done with:'),
(3226, 'Done.  Will now send download.'),
(3227, 'DOS'),
(3228, 'Dosage'),
(3229, 'Dose'),
(3230, 'Double click on a DX\'s handle'),
(3231, 'Double Click on this icon to pop up document in a new viewer.'),
(3232, 'double click to edit'),
(3233, 'Double Clicking a NPI box will bring up a current Users dialog for providers.'),
(3234, 'Double Vision'),
(3235, 'Download'),
(3236, 'DOWNLOAD'),
(3237, 'Download - the created CCD is downloaded as a pdf file to the downloads from the browser'),
(3238, 'Download - the created CCR is downloaded as a pdf file to the downloads from the browser'),
(3239, 'Download all patient documents'),
(3240, 'Download and/or delete log data'),
(3241, 'Download Anyway'),
(3242, 'Download billing file, post to accounting and mark as billed'),
(3243, 'Download CCD'),
(3244, 'Download CCDA file'),
(3245, 'Download Certificates'),
(3246, 'Download Charted Documents'),
(3247, 'Download configuration data'),
(3248, 'Download CSV'),
(3249, 'Download CSV File'),
(3250, 'Download document template for this patient and visit'),
(3251, 'Download Documents'),
(3252, 'download encrypted file'),
(3253, 'Download Fax'),
(3254, 'Download HL7 file'),
(3255, 'Download Lab Documents'),
(3256, 'Download Log Entries as Zipped CSV'),
(3257, 'Download Offsite Portal Connection Files'),
(3258, 'Download or Delete a Template'),
(3259, 'Download or Delete Old Log Entries'),
(3260, 'Download PDF'),
(3261, 'Download QRDA Category III File'),
(3262, 'Download report as a pdf file into the browser\'s download folder'),
(3263, 'Download Selected'),
(3264, 'Download Selected Statements'),
(3265, 'Download will download a text file containing the order in the HL7v2.3 message format to the downloads directory of your computer'),
(3266, 'Downloading Document!'),
(3267, 'Dr Check'),
(3268, 'Dr Visit'),
(3269, 'Dr.'),
(3270, 'Drafts'),
(3271, 'Drag a DX over by its handle'),
(3272, 'Drag the arrow for each diagnosis to sort the list.'),
(3273, 'Drag to move'),
(3274, 'Draw'),
(3275, 'Dribbling'),
(3276, 'Drivers License or State ID'),
(3277, 'Drop files here to upload'),
(3278, 'Drug'),
(3279, 'Drug - Drug Interaction'),
(3280, 'Drug Code'),
(3281, 'Drug Finder'),
(3282, 'Drug Forms'),
(3283, 'Drug ID missing!'),
(3284, 'Drug Intervals'),
(3285, 'Drug Inventory'),
(3286, 'Drug name'),
(3287, 'Drug Name'),
(3288, 'Drug name is required'),
(3289, 'Drug Routes'),
(3290, 'Drug Screen'),
(3291, 'Drug Screen Completed'),
(3292, 'Drug Screen Report'),
(3293, 'Drug units'),
(3294, 'Drug Units'),
(3295, 'Drug Use'),
(3296, 'Drug-Drug'),
(3297, 'Drug-Drug Interaction'),
(3298, 'Drug1 Name{{Drug1 Interaction}}'),
(3299, 'Drug2 Name{{Drug2 Interaction}}'),
(3300, 'Drugs'),
(3301, 'Drugs and Products'),
(3302, 'Dry Mouth'),
(3303, 'DSMIV Diagnosis'),
(3304, 'DT 1'),
(3305, 'DT 2'),
(3306, 'DT 3'),
(3307, 'DT 4'),
(3308, 'DT 5'),
(3309, 'DTaP 1'),
(3310, 'DTaP 2'),
(3311, 'DTaP 3'),
(3312, 'DTaP 4'),
(3313, 'DTaP 5'),
(3314, 'Dual'),
(3315, 'Due'),
(3316, 'Due Date'),
(3317, 'Due date'),
(3318, 'Due date mm/dd/yyyy or yyyy-mm-dd'),
(3319, 'Due Date:'),
(3320, 'Due Ins'),
(3321, 'Due Pt'),
(3322, 'Due Soon'),
(3323, 'Due Status'),
(3324, 'Due Status Update'),
(3325, 'Dumping OpenEMR database'),
(3326, 'Dumping OpenEMR web directory tree'),
(3327, 'Dumping phpGACL database'),
(3328, 'Dumping phpGACL web directory tree'),
(3329, 'Dumping SQL-Ledger database'),
(3330, 'Dumping SQL-Ledger web directory tree'),
(3331, 'Dup Check'),
(3332, 'Dup Check on only Edit'),
(3333, 'Dup Check on only Edit, or Extra billing codes OK'),
(3334, 'Dup Check on only New'),
(3335, 'Duplicate codes are deleted from editor list otherwise, code will append to list.'),
(3336, 'Duplicate Patient Management'),
(3337, 'Duplicate Rx -- unchanged from current Rx{{The refraction did not change, New Rx=old Rx}}'),
(3338, 'Duplicated ID on line'),
(3339, 'Duplicated name on line'),
(3340, 'DUPLICATION WARNING'),
(3341, 'Durable Power of Attorney'),
(3342, 'Duration'),
(3343, 'duration'),
(3344, 'During the work-day, syncs occurs every'),
(3345, 'Dutch'),
(3346, 'Dx Codes'),
(3347, 'Dx Rep'),
(3348, 'Dysphagia'),
(3349, 'Dyspnea:'),
(3350, 'Dysuria'),
(3351, 'Dzongkha'),
(3352, 'E(T){{intermittent esotropia}}'),
(3353, 'E-Mail'),
(3354, 'E-mail'),
(3355, 'E-Mail Address'),
(3356, 'E-mail Messaging'),
(3357, 'E-mail OK'),
(3358, 'E-PRESCRIBING'),
(3359, 'E-Prescription?'),
(3360, 'E-Reports'),
(3361, 'e-Rx'),
(3362, 'e-Rx EPCS'),
(3363, 'e-Rx Renewal'),
(3364, 'e-signed'),
(3365, 'Each of these groups (AROs) has access to pre-determined parts of the program (ACOs).'),
(3366, 'Each provider needs to set this under user settings. This should be blank'),
(3367, 'Each recipient must set their own messages as completed.'),
(3368, 'Each Section has one Narrative Block and zero to many coded Entries'),
(3369, 'Each segment is identified by a unique three letter header that constitutes the first three letters on that line'),
(3370, 'Each test in order gets a label.'),
(3371, 'Each test or panel in this group has to be in an individual Custom Favorite Item tier'),
(3372, 'Each Transaction is listed on a separate line'),
(3373, 'Early Recurrence (<2 Mo)'),
(3374, 'Ears'),
(3375, 'Easipro Server'),
(3376, 'Easipro Server Password'),
(3377, 'Easipro Server Username'),
(3378, 'Easy to forget on the computer used to login'),
(3379, 'Easy to setup'),
(3380, 'Easy to use'),
(3381, 'ECG'),
(3382, 'eClaims'),
(3383, 'ECL{{equivalent contact lens power at the corneal level}}'),
(3384, 'ECOM{{external comments abbreviation}}'),
(3385, 'Edema'),
(3386, 'EDI File'),
(3387, 'EDI History'),
(3388, 'edi history'),
(3389, 'EDI History (under Fees) for storing and interpreting EDI claim response files'),
(3390, 'EDI-271 File Upload'),
(3391, 'EDI-271 Response File Upload'),
(3392, 'Edit'),
(3393, 'edit'),
(3394, 'Edit Allergies'),
(3395, 'Edit Appointment'),
(3396, 'Edit Categories'),
(3397, 'Edit Current Patient'),
(3398, 'Edit Definitions'),
(3399, 'Edit definitions'),
(3400, 'Edit Diagnoses for'),
(3401, 'Edit Disclosure'),
(3402, 'Edit Document'),
(3403, 'Edit Entry'),
(3404, 'Edit Event'),
(3405, 'EDIT EXISTING GROUP'),
(3406, 'Edit Facilities'),
(3407, 'Edit Facility'),
(3408, 'Edit Facility Information'),
(3409, 'Edit Facility Specific User Information'),
(3410, 'Edit File in'),
(3411, 'Edit form'),
(3412, 'Edit Global Settings'),
(3413, 'Edit History and Lifestyle'),
(3414, 'Edit is not authorized!'),
(3415, 'Edit Issue'),
(3416, 'Edit layout'),
(3417, 'Edit Layout Properties'),
(3418, 'Edit list'),
(3419, 'Edit Mode'),
(3420, 'Edit Only'),
(3421, 'Edit Onsite Portal Activity'),
(3422, 'Edit Payment'),
(3423, 'Edit Signature'),
(3424, 'Edit Structure'),
(3425, 'Edit Template'),
(3426, 'Edit this form'),
(3427, 'Edit User'),
(3428, 'Edit User Settings'),
(3429, 'Edit your entered data'),
(3430, 'Editing'),
(3431, 'Editing failed'),
(3432, 'Education'),
(3433, 'Education Date'),
(3434, 'Educational materials for'),
(3435, 'ee the  * GNU General Public License for more details.  *   * You should have received a copy of the GNU General Public License  * along with this program; if not, write to the Free '),
(3436, 'Effective Date'),
(3437, 'Effective Dates'),
(3438, 'Effectiveness'),
(3439, 'eg. aching, burning, radiating pain'),
(3440, 'EIN'),
(3441, 'Either type a search term in appropriate box or double click box to see available codes.'),
(3442, 'Either way data entered by any method will feature in both locations'),
(3443, 'Ejaculations'),
(3444, 'Elbow'),
(3445, 'Elbow Problems'),
(3446, 'Electronic'),
(3447, 'Electronic document received'),
(3448, 'Electronic Notes'),
(3449, 'Electronic orders'),
(3450, 'Electronic Remits'),
(3451, 'Electronic Reports'),
(3452, 'Electronic results can be bidirectional - both order tests and receive results electronically or unidirectional - only receive the results electronically'),
(3453, 'electronically signed on'),
(3454, 'Eligibility'),
(3455, 'Eligibility 270 Inquiry Batch'),
(3456, 'Eligibility Response'),
(3457, 'Eligibility Service Date (270 DTP03)'),
(3458, 'Eligibility status for Vaccine for Children supplied vaccine'),
(3459, 'Eligible'),
(3460, 'Ellipse'),
(3461, 'Email'),
(3462, 'email'),
(3463, 'EMAIL'),
(3464, 'Email Address'),
(3465, 'Email address is missing'),
(3466, 'Email address of the sender for patient reminders. Replies to patient reminders will be directed to this address. It is important to use an address from your clinic\'s domain to avoid help prevent patient reminders from going to junk mail folders.'),
(3467, 'Email address, if any, to receive administrative notifications.'),
(3468, 'Email address, if any, to receive emergency login user activation messages.'),
(3469, 'Email Auth'),
(3470, 'EMAIL Confimed'),
(3471, 'Email Direct'),
(3472, 'Email from Batchcom'),
(3473, 'Email if required'),
(3474, 'Email Notification'),
(3475, 'Email Notification Hours'),
(3476, 'Email Notification Report'),
(3477, 'Email Notification Settings Updated Successfully'),
(3478, 'Email Selected'),
(3479, 'Email Selected Statements'),
(3480, 'Email send before'),
(3481, 'Email Sender'),
(3482, 'Email Sent'),
(3483, 'Email sent to'),
(3484, 'Email Subject'),
(3485, 'email subject'),
(3486, 'Email Text Usable Tags'),
(3487, 'Email Text, Usable Tag: ***NAME*** , i.e. Dear ***NAME***'),
(3488, 'Email Text, Usable Tag: ***NAME*** , i.e. Dear ***NAME***{{Do Not translate the ***NAME*** elements of this constant.}}'),
(3489, 'Email Transport Method'),
(3490, 'Email was sent to following address'),
(3491, 'emails not sent'),
(3492, 'Embed {login} where the OpenEMR login name of the user is to be; for example: uid={login},dc=example,dc=com'),
(3493, 'Emergency Care'),
(3494, 'Emergency contact'),
(3495, 'Emergency Contact'),
(3496, 'Emergency Contact Person'),
(3497, 'Emergency Contact Phone Number'),
(3498, 'Emergency Contraception'),
(3499, 'Emergency Login'),
(3500, 'Emergency Login ACL is chosen. The user is still in active state, please de-activate the user and activate the same when required during emergency situations. Visit Administration->Users for activation or de-activation.'),
(3501, 'Emergency Login activation email will be circulated only if following settings in the interface/globals.php file are configured:'),
(3502, 'Emergency Login Email Address'),
(3503, 'Emergency Login user can do anything'),
(3504, 'Emergency Phone'),
(3505, 'Emergency Room - Hospital'),
(3506, 'Emotional / Behavioral Conditions & Complications'),
(3507, 'Emphysema'),
(3508, 'Employee'),
(3509, 'Employer'),
(3510, 'Employer Address'),
(3511, 'Employer Data'),
(3512, 'Employer Name'),
(3513, 'EMPTY'),
(3514, 'Empty'),
(3515, 'Empty Definition'),
(3516, 'Empty Definitions'),
(3517, 'empty file received'),
(3518, 'Empty Password Not Allowed'),
(3519, 'Empty table'),
(3520, 'Empty value in \"Email Hours\"'),
(3521, 'Empty value in \"Email Sender\"'),
(3522, 'Empty value in \"Email Subject\"'),
(3523, 'Empty value in \"Email Text\"'),
(3524, 'Empty value in \"Name of Provider\"'),
(3525, 'Empty value in \"Password\"'),
(3526, 'Empty value in \"SMS Hours\"'),
(3527, 'Empty value in \"SMS Text\"'),
(3528, 'Empty value in \"Username\"'),
(3529, 'EMR Direct'),
(3530, 'EMR Direct phiMail is a secure, scalable, standards-based way for participants to send authenticated, encrypted health information directly to known, trusted recipients over the Internet'),
(3531, 'Enable'),
(3532, 'Enable a Payment Gateway Service for processing credit card transactions'),
(3533, 'Enable Alert Log'),
(3534, 'Enable Alert Logging'),
(3535, 'Enable Allergy Check'),
(3536, 'Enable Allergy Check Against Medications and Prescriptions'),
(3537, 'Enable AMC Prompting'),
(3538, 'Enable AMC Report Itemization'),
(3539, 'Enable AMC Reporting'),
(3540, 'Enable AMC Tracking'),
(3541, 'Enable amendments feature'),
(3542, 'Enable ATNA Auditing'),
(3543, 'Enable Audit Log Encryption'),
(3544, 'Enable Audit Logging'),
(3545, 'Enable Audit Trail and Node Authentication (ATNA).'),
(3546, 'Enable Authentication Using Google Sign-in'),
(3547, 'Enable Automated Measure Calculations (AMC) Reporting'),
(3548, 'Enable Batch Payment'),
(3549, 'Enable C-CDA Alternate Service'),
(3550, 'Enable C-CDA Service'),
(3551, 'Enable Client'),
(3552, 'Enable Client SSL'),
(3553, 'Enable client SSL certificate authentication.'),
(3554, 'Enable Clinical Active Reminder Popup'),
(3555, 'Enable Clinical Decisions Rules (CDR)'),
(3556, 'Enable Clinical Passive New Reminder(s) Popup'),
(3557, 'Enable Clinical Passive Reminder Widget'),
(3558, 'Enable Clinical Quality Measure (CQM) Reporting'),
(3559, 'Enable Clinical Reminder Popup'),
(3560, 'Enable Clinical Reminder Widget'),
(3561, 'Enable CMS Portal'),
(3562, 'Enable Compact Mode'),
(3563, 'Enable CQM Report Itemization'),
(3564, 'Enable CQM Reporting'),
(3565, 'Enable Database Connection Pooling'),
(3566, 'Enable Easipro'),
(3567, 'Enable Easipro. For licensing options for this feature, please contact'),
(3568, 'Enable EDI History'),
(3569, 'Enable EDI History In Left Menu'),
(3570, 'Enable Encryption of Items Stored on CouchDB'),
(3571, 'Enable Encryption of Items Stored on Drive'),
(3572, 'Enable Extension'),
(3573, 'Enable Facility'),
(3574, 'Enable Facility/Warehouse Permissions'),
(3575, 'Enable facility/warehouse restrictions in the user administration form.'),
(3576, 'Enable Fees In Left Menu'),
(3577, 'Enable Fees Submenu'),
(3578, 'Enable FHIR Provider Client Service'),
(3579, 'Enable follow-up encounters'),
(3580, 'Enable follow-up encounters feature'),
(3581, 'Enable Google Sign-In'),
(3582, 'Enable Group Therapy'),
(3583, 'Enable Help Modal'),
(3584, 'Enable Hylafax Support'),
(3585, 'Enable import status message after visiting NewCrop eRx.'),
(3586, 'Enable import status message for NewCrop erx'),
(3587, 'Enable Itemization of AMC Reports'),
(3588, 'Enable Itemization of CQM Reports'),
(3589, 'Enable Itemization of Standard Clinical Rules Reports'),
(3590, 'Enable Lab Exchange'),
(3591, 'Enable lock toggle'),
(3592, 'Enable log for document uploads/downloads to CouchDB'),
(3593, 'Enable logging of all SQL SELECT queries.'),
(3594, 'Enable logging of backup related activities.'),
(3595, 'Enable logging of CDR Engine Queries.'),
(3596, 'Enable logging of miscellaneous activities.'),
(3597, 'Enable logging of ordering activities.'),
(3598, 'Enable logging of patient record modifications.'),
(3599, 'Enable logging of scheduling activities.'),
(3600, 'Enable logging of security and administration activities.'),
(3601, 'Enable MedEx Communication Service'),
(3602, 'Enable NewCrop eRx import status message'),
(3603, 'Enable NewCrop eRx Service'),
(3604, 'Enable NewCrop eRx Service.'),
(3605, 'Enable OAuth2 Password Grant (Not considered secure)'),
(3606, 'Enable OAuth2 Password Grant. Recommend turning this setting off for production server. Recommend only using for testing.'),
(3607, 'Enable Office Ally Insurance Eligibility'),
(3608, 'Enable Offsite Patient Portal'),
(3609, 'Enable Offsite Patient Portal.'),
(3610, 'Enable only one type of portal by checking the relevant check-box'),
(3611, 'Enable Onsite Patient Portal'),
(3612, 'Enable Onsite Patient Portal Document Download'),
(3613, 'Enable Onsite Patient Portal new patient to self register.'),
(3614, 'Enable Onsite Patient Portal.'),
(3615, 'Enable OpenEMR FHIR System Scopes (Recommended Off, Turn on only if you know what you are doing)'),
(3616, 'Enable OpenEMR FHIR System Scopes.'),
(3617, 'Enable OpenEMR Patient Portal FHIR REST API (EXPERIMENTAL)'),
(3618, 'Enable OpenEMR Patient Portal FHIR RESTful API.'),
(3619, 'Enable OpenEMR Patient Portal REST API (EXPERIMENTAL)'),
(3620, 'Enable OpenEMR Patient Portal RESTful API.'),
(3621, 'Enable OpenEMR REST API'),
(3622, 'Enable OpenEMR RESTful API. SSL Required'),
(3623, 'Enable OpenEMR Standard FHIR REST API'),
(3624, 'Enable OpenEMR Standard FHIR RESTful API.'),
(3625, 'Enable OpenEMR Standard REST API'),
(3626, 'Enable OpenEMR Standard RESTful API.'),
(3627, 'Enable Patient Portal'),
(3628, 'Enable Patient Portal Document Download'),
(3629, 'Enable Patient Portal new patient to self register.'),
(3630, 'Enable Patient Reminder Widget'),
(3631, 'Enable percent-based price levels'),
(3632, 'Enable phiMail Direct Messaging Service'),
(3633, 'Enable Posting'),
(3634, 'Enable Prompting For Automated Measure Calculations (AMC) Required Data'),
(3635, 'Enable Random Drug Testing'),
(3636, 'Enable Reporting of Tracking Date For Automated Measure Calculations (AMC)'),
(3637, 'Enable Save and Close'),
(3638, 'Enable Scanner Support'),
(3639, 'Enable Standard Report Itemization'),
(3640, 'Enable support for the open source WordPress Portal by Sunset Systems'),
(3641, 'Enable Text Templates in Encounter Forms'),
(3642, 'Enable the Medical Information Integration, LLC Lab Exchange Service.'),
(3643, 'Enable the OpenEMR Support LLC Lab Exchange Service.'),
(3644, 'Enable User Certificate Authentication'),
(3645, 'Enable Version 1 Onsite Patient Portal'),
(3646, 'Enable Version 2 Onsite Patient Portal'),
(3647, 'Enable Version 2 Onsite Patient Portal new patient to self register.'),
(3648, 'Enable Weno eRx Service'),
(3649, 'Enable Weno eRx Service Test mode'),
(3650, 'Enable ZMG, LLC eRx service'),
(3651, 'enabled'),
(3652, 'Enabled'),
(3653, 'Enabled Client'),
(3654, 'Enabled Services'),
(3655, 'Enables choose due date to message'),
(3656, 'Enables groups module in system.'),
(3657, 'Enables the ability to download documents in the Onsite Patient Portal by the user.'),
(3658, 'Enables the ability to download documents in the Patient Portal by the user.'),
(3659, 'Enables the old Charges panel for entering billing codes and payments. Not recommended, use the Fee Sheet instead.'),
(3660, 'Enables to submit changes for all appointments of a recurrence at once.'),
(3661, 'Enabling EMR Direct phiMail'),
(3662, 'Enc'),
(3663, 'Enc#'),
(3664, 'Encnter'),
(3665, 'Encounter'),
(3666, 'encounter'),
(3667, 'Encounter '),
(3668, 'encounter acute inpatient or ED'),
(3669, 'Encounter Balance'),
(3670, 'Encounter Billing Note'),
(3671, 'Encounter Checkup Procedure'),
(3672, 'Encounter Count'),
(3673, 'encounter data'),
(3674, 'Encounter Date'),
(3675, 'Encounter Diagnosis'),
(3676, 'Encounter Dt / Rsn'),
(3677, 'Encounter EDI Record'),
(3678, 'Encounter Esigned'),
(3679, 'Encounter Forms'),
(3680, 'encounter health and behavior assessment'),
(3681, 'Encounter History'),
(3682, 'Encounter ID'),
(3683, 'encounter influenza'),
(3684, 'Encounter Information'),
(3685, 'Encounter Information (encounters)'),
(3686, 'Encounter number'),
(3687, 'Encounter Number'),
(3688, 'encounter nursing discharge'),
(3689, 'encounter nursing facility'),
(3690, 'encounter occupational therapy'),
(3691, 'encounter office visit'),
(3692, 'encounter outpatient'),
(3693, 'encounter outpatient w/PCP & obgyn'),
(3694, 'Encounter Page Size'),
(3695, 'Encounter Payment'),
(3696, 'encounter pregnancy'),
(3697, 'encounter preventive medicine - individual counseling'),
(3698, 'encounter preventive medicine 40 and older'),
(3699, 'encounter preventive medicine group counseling'),
(3700, 'encounter preventive medicine other services'),
(3701, 'encounter preventive medicine services 18 and older'),
(3702, 'Encounter Preview'),
(3703, 'Encounter Provider'),
(3704, 'encounter psychiatric & psychologic'),
(3705, 'Encounter statistics'),
(3706, 'Encounter Summary'),
(3707, 'Encounter type'),
(3708, 'Encounter was coded'),
(3709, 'Encounter:'),
(3710, 'Encounter: encounter non-acute inpt, outpatient, or ophthalmology'),
(3711, 'Encounters'),
(3712, 'Encounters & Forms'),
(3713, 'Encounters &amp; Forms'),
(3714, 'Encounters not authorized'),
(3715, 'Encounters Report'),
(3716, 'Encounters Section'),
(3717, 'Encrypted File'),
(3718, 'Encryption'),
(3719, 'Encryption key issued by Weno eRx service.'),
(3720, 'Encryption Pass Phrase'),
(3721, 'End'),
(3722, 'End (yyyy-mm-dd): '),
(3723, 'End Date'),
(3724, 'End date'),
(3725, 'End Date From'),
(3726, 'End date is missing!'),
(3727, 'End Date leave blank if ongoing'),
(3728, 'End date must be equal or bigger than start date'),
(3729, 'End date must be later than Begin date!'),
(3730, 'End date should be greater than Begin date'),
(3731, 'End Date To'),
(3732, 'End Date:'),
(3733, 'End of Day by Provider or allow Totals Only'),
(3734, 'End Of Day Report'),
(3735, 'End of report'),
(3736, 'End of Requisition'),
(3737, 'End Time'),
(3738, 'End watching server processes for upgrade version'),
(3739, 'End-Stage Renal Disease Beneficiary in MCP with Employer`s Group Plan'),
(3740, 'End-Stage Renal Disease Treatment Facility'),
(3741, 'Ending Account Balance'),
(3742, 'Ending date'),
(3743, 'Ending date of service yyyy-mm-dd'),
(3744, 'Ending DOS mm/dd/yyyy if you wish to enter a range'),
(3745, 'Ending hour of day for calendar events.'),
(3746, 'Endo Abnormal Blood'),
(3747, 'Endocrine'),
(3748, 'Endoscopy'),
(3749, 'ENDO{{Endocrine}}'),
(3750, 'Enforce E-Mail in Portal Log On Dialog'),
(3751, 'Engineer'),
(3752, 'Engineering Firm'),
(3753, 'English'),
(3754, 'English '),
(3755, 'English (Australian)'),
(3756, 'English (Indian)'),
(3757, 'English (Standard)'),
(3758, 'Enscript command used by Hylafax.'),
(3759, 'Ensure OpenEMR has write privileges to directory'),
(3760, 'Ensure that Identifying Codes are unique'),
(3761, 'ENT Discharge'),
(3762, 'ENT Pain'),
(3763, 'Enter 1 under sequence, more about sequence numbers later'),
(3764, 'Enter a Begin Date'),
(3765, 'Enter a diagnosis code to exclude all invoices not containing it'),
(3766, 'Enter a sequence 1'),
(3767, 'Enter an amendment...'),
(3768, 'Enter an End Date if the problem has been resolved'),
(3769, 'Enter Application Name'),
(3770, 'Enter body of letter here'),
(3771, 'Enter City'),
(3772, 'Enter Database root Password'),
(3773, 'Enter Database root Username'),
(3774, 'Enter default values for OD{{right eye}}'),
(3775, 'Enter defaults for Right side'),
(3776, 'Enter defaults values for Left side'),
(3777, 'Enter defaults values for OS{{left eye}}'),
(3778, 'Enter Details'),
(3779, 'Enter Details for Custom Favorite Group'),
(3780, 'Enter Details for Discrete Results'),
(3781, 'Enter Details for Group'),
(3782, 'Enter Details for Individual Custom Favorite Item'),
(3783, 'Enter Details for Individual Procedures'),
(3784, 'Enter Details for Recommendation'),
(3785, 'Enter Diagnosis'),
(3786, 'Enter Drugs'),
(3787, 'Enter E-Mail Address'),
(3788, 'Enter email address to receive registration.'),
(3789, 'Enter Encounter'),
(3790, 'Enter Encounter Number'),
(3791, 'Enter Facility Name'),
(3792, 'Enter Gift Card number in the Reference field'),
(3793, 'Enter ID'),
(3794, 'Enter Immunizations'),
(3795, 'Enter Key'),
(3796, 'Enter Last'),
(3797, 'Enter name'),
(3798, 'Enter needed information to help process this particular claim'),
(3799, 'Enter new data'),
(3800, 'Enter new office note here'),
(3801, 'Enter new State'),
(3802, 'Enter Occurrence if appropriate'),
(3803, 'Enter or select the options in the various boxes to filter the results according to need and press Filter'),
(3804, 'Enter Password'),
(3805, 'Enter PIN code'),
(3806, 'Enter Provider Details'),
(3807, 'Enter Recipient\'s Direct Address'),
(3808, 'Enter required authentication code'),
(3809, 'Enter Self if None'),
(3810, 'Enter Serum Uric Acid in the Name box'),
(3811, 'Enter Serum Uric Acid order in the Description box'),
(3812, 'Enter Serum Uric Acid result under Description'),
(3813, 'Enter Serum Uric Acid under Name'),
(3814, 'Enter the category data in the appropriate fields and click \'Save\'. These will be used to group the ICD codes and will be displayed on the buttons in the \'Select Codes\' section'),
(3815, 'Enter the code from your authentication application on your device'),
(3816, 'Enter the default range values if applicable, used in manual entry of results.'),
(3817, 'Enter the default units for this test.'),
(3818, 'Enter the details - Name - Well Woman Tests, Description - Well Woman Tests, an appropriate sequence number depending on the procedure orders already entered, Order From - Local Lab'),
(3819, 'Enter the details as follows Name - Blood Glucose, Description - Fasting Glucose result, Sequence - 1, Identifying Code - any unique value - WWT01R, Default Units - mg/dL, Default Range - 70-100, leave Followup Services blank and click Save'),
(3820, 'Enter the Direct address and click Send CCR/Send CCD as the case may be'),
(3821, 'Enter the following: Name - Blood Glucose, Description - Fasting Blood Glucose, Sequence - 1, Order From - Local Lab'),
(3822, 'Enter the laterality of this procedure, if applicable.'),
(3823, 'Enter the Logical Observation Identifiers Names and Codes (LOINC) code for this procedure'),
(3824, 'Enter the Logical Observation Identifiers Names and Codes (LOINC) code for this procedure. LOINC is a database and universal standard for identifying medical laboratory observations.'),
(3825, 'Enter the LOINC code for this procedure'),
(3826, 'Enter the OpenEMR login password for the user and click Submit'),
(3827, 'Enter the Re Identification code'),
(3828, 'Enter the relevant site if applicable.'),
(3829, 'Enter the Server Address, Username, and Password provided to you'),
(3830, 'Enter the Severity of the allergy'),
(3831, 'Enter the specimen type if applicable.'),
(3832, 'Enter the values 3.4 - 7.2 - Men, 2.4–6.1 - Women'),
(3833, 'Enter their OpenEMR username in the notification user field'),
(3834, 'Enter User Login ID'),
(3835, 'Enter values in this section to create a new group also known as Access Request Object (ARO)'),
(3836, 'Enter your credentials'),
(3837, 'Enter your existing current password used to login.'),
(3838, 'Enter your password to sign the form'),
(3839, 'Enter your search criteria above'),
(3840, 'Enter Your Zip'),
(3841, 'Entered'),
(3842, 'Entered By'),
(3843, 'Entered in Error'),
(3844, 'Entered User Name is unavalable!'),
(3845, 'entries'),
(3846, 'entries with the oldest dated'),
(3847, 'Entry Status'),
(3848, 'Envelope Height in mm'),
(3849, 'Envelope Width in mm'),
(3850, 'Envelope x-axis starting pt'),
(3851, 'Envelope y-axis starting pt'),
(3852, 'Environmental'),
(3853, 'EOB Data Entry'),
(3854, 'EOB Data Entry (eob)'),
(3855, 'EOB Id'),
(3856, 'EOB Invoice'),
(3857, 'EOB Posting - Electronic Remittances'),
(3858, 'EOB Posting - Instructions'),
(3859, 'EOB Posting - Invoice'),
(3860, 'EOB Posting - Patient Note'),
(3861, 'EOB Posting - Search'),
(3862, 'EOBs'),
(3863, 'Epilepsy'),
(3864, 'Episode'),
(3865, 'EPSDT'),
(3866, 'EPSDT:'),
(3867, 'Equals'),
(3868, 'Equivalent contact lens power at the corneal level'),
(3869, 'ERA'),
(3870, 'ERA Files'),
(3871, 'ERA Posting'),
(3872, 'ERA Upload'),
(3873, 'Erase'),
(3874, 'Eraser'),
(3875, 'Erections'),
(3876, 'Error'),
(3877, 'ERROR'),
(3878, 'Error confirming receipt of lab results'),
(3879, 'Error creating directory!'),
(3880, 'Error finding diagnosis element. Try again.'),
(3881, 'Error Generating Batch File'),
(3882, 'Error getting lab results from Lab Exchange Network'),
(3883, 'Error in \"Gender\" selection'),
(3884, 'Error in \"HIPAA\" selection'),
(3885, 'Error in \"Process\" selection'),
(3886, 'Error in \"SMS Gateway\" selection'),
(3887, 'Error in \"Sort By\" selection'),
(3888, 'Error in gzip compression of file: '),
(3889, 'Error in YES or NO option'),
(3890, 'Error Message'),
(3891, 'ERROR Missing Patient ID'),
(3892, 'Error No selected Readers'),
(3893, 'Error number'),
(3894, 'Error opening uploaded file for reading'),
(3895, 'Error processing file'),
(3896, 'Error processing upload'),
(3897, 'Error Removing Message'),
(3898, 'Error retrieving results from Lab Exchange Network'),
(3899, 'Error retrieving values.'),
(3900, 'Error saving document'),
(3901, 'Error when granting file privilege to the OpenEMR user.'),
(3902, 'Error while adding new plan'),
(3903, 'Error while deleting the plan'),
(3904, 'error while registering form!'),
(3905, 'Error while saving to the file'),
(3906, 'Error while updating the plan'),
(3907, 'Error while writing to file'),
(3908, 'Error! Groups save failed. Check your Group lists.'),
(3909, 'Error! Images state save failed.'),
(3910, 'Error! Profiles save failed. Check your Profile lists.'),
(3911, 'ERROR!... in Update'),
(3912, 'error(s) encountered from new results'),
(3913, 'Error, Class ZipArchive does not exist'),
(3914, 'Error, Could not create file archive'),
(3915, 'Error, the CA Certificate File doesn\'t exist'),
(3916, 'Error, the CA Key File doesn\'t exist'),
(3917, 'Error, the file does not exist'),
(3918, 'ERROR, unable to collect data from server'),
(3919, 'Error, unable to create client certificate.'),
(3920, 'Error, unable to create the admin.p12 certificate.'),
(3921, 'Error, unable to create the Certificate Authority certificate.'),
(3922, 'Error, unable to create the Server certificate.'),
(3923, 'Error, unable to create zip file with all the certificates'),
(3924, 'Error, unable to open file'),
(3925, 'Error, User Certificate Authentication is not enabled in OpenEMR'),
(3926, 'ERROR. Could not open'),
(3927, 'Error. Not authorized'),
(3928, 'Error. Not Authorized.'),
(3929, 'Error. Nothing to do.'),
(3930, 'Error. Problem sending one or more templates.'),
(3931, 'Error. Problem setting one or more profiles.'),
(3932, 'Error. Try again later'),
(3933, 'Error. You need to install the Archive/Tar.php php module.'),
(3934, 'ERROR: could not open table.sql, broken form?'),
(3935, 'Error: Duplicated field ID'),
(3936, 'Error: duplicated ID'),
(3937, 'Error: duplicated ID on line'),
(3938, 'Error: duplicated name on line'),
(3939, 'ERROR: Field'),
(3940, 'ERROR: Missing ZipArchive PHP Module'),
(3941, 'ERROR: No ICD import directory.'),
(3942, 'Error: passwords don\'t match. Please check your typing.'),
(3943, 'Error: passwords don\'t match. Please check your typing.'),
(3944, 'Error: the file does not exist'),
(3945, 'ERROR: The following variable contains invalid characters'),
(3946, 'ERROR: Unable to copy the file.'),
(3947, 'Error: Unable to create downloadable archive'),
(3948, 'ERROR: Unable to Create Zip Archive.'),
(3949, 'ERROR: Unable to extract the file.'),
(3950, 'ERROR: Unable to load the file into the database.'),
(3951, 'ERROR: Unable to set the version number.'),
(3952, 'Errors'),
(3953, 'eRx'),
(3954, 'eRx Account Status'),
(3955, 'eRx Logs'),
(3956, 'ERX Name'),
(3957, 'ERX Password'),
(3958, 'ERX Role'),
(3959, 'ERX User'),
(3960, 'Erythema:'),
(3961, 'eSign'),
(3962, 'eSign Log'),
(3963, 'Eskimo'),
(3964, 'Esophoria'),
(3965, 'Esotropia'),
(3966, 'Esperanto'),
(3967, 'Est'),
(3968, 'Established'),
(3969, 'Established Patient'),
(3970, 'Estonian'),
(3971, 'Ethnicity'),
(3972, 'Ethnicity or Race'),
(3973, 'Ethnicity-Race List (write,addonly optional)'),
(3974, 'Ethnicity-Race List (write,addonly optional) (ethrace)'),
(3975, 'Ethnoracial'),
(3976, 'ETIN'),
(3977, 'ETOH'),
(3978, 'ET{{esotropia}}'),
(3979, 'Event'),
(3980, 'event'),
(3981, 'Event Begins'),
(3982, 'Event Category'),
(3983, 'Event Date'),
(3984, 'event date or starting date'),
(3985, 'Event Description'),
(3986, 'Event Details'),
(3987, 'Event does not repeat'),
(3988, 'Event Duration'),
(3989, 'Event duration in minutes'),
(3990, 'Event Fee'),
(3991, 'Event Location'),
(3992, 'Event repeats every'),
(3993, 'Event repeats on'),
(3994, 'Event start time'),
(3995, 'Event title'),
(3996, 'Event Title'),
(3997, 'Event Website'),
(3998, 'Events'),
(3999, 'Events for'),
(4000, 'Events open in new window'),
(4001, 'Events Scheduled'),
(4002, 'Eventually file name becomes a Pending document selection in Portal Documents.'),
(4003, 'every'),
(4004, 'Every'),
(4005, 'Every 2nd'),
(4006, 'every 3 hours'),
(4007, 'Every 3rd'),
(4008, 'every 4 hours'),
(4009, 'Every 4th'),
(4010, 'every 5 hours'),
(4011, 'Every 5th'),
(4012, 'every 6 hours'),
(4013, 'Every 6th'),
(4014, 'every 8 hours'),
(4015, 'Every Fourth'),
(4016, 'Every name in the address book appears here, not only physicians.'),
(4017, 'Every Other'),
(4018, 'Every Third'),
(4019, 'Every, every other, every 3rd, etc.'),
(4020, 'Ewe'),
(4021, 'Exam and test results'),
(4022, 'Exam or Test'),
(4023, 'Exam results'),
(4024, 'Exam Room #'),
(4025, 'Exam Room Number'),
(4026, 'Examination'),
(4027, 'Examination Date'),
(4028, 'Example'),
(4029, 'Example authenticator apps include'),
(4030, 'Example Privacy_Agreement.txt becomes Privacy Agreement button in Patient Documents'),
(4031, 'Examples'),
(4032, 'Examples of Sections are - Medications, Allergies, Vital Signs'),
(4033, 'Exams/Tests'),
(4034, 'Exam{{Physical Exam}}'),
(4035, 'Except'),
(4036, 'Excessive Tearing'),
(4037, 'Exclude All E-Sign Logs On Report'),
(4038, 'Exclude in Portal'),
(4039, 'Excluded Appointments - Tooltip - Number to Display'),
(4040, 'Excluded Patients'),
(4041, 'Exclusion'),
(4042, 'Exclusive Provider Organization (EPO)'),
(4043, 'Executables not allowed'),
(4044, 'Executive Paper Size'),
(4045, 'Exercise'),
(4046, 'Exercise patterns'),
(4047, 'Exercise Patterns'),
(4048, 'Exist'),
(4049, 'existing claim status is not altered.'),
(4050, 'Existing Forms'),
(4051, 'Exit'),
(4052, 'Exit from Administration'),
(4053, 'Exit Mail'),
(4054, 'Exophoria'),
(4055, 'Exotropia'),
(4056, 'Exp'),
(4057, 'Exp Date'),
(4058, 'Expand'),
(4059, 'expand'),
(4060, 'Expand / Collapse'),
(4061, 'Expand All'),
(4062, 'Expand All Document Categories'),
(4063, 'Expand All Document Categories by Default'),
(4064, 'Expand Form'),
(4065, 'Expand/Collapse this form'),
(4066, 'Expanded View'),
(4067, 'Expected form_encounter.pid to be '),
(4068, 'Expiration'),
(4069, 'Expiration Date'),
(4070, 'Expired'),
(4071, 'Expires'),
(4072, 'expires in'),
(4073, 'Expiry'),
(4074, 'Export'),
(4075, 'Export as CSV'),
(4076, 'Export Billing'),
(4077, 'Export Configuration'),
(4078, 'Export File'),
(4079, 'Export Individual Invoices'),
(4080, 'Export OFX'),
(4081, 'Export Patient Demographics'),
(4082, 'Export Patient Demographics XML'),
(4083, 'Export PQRI Report'),
(4084, 'Export process timed out'),
(4085, 'Export QRDA Report'),
(4086, 'Export Selected as CSV'),
(4087, 'Export Selected to Collections'),
(4088, 'Export to CSV'),
(4089, 'Export to external billing system'),
(4090, 'Export Zero Balances'),
(4091, 'Exposure to Foreign Countries'),
(4092, 'Exposure To Foreign Countries'),
(4093, 'Ext'),
(4094, 'Ext Time Collected'),
(4095, 'Extended family'),
(4096, 'External'),
(4097, 'External Data'),
(4098, 'External Data - any external data linked to either encounters or procedures'),
(4099, 'External Data Loads'),
(4100, 'External Database Import Utility'),
(4101, 'External Draw Panel'),
(4102, 'External Exam'),
(4103, 'External Exam Default Values'),
(4104, 'External ID'),
(4105, 'External Id'),
(4106, 'External identifier'),
(4107, 'External Lab'),
(4108, 'External Only'),
(4109, 'External Organization'),
(4110, 'External Procedure'),
(4111, 'External Provider'),
(4112, 'External Referral'),
(4113, 'External Referral Followups'),
(4114, 'External referral?'),
(4115, 'External Referrals'),
(4116, 'External URL'),
(4117, 'Extract the zip file'),
(4118, 'Extracting the file. This will take some time...'),
(4119, 'Extremely difficult'),
(4120, 'Exudate:'),
(4121, 'Eye'),
(4122, 'Eye Coding Fields'),
(4123, 'Eye Coding Terms'),
(4124, 'Eye Contact Lens Brand list'),
(4125, 'Eye Contact Lens Manufacturer list'),
(4126, 'Eye Contact Lens Supplier list'),
(4127, 'Eye Dx{{eye diagnosis}}'),
(4128, 'Eye Exam'),
(4129, 'Eye Exam Default Values for New Providers'),
(4130, 'Eye Irritation'),
(4131, 'Eye Lens Material'),
(4132, 'Eye Lens Treatments'),
(4133, 'Eye Med'),
(4134, 'Eye Meds'),
(4135, 'Eye Orders Defaults'),
(4136, 'Eye Pain'),
(4137, 'Eye QP List ANTSEG for New Providers'),
(4138, 'Eye QP List EXT for New Providers'),
(4139, 'Eye QP List RETINA for New Providers'),
(4140, 'Eye Redness'),
(4141, 'Eye Surgery'),
(4142, 'Eyedropper'),
(4143, 'Eyes'),
(4144, 'E{{esophoria}}'),
(4145, 'F'),
(4146, 'F/H Blood Problems'),
(4147, 'F/H Female Hirsutism/Striae'),
(4148, 'Facilities'),
(4149, 'Facility'),
(4150, 'facility'),
(4151, 'Facility Administration'),
(4152, 'Facility and warehouse permissions'),
(4153, 'Facility City'),
(4154, 'Facility Code'),
(4155, 'Facility Color Schema'),
(4156, 'Facility Country code'),
(4157, 'Facility Details'),
(4158, 'Facility Fax'),
(4159, 'Facility ID'),
(4160, 'Facility ID is missing'),
(4161, 'Facility ID\'s'),
(4162, 'Facility Name'),
(4163, 'Facility NPI'),
(4164, 'Facility permissions'),
(4165, 'Facility Phone'),
(4166, 'Facility reflects the facility in which the visit occurred'),
(4167, 'Facility Specific User Information'),
(4168, 'Facility State'),
(4169, 'Facility Street'),
(4170, 'Facility Taxonomy'),
(4171, 'Facility Zip'),
(4172, 'Facility Zip Code'),
(4173, 'Facility:'),
(4174, 'FAIL'),
(4175, 'Failed'),
(4176, 'failed'),
(4177, 'Failed - already has group with the same name'),
(4178, 'Failed Patients'),
(4179, 'Failed Registration'),
(4180, 'Failed since file already exists'),
(4181, 'Failed to add patient to portal'),
(4182, 'Failed to compute a unique filename'),
(4183, 'Failed to create'),
(4184, 'Failed to create folder'),
(4185, 'Failed to create new group'),
(4186, 'Failed to create temporary folder. CouchDB will not work.'),
(4187, 'Failed to generate'),
(4188, 'Failed to get URL:'),
(4189, 'Failed to send'),
(4190, 'Failed to unregister module.'),
(4191, 'Failed UTF8 encoding check! Could not automatically fix.'),
(4192, 'Failed.'),
(4193, 'failure'),
(4194, 'Failure'),
(4195, 'FAILURE NOTICE: Direct Message Send Failed.'),
(4196, 'FAILURE: Couldn\'t create the zip'),
(4197, 'FAILURE: No patients for measure'),
(4198, 'Falls: Screening, Risk-Assessment, and Plan of Care to Prevent Future Falls (CQM)'),
(4199, 'False'),
(4200, 'Family Health History'),
(4201, 'Family History'),
(4202, 'Family history - Documents the patient\'s family history, an ICD10 diagnosis can be linked to the medical conditions'),
(4203, 'Family History of Glaucoma'),
(4204, 'Family History:'),
(4205, 'Family Member'),
(4206, 'Family Payment'),
(4207, 'Family Size'),
(4208, 'Fancy'),
(4209, 'Faroese'),
(4210, 'Farsi'),
(4211, 'Fasting'),
(4212, 'Fatal'),
(4213, 'Father'),
(4214, 'Fathers History'),
(4215, 'Fatigue'),
(4216, 'Fatigued'),
(4217, 'Favorites'),
(4218, 'Fax'),
(4219, 'Fax Count'),
(4220, 'Fax number'),
(4221, 'Fax sending failed'),
(4222, 'Fax/Scan'),
(4223, 'Faxes In'),
(4224, 'Faxes Out'),
(4225, 'Feature not activated'),
(4226, 'Features'),
(4227, 'Feb'),
(4228, 'February'),
(4229, 'FECA'),
(4230, 'Federal Drug ID'),
(4231, 'Federal EIN'),
(4232, 'Federal Tax ID'),
(4233, 'Federally Qualified Health Center'),
(4234, 'Fee'),
(4235, 'fee'),
(4236, 'Fee is not allowed'),
(4237, 'Fee Sheet'),
(4238, 'Fee Sheet and Checkout'),
(4239, 'Fee Sheet for'),
(4240, 'Fee Sheet Options'),
(4241, 'Fee sheet tab is already opened'),
(4242, 'Feeling afraid'),
(4243, 'Feeling afraid as if something awful might happen'),
(4244, 'Feeling nervous'),
(4245, 'Feeling nervous, anxious, or on edge'),
(4246, 'Fees'),
(4247, 'Female'),
(4248, 'Female AP'),
(4249, 'Female Condoms'),
(4250, 'Female G'),
(4251, 'Female LC'),
(4252, 'Female P'),
(4253, 'Female Symptoms'),
(4254, 'Female VSC'),
(4255, 'Fetch'),
(4256, 'Fetching following file from portal'),
(4257, 'Fever'),
(4258, 'Fever:'),
(4259, 'FH Blood Problems'),
(4260, 'FHD, WUXGA'),
(4261, 'FHIR Server Base Address'),
(4262, 'FH{{Family History}}'),
(4263, 'Fibroids'),
(4264, 'FIDO U2F - Universal 2nd Factor from the Fast IDentity Online alliance'),
(4265, 'Field'),
(4266, 'Field \'name\' cannot be NULL'),
(4267, 'Field ID'),
(4268, 'Field not suitable for edit option M'),
(4269, 'Field type to use for employer or subscriber country in demographics.'),
(4270, 'Field type to use for employer or subscriber state in demographics.'),
(4271, 'Field(s) are missing!'),
(4272, 'FIELD: Text(.a); '),
(4273, 'Fields in This Form'),
(4274, 'Fields{{visual fields}}'),
(4275, 'Fifth account message'),
(4276, 'Fijian'),
(4277, 'File'),
(4278, 'File base name becomes Menu selection'),
(4279, 'File Error'),
(4280, 'file in the Documentation directory to learn how to automate the process of creating log backups'),
(4281, 'file location'),
(4282, 'File management'),
(4283, 'file missing'),
(4284, 'File Name'),
(4285, 'File not found'),
(4286, 'File Not Found'),
(4287, 'File on server (modification date)'),
(4288, 'File path not found.'),
(4289, 'File privilege granted to OpenEMR user.'),
(4290, 'File retrieval from CouchDB failed'),
(4291, 'File Room'),
(4292, 'File to upload'),
(4293, 'File to Upload'),
(4294, 'File with same name already exists at location:'),
(4295, 'Filename'),
(4296, 'Filename must end with \".pdf\"'),
(4297, 'Files'),
(4298, 'Files base name becomes a pending document selection in Portal Documents.'),
(4299, 'Files type white list'),
(4300, 'Files with empty thumbnail'),
(4301, 'filetype is not accepted'),
(4302, 'Filipino'),
(4303, 'fill'),
(4304, 'Fill any of the Below Row.'),
(4305, 'Fill here only if sending email notification to patients'),
(4306, 'Fill in any missing details or edit existing information. This will be saved in the patient\'s demographics page in openEMR'),
(4307, 'Fill in the CPT codes using the displayed format. The common E/M codes are already filled in, add more as needed'),
(4308, 'Fill in the details as required and click Save'),
(4309, 'Fill in the details for the Organ/Disease Panel as before and click Save to close the pop-up'),
(4310, 'Fill in the details in a fashion similar to that used for allergies'),
(4311, 'Fill in the necessary details in a fashion similar to that for Medical Problems'),
(4312, 'Fill in the reason and select a provider and clinic and click the Add Recall button to complete the process'),
(4313, 'Fill in the required details especially for the external facilities and click Save'),
(4314, 'Fill in the values below'),
(4315, 'Fill Instructions'),
(4316, 'Fill the Row.'),
(4317, 'Fill your first and last name'),
(4318, 'Filled'),
(4319, 'Filling in the other fields will help provide additional details pertinent to the referral'),
(4320, 'Filter'),
(4321, 'Filter for Constants'),
(4322, 'Filter for Definitions'),
(4323, 'filtered from'),
(4324, 'Filters'),
(4325, 'filters'),
(4326, 'Final'),
(4327, 'Final Diagnosis'),
(4328, 'Final diagnosis by specialist'),
(4329, 'Final Status'),
(4330, 'Financial'),
(4331, 'Financial Close Date (yyyy-mm-dd)'),
(4332, 'Financial Reporting - anything'),
(4333, 'Financial Reporting - anything (rep_a)'),
(4334, 'Financial Reporting - my encounters'),
(4335, 'Financial Reporting - my encounters (rep)'),
(4336, 'Financial Review'),
(4337, 'Financial Review Date'),
(4338, 'Financial Summary by Service Code'),
(4339, 'Financial transactions corresponding to the date range, if any, will be listed in the table'),
(4340, 'Find'),
(4341, 'Find Available'),
(4342, 'Find Available Appointments'),
(4343, 'Find Available{{Provider}}'),
(4344, 'Find Code History'),
(4345, 'Find Patient'),
(4346, 'Find Patient Education Materials'),
(4347, 'Find Procedure Order'),
(4348, 'Findings'),
(4349, 'Findings by specialist'),
(4350, 'Fine'),
(4351, 'Finish'),
(4352, 'Finish Payments'),
(4353, 'Finished'),
(4354, 'finished'),
(4355, 'Finished Deleting'),
(4356, 'Finnish'),
(4357, 'First'),
(4358, 'First account message'),
(4359, 'First day in the week'),
(4360, 'First day of the week'),
(4361, 'First Modern Contraception at this Clinic (with Prior Contraceptive Use)'),
(4362, 'First Modern Contraceptive Use (Lifetime)'),
(4363, 'First Name'),
(4364, 'First name'),
(4365, 'First Name Missing'),
(4366, 'First Name:'),
(4367, 'First Visit or Consultation'),
(4368, 'First visit: No Old Records'),
(4369, 'First-time visits only'),
(4370, 'Firstname Lastname'),
(4371, 'First{{Name}}'),
(4372, 'Fitness'),
(4373, 'Fitness Level'),
(4374, 'Fitness level for this player on this day'),
(4375, 'Fitness Testing'),
(4376, 'Fitness to Play'),
(4377, 'Fix encounter dates - any encounters'),
(4378, 'Fix encounter dates - any encounters (date_a)'),
(4379, 'Fix this'),
(4380, 'Fixed'),
(4381, 'FL'),
(4382, 'Flash'),
(4383, 'Flatulence'),
(4384, 'Flow'),
(4385, 'Flow Board'),
(4386, 'Flow Board will only display completed checkouts for this many minutes. Zero is continuous display.'),
(4387, 'Flow Board: Allow Date Range'),
(4388, 'Flow Board: Default Ending Date'),
(4389, 'Flow Board: Default Starting Date'),
(4390, 'Flow Board: Disable'),
(4391, 'Flow Board: display completed checkouts (minutes)'),
(4392, 'Flow Board: Enable Random Drug Testing'),
(4393, 'Flow Board: Ending Date'),
(4394, 'Flow Board: Max tests per Patient per year'),
(4395, 'Flow Board: Percentage of Patients to Drug Test'),
(4396, 'Flow Board: Show Encounter Number'),
(4397, 'Flow Board: Show Patient ID'),
(4398, 'Flow Board: Show Staff Action'),
(4399, 'Flow Board: Show Visit Reason'),
(4400, 'Flow Board: Timer Refresh Interval'),
(4401, 'Flu season'),
(4402, 'Flu Season'),
(4403, 'Flu Vaccination'),
(4404, 'Fluid and electrolyte problem'),
(4405, 'FMS'),
(4406, 'Folio Paper Size'),
(4407, 'Follow manually'),
(4408, 'Follow these instructions for installing or upgrading the following database'),
(4409, 'Follow Up'),
(4410, 'Follow up for'),
(4411, 'Follow Up Note'),
(4412, 'Follow Up Reason'),
(4413, 'Following audit log entry number is missing'),
(4414, 'Following is a new custom constant:'),
(4415, 'Following is a new custom language:'),
(4416, 'Following is a new definition (Language, Constant, Definition):'),
(4417, 'Following rows in the audit log have been tampered'),
(4418, 'Followup Services'),
(4419, 'Followups Indicated'),
(4420, 'Font Size'),
(4421, 'Font Size in Pt'),
(4422, 'Food Intolerance'),
(4423, 'Foot'),
(4424, 'Foot Problems'),
(4425, 'Foot:'),
(4426, 'Football Injuries'),
(4427, 'Football Injury'),
(4428, 'Football Injury Report'),
(4429, 'Footwear Type'),
(4430, 'for'),
(4431, 'For'),
(4432, 'for '),
(4433, 'For a Recognized Panel of Tests'),
(4434, 'For a search to show results the codes must exist in the database.'),
(4435, 'For added ease of use the Fee Sheet needs to be customized'),
(4436, 'For an existing patient, go to Patient Summary->Documents. For a new patient, go to Miscellanous->New Documents'),
(4437, 'For automatically sending claims that are generated in EDI directory to the X12 partner using SFTP credentials X12 Partner Settings'),
(4438, 'For Category'),
(4439, 'For code'),
(4440, 'For Custom Groups'),
(4441, 'For Dates'),
(4442, 'For detailed instructions close the \'Enter Details\' pop-up and click on the Help icon on the main form. '),
(4443, 'For detailed instructions close the \'Enter Provider Details\' popup and click on the Help icon on the main form. '),
(4444, 'For each issue type there is a list of commonly selected titles which are customizable for your clinic\'s specific needs'),
(4445, 'For ease of use it is rendered as a unique 6 digit number'),
(4446, 'For editing the values under Procedures you would need to modify'),
(4447, 'For Encounter Claims'),
(4448, 'for Encounter on'),
(4449, 'For example:'),
(4450, 'For example: Privacy_Agreement.txt becomes \"Privacy Agreement\" button in Patient Documents.'),
(4451, 'For example: Privacy_Agreement.txt becomes Privacy Agreement button in Patient Documents.'),
(4452, 'For Firefox click'),
(4453, 'For full billing functionality in the United States CPT/HCPCS codes will then need to be installed'),
(4454, 'For HCFA 02/12 Box 15 is Other Date with a qualifier to specify what the date indicates'),
(4455, 'For HCFA 02/12 Onset date specified on the Encounter Form needs a qualifier'),
(4456, 'For Identifying Code use 34392 the code used by a major lab, if using an external lab this is a vendor specific code if not you can assign any unique value'),
(4457, 'for Invoice'),
(4458, 'For IPPF Argentina and maybe others'),
(4459, 'For IPPF Belize and maybe others'),
(4460, 'For IPPF Suriname and maybe others'),
(4461, 'For manual lab entry you can give the organization any name  - e.g Local Lab and click Save'),
(4462, 'For Medicare only, forces the referring provider to be the same as the rendering provider.'),
(4463, 'For Mental Status'),
(4464, 'For more information on Issues see the '),
(4465, 'For NetSuite financial integration'),
(4466, 'for OBR placer order number'),
(4467, 'for patient'),
(4468, 'For procedures performed in the practice, whether it is an office based procedure or a lab or radiological procedure done in the facility, the provider can be defined as Local Lab, Office Based or have any descriptive name'),
(4469, 'For proper display of results the Identifying Codes for each test entered in the Procedure Orders module has to be unique'),
(4470, 'For proper display of results this is a required field'),
(4471, 'For proper display of the order and results the entry indicating a result has to be the immediate successor or child of an order'),
(4472, 'For proper tabulated display of tests and results an identifying code is required'),
(4473, 'For Provider'),
(4474, 'For Referred Organization/Practitioner'),
(4475, 'For sending claims directly to insurance company, based on X12 Partner Settings'),
(4476, 'For the deceased notification to appear the date of death must be noted under Medical Dashboard > Edit Demographics > Misc'),
(4477, 'For the name to appear on the drop-down list it must be first entered in Administration > Address Book '),
(4478, 'For the past'),
(4479, 'For the Procedure Module to be useful several tests have to be setup using the above methods'),
(4480, 'For the Standard Code use the LOINC code 24326-1'),
(4481, 'For this name to show in the drop-down box in the Procedures > Providers setup page select only Lab Service as the Type even if it represents a Radiological facility'),
(4482, 'for this patient not yet assigned to any encounter.'),
(4483, 'For those interested details of OTP'),
(4484, 'For those interested in details of what constitutes a Continuity of Care Record (CCR) click on the eye icon'),
(4485, 'For those interested in what happens under the hood'),
(4486, 'For those lines the Description will indicate the details of the code'),
(4487, 'For those with administrative privileges an icon is displayed next to the My Messages caption'),
(4488, 'For TOTP to work a unique secret key must be shared between OpenEMR and the user'),
(4489, 'For U2F support on Linux click'),
(4490, 'for variable'),
(4491, 'for:'),
(4492, 'Force Billing Widget Open'),
(4493, 'Force claim balancing in EOB Posting'),
(4494, 'Force Create New Patient'),
(4495, 'Force logging of all Emergency User (ie. breakglass) activities.'),
(4496, 'Force Show'),
(4497, 'Forearm'),
(4498, 'Form'),
(4499, 'form'),
(4500, 'Form element not found'),
(4501, 'Form Keys'),
(4502, 'Form signed successfully'),
(4503, 'Form validation failed. Fix any errors and resubmit.'),
(4504, 'Format'),
(4505, 'format'),
(4506, 'Format for age display'),
(4507, 'Format incorrect for NDC'),
(4508, 'Format used to display most dates.'),
(4509, 'Format used to display most times.'),
(4510, 'Formatted Report'),
(4511, 'Former smoker'),
(4512, 'Forms'),
(4513, 'Forms Administration'),
(4514, 'Forms Administration (forms)'),
(4515, 'Forms Esigned'),
(4516, 'Formularies are inserted into table'),
(4517, 'Formularies inserted into table'),
(4518, 'Forward'),
(4519, 'FORWARD A DATED REMINDER'),
(4520, 'Forward message to practice.'),
(4521, 'Forward one drawing'),
(4522, 'Forward Pages via Fax'),
(4523, 'Forward this Reminder'),
(4524, 'Forward to current canvas'),
(4525, 'Forwarded'),
(4526, 'Forwarded Portal Message Re: '),
(4527, 'Foster Child'),
(4528, 'Fourth'),
(4529, 'Fourth account message'),
(4530, 'Fracture'),
(4531, 'Fracture at the Navicula'),
(4532, 'Fracture lateral malleolus'),
(4533, 'Fracture medial malleolus'),
(4534, 'Fracture, Base of fifth (5th) Metatarsal'),
(4535, 'Frame'),
(4536, 'Frame support required'),
(4537, 'Free authenticator app'),
(4538, 'French'),
(4539, 'French (Canadian)'),
(4540, 'French (Standard)'),
(4541, 'Frequency'),
(4542, 'Frequent Colds'),
(4543, 'Frequent Illness'),
(4544, 'Fri'),
(4545, 'Friday'),
(4546, 'Friend'),
(4547, 'From'),
(4548, 'FROM'),
(4549, 'from'),
(4550, 'From Date Cannot be Greater than To Date.'),
(4551, 'From date should be less than To date'),
(4552, 'From Period'),
(4553, 'From the Issues Menu item on the Nav Bar'),
(4554, 'From the Patient dashboard via the individual Issues widgets on the right hand column'),
(4555, 'From your clinic'),
(4556, 'From:'),
(4557, 'From: '),
(4558, 'FROM_CITY'),
(4559, 'FROM_EMAIL'),
(4560, 'FROM_FNAME'),
(4561, 'FROM_LNAME'),
(4562, 'FROM_MNAME'),
(4563, 'FROM_PHONE'),
(4564, 'FROM_PHONECELL'),
(4565, 'FROM_POSTAL'),
(4566, 'FROM_STATE'),
(4567, 'FROM_STREET'),
(4568, 'FROM_TITLE'),
(4569, 'FROM_VALEDICTORY'),
(4570, 'Front'),
(4571, 'Front Office'),
(4572, 'Front Office by Phone'),
(4573, 'Front Office in Person'),
(4574, 'Front Office Receipts'),
(4575, 'Front Office Receipts Report'),
(4576, 'Front Rec'),
(4577, 'Frontal Right:'),
(4578, 'Fr{{Friday}}'),
(4579, 'FTCF{{Full to count fingers}}'),
(4580, 'FTN{{Finger Tension abbreviation}}'),
(4581, 'FT{{finger tension}}'),
(4582, 'Fula- Fulah- Pulaar- Pular'),
(4583, 'Full Editor'),
(4584, 'Full Logging'),
(4585, 'Full Name'),
(4586, 'Full or Initial'),
(4587, 'Full path to directory containing MySQL executables.'),
(4588, 'Full path to directory containing Perl executables.'),
(4589, 'Full path to directory for event log backup.'),
(4590, 'Full path to directory used for temporary files.'),
(4591, 'Full path to your node executable for starting external node.js processes.'),
(4592, 'Full Play'),
(4593, 'Full Screen'),
(4594, 'Full Training'),
(4595, 'Fullscreen'),
(4596, 'Fully Paid'),
(4597, 'Functional'),
(4598, 'Functional and Cognitive Status'),
(4599, 'Functional and Cognitive Status Form'),
(4600, 'Functional Cognitive Status'),
(4601, 'Functional Condition'),
(4602, 'Funding Source'),
(4603, 'Further information regarding using the e-prescribing modules can be found by clicking this link'),
(4604, 'Future'),
(4605, 'Future Appointments'),
(4606, 'F{{Friday}}'),
(4607, 'G'),
(4608, 'G/DL'),
(4609, 'GAD-7'),
(4610, 'Galaxy S9/S9 Plus'),
(4611, 'Galician'),
(4612, 'Gall Bladder Condition'),
(4613, 'Gall Stones'),
(4614, 'Game Period'),
(4615, 'Games'),
(4616, 'Games Missed'),
(4617, 'games/events'),
(4618, 'Games/Events Missed'),
(4619, 'Ganda'),
(4620, 'Gastritis'),
(4621, 'Gastro Pain'),
(4622, 'Gastrointestinal'),
(4623, 'Gateway API Login Auth Name or Secret'),
(4624, 'Gateway for AuthorizeNet Manual Payments'),
(4625, 'Gateway for Sphere Payments'),
(4626, 'Gateway for Stripe Manual Payments'),
(4627, 'Gateway Publishable Key'),
(4628, 'Gateway Transaction Key'),
(4629, 'GCAC statistical reports.'),
(4630, 'GCAC Statistics Report'),
(4631, 'GCAC Statistics Reporting'),
(4632, 'GCAC Stats'),
(4633, 'GCAC visit form is missing'),
(4634, 'Gender'),
(4635, 'Gender '),
(4636, 'Gender Missing'),
(4637, 'General'),
(4638, 'General Anxiety Disorder 7 (GAD-7)'),
(4639, 'General data'),
(4640, 'General Issue List'),
(4641, 'General physician'),
(4642, 'General Service Category'),
(4643, 'General Tab - lists the risk factors / past medical conditions on the left and the Results of various clinical exams, procedures and tests on the right'),
(4644, 'General Theme'),
(4645, 'General Theme (need to logout/login after change this setting)'),
(4646, 'Generally a good idea to include it'),
(4647, 'Generally, the first field in a group should be Label Cols = 1 Data Cols = number of Layout columns from Group Properties.'),
(4648, 'Generate'),
(4649, 'Generate and download CMS 1500 paper claims'),
(4650, 'Generate and download CMS 1500 paper claims on Preprinted form'),
(4651, 'Generate and download HCFA 1500 paper claims'),
(4652, 'Generate and download UB-04 CMS1450'),
(4653, 'Generate and download UB-04 CMS1450 with form'),
(4654, 'Generate and download X12 batch'),
(4655, 'Generate and download X12 encounter claim batch'),
(4656, 'Generate and transmit permissible prescriptions electronically (All Prescriptions).'),
(4657, 'Generate and transmit permissible prescriptions electronically (Not including controlled substances).'),
(4658, 'Generate and transmit permissible prescriptions electronically.'),
(4659, 'Generate CMS 1500'),
(4660, 'Generate CMS 1500 PDF'),
(4661, 'Generate CMS 1500 TEXT'),
(4662, 'Generate HCFA'),
(4663, 'Generate Institutional X12 837I'),
(4664, 'Generate Invoice'),
(4665, 'Generate Letter'),
(4666, 'Generate Letter regarding '),
(4667, 'Generate new key'),
(4668, 'Generate New Receipt Number'),
(4669, 'Generate New Report'),
(4670, 'Generate PQRI report (Method A)'),
(4671, 'Generate PQRI report (Method A) - 2011'),
(4672, 'Generate PQRI report (Method E)'),
(4673, 'Generate PQRI report (Method E) - 2011'),
(4674, 'Generate QRDA I – 2014'),
(4675, 'Generate QRDA III - 2014'),
(4676, 'Generate Report'),
(4677, 'Generate Report - that opens the CCD in a separate tab on the browser'),
(4678, 'Generate Report - that opens the CCR in a separate tab on the browser'),
(4679, 'Generate Report that creates a report and displays it in a separate tab on the browser '),
(4680, 'Generate safe key'),
(4681, 'Generate thumbnail'),
(4682, 'Generate thumbnail images'),
(4683, 'Generate Thumbnails'),
(4684, 'Generate Username And Password For'),
(4685, 'Generate X-12 Based On Insurance Company'),
(4686, 'Generate X12'),
(4687, 'Generate X12 837I'),
(4688, 'Generate X12 Encounter'),
(4689, 'Generate/Download QRDA I - 2014'),
(4690, 'Generated on'),
(4691, 'Generated thumbnail(s)'),
(4692, 'Generates'),
(4693, 'Generating and charting requisition for PSC Hold Order'),
(4694, 'Generating preview data. Please Wait'),
(4695, 'Generating requisition based on order HL7 content'),
(4696, 'Genericname1'),
(4697, 'Genericname2'),
(4698, 'Genericval1'),
(4699, 'Genericval2'),
(4700, 'Genitourinary'),
(4701, 'Genitourinary medicine physician'),
(4702, 'GEN{{General}}'),
(4703, 'Georgian'),
(4704, 'German'),
(4705, 'Gest age'),
(4706, 'Gest wks'),
(4707, 'Gestational Age'),
(4708, 'Get History'),
(4709, 'GET HL7'),
(4710, 'Get HL7'),
(4711, 'Get Started'),
(4712, 'Gift Card Customer requires at least one Gift Card Payment Method'),
(4713, 'Give a Name to this group, in our case it will be called Serum Chemistry'),
(4714, 'Give it a sequence number of 3'),
(4715, 'GI{{Gastrointestinal}}'),
(4716, 'Glare{{Acuity under Glare conditions}}'),
(4717, 'Glaucoma'),
(4718, 'Glaucoma Family History'),
(4719, 'Glaucoma Zone'),
(4720, 'Global'),
(4721, 'Global All Patients'),
(4722, 'Global Default Patient Country'),
(4723, 'Global ID'),
(4724, 'Global Settings'),
(4725, 'Globals'),
(4726, 'GM/DL'),
(4727, 'GO'),
(4728, 'Go'),
(4729, 'go'),
(4730, 'Go Back'),
(4731, 'Go back'),
(4732, 'Go to'),
(4733, 'Go to Administration > Address Book > Add New'),
(4734, 'Go to Administration > Globals > CDR > Dated reminders maximum alerts to show and change the value to a higher number'),
(4735, 'Go to Administration > Globals > Connectors'),
(4736, 'Go to Administration > Globals > Connectors and check the Enable MedEx Communication Service check box and click Save'),
(4737, 'Go to Administration > Lists, select each one of the above lists from the drop-down box and make changes as needed'),
(4738, 'Go to Administration > Lists. Select \'Fee Sheet\' from the dropdown box'),
(4739, 'Go to Adminstration > Codes. Select ICD 10 under Type, enter ICD 10 Code, enter Description, under category select an appropriate category, this ICD 10 code will then appear when the button with that category is clicked'),
(4740, 'Go to Adminstration > Lists and select \'Code Types\' from the dropdown box. Use either ICD 9 or ICD 10, inactivate ICD 9 and select \'No\' in the last dropdown box under ICD 10'),
(4741, 'Go to Duplicate Manager'),
(4742, 'Go to Procedures > Providers and click on the Add New button'),
(4743, 'Go to week of'),
(4744, 'Go Today'),
(4745, 'Goal A'),
(4746, 'Goal and Methods'),
(4747, 'Goal B'),
(4748, 'Goal C'),
(4749, 'Gonioscopy'),
(4750, 'Gonio{{Gonioscopy abbreviation}}'),
(4751, 'Google Auth'),
(4752, 'Google Email for Login'),
(4753, 'Google reCAPTCHA V2 secret key'),
(4754, 'Google reCAPTCHA V2 site key'),
(4755, 'Google Sign-In Client ID'),
(4756, 'Got It'),
(4757, 'Grace Period'),
(4758, 'Grade of Injury'),
(4759, 'Grade:'),
(4760, 'grams'),
(4761, 'Grand Total'),
(4762, 'Grand Totals'),
(4763, 'Grandchild'),
(4764, 'Grandparent'),
(4765, 'Grant Type'),
(4766, 'Graphable'),
(4767, 'Great Grandparent'),
(4768, 'Greater Than'),
(4769, 'Greater Than or Equal To'),
(4770, 'Greek'),
(4771, 'Greek, Modern'),
(4772, 'Green lines show changes that were successfully applied.'),
(4773, 'Group'),
(4774, 'Group > Group > Procedure Order > Discrete Result'),
(4775, 'Group > Procedure Order > Discrete Result'),
(4776, 'Group appointments'),
(4777, 'Group Attendance Form'),
(4778, 'Group Attendance Statuses'),
(4779, 'Group detailed log of appointment in patient record'),
(4780, 'Group detailed log of appointment in patient record (gdlog)'),
(4781, 'Group Details'),
(4782, 'Group Encounter'),
(4783, 'Group Encounter Form'),
(4784, 'Group encounter log'),
(4785, 'Group encounter log (glog)'),
(4786, 'Group Finder'),
(4787, 'Group Home'),
(4788, 'Group Id'),
(4789, 'Group name'),
(4790, 'Group Name'),
(4791, 'Group names cannot be blank'),
(4792, 'Group names cannot start with numbers or spaces.'),
(4793, 'Group names cannot start with numbers.'),
(4794, 'Group Number'),
(4795, 'Group number'),
(4796, 'Group Payment'),
(4797, 'Group Properties'),
(4798, 'Group Search'),
(4799, 'Group Statuses'),
(4800, 'Group Type'),
(4801, 'Group\'s name'),
(4802, 'Group:'),
(4803, 'groupname'),
(4804, 'Groupname'),
(4805, 'Groups'),
(4806, 'Groups (groups)'),
(4807, 'Groups and Access Controls'),
(4808, 'Groups successfully saved.'),
(4809, 'Growth Chart'),
(4810, 'Growth-Chart'),
(4811, 'gtts(drops)'),
(4812, 'Guamanian'),
(4813, 'Guarani'),
(4814, 'Guaraní'),
(4815, 'Guardian'),
(4816, 'Guardian Email Address'),
(4817, 'Guardian\'s Name'),
(4818, 'Guardians Name'),
(4819, 'Guest counselors'),
(4820, 'Gujarati'),
(4821, 'GU{{Genitourinary}}'),
(4822, 'Gynecological Exam'),
(4823, 'h'),
(4824, 'H(T){{intermittent hypertropia}}'),
(4825, 'h.s.'),
(4826, 'H/O Hepatitis'),
(4827, 'had been successfully deleted. Any sub-categories if present were moved below'),
(4828, 'Haematoma / bruising'),
(4829, 'HAI Status'),
(4830, 'Haitian- Haitian Creole'),
(4831, 'Half-Sibling'),
(4832, 'Hand + fingers'),
(4833, 'Hand Problems'),
(4834, 'Handicapped dependent'),
(4835, 'Happy Birthday'),
(4836, 'Hard copy OTP'),
(4837, 'Hard copy OTP is used for online banking in some countries'),
(4838, 'Hard Disk'),
(4839, 'Hardship w/o'),
(4840, 'has been linked to visit'),
(4841, 'has expired'),
(4842, 'Hash'),
(4843, 'Hash Algorithm for Authentication'),
(4844, 'Hash did not exist for this file. A new hash was generated.'),
(4845, 'Hash does not match. Data integrity has been compromised.'),
(4846, 'Hashing algorithm for authentication. Suggest PHP Default unless you know what you are doing.'),
(4847, 'Hausa'),
(4848, 'Hawaiian'),
(4849, 'Hazardous activities'),
(4850, 'Hazardous Activities'),
(4851, 'HB{{abbreviation for Horizontal Prism Base}}'),
(4852, 'HCFA 1500 or CMS 1500 - both refer to the same form. Prior to 2001 the federal agency within the United States Department of Health and Human Services (HHS) that administers the Medicare program was called Health Care Financing Administration (HCFA) since then it is called Centers for Medicare & Medicaid Services (CMS)'),
(4853, 'HCFA FORM'),
(4854, 'HCFA left margin in points'),
(4855, 'HCFA Margins'),
(4856, 'HCFA top margin in points'),
(4857, 'HCPCS Procedure/Service'),
(4858, 'HD'),
(4859, 'HD+'),
(4860, 'he PostCalendar '),
(4861, 'Head'),
(4862, 'Head Circ'),
(4863, 'Head Circumference'),
(4864, 'Headache'),
(4865, 'Headaches'),
(4866, 'Header'),
(4867, 'header invalid'),
(4868, 'health care operations'),
(4869, 'Health Care Operations'),
(4870, 'Health Care Providers'),
(4871, 'Health centre/clinic'),
(4872, 'Health Insurance Claim Form'),
(4873, 'Health Level-7 or HL7 refers to a set of international standards for transfer of clinical and administrative data between software applications used by various healthcare providers'),
(4874, 'Health Maintenance Organization'),
(4875, 'Health Maintenance Organization (HMO) Medicare Risk'),
(4876, 'Healthcare facility'),
(4877, 'Hearing Loss'),
(4878, 'Heart Attack'),
(4879, 'Heart Disease'),
(4880, 'Heart Failure'),
(4881, 'Heart Problem'),
(4882, 'Heart Problems'),
(4883, 'Heart Surgery'),
(4884, 'Heart Transplant'),
(4885, 'HEART:'),
(4886, 'Heartburn'),
(4887, 'Heat or Cold'),
(4888, 'Heat Or Cold'),
(4889, 'Heavy tobacco smoker'),
(4890, 'Hebrew'),
(4891, 'Hebrew (modern)'),
(4892, 'HEENT'),
(4893, 'Height'),
(4894, 'Height/Length'),
(4895, 'Help'),
(4896, 'help'),
(4897, 'Help content goes here'),
(4898, 'Hematemesis'),
(4899, 'Hematochezia'),
(4900, 'Hematologic'),
(4901, 'Hematuria'),
(4902, 'Hemoglobin'),
(4903, 'Hemoglobin A1C'),
(4904, 'Hemoptysis'),
(4905, 'Hepatitis'),
(4906, 'Hepatitis A 1'),
(4907, 'Hepatitis A 2'),
(4908, 'Hepatitis B 1'),
(4909, 'Hepatitis B 2'),
(4910, 'Hepatitis B 3'),
(4911, 'here'),
(4912, 'Here is what we do know.'),
(4913, 'Here you can customize the ACL further.'),
(4914, 'Herero'),
(4915, 'Hernia Repair'),
(4916, 'Herniated Disc'),
(4917, 'Herpes'),
(4918, 'Hertel Exophthalmometry'),
(4919, 'HERT{{Hertel exophthalmometry}}'),
(4920, 'Hesitancy'),
(4921, 'heyyo. you have been here for '),
(4922, 'Hib 1'),
(4923, 'Hib 2'),
(4924, 'Hib 3'),
(4925, 'Hib 4'),
(4926, 'Hidden'),
(4927, 'Hidden Events Administration'),
(4928, 'Hide'),
(4929, 'Hide Billing Widget'),
(4930, 'Hide Details'),
(4931, 'hide else set to'),
(4932, 'Hide Empty E-Sign Logs On Report'),
(4933, 'Hide Encryption/Decryption Options In Document Management'),
(4934, 'Hide Help Modal'),
(4935, 'Hide Menu'),
(4936, 'Hide print feature'),
(4937, 'Hide Reminders'),
(4938, 'hide this field'),
(4939, 'Hide/Show Columns'),
(4940, 'HIE'),
(4941, 'High'),
(4942, 'High (high)'),
(4943, 'High Blood Pressure'),
(4944, 'High{{Priority}}'),
(4945, 'Hindi'),
(4946, 'Hip + groin'),
(4947, 'Hip and groin'),
(4948, 'Hip Problems'),
(4949, 'Hip Replacement'),
(4950, 'Hipaa Message'),
(4951, 'HIPAA Notice Received'),
(4952, 'Hiri Motu'),
(4953, 'Hirsutism/Striae'),
(4954, 'Hispanic'),
(4955, 'Hispanic - Other (Born in US)'),
(4956, 'Hispanic - Other (Born outside US)'),
(4957, 'Hispanic or Latino'),
(4958, 'Historical information -source unspecified'),
(4959, 'History'),
(4960, 'History & Lifestyle'),
(4961, 'History - patient\'s past medical history, family history, personal history'),
(4962, 'History and Lifestyle'),
(4963, 'History and Lifestyle Help'),
(4964, 'History and Physical 2008'),
(4965, 'History Data'),
(4966, 'History Date'),
(4967, 'History Fields'),
(4968, 'History Murmur'),
(4969, 'History not authorized'),
(4970, 'History of Heart Murmur'),
(4971, 'History of Present Illness: A detailed HPI may be completed by using either four or more HPI elements OR the status of three chronic or inactive problems.'),
(4972, 'History Order'),
(4973, 'History order'),
(4974, 'Hits'),
(4975, 'HIV'),
(4976, 'Hives'),
(4977, 'HL7'),
(4978, 'HL7 - MSH-11 - Processing ID'),
(4979, 'HL7 - MSH-3.1 - Sending application'),
(4980, 'HL7 - MSH-4.1 - Sending facility'),
(4981, 'HL7 - MSH-5.1 - Receiving application'),
(4982, 'HL7 - MSH-6.1 - Receiving facility'),
(4983, 'HL7 Code'),
(4984, 'HL7 is supported by more than 1,600 members from over 50 countries, making it a widely accepted standard'),
(4985, 'HL7 Viewer'),
(4986, 'HL7-V3 Concept Code'),
(4987, 'HMOL/L'),
(4988, 'Hmong'),
(4989, 'Hold down [Ctrl] for multiple selections or to unselect'),
(4990, 'Hold down Ctrl button to select multiple issues'),
(4991, 'Hold down Ctrl to select multiple items'),
(4992, 'Hold down Ctrl to select multiple squads'),
(4993, 'Hold on! You have unsaved changes in another form. Please just Save this form and then complete the other one.'),
(4994, 'Holidays management'),
(4995, 'Home'),
(4996, 'Home Facility'),
(4997, 'Home Phone'),
(4998, 'Home Phone Number'),
(4999, 'Homeless'),
(5000, 'Homeless or similar?'),
(5001, 'Homeless Shelter'),
(5002, 'Homeless, etc'),
(5003, 'Homeless, etc.'),
(5004, 'Hooks'),
(5005, 'Horiz Base{{abbreviation for Horizontal Prism Base}}'),
(5006, 'Horiz Prism{{abbreviation for Horizontal Prism Power}}'),
(5007, 'Horizontal Prism Base'),
(5008, 'Horizontal Prism Power'),
(5009, 'Hospice'),
(5010, 'Hospital date needed for successful billing of hospital encounters'),
(5011, 'Host'),
(5012, 'Host Name'),
(5013, 'Host Name cannot be empty'),
(5014, 'hour'),
(5015, 'Hour'),
(5016, 'Hours'),
(5017, 'hours'),
(5018, 'How bad is it? 0-10, mild, mod, severe?'),
(5019, 'How did Injury Occur?'),
(5020, 'How did Injury Occur?:'),
(5021, 'How did they hear about us'),
(5022, 'How difficult have these problems made it to do work, take care of things at home, or get along with other people?'),
(5023, 'How long does it last?'),
(5024, 'How many months ahead to query for upcoming events?'),
(5025, 'How many sets of specimen labels to create?'),
(5026, 'How often have you been bothered by the following over the past 2 weeks?'),
(5027, 'How Paid'),
(5028, 'How Referred'),
(5029, 'How to display the patient name'),
(5030, 'How to sort a drop-lists'),
(5031, 'How-to Build the Impression/Plan'),
(5032, 'However SMS text messages can be intercepted and the use of SMS as a method of implementing out-of-band two-factor authentication is discouraged'),
(5033, 'However, you can not use this email for patient registration since it is already being used.'),
(5034, 'HPI'),
(5035, 'HPI Elements'),
(5036, 'HPI:'),
(5037, 'HP{{abbreviation for Horizontal Prism Power}}'),
(5038, 'HT'),
(5039, 'HTML'),
(5040, 'HTML Output?'),
(5041, 'HTN{{hypertension}}'),
(5042, 'Http Error'),
(5043, 'Https link for the OpenEMR Support LLC Lab Exchange Service.'),
(5044, 'HT{{hyperphoria}}'),
(5045, 'Hungarian'),
(5046, 'Hylafax Directory'),
(5047, 'Hylafax Enscript Command'),
(5048, 'Hylafax Server'),
(5049, 'Hylafax server hostname.'),
(5050, 'Hyperactive'),
(5051, 'Hyperphoria'),
(5052, 'Hypertension'),
(5053, 'Hypertension: Blood Pressure Measurement'),
(5054, 'Hypertension: Blood Pressure Measurement (CQM)'),
(5055, 'Hyperthyroidism'),
(5056, 'hypo(T){{intermittent hypotropia}}'),
(5057, 'Hypothyroidism'),
(5058, 'Hypotropia'),
(5059, 'hypoT{{hypotropia}}'),
(5060, 'Hysterectomy'),
(5061, 'I'),
(5062, 'I am busy during this time.'),
(5063, 'I do not have permission to read '),
(5064, 'I have read and accept the'),
(5065, 'I have read and my practice agrees to the'),
(5066, 'I know but we need it!'),
(5067, 'IBAN'),
(5068, 'ICD'),
(5069, 'ICD10'),
(5070, 'ICD10 Diagnosis'),
(5071, 'ICD10 Procedure/Service'),
(5072, 'ICD9'),
(5073, 'ICD9 Diagnosis'),
(5074, 'ICD9 Procedure/Service'),
(5075, 'Icelandic'),
(5076, 'icon'),
(5077, 'Icon Legend'),
(5078, 'Icons'),
(5079, 'ID'),
(5080, 'id'),
(5081, 'Id'),
(5082, 'ID - select a unique three letter id, all in lower case'),
(5083, 'ID cannot be blank'),
(5084, 'ID Card'),
(5085, 'ID Card / Photos'),
(5086, 'ID Card/Photos - will display any ID Card or patient photo that has been uploaded to Documents > Patient Information > Patient ID Card and Patient Photograph folders'),
(5087, 'ID Number (ETIN)'),
(5088, 'IDays'),
(5089, 'identified as'),
(5090, 'Identifier'),
(5091, 'Identifier(one word)'),
(5092, 'Identifying Code'),
(5093, 'Idle Session Timeout Seconds'),
(5094, 'Ido'),
(5095, 'if'),
(5096, 'If a field\'s Data Col = 0 the data field will immediately follow its label field on the same line'),
(5097, 'If a field\'s Label Col = 0 the label will immediately follow the previous data field in the Order sequence, on the same line as the Data field.'),
(5098, 'If a field\'s Label Col = 1 the label field will go to a new line unless the previous field\'s total column values (Label + Data) is less than number of Layout columns from Group Properties or Layout Properties.'),
(5099, 'If a product is sold then change the default to reflect required number. Leave it at one for procedures'),
(5100, 'If a wrong code was selected click on the Coding text-box to to bring up the Select Codes pop-up page'),
(5101, 'If all data for all columns are complete for this form'),
(5102, 'If all the details were entered correctly you will see Blood Glucose in the Name column with a vertical bar before it indicating that it has no descendants or children, Result in the Category column, WWT01R in the Code column, the Tier column value should be 3 and the Description column should say Fasting Glucose result'),
(5103, 'If billing justification is used enter the name of the diagnosis code type.'),
(5104, 'If configured correctly the Name column should say Blood Glucose with a vertical bar before it indicating no descendants or children, the Category column should say Custom Order and both Name and Category columns will be highlighted in pink indicating a custom grouped order'),
(5105, 'If desired the current message can be printed'),
(5106, 'If enabled, this will send the execution time it took to verify hash to the php error log.'),
(5107, 'If enabled, use LDAP for login and authentication.'),
(5108, 'If enabled, uses the specified active directory for login and authentication.'),
(5109, 'if entered, select only those who have had this service'),
(5110, 'If it it still active i.e. End Date is not entered it will be displayed in red, if the problem has an end Date then it will be displayed in black'),
(5111, 'If name, any part of lastname or lastname,firstname'),
(5112, 'If NewCrop eRx - the electronic prescription module, is enabled the NewCrop MedEntry and NewCrop Account Status buttons will be appear here'),
(5113, 'If not listed you can add the drug to the Title text-box'),
(5114, 'If nothing is selected here then all are permitted.'),
(5115, 'If only capture the QR code but do not register the TOTP key with OpenEMR this feature will not be enabled at login'),
(5116, 'If patient has appointment click OK to create encounter otherwise, cancel this and then create an encounter for today visit.'),
(5117, 'If paying by'),
(5118, 'If person is deceased, then enter date of death.'),
(5119, 'If phone is lost will not be able to login'),
(5120, 'If privileges have to be modified then it can be done either one user at a time at Administration > Users or more conveniently on this page i.e. Administration > ACL where all users are listed on one page and more options are available.'),
(5121, 'If set as high will restrict visibility of encounter to users belonging to certain groups (AROs). By default - Physicians and Administrators'),
(5122, 'If SMTP is used, the server`s hostname or IP address.'),
(5123, 'If SMTP is used, the server`s TCP port number (usually 25).'),
(5124, 'If so desired the default board can be disabled by going to Administration > Calendar > Recall Board: Disable and checking the checkbox and click Save'),
(5125, 'If so you will have to create individual Procedure Orders (the orders) for these tests along with Discrete Results (the place to enter and display the returned result)'),
(5126, 'If successful it authenticates the user'),
(5127, 'If the checkbox is checked and the message is sent to multiple users then each user has to sign off on the message by clicking the Set As Completed Button for that message'),
(5128, 'If the checkbox is checked then each individual of a group receiving this message will have to sign off by clicking the Set As Completed button'),
(5129, 'If the csv file has been uploaded, then click on the \"Import holiday events\" button. NOTE that clicking on the button will remove all the existing rows in the calendar_external table'),
(5130, 'If the desired title is not included, it can be typed into the text box below the list'),
(5131, 'If the displayed table says No matching record found it means that the ICD10 code set is not installed'),
(5132, 'If the help file does not exist create one and place it in'),
(5133, 'If the issue has not been linked to an encounter it will display 0'),
(5134, 'If the medical problem is not listed in the drop-down box click on Coding text-box to bring up the Select Codes pop-up page'),
(5135, 'If the message is forwarded it will show up in the active messages list of the user to whom the message was forwarded and disappear from the current user\'s active messages list'),
(5136, 'If the Offsite Patient portal is enabled there will be either a button that says Create Offsite Portal Credentials provided the patient has given permission to access the online patient portal or a message that says Patient has not authorized the Patient Portal'),
(5137, 'If the Online Patient portal is enabled there will be either a button that says Create Online Portal Credentials provided the patient has given permission to access the online patient portal or a message that says Patient has not authorized the Patient Portal'),
(5138, 'If the Online/Offsite Portal Credentials has already been set the button will change to'),
(5139, 'If the patient has any demographic data entered in openEMR it will automatically populate the relevant fields on the right sections'),
(5140, 'If the patient has not authorized patient portal then a Patient has not authorized the Patient Portal message will be shown here'),
(5141, 'If the patient is being added to the recall list on the day of the visit it would reflect the current date'),
(5142, 'If the patient is calling back to be added to the list the last visit may be in the remote past. Be aware that the 1,2,3 plus years are calculated and displayed on the Date box at the bottom of this section'),
(5143, 'If the patient is deceased then the deceased notification will appear in red in this section'),
(5144, 'If the report is sent electronically all steps needed for safe and secure transmission of Protected Health Information (PHI) must be followed'),
(5145, 'If there is no vendor enter any arbitrary unique number, preferably a 5 digit zero-padded e.g. 00211'),
(5146, 'If these tests are being sent to the same external lab they will have identical vendor specific Identifying Codes causing duplicate lines to appear when results are displayed'),
(5147, 'If they have been configured correctly each result should have a Tier value of 4, indicating they are the successor or child to the first line above with a Tier value of 3, i.e Electrolyte Panel'),
(5148, 'If this page does not refresh, reload the Messages page manually'),
(5149, 'If unassigned will default to php.ini setting for date.timezone.'),
(5150, 'if unemployed enter Student'),
(5151, 'If value is left as zero, will be sorted alphabetically'),
(5152, 'If YMD is selected for age display, switch to just Years when patients older than this value in years'),
(5153, 'If you are having troubles logging into your account.'),
(5154, 'If you are interested in what happens under the hood'),
(5155, 'If you are only using a small subset of the CPT codes you can manually enter it in Administration > Codes'),
(5156, 'If you are planning on entering different prices for different modalities of payment go to Administration > Lists'),
(5157, 'If you are unsure or were using a development version between two releases, then choose the older of possible releases'),
(5158, 'If you are unsure or were using a development version between two releases, then choose the older of possible releases.'),
(5159, 'If you are upgrading from a version below 5.0.0 to version 5.0.0 or greater, do note that this upgrade can take anywhere from several minutes to several hours (you will only see a whitescreen until it is complete; do not stop the script before it is complete or you risk corrupting your data)'),
(5160, 'If you are using Electronic lab entry then fill in the required details and click Save'),
(5161, 'If you are using multiple labs enter the details for each one of them'),
(5162, 'If you change e-RX Role for ePrescription, it may affect the ePrescription workflow. If you face any difficulty, contact your ePrescription vendor.'),
(5163, 'If you change your Smartphone you can recapture the TOTP key QR code on to a new device by first logging in using the authenticator app on your old phone and then going to Miscellaneous > MFA Authentication and clicking the View button on the Current Authentication Method section'),
(5164, 'If you check the check box in any of these cells it will generate an entry in the last cell called Progress'),
(5165, 'If you choose to do a manual entry click the \'Invoice Search\' radio button. It displays two sections \'Post Item\' and \'Invoice Search\''),
(5166, 'If you choose to integrate lab results with the patient\'s record then some preliminary setup has to be performed'),
(5167, 'If you click on any user in the \'User Memberships\' section you will now see these newly created group (ARO) in the \'Inactive\' column. These can now be assigned in the usual fashion as needed.'),
(5168, 'If you click on the edit icon next to this newly created group (ARO) you will note that the \'Active\' column contains only a single entry - Placeholder (Maintains empty ACLs). As yet this new group (ARO) has NO access to any part of the program as there are no ACOs assigned in the \'Active\' column.'),
(5169, 'If you Click the blue + sign on Serum Chemistry you will see a new line called Organ/Disease Panel with a Category of Sub Group'),
(5170, 'If you continue to experience this error please contact support.'),
(5171, 'If you do not find a required value in the drop-down box you will need to add it via Administration > Lists > Procedure Units. Refer to the help file in Procedures > Providers'),
(5172, 'If you do not select a match the patient will be created.'),
(5173, 'If you do not select at least one of these, OpenEMR will operate in a receive-only mode'),
(5174, 'If you do not submit orders electronically or receive result electronically leave it as the default value, Download'),
(5175, 'If you do not want to allow this application to have offline access to your data, uncheck the offline_permission scope'),
(5176, 'If you do not want to do so the following method involves adding data manually using the openEMR interface'),
(5177, 'If you drill down to the Electrolyte Panel line and click on the + sign in the Name column you should see Sodium listed underneath it with a Category value of Result with a Tier value of 4'),
(5178, 'If you drill down to the Electrolyte Panel line you should see it have a Category of Order and be highlighted in yellow indicating that it is a search-able and valid order and has a Tier value of 3'),
(5179, 'If you had selected multiple codes they will be separated by semi-colons'),
(5180, 'If you have already filled the calendar_external table, then click on \"Synchronize\" button to have the holidays in the calendar view. NOTE that clicking on the button will remove all the existing items in the calendar view related to holidays'),
(5181, 'If you have an old superbill you can use its grouping of codes as a template to start the customization'),
(5182, 'If you have chosen to upload electronic remittances, then the search window redisplays itself with the matching invoices from the X12 file.  You may click on any of these invoice numbers (as described below) if you wish to make any corrections before the remittance information is applied. To apply the changes, click the Process ERA File button at the bottom of the page.  This will produce a new window with a detailed report.'),
(5183, 'If you have chosen to upload electronic remittances, then the search window redisplays itself with the matching invoices from the X12 file. You may click on any of these invoice numbers (as described above) if you wish to make any corrections before the remittance information is applied. To apply the changes, click the \'Process ERA File\' button at the bottom of the page. This will produce a new window with a detailed report.'),
(5184, 'If you have enabled the TOTP method the next time you login you will be asked to enter the TOTP password'),
(5185, 'If you have entered a Pay Date in the search page, this will override the posting date of payments and adjustments that are otherwise taken from the X12 file.  This may be useful for reporting purposes, if you want your receipts reporting to use your posting date rather than the insurance company\'s processing date.  Note that this will also affect dates of prior payments and adjustments that are put into secondary claims.'),
(5186, 'If you have entered a Pay Date in the search page, this will override the posting date of payments and adjustments that are otherwise taken from the X12 file. This may be useful for reporting purposes, if you want your receipts reporting to use your posting date rather than the insurance company\'s processing date. Note that this will also affect dates of prior payments and adjustments that are put into secondary claims.'),
(5187, 'If you have followed all the above steps correctly you should see Serum Uric Acid under Name, it will be preceded by a vertical bar indicating the absence of descendants or children to this entry'),
(5188, 'If you have followed the above steps correctly the Serum Uric Acid Test should now have a + sign preceding the Name indicating the presence of successors or children'),
(5189, 'If you have lost your Smartphone those with administrator privileges can delete the keys by going to Administration > Users and checking the Clear 2FA checkbox and clicking Save'),
(5190, 'If you have NewCrop eRx module enabled then the allergies have to be entered on the NewCrop MedEntry page'),
(5191, 'If you have not already done some pre-configuration, including adding providers, do so by going to Procedures > Providers'),
(5192, 'If you have the need to order individual components of the panel you will have to create a separate Procedure Order for each individual component of the panel and store the returned result under a Discrete Result created in a fashion similar to that used earlier to create an order for Serum Uric Acid'),
(5193, 'If you hit the refresh button without setting any filters then all dated reminders for the user will appear below'),
(5194, 'If you leave it at the default of 0 then the top level entries that you make will be sorted alphabetically'),
(5195, 'If you made changes and want to re-send it, delete the original (in Communications) and try again.'),
(5196, 'If you made changes and want to re-send it, delete the original (in Communications) or wait 60 seconds, and try again.'),
(5197, 'If you need to manually enter the returned result each test (Custom Favorite Item) should have a Discrete Result as a direct descendant'),
(5198, 'If you see no entries in the Order From drop-down box it means that you have not set up a lab under Procedures > Providers'),
(5199, 'If you want to change data types, or add rows or columns'),
(5200, 'If you want to upgrade the database, then place the database zip file in the following directory'),
(5201, 'If your search was successful the search results will be displayed in the search results box below'),
(5202, 'Igbo'),
(5203, 'Ignore'),
(5204, 'III{{patient suffix}}'),
(5205, 'IIS Code'),
(5206, 'II{{patient suffix}}'),
(5207, 'Illness'),
(5208, 'IM'),
(5209, 'Image canvas'),
(5210, 'Image Results'),
(5211, 'Images'),
(5212, 'Imaging'),
(5213, 'Imaging Integration, and DICOM Diagnostic Imaging Reports - 2009'),
(5214, 'Imaging Service'),
(5215, 'Immune System'),
(5216, 'Immunization'),
(5217, 'Immunization Administered Site'),
(5218, 'Immunization Code'),
(5219, 'Immunization Completion Status'),
(5220, 'Immunization Date'),
(5221, 'Immunization Expiration Date'),
(5222, 'Immunization Information Source'),
(5223, 'Immunization Lot Number'),
(5224, 'Immunization Manufacturer'),
(5225, 'Immunization Observation Criteria'),
(5226, 'Immunization Observation Results'),
(5227, 'Immunization Ordering Provider'),
(5228, 'Immunization Refusal Reason'),
(5229, 'Immunization Registry'),
(5230, 'Immunization Registry Status'),
(5231, 'Immunization Registry Status Effective Date'),
(5232, 'Immunization Report'),
(5233, 'Immunization Service'),
(5234, 'Immunization Title'),
(5235, 'Immunization Vaccine Eligibility Results'),
(5236, 'Immunizations'),
(5237, 'Immunizations - lists immunization history and allows for adding new entries or editing existing ones'),
(5238, 'Immunize'),
(5239, 'Immunologic'),
(5240, 'Immuno{{immunologic}}'),
(5241, 'IMMUNO{{Immunology/Rheumatology}}'),
(5242, 'Imp'),
(5243, 'Imp Plan'),
(5244, 'Implants'),
(5245, 'Import'),
(5246, 'Import All'),
(5247, 'Import CCDA'),
(5248, 'Import CCR'),
(5249, 'Import certificate to the browser.'),
(5250, 'Import Configuration'),
(5251, 'Import deferred for time-to-live'),
(5252, 'Import Formularies'),
(5253, 'Import holiday events'),
(5254, 'Import Holidays'),
(5255, 'Import Patient'),
(5256, 'Import Patient Demographics'),
(5257, 'Import Patient Demographics XML'),
(5258, 'Import Pharmacies'),
(5259, 'Import Pharmacies Script'),
(5260, 'Important - the Identifying Code for Custom Favorite Group is always user defined'),
(5261, 'Important Codes'),
(5262, 'IMPORTANT: The NPI number also exists in the Address Book entry for the provider, take care to enter the correct NPI number'),
(5263, 'IMPORTANT: This upload tool is only for uploading documents on patients that are not yet entered into the system. To upload files for patients whom already have been entered into the system, please use the upload tool linked within the Patient Summary screen.'),
(5264, 'Imported Allergies'),
(5265, 'Imported from Accounting'),
(5266, 'Imported Medications'),
(5267, 'Imported Problems'),
(5268, 'Importing the entire CPT code set after you license it from the American Medical Association would get you all the relevant CPT codes in one fell swoop'),
(5269, 'Impression/Plan'),
(5270, 'Impression/Plan Builder'),
(5271, 'Improved'),
(5272, 'IMP{{impression}}'),
(5273, 'in'),
(5274, 'IN'),
(5275, 'In a likewise fashion you will create a Discrete Result for Potassium, Chloride and Carbon Dioxide'),
(5276, 'In a likewise manner create a Custom Favorite Item each for TSH (Sequence 2, Identifying Code WWT02, Standard Code 30166-3) and Vitamin D (Sequence 3, Identifying Code WWT03, Standard Code 35365-6)'),
(5277, 'In a likewise manner create a Discrete Result each for TSH (Sequence - 2, Identifying Code - WWT02R, Default Units - mU/L, Default Range - 0.4-4, leave Followup Services blank) and Vitamin D (Sequence - 3, Identifying Code - WWT03R, Default Units - ng/mL, Default Range - 0-20, leave Followup Services blank)'),
(5278, 'In addition there are 2 checkboxes'),
(5279, 'In addition to creating a Referral the system also allows you to print a blank referral form that can be manually filled to generate a Referral'),
(5280, 'In any case establishing a connection, ensuring HIPAA compliance, data security etc will require coding, the cost of which is generally borne by the lab. They however will only approve if the volume of business justifies their investment'),
(5281, 'in category'),
(5282, 'In Current Chat'),
(5283, 'in each eye'),
(5284, 'In exam room'),
(5285, 'In General'),
(5286, 'In House'),
(5287, 'In House Authorize Payments'),
(5288, 'in left eye'),
(5289, 'in nostril'),
(5290, 'In Office'),
(5291, 'In openEMR the Continuity of Care Record (CCR) reports to be generated can be limited to a specific date range by checking the Use Date Range check-box and entering the desired date range'),
(5292, 'In order to fulfill Meaningful Use requirements for Computerized Provider Order Entry (CPOE) for lab and radiology tests this module needs to be used'),
(5293, 'In order to properly store and retrieve test results and place new orders, tests/orders have to be setup in a hierarchical manner'),
(5294, 'In order to record the values of the results returned you have to create a separate Discrete Result (Tier 4) for each of the panel\'s constituents, the fruit, as direct descendants of this (General Health Panel) branch (Tier 3). Examples of the results being CBC - Hemoglobin, CBC - Hematocrit, CMP - Sodium, CMP - Potassium, TSH etc. '),
(5295, 'In order to register your device, please provide your OpenEMR login password'),
(5296, 'In order to send Continuity of Care Record (CCR) and /or Continuity of Care Document (CCD) optionally check phiMail Allow CCD Send and/or phiMail Allow CCR Send to enable the Transmit feature for these data types'),
(5297, 'In our case we will choose Local Lab that was setup previously'),
(5298, 'In our case we will leave it as Unassigned'),
(5299, 'In person payments with Stripe Verifone P400'),
(5300, 'In Portrait mode, determines the height of the envelope along the y-axis in mm'),
(5301, 'In Portrait mode, determines the width of the envelope along the x-axis in mm'),
(5302, 'in right eye'),
(5303, 'In short electronic orders can be done, it involves a significant amount of testing and customization to be certified by the lab, generally through a third party and can only happen if the lab agrees to give the green light to the project'),
(5304, 'In the \'Post Item\' section that is displayed at the top you may enter a source (e.g. check number), pay date and check amount. The reason for the source and pay date is so that you don\'t have to enter them over and over again for each claim. The amount that you enter will be decreased for each invoice that is given part of the payment, and hopefully will end at zero when you are done.'),
(5305, 'In the above example an order for a single test was created, i.e. Serum Uric Acid'),
(5306, 'In the default installation click on Add to bring up the Add/Edit Issue pop-up page'),
(5307, 'In the patient\'s words'),
(5308, 'In the second stage of Meaningful Use, the CCD, but not the CCR, was included as part of the standard for clinical document exchange'),
(5309, 'In this case the Custom Favorite Group will be called Preop Labs and the two recognized panels will be direct descendants, each in a Custom Favorite Item Tier named CBC and Renal Panel respectively'),
(5310, 'In this case you will create a Procedure Order, the fruit bearing branch called General Health Panel (Tier 3)'),
(5311, 'In total, there are seventeen sections that can be included within a Continuity of Care Record (CCR)'),
(5312, 'In Use'),
(5313, 'in-house'),
(5314, 'In-process'),
(5315, 'Inactive'),
(5316, 'inactive'),
(5317, 'Inactive - Lost to follow - up'),
(5318, 'Inactive - Moved or gone elsewhere'),
(5319, 'Inactive - Permanently inactive'),
(5320, 'Inactive - Unspecified'),
(5321, 'Inactive Days'),
(5322, 'Inactive Messages'),
(5323, 'Inbox'),
(5324, 'INCITS Code'),
(5325, 'Include all lists referenced in chosen layouts'),
(5326, 'Include all values reported for each result code'),
(5327, 'Include Checksum'),
(5328, 'Include Completed'),
(5329, 'Include Customers in checkout and receipts. See the Customers list.'),
(5330, 'Include Inactive'),
(5331, 'Include inactive'),
(5332, 'Include Inactive Providers'),
(5333, 'Include inactive providers in the fee sheet'),
(5334, 'Include inactive providers in the fee sheet.'),
(5335, 'Include inactive users'),
(5336, 'Include line item unit price amounts in checkout and receipts.'),
(5337, 'Include Uncategorized'),
(5338, 'Include Unstructured data'),
(5339, 'Include Vitals'),
(5340, 'Include vitals data?'),
(5341, 'Include your initials and details of reason for transaction.'),
(5342, 'Included Providers'),
(5343, 'including CVF{{Confrontational Visual Fields}} and Pupils'),
(5344, 'Inclusion'),
(5345, 'Income'),
(5346, 'Incoming results requiring attention:'),
(5347, 'Incomplete'),
(5348, 'Incomplete Abortion Treatment'),
(5349, 'Incontinence'),
(5350, 'Incorporate clinical lab-test results into certified EHR technology as structured data.'),
(5351, 'Incorrect confirmation PIN'),
(5352, 'Incorrect password!'),
(5353, 'Increase the limit to a larger number say 100 so that you can decide on which ones to act upon'),
(5354, 'increased:'),
(5355, 'Indemnity Insurance'),
(5356, 'Independent Clinic'),
(5357, 'Independent Laboratory'),
(5358, 'Indeterminate'),
(5359, 'Indian'),
(5360, 'Indian Health Service Free-standing Facility'),
(5361, 'Indian Health Service Provider-based Facility'),
(5362, 'Indicates abnormality'),
(5363, 'Indicates if this issue is an ophthalmic-specific medication'),
(5364, 'Indicates if this issue is currently active'),
(5365, 'Indications'),
(5366, 'Indicator for specialized usage'),
(5367, 'Indigent Patients'),
(5368, 'Indigent Patients Report'),
(5369, 'Indigents'),
(5370, 'Individual access can be tailored to fit the needs by assigning a user to one or more groups (AROs). The user will then inherit all the privileges, i.e have access to parts of the program (ACO), of each group (ARO) the user belongs to.'),
(5371, 'Individual pages can override 2nd and 3rd options by implementing a log message.'),
(5372, 'Individual tests or even individual recognized panel of tests can be grouped together as a Custom Favorite Group'),
(5373, 'Indonesian'),
(5374, 'Induced Abortion'),
(5375, 'Industry'),
(5376, 'Ineligible'),
(5377, 'Infection / Abscess'),
(5378, 'Infections'),
(5379, 'Infert Couns'),
(5380, 'Infertility'),
(5381, 'Influenza 1'),
(5382, 'Influenza 2'),
(5383, 'Influenza Immunization for Patients >= 50 Years Old'),
(5384, 'Influenza Immunization for Patients >= 50 Years Old (CQM)'),
(5385, 'Influenza Vaccine'),
(5386, 'Info'),
(5387, 'Info test 1'),
(5388, 'Info test 2'),
(5389, 'Info test 3'),
(5390, 'Info test 4'),
(5391, 'Info test 5'),
(5392, 'Info test 6'),
(5393, 'Informant'),
(5394, 'Information'),
(5395, 'Information regarding the Patient Portal is also shown in the header section'),
(5396, 'Information Source'),
(5397, 'inf{{inferior}}'),
(5398, 'inhalations'),
(5399, 'Inhale'),
(5400, 'inhilations'),
(5401, 'Initial Patient Population'),
(5402, 'Initial Treatment'),
(5403, 'Initial User'),
(5404, 'Initially Open Group'),
(5405, 'Initially Open Sections'),
(5406, 'Inj/Rehab'),
(5407, 'Injectables'),
(5408, 'Injection'),
(5409, 'Injured Body Part'),
(5410, 'Injured Out'),
(5411, 'Injury'),
(5412, 'Injury Log'),
(5413, 'Injury Mechanism'),
(5414, 'Injury Overview Report'),
(5415, 'Injury Surveillance'),
(5416, 'Injury Type'),
(5417, 'Injury/illness-related'),
(5418, 'Inline'),
(5419, 'Inpatient Hospital'),
(5420, 'Inpatient Psychiatric Facility'),
(5421, 'Input does not begin with a MSH segment'),
(5422, 'Input Fields'),
(5423, 'INR'),
(5424, 'Ins 1'),
(5425, 'Ins 2 or Ins 3'),
(5426, 'Ins Address'),
(5427, 'Ins adjust'),
(5428, 'Ins bundling'),
(5429, 'Ins Code'),
(5430, 'Ins Group'),
(5431, 'Ins Name'),
(5432, 'Ins overpaid'),
(5433, 'Ins Policy'),
(5434, 'Ins refund'),
(5435, 'Ins Summary'),
(5436, 'Ins/fin issue'),
(5437, 'Ins1'),
(5438, 'Ins2'),
(5439, 'Ins3'),
(5440, 'Insert'),
(5441, 'Insert failed: '),
(5442, 'Insert in Form'),
(5443, 'Insert normals'),
(5444, 'Insert normals - 100/100'),
(5445, 'Insert normals - 11/11'),
(5446, 'Insert old events into tables'),
(5447, 'Insert special field'),
(5448, 'Insert the key into the USB port'),
(5449, 'Insert U2F Key'),
(5450, 'Insert your key into a USB port and click the Authenticate button below.'),
(5451, 'Inserted'),
(5452, 'Insomnia'),
(5453, 'Inspect the log'),
(5454, 'Inspection'),
(5455, 'Instability / subluxation'),
(5456, 'INSTALL'),
(5457, 'Install'),
(5458, 'Install ACL'),
(5459, 'Install Code Set'),
(5460, 'install DB'),
(5461, 'Install it by going to Administration > Other > External Data Loads > ICD10 > Staged Releases and click Install'),
(5462, 'Install Layout Service Codes'),
(5463, 'Install RxCUI monthly via Native Load or enable in Lists!'),
(5464, 'Install SQL'),
(5465, 'Install the EMR Direct trust anchor certificate'),
(5466, 'Installation Details'),
(5467, 'Installations processing a large number of Direct messages may want a shorter interval'),
(5468, 'Installed Release'),
(5469, 'Installing codes in openEMR'),
(5470, 'Instructed'),
(5471, 'Instruction'),
(5472, 'Instructions'),
(5473, 'Instructions:'),
(5474, 'Insufficient inventory for product'),
(5475, 'Insufficient inventory for product ID'),
(5476, 'Insulin Dependent Diabetes'),
(5477, 'Insurance'),
(5478, 'insurance'),
(5479, 'Insurance Address'),
(5480, 'Insurance Adj'),
(5481, 'Insurance Adjustment'),
(5482, 'Insurance Balance'),
(5483, 'Insurance Balance Due'),
(5484, 'Insurance Comp'),
(5485, 'Insurance Companies'),
(5486, 'Insurance Company'),
(5487, 'Insurance Company Search/Add'),
(5488, 'Insurance Credit'),
(5489, 'Insurance Data'),
(5490, 'Insurance ID'),
(5491, 'Insurance Information'),
(5492, 'Insurance information on file'),
(5493, 'Insurance Name'),
(5494, 'Insurance Numbers'),
(5495, 'Insurance Payment'),
(5496, 'Insurance payment'),
(5497, 'Insurance Payments'),
(5498, 'Insurance Provider'),
(5499, 'Insurance Search/Select/Add'),
(5500, 'Insurance Types'),
(5501, 'Insurances'),
(5502, 'Insured'),
(5503, 'Intake Conclusion'),
(5504, 'Intake Date'),
(5505, 'Integers1-100'),
(5506, 'Integrating lab results into a patient\'s chart in openEMR can be done manually i.e. both ordering tests and uploading the received results or electronically'),
(5507, 'Intellectual Decline'),
(5508, 'Inter-pupillary distance'),
(5509, 'Interact with created transactions'),
(5510, 'Interlingua'),
(5511, 'Interlingue'),
(5512, 'Intermediate Care Facility/Mentally Retarded'),
(5513, 'Intermittent Esotropia'),
(5514, 'Intermittent Exotropia'),
(5515, 'intermittent hyperphoria'),
(5516, 'Intermittent hypotropia'),
(5517, 'Internal Allergies'),
(5518, 'Internal error - no pages were selected!'),
(5519, 'Internal error - patient ID was not provided!'),
(5520, 'Internal error accessing uploaded file!'),
(5521, 'Internal error in tableNameFromLayout'),
(5522, 'Internal error!'),
(5523, 'Internal error, no drug ID specified!'),
(5524, 'Internal error: Cannot find MSH-10'),
(5525, 'Internal error: claim '),
(5526, 'Internal error: encounter \''),
(5527, 'Internal error: pid or encounter is missing.'),
(5528, 'Internal error: the referenced encounter no longer exists.'),
(5529, 'Internal error: we do not seem to be in an encounter!'),
(5530, 'Internal Identifier (pid)'),
(5531, 'Internal Medications'),
(5532, 'Internal Problems'),
(5533, 'Internal Referrals'),
(5534, 'Internal Time Collected'),
(5535, 'International Duty'),
(5536, 'Internet Explorer browser version 6 to Internet Explorer browser version 11 does not support FIDO U2F API'),
(5537, 'Interpreter'),
(5538, 'Interpreter needed?'),
(5539, 'Interstitial Lung Disease'),
(5540, 'Interval'),
(5541, 'Interval (minutes)'),
(5542, 'Interval between message checks (set to zero for manual checks only)'),
(5543, 'Intervention'),
(5544, 'Intervention Provided'),
(5545, 'Intolerance'),
(5546, 'Intradermal'),
(5547, 'Intramuscular'),
(5548, 'intramuscularly'),
(5549, 'Intraocular Pressures'),
(5550, 'Intraocular Pressures (mmHg) by Date'),
(5551, 'intravenously'),
(5552, 'Introduction'),
(5553, 'Inuktitut'),
(5554, 'Inupiaq'),
(5555, 'Invalid character in'),
(5556, 'Invalid Content'),
(5557, 'Invalid Credit Card Number'),
(5558, 'Invalid Credit Card Values: Please correct'),
(5559, 'Invalid Current Credentials Error.'),
(5560, 'Invalid Date format or value! Type date as YYYY-MM-DD or use the calendar.'),
(5561, 'Invalid date range'),
(5562, 'Invalid encapsulated data encoding type'),
(5563, 'Invalid File'),
(5564, 'Invalid file type.'),
(5565, 'Invalid layout ID'),
(5566, 'Invalid length for'),
(5567, 'Invalid non-numeric character in'),
(5568, 'Invalid or missing payer in source for code '),
(5569, 'Invalid password'),
(5570, 'Invalid recipient address. Please try again.'),
(5571, 'Invalid Request'),
(5572, 'Invalid Request Parameters'),
(5573, 'Invalid Service Codes'),
(5574, 'Invalid source designation \"'),
(5575, 'Invalid Total!'),
(5576, 'Invalid username or password'),
(5577, 'InvAmt'),
(5578, 'Inventory'),
(5579, 'Inventory Activity'),
(5580, 'Inventory Administration'),
(5581, 'Inventory and sell both drugs and non-drug products'),
(5582, 'Inventory and sell drugs only'),
(5583, 'Inventory is not available for this order.'),
(5584, 'Inventory List'),
(5585, 'Inventory Management'),
(5586, 'Inventory Transactions'),
(5587, 'Invoice'),
(5588, 'invoice'),
(5589, 'Invoice Actions'),
(5590, 'Invoice Adjustment'),
(5591, 'Invoice and Line Levels'),
(5592, 'Invoice Balance'),
(5593, 'Invoice Balance cannot be posted. No Encounter is created.'),
(5594, 'Invoice Date'),
(5595, 'Invoice Details'),
(5596, 'Invoice has no date!'),
(5597, 'Invoice Level Only'),
(5598, 'Invoice Number'),
(5599, 'Invoice Reference Number'),
(5600, 'Invoice reference number pool, if used'),
(5601, 'Invoice Reference Number Pools'),
(5602, 'Invoice Refno Pool'),
(5603, 'Invoice Search'),
(5604, 'Invoice:'),
(5605, 'IOP Chart'),
(5606, 'IOP Dilated{{Dilated Intraocular Pressure}}'),
(5607, 'IOP Graph'),
(5608, 'ios'),
(5609, 'iPad Pro 10.5 inches'),
(5610, 'iPad Pro 12.5 inches'),
(5611, 'iPad/iPad Mini, XGA'),
(5612, 'iPhone 6/7/8 Plus'),
(5613, 'iPhone X/XS'),
(5614, 'iPhone XR/XS Max'),
(5615, 'IPPF'),
(5616, 'IPPF Abortion'),
(5617, 'IPPF Contraception'),
(5618, 'IPPF SRH Data for'),
(5619, 'IPPF statistical reports.'),
(5620, 'IPPF Statistics Report'),
(5621, 'IPPF Statistics Reporting'),
(5622, 'IPPF Stats'),
(5623, 'IPV 1'),
(5624, 'IPV 2'),
(5625, 'IPV 3'),
(5626, 'IPV 4'),
(5627, 'Iris'),
(5628, 'Irish'),
(5629, 'Irregular Heart Beat'),
(5630, 'Irritability'),
(5631, 'Irritation'),
(5632, 'is a different language version of the following database'),
(5633, 'is a different version of the following database'),
(5634, 'is a more recent version of the following database'),
(5635, 'Is a record of all financial transactions between the patient and the practice'),
(5636, 'is a required field.'),
(5637, 'is a root node and can not be deleted.'),
(5638, 'is an extension of the following database'),
(5639, 'Is Authorizing Signature'),
(5640, 'Is Confidential'),
(5641, 'Is Enabled'),
(5642, 'Is it ok to map these CVX codes to already existent immunizations?'),
(5643, 'is misplaced or unknown'),
(5644, 'is not a number'),
(5645, 'is not a valid email address'),
(5646, 'Is not selected'),
(5647, 'is not valid'),
(5648, 'is not valid (decimal fractions are OK).'),
(5649, 'Is PHP using Safe Mode?'),
(5650, 'Is Required. Contact Provider.'),
(5651, 'Is Required. Please Add in Contacts.'),
(5652, 'Is selected'),
(5653, 'Is text from form layouts to be translated?'),
(5654, 'Is text from lists to be translated?'),
(5655, 'Is The File Encrypted?'),
(5656, 'Is this a Clinical Term code type?'),
(5657, 'Is this a diagnosis type?'),
(5658, 'Is this a Medical Problem code type?'),
(5659, 'Is this a Medication type?'),
(5660, 'Is this a procedure/service type?'),
(5661, 'Is this active?'),
(5662, 'Is this code type active?'),
(5663, 'Is this code type used in claims?'),
(5664, 'Is this Okay?'),
(5665, 'Is this really OK?'),
(5666, 'Is this type hidden in the fee sheet?'),
(5667, 'Is this using external sql tables? If it is, then choose the format.'),
(5668, 'is too long'),
(5669, 'ISO 639-2 Code'),
(5670, 'Issue'),
(5671, 'issue'),
(5672, 'Issue Date'),
(5673, 'Issue ID'),
(5674, 'Issue Subtypes'),
(5675, 'Issue Title'),
(5676, 'Issue Type'),
(5677, 'Issue Types'),
(5678, 'Issues'),
(5679, 'Issues (Injuries/Medical/Allergy)'),
(5680, 'Issues (Injuries/Medical/Allergy):'),
(5681, 'Issues - summarizes the patient\'s medical problems, allergies, medications, surgeries and dental issues'),
(5682, 'Issues and Encounters'),
(5683, 'Issues and Encounters for'),
(5684, 'Issues and Immunizations wiki page'),
(5685, 'Issues can also be linked to zero or more encounters'),
(5686, 'Issues Help'),
(5687, 'Issues List'),
(5688, 'Issues not authorized'),
(5689, 'Issues Section'),
(5690, 'Issuing Agency'),
(5691, 'It allows the browser to communicate directly to the USB device avoiding the need for the user to do anything more than insert the device into an USB port and tap it to activate it'),
(5692, 'It also lets you create new groups (AROs) as well as remove existing ones.'),
(5693, 'It can also just receive results electronically'),
(5694, 'It can be either linked to a patient or just be a message addressed to another user(s)'),
(5695, 'It combines what the user knows i.e. user password with what the user has i.e. a device that is unique or a mechanism to generate/receive a unique code to be used at each login'),
(5696, 'It consists of three sections '),
(5697, 'It consists of two parts - defining a Provider and configuring the Orders and Results'),
(5698, 'It consists of two parts - the Receiving application and Receiving facility'),
(5699, 'It consists of two parts - the Sending application and Sending facility'),
(5700, 'It contains a left and right section'),
(5701, 'It contains a QR code that needs to be captured by the authenticator app'),
(5702, 'It contains structured data that is included in the Continuity of Care Record (CCR) set to the the Clinical Document Architecture standard'),
(5703, 'It does not refer to the actual referral that has been created'),
(5704, 'It does so by using an algorithm to combine the current UNIX time with the secret key to generate an ever changing unique key'),
(5705, 'It has four tabs'),
(5706, 'It has three tiers '),
(5707, 'It is a commercial messaging module available to openEMR practices utilizing version 5.0.1 and higher'),
(5708, 'It is a field in the HL7 Message header known as Processing ID'),
(5709, 'It is a part of the medical record'),
(5710, 'It is also a subscription based service'),
(5711, 'It is also necessary to list an ICD10 code in order for the problem to be listed in Continuity of Care Report (CCR) and Continuity of Care Document (CCD)'),
(5712, 'It is divided into two sections'),
(5713, 'It is essential that you read through the first four sections to understand the underlying principles'),
(5714, 'It is far easier and intuitive to make major changes and reorganize the data on the spreadsheet before you start entering the data in openEMR'),
(5715, 'It is important to realize that this manages the MFA for the logged in user'),
(5716, 'It is important to understand the function of these two icons as all subsequent steps needed to properly set up the hierarchy will depend on the correct use of these two icons'),
(5717, 'It is intended to include only the information that is critical to effectively continue care'),
(5718, 'It is issued to health care providers in the United States by the Centers for Medicare and Medicaid Services (CMS)'),
(5719, 'It is not necessary for local lab, instead you can use any arbitrary unique number'),
(5720, 'It is not necessary to fill default Diagnosis Codes as ICD10 codes can be entered at the time of the actual ordering of the test'),
(5721, 'It is not submitted with the claim'),
(5722, 'It is not uncommon to order several blood tests together, grouping them as a panel of tests facilitates this process'),
(5723, 'It is prudent to follow up with provider if not contacted.'),
(5724, 'It is the basic paper claim form prescribed by many payers for claims submitted by individual doctors & practices, nurses, and professionals, including therapists, chiropractors, and out-patient clinics, and in some cases, for ambulance services'),
(5725, 'It is used to link problems with encounters and is also used to see which encounters are associated to a particular issue'),
(5726, 'It is useful to practice on a trial site to become familiar with the process before doing so on the production openEMR application'),
(5727, 'It lets you search by ICD 9 and ICD 10 diagnostic codes and CPT4 and HCPCS service/procedure codes'),
(5728, 'It lets you send messages and dated reminders to staff members, add patient to the recall list and send SMS text messages to patients'),
(5729, 'It serves as a necessary bridge to a different environment, often with new clinicians who know nothing about the patient, enabling next provider to easily'),
(5730, 'It should be UTF-8 encoded with comma separated values.'),
(5731, 'It therefore stands to reason that you cannot create a Counter-Referral by itself'),
(5732, 'It uses an open standard and therefore available from various manufactures'),
(5733, 'It uses the HMAC-SHA256 hash function to generate a unique private key for the account'),
(5734, 'It uses this private key to sign the challenge and sends the response back to the application'),
(5735, 'It will be displayed in the visit summary'),
(5736, 'It will bring up the Enter Details pop-up form'),
(5737, 'It will bring up the Multi patient finder  popup'),
(5738, 'It will display the justify display pop-up. It has a search box that wil let you search for a ICD code.  It will also display the 10 most commonly used ICD codes. You can select any or all codes by checking the J (justify) checkbox and pressing update'),
(5739, 'It will have a value of 2 in the Tier column indicating it is a successor or child on the first line above having a Tier value of 1 which in this case is Serum Chemistry'),
(5740, 'It will have two sections - the Issues Section and the Encounters Section'),
(5741, 'It will help later in troubleshooting problems that may arise with your configuration of the Procedure Orders module'),
(5742, 'It will open the Create New Message section'),
(5743, 'It will take you to the MedEx sign-up page'),
(5744, 'It will then appear in the Allergies widget on the Patient Dashboard as well as under allergies in the Issues page'),
(5745, 'It will then appear in the Medications widget on the Patient Dashboard as well as under Medications in the Issues page'),
(5746, 'Italian'),
(5747, 'Item'),
(5748, 'item'),
(5749, 'Item added'),
(5750, 'Item Adjustment'),
(5751, 'Item deleted'),
(5752, 'Item Details'),
(5753, 'items'),
(5754, 'Items load failed'),
(5755, 'IU/L'),
(5756, 'IUD'),
(5757, 'IV'),
(5758, 'IVE Client List'),
(5759, 'IV{{patient suffix}}'),
(5760, 'Jaeger'),
(5761, 'Jaeger{{Near Acuity Type Jaeger}}'),
(5762, 'Jan'),
(5763, 'January'),
(5764, 'Japanese'),
(5765, 'Jaundice'),
(5766, 'Javanese'),
(5767, 'Job Description'),
(5768, 'Job ID'),
(5769, 'Joint dislocations'),
(5770, 'Joint Pain'),
(5771, 'Joint sprains'),
(5772, 'Jr'),
(5773, 'Jr.'),
(5774, 'JSON Web Key Set'),
(5775, 'JSON Web Key Set (Note a hosted web URI is preferred and this feature may be removed in future SMART versions)'),
(5776, 'JSON Web Key Set URI'),
(5777, 'Jul'),
(5778, 'July'),
(5779, 'Jump to Next Row'),
(5780, 'Jun'),
(5781, 'June'),
(5782, 'Just below the check information is a blue area where you put in your search parameters.  You can search by patient name, chart number, encounter number or date of service, or any combination of these.  You may also select whether you want to see all invoices, open invoices, or only invoices that are due (by the patient).  Click the Search button to perform the search.'),
(5783, 'Just Mine'),
(5784, 'Justification Entries'),
(5785, 'Justify'),
(5786, 'Justify Dx'),
(5787, 'Justify each CPT code with one or more justifications using the dropdown box. These will reflect the diagnosis codes that was previously selected in \'Select Codes\''),
(5788, 'Justify/Save'),
(5789, 'JWT not found in system'),
(5790, 'J{{Justify Header}}'),
(5791, 'k, here\'s the rest '),
(5792, 'K1{{Keratometry 1}}'),
(5793, 'K2{{Keratometry 2}}'),
(5794, 'Kalaallisut, Greenlandic'),
(5795, 'Kannada'),
(5796, 'Kanuri'),
(5797, 'Kashmiri'),
(5798, 'Kazakh'),
(5799, 'key'),
(5800, 'Key'),
(5801, 'Key access failed with error'),
(5802, 'Key for multiple database credentials encryption'),
(5803, 'Key Name'),
(5804, 'Keywords'),
(5805, 'kg'),
(5806, 'kg/m^2'),
(5807, 'Khmer'),
(5808, 'Kidney Cancer'),
(5809, 'Kidney Failure'),
(5810, 'Kidney Infections'),
(5811, 'Kidney Stones'),
(5812, 'Kidney Transplant'),
(5813, 'Kikuyu, Gikuyu'),
(5814, 'Kindle Fire HDX, Laptop MDPI, WXGA'),
(5815, 'Kinyarwanda'),
(5816, 'Kiosk'),
(5817, 'Kirundi'),
(5818, 'Knee'),
(5819, 'Knee Problems'),
(5820, 'Knee Replacement'),
(5821, 'Komi'),
(5822, 'Kongo'),
(5823, 'Korean'),
(5824, 'Kurdish'),
(5825, 'Kwanyama, Kuanyama'),
(5826, 'Kyrgyz'),
(5827, 'l/min'),
(5828, 'Lab'),
(5829, 'Lab Configuration'),
(5830, 'Lab Documents'),
(5831, 'Lab Exchange Site Address'),
(5832, 'Lab Exchange Site ID'),
(5833, 'Lab Exchange Token ID'),
(5834, 'Lab Order'),
(5835, 'Lab overview'),
(5836, 'Lab Overview'),
(5837, 'Lab Query Status'),
(5838, 'Lab Reference ID'),
(5839, 'Lab Report'),
(5840, 'Lab Result'),
(5841, 'Lab Results'),
(5842, 'Lab Results (write,addonly optional)'),
(5843, 'Lab Results Category Name'),
(5844, 'Lab Results Report'),
(5845, 'Lab Service'),
(5846, 'Lab Test Results'),
(5847, 'Lab/File'),
(5848, 'Label'),
(5849, 'Label cannot be blank'),
(5850, 'Label Cols'),
(5851, 'Label for this type'),
(5852, 'Label printed by'),
(5853, 'LabelCols must be a number between 1 and 999'),
(5854, 'Labels'),
(5855, 'Labels can be printed either for one patient or for all the selected patients'),
(5856, 'Laboratory Information'),
(5857, 'Laboratory Test'),
(5858, 'Labs'),
(5859, 'Laceration / skin condition'),
(5860, 'Laceration/abrasion'),
(5861, 'LAC{{left anterior chamber}}'),
(5862, 'LADate'),
(5863, 'LAD{{left adnexa}}'),
(5864, 'Laminas Module'),
(5865, 'Landscape'),
(5866, 'Language'),
(5867, 'Language Code'),
(5868, 'Language definition added'),
(5869, 'Language Interface Tool'),
(5870, 'Language Interface Tool (language)'),
(5871, 'Language List (write,addonly optional)'),
(5872, 'Language List (write,addonly optional) (language)'),
(5873, 'Language Name'),
(5874, 'Language:'),
(5875, 'Lao'),
(5876, 'Laotian'),
(5877, 'Laptop HiDPI, WXGA+'),
(5878, 'Laser Interferometry'),
(5879, 'Laser Interferometry Acuity'),
(5880, 'Last'),
(5881, 'Last Action'),
(5882, 'Last Activity Date'),
(5883, 'Last Appendectomy'),
(5884, 'Last Bill Date'),
(5885, 'Last Bill Date:'),
(5886, 'Last Breast Exam'),
(5887, 'Last Calendar Year'),
(5888, 'Last Cataract Surgery'),
(5889, 'Last Cholecystestomy'),
(5890, 'last date of this event'),
(5891, 'Last Encounter'),
(5892, 'Last Gyn. Exam'),
(5893, 'Last Heart Surgery'),
(5894, 'Last Hernia Repair'),
(5895, 'Last Hip Replacement'),
(5896, 'Last Hysterectomy'),
(5897, 'Last Knee Replacement'),
(5898, 'Last Level Billed'),
(5899, 'Last Mammogram'),
(5900, 'Last Menstrual Period'),
(5901, 'Last Modified'),
(5902, 'Last Month'),
(5903, 'Last Name'),
(5904, 'Last name'),
(5905, 'Last Name Missing'),
(5906, 'Last name, First name'),
(5907, 'Last name, first name'),
(5908, 'Last name, first name (title)'),
(5909, 'Last name, first name (title: comments)'),
(5910, 'Last Name:'),
(5911, 'Last Physical Exam'),
(5912, 'Last Prostate Exam'),
(5913, 'Last Rectal Exam'),
(5914, 'Last Reviewed'),
(5915, 'Last Run Started At'),
(5916, 'Last Saved'),
(5917, 'Last Sigmoid/Colonoscopy'),
(5918, 'Last Stmt'),
(5919, 'Last Tonsillectomy'),
(5920, 'Last Tx Date'),
(5921, 'Last update'),
(5922, 'Last Update'),
(5923, 'Last update by'),
(5924, 'Last Verified On'),
(5925, 'Last Visit'),
(5926, 'Last X-ray'),
(5927, 'Lastly is the view to show templates assigned to patients.'),
(5928, 'Last{{Name}}'),
(5929, 'Late Recurrence (2-12 Mo)'),
(5930, 'Lateral Malleolus'),
(5931, 'Lateral malleolus:'),
(5932, 'Laterality'),
(5933, 'Laterality of this procedure, if applicable'),
(5934, 'laterally displaced PMI:'),
(5935, 'Latest Health Alerts'),
(5936, 'Latest Medical Records'),
(5937, 'Latest Results Only'),
(5938, 'Latest Visit or Consultation'),
(5939, 'Latin'),
(5940, 'Latvian'),
(5941, 'lat{{lateral}}'),
(5942, 'Launch'),
(5943, 'Launch URI'),
(5944, 'Law Firm'),
(5945, 'Lawyer'),
(5946, 'Layout'),
(5947, 'Layout (need to logout/login after change this setting)'),
(5948, 'Layout Based'),
(5949, 'Layout Columns'),
(5950, 'Layout Editor'),
(5951, 'Layout groups'),
(5952, 'Layout ID'),
(5953, 'Layout ID is required'),
(5954, 'Layout Properties'),
(5955, 'Layout Style'),
(5956, 'Layout-Based Transaction Forms'),
(5957, 'Layout-Based Visit Forms'),
(5958, 'Layouts'),
(5959, 'lb'),
(5960, 'LBF Encounter Form Preview'),
(5961, 'LBF_Validations'),
(5962, 'lbs'),
(5963, 'LB{{left brow}}'),
(5964, 'LCMT{{left Central Macular Thickness}}'),
(5965, 'LCUP{{left cup}}'),
(5966, 'LC{{left conjunctiva}}'),
(5967, 'LDAP - Distinguished Name of User'),
(5968, 'LDAP - Login Exclusions'),
(5969, 'LDAP - Server Name or URI'),
(5970, 'LDL'),
(5971, 'LD{{left disc}}'),
(5972, 'leave blank if still active'),
(5973, 'Leave Blank To Keep Original Filename'),
(5974, 'Leave blank to keep password unchanged.'),
(5975, 'Leave Coding Blank'),
(5976, 'Leave coding blank as currently you can only enter ICD10 codes'),
(5977, 'Leave Destination blank'),
(5978, 'Leave it blank if the problem is still active'),
(5979, 'Leave Message With'),
(5980, 'Leave the Followup Services blank and click Save'),
(5981, 'Leave The Form'),
(5982, 'Leaving the pass phrase blank will not encrypt the document'),
(5983, 'Ledger'),
(5984, 'Ledger - Summarizes and tabulates all the charges, payments, adjustments and balances for all encounters pertaining to the patient'),
(5985, 'Left'),
(5986, 'Left Arm'),
(5987, 'Left Deltoid'),
(5988, 'Left Ear'),
(5989, 'left ear'),
(5990, 'Left Gluteus Medius'),
(5991, 'Left Lens'),
(5992, 'Left Lower Forearm'),
(5993, 'Left Margin (mm)'),
(5994, 'Left Thigh'),
(5995, 'Left Vastus Lateralis'),
(5996, 'Left w/o visit'),
(5997, 'Left-Form Layout'),
(5998, 'Left:'),
(5999, 'Left: '),
(6000, 'Leg Pain/Cramping'),
(6001, 'Legal'),
(6002, 'Legal Authenticator'),
(6003, 'Legal Paper Size'),
(6004, 'Legend:'),
(6005, 'Length'),
(6006, 'Length of modifier, 0 if none'),
(6007, 'Lens'),
(6008, 'Lens Material'),
(6009, 'Lens Material Options'),
(6010, 'Lens Thickness'),
(6011, 'Lens Treatments'),
(6012, 'Less Than'),
(6013, 'Less Than or Equal To'),
(6014, 'Less-private information (write,addonly optional)'),
(6015, 'Less-private information (write,addonly optional) (relaxed)'),
(6016, 'Lets you delete a line or row. Hit \'Refresh\' and the line will have a strikethrough across it'),
(6017, 'Lets you filter the results as per the chosen criteria'),
(6018, 'Lets you send messages to staff members about patient related matters'),
(6019, 'Letter'),
(6020, 'Letter Generator'),
(6021, 'Letter Paper Size'),
(6022, 'Letterhead that doctor signs'),
(6023, 'Letterhead that patient signs'),
(6024, 'Lev Fn{{levator function}}'),
(6025, 'Levator Function'),
(6026, 'Level of urgency'),
(6027, 'LF{{levator function}}'),
(6028, 'LH{{left hertel measurement}}'),
(6029, 'Liability'),
(6030, 'Liability Medical'),
(6031, 'Library'),
(6032, 'License/ID'),
(6033, 'Licensed Prescriber'),
(6034, 'Licensed Prescriber First Name'),
(6035, 'Licensed Prescriber Last Name'),
(6036, 'Licensed Prescriber NPI'),
(6037, 'Licensed Prescriber Title (Prefix)'),
(6038, 'LicensedPrescriber Last name'),
(6039, 'LicensedPrescriber NPI'),
(6040, 'LicensedPrescriber UPIN'),
(6041, 'Life partner'),
(6042, 'Life threatening severity'),
(6043, 'Lifestyle'),
(6044, 'Lifestyle - lists the patient\'s use of Tobacco, Coffee, Alcohol, Recreational Drugs etc'),
(6045, 'Lifestyle status'),
(6046, 'Ligament tear or sprain'),
(6047, 'Light tobacco smoker'),
(6048, 'Likewise Laterality is not relevant in this context and can be left Unassigned'),
(6049, 'Limburgish, Limburgan, Limburger'),
(6050, 'Limit Of Events'),
(6051, 'Limit service provider selection according to the facility of the logged-in user.'),
(6052, 'Limited Exam'),
(6053, 'Limited HPI'),
(6054, 'Limits'),
(6055, 'Line'),
(6056, 'Line Items Only'),
(6057, 'Lingala'),
(6058, 'Link'),
(6059, 'Link To Patient'),
(6060, 'Link to Referential CDS'),
(6061, 'Link/Add Issues (Injuries/Medical/Allergy) to Current Visit'),
(6062, 'Linked'),
(6063, 'Linked document'),
(6064, 'Linked procedure order'),
(6065, 'linked to document'),
(6066, 'linked to procedure order'),
(6067, 'List'),
(6068, 'List box'),
(6069, 'list box'),
(6070, 'list box w/ add'),
(6071, 'List box w/add'),
(6072, 'List box w/comment'),
(6073, 'List box w/search'),
(6074, 'List Editor'),
(6075, 'List encounters'),
(6076, 'List Forms'),
(6077, 'List groups'),
(6078, 'List Insurance Companies'),
(6079, 'List item ID'),
(6080, 'List items can not start with a number.'),
(6081, 'List items contains illegal character(s).'),
(6082, 'List layout items'),
(6083, 'List lists'),
(6084, 'List modifiers, up to 4 can be listed, each separated by a space or a colon'),
(6085, 'List Name'),
(6086, 'List names cannot start with numbers.'),
(6087, 'List of '),
(6088, 'List of health care practitioners'),
(6089, 'List of previous refractions'),
(6090, 'List of previously dispensed Spectacle and Contact Lens Rxs'),
(6091, 'List Prescriptions'),
(6092, 'List used by above Country Data Type option.'),
(6093, 'List used by above State Data Type option.'),
(6094, 'Listening port of the RFC 5425 TLS syslog server.'),
(6095, 'Listing an ICD10 code will let you search for educational material for that particular code '),
(6096, 'Lists'),
(6097, 'Lists (lists)'),
(6098, 'Lithuanian'),
(6099, 'Living Will'),
(6100, 'LI{{Laser Interferometry Acuity}}'),
(6101, 'LI{{Laser Interferometry}}'),
(6102, 'LI{{left iris}}'),
(6103, 'LK{{left cornea}}'),
(6104, 'LLL:'),
(6105, 'LLL{{left lower eyelid}}'),
(6106, 'LL{{left iris}}'),
(6107, 'LL{{left lens}}'),
(6108, 'LMAC{{left macula}}'),
(6109, 'LMC{{left medial chathus}}'),
(6110, 'LMP'),
(6111, 'Load Compendium'),
(6112, 'Load Definitions'),
(6113, 'Load from CSV'),
(6114, 'Load Lab Compendium'),
(6115, 'Load Lab Configuration'),
(6116, 'Load OE Question Options'),
(6117, 'Load Order Definitions'),
(6118, 'Load Order Entry Questions'),
(6119, 'LOAD SUCCESSFUL. Codes inserted'),
(6120, 'Loading'),
(6121, 'LOADING'),
(6122, 'Loading data'),
(6123, 'Loading more results'),
(6124, 'Loading prior image'),
(6125, 'Loading the files into the database. This will take some time...'),
(6126, 'Loading... Please wait'),
(6127, 'LOBI Insurers Report'),
(6128, 'LOC'),
(6129, 'Local'),
(6130, 'Local Content'),
(6131, 'Local Filesystem'),
(6132, 'Local Filesystem will store the order as a HL7v2.3 message in a predefined location in the local server hosting openEMR'),
(6133, 'Locale'),
(6134, 'Locality'),
(6135, 'Location'),
(6136, 'location of the openemr machine and may contain sensitive data, so it is recommended to manually delete the files after its use'),
(6137, 'Location of this lot'),
(6138, 'Location unspecified'),
(6139, 'Location where Hylafax stores faxes.'),
(6140, 'Location where scans are stored.'),
(6141, 'Location:'),
(6142, 'Lock'),
(6143, 'Lock an e-signed form individually'),
(6144, 'Lock e-signed encounters and their forms'),
(6145, 'Lock?'),
(6146, 'Locked'),
(6147, 'Locked Payment Pending'),
(6148, 'Log all NewCrop eRx Requests and / or Responses.'),
(6149, 'Log entire document'),
(6150, 'Log In'),
(6151, 'Log in'),
(6152, 'Log In Name is unavailable. Try again!'),
(6153, 'Log is cleared. Please close window.'),
(6154, 'Log Out'),
(6155, 'Log Types'),
(6156, 'Log was already empty. Please close window.'),
(6157, 'Logged in'),
(6158, 'Logged in as'),
(6159, 'Logged in as: '),
(6160, 'Logged in User if provider, otherwise Current Provider'),
(6161, 'Logged out.'),
(6162, 'Logging'),
(6163, 'Login'),
(6164, 'login'),
(6165, 'Login - details are only required if you are connecting to a facility using the SFTP protocol '),
(6166, 'Login Into Facility'),
(6167, 'Login name of WordPress user for portal access'),
(6168, 'Login Page Layout'),
(6169, 'Login Page Tagline'),
(6170, 'Login to remote host'),
(6171, 'Login to this remote host failed'),
(6172, 'Login Trusted Email'),
(6173, 'Login User Name'),
(6174, 'Login with your user id and password and it will automatically authenticate you'),
(6175, 'Logout'),
(6176, 'logout'),
(6177, 'Logs'),
(6178, 'Logs Viewer'),
(6179, 'LOINC'),
(6180, 'LOINC Code'),
(6181, 'LOINC, rhymes with oink, is a database and universal standard for identifying medical laboratory observations'),
(6182, 'Look back one drawing'),
(6183, 'Look Up'),
(6184, 'Lot'),
(6185, 'Lot ID missing!'),
(6186, 'Lot Number'),
(6187, 'Lots'),
(6188, 'Low'),
(6189, 'Low Priority'),
(6190, 'Lower leg'),
(6191, 'Lower Lids'),
(6192, 'Lowest Priority'),
(6193, 'Low{{Priority}}'),
(6194, 'LP{{left peripheral retina}}'),
(6195, 'LT{{lens thickness}}'),
(6196, 'Luba-Katanga'),
(6197, 'Luhn'),
(6198, 'LUL{{left upper eyelid}}'),
(6199, 'Lumbar spine'),
(6200, 'LUNCH'),
(6201, 'Lunch'),
(6202, 'Lung Cancer'),
(6203, 'Lung Cancer Surgery'),
(6204, 'LUNGS:'),
(6205, 'Lungs:'),
(6206, 'Lupus'),
(6207, 'Luxembourgish, Letzeburgesch'),
(6208, 'LVIT{{left vitreous}}'),
(6209, 'LV{{left vessels}}'),
(6210, 'L{{left side}}'),
(6211, 'L{{left}}'),
(6212, 'M'),
(6213, 'MA Category'),
(6214, 'MA Client Accepting Abortion'),
(6215, 'MA statistical reports.'),
(6216, 'MA Statistics Reporting'),
(6217, 'MA Stats'),
(6218, 'Macedonian'),
(6219, 'Macula'),
(6220, 'Mail'),
(6221, 'Mail Order'),
(6222, 'Mail Sent'),
(6223, 'Mailing Address'),
(6224, 'Main'),
(6225, 'Main Address'),
(6226, 'Main and API'),
(6227, 'Main Counselors'),
(6228, 'Main Log'),
(6229, 'Main Menu Role'),
(6230, 'Main Provider'),
(6231, 'Main Top Pane Screen'),
(6232, 'Main Top Pane Screen(Or Default First Tab)'),
(6233, 'Mainly Authorize.Net uses two keys'),
(6234, 'Maintain active medication allergy list.'),
(6235, 'Maintain active medication list.'),
(6236, 'Maintain an up-to-date problem list of current and active diagnoses.'),
(6237, 'Make modifications to current categories.'),
(6238, 'Make new appointment for'),
(6239, 'Make Payment'),
(6240, 'Make subsequent fields in the same row, Label = 0 Data = 0 and ensure enough columns are available from previous items to allow space for this new item. Otherwise result could be unpredictable'),
(6241, 'Make sure \"'),
(6242, 'Making batch text files for uploading to Clearing House and will mark as billed'),
(6243, 'Malagasy'),
(6244, 'Malaise:'),
(6245, 'Malay'),
(6246, 'Malayalam'),
(6247, 'Male'),
(6248, 'Male Condoms'),
(6249, 'Male VSC'),
(6250, 'Maltese'),
(6251, 'Mammogram'),
(6252, 'Manage'),
(6253, 'Manage Hooks'),
(6254, 'Manage Lists'),
(6255, 'Manage Modules'),
(6256, 'Manage modules'),
(6257, 'Manage modules (manage_modules)'),
(6258, 'Manage Multi Factor Authentication'),
(6259, 'Manage Templates'),
(6260, 'Manage Translations'),
(6261, 'Management'),
(6262, 'Manager'),
(6263, 'Mandatory'),
(6264, 'Mandatory and specified fields'),
(6265, 'Mandatory or specified fields only, dup check, no search'),
(6266, 'Mandatory or specified fields only, search and dup check'),
(6267, 'Mandatory or specified fields only, use patient validation Zend module'),
(6268, 'Manifest (Dry) Refraction'),
(6269, 'Manual'),
(6270, 'Manual eREQ'),
(6271, 'Manual Posting'),
(6272, 'Manual Processing Required'),
(6273, 'Manually retrieve description on Fee Sheet'),
(6274, 'Manually type into the New DX box above.'),
(6275, 'Manufacturer'),
(6276, 'Manufacturing Date'),
(6277, 'Manx'),
(6278, 'Many code items have a lookup/hint.'),
(6279, 'Many companies block operations with USB ports on corporate computers'),
(6280, 'Many of the LOINC codes can be used for both tests and their results'),
(6281, 'Maori'),
(6282, 'Mar'),
(6283, 'Marathi'),
(6284, 'Marathi (Marathi)'),
(6285, 'Marathi (Marāṭhī)'),
(6286, 'March'),
(6287, 'Marginal Reflex Distance'),
(6288, 'Marital'),
(6289, 'Marital Status'),
(6290, 'Mark all as read'),
(6291, 'Mark as Billed'),
(6292, 'Mark as billed but skip billing'),
(6293, 'Mark as Cleared'),
(6294, 'Mark as not billed'),
(6295, 'Mark as Unique'),
(6296, 'Mark Message as Completed'),
(6297, 'Mark Note as Completed'),
(6298, 'Mark these reports as reviewed'),
(6299, 'Marked as cleared'),
(6300, 'Married'),
(6301, 'Marshallese'),
(6302, 'Mask'),
(6303, 'Mask for Invoice Numbers'),
(6304, 'Mask for Patient IDs'),
(6305, 'Mask for Product IDs'),
(6306, 'Mass Immunization Center'),
(6307, 'Match'),
(6308, 'Match case'),
(6309, 'Match Found'),
(6310, 'Match Patient'),
(6311, 'Matched Patient'),
(6312, 'Matching for Patient'),
(6313, 'MaternalAunt'),
(6314, 'MaternalCousin'),
(6315, 'MaternalGrandparent'),
(6316, 'MaternalGreatgrandparent'),
(6317, 'MaternalUncle'),
(6318, 'Matrix'),
(6319, 'max'),
(6320, 'Max'),
(6321, 'Max 255 characters'),
(6322, 'max file count reached'),
(6323, 'max file count reached - reload names below'),
(6324, 'Max number of results to process at a time per Lab'),
(6325, 'Max Size'),
(6326, 'Maxillary Right:'),
(6327, 'Maximum Age'),
(6328, 'Maximum characters'),
(6329, 'Maximum Failed Login Attempts'),
(6330, 'Maximum Failed Login Attempts (0 for no maximum).'),
(6331, 'Maximum idle time in seconds before logout. Default is 1800 (30 minutes).'),
(6332, 'Maximum idle time in seconds before logout. Default is 7200 (2 hours).'),
(6333, 'Maximum length of password (Recommend using the default value of 72 unless you know what you are doing).'),
(6334, 'Maximum number of times a Patient can be tested in a year'),
(6335, 'Maximum number of times a Patient can be tested in a year. Zero is no limit.'),
(6336, 'Maximum Password Length'),
(6337, 'Maximum reasonable inventory, 0 if not applicable'),
(6338, 'Maximum Size'),
(6339, 'Maximum Size (entering 0 will allow any size)'),
(6340, 'Maximum size of thumbnail file'),
(6341, 'May'),
(6342, 'MBO '),
(6343, 'MC'),
(6344, 'mcg'),
(6345, 'MDM Document Category Name'),
(6346, 'Means none of last three passwords are allowed when changing a password.'),
(6347, 'Measure Blood Pressure'),
(6348, 'Measure Group Code'),
(6349, 'Measure INR'),
(6350, 'Measurement'),
(6351, 'Measurement Units'),
(6352, 'MedEx automates Appointment Reminders and Recalls using phone calls, text messages and e-mails'),
(6353, 'MedEx Communication Service'),
(6354, 'MedEx needs a valid mobile number to send SMS messages...'),
(6355, 'MedEx Setup'),
(6356, 'Medial Canthi'),
(6357, 'Medial malleolus:'),
(6358, 'Medicaid'),
(6359, 'Medicaid Original Reference No.'),
(6360, 'Medical'),
(6361, 'Medical Abortion'),
(6362, 'Medical Administration'),
(6363, 'Medical Dashboard'),
(6364, 'Medical Dashboard Help'),
(6365, 'Medical History'),
(6366, 'Medical Issue'),
(6367, 'Medical issue'),
(6368, 'Medical Issues'),
(6369, 'Medical prescription'),
(6370, 'Medical Problem'),
(6371, 'Medical problem'),
(6372, 'Medical Problem Issue List'),
(6373, 'Medical Problems'),
(6374, 'Medical Problems - will show the patient\'s medical issues, Issues > Medical Problems'),
(6375, 'Medical Record'),
(6376, 'Medical Record #'),
(6377, 'Medical Record Dashboard'),
(6378, 'Medical Records'),
(6379, 'Medical Records and History (write,addonly optional) (med)'),
(6380, 'Medical Records Sent'),
(6381, 'Medical Specialty'),
(6382, 'Medical Summary Given'),
(6383, 'Medical System'),
(6384, 'Medical Type'),
(6385, 'Medical/History (write,addonly optional)'),
(6386, 'Medical/History (write,addonly optional) (med)'),
(6387, 'Medicare Part B'),
(6388, 'Medicare Referrer Is Renderer'),
(6389, 'Medication'),
(6390, 'Medication Allergy List'),
(6391, 'Medication Dosage Instructions'),
(6392, 'Medication Issue List'),
(6393, 'Medication List'),
(6394, 'Medication Reconciliation Performed?'),
(6395, 'Medication Request Intent'),
(6396, 'Medication Usage'),
(6397, 'Medications'),
(6398, 'Medications - lists the medications under Issues > Medications. If eRx is enabled the medication list has to be entered on the eRx page'),
(6399, 'Medications Allergy List'),
(6400, 'Medications:'),
(6401, 'Medicine Units'),
(6402, 'Medium'),
(6403, 'Medium{{Priority}}'),
(6404, 'MedlinePlus Connect'),
(6405, 'med{{medial}}'),
(6406, 'Member Association Statistics Report'),
(6407, 'Member Id'),
(6408, 'Memory Problems'),
(6409, 'Men'),
(6410, 'Men and Women'),
(6411, 'Men Only'),
(6412, 'Menarche'),
(6413, 'Menopause'),
(6414, 'Menstrual Flow'),
(6415, 'Menstrual Frequency'),
(6416, 'Mental Illness'),
(6417, 'Mental Status'),
(6418, 'Menu'),
(6419, 'Menu (menu)'),
(6420, 'Menu Text'),
(6421, 'Menus'),
(6422, 'Menus (menus)'),
(6423, 'Merge'),
(6424, 'Merge and Discard'),
(6425, 'Merge and Keep'),
(6426, 'Merge complete.'),
(6427, 'Merge Patients'),
(6428, 'Merge to any patient'),
(6429, 'Message'),
(6430, 'Message and Reminder Center'),
(6431, 'Message Center'),
(6432, 'Message Center Help'),
(6433, 'Message content is not plain text so it has been stored as a document.'),
(6434, 'Message from patient'),
(6435, 'Message List'),
(6436, 'Message Log'),
(6437, 'Message Sent'),
(6438, 'Message Status'),
(6439, 'Message Title'),
(6440, 'Message to patient'),
(6441, 'Message to Reviewer'),
(6442, 'Message type'),
(6443, 'MESSAGE:'),
(6444, 'Messages'),
(6445, 'Messages - due date'),
(6446, 'Messages Screen'),
(6447, 'Messages You have sent Today'),
(6448, 'Messages, Reminders'),
(6449, 'Messages, Reminders, Recalls'),
(6450, 'Messaging'),
(6451, 'Method'),
(6452, 'Method and Specific Product'),
(6453, 'Method Change at this Clinic'),
(6454, 'Method for sending outgoing email.'),
(6455, 'Method of Destruction'),
(6456, 'Mexican/MexAmer/Chicano'),
(6457, 'Mexico'),
(6458, 'MFA'),
(6459, 'MFA Authorization'),
(6460, 'MFA Manaagement'),
(6461, 'MFA Management'),
(6462, 'MFA Verification'),
(6463, 'mg'),
(6464, 'mg/1cc'),
(6465, 'mg/2cc'),
(6466, 'mg/3cc'),
(6467, 'mg/4cc'),
(6468, 'mg/5cc'),
(6469, 'MG/DL'),
(6470, 'mid'),
(6471, 'Middle'),
(6472, 'Middle Name'),
(6473, 'Middle name'),
(6474, 'Middle{{Name}}'),
(6475, 'Midlevel Prescriber'),
(6476, 'Midlevel Prescriber DEA'),
(6477, 'Midlevel Prescriber First name'),
(6478, 'Midlevel Prescriber Last name'),
(6479, 'Midlevel Prescriber NPI'),
(6480, 'Midlevel Prescriber Prefix'),
(6481, 'Midlevel Prescriber UPIN'),
(6482, 'Mid{{Middle Distance Add}}'),
(6483, 'Mid{{middle Rx strength}}'),
(6484, 'Mid{{Middle segment in a trifocal glasses prescription}}'),
(6485, 'mid{{middle}}'),
(6486, 'Mien'),
(6487, 'Migrant or seasonal worker?'),
(6488, 'Migrant Seasonal'),
(6489, 'Migrant/Seasonal'),
(6490, 'Mil/CU.MM'),
(6491, 'Mild'),
(6492, 'Mild anxiety disorder'),
(6493, 'Mild to moderate'),
(6494, 'Military Treatment Facility'),
(6495, 'MIME Type'),
(6496, 'MimeType'),
(6497, 'Min'),
(6498, 'min'),
(6499, 'Min length is 8 with upper,lowercase,numbers mix'),
(6500, 'Min/Max Inventory as Months'),
(6501, 'Min/max inventory is expressed as months of supply instead of units'),
(6502, 'Mini'),
(6503, 'Minimal Logging'),
(6504, 'Minimize this panel'),
(6505, 'Minimum Age'),
(6506, 'Minimum length of password.'),
(6507, 'Minimum Password Length'),
(6508, 'Minor joint strain +/- synovitis'),
(6509, 'minute'),
(6510, 'Minute'),
(6511, 'Minutes'),
(6512, 'minutes'),
(6513, 'Mirth IP'),
(6514, 'Misc'),
(6515, 'Misc Billing Options'),
(6516, 'Misc Billing Options for HCFA-1500'),
(6517, 'Misc Billing Options HCFA'),
(6518, 'Miscellaneous'),
(6519, 'Miscellaneous Billing Options for HCFA-1500'),
(6520, 'Missed'),
(6521, 'missing'),
(6522, 'Missing a required field'),
(6523, 'Missing a required field and will be highlighted'),
(6524, 'Missing email config record'),
(6525, 'Missing Fee'),
(6526, 'Missing Identifying Code'),
(6527, 'Missing information, so aborting credit/void.'),
(6528, 'Missing Insurance Payer Id'),
(6529, 'Missing Mods Only'),
(6530, 'Missing or Invalid'),
(6531, 'Missing Patient ID'),
(6532, 'Missing PID.'),
(6533, 'Missing report date'),
(6534, 'Missing slash after payer in source for code '),
(6535, 'Missing SMS config record'),
(6536, 'Missing Subscriber Policy Number or DOB'),
(6537, 'Missing Title'),
(6538, 'Missing user credentials'),
(6539, 'Missing/invalid notification id'),
(6540, 'Mixed'),
(6541, 'mL'),
(6542, 'ml'),
(6543, 'MM/DD/YYYY'),
(6544, 'mm/hg'),
(6545, 'mmHg'),
(6546, 'MMR 1'),
(6547, 'MMR 2'),
(6548, 'mm{{millimeters}}'),
(6549, 'Mobile'),
(6550, 'Mobile Phone'),
(6551, 'Mobile phones'),
(6552, 'Mobile phones are ubiquitous and are generally easily accessible by any user'),
(6553, 'Mobile Unit'),
(6554, 'Mod'),
(6555, 'Mod Date'),
(6556, 'Mode - Do Not Show SQL Queries'),
(6557, 'Moderate'),
(6558, 'Moderate Priority'),
(6559, 'Moderate to severe'),
(6560, 'Moderate/Low Priority'),
(6561, 'Modern/images'),
(6562, 'Modifier'),
(6563, 'Modifier 22: Increased Procedural Services: When the work required to provide a service is substantially greater than typically required, it may be identified by adding modifier 22 to the usual procedure code.'),
(6564, 'Modifier 24: Unrelated Evaluation and Management Service by the Same Physician During a Postoperative Period'),
(6565, 'Modifier 25: Significant, separately identifiable evaluation and management (E/M) service by the same physician on the day of a procedure or other service'),
(6566, 'Modifier 57: Indicates an Evaluation and Management (E/M) service resulted in the initial decision to perform surgery either the day before a major surgery (90 day global) or the day of a major surgery.'),
(6567, 'Modifier(s)'),
(6568, 'Modifiers'),
(6569, 'Modify'),
(6570, 'Modify Date'),
(6571, 'Modify Patient Form'),
(6572, 'Modify Payments'),
(6573, 'Modifying'),
(6574, 'ModLength'),
(6575, 'Module'),
(6576, 'Module Directory not found'),
(6577, 'Module Installer'),
(6578, 'Module Name'),
(6579, 'Module name already exist'),
(6580, 'Modules'),
(6581, 'Modules (modle)'),
(6582, 'Mon'),
(6583, 'Mon thru Fri'),
(6584, 'Mon, Wed &amp; Fri'),
(6585, 'Monday'),
(6586, 'Mongolian'),
(6587, 'Monocular Pupillary Diameter - Distance'),
(6588, 'Monocular Pupillary Diameter - Near'),
(6589, 'month'),
(6590, 'Month'),
(6591, 'Month View'),
(6592, 'Month(s)'),
(6593, 'Monthly Income'),
(6594, 'months'),
(6595, 'Months'),
(6596, 'months ago'),
(6597, 'Mood/Affect Nml{{Mood and affect normal}}'),
(6598, 'More Actions'),
(6599, 'More appointments may exist'),
(6600, 'More information about Clinical Decision Rule can be found here'),
(6601, 'More information about Issues can be found here'),
(6602, 'More information about what phiMail is and how to set it up is available here'),
(6603, 'More information available at the openEMR MedEx wiki page'),
(6604, 'More information on how to edit this form and other such forms can be found here'),
(6605, 'More information on the use of phiMail messages is available here'),
(6606, 'More options'),
(6607, 'More than'),
(6608, 'More than 100 records found. Please narrow your search criteria.'),
(6609, 'More than 1000 records found. Please narrow your search criteria.'),
(6610, 'More than 50 results, please make your search more specific.'),
(6611, 'More than half of days'),
(6612, 'More than half the days'),
(6613, 'More than one appointment was found'),
(6614, 'Moreover there is a recurring cost incurred in sending the text messages'),
(6615, 'Most activities in relation to a patient are based on an encounter'),
(6616, 'Most column headers can be clicked to change sort order'),
(6617, 'Most often this is due to a Username/Password mismatch'),
(6618, 'Most recent from'),
(6619, 'Most recent lab data:'),
(6620, 'Most recent visit'),
(6621, 'Most recent vitals from:'),
(6622, 'Mother'),
(6623, 'Mother\'s Name'),
(6624, 'Mothers History'),
(6625, 'Mothers Name'),
(6626, 'Motility'),
(6627, 'Mouth'),
(6628, 'Move'),
(6629, 'Move Document to Category:'),
(6630, 'Move Down'),
(6631, 'Move failed!'),
(6632, 'Move the individual items from \'Active\' to \'Inactive\' or vice-versa by selecting the items and pressing the relevant button with the double chevron.'),
(6633, 'Move to Patient'),
(6634, 'Move to Patient PID'),
(6635, 'Move to...'),
(6636, 'Move Up'),
(6637, 'Moving'),
(6638, 'Mo{{Monday}}'),
(6639, 'MPD-D{{abbreviation for Monocular Pupillary Diameter - Distance}}'),
(6640, 'MPD-N{{abbreviation for Monocular Pupillary Diameter - Near}}'),
(6641, 'MR (Dry)'),
(6642, 'Mr.'),
(6643, 'MRD{{marginal reflex distance}}'),
(6644, 'MRI Safety Status'),
(6645, 'MRN (pid)'),
(6646, 'MRN Reference'),
(6647, 'MRNear{{Manifest Near Acuity}}'),
(6648, 'MRNear{{manifest refraction near}}'),
(6649, 'Mrs.'),
(6650, 'MR{{Manifest Refraction}}'),
(6651, 'Ms.'),
(6652, 'MSH-11'),
(6653, 'MSH-3.1'),
(6654, 'MSH-4.1'),
(6655, 'MSH-5.1'),
(6656, 'MSH-6.1'),
(6657, 'MSH.8 message type is not supported'),
(6658, 'MSH.8 message type is not valid'),
(6659, 'MSI (requires LBFmsivd form)'),
(6660, 'MSP'),
(6661, 'MSP Code'),
(6662, 'MSP Remit Codes'),
(6663, 'Multi Factor Authorization - MFA has been increasingly used to authenticate a user without making the process of authentication too onerous'),
(6664, 'Multi Factor Authorization Help'),
(6665, 'Multi Language Tool'),
(6666, 'Multi Select Patients or All Patients using toolbar Location'),
(6667, 'Multi-select desired DX(s) and click the'),
(6668, 'Multi-Select Facilties'),
(6669, 'Multi-Select Provider'),
(6670, 'Multiple areas'),
(6671, 'Multiple DataBase'),
(6672, 'Multiple files can be uploaded at one time by selecting them using CTRL+Click or SHIFT+Click.'),
(6673, 'Multiple Lots'),
(6674, 'Multiple modifiers can be separated by colons or spaces, maximum of 4 (M1:M2:M3:M4)'),
(6675, 'Multiple Select List'),
(6676, 'Multipledb'),
(6677, 'Multipledb (multipledb)'),
(6678, 'Multiracial'),
(6679, 'Murmur:'),
(6680, 'Musc Ache'),
(6681, 'Musc Aches'),
(6682, 'Musc Redness'),
(6683, 'Musc Stiffness'),
(6684, 'Musc Swelling'),
(6685, 'Musc Warm'),
(6686, 'Muscle'),
(6687, 'Muscle injury'),
(6688, 'Musculoskeletal'),
(6689, 'Musculo{{musculoskeletal}}'),
(6690, 'Must be 12 to 80 characters'),
(6691, 'Must be current email address on file.'),
(6692, 'Must be empty if SMTP authentication is not used.'),
(6693, 'Must be future date'),
(6694, 'Must choose at least one day!'),
(6695, 'Must have an encounter to take credit card payment.'),
(6696, 'Mutually Defined'),
(6697, 'MVA'),
(6698, 'MVX Code'),
(6699, 'My Appointments'),
(6700, 'My Dashboard'),
(6701, 'My default facility'),
(6702, 'My Default Values'),
(6703, 'My Documents'),
(6704, 'My Health'),
(6705, 'My Messages'),
(6706, 'My Profile'),
(6707, 'My Signature'),
(6708, 'My Term'),
(6709, 'Myself'),
(6710, 'M{{Monday}}'),
(6711, 'Māori'),
(6712, 'N.B.{{Nota bene}}'),
(6713, 'N/A'),
(6714, 'n/a'),
(6715, 'N/A{{not applicable}}'),
(6716, 'Name'),
(6717, 'NAME'),
(6718, 'Name (click for more)'),
(6719, 'Name (GMDN PT Name)'),
(6720, 'Name - Select a provider name from the drop-down list'),
(6721, 'Name 1'),
(6722, 'Name 2'),
(6723, 'Name and Title of Immunization Administrator'),
(6724, 'Name for this Category, Procedure or Result'),
(6725, 'Name in EMR'),
(6726, 'Name must be like codetype_code_language.pdf, for example icd9_274.11_en.pdf'),
(6727, 'Name of Events'),
(6728, 'Name of insurance company'),
(6729, 'Name of Provider'),
(6730, 'Name of the sender for patient reminders.'),
(6731, 'Name of the Surgeon'),
(6732, 'Name of zend template for html print'),
(6733, 'Name of zend template for html print, possible to add custom template in the PrescriptionTemplate module'),
(6734, 'Name of zend template for pdf export'),
(6735, 'Name of zend template for pdf export, possible to add custom template in the PrescriptionTemplate module'),
(6736, 'Name on Card'),
(6737, 'Name Translation'),
(6738, 'Name/Username'),
(6739, 'Name/Value'),
(6740, 'Name:'),
(6741, 'Names'),
(6742, 'Namespace'),
(6743, 'Narcotic drugs imported'),
(6744, 'NARES:'),
(6745, 'NARES: Normal Right'),
(6746, 'Narrative'),
(6747, 'nasal'),
(6748, 'Nasal mucosa pink, septum midline'),
(6749, 'Nation Notes'),
(6750, 'Nation Notes (nationnotes)'),
(6751, 'Nation Notes (nn_configure)'),
(6752, 'Nation Notes Configure'),
(6753, 'Nation Notes Replace Buttons'),
(6754, 'Nationality'),
(6755, 'NationNotes'),
(6756, 'Native Data Loads'),
(6757, 'Native Hawaiian or Other Pacific Islander'),
(6758, 'Natural Child'),
(6759, 'Natural child'),
(6760, 'Natural Parent'),
(6761, 'Natural Sibling'),
(6762, 'Nauru'),
(6763, 'Nausea'),
(6764, 'Nav Bar'),
(6765, 'Navajo, Navaho'),
(6766, 'Navigation'),
(6767, 'Navigation area includes encounter forms'),
(6768, 'Navigation area uses full height of frameset'),
(6769, 'Navigation Area Visit Forms'),
(6770, 'Navigation Area Width'),
(6771, 'Navigation Area Width for Frames'),
(6772, 'Navigation menu consists of pairs of radio buttons'),
(6773, 'Navigation menu is a tree view'),
(6774, 'Navigation uses a sliding menu'),
(6775, 'NCI CONCEPT ID'),
(6776, 'NCOM{{Neuro comments}}'),
(6777, 'NCPDP'),
(6778, 'NDC'),
(6779, 'NDC Data'),
(6780, 'NDC Number'),
(6781, 'Ndonga'),
(6782, 'Near'),
(6783, 'Near Acuity AutoRefraction'),
(6784, 'Near Acuity Manifest Refraction'),
(6785, 'Near Acuity with Autorefraction'),
(6786, 'Near Acuity with Correction'),
(6787, 'Near Acuity with Manifest (Dry) refraction'),
(6788, 'Near Acuity without Correction'),
(6789, 'Near Point of Accomodation'),
(6790, 'Near Point of Convergence'),
(6791, 'Nearly every day'),
(6792, 'Necessary Medical Equipment'),
(6793, 'Neck'),
(6794, 'Neck Problems'),
(6795, 'Neck supple'),
(6796, 'Need more than one drug.'),
(6797, 'Need to enter a description'),
(6798, 'Need to enter a Return Value'),
(6799, 'Need to enter identifier'),
(6800, 'Need to enter title'),
(6801, 'need to logout/login after changing these settings'),
(6802, 'Needs a Smartphone'),
(6803, 'Needs Auth'),
(6804, 'Needs Justify'),
(6805, 'Needs secondary billing'),
(6806, 'Neg/Nrml'),
(6807, 'Negative'),
(6808, 'Negative payments not accepted'),
(6809, 'Negatives'),
(6810, 'Neg{{negative}}'),
(6811, 'Neighbor'),
(6812, 'Neo 10%'),
(6813, 'Neo 2.5%'),
(6814, 'Nepali'),
(6815, 'Nerve injury'),
(6816, 'NetSuite Reports'),
(6817, 'Network Indicator'),
(6818, 'Neural condition / nerve damage'),
(6819, 'Neuro'),
(6820, 'Neuro Numbness'),
(6821, 'Neuro Weakness'),
(6822, 'Neuro-physiology'),
(6823, 'Neuro/Phys Exam Default Values'),
(6824, 'Neurologic'),
(6825, 'Neurology'),
(6826, 'Neuro{{neurologic}}'),
(6827, 'NEURO{{Neurology}}'),
(6828, 'Never'),
(6829, 'Never Alcohol'),
(6830, 'Never smoker'),
(6831, 'New'),
(6832, 'New =>'),
(6833, 'New Acceptor Policy'),
(6834, 'New Acceptors'),
(6835, 'New Alerts'),
(6836, 'New Allergy'),
(6837, 'New amendment request'),
(6838, 'New Appointment'),
(6839, 'New Categories'),
(6840, 'New Category'),
(6841, 'New Clients'),
(6842, 'New Consultation'),
(6843, 'New Crop'),
(6844, 'New Definition set added'),
(6845, 'New Document'),
(6846, 'New Documents'),
(6847, 'New Due Clinical Reminders'),
(6848, 'New Dx{{new diagnosis}}'),
(6849, 'New Encounter'),
(6850, 'New encounter created with id'),
(6851, 'New Encounter Form'),
(6852, 'New encounters not authorized'),
(6853, 'New Enctr'),
(6854, 'New Facility Information'),
(6855, 'New file'),
(6856, 'New Files'),
(6857, 'New form validation'),
(6858, 'New Group'),
(6859, 'New group encounter created with id'),
(6860, 'New Group Encounter Form'),
(6861, 'New Group Information'),
(6862, 'New group was saved successfully'),
(6863, 'New Immunization Record'),
(6864, 'New in ACL Ver 4'),
(6865, 'New in ACL Ver 5'),
(6866, 'New in ACL Ver 6'),
(6867, 'New in ACL Ver 7'),
(6868, 'New in ACL Ver 8'),
(6869, 'New in openEMR ver 5.0.2 '),
(6870, 'New Inj/Status'),
(6871, 'New Items (see above for details)'),
(6872, 'New Layout'),
(6873, 'New Limit of Events'),
(6874, 'New List'),
(6875, 'New Message'),
(6876, 'new messages'),
(6877, 'new method in contraception form does not match the contraception service'),
(6878, 'New Note'),
(6879, 'New or Current Password'),
(6880, 'New or Current Username'),
(6881, 'New Orders'),
(6882, 'New Paragraph'),
(6883, 'New Password'),
(6884, 'New Patient'),
(6885, 'NEW PATIENT'),
(6886, 'New Patient Encounter'),
(6887, 'New Patient Form'),
(6888, 'New Patient ID'),
(6889, 'New patient registration received from patient portal. Reminder to check for possible new appointment'),
(6890, 'New Patients'),
(6891, 'New Payment'),
(6892, 'New payment'),
(6893, 'New Portal Login'),
(6894, 'New Procedure Order'),
(6895, 'New Pt'),
(6896, 'New Recall'),
(6897, 'New results from Lab Exchange'),
(6898, 'New Search'),
(6899, 'New Submissions'),
(6900, 'New to openEMR 5.0.2'),
(6901, 'New User'),
(6902, 'New Value'),
(6903, 'New Visit'),
(6904, 'New/Search'),
(6905, 'NewCrop Account Status'),
(6906, 'NewCrop Admin'),
(6907, 'NewCrop call failed'),
(6908, 'NewCrop Doctor'),
(6909, 'NewCrop eRx Account Id'),
(6910, 'NewCrop eRx Account Name'),
(6911, 'NewCrop eRx Debug Setting'),
(6912, 'NewCrop eRx Default Patient Country'),
(6913, 'NewCrop eRx Name'),
(6914, 'NewCrop eRx Partner Name'),
(6915, 'NewCrop eRx Password'),
(6916, 'NewCrop eRX Role'),
(6917, 'NewCrop eRx Role'),
(6918, 'NewCrop eRx Site Address'),
(6919, 'NewCrop eRx SOAP Request Time-To-Live for Allergies'),
(6920, 'NewCrop eRx SOAP Request Time-To-Live for Medications'),
(6921, 'NewCrop eRx User Role'),
(6922, 'NewCrop eRx User Role * invalid selection *'),
(6923, 'NewCrop eRx Web Service Address'),
(6924, 'NewCrop Manager'),
(6925, 'NewCrop MedEntry'),
(6926, 'NewCrop Midlevel Prescriber'),
(6927, 'NewCrop Nurse'),
(6928, 'NewCrop Supervising Doctor'),
(6929, 'Newer'),
(6930, 'NewRx'),
(6931, 'Newspaper'),
(6932, 'Next'),
(6933, 'Next Appointment Date'),
(6934, 'Next Day'),
(6935, 'Next Due'),
(6936, 'Next Month'),
(6937, 'Next month (hold for menu)'),
(6938, 'Next of Kin Relationship'),
(6939, 'Next Scheduled Run'),
(6940, 'Next Visit'),
(6941, 'Next Visit Orders'),
(6942, 'Next Week'),
(6943, 'Next year (hold for menu)'),
(6944, 'Nick Name'),
(6945, 'Nickname'),
(6946, 'Niece/Nephew'),
(6947, 'Night Sweats'),
(6948, 'NKDA{{No known drug allergies}}'),
(6949, 'Nl ext genitalia, vag mucosa, cervix'),
(6950, 'No'),
(6951, 'NO'),
(6952, 'no'),
(6953, 'No access'),
(6954, 'No active access tokens found'),
(6955, 'No active patient reminders.'),
(6956, 'No active refresh tokens found'),
(6957, 'No adenopathy (2 areas required)'),
(6958, 'No adjustment reason type found for'),
(6959, 'No adnexal tenderness/masses'),
(6960, 'No alert'),
(6961, 'No amendment requests available'),
(6962, 'No anxiety disorder'),
(6963, 'No Appointments'),
(6964, 'No archive files present'),
(6965, 'No Archives'),
(6966, 'No Assessment to Display.'),
(6967, 'No audit log tampering detected in the selected date range.'),
(6968, 'No authorized users found for this client'),
(6969, 'No automatic refresh'),
(6970, 'No available readers.'),
(6971, 'No billing system is currently active'),
(6972, 'No Bills Found to Include in OFX Export'),
(6973, 'No Bills Found to Include in OFX Export<br>'),
(6974, 'No Changes Detected'),
(6975, 'No code was specified!'),
(6976, 'No Configuration Defined for this Module'),
(6977, 'No data available in table'),
(6978, 'No Data to Process'),
(6979, 'No Diagnosis'),
(6980, 'no diagnosis was auto-generated from the clinical findings.'),
(6981, 'No directory for X12 partner '),
(6982, 'No Documents'),
(6983, 'No Documents Found'),
(6984, 'No Encounter could be created'),
(6985, 'No encounter...'),
(6986, 'No end date'),
(6987, 'No entries found, use the form below to add an entry.'),
(6988, 'No errors found'),
(6989, 'No Events'),
(6990, 'No Fax Number Saved For The Selected Organization'),
(6991, 'No file specified'),
(6992, 'No files staged for installation'),
(6993, 'No form selected to order!'),
(6994, 'No group was selected'),
(6995, 'No hernia'),
(6996, 'No history recorded'),
(6997, 'No Hooks Available in this Module'),
(6998, 'No Hooks enabled for this Module'),
(6999, 'No injury/illness'),
(7000, 'No Insurance Companies Found'),
(7001, 'No interactions found'),
(7002, 'No invoices were checked.'),
(7003, 'No Issues'),
(7004, 'No issues in this encounter.'),
(7005, 'No items under selected category'),
(7006, 'No items were selected!'),
(7007, 'No Known Allergies'),
(7008, 'No Known Clinical Instructions'),
(7009, 'No Known Encounters'),
(7010, 'No Known Immunizations'),
(7011, 'No Known Lab Results'),
(7012, 'No Known Medications'),
(7013, 'No Known Plan of Care'),
(7014, 'No Known Problems'),
(7015, 'No Known Procedures'),
(7016, 'No Known Referrals'),
(7017, 'No Known Social Functional Status'),
(7018, 'No Known Social History'),
(7019, 'No Known Vitals'),
(7020, 'No lab data documented.'),
(7021, 'No Language ID specified'),
(7022, 'No log file exist for the selected date'),
(7023, 'No logging'),
(7024, 'No logs older than 7 days'),
(7025, 'No masses, tenderness'),
(7026, 'No match Patient record found for the given Re Idenitification code'),
(7027, 'No matches for'),
(7028, 'No matches found. Try search again.'),
(7029, 'No matches were found.'),
(7030, 'No matches were found. Create the new patient now?'),
(7031, 'No matching records found'),
(7032, 'No Maximum'),
(7033, 'No member fields found for'),
(7034, 'No method enabled'),
(7035, 'No Minimum'),
(7036, 'No Name'),
(7037, 'No new messages on'),
(7038, 'No new results found'),
(7039, 'No notes'),
(7040, 'No ogrganomegoly'),
(7041, 'No openings were found for this period.'),
(7042, 'No Order found, please enter procedure order first'),
(7043, 'No organomegaly'),
(7044, 'No other phone numbers listed'),
(7045, 'No parameters selected'),
(7046, 'No Partners Found'),
(7047, 'No Patient record found for given Selection criteria'),
(7048, 'No Patient record found for the given Re Identification code'),
(7049, 'No patients to select'),
(7050, 'No patients without scores were found.'),
(7051, 'No peripheral edema'),
(7052, 'No Pharmacies Found'),
(7053, 'No Prescriptions Found'),
(7054, 'No prescriptions selected'),
(7055, 'No presenting illness/injury'),
(7056, 'No previous entries.'),
(7057, 'No Primary Business Entity selected in facility list'),
(7058, 'No prior encounters.'),
(7059, 'No procedures in this encounter.'),
(7060, 'No provider was matched'),
(7061, 'No Providers Found'),
(7062, 'No rash or abnormal lesions'),
(7063, 'No Recall'),
(7064, 'No records available'),
(7065, 'No records found'),
(7066, 'No records found.'),
(7067, 'No records found. Please expand your search criteria.'),
(7068, 'No registered SMART apps in the system'),
(7069, 'No reminder/recall'),
(7070, 'No Reminders'),
(7071, 'No Result Found, for the above search criteria.'),
(7072, 'No Results'),
(7073, 'No results found'),
(7074, 'No results found for'),
(7075, 'No Results Found For Search'),
(7076, 'No results found, please try again.'),
(7077, 'No results, please tray again.'),
(7078, 'No results, please try again.'),
(7079, 'No scopes'),
(7080, 'No Settings avaliable in this module'),
(7081, 'No Show'),
(7082, 'No show'),
(7083, 'no signature in document'),
(7084, 'No signatures on file'),
(7085, 'No Sinus Tenderness:'),
(7086, 'No skin dimpling or breast nodules'),
(7087, 'NO SUCH CONTEXT NAME'),
(7088, 'No table selected! Select a table.'),
(7089, 'No testicular tenderness, masses'),
(7090, 'No Thanks'),
(7091, 'No thrills or heaves'),
(7092, 'No track selected'),
(7093, 'No tracks have been documented.'),
(7094, 'No translations!'),
(7095, 'No version of Internet Explorer supports U2F'),
(7096, 'No visit'),
(7097, 'No vitals have been documented.'),
(7098, 'No X-12 partner assigned for claim '),
(7099, 'No, Cancel'),
(7100, 'No-fault Insurance including Auto is Primary'),
(7101, 'No:'),
(7102, 'Nocturia'),
(7103, 'Non Paid'),
(7104, 'Non Provider'),
(7105, 'Non Reported Report'),
(7106, 'Non specific injury'),
(7107, 'Non-Consumable Only'),
(7108, 'Non-electronic'),
(7109, 'Non-Insulin Dependent Diabetes'),
(7110, 'Non-Insured'),
(7111, 'Non-residential Substance Abuse Treatment Facility'),
(7112, 'Non-SRH Medical'),
(7113, 'Non-SRH Non-Medical'),
(7114, 'None'),
(7115, 'none'),
(7116, 'None defined'),
(7117, 'None documented'),
(7118, 'None have been documented'),
(7119, 'None of the above'),
(7120, 'None of the Top Distribution Row Can be Completly Blank.'),
(7121, 'None required'),
(7122, 'None Selected'),
(7123, 'None{{Advanced_Directives}}'),
(7124, 'None{{Amendment}}'),
(7125, 'None{{Appointment}}'),
(7126, 'None{{Authorization}}'),
(7127, 'None{{Category}}'),
(7128, 'none{{Code}}'),
(7129, 'None{{Diagnosis}}'),
(7130, 'None{{Disclosure}}'),
(7131, 'None{{Encounter}}'),
(7132, 'None{{Group}}'),
(7133, 'None{{Immunizations}}'),
(7134, 'None{{Insurance}}'),
(7135, 'None{{Issues}}'),
(7136, 'None{{Issue}}'),
(7137, 'None{{Note}}'),
(7138, 'None{{Partner}}'),
(7139, 'None{{Patient}}'),
(7140, 'None{{Prescriptions}}'),
(7141, 'None{{Recipients}}'),
(7142, 'None{{Result}}'),
(7143, 'None{{Sales}}'),
(7144, 'None{{Sensitivity}}'),
(7145, 'None{{Side}}'),
(7146, 'none{{Symptoms}}'),
(7147, 'none{{Template}}'),
(7148, 'None{{Therapy Group}}'),
(7149, 'None{{Transaction}}'),
(7150, 'Noninsulin Dependent Diabetes'),
(7151, 'Nor'),
(7152, 'Normal'),
(7153, 'Normal (normal)'),
(7154, 'Normal BL'),
(7155, 'Normal Cardiac Exam:'),
(7156, 'Normal Cardiac Exam: '),
(7157, 'Normal Lung Exam:'),
(7158, 'Normal Lung Exam: '),
(7159, 'Normal Office Visit'),
(7160, 'Normal Oropharynx:'),
(7161, 'Normal Right'),
(7162, 'Normal Right:'),
(7163, 'Normal View'),
(7164, 'normal:'),
(7165, 'Normally this should be checked. Not related to access control.'),
(7166, 'North Ndebele'),
(7167, 'Northern Sami'),
(7168, 'Norwegian'),
(7169, 'Norwegian Bokmal'),
(7170, 'Norwegian Bokmål'),
(7171, 'Norwegian Nynorsk'),
(7172, 'Nose'),
(7173, 'Nosebleed'),
(7174, 'not a letter or number'),
(7175, 'Not active'),
(7176, 'Not Administered'),
(7177, 'Not all fields are required for all codes or code types.'),
(7178, 'Not all old browsers support U2F. Using the latest versions of modern browsers - Chrome, Firefox, Safari, Edge and Opera should suffice'),
(7179, 'Not Allowed'),
(7180, 'Not allowed to delete the Administrators group'),
(7181, 'Not Allowed to Edit'),
(7182, 'Not allowed to inactivate all security objects'),
(7183, 'Not allowed to inactivate anything from the Administrators ACL'),
(7184, 'Not allowed to remove the admin user from the Administrators group'),
(7185, 'Not allowed to remove this user from the Administrators group'),
(7186, 'not answered'),
(7187, 'Not applicable'),
(7188, 'Not Applicable'),
(7189, 'Not at all'),
(7190, 'Not authorised to access PostCalendar module'),
(7191, 'Not Authorized'),
(7192, 'Not authorized'),
(7193, 'Not authorized for this squad!'),
(7194, 'Not authorized for this squad.'),
(7195, 'Not authorized to manage users!'),
(7196, 'Not authorized to sign results'),
(7197, 'Not authorized to view this encounter'),
(7198, 'Not authorized!'),
(7199, 'Not Available'),
(7200, 'Not being able to stop or control worrying'),
(7201, 'Not Billed'),
(7202, 'Not billed'),
(7203, 'Not Checked'),
(7204, 'Not checked out'),
(7205, 'Not Coded'),
(7206, 'Not controlling worry'),
(7207, 'Not documented'),
(7208, 'Not Due'),
(7209, 'Not Esigned'),
(7210, 'Not Examined'),
(7211, 'Not Examined:'),
(7212, 'Not Examined: '),
(7213, 'Not For Diagnostic Use'),
(7214, 'not found'),
(7215, 'Not Found'),
(7216, 'not found!'),
(7217, 'Not Hispanic or Latino'),
(7218, 'Not installed'),
(7219, 'Not Installed'),
(7220, 'Not Possible'),
(7221, 'Not Required'),
(7222, 'Not required.'),
(7223, 'Not required. This password is for generated admin.p12'),
(7224, 'Not seen since'),
(7225, 'Not sent'),
(7226, 'Not Sent Yet'),
(7227, 'Not signed.'),
(7228, 'Not Specified'),
(7229, 'Not Specified.'),
(7230, 'Not VFC eligible'),
(7231, 'Not yet implemented.'),
(7232, 'Note'),
(7233, 'NOTE'),
(7234, 'Note Category'),
(7235, 'Note Codes'),
(7236, 'Note Details'),
(7237, 'Note it is recommended to avoid approving SMART apps that do not register as a confidential client. These apps are less secure and should be highly restricted in the OAUTH2 scopes you allow them to access.'),
(7238, 'Note it will take 5-10 minutes to fully process after you click Install'),
(7239, 'Note it will take 5-10 minutes to fully process after you click Upgrade'),
(7240, 'Note that Audit Logging needs to be enabled above'),
(7241, 'Note that the Eventlog Backup is currently set to save in the following folder'),
(7242, 'Note that the pop-up form heading will now read Enter Details for Custom Favorite Group'),
(7243, 'Note that the pop-up form heading will now read Enter Details for Discrete Results'),
(7244, 'Note that the pop-up form heading will now read Enter Details for Individual Procedures'),
(7245, 'Note there is no \'Save\' button.'),
(7246, 'Note this refers to the Continuity of Care Record (CCR) or Continuity of Care Document (CCD) as the case may be'),
(7247, 'Note Type'),
(7248, 'Note: 12:00 noon is PM, not AM'),
(7249, 'NOTE: Importing external data can take more than an hour depending on your hardware configuration. For example, one of the RxNorm data tables contain in excess of 6 million rows.'),
(7250, 'NOTE: Only the Biannual International Snomed Release is currently supported'),
(7251, 'NOTE: Only the Biannual International Snomed Releases and the US Snomed Releases are currently supported'),
(7252, 'NOTE: Only the full monthly RxNorm release is currently supported'),
(7253, 'NOTE: Only the XML formats and Eligible Professionals valuesets supported'),
(7254, 'NOTE: The import can take up to several hours'),
(7255, 'Note: This code has not been authorized.'),
(7256, 'Note: This code was not entered by an authorized user. Only authorized codes may be uploaded to the Open Medical Billing Network for processing. If you wish to upload these codes, please select an authorized user here.'),
(7257, 'Note: This copay was entered against billing that has not been authorized. Please review status.'),
(7258, 'Note: this is not an email address'),
(7259, 'NOTE: Uploading files with duplicate names will cause the files to be automatically renamed (for example, file.jpg will become file.1.jpg). Filenames are considered unique per patient, not per category.'),
(7260, 'NOTE: Uploading files with duplicate names will cause the files to be automatically renamed. For example \'<i>file.jpg</i>\' will become \'<i>file.jpg.1</i>\'. Filenames are considered unique per patient, not per category. '),
(7261, 'Notes'),
(7262, 'NOTES'),
(7263, 'Notes - A short description that will show up as a tooltip'),
(7264, 'Notes - any encounters (write,addonly optional)'),
(7265, 'Notes - any encounters (write,addonly optional) (notes_a)'),
(7266, 'Notes - my encounters (write,addonly optional)'),
(7267, 'Notes - my encounters (write,addonly optional) (notes)'),
(7268, 'Notes by'),
(7269, 'Notes not authorized'),
(7270, 'Nothing found - sorry'),
(7271, 'Nothing Pending for Approval'),
(7272, 'Nothing Recorded'),
(7273, 'Nothing returned to report'),
(7274, 'Nothing to display'),
(7275, 'Nothing to import for Allergy'),
(7276, 'Nothing to import for Prescription'),
(7277, 'Nothing to Post! Please review entries or use Cancel to exit transaction'),
(7278, 'Nothing To Report'),
(7279, 'Nothing to show'),
(7280, 'Nothing to show for current actions.'),
(7281, 'Nothing was selected'),
(7282, 'Notice'),
(7283, 'Notice how the Top Group entry that was initially created called Serum Chemistry now has a blue + sign before its name indicating the presence of descendants or children to this entry'),
(7284, 'Notice Received'),
(7285, 'NOTICE:: PostCalendar Submission/Modification'),
(7286, 'Notification'),
(7287, 'Notification Email Address'),
(7288, 'Notification FAILED'),
(7289, 'Notification FAILED: Not Portal Authorized'),
(7290, 'Notification sent to'),
(7291, 'Notification Settings'),
(7292, 'Notifications'),
(7293, 'Notify Admin About Event Submission/Modification?'),
(7294, 'Notify Patient'),
(7295, 'Notify Patients Portal'),
(7296, 'Notify via Patient Portal'),
(7297, 'Nov'),
(7298, 'November'),
(7299, 'Now is the time to check and adjust the settings in openEMR for default units, sites, etc., refer to the help file in Procedures > Providers'),
(7300, 'Now posting for'),
(7301, 'Now posting for:'),
(7302, 'Now printing'),
(7303, 'Now printing $stmt_count statements and updating encounters.'),
(7304, 'Now printing $stmt_count statements and updating invoices.'),
(7305, 'Now printing $stmt_count statements; encounters will not be updated.'),
(7306, 'Now printing $stmt_count statements; invoices will not be updated.'),
(7307, 'Now when you bring up the Select Codes pop-up you will see all the ICD10 codes listed'),
(7308, 'Now when you bring up the Select Diagnosis Codes pop-up you will see all the ICD10 codes listed'),
(7309, 'NPA{{near point of accomodation}}'),
(7310, 'NPC{{near point of convergence}}'),
(7311, 'NPI'),
(7312, 'NPI - Enter the Provider\'s unique 10-digit National Provider Identifier or NPI identification number'),
(7313, 'NQF'),
(7314, 'Number'),
(7315, 'Number labs'),
(7316, 'Number of Appointments on Statement'),
(7317, 'Number of Appointments to display in the Group Summary'),
(7318, 'Number of Appointments to display in the Onsite Patient Portal'),
(7319, 'Number of Appointments to display in the Patient Summary'),
(7320, 'Number of columns in year view.'),
(7321, 'Number of days before showing fifth account message'),
(7322, 'Number of days before showing first account message'),
(7323, 'Number of days before showing first account message.'),
(7324, 'Number of days before showing fourth account message'),
(7325, 'Number of days before showing second account message'),
(7326, 'Number of days before showing third account message'),
(7327, 'Number of days that the client certificate is valid.'),
(7328, 'Number of days to search from the start date'),
(7329, 'Number of digits after decimal point for currency, usually 0 or 2.'),
(7330, 'Number of encounters to display per page.'),
(7331, 'Number of Excluded Appointments to display in the Tooltip'),
(7332, 'Number of games or events missed, if any'),
(7333, 'Number of hours in advance to send email notifications.'),
(7334, 'Number of hours in advance to send Phone notification.'),
(7335, 'Number of hours in advance to send SMS notifications.'),
(7336, 'Number of Messages Displayed in Patient Summary'),
(7337, 'Number of Minutes to display completed checkouts'),
(7338, 'Number of Minutes to display completed checkouts. Zero is continuous display'),
(7339, 'Number of past history columns'),
(7340, 'Number of patients to display per page in the patient list.'),
(7341, 'Numbness'),
(7342, 'Numerator'),
(7343, 'Numeric display order'),
(7344, 'Nuosu'),
(7345, 'Nursing Facility'),
(7346, 'Nutrition'),
(7347, 'Nutritional'),
(7348, 'O.A.F.V.'),
(7349, 'O2 Sat'),
(7350, 'OAuth2 using SMART-on-FHIR profile (see http://docs.smarthealthit.org)'),
(7351, 'Obesity I'),
(7352, 'Obesity II'),
(7353, 'Obesity III'),
(7354, 'Objective'),
(7355, 'Obligatory participation'),
(7356, 'Observation'),
(7357, 'Observation Criteria'),
(7358, 'Observation Criteria Value'),
(7359, 'Observation Form'),
(7360, 'Observation Results'),
(7361, 'Observation Results in Immunization'),
(7362, 'Occitan'),
(7363, 'Occupation'),
(7364, 'Occupational physician'),
(7365, 'occurred while uploading file named'),
(7366, 'Occurrence'),
(7367, 'Oct'),
(7368, 'October'),
(7369, 'OD'),
(7370, 'OD{{right eye}}'),
(7371, 'oeFHIR'),
(7372, 'of'),
(7373, 'of quantity'),
(7374, 'of tablets'),
(7375, 'of the month every'),
(7376, 'Ofc Notes'),
(7377, 'Off'),
(7378, 'Off (Recommended setting)'),
(7379, 'Off Campus-Outpatient Hospital'),
(7380, 'Off: No Service.'),
(7381, 'Office'),
(7382, 'Office Announcements'),
(7383, 'Office Note'),
(7384, 'Office Notes'),
(7385, 'Office Visit'),
(7386, 'Official Clinical Quality Measures (CQM) Measure Groups'),
(7387, 'Offline access end date'),
(7388, 'offline_access'),
(7389, 'Offsite Https link for the Patient Portal.'),
(7390, 'Offsite Https link for the Patient Portal.(Patient Link)'),
(7391, 'Offsite Patient Portal Password'),
(7392, 'Offsite Patient Portal Password(Put Blank If not Registered).'),
(7393, 'Offsite Patient Portal Provider ID'),
(7394, 'Offsite Patient Portal Provider ID(Put Blank If not Registered).'),
(7395, 'Offsite Patient Portal Site Address'),
(7396, 'Offsite Patient Portal Site Address (Patient Link)'),
(7397, 'Offsite Patient Portal Username'),
(7398, 'Offsite Patient Portal Username(Put Blank If not Registered).'),
(7399, 'Offsite Portal web Service Failed'),
(7400, 'Offspring'),
(7401, 'Offspring History'),
(7402, 'Oh Snap!'),
(7403, 'OID'),
(7404, 'ointment'),
(7405, 'Ojibwe, Ojibwa'),
(7406, 'OK'),
(7407, 'Ok'),
(7408, 'OK to close this other popup window?'),
(7409, 'OK to link the GCAC issue dated'),
(7410, 'Old'),
(7411, 'Old Church Slavonic, Church Slavonic, Old Bulgarian'),
(7412, 'Old Clients'),
(7413, 'Old fracture non / malunion'),
(7414, 'Old Medication'),
(7415, 'Old style layout with no left menu'),
(7416, 'Old-style static form without search or duplication check'),
(7417, 'Older'),
(7418, 'Older than'),
(7419, 'Oldest drawing'),
(7420, 'Omit'),
(7421, 'Omit circumferences'),
(7422, 'Omit employer information in patient demographics'),
(7423, 'Omit Employers'),
(7424, 'Omit form, route and interval which then become part of dosage'),
(7425, 'Omit insurance and some other things from the demographics form'),
(7426, 'Omit internal users?'),
(7427, 'Omit method of payment from the co-pay panel'),
(7428, 'omit to autoassign'),
(7429, 'On'),
(7430, 'on'),
(7431, 'on file email'),
(7432, 'On first page'),
(7433, 'On for Both Roles'),
(7434, 'On for Patient Role'),
(7435, 'On for Users Role'),
(7436, 'On Hand'),
(7437, 'On mobile devices tap once on the label to reveal the help icon and tap on the icon to show the help section'),
(7438, 'On opening, all dx code rows that match the new procedure from procedure order form will be marked and then will scroll to the first match.'),
(7439, 'On Order'),
(7440, 'On Site'),
(7441, 'On the other hand if you click register but do not capture the QR code with the authenticator app you will not be able to login'),
(7442, 'On these lines the Code column will be blank'),
(7443, 'On this date there is a holiday, use it anyway?'),
(7444, 'On-line'),
(7445, 'On: HAPI FHIR.'),
(7446, 'On: Smart on FHIR.'),
(7447, 'Once a rule is setup it can be enabled for a particular patient'),
(7448, 'Once a template is uploaded, you may change the category at anytime from the repository view.'),
(7449, 'Once a template or available profile have been selected the Send button will show in the Scope toolbar. Click it to perform the action. A confirmation popup will then show on success or an error message otherwise.'),
(7450, 'Once a Transaction is saved it will appear on the Transaction page'),
(7451, 'Once an appointment is scheduled the name automatically drops off the recall board'),
(7452, 'Once an appointment is scheduled the recall will drop off the Recall Board'),
(7453, 'Once completed, view and store this encounter as a PDF file'),
(7454, 'Once finished editing, click Save. The procedure forms current procedure diagnoses will fill exactly as built in this dialog.'),
(7455, 'Once saved the entity for a Custom Favorite Group cannot be changed. If you need to change the entity you have to delete this entry and create a new one'),
(7456, 'Once the app captures the QR code it will show the OpenEMR user name in the app'),
(7457, 'Once the Primary Business Facility is set, changing the facility id will affect NewCrop ePrescription.'),
(7458, 'Once the Primary Business Facility is set, it should not be changed. Changing the facility will affect the working in NewCrop ePrescription.'),
(7459, 'Once this feature is enabled you will be required to type in the 6 digit key at each login'),
(7460, 'Once this is done the shared secret key that is unique for each user should only exist in OpenEMR and on the user\'s authenticator app'),
(7461, 'Once this step is completed you can proceed to next step - to configure the tests that can be ordered from the system'),
(7462, 'Once you change your password, you will have to re-login.'),
(7463, 'Once you select a justification code for the first CPT line all subsequent CPT code lines will have the same justification. Can be manually altered later if so desired'),
(7464, 'Oncology: Medical and Radiation – Pain Intensity Quantified (CQM)'),
(7465, 'One Day Ago'),
(7466, 'One Day Ahead'),
(7467, 'One Encounter Per Day'),
(7468, 'One Month Ago'),
(7469, 'One Month Ahead'),
(7470, 'One or more transactions failed'),
(7471, 'One such lab uses 905 for Uric Acid and in our example we will enter that number in the box'),
(7472, 'One time'),
(7473, 'One Time PIN'),
(7474, 'One Time verification PIN'),
(7475, 'One Week Ahead'),
(7476, 'One Year Ago'),
(7477, 'One Year Ahead'),
(7478, 'One-time password or OTP is a commonly used strategy used to provide a unique code for each login'),
(7479, 'Online'),
(7480, 'Online Support'),
(7481, 'Online Support Link'),
(7482, 'Online Users'),
(7483, 'Only Active'),
(7484, 'Only applicable if a provider or collated list was chosen above. PRIMARY only selects patients that the provider is the primary provider. ENCOUNTER selects all patients that the provider has seen.'),
(7485, 'Only entries with a Code are billable'),
(7486, 'Only for comparisons'),
(7487, 'Only for HTML5 compatible browsers.'),
(7488, 'only if billing location'),
(7489, 'Only images files are accepted'),
(7490, 'Only Inactive'),
(7491, 'Only Include E-Signed Forms On Report'),
(7492, 'Only Mine'),
(7493, 'Only need to set this if the server is not providing the correct host for OAuth2, FHIR or CCDA. Example is'),
(7494, 'Only one TOTP Key can be set up per user'),
(7495, 'Only recall to provider, no reminder'),
(7496, 'Only reminder to provider, no recall'),
(7497, 'Only Show Active Codes '),
(7498, 'Only Show Diagnosis Reporting Codes'),
(7499, 'Only Show Service Code Finance Reporting Codes'),
(7500, 'Only upload active prescriptions'),
(7501, 'Only upload active prescriptions to NewCrop eRx.'),
(7502, 'Onset'),
(7503, 'Onset of Current Symptoms or Illness'),
(7504, 'Onset of Illness:'),
(7505, 'Onset of Ilness: '),
(7506, 'Onset of Swelling:'),
(7507, 'Onset/Hosp Date for Encounters'),
(7508, 'Onset/hosp. date'),
(7509, 'Onset/hosp. date - is used for billing hospital encounters'),
(7510, 'Onset/hosp. date:'),
(7511, 'Onsite Activity Views'),
(7512, 'Onsite Patient Activities'),
(7513, 'Onsite Patient Portal'),
(7514, 'Onsite Patient Portal Site Address'),
(7515, 'Onsite Portal'),
(7516, 'Onsite Portal Activities'),
(7517, 'Onsite Portal Reviewed'),
(7518, 'Oops!'),
(7519, 'Open'),
(7520, 'Open a spreadsheet and type in the various groups, procedure orders and discrete results, arrange according to need'),
(7521, 'Open a spreadsheet in openoffice/LibreOffice create 5 columns - three for E/M / CPT codes and two for the ICD code categories'),
(7522, 'Open all expandable forms in expanded state'),
(7523, 'Open and review the message content and any attachments'),
(7524, 'Open Demographics in New Window from Patient Flow Board'),
(7525, 'Open Encounter'),
(7526, 'Open Fee Sheet'),
(7527, 'Open Forms Module'),
(7528, 'Open in New Window'),
(7529, 'Open invoice (will refresh page)'),
(7530, 'Open Med Practice and its suppliers use their commercially reasonable efforts to provide the most current and complete data available to them concerning prescription histories, drug interactions and formularies, patient allergies and other factors, but by your use of this service you acknowledge that (1) the completeness and accuracy of such data depends upon the completeness and accuracy with which it is entered into connected electronic databases by physicians, physician’s offices, pharmaceutical benefits managers, electronic medical records firms, and other network participants, (2) such data is subject to error or omission in input, storage or retrieval, transmission and display, technical disruption, power or service outages, or other interruptions in electronic communication, any or all of which may be beyond the control of Open Med Practice and its suppliers, and (3) some information may be unavailable due to regulatory, contractual, privacy or other legal restrictions. You are responsible to use your clinical judgment at all times in rendering medical service and advice.'),
(7531, 'Open Patient'),
(7532, 'Open Patient in New Window'),
(7533, 'Open the Quick Pick panels'),
(7534, 'Open the Shorthand Window and display Shorthand Codes'),
(7535, 'Open Today`s Visit'),
(7536, 'Open/Close Ant Seg panels'),
(7537, 'Open/Close External Exam panels'),
(7538, 'Open/Close Imp/Plan panels'),
(7539, 'Open/Close Neuro panels'),
(7540, 'Open/Close Post Seg panels'),
(7541, 'Open/Close the Anterior Segment drawing panel'),
(7542, 'Open/Close the Anterior Segment Exam Quick Picks panel'),
(7543, 'Open/Close the detailed HPI panel'),
(7544, 'Open/Close the External drawing panel'),
(7545, 'Open/Close the External Exam Quick Picks panel'),
(7546, 'Open/Close the HPI Canvas'),
(7547, 'Open/Close the Imp/Plan drawing panel'),
(7548, 'Open/Close the Impression/Plan Builder panel'),
(7549, 'Open/Close the Neuro drawing panel'),
(7550, 'Open/Close the Neuro Exam Quick Picks panel'),
(7551, 'Open/Close the PMH draw panel'),
(7552, 'Open/Close the PMSFH panel'),
(7553, 'Open/Close the PMSFH summary panel'),
(7554, 'Open/Close the Retina drawing panel'),
(7555, 'Open/Close the Retinal Exam Quick Picks panel'),
(7556, 'Open/Close the Shorthand Window and Codes'),
(7557, 'Open/Close the Shorthand Window and display Shorthand Codes'),
(7558, 'Open/Close the Shorthand Window and display Shorthand Codes next to each field'),
(7559, 'Open/Close the Shorthand Window and display Shorthand Codes.'),
(7560, 'OpenEMR'),
(7561, 'OpenEMR allows one TOTP but multiple U2F methods per user'),
(7562, 'OpenEMR already has a Certificate Authority configured.'),
(7563, 'OpenEMR App Registration'),
(7564, 'OpenEMR Application'),
(7565, 'OpenEMR Application Category'),
(7566, 'OpenEMR Authorization'),
(7567, 'OpenEMR Database Upgrade'),
(7568, 'OpenEMR Database Upgrade for De-identification'),
(7569, 'OpenEMR does not recognize the incoming file in the contrib directory. This is most likely because you need to configure the release in the supported_external_dataloads table in the MySQL database.'),
(7570, 'OpenEMR Login'),
(7571, 'OpenEMR must be configured to use certificates before it can create client certificates.'),
(7572, 'OpenEMR offers 2 methods of 2FA'),
(7573, 'OpenEMR Portal'),
(7574, 'OpenEMR Product Registration'),
(7575, 'OpenEMR requires Javascript to perform user authentication.'),
(7576, 'OpenEMR Users'),
(7577, 'Openings'),
(7578, 'Opens in Bottom frame'),
(7579, 'Opens in Top frame'),
(7580, 'Operation Failed'),
(7581, 'Operative Note - 2009'),
(7582, 'Operator'),
(7583, 'Opthalmic'),
(7584, 'Optic Discs'),
(7585, 'Optic Nerve Analysis'),
(7586, 'Option'),
(7587, 'Option one, apply the changes to only the Current event. Option two, apply to this event and all Future occurrences or lastly, apply to All event occurrences?'),
(7588, 'Option to save method of document storage.'),
(7589, 'Option to support inventory and sales of products'),
(7590, 'Optional'),
(7591, 'Optional category name for an ID Card image that can be viewed from the patient summary page.'),
(7592, 'Optional category name for photo images that can be viewed from the patient summary page.'),
(7593, 'Optional category name of a document to link to from the patient summary page. Lets you click on a patient name to see their ID card.'),
(7594, 'Optional default range for manual entry of results'),
(7595, 'Optional default units for manual entry of results'),
(7596, 'Optional Destination Name'),
(7597, 'Optional Destination or Dicom Study Name'),
(7598, 'Optional drug name, use % as a wildcard'),
(7599, 'Optional end date'),
(7600, 'Optional end date mm/dd/yyyy'),
(7601, 'Optional immunization name or code, use % as a wildcard'),
(7602, 'Optional information about this event'),
(7603, 'Optional lot number, use % as a wildcard'),
(7604, 'Optional numeric patient ID'),
(7605, 'Optional procedure code'),
(7606, 'Optional procedure/service code'),
(7607, 'Options'),
(7608, 'OR'),
(7609, 'Or'),
(7610, 'or choose'),
(7611, 'or click and drag for faster selection.'),
(7612, 'Or create this new field ID'),
(7613, 'Or Out To'),
(7614, 'or select from inventory'),
(7615, 'or Shift-click to decrease it'),
(7616, 'Or upload ERA file:'),
(7617, 'or utilize the Impression/Plan Builder'),
(7618, 'Oral'),
(7619, 'Oral mucosa pink, throat clear'),
(7620, 'Order'),
(7621, 'Order - The order in which the item will be displayed - incrementing by 10 will allow for up to 9 values to be inserted in between if so desired at a later date'),
(7622, 'Order and Result Types'),
(7623, 'Order Catalog'),
(7624, 'Order Date'),
(7625, 'Order Descriptions'),
(7626, 'Order Documents'),
(7627, 'Order Documents and Logs'),
(7628, 'Order for'),
(7629, 'Order Form'),
(7630, 'Order From'),
(7631, 'Order HL7 Content'),
(7632, 'Order ID'),
(7633, 'Order Log'),
(7634, 'Order must be a number between 1 and 999'),
(7635, 'Order must be a number between 1 and 9999'),
(7636, 'Order Name'),
(7637, 'Order Notes'),
(7638, 'Order Priorities'),
(7639, 'Order Processor'),
(7640, 'Order Questions'),
(7641, 'Order Results'),
(7642, 'Order Status'),
(7643, 'Order Statuses'),
(7644, 'Order Successfully Sent'),
(7645, 'Order Summary'),
(7646, 'Order Test Type'),
(7647, 'Order Tracks'),
(7648, 'Order Type'),
(7649, 'Order Types'),
(7650, 'Order/Result Type'),
(7651, 'Ordered'),
(7652, 'Ordered By'),
(7653, 'Ordered Procedure'),
(7654, 'Ordering'),
(7655, 'Ordering a recognized panel of tests'),
(7656, 'Ordering Physician'),
(7657, 'Ordering Provider'),
(7658, 'Ordering Provider is required but not selected!'),
(7659, 'Ordering tests individually can be tedious and there are two ways of ordering multiple tests together'),
(7660, 'Orders'),
(7661, 'Orders and Results are setup in an hierarchical manner, there are four tiers in this hierarchy'),
(7662, 'Orders Path'),
(7663, 'Orders Path - is only required if you are submitting an electronic order to an external facility'),
(7664, 'Order{{Sequence}}'),
(7665, 'Organ injury'),
(7666, 'Organization'),
(7667, 'Organization Name'),
(7668, 'Organizational Unit Name'),
(7669, 'Organizations'),
(7670, 'Orientated x 3'),
(7671, 'Oriented TPP{{oriented to person and place}}'),
(7672, 'Origin'),
(7673, 'Origin Description'),
(7674, 'Original'),
(7675, 'Original Checksum'),
(7676, 'Original file'),
(7677, 'Original file deletion error'),
(7678, 'Oriya'),
(7679, 'Oromo'),
(7680, 'OROPHARYNX: '),
(7681, 'Ortho'),
(7682, 'Orthophoric'),
(7683, 'Orthopnea'),
(7684, 'ORTHO{{Orthopedics}}'),
(7685, 'Ortho{{orthophoric}}'),
(7686, 'OR{{as in AND/OR, ie. not an abbreviation}}'),
(7687, 'OS'),
(7688, 'Osetoarthritis'),
(7689, 'Ossetian, Ossetic'),
(7690, 'Osteopathy'),
(7691, 'OS{{left eye}}'),
(7692, 'Other'),
(7693, 'other'),
(7694, 'OTHER'),
(7695, 'Other (specify)'),
(7696, 'Other - lists items not covered in the above sections'),
(7697, 'Other - Specified'),
(7698, 'Other adult'),
(7699, 'Other Documents'),
(7700, 'Other Federal Program'),
(7701, 'Other HCFA'),
(7702, 'Other injury not elsewhere specified'),
(7703, 'Other Liability Insurance is Primary'),
(7704, 'Other Logs'),
(7705, 'other month'),
(7706, 'Other Non-Federal Programs'),
(7707, 'Other Notes'),
(7708, 'Other Pertinent Symptoms'),
(7709, 'Other Pertinent Symptoms:'),
(7710, 'Other Place of Service'),
(7711, 'Other Provider'),
(7712, 'Other pt resp'),
(7713, 'Other Registry'),
(7714, 'Other stress/Over use injury'),
(7715, 'Other Surgical'),
(7716, 'Other/Generic Abortion-Related'),
(7717, 'Other/Miscellaneous'),
(7718, 'Others'),
(7719, 'Otherwise known as Dated Reminders are short messages of up to 160 characters'),
(7720, 'otherwise you will destroy references to/from existing data.'),
(7721, 'OTP can be delivered by various methods'),
(7722, 'OTP can be generated either using time synchronization where the current time is combined with a secret key and hashed to generate the OTP or using mathematical algorithms were an initial seed (a random number) is combined with the previously used password to generate the OTP'),
(7723, 'Ottawa Ankle Rules'),
(7724, 'OU'),
(7725, 'Our Out To'),
(7726, 'OUT'),
(7727, 'Out Of Office'),
(7728, 'Out Time'),
(7729, 'Outbound Referral'),
(7730, 'Outcome'),
(7731, 'Outline Data Col'),
(7732, 'Outline Entire Row'),
(7733, 'Outlook'),
(7734, 'Outpatient Hospital'),
(7735, 'Output Type'),
(7736, 'OU{{both eyes}}'),
(7737, 'Over'),
(7738, 'Overall Status Of Discharge'),
(7739, 'OVERDUE'),
(7740, 'Overlay CMS 1500 on the Preprinted form'),
(7741, 'Override (if necessary) the appointment display limit to allow all appointments to be displayed for the last set'),
(7742, 'Override HIPAA choice'),
(7743, 'Overuse'),
(7744, 'Overview'),
(7745, 'Overweight'),
(7746, 'Overwrite HIPAA choice'),
(7747, 'Owner'),
(7748, 'Oxygen Saturation'),
(7749, 'oz'),
(7750, 'P'),
(7751, 'p.c.'),
(7752, 'p.m.'),
(7753, 'p.r.n.'),
(7754, 'Pachymetry'),
(7755, 'Pachymetry: Central Corneal Thickness'),
(7756, 'Pachy{{Pachymetry}}'),
(7757, 'Pacific Islander'),
(7758, 'Paedeatric'),
(7759, 'Page'),
(7760, 'Page not found'),
(7761, 'Page Validation'),
(7762, 'Pages'),
(7763, 'Paid'),
(7764, 'Paid amount that you will allocate'),
(7765, 'Paid Amt'),
(7766, 'Paid Via'),
(7767, 'Pain'),
(7768, 'Pali'),
(7769, 'Palliative care physician'),
(7770, 'Palpitation'),
(7771, 'PAM{{Potential Acuity Meter}}'),
(7772, 'Pan'),
(7773, 'Panama'),
(7774, 'Panjabi, Punjabi'),
(7775, 'Pap Smear'),
(7776, 'Paper'),
(7777, 'Paper Size'),
(7778, 'Paralysis'),
(7779, 'Parent'),
(7780, 'parent in-law'),
(7781, 'Parent Recall'),
(7782, 'Parent Written Record'),
(7783, 'Parental decision'),
(7784, 'Parse HL7'),
(7785, 'Parse Token'),
(7786, 'Partially Administered'),
(7787, 'Participant\'s name'),
(7788, 'participants'),
(7789, 'Participants '),
(7790, 'Partner'),
(7791, 'Partner Name'),
(7792, 'Partner Name issued for NewCrop eRx service.'),
(7793, 'Partner not configured'),
(7794, 'Pashto, Pushto'),
(7795, 'Pass Phrase'),
(7796, 'Pass phrase to decrypt document'),
(7797, 'Passed Patients'),
(7798, 'Passive Alert'),
(7799, 'Passive Alert - that will be displayed in the Clinical Reminders widget section'),
(7800, 'Passive Alert Rules'),
(7801, 'password'),
(7802, 'Password'),
(7803, 'Password Change'),
(7804, 'Password change successful'),
(7805, 'Password change successful.'),
(7806, 'Password does not meet minimum requirements and should contain at least each of the following items: A number, a lowercase letter, an uppercase letter, a special character (not a letter or number).'),
(7807, 'Password does not meet minimum requirements and should contain at least three of the four following items: A number, a lowercase letter, an uppercase letter, a special character (Not a leter or number).'),
(7808, 'Password Expiration'),
(7809, 'Password Expiration Grace Period'),
(7810, 'Password for Phone Gateway.'),
(7811, 'Password for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(7812, 'Password for SMS Gateway'),
(7813, 'Password for SMS Gateway.'),
(7814, 'Password for the above user'),
(7815, 'Password security has recently been upgraded.'),
(7816, 'Password to connect to CouchDB'),
(7817, 'Password too long. Maximum characters allowed'),
(7818, 'Password too short. Minimum 8 characters required.'),
(7819, 'Password too short. Minimum characters required'),
(7820, 'Password update error!'),
(7821, 'Password:'),
(7822, 'Passwords do not match'),
(7823, 'Passwords do not match.'),
(7824, 'Passwords Don\'t match!'),
(7825, 'Passwords must be 8-12 characters long and include one capital letter, one lower case letter and one special character'),
(7826, 'Past Appoinments'),
(7827, 'Past Appointment Display Widget'),
(7828, 'Past Appointments'),
(7829, 'Past Appointments - will show all past appointments'),
(7830, 'Past Date'),
(7831, 'Past due'),
(7832, 'Past Due'),
(7833, 'Past Due Interval (Clinical Reminders)'),
(7834, 'Past Due Interval (Patient Reminders)'),
(7835, 'Past Encounter List'),
(7836, 'Past Encounters'),
(7837, 'Past Encounters and Documents'),
(7838, 'Past Encounters for'),
(7839, 'Past Medical History'),
(7840, 'Past meetings'),
(7841, 'Past Ocular History'),
(7842, 'Past Ocular Surgery'),
(7843, 'Past Surgical History'),
(7844, 'Past Therapy Group Encounters'),
(7845, 'Past Year'),
(7846, 'Paste HL7 Data'),
(7847, 'Paste the data to import into the text area below:'),
(7848, 'Pat'),
(7849, 'Pat Ledger'),
(7850, 'Patch'),
(7851, 'Patch was also installed, updating version patch indicator'),
(7852, 'PaternalAunt'),
(7853, 'PaternalCousin'),
(7854, 'PaternalGrandparent'),
(7855, 'PaternalGreatgrandparent'),
(7856, 'PaternalUncle'),
(7857, 'Path for Event Log Backup'),
(7858, 'Path to CA Certificate File'),
(7859, 'Path to CA Key File'),
(7860, 'Path to MySQL Binaries'),
(7861, 'Path to Perl Binaries'),
(7862, 'Path to Temporary Files'),
(7863, 'Patient'),
(7864, 'PATIENT'),
(7865, 'patient'),
(7866, 'Patient Access'),
(7867, 'Patient Address'),
(7868, 'Patient Address is missing'),
(7869, 'Patient Adj'),
(7870, 'Patient Adjustment'),
(7871, 'Patient allergies'),
(7872, 'Patient Allergies'),
(7873, 'Patient already in form'),
(7874, 'Patient and Insured Informatiom - Boxes 1 - 13 and Physician or Supplier Information - Boxes 14 - 33'),
(7875, 'Patient Appointment'),
(7876, 'Patient Assigned Templates'),
(7877, 'Patient Balance'),
(7878, 'Patient Balance Due'),
(7879, 'Patient Billing Note'),
(7880, 'Patient birthday alert requires turning off'),
(7881, 'Patient Characteristics'),
(7882, 'Patient chart ID'),
(7883, 'Patient Chat'),
(7884, 'Patient Checkout'),
(7885, 'Patient Checkout for '),
(7886, 'Patient City'),
(7887, 'Patient City is missing'),
(7888, 'Patient city missing'),
(7889, 'Patient Communication sent'),
(7890, 'Patient Comunication Sent'),
(7891, 'Patient Country'),
(7892, 'Patient Country is missing. Also you have not set default Patient Country in Global Settings'),
(7893, 'Patient Coverage'),
(7894, 'Patient Credentials Reset'),
(7895, 'Patient Credit'),
(7896, 'Patient Dashboard'),
(7897, 'Patient Data'),
(7898, 'Patient Date Of Birth'),
(7899, 'Patient Date Of Birth is missing'),
(7900, 'Patient decision'),
(7901, 'Patient Default'),
(7902, 'Patient Demographics'),
(7903, 'Patient details'),
(7904, 'Patient Details'),
(7905, 'Patient DOB'),
(7906, 'Patient DOB missing'),
(7907, 'Patient Document'),
(7908, 'Patient Document Template Forms'),
(7909, 'Patient Document Template Maintenance'),
(7910, 'Patient Document Template Upload'),
(7911, 'Patient Document Templates'),
(7912, 'Patient Documents'),
(7913, 'Patient Education'),
(7914, 'Patient Education Materials'),
(7915, 'Patient Encounter'),
(7916, 'Patient Encounter Form'),
(7917, 'Patient Encounters'),
(7918, 'Patient Finder'),
(7919, 'Patient Finder Screen'),
(7920, 'Patient First name'),
(7921, 'Patient First Name'),
(7922, 'Patient First name is missing'),
(7923, 'Patient Flow Board'),
(7924, 'Patient Flow Board Report'),
(7925, 'Patient Flow Board Rooms'),
(7926, 'Patient Flow Board Timer Interval'),
(7927, 'Patient Gender'),
(7928, 'Patient Gender is missing'),
(7929, 'Patient Groups'),
(7930, 'Patient has not authorized the Patient Portal.'),
(7931, 'Patient Height Vital is required under age 19'),
(7932, 'Patient History'),
(7933, 'Patient History / Lifestyle'),
(7934, 'Patient Home phone'),
(7935, 'Patient ID'),
(7936, 'Patient Id'),
(7937, 'Patient ID card'),
(7938, 'Patient ID Category Name'),
(7939, 'Patient identifying information'),
(7940, 'Patient Images'),
(7941, 'Patient Immunization'),
(7942, 'Patient Information'),
(7943, 'Patient Information (patients)'),
(7944, 'Patient Instructions'),
(7945, 'Patient Insurance Distribution'),
(7946, 'Patient Insurance Distribution Report'),
(7947, 'Patient insurance/financial information'),
(7948, 'Patient is required to enter their contact e-mail if present in Demographics Contact.'),
(7949, 'Patient Issues'),
(7950, 'Patient Label Type'),
(7951, 'Patient Last name'),
(7952, 'Patient Last Name'),
(7953, 'Patient Last name is missing'),
(7954, 'Patient Ledger'),
(7955, 'Patient Ledger by Date'),
(7956, 'Patient Ledger Help'),
(7957, 'Patient Level Billing Note (Collections)'),
(7958, 'Patient List'),
(7959, 'Patient List Columns'),
(7960, 'Patient List Creation'),
(7961, 'Patient List New Window'),
(7962, 'Patient List Page Size'),
(7963, 'Patient Login'),
(7964, 'Patient Lookup Errors'),
(7965, 'Patient Mail'),
(7966, 'Patient may change their logon from portal login dialog.'),
(7967, 'Patient Medical Problems'),
(7968, 'Patient Medications'),
(7969, 'Patient Menu Role'),
(7970, 'Patient Message'),
(7971, 'Patient Messages'),
(7972, 'Patient Messaging'),
(7973, 'Patient must be set manually'),
(7974, 'Patient Name'),
(7975, 'Patient name'),
(7976, 'Patient Name & Address'),
(7977, 'Patient Name and ID'),
(7978, 'Patient Name and Invoice'),
(7979, 'Patient Name Display'),
(7980, 'Patient Name Required'),
(7981, 'Patient Name/ID'),
(7982, 'Patient Note'),
(7983, 'Patient Note Types'),
(7984, 'Patient Notes'),
(7985, 'Patient Notes (write,addonly optional)'),
(7986, 'Patient Notes (write,addonly optional) (notes)'),
(7987, 'Patient Number'),
(7988, 'Patient Payment'),
(7989, 'Patient Payments'),
(7990, 'Patient Photo Category Name'),
(7991, 'PATIENT PORTAL'),
(7992, 'Patient Portal'),
(7993, 'Patient Portal (patientportal)'),
(7994, 'Patient Portal (portal)'),
(7995, 'Patient Portal connectivity issue'),
(7996, 'Patient Portal Documents'),
(7997, 'Patient Portal is turned off'),
(7998, 'Patient Portal Login'),
(7999, 'Patient Portal Secure'),
(8000, 'Patient Portal Site Address'),
(8001, 'Patient Portal Web Address'),
(8002, 'Patient previous names history. Ensure to add the date the name was last used if known.'),
(8003, 'Patient Printed Report'),
(8004, 'Patient Recalls'),
(8005, 'Patient Record Report'),
(8006, 'Patient Record Request'),
(8007, 'Patient Records Request'),
(8008, 'Patient Religion'),
(8009, 'Patient Reminder'),
(8010, 'Patient Reminder - that is used to communicate relevant information pertaining to that particular Clinical Decision Rule and is shown in the Patient Reminders widget as Well as under Administration > Patient Reminders'),
(8011, 'Patient Reminder Batch Job'),
(8012, 'Patient Reminder Creation Processing Priority'),
(8013, 'Patient Reminder Rules'),
(8014, 'Patient Reminder Sender Email'),
(8015, 'Patient Reminder Sender Name'),
(8016, 'Patient Reminders'),
(8017, 'Patient Reminders (write,addonly optional)'),
(8018, 'Patient Reminders (write,addonly optional) (reminder)'),
(8019, 'Patient Reminders - a list reminders for preventive or follow-up care according to patient preferences based on demographic data, specific conditions, and/or medication list as well as the status of the notification'),
(8020, 'Patient Report'),
(8021, 'Patient Reported Outcomes'),
(8022, 'Patient Reports'),
(8023, 'Patient Reports Help'),
(8024, 'Patient Request'),
(8025, 'Patient Requested Medical Records'),
(8026, 'Patient Resource'),
(8027, 'Patient Results'),
(8028, 'Patient Search'),
(8029, 'Patient Search Not Available'),
(8030, 'Patient search or select.'),
(8031, 'Patient Search Results Style'),
(8032, 'Patient Search/Add Screen'),
(8033, 'Patient Secure Mail'),
(8034, 'Patient Selection'),
(8035, 'Patient Setting'),
(8036, 'Patient sex missing'),
(8037, 'Patient Signature'),
(8038, 'Patient Signed'),
(8039, 'Patient Signed Date'),
(8040, 'Patient State'),
(8041, 'Patient state missing'),
(8042, 'Patient Statement Bill'),
(8043, 'Patient statements can be generated as plain text or with a modern graphical appearance.'),
(8044, 'Patient Street Address'),
(8045, 'Patient street missing'),
(8046, 'Patient Summary'),
(8047, 'Patient Surveys'),
(8048, 'Patient Template'),
(8049, 'Patient Transactions'),
(8050, 'Patient Transactions Help'),
(8051, 'Patient validation'),
(8052, 'Patient Weight Vital is required under age 19'),
(8053, 'Patient Zip'),
(8054, 'Patient Zip Code missing'),
(8055, 'Patient\'s number'),
(8056, 'patient(s) in the database that match the demographic information you have entered.'),
(8057, 'Patient/Client'),
(8058, 'Patient:'),
(8059, 'patient_id'),
(8060, 'PatientID'),
(8061, 'Patients'),
(8062, 'Patients (patients)'),
(8063, 'Patients Processed'),
(8064, 'Patients with debt'),
(8065, 'Patient’s health status'),
(8066, 'Paused status checks.'),
(8067, 'Pay'),
(8068, 'Pay attention to the \"Done with\" checkboxes.  After the insurances are marked complete then we will start asking the patient to pay the remaining balance; if you fail to mark all of the insurances complete then the remaining amount will not be collected!  Also if there is a balance that the patient should pay, then set the due date appropriately, as this will affect the language that appears on patient statements.'),
(8069, 'Pay attention to the \'Done with\' checkboxes. After the insurances are marked complete then we will start asking the patient to pay the remaining balance; if you fail to mark all of the insurances complete then the remaining amount will not be collected! Also if there is a balance that the patient should pay, then set the due date appropriately, as this will affect the language that appears on patient statements.'),
(8070, 'Pay Date'),
(8071, 'Pay Date:'),
(8072, 'Pay Invoice'),
(8073, 'Pay Now'),
(8074, 'Pay Previous Balance'),
(8075, 'Pay Status'),
(8076, 'Payee Name'),
(8077, 'Payer'),
(8078, 'Payer ID'),
(8079, 'Payer Id For Eligibility'),
(8080, 'Payer ID For Encounter Claims'),
(8081, 'Payer Name'),
(8082, 'Payer Type'),
(8083, 'Paying'),
(8084, 'Paying Amount'),
(8085, 'Paying Entity'),
(8086, 'Payment'),
(8087, 'payment'),
(8088, 'Payment Adjustment Code'),
(8089, 'Payment against'),
(8090, 'Payment Amount'),
(8091, 'Payment Amount must be Numeric'),
(8092, 'Payment Category'),
(8093, 'Payment date'),
(8094, 'Payment Date'),
(8095, 'payment entered on'),
(8096, 'Payment From'),
(8097, 'Payment Gateways'),
(8098, 'Payment Information'),
(8099, 'Payment Ins'),
(8100, 'Payment List'),
(8101, 'Payment Method'),
(8102, 'Payment note'),
(8103, 'Payment Processing'),
(8104, 'Payment Sort By'),
(8105, 'Payment Status'),
(8106, 'Payment successfully sent for authorization. You will be notified when payment is posted. Until payment is accepted and you are notified, you may resubmit this payment at anytime with new amounts or different credit card. Thank you'),
(8107, 'Payment successfully sent for review and posting to your account.'),
(8108, 'Payment Tracking Id'),
(8109, 'Payment Type'),
(8110, 'Payment Validated: Save?'),
(8111, 'Payment value for code'),
(8112, 'Payment value for code '),
(8113, 'Payment was successfully authorized and charged. Thank You.'),
(8114, 'Payment was successfully authorized and your card is charged.'),
(8115, 'Payments'),
(8116, 'Payor'),
(8117, 'Payor ID'),
(8118, 'Payor/Carrier Code'),
(8119, 'PCP'),
(8120, 'Pct (%) of rows'),
(8121, 'PD-D{{abbreviation for Binocular Pupillary Diameter - Distance}}'),
(8122, 'PD-N{{abbreviation for Binocular Pupillary Diameter - Near}}'),
(8123, 'PDF'),
(8124, 'PDF buttons will save, mark claim reviewed and download claim'),
(8125, 'PDF Document'),
(8126, 'PDF Document Parse Error and not included. Check if included in archive.'),
(8127, 'PDF Download Selected'),
(8128, 'PDF Download Selected Statements'),
(8129, 'PDF Language'),
(8130, 'Pdf With Form'),
(8131, 'Pdf Without Form'),
(8132, 'PD{{Inter-pupillary distance}}'),
(8133, 'PD{{pupillary distance}}'),
(8134, 'Pediatric BMI Percentile'),
(8135, 'Pediatric Head Circumference Percentile'),
(8136, 'Pediatric Height Weight Percentile'),
(8137, 'Pelvis and buttock'),
(8138, 'Pemphigus'),
(8139, 'Pencil'),
(8140, 'pend'),
(8141, 'Pending'),
(8142, 'Pending Action'),
(8143, 'Pending Approval'),
(8144, 'Pending Auth since'),
(8145, 'Pending Documents'),
(8146, 'Pending F/U'),
(8147, 'Pending followup'),
(8148, 'Pending Followup from Results'),
(8149, 'Pending investigation'),
(8150, 'Pending Orders'),
(8151, 'Pending Res'),
(8152, 'Pending Review'),
(8153, 'Pending Rx Count'),
(8154, 'Pending since'),
(8155, 'Penicillin Allergy'),
(8156, 'Pennington Firm OpenEMR  v'),
(8157, 'Peptic Ulcer Disease'),
(8158, 'Per Encounter'),
(8159, 'per min'),
(8160, 'Per Nostril'),
(8161, 'per nostril'),
(8162, 'Per Oris'),
(8163, 'per oris'),
(8164, 'Per Rectum'),
(8165, 'per rectum'),
(8166, 'Percent'),
(8167, 'Percentage'),
(8168, 'Percentage of Patients to Drug Test'),
(8169, 'Percentage of Patients to select for Random Drug Testing.'),
(8170, 'Percentile'),
(8171, 'Perforated Right:'),
(8172, 'Perform Search'),
(8173, 'Perform this action'),
(8174, 'Performance Percentage'),
(8175, 'performed'),
(8176, 'Performer'),
(8177, 'Performing Laboratory Facility'),
(8178, 'Performing organization'),
(8179, 'Period'),
(8180, 'Period in days where a user may login with an expired password.'),
(8181, 'Perioperative Care'),
(8182, 'Periph'),
(8183, 'Peripheral'),
(8184, 'Periph{{peripheral retina}}'),
(8185, 'Periph{{periphery}}'),
(8186, 'Permit unsalted passwords'),
(8187, 'Persian'),
(8188, 'Persian (Farsi)'),
(8189, 'Persist Login'),
(8190, 'Person'),
(8191, 'Personalize'),
(8192, 'Persons needing a recall, no appt scheduled yet'),
(8193, 'Persons needing a recall, no appt scheduled yet.'),
(8194, 'PG'),
(8195, 'Pharm'),
(8196, 'Pharm Com Count'),
(8197, 'Pharmacies'),
(8198, 'Pharmacies Imported'),
(8199, 'Pharmacy'),
(8200, 'Pharmacy Dispensary'),
(8201, 'Pharmacy Dispensary (drugs)'),
(8202, 'Pharmacy Id'),
(8203, 'Pharmacy Import / Update'),
(8204, 'Pharmacy Import not authorized'),
(8205, 'Pharmacy missing NCPDP ID or less than 7 digits'),
(8206, 'Pharmacy missing NPI  or less than 10 digits'),
(8207, 'Pharmacy not assigned to the patient'),
(8208, 'Pheumothorax'),
(8209, 'phiMail Allow CCD Send'),
(8210, 'phiMail Allow CCR Send'),
(8211, 'phiMail Message Check Interval (minutes)'),
(8212, 'phiMail notification user'),
(8213, 'phiMail Password'),
(8214, 'phiMail Server Address'),
(8215, 'phiMail Username'),
(8216, 'PHIN Questions'),
(8217, 'Phone'),
(8218, 'Phone Biz'),
(8219, 'Phone call list'),
(8220, 'Phone Call List'),
(8221, 'Phone Call List report'),
(8222, 'Phone call made by'),
(8223, 'Phone Cell'),
(8224, 'Phone Contact'),
(8225, 'Phone Gateway Password'),
(8226, 'Phone Gateway URL'),
(8227, 'Phone Gateway Username'),
(8228, 'Phone Home'),
(8229, 'Phone Notification Hour'),
(8230, 'Phone number'),
(8231, 'Phone Number'),
(8232, 'Phone number for billing inquiries'),
(8233, 'Phone Number for Vendor Support that Appears on the About Page.'),
(8234, 'Phone(W)'),
(8235, 'Photophobia'),
(8236, 'Photos'),
(8237, 'PHP compressed'),
(8238, 'PHP CURL module should be enabled in your server.'),
(8239, 'PHP Default'),
(8240, 'PHP extracted'),
(8241, 'php-GACL access controls are turned off'),
(8242, 'PHP-gacl is not installed'),
(8243, 'Physical Exam'),
(8244, 'Physician'),
(8245, 'Physician Request'),
(8246, 'Physician Signature'),
(8247, 'Physician Type'),
(8248, 'Physician\'s UPIN'),
(8249, 'Physicians'),
(8250, 'PH{{pinhole acuity}}'),
(8251, 'PH{{Pinhole Vision}}'),
(8252, 'PH{{Pinhole}}'),
(8253, 'pick'),
(8254, 'Pick'),
(8255, 'Pick a CSS theme.'),
(8256, 'Pick a general theme (need to logout/login after change this setting).'),
(8257, 'Pick a general theme (need to logout/login after changing this setting).'),
(8258, 'PID'),
(8259, 'Pid'),
(8260, 'PID (Pelvic Inflammatory Disease)'),
(8261, 'Pill Size'),
(8262, 'Pills'),
(8263, 'Pinhole Vision'),
(8264, 'Place of Employment-Worksite'),
(8265, 'Place the database zip file in the following directory if want the option to install'),
(8266, 'Place the downloaded ICD 10 database zip files into the following directory'),
(8267, 'Place the downloaded ICD 9 database zip file into the following directory'),
(8268, 'Place the downloaded RxNorm database zip file into the following directory'),
(8269, 'Place the downloaded Snomed database zip file into the following directory'),
(8270, 'Place the downloaded VALUESET database zip file into the following directory'),
(8271, 'Place your logo in sites/default/images and type the filename including gif extension here.'),
(8272, 'Placeholder'),
(8273, 'Placeholder (Maintains empty ACLs)'),
(8274, 'Placeholder (Maintains empty ACLs) (filler)'),
(8275, 'Placeholder (placeholder)'),
(8276, 'Plain Text'),
(8277, 'Plan'),
(8278, 'Plan Added Successfully'),
(8279, 'Plan Already in list_options'),
(8280, 'Plan copay if known'),
(8281, 'Plan Description'),
(8282, 'Plan Name'),
(8283, 'Plan Name Already Exists'),
(8284, 'Plan Name Already Taken'),
(8285, 'Plan Name Missing'),
(8286, 'Plan of Care'),
(8287, 'Plan of Care Type'),
(8288, 'Plan Set'),
(8289, 'Plan Status Changed'),
(8290, 'Plan Status Failed to Change'),
(8291, 'Plan Type'),
(8292, 'Plan Updated Successfully'),
(8293, 'Plan:'),
(8294, 'Planned Activity'),
(8295, 'Planned Date'),
(8296, 'Plans'),
(8297, 'Plans Configuration'),
(8298, 'Player'),
(8299, 'Playing Position'),
(8300, 'Please answer all of the questions'),
(8301, 'Please call if any of the above information is incorrect'),
(8302, 'Please call if any of the above information is incorrect.'),
(8303, 'Please call or message if any of the above information is incorrect.'),
(8304, 'Please call our office to schedule'),
(8305, 'Please change your password.'),
(8306, 'Please Choose a file'),
(8307, 'Please choose a patient'),
(8308, 'Please choose a valid selection from the list.'),
(8309, 'Please choose a valid selection.'),
(8310, 'Please choose a value for'),
(8311, 'Please choose date range criteria above, and click Refresh to view results.'),
(8312, 'Please choose the proper formatted EDI-271 file'),
(8313, 'Please Click download button to download the De Identified data'),
(8314, 'Please Click download button to download the Re Identified data'),
(8315, 'Please click on Openings to select a time.'),
(8316, 'Please close this window.'),
(8317, 'Please compare the new name'),
(8318, 'Please Confirm'),
(8319, 'Please consider sending in a donation to'),
(8320, 'Please contact your provider.'),
(8321, 'Please contact your providers office with the following account information'),
(8322, 'Please contact your systems administrator, the following component(s) are required but are missing.'),
(8323, 'Please correct the value(s) before proceeding!'),
(8324, 'Please create the following directory before proceeding'),
(8325, 'Please delete characters'),
(8326, 'Please do not accept this prescription unless it was received via facimile.'),
(8327, 'Please do not accept this prescription unless it was received via facsimile.'),
(8328, 'Please do NOT use your browsers stop or reload button while this page is running unless more than 10 minutes have elapsed, this will not cause the process to  stop on the server and will consume uneccesary resources.'),
(8329, 'PLEASE ENABLE CURL EXTENSION'),
(8330, 'PLEASE ENABLE OPENSSL EXTENSION'),
(8331, 'PLEASE ENABLE SOAP EXTENSION'),
(8332, 'PLEASE ENABLE XML EXTENSION'),
(8333, 'Please ensure that there is only one image file - jpeg, png or bmp in the Patient Photograph folder'),
(8334, 'Please enter a date for Last Reviewed.'),
(8335, 'Please enter a date.'),
(8336, 'Please enter a dollar amount using only numbers and a decimal point.'),
(8337, 'Please enter a due date'),
(8338, 'Please enter a enter valid range'),
(8339, 'Please enter a message'),
(8340, 'Please enter a monetary amount using only numbers and a decimal point.'),
(8341, 'Please enter a name for this key.'),
(8342, 'Please Enter a New Password'),
(8343, 'Please enter a payment amount'),
(8344, 'Please enter a title!'),
(8345, 'Please enter a username of 12 to 80 characters. Recommended to include symbols and numbers but not required.'),
(8346, 'Please enter a valid Direct Address above.'),
(8347, 'Please enter at least the item\'s name'),
(8348, 'Please enter at least the track\'s name'),
(8349, 'Please enter card comfirmation authorization'),
(8350, 'Please enter correct Re Identification code'),
(8351, 'Please Enter End Date greater than Begin Date!'),
(8352, 'Please enter more characters'),
(8353, 'Please Enter New Credentials'),
(8354, 'Please enter new search string'),
(8355, 'Please enter the correct Re Identification code'),
(8356, 'Please enter the password'),
(8357, 'Please fill in credit information and send for review.'),
(8358, 'Please fill out facility city properly'),
(8359, 'Please fill out facility fax properly'),
(8360, 'Please fill out facility name properly'),
(8361, 'Please fill out facility phone properly'),
(8362, 'Please fill out facility postal code properly'),
(8363, 'Please fill out facility state properly'),
(8364, 'Please fill out facility street properly'),
(8365, 'Please Fill the Check Number'),
(8366, 'Please Fill the Check or Reference Number'),
(8367, 'Please Fill the Check/Ref Number'),
(8368, 'Please Fill the Date'),
(8369, 'Please Fill the Payment Amount'),
(8370, 'Please Fill the Payment Category'),
(8371, 'Please Fill the Payment From'),
(8372, 'Please Fill the Post To Date'),
(8373, 'Please fill them in before continuing.'),
(8374, 'Please follow up.'),
(8375, 'Please give this key a name'),
(8376, 'Please ignore this email if you did not make this request'),
(8377, 'Please ignore this email if you did not make this request.'),
(8378, 'Please indicate visit reason'),
(8379, 'Please input search criteria above, and click Submit to start report.'),
(8380, 'Please input search criteria above, and click Submit to view results.'),
(8381, 'Please input search criteria above, and click Submit to view results. (Results will be displayed in a pop up window)'),
(8382, 'Please login again.'),
(8383, 'Please note that this can take a very long time, up to several minutes, your web browser may not appear very active during this time but generating a bill is a  complicated process and your web browser is merely waiting for more information.'),
(8384, 'Please note, this message was received empty and is not an error.'),
(8385, 'Please Note: constants are case sensitive and any string is allowed.'),
(8386, 'Please only use alphabetic characters'),
(8387, 'Please only use alphabetic characters with no spaces'),
(8388, 'Please pay this amount'),
(8389, 'Please place your install files in following directory'),
(8390, 'Please provide a valid e-mail address to proceed'),
(8391, 'Please provide a valid email address'),
(8392, 'Please refer to'),
(8393, 'Please reset the password.'),
(8394, 'Please resolve errors and resubmit order.'),
(8395, 'Please restart the apache server before playing with de-identification'),
(8396, 'Please return this bottom part with your payment'),
(8397, 'Please see forum and wiki'),
(8398, 'Please see forum or wiki'),
(8399, 'Please see http://www.open-emr.org/wiki/index.php/LBV_Forms for more on this topic'),
(8400, 'Please see the attached PDF.'),
(8401, 'Please Select'),
(8402, 'Please select a default provider.'),
(8403, 'Please select a format'),
(8404, 'Please select a language'),
(8405, 'Please Select a Patient.'),
(8406, 'Please select a Primary Business Entity facility with \'Tax ID\' as your facility Tax ID. If you are an individual practitioner, use your tax id. This is used for identifying you in the NewCrop system.'),
(8407, 'Please select a Primary Business Entity facility with \'Tax ID\' as your facility Tax ID. If you are an individual practitioner, use your tax id. This is used for identifying you in the NewCrop system.'),
(8408, 'Please select a procedure provider'),
(8409, 'Please Select A Recipient'),
(8410, 'Please Select a Recipient for Message.'),
(8411, 'Please select a start date and end date'),
(8412, 'Please select a valid recipient'),
(8413, 'Please Select an Active Group'),
(8414, 'Please select an adjustment reason for code'),
(8415, 'Please select an adjustment reason for code '),
(8416, 'Please select an answer'),
(8417, 'Please select an event'),
(8418, 'Please select an item that has more data'),
(8419, 'Please select any Search Option.'),
(8420, 'Please select at least one criteria to download'),
(8421, 'Please select at least one patient.'),
(8422, 'Please select at least one prescription!'),
(8423, 'Please select encounter'),
(8424, 'Please select From date'),
(8425, 'Please select image procedure'),
(8426, 'Please select message(s) to delete'),
(8427, 'Please select procedure'),
(8428, 'Please select the desired pages to copy or forward:'),
(8429, 'Please Select the Payment Method'),
(8430, 'Please select the prior release you are converting from'),
(8431, 'Please select To date'),
(8432, 'Please Select Type Of Payment.'),
(8433, 'Please select visit category'),
(8434, 'Please select X12 partner, required to create the 270 batch'),
(8435, 'Please set'),
(8436, 'Please set de_identification_config variable back to zero'),
(8437, 'Please set pharmacy in patient\'s chart!'),
(8438, 'Please Specify at least One Direct Address'),
(8439, 'Please specify Void Notes.'),
(8440, 'Please specify Void Reason.'),
(8441, 'Please start new De Identification process'),
(8442, 'Please supply a heading'),
(8443, 'Please take action to prevent being logged out!'),
(8444, 'Please try again or contact the providers office for further assistance.'),
(8445, 'Please upgrade OpenEMR Database to include De Identification procedures, function, tables'),
(8446, 'Please use valid NPI'),
(8447, 'Please view De Identification error log table for more details'),
(8448, 'Please visit De Identification screen after some time'),
(8449, 'Please visit Re Identification screen after some time'),
(8450, 'Please visit the screen after some time'),
(8451, 'Please wait'),
(8452, 'Please wait...'),
(8453, 'Plot item'),
(8454, 'Plot selected Items'),
(8455, 'Plural'),
(8456, 'plus 1 year'),
(8457, 'plus 2 years'),
(8458, 'plus 3 years'),
(8459, 'PM'),
(8460, 'PM Program'),
(8461, 'PMH'),
(8462, 'PMH Dx'),
(8463, 'PMH{{Past Medical History}}'),
(8464, 'PMSFH Panel'),
(8465, 'PMSFH{{Abbreviation for Past medical Surgical Family and Social History}}'),
(8466, 'Pmt Method'),
(8467, 'PND'),
(8468, 'Pneumococcal Conjugate 1'),
(8469, 'Pneumococcal Conjugate 2'),
(8470, 'Pneumococcal Conjugate 3'),
(8471, 'Pneumococcal Conjugate 4'),
(8472, 'Pneumococcal Vaccine'),
(8473, 'Pneumonia Vaccination'),
(8474, 'Pneumonia Vaccination Status for Older Adults'),
(8475, 'Pneumonia Vaccination Status for Older Adults (CQM)'),
(8476, 'Podiatric'),
(8477, 'Podiatry'),
(8478, 'POH{{Past Ocular History}}'),
(8479, 'Point of Service (POS)'),
(8480, 'Point to a custom user manual. Leave blank for the default, auto-generated URL for specific version of application'),
(8481, 'Policy'),
(8482, 'Policy Begin Date'),
(8483, 'Policy effective date'),
(8484, 'Policy No'),
(8485, 'Policy Number'),
(8486, 'Polish'),
(8487, 'Polydypsia'),
(8488, 'Polygon'),
(8489, 'Polyps'),
(8490, 'Polyuria'),
(8491, 'Poor Appetite'),
(8492, 'Poor Circulation'),
(8493, 'Poor Hearing'),
(8494, 'Pop Out'),
(8495, 'Pop Out Full Screen.'),
(8496, 'Pop ups need to be enabled to see these reports'),
(8497, 'Populate Fee Sheet'),
(8498, 'Populate the year view with events?'),
(8499, 'Popups'),
(8500, 'Port'),
(8501, 'Portal'),
(8502, 'Portal Account Name'),
(8503, 'Portal Activity'),
(8504, 'Portal Alerts'),
(8505, 'Portal Audits'),
(8506, 'Portal Chats'),
(8507, 'Portal Credential Information'),
(8508, 'Portal Dashboard'),
(8509, 'Portal Document Review'),
(8510, 'Portal ID'),
(8511, 'Portal ID does not match request from portal!'),
(8512, 'Portal Idle Session Timeout Seconds'),
(8513, 'Portal Mail'),
(8514, 'Portal Only'),
(8515, 'Portal password is missing'),
(8516, 'Portal Payments'),
(8517, 'Portal Requests'),
(8518, 'Portal Uses Server Base Path (internal)'),
(8519, 'Portrait'),
(8520, 'Portuguese'),
(8521, 'Portuguese (Angolan)'),
(8522, 'Portuguese (Brazilian)'),
(8523, 'Portuguese (European)'),
(8524, 'POS Code'),
(8525, 'POS Payment'),
(8526, 'POS Payments'),
(8527, 'POS Printer'),
(8528, 'Pos/Abn'),
(8529, 'Position'),
(8530, 'Position of Gaze'),
(8531, 'Positive'),
(8532, 'Positives'),
(8533, 'Possible'),
(8534, 'Post Date'),
(8535, 'Post For'),
(8536, 'Post Item'),
(8537, 'Post Nasal Drip'),
(8538, 'Post Payment'),
(8539, 'Post Payments'),
(8540, 'Post surgical'),
(8541, 'Post to accounting and mark as billed'),
(8542, 'Post To Date'),
(8543, 'Post To Date Cannot be greater than Today'),
(8544, 'Post To Date must be greater than the financial close date.'),
(8545, 'Post To Date Must be greater than the Financial Close Date.'),
(8546, 'Post-Abortion Care'),
(8547, 'Post-Abortion Contraception'),
(8548, 'Post-Abortion Counseling'),
(8549, 'Post-Abortion Followup'),
(8550, 'Postal'),
(8551, 'Postal Code'),
(8552, 'Postal code'),
(8553, 'Postal Code and Box Number'),
(8554, 'PostCalendar'),
(8555, 'PostCalendar Administration'),
(8556, 'PostCalendar Category Settings'),
(8557, 'PostCalendar Global Settings'),
(8558, 'Postcard'),
(8559, 'POSTCARD'),
(8560, 'Postcard printed by'),
(8561, 'Postcards'),
(8562, 'Posted on'),
(8563, 'Posterior Segment'),
(8564, 'Posting'),
(8565, 'Posting Date'),
(8566, 'post{{posterior}}'),
(8567, 'Pos{{Abbreviation for Position}}'),
(8568, 'POS{{Past Ocular Surgery}}'),
(8569, 'Potential Acuity'),
(8570, 'Potential Acuity Meter'),
(8571, 'Powered by'),
(8572, 'PPE + Prev Med/Surg Hx'),
(8573, 'PQRI'),
(8574, 'PQRI Registry ID'),
(8575, 'PQRI Registry Name'),
(8576, 'Practice'),
(8577, 'Practice Default Setting'),
(8578, 'Practice Settings'),
(8579, 'Practice Settings (practice)'),
(8580, 'Practitioner'),
(8581, 'Pre Participation Assessment'),
(8582, 'Pre Pay'),
(8583, 'Pre Payment'),
(8584, 'Pre-Abortion Consultation'),
(8585, 'Pre-Abortion Counseling'),
(8586, 'Pre-payment Amount'),
(8587, 'Pref Cat'),
(8588, 'Preference'),
(8589, 'Preferences'),
(8590, 'Preferences updated successfully'),
(8591, 'Preferred Event Category'),
(8592, 'Preferred Language'),
(8593, 'Preferred Pharmacy'),
(8594, 'Preferred Provider Organization (PPO)'),
(8595, 'Preg Test'),
(8596, 'Preliminary'),
(8597, 'Preparing To Run Report'),
(8598, 'Prepay'),
(8599, 'Prepayment'),
(8600, 'Prepend Blank Row'),
(8601, 'Prescription'),
(8602, 'Prescription - lists the prescriptions of the current patient'),
(8603, 'prescription has reached its limit of'),
(8604, 'Prescription History'),
(8605, 'Prescription History import successfully completed'),
(8606, 'Prescription Label'),
(8607, 'Prescription Report'),
(8608, 'Prescription successfully removed.'),
(8609, 'Prescription Transmit Review'),
(8610, 'Prescriptions'),
(8611, 'Prescriptions (write,addonly optional)'),
(8612, 'Prescriptions (write,addonly optional) (rx)'),
(8613, 'Prescriptions and Dispensations'),
(8614, 'Prescriptions and other referrals'),
(8615, 'Prescriptions and/or referrals by specialist'),
(8616, 'Prescriptions may be created from the Fee Sheet.'),
(8617, 'Prescriptions Report'),
(8618, 'Prescriptions Review Not Authorized'),
(8619, 'Prescriptions/Referrals'),
(8620, 'Present'),
(8621, 'Present an additional PDF custom receipt after checkout.'),
(8622, 'Presenting Complaint'),
(8623, 'Presenting Issue(s)'),
(8624, 'Press Continue to proceed'),
(8625, 'Press the flashing button on the USB key within 1 minute of inserting it and click on register to register the key with OpenEMR'),
(8626, 'Press this icon to build your Impression/Plan.'),
(8627, 'Presumed Diagnosis'),
(8628, 'Presumed diagnosis by specialist'),
(8629, 'Prev'),
(8630, 'Prev Med/Surg Hx'),
(8631, 'Prev. month (hold for menu)'),
(8632, 'Prev. year (hold for menu)'),
(8633, 'Prevent Web Browser Refresh'),
(8634, 'Preventative Care'),
(8635, 'Prevention Rehab'),
(8636, 'Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention (CQM)'),
(8637, 'Preview Changes'),
(8638, 'Preview Event'),
(8639, 'Preview file'),
(8640, 'Preview not available for this document type'),
(8641, 'Preview of'),
(8642, 'Previous'),
(8643, 'Previous Balance'),
(8644, 'Previous Consultations'),
(8645, 'Previous Day'),
(8646, 'Previous Encounter Drawings'),
(8647, 'Previous History/Screening'),
(8648, 'Previous Month'),
(8649, 'Previous name history already exist. Try again or Cancel.'),
(8650, 'Previous Names'),
(8651, 'Previous Week'),
(8652, 'Price'),
(8653, 'Price can be manually set or if already set can be altered here'),
(8654, 'Price changed'),
(8655, 'Price Discounting'),
(8656, 'Price Level'),
(8657, 'Price level changed'),
(8658, 'Price Level:'),
(8659, 'Pricelevel'),
(8660, 'Prices'),
(8661, 'Primary'),
(8662, 'Primary Business Entity'),
(8663, 'Primary Business Entity tax id is used as account id for NewCrop ePrescription. Changing the facility will affect the working in NewCrop.'),
(8664, 'Primary Business Entity tax id is used as the account id for NewCrop ePrescription.'),
(8665, 'Primary Care'),
(8666, 'Primary Care Provider'),
(8667, 'Primary Diagnosis'),
(8668, 'Primary Facility City'),
(8669, 'Primary Facility Country code'),
(8670, 'Primary Facility State'),
(8671, 'Primary Facility Street Address'),
(8672, 'Primary Facility Zip Code'),
(8673, 'Primary Ins'),
(8674, 'Primary Insurance'),
(8675, 'Primary Insurance Data'),
(8676, 'Primary Insurance Provider'),
(8677, 'Primary Provider'),
(8678, 'Print'),
(8679, 'Print (HTML)'),
(8680, 'Print (PDF)'),
(8681, 'Print Amendments'),
(8682, 'Print Any Encounter'),
(8683, 'Print Blank Referral Form'),
(8684, 'Print Checkout'),
(8685, 'Print Command'),
(8686, 'Print Custom Message'),
(8687, 'Print Date'),
(8688, 'Print End of Day Report 1'),
(8689, 'Print End of Day Report 2'),
(8690, 'Print End of Day Report 3'),
(8691, 'Print Entire Listing'),
(8692, 'Print Format'),
(8693, 'Print Four Panel'),
(8694, 'Print Ledger'),
(8695, 'Print locally'),
(8696, 'Print message'),
(8697, 'Print Multiple'),
(8698, 'Print Multiple To Fax'),
(8699, 'Print name, sign and date.'),
(8700, 'Print Notes'),
(8701, 'Print Page 1'),
(8702, 'Print Page 2'),
(8703, 'Print Patient Address Label'),
(8704, 'Print Patient Billing Note'),
(8705, 'Print Receipts by Provider'),
(8706, 'Print Record'),
(8707, 'Print Record (HTML)'),
(8708, 'Print Record (PDF)'),
(8709, 'Print remotely'),
(8710, 'Print Report'),
(8711, 'Print Selected'),
(8712, 'Print Selected Statements'),
(8713, 'Print Shot Record'),
(8714, 'Print the Next Appointment on the Bottom of the Ledger'),
(8715, 'Print This Encounter'),
(8716, 'Print this form'),
(8717, 'Print this note'),
(8718, 'Print This Note'),
(8719, 'Print To'),
(8720, 'Print To Fax'),
(8721, 'Print View'),
(8722, 'printable'),
(8723, 'Printable Version'),
(8724, 'Printed'),
(8725, 'Printed on'),
(8726, 'Printer'),
(8727, 'Printing Log Option'),
(8728, 'Printing results:'),
(8729, 'Printing skipped; see test output in'),
(8730, 'Printing skipped; see test output in '),
(8731, 'Prints the CMS 1500 on the Preprinted form'),
(8732, 'Prior Auth'),
(8733, 'Prior Authorization'),
(8734, 'Prior Authorization Form'),
(8735, 'Prior Exam'),
(8736, 'Prior Eye Meds'),
(8737, 'Prior IMP/PLAN'),
(8738, 'Prior Refractions'),
(8739, 'Prior Validations Errors'),
(8740, 'Prior Visit'),
(8741, 'Prior Visits'),
(8742, 'Priority'),
(8743, 'Priority '),
(8744, 'Prism'),
(8745, 'Prism Diopters'),
(8746, 'Prison Correctional Facility'),
(8747, 'Private'),
(8748, 'Problem'),
(8749, 'Problem DX'),
(8750, 'Problem List'),
(8751, 'Problem loading.'),
(8752, 'Problems'),
(8753, 'Problems & Diagnoses'),
(8754, 'Problems or Code'),
(8755, 'Problems/Issues'),
(8756, 'Proc Bat'),
(8757, 'Proc Cat'),
(8758, 'Proc Load'),
(8759, 'Proc Pending Rev'),
(8760, 'Proc Prov'),
(8761, 'Proc Res'),
(8762, 'Procedure'),
(8763, 'Procedure Body Sites'),
(8764, 'Procedure Body Sites - Arm, Buttock and Other - used for immunization - modify as needed'),
(8765, 'Procedure Boolean Results'),
(8766, 'Procedure Boolean Results - No and Yes'),
(8767, 'Procedure Code'),
(8768, 'Procedure Codes'),
(8769, 'Procedure Lateralities'),
(8770, 'Procedure Lateralities - Left, Right and Bilateral'),
(8771, 'Procedure Name'),
(8772, 'Procedure Note - 2010'),
(8773, 'Procedure Order'),
(8774, 'Procedure order'),
(8775, 'Procedure Order Details'),
(8776, 'Procedure Order for'),
(8777, 'Procedure order not found'),
(8778, 'procedure order not found in database contact tech support'),
(8779, 'Procedure Orders and Reports'),
(8780, 'Procedure Picker'),
(8781, 'Procedure provider'),
(8782, 'Procedure Provider'),
(8783, 'Procedure Provider Help'),
(8784, 'Procedure Providers'),
(8785, 'Procedure Report'),
(8786, 'Procedure Report Abnormal'),
(8787, 'Procedure Report Abnormal - No, Yes, High, Low Above upper panic limit and Below lower panic limit'),
(8788, 'Procedure Report Statuses'),
(8789, 'Procedure Report Statuses - Final, Reviewed, Preliminary, Canceled, Error and Corrected'),
(8790, 'Procedure Result Abnormal'),
(8791, 'Procedure Result Statuses'),
(8792, 'Procedure Result Statuses - Final, Preliminary, Canceled, Error, Corrected and Incomplete'),
(8793, 'Procedure Results'),
(8794, 'Procedure Routes'),
(8795, 'Procedure Routes - Injection, Oral and Other'),
(8796, 'Procedure Specimen Types'),
(8797, 'Procedure Specimen Types - Blood, Saliva, Urine and Other'),
(8798, 'Procedure Statistics Report'),
(8799, 'Procedure Test'),
(8800, 'Procedure Tier'),
(8801, 'Procedure Type'),
(8802, 'Procedure Types'),
(8803, 'Procedure Types - Group, Procedure Order, Discrete Result, Recommendation, Custom Favorite Group and Custom Favorite Item. Used in the next step - Configure the lab test structure'),
(8804, 'Procedure Units'),
(8805, 'Procedure Units - various units needed to define result values - may need to add to this list depending on the tests that are included, will vary according to need'),
(8806, 'Procedure/Service'),
(8807, 'Procedures'),
(8808, 'Proceed'),
(8809, 'Proceeding to Preferences'),
(8810, 'Process'),
(8811, 'Process and Send Reminders'),
(8812, 'Process ERA File'),
(8813, 'Process New Files'),
(8814, 'Process new files for CSV records'),
(8815, 'Process Reminders'),
(8816, 'Process Results For'),
(8817, 'Process takes some time'),
(8818, 'Process UDI'),
(8819, 'Processed'),
(8820, 'Processed By'),
(8821, 'Processed Date'),
(8822, 'processed successfully'),
(8823, 'Processing'),
(8824, 'Processing and Sending Patient Reminders'),
(8825, 'Processing Details'),
(8826, 'Processing format'),
(8827, 'Processing Lab Name/Internal Lab Id/Results File Name'),
(8828, 'Processing Patient Reminders'),
(8829, 'Processing Time'),
(8830, 'Processing...'),
(8831, 'Product'),
(8832, 'Product added'),
(8833, 'Product Contraceptive Method'),
(8834, 'Product deleted'),
(8835, 'Product name is required'),
(8836, 'Product-level reorder point has been reached'),
(8837, 'Production'),
(8838, 'Products'),
(8839, 'Products but no prescription drugs and no templates'),
(8840, 'Products Provided'),
(8841, 'Prof.'),
(8842, 'Profile'),
(8843, 'Profile Demographics'),
(8844, 'Profile Edits Red = Charted Values Blue = Patient Edits'),
(8845, 'Profile Templates Successfully set to Active in portal.'),
(8846, 'Profiles'),
(8847, 'Profiles in Portal'),
(8848, 'Profiles successfully saved.'),
(8849, 'Profiles that have patient groups assigned to them are handled differently than those that do not. The latter is sent from the Scope toolbar to selected Location where the former shows an Update button to make the group profiles active for portal.'),
(8850, 'Prog.{{Progressive lenses}}'),
(8851, 'Progress'),
(8852, 'Progress Note - 2010'),
(8853, 'Progress Notes'),
(8854, 'Progressive'),
(8855, 'Properties'),
(8856, 'Proprietary hardware tokens'),
(8857, 'Proprietary hardware tokens are tamper proof and are not connected to the internet or any network'),
(8858, 'Prostate Cancer'),
(8859, 'Prostate Cancer Screening'),
(8860, 'Prostate Exam'),
(8861, 'Prostate Problems'),
(8862, 'Prostate w/o enlrgmt, nodules, tender'),
(8863, 'Protection Indicator'),
(8864, 'Protection Indicator Effective Date'),
(8865, 'Protocol'),
(8866, 'Protocol - consists of two parts - the method used to send orders and receive results and whether it is used to receive results only or is used to send orders and receive result i.e. bidirectional'),
(8867, 'Provide absolute path'),
(8868, 'Provide absolute path of file'),
(8869, 'Provide absolute path of following file in Path to CA Certificate File'),
(8870, 'Provide absolute path of following file in Path to CA Key File'),
(8871, 'Provide clinical summaries for patients for each office visit (New).'),
(8872, 'Provide clinical summaries for patients for each office visit.'),
(8873, 'Provide Password for'),
(8874, 'Provide patients with an electronic copy of their health information (including diagnostic test results, problem list, medication lists, medication allergies), upon request.'),
(8875, 'Provide patients with timely electronic access to their health information (including lab results, problem list, medication lists, medication allergies) within four business days of the information being available to the EP.'),
(8876, 'Provide Records to Patient for Visit'),
(8877, 'Provide TOTP code'),
(8878, 'Provide valid Email Address'),
(8879, 'Provided Clinical Summary?'),
(8880, 'Provided Education Resource(s)?'),
(8881, 'Provider'),
(8882, 'provider'),
(8883, 'Provider Access'),
(8884, 'Provider Dashboard'),
(8885, 'Provider email address is missing. Go to address book to add providers email address'),
(8886, 'Provider Id'),
(8887, 'Provider ID'),
(8888, 'Provider ID at Specified Facility'),
(8889, 'Provider Matching Errors'),
(8890, 'Provider Missing Add one in Choices'),
(8891, 'Provider Missing NPI or Provider not selected in choices'),
(8892, 'provider name'),
(8893, 'Provider not available, please choose another.'),
(8894, 'Provider not available, use it anyway?'),
(8895, 'Provider Number'),
(8896, 'Provider Number (Type)'),
(8897, 'Provider Password is missing'),
(8898, 'Provider Qualifier Code'),
(8899, 'Provider Relationship'),
(8900, 'Provider Type'),
(8901, 'Provider/Warehouse'),
(8902, 'Provider:'),
(8903, 'Providers'),
(8904, 'Providers NPI'),
(8905, 'Providers See Entire Calendar'),
(8906, 'PRO{{Patient Reported Outcomes}}'),
(8907, 'Prv'),
(8908, 'PSA'),
(8909, 'PSC Hold Order'),
(8910, 'Psoriasis'),
(8911, 'Psych'),
(8912, 'Psych Diagnosis'),
(8913, 'Psych Medication'),
(8914, 'Psychiatric'),
(8915, 'Psychiatric Brief Letter'),
(8916, 'Psychiatric Diagnosis'),
(8917, 'Psychiatric Examination'),
(8918, 'Psychiatric Facility-Partial Hospitalization'),
(8919, 'Psychiatric History'),
(8920, 'Psychiatric Intake'),
(8921, 'Psychiatric Medication'),
(8922, 'Psychiatric Residential Treatment Center'),
(8923, 'Psych{{psychiatric}}'),
(8924, 'PSYCH{{Psychiatry}}'),
(8925, 'Pt %'),
(8926, 'Pt Debt'),
(8927, 'Pt Notes'),
(8928, 'Pt Notes/Auth'),
(8929, 'Pt overpaid'),
(8930, 'Pt paid'),
(8931, 'Pt Paid'),
(8932, 'Pt Rec Request'),
(8933, 'Pt refund'),
(8934, 'Pt released'),
(8935, 'Pt Report'),
(8936, 'PT Student, or leave blank'),
(8937, 'PT_CITY'),
(8938, 'PT_DOB'),
(8939, 'PT_EMAIL'),
(8940, 'PT_FNAME'),
(8941, 'PT_LNAME'),
(8942, 'PT_MNAME'),
(8943, 'PT_PHONE_CELL'),
(8944, 'PT_PHONE_HOME'),
(8945, 'PT_POSTAL'),
(8946, 'PT_SSN'),
(8947, 'PT_STATE'),
(8948, 'PT_STREET'),
(8949, 'Pubid'),
(8950, 'Public'),
(8951, 'Public Agency'),
(8952, 'Public Health Clinic'),
(8953, 'Public health physician'),
(8954, 'Public Health Service (PHS) or Other Federal Agency'),
(8955, 'Public Patient Id'),
(8956, 'Publicity Code'),
(8957, 'Publicity Code Effective Date'),
(8958, 'Publish'),
(8959, 'Publish Patient to FHIR Server'),
(8960, 'Pubpid'),
(8961, 'Puerto Rican'),
(8962, 'puff'),
(8963, 'Pulmonary'),
(8964, 'PULM{{Pulmonary}}'),
(8965, 'Pulse'),
(8966, 'Punjabi'),
(8967, 'Pupils'),
(8968, 'Purchase'),
(8969, 'Purchase or Transfer'),
(8970, 'Purchase/Receipt'),
(8971, 'Purchase/Return'),
(8972, 'Purchases'),
(8973, 'px'),
(8974, 'Pyschiatry'),
(8975, 'P{{Justify Header}}'),
(8976, 'Pāli'),
(8977, 'q.3h'),
(8978, 'q.4h'),
(8979, 'q.5h'),
(8980, 'q.6h'),
(8981, 'q.8h'),
(8982, 'q.d.'),
(8983, 'q.i.d.'),
(8984, 'QHD'),
(8985, 'QOE'),
(8986, 'QOH'),
(8987, 'QOH is less than monthly usage'),
(8988, 'Qrda Lab'),
(8989, 'QTY'),
(8990, 'Qty'),
(8991, 'Quality'),
(8992, 'Quality Measures (CQM)'),
(8993, 'Quantity'),
(8994, 'Quantity cannot be negative for this transaction type'),
(8995, 'Quantity changed'),
(8996, 'Quantity for NDC'),
(8997, 'Quantity On Hand'),
(8998, 'quantity seems unusable'),
(8999, 'Quantity:'),
(9000, 'Quechua'),
(9001, 'Query Error'),
(9002, 'querystring hash was invalid'),
(9003, 'Quest Cert Debug'),
(9004, 'Quest Cert Testing'),
(9005, 'Question Mark'),
(9006, 'Queue for HCFA batch processing'),
(9007, 'Queue for HCFA batch processing and printing'),
(9008, 'Queue for UB-92 batch processing'),
(9009, 'Queue for UB-92 batch processing and printing'),
(9010, 'Queued'),
(9011, 'Queued Events Administration'),
(9012, 'Queued for'),
(9013, 'Queued for Transfer'),
(9014, 'Queued Submissions Administration'),
(9015, 'Quick Picks'),
(9016, 'Quit'),
(9017, 'Quit Alcohol'),
(9018, 'QWXGA'),
(9019, 'R'),
(9020, 'R/LG{{right/left gonioscopy}}'),
(9021, 'R/LPACH{{right/left pachymetry}}'),
(9022, 'R/LSCH1{{right/left Schirmers I (w/o anesthesia)}}'),
(9023, 'R/LSCH2{{right/left Schirmers II (w/ anesthesia)}}'),
(9024, 'R/LTBUT{{right/left Tear Break Up Time}}'),
(9025, 'RA for Patient, Encounter, or Trace'),
(9026, 'Race'),
(9027, 'Race and Ethnicity'),
(9028, 'Race/Ethnicity'),
(9029, 'RAC{{right anterior chamber}}'),
(9030, 'Radio'),
(9031, 'Radio buttons'),
(9032, 'Radio Group Master'),
(9033, 'Radio Group Member'),
(9034, 'RAD{{right adnexa}}'),
(9035, 'Random Drug Screen'),
(9036, 'Range'),
(9037, 'Rapid Workflow Option'),
(9038, 'Rashes'),
(9039, 'Rate'),
(9040, 'Rather than granting access to each ACO individually for each user the program grants access to groups that request these privileges. These groups are called Access Request Objects (ARO).'),
(9041, 'Ratio'),
(9042, 'Raw Report'),
(9043, 'RB{{right brow}}'),
(9044, 'RCMT{{right Central Macular Thickness}}'),
(9045, 'RCOM{{right comments}}'),
(9046, 'RCUP{{right cup}}'),
(9047, 'RC{{right conjunctiva}}'),
(9048, 'RD{{retinal detachment}}'),
(9049, 'RD{{right disc}}'),
(9050, 'Re Identification'),
(9051, 'Re Identification Process is completed'),
(9052, 'Re Identification Process is ongoing'),
(9053, 'Re-identification files will be saved in'),
(9054, 'Re-Injury?'),
(9055, 'Re-Open'),
(9056, 'Re-Open Visit'),
(9057, 'Re-opened'),
(9058, 'Re-opening this visit will cause a void. Payment information will need to be re-entered. Do you want to proceed?'),
(9059, 'Re-Process UDI'),
(9060, 'Reaction'),
(9061, 'Reaction - hives, nausea, shortness of breath or unassigned'),
(9062, 'Reactions'),
(9063, 'Reactivate'),
(9064, 'react{{reactivity}}'),
(9065, 'Read'),
(9066, 'Read Only'),
(9067, 'Read the help file there to understand the initial pre-configuration steps'),
(9068, 'Read these two wiki articles for customizing the Fee Sheet'),
(9069, 'Read this wiki page for more details'),
(9070, 'Read through this help file and its supporting documents before you start to configure the orders and results'),
(9071, 'Read-only from History'),
(9072, 'Real Name'),
(9073, 'Really delete'),
(9074, 'Really destroy this lot?'),
(9075, 'Reason'),
(9076, 'Reason Deceased'),
(9077, 'Reason for Death'),
(9078, 'Reason for Referral'),
(9079, 'Reason for referral'),
(9080, 'Reason for visit'),
(9081, 'Reason for Visit'),
(9082, 'Reason must be at least 10 characters!'),
(9083, 'Reason not given'),
(9084, 'Reason/Form'),
(9085, 'Reason/Plan'),
(9086, 'Recalculate'),
(9087, 'Recall'),
(9088, 'Recall Board'),
(9089, 'RECALL BOARD - Default - without MedEx Communication Service'),
(9090, 'Recall Board: Disable'),
(9091, 'Recall Campaigns'),
(9092, 'Recall only - any method'),
(9093, 'Recall only - no calls'),
(9094, 'Recall Reason'),
(9095, 'Recall Schedule'),
(9096, 'Recall to provider'),
(9097, 'Recall When'),
(9098, 'Recalls'),
(9099, 'Receipt'),
(9100, 'Receipt for Payment'),
(9101, 'Receipt Generated'),
(9102, 'Receipts by Payment Method Report'),
(9103, 'Receipts Summary'),
(9104, 'Received'),
(9105, 'Received By'),
(9106, 'Received Faxes'),
(9107, 'Received messages are processed and a new Patient Note is delivered to a specified user and appears in that user\'s Message Center'),
(9108, 'Received, not reviewed'),
(9109, 'Received, unreviewed'),
(9110, 'Receiver'),
(9111, 'Receiver ID'),
(9112, 'Receiver ID (ISA08)'),
(9113, 'Receiver ID Qualifier (ISA07)'),
(9114, 'Receiver IDs'),
(9115, 'Receiver IDs - is only required if you are submitting an electronic order to an external facility'),
(9116, 'RECEIVING A MESSAGE'),
(9117, 'Receiving Fac.'),
(9118, 'Recent three passwords are not allowed.'),
(9119, 'Recently Completed'),
(9120, 'Recipient'),
(9121, 'Recipient List Is Empty'),
(9122, 'Recipient Name'),
(9123, 'Recipient of the Disclosure'),
(9124, 'Recipient required unless status is Done'),
(9125, 'Recommend contacting the clinic if need guidance.'),
(9126, 'Recommend not leaving or refreshing or you may lose data.'),
(9127, 'Recommend setting the Path for Event Log Backup in Globals settings in the Miscellaneous section to something other than your tmp/temp directory.'),
(9128, 'Recommendation'),
(9129, 'Recommendation - Optional'),
(9130, 'Recommendation For Follow Up'),
(9131, 'Recommendations'),
(9132, 'Recommendations and treatment'),
(9133, 'Recommendations by specialist'),
(9134, 'Recommended setting is warn and prevent web browser refresh. Only use other settings if needed and use at own risk.'),
(9135, 'Recompute Score'),
(9136, 'RECORD'),
(9137, 'Record'),
(9138, 'Record already exist'),
(9139, 'Record and chart changes in vital signs ( Height / Weight / BP with in scope ).'),
(9140, 'Record and chart changes in vital signs (BP out of scope).'),
(9141, 'Record and chart changes in vital signs (Height / Weight out of scope).'),
(9142, 'Record and chart changes in vital signs (New).'),
(9143, 'Record and chart changes in vital signs (SET 1).'),
(9144, 'Record and chart changes in vital signs.'),
(9145, 'Record demographics.'),
(9146, 'Record Disclosure'),
(9147, 'Record of Fitness'),
(9148, 'Record Payment'),
(9149, 'Record Request'),
(9150, 'Record Request Date'),
(9151, 'Record smoking status for patients 13 years old or older.'),
(9152, 'Records'),
(9153, 'records found'),
(9154, 'records found.'),
(9155, 'records per page'),
(9156, 'Recreational drug use'),
(9157, 'Recreational Drugs'),
(9158, 'Rectal'),
(9159, 'Rectal Exam'),
(9160, 'rectally'),
(9161, 'Rectangle'),
(9162, 'Recurrence'),
(9163, 'Recurrent Appointment Display Widget'),
(9164, 'Recurrent Appointments'),
(9165, 'Recurrent Appointments - shows all recurring appointments'),
(9166, 'Recurring'),
(9167, 'Recurring appointment'),
(9168, 'Red Desaturation'),
(9169, 'Red Desat{{red desaturation}}'),
(9170, 'Red lines  indicate errors, or changes that were not applied; these must be processed manually. Currently denied claims and payment reversals are not handled automatically and so will appear in red.'),
(9171, 'Red Triangle indicates a required code that is missing'),
(9172, 'Redirect URI'),
(9173, 'Redirection'),
(9174, 'Redness'),
(9175, 'Redo'),
(9176, 'reduced:'),
(9177, 'Ref No'),
(9178, 'Ref Prov'),
(9179, 'Refer'),
(9180, 'Refer By'),
(9181, 'Refer Date'),
(9182, 'Refer To'),
(9183, 'Refer to Message'),
(9184, 'Reference'),
(9185, 'Reference classification (risk level)'),
(9186, 'Reference range of results'),
(9187, 'Reference Reason'),
(9188, 'Reference table and reference id must both be set'),
(9189, 'Reference this Account Id: '),
(9190, 'Reference this Account Number'),
(9191, 'Referential CDS'),
(9192, 'Referential CDS (codetype:code)'),
(9193, 'Referer'),
(9194, 'Referer name and signature'),
(9195, 'Referral'),
(9196, 'Referral By'),
(9197, 'Referral Card'),
(9198, 'Referral Date'),
(9199, 'Referral Form'),
(9200, 'REFERRAL FORM'),
(9201, 'Referral ID'),
(9202, 'Referral Provider'),
(9203, 'Referral Reason'),
(9204, 'Referral Source'),
(9205, 'Referral Source for Encounters'),
(9206, 'Referral To'),
(9207, 'Referrals'),
(9208, 'Referrals Report'),
(9209, 'Referred by'),
(9210, 'Referred By'),
(9211, 'Referred By, Outcome and Destination can be left blank'),
(9212, 'Referred To'),
(9213, 'Referred to'),
(9214, 'Referrer'),
(9215, 'Referrer Address'),
(9216, 'Referrer Diagnosis'),
(9217, 'Referrer diagnosis'),
(9218, 'Referrerid'),
(9219, 'Referring physician and practice'),
(9220, 'Referring provider'),
(9221, 'Referring Provider'),
(9222, 'ReFill'),
(9223, 'Refill'),
(9224, 'Refill Rx'),
(9225, 'Refills'),
(9226, 'refills'),
(9227, 'Reflexes normal'),
(9228, 'Refraction Comments'),
(9229, 'Refraction Method'),
(9230, 'Refractive States'),
(9231, 'Refresh'),
(9232, 'Refresh Screen'),
(9233, 'Refresh the Message Center or just reopen it'),
(9234, 'Refresh Tokens'),
(9235, 'Refreshing Reminders'),
(9236, 'Refund'),
(9237, 'Refused'),
(9238, 'Refused To State'),
(9239, 'reg_re'),
(9240, 'regarding'),
(9241, 'regarding appointment dated'),
(9242, 'Register'),
(9243, 'register'),
(9244, 'Register Time Based One Time Password Key'),
(9245, 'Register TOTP Key for'),
(9246, 'Register U2F Key for'),
(9247, 'Register Universal 2nd Factor Key'),
(9248, 'Register your installation with OEMR to receive important notifications, such as security fixes and new release announcements.'),
(9249, 'Registered'),
(9250, 'registered'),
(9251, 'Registered email'),
(9252, 'Registered id'),
(9253, 'Registered Modules'),
(9254, 'Registered username'),
(9255, 'Registration Date'),
(9256, 'Registration error'),
(9257, 'Registration failed with error'),
(9258, 'Registration Form'),
(9259, 'Rehabilitation'),
(9260, 'Rehabilitation physician'),
(9261, 'Rejected'),
(9262, 'Relapse Potential'),
(9263, 'Relate To'),
(9264, 'Related'),
(9265, 'Related Issue'),
(9266, 'Related Patient Notes'),
(9267, 'Relates To'),
(9268, 'Relation(s) / Children'),
(9269, 'Relations'),
(9270, 'Relationship'),
(9271, 'Relative ordering of this entity'),
(9272, 'Relatives'),
(9273, 'Relatives - lists the patient relatives having various medical conditions like Cancer, Diabetes, Hypertension etc'),
(9274, 'Relatives Blood Pressure'),
(9275, 'Relatives Cancer'),
(9276, 'Relatives Diabetes'),
(9277, 'Relatives Epilepsy'),
(9278, 'Relatives Heart'),
(9279, 'Relatives Mental Illness'),
(9280, 'Relatives Stroke'),
(9281, 'Relatives Suicide'),
(9282, 'Relatives Tuberculosis'),
(9283, 'Relay Health credentials are missing from this user account.'),
(9284, 'Relay Health ID'),
(9285, 'Release'),
(9286, 'Release Date'),
(9287, 'Relevant for insurance claim submission in the United States'),
(9288, 'Religion'),
(9289, 'Religious Affiliation'),
(9290, 'Religious exemption'),
(9291, 'Reload'),
(9292, 'reload names below'),
(9293, 'Relogin'),
(9294, 'Remdr'),
(9295, 'Remember grouping of tests is only for conveniently organizing the data in the Procedure Order module in openEMR, for this process to work, configuring the Procedure Orders (the tests themselves) and the Discrete Result (the place to enter and display the returned result) are critically important'),
(9296, 'Remember Me'),
(9297, 'Remember Selected Facility'),
(9298, 'Remember the dictum that Identifying codes have to be unique, you should not set up a custom grouping of a panel of tests as well have the panels setup as individual recognized panel, i.e. have CBC and Renal panel grouped as a Custom Favorite and list CBC and Renal Panel separately as individually ordered panels'),
(9299, 'Remember these Discrete Results or fruit (Tier 4)  will have to hang off the fruit bearing branch or Procedure Order namely Electrolyte Panel (Tier 3)'),
(9300, 'Reminder'),
(9301, 'Reminder Campaigns'),
(9302, 'Reminder done'),
(9303, 'Reminder intervals'),
(9304, 'Reminder Not Sent Yet'),
(9305, 'Reminder only - any method'),
(9306, 'Reminder only - no calls'),
(9307, 'Reminder Sent'),
(9308, 'Reminder Sent On'),
(9309, 'Reminder to provider'),
(9310, 'Reminder/recall - any method'),
(9311, 'Reminder/recall - no calls'),
(9312, 'Reminder/recall - to provider'),
(9313, 'Reminders'),
(9314, 'REMIT TO'),
(9315, 'Remote Host'),
(9316, 'Remote Host - is only required if you are submitting an electronic order to an external facility or just receiving results from it'),
(9317, 'Remove'),
(9318, 'Remove all rules from plan'),
(9319, 'Remove Bottom Pane'),
(9320, 'REMOVE GROUP'),
(9321, 'Remove Group'),
(9322, 'Remove Group Form'),
(9323, 'Remove multi-factor authentications for this person.'),
(9324, 'Remove Tab'),
(9325, 'Remove this Prescription from the list of RXs dispensed'),
(9326, 'Removes support for immunizations'),
(9327, 'Removes support for phpMyAdmin'),
(9328, 'Removes support for prescriptions'),
(9329, 'Removes the bottom pane by default on start up.'),
(9330, 'Removes the Chart Tracker feature'),
(9331, 'Renal Stones'),
(9332, 'Rename'),
(9333, 'Rename Group'),
(9334, 'Rendering'),
(9335, 'Rendering Provider'),
(9336, 'Rendering Provider Number'),
(9337, 'Rendering Provider Number (Type)'),
(9338, 'Reorder'),
(9339, 'Reorder At'),
(9340, 'Reorder point has been reached'),
(9341, 'Reorder point has been reached for warehouse'),
(9342, 'Reorder point, 0 if not applicable'),
(9343, 'Reorder Qty'),
(9344, 'Rep'),
(9345, 'Repeat'),
(9346, 'Repeat New Password'),
(9347, 'Repeat password'),
(9348, 'Repeating event'),
(9349, 'Repeating Info:'),
(9350, 'Repeats'),
(9351, 'REPLACE'),
(9352, 'Replace'),
(9353, 'Replace all exam findings with Default values?  Are you sure?'),
(9354, 'Replace entire code set'),
(9355, 'Replace the existing group and option values with these ones taking care to match the E/M codes'),
(9356, 'Replace the hostname and port with the values provided to you by EMR Direct'),
(9357, 'replaced'),
(9358, 'Replies'),
(9359, 'Replies from patients are displayed directly in your EHR'),
(9360, 'Replies retrieved'),
(9361, 'Reply'),
(9362, 'Reply Date'),
(9363, 'Reply From'),
(9364, 'Reply to this message'),
(9365, 'Report'),
(9366, 'report'),
(9367, 'Report - Clinical'),
(9368, 'Report - Generates and downloads the patient\'s Continuity of Care Record (CCR), Continuity of Care Document (CCD) and Patient Report'),
(9369, 'Report - Patient List Creation'),
(9370, 'Report by'),
(9371, 'Report Content'),
(9372, 'Report Date'),
(9373, 'Report End (Relinquished Care Date)'),
(9374, 'Report has been sent to the patient.'),
(9375, 'Report History/Results'),
(9376, 'Report of visit'),
(9377, 'Report Results'),
(9378, 'Report Results/History'),
(9379, 'Report Start (Assumed Care Date)'),
(9380, 'Report Status'),
(9381, 'Report Totals'),
(9382, 'Report was faxed to'),
(9383, 'Report was faxed. Click to view.'),
(9384, 'Report/ Form'),
(9385, 'Report?'),
(9386, 'Reportable'),
(9387, 'Reported'),
(9388, 'Reported Date'),
(9389, 'Reporting'),
(9390, 'Reports'),
(9391, 'Reports consisting of various portions of the patient\'s medical record can be created here'),
(9392, 'Repository always.'),
(9393, 'Request & Response'),
(9394, 'Request Content Fails Integrity Test'),
(9395, 'Request Description'),
(9396, 'Request Eligibility'),
(9397, 'Request ID is missing!'),
(9398, 'Request ignored - claims processing is already running!'),
(9399, 'Request is not same origin!'),
(9400, 'Request Message'),
(9401, 'Request New Appointment'),
(9402, 'Request Only'),
(9403, 'Request Status'),
(9404, 'Request Type'),
(9405, 'Request type not implemented'),
(9406, 'request was received from portal patient'),
(9407, 'Requested By'),
(9408, 'Requested Date'),
(9409, 'Requested Service'),
(9410, 'Requested template does not exist'),
(9411, 'Requests Sent'),
(9412, 'Require Audit'),
(9413, 'Require Strong Passwords'),
(9414, 'Require Unique Passwords'),
(9415, 'Required'),
(9416, 'required'),
(9417, 'Required Co Pay'),
(9418, 'Required Field Missing: Please choose the EDI-271 file to upload'),
(9419, 'Required field missing: Please enter the First name'),
(9420, 'Required field missing: Please enter the Last name'),
(9421, 'Required field missing: Please enter the User Name'),
(9422, 'Required fields'),
(9423, 'Required in'),
(9424, 'Required Primary Diagnosis for Order. This will be automatically added to any missing test order diagnosis.'),
(9425, 'Requirements'),
(9426, 'Requisition Number'),
(9427, 'Resending this report.'),
(9428, 'RESERVED'),
(9429, 'Reserved'),
(9430, 'Reserved for use to define Scheduled Vacation Time'),
(9431, 'Reserved to define when a provider may not have available appointments after.'),
(9432, 'Reserved to define when an event did not occur as specified.'),
(9433, 'Reserved todefine when a provider may haveavailable appointments after.'),
(9434, 'Reset'),
(9435, 'Reset button resets the edited claim to the fee sheet version. If subsequently saved, it will replace last claim version and be considered reviewed. Otherwise, claim is reset to fee sheet version.'),
(9436, 'Reset claim form to Fee Sheet Version'),
(9437, 'Reset Credentials'),
(9438, 'Reset Offsite Portal Credentials'),
(9439, 'Reset Online Portal Credentials'),
(9440, 'Reset Onsite Portal Credentials'),
(9441, 'Reset to no patient'),
(9442, 'Reset Version'),
(9443, 'Resident physician'),
(9444, 'Residential Substance Abuse Treatment Facility'),
(9445, 'Resist the temptation to start entering data in an unorganized manner'),
(9446, 'Resn'),
(9447, 'Resolve Orphan Results'),
(9448, 'Resolve Orphans'),
(9449, 'Resolved'),
(9450, 'Resource (select one)'),
(9451, 'Resources'),
(9452, 'Respiration'),
(9453, 'Respirator effort unlabored'),
(9454, 'Respiratory'),
(9455, 'Response'),
(9456, 'Response Only'),
(9457, 'Responsible Party'),
(9458, 'Responsive Vertical Menu Style for Tabs'),
(9459, 'Restore'),
(9460, 'Restore Archive'),
(9461, 'Restrict non-authorized users to the Schedule Facilities set in User admin.'),
(9462, 'Restrict Providers by Facility'),
(9463, 'Restrict Users to Facilities'),
(9464, 'Restricted Projects Reporting'),
(9465, 'Restricted Training'),
(9466, 'Result'),
(9467, 'Result Name'),
(9468, 'Result Status'),
(9469, 'Result status or abnormality is missing'),
(9470, 'Result, use % as a wildcard'),
(9471, 'Results'),
(9472, 'Results and'),
(9473, 'Results Found For Search'),
(9474, 'Results Group'),
(9475, 'Results Only'),
(9476, 'Results Path'),
(9477, 'Results Path - is only required if you are submitting an electronic order to an external facility or just receiving results from it'),
(9478, 'Results Per Lab'),
(9479, 'Results per page'),
(9480, 'Results/Details'),
(9481, 'Resuming status checks.'),
(9482, 'Retina'),
(9483, 'Retina Default Values'),
(9484, 'Retinal Exam'),
(9485, 'Retracted Right:'),
(9486, 'Return'),
(9487, 'Return above part with your payment'),
(9488, 'Return button simply returns, then refreshes billing manager'),
(9489, 'Return Home'),
(9490, 'Return to calendar'),
(9491, 'Return To Report Results'),
(9492, 'Return to this page and you will be able to complete the ICD10 installation process by clicking on the ICD10 section header'),
(9493, 'Return to this page and you will be able to complete the ICD9 installation process by clicking on the ICD9 section header'),
(9494, 'Return to this page and you will be able to complete the RxNorm installation process by clicking on the RXNORM section header'),
(9495, 'Return to this page and you will be able to complete the Snomed installation process by clicking on the SNOMED section header'),
(9496, 'Return to this page and you will be able to complete the Valueset installation process by clicking on the VALUESET section header'),
(9497, 'Return Value'),
(9498, 'Return Visit'),
(9499, 'Returned to Play'),
(9500, 'Returned: '),
(9501, 'Reuse of previous passwords not allowed!'),
(9502, 'Reuse of three previous passwords not allowed!'),
(9503, 'Rev.'),
(9504, 'Revenue'),
(9505, 'Revenue Code'),
(9506, 'Revenue Code for this item. Type for hints/search'),
(9507, 'Revenue Code for this item. Type to search'),
(9508, 'Revenue Code for this item. Type to search or double click for list'),
(9509, 'Revert'),
(9510, 'Revert Edits'),
(9511, 'Revert Error'),
(9512, 'Review'),
(9513, 'Review & Approve'),
(9514, 'Review all the parameters that are entered and only then move to the next step. This is because once you create a group (ARO) you will NOT be able of modify any of the data that you have entered in THIS section. You can only delete the entire group (ARO) and start afresh.'),
(9515, 'Review and Approve'),
(9516, 'Review Audits'),
(9517, 'Review of PMH:'),
(9518, 'Review of System'),
(9519, 'Review of Systems'),
(9520, 'Review Of Systems'),
(9521, 'Review of Systems Checks'),
(9522, 'Review Status'),
(9523, 'Review UB04'),
(9524, 'Reviewed'),
(9525, 'Reviewed Date'),
(9526, 'Revise'),
(9527, 'Revision'),
(9528, 'Revoke Token'),
(9529, 'Revoke User'),
(9530, 'Rheumatoid Arthritis'),
(9531, 'Rheumotoid Arthritis'),
(9532, 'RH{{right hertel measurement}}'),
(9533, 'Right'),
(9534, 'Right Arm'),
(9535, 'Right Deltoid'),
(9536, 'Right Ear'),
(9537, 'right ear'),
(9538, 'Right Gluteus Medius'),
(9539, 'Right Lens'),
(9540, 'Right Lower Forearm'),
(9541, 'Right Margin (mm)'),
(9542, 'Right Thigh'),
(9543, 'Right Vastus Lateralis'),
(9544, 'Right-Form Layout'),
(9545, 'Right:'),
(9546, 'Ringing in Ears'),
(9547, 'Ringing In Ears'),
(9548, 'Risk Category Assessment'),
(9549, 'Risk Factors'),
(9550, 'Risk Level'),
(9551, 'Risky Beh.'),
(9552, 'RI{{right iris}}'),
(9553, 'RK{{right cornea}}'),
(9554, 'RLL:'),
(9555, 'RLL{{right lower eyelid}}'),
(9556, 'RL{{right lens}}'),
(9557, 'RMAC{{right macula}}'),
(9558, 'RMC{{right medial canthus}}'),
(9559, 'Role'),
(9560, 'ROM'),
(9561, 'Romanian'),
(9562, 'Romansh'),
(9563, 'Room 1'),
(9564, 'Room 2'),
(9565, 'Room 3'),
(9566, 'Room Number'),
(9567, 'Roommate'),
(9568, 'Roster'),
(9569, 'ROS{{Review of Systems}}'),
(9570, 'Round and Reactive'),
(9571, 'Route'),
(9572, 'Route of administration, if applicable'),
(9573, 'Routed'),
(9574, 'Rows'),
(9575, 'RP{{right peripheral retina}}'),
(9576, 'RRR without MOR'),
(9577, 'Rub:'),
(9578, 'Rubs:'),
(9579, 'Rule'),
(9580, 'Rule Add'),
(9581, 'Rule Bibliographic Citation'),
(9582, 'Rule Detail'),
(9583, 'Rule Developer'),
(9584, 'Rule Edit'),
(9585, 'Rule Funding Source'),
(9586, 'Rule Release'),
(9587, 'Rule Set'),
(9588, 'Rule Set and Plan Set selections are not consistent. Please fix and Submit again.'),
(9589, 'Rule Title'),
(9590, 'Rules'),
(9591, 'rules already in plan'),
(9592, 'Rules Configuration'),
(9593, 'RUL{{right upper eyelid}}'),
(9594, 'Run Setup again or contact support for assistance'),
(9595, 'Running Command: '),
(9596, 'Rupture'),
(9597, 'Rural Health Clinic'),
(9598, 'Russian'),
(9599, 'RVIT{{right vitreous}}'),
(9600, 'RV{{right vessels}}'),
(9601, 'Rx'),
(9602, 'RX'),
(9603, 'Rx Bottom Margin (px)'),
(9604, 'RX Date'),
(9605, 'Rx Details'),
(9606, 'Rx Dispensed History'),
(9607, 'Rx Enable DEA #'),
(9608, 'Rx Enable NPI'),
(9609, 'Rx Enable State Lic. #'),
(9610, 'Rx History'),
(9611, 'Rx html print - zend module'),
(9612, 'Rx ID'),
(9613, 'Rx Left Margin (px)'),
(9614, 'Rx Log'),
(9615, 'Rx NLM Drug-Drug'),
(9616, 'Rx Paper Size'),
(9617, 'Rx pdf - zend template'),
(9618, 'RX Print Date'),
(9619, 'Rx Right Margin (px)'),
(9620, 'Rx Show DEA #'),
(9621, 'Rx Show NPI'),
(9622, 'Rx Show State Lic. #'),
(9623, 'Rx Top Margin (px)'),
(9624, 'Rx Type'),
(9625, 'Rx Type{{Type of glasses prescription}}'),
(9626, 'Rx/Distance'),
(9627, 'RXCUI Code'),
(9628, 'RXCUI Medication'),
(9629, 'RxNorm'),
(9630, 'RxNorm Database'),
(9631, 'R{{History of Refraction}}'),
(9632, 'R{{right side}}'),
(9633, 'R{{right}}'),
(9634, 'S'),
(9635, 'S.S.'),
(9636, 'S3:'),
(9637, 'S4:'),
(9638, 'SA  *  * To read the license please read the docs/license.txt or visit  * http://www.gnu.org/copyleft/gpl.html  *  */  //========================================================================= // '),
(9639, 'Safe key database'),
(9640, 'Sale'),
(9641, 'Sales'),
(9642, 'Sales by Item'),
(9643, 'Sales by Product Report'),
(9644, 'Saliva'),
(9645, 'Same Day'),
(9646, 'Samoan'),
(9647, 'Sample'),
(9648, 'Sanction Type'),
(9649, 'Sango'),
(9650, 'Sanskrit (Samskrta)'),
(9651, 'Sanskrit (Saṁskṛta)'),
(9652, 'Sardinian'),
(9653, 'Sat'),
(9654, 'Sat &amp; Sun'),
(9655, 'Saturday'),
(9656, 'Save'),
(9657, 'SAVE'),
(9658, 'Save & Exit'),
(9659, 'Save Activity'),
(9660, 'Save and Checkout'),
(9661, 'Save and Close'),
(9662, 'Save and Close Visit'),
(9663, 'Save and Continue'),
(9664, 'Save and Delete Request'),
(9665, 'Save and Dispense'),
(9666, 'Save and Print'),
(9667, 'Save and Transmit'),
(9668, 'Save as New'),
(9669, 'Save as new message'),
(9670, 'Save as new note'),
(9671, 'Save button saves claim and marks reviewed'),
(9672, 'Save Category'),
(9673, 'Save Certificate Settings'),
(9674, 'Save Changes'),
(9675, 'Save Claim'),
(9676, 'Save claim for batch processing'),
(9677, 'Save codes history'),
(9678, 'Save Completed'),
(9679, 'Save Current'),
(9680, 'Save for printing to a pre printed sheet'),
(9681, 'Save for printing with form'),
(9682, 'Save Form'),
(9683, 'Save Immunization'),
(9684, 'Save Level'),
(9685, 'Save New Field'),
(9686, 'Save New Group'),
(9687, 'Save New List'),
(9688, 'Save new template'),
(9689, 'Save omission selections'),
(9690, 'Save Patient Demographics'),
(9691, 'Save Payer'),
(9692, 'Save Profiles'),
(9693, 'Save rejected because someone else has changed this list. Please try again.'),
(9694, 'Save Report as PDF'),
(9695, 'Save Successful'),
(9696, 'Save Successful for chart ID'),
(9697, 'Save to Chart'),
(9698, 'Save Transaction'),
(9699, 'Saved Successfully'),
(9700, 'Saved to Documents->Onsite Portal->Reviewed - Open there to move or rename.'),
(9701, 'Saved to Patient Documents'),
(9702, 'Saving denied'),
(9703, 'Sa{{Saturday}}'),
(9704, 'sc Distance{{without correction distance}}'),
(9705, 'sc Near{{without correction near}}'),
(9706, 'Scan the following QR code with your preferred authenticator app to register a new TOTP key.'),
(9707, 'Scanned'),
(9708, 'Scanned Encounter Note'),
(9709, 'Scanner Directory'),
(9710, 'Scanner In'),
(9711, 'scDist{{ACT without Correction Distance}}'),
(9712, 'scDist{{without correction distance}}'),
(9713, 'Schedule'),
(9714, 'Schedule A New Appointment'),
(9715, 'Schedule Facilities:'),
(9716, 'Schedule New Appointment'),
(9717, 'Scheduled'),
(9718, 'Scheduling'),
(9719, 'Schirmer I'),
(9720, 'Schirmer II'),
(9721, 'Schirmers I'),
(9722, 'Schirmers I (w/o anesthesia)'),
(9723, 'Schirmers II'),
(9724, 'Schirmers II (w/ anesthesia)'),
(9725, 'School'),
(9726, 'SCHOOL NOTE'),
(9727, 'School Record'),
(9728, 'Sclera'),
(9729, 'scNear{{ACT without Correction Near}}'),
(9730, 'scNear{{without correction near}}'),
(9731, 'Scoliosis'),
(9732, 'Scope'),
(9733, 'Scopes'),
(9734, 'Scopes Requested'),
(9735, 'Score'),
(9736, 'Scottish Gaelic- Gaelic'),
(9737, 'Screen'),
(9738, 'Screening / Testing'),
(9739, 'script error'),
(9740, 'Script Error: See Browser Console for Detail'),
(9741, 'SC{{Acuity without correction}}'),
(9742, 'sc{{without correction}}'),
(9743, 'SC{{without correction}}'),
(9744, 'SE'),
(9745, 'SE Address'),
(9746, 'SE Address Line 2'),
(9747, 'SE City'),
(9748, 'SE Country'),
(9749, 'SE Locality'),
(9750, 'SE Postal Code'),
(9751, 'SE State'),
(9752, 'SE Zip Code'),
(9753, 'Search'),
(9754, 'SEARCH'),
(9755, 'search'),
(9756, 'search again'),
(9757, 'Search all columns'),
(9758, 'Search and select a patient and click OK'),
(9759, 'Search Appointment'),
(9760, 'Search by'),
(9761, 'Search by any demographics'),
(9762, 'Search by:'),
(9763, 'Search criteria.'),
(9764, 'Search Diagnoses'),
(9765, 'Search for'),
(9766, 'Search for Additional Codes'),
(9767, 'Search for patient by entering whole or part of any demographics field information'),
(9768, 'Search for the drug by typing its name in the Search for Allergy text-box'),
(9769, 'Search for:'),
(9770, 'Search from external RxNorm table. Vocabulary RXNORM'),
(9771, 'Search from native inventory drugs table'),
(9772, 'Search from native loaded RxCUI table.'),
(9773, 'Search global settings'),
(9774, 'Search In'),
(9775, 'Search in'),
(9776, 'Search Not Available'),
(9777, 'Search or Add Patient'),
(9778, 'Search Patient By Any Demographics'),
(9779, 'Search Patient By Any Demographics, Dual additionally lets direct access to Patient Finder, Comprehensive has collapsed input box, Fixed is similar to Dual with fixed size, None is do not show'),
(9780, 'Search Payment'),
(9781, 'Search Payments'),
(9782, 'Search Products'),
(9783, 'Search Results'),
(9784, 'Search Results:'),
(9785, 'Search Selected'),
(9786, 'Search Services'),
(9787, 'Search string does not match with list in database'),
(9788, 'Search string should have at least three characters'),
(9789, 'search term was not found, please try another search'),
(9790, 'Search Text'),
(9791, 'Search the Events'),
(9792, 'Search user settings'),
(9793, 'Search Web API'),
(9794, 'Search with exact method'),
(9795, 'Search/Add'),
(9796, 'Search/Add Insurer'),
(9797, 'Searching'),
(9798, 'Searching for appointments'),
(9799, 'Searching...'),
(9800, 'Seatbelt'),
(9801, 'Seatbelt use'),
(9802, 'Seatbelt Use'),
(9803, 'Second'),
(9804, 'second'),
(9805, 'Second account message'),
(9806, 'Second is the All Patients. This View shows all current templates that are default to all patients. '),
(9807, 'Secondary'),
(9808, 'Secondary billing'),
(9809, 'Secondary Insurance'),
(9810, 'Secondary Insurance Data'),
(9811, 'Secondary Insurance Provider'),
(9812, 'Secondary Medicare Type'),
(9813, 'seconds'),
(9814, 'Section ID'),
(9815, 'Section ID and Name Cannot be Empty'),
(9816, 'Section Name'),
(9817, 'Section saved successfully'),
(9818, 'Secure Chat'),
(9819, 'Secure Electronic Messaging'),
(9820, 'Secure File Transfer Protocol, or SFTP is a network protocol that provides file access, file transfer, and file management over a secure connection'),
(9821, 'Secure Mail'),
(9822, 'Secure Messaging'),
(9823, 'Secure Password Required'),
(9824, 'Secure Patient Chat'),
(9825, 'Secure Upload Files with White List'),
(9826, 'Security'),
(9827, 'See All'),
(9828, 'See All Messages'),
(9829, 'See Authorizations'),
(9830, 'See couchdb error log'),
(9831, 'See Customize the Fee Sheet'),
(9832, 'See Growth-Chart'),
(9833, 'See messages from the last set of generated claims'),
(9834, 'See observation results'),
(9835, 'See Setup the Fee Sheet'),
(9836, 'See the Clinical Reminders widget for more details'),
(9837, 'Seen since'),
(9838, 'Seen within'),
(9839, 'Segment name'),
(9840, 'Segments Batch Claim'),
(9841, 'Seizures'),
(9842, 'Sel'),
(9843, 'select'),
(9844, 'Select'),
(9845, 'Select \'Price Levels\' and enter Credit Card and Cash'),
(9846, 'Select a Component'),
(9847, 'Select a Context'),
(9848, 'Select a CSV file with translation information to review.'),
(9849, 'Select a date range and click Submit'),
(9850, 'Select a lab from the Order From drop-down box'),
(9851, 'Select a patient by clicking on the patient input box'),
(9852, 'Select a percentage of the rows or or select dates'),
(9853, 'Select a surgery if it is listed in the drop-down box or enter a new surgery name under Title'),
(9854, 'Select a text or html template and upload for selected patient or all portal patients.'),
(9855, 'Select a Time Span'),
(9856, 'Select a User'),
(9857, 'Select a validation rule'),
(9858, 'Select Action'),
(9859, 'Select All'),
(9860, 'Select all'),
(9861, 'Select Amendment Date'),
(9862, 'Select amendments to print'),
(9863, 'Select an appropriate ICD/CPT code. This helps search for education material to give to the patient for that particular problem'),
(9864, 'Select an end date. Entries after this date will not be downloaded or deleted.'),
(9865, 'Select as appropriate and fill in the text box and click Save'),
(9866, 'Select below to Zip Directory of image slices.'),
(9867, 'Select Bidirectional or Results Only as appropriate, again only used for electronic orders'),
(9868, 'Select Blood in the Specimen Type drop-down box'),
(9869, 'Select CAMOS Entries for Printing'),
(9870, 'Select Case'),
(9871, 'Select category'),
(9872, 'Select Code'),
(9873, 'Select Codes'),
(9874, 'Select Communication Preferences'),
(9875, 'Select corresponding checkboxes to delete'),
(9876, 'Select Credit Card Payment Gateway'),
(9877, 'Select Criteria to Remove'),
(9878, 'Select CSV table'),
(9879, 'Select Custom Favorite Group from the Procedure Tier drop-down box'),
(9880, 'Select Custom Favorite Item in the Procedure Tier drop-down box'),
(9881, 'Select Data Required for De Identification'),
(9882, 'Select data to be included in De Identified data'),
(9883, 'Select date'),
(9884, 'Select Default Codes'),
(9885, 'Select desired squad'),
(9886, 'Select Diagnosis'),
(9887, 'Select Diagnosis Codes'),
(9888, 'Select Diagnosis for De Identification request'),
(9889, 'Select Discrete Result from the Procedure Tier'),
(9890, 'Select Discrete Result from the Procedure Tier drop-down box'),
(9891, 'Select Discrete Result under Procedure Tier in the Enter Details pop-up'),
(9892, 'Select Documents'),
(9893, 'Select Drug'),
(9894, 'Select Drugs'),
(9895, 'Select Drugs for De Identification request'),
(9896, 'Select EDI-271 file'),
(9897, 'Select Encounter'),
(9898, 'Select field'),
(9899, 'Select Field'),
(9900, 'Select Fields'),
(9901, 'Select for printing'),
(9902, 'Select from the displayed list'),
(9903, 'Select Group'),
(9904, 'Select Group in the drop-down box labeled Procedure Tier'),
(9905, 'Select Group under Procedure Tier, think of it as creating a large branch off the main tree trunk, and call it Organ/Disease Panel'),
(9906, 'Select Image Procedure'),
(9907, 'Select Immunizations'),
(9908, 'Select Immunizations for De Identification request'),
(9909, 'Select Insurance Company'),
(9910, 'Select Insurance, by typing'),
(9911, 'Select Issue'),
(9912, 'Select items'),
(9913, 'Select Lab Service in the Type drop-down box and enter a name under organization'),
(9914, 'Select Language'),
(9915, 'Select list'),
(9916, 'Select List'),
(9917, 'Select Location'),
(9918, 'Select Method'),
(9919, 'Select MG/DL as Default Units'),
(9920, 'Select Month'),
(9921, 'Select Note Category'),
(9922, 'Select Note Type'),
(9923, 'Select One'),
(9924, 'Select one or more diagnosis codes to justify the service'),
(9925, 'Select one or more files to upload'),
(9926, 'Select only one code per problem'),
(9927, 'Select Options for Current Encounter'),
(9928, 'Select Options for Current Order Id'),
(9929, 'Select Options for Current Procedure Order Id '),
(9930, 'Select output'),
(9931, 'Select patient'),
(9932, 'Select Pharmacy'),
(9933, 'Select Plan'),
(9934, 'SELECT PLAN'),
(9935, 'Select Primary Physician'),
(9936, 'Select Procedure'),
(9937, 'Select Procedure Code'),
(9938, 'Select Procedure Order from Procedure Tier pop-up box'),
(9939, 'Select Procedure Order in Procedure Tier'),
(9940, 'Select Providers'),
(9941, 'Select Referral from the Transaction type drop-down box'),
(9942, 'Select Requested By'),
(9943, 'Select Role'),
(9944, 'Select SMS Gateway'),
(9945, 'Select source'),
(9946, 'Select State and City to Import for Pharmacy'),
(9947, 'Select Supervisor'),
(9948, 'Select Template'),
(9949, 'Select Template Context'),
(9950, 'Select the appropriate choice - Debugging or Production'),
(9951, 'Select the appropriate radio button. Enter the search term in the search box and click \'Search\''),
(9952, 'Select the configuration items to export'),
(9953, 'Select the default font'),
(9954, 'Select the default font (need to logout/login after changing this setting).'),
(9955, 'Select the default font size'),
(9956, 'Select the default font size (need to logout/login after changing this setting).'),
(9957, 'Select the diagnoses to include in the Impression/Plan.'),
(9958, 'Select the group (ARO) that you wish to remove.'),
(9959, 'Select the issue primarily responsible for any missed events on this day'),
(9960, 'Select the Lab From lab name'),
(9961, 'Select the message type to more accurately reflect the type of message you are sending. You may choose to leave it as unassigned'),
(9962, 'Select the name of the entity from the Name drop-down box'),
(9963, 'Select the type of Occurrence of the problem from the drop-down box, the choices are Unknown or N/A, First, Early Recurrence, Late Recurrence, Delayed Recurrence, Chronic/Recurrent and Acute on Chronic'),
(9964, 'Select to print patient address labels from popups in left nav screen.'),
(9965, 'Select to transmit'),
(9966, 'Select Track'),
(9967, 'Select Transaction Type'),
(9968, 'Select Type'),
(9969, 'Select User'),
(9970, 'SELECT Users FROM The Dropdown LIST'),
(9971, 'Select Users From The Dropdown List'),
(9972, 'Select which languages, if any, may be chosen at login. (only pertinent if above All Languages Allowed is turned off)'),
(9973, 'Select Year'),
(9974, 'Select Yes to confirm group deletion'),
(9975, 'Select your current facility in the login page'),
(9976, 'Select/Add Authentication Method for the logged in user'),
(9977, 'Select/Add New Authentication Method for'),
(9978, 'Select1'),
(9979, 'Select2'),
(9980, 'Selected'),
(9981, 'Selected Encounter'),
(9982, 'Selected Fee Sheet Codes and Charges for Current Encounter'),
(9983, 'Selected Files'),
(9984, 'Selected files and data will be removed from folders and tables'),
(9985, 'Selecting the width for responsive vertical style menus in tab based layout (need to logout/login after changing this setting)'),
(9986, 'Selecting this will create a message that needs to be processed by each recipient individually (this is not a group task).'),
(9987, 'Seleted Message id'),
(9988, 'Self'),
(9989, 'Self Pay'),
(9990, 'SEND'),
(9991, 'Send'),
(9992, 'Send A Dated Reminder'),
(9993, 'Send a Reminder'),
(9994, 'Send a report to this provider'),
(9995, 'Send an email to '),
(9996, 'Send CCD'),
(9997, 'Send CCR'),
(9998, 'Send Complete - Prescription(s) Return Status'),
(9999, 'Send Emails'),
(10000, 'Send for Review'),
(10001, 'Send in progress'),
(10002, 'Send It'),
(10003, 'Send Message'),
(10004, 'Send message'),
(10005, 'Send message from the permanent group therapist to the personal therapist'),
(10006, 'Send message from the permanent group therapist to the personal therapist (gm)'),
(10007, 'Send NewRx'),
(10008, 'Send Notes'),
(10009, 'Send Payment'),
(10010, 'Send Reminders Batch'),
(10011, 'Send reminders to patients per patient preference for preventive/follow up care.'),
(10012, 'Send Request'),
(10013, 'Send Selected to Archive'),
(10014, 'Send Selected to Trash'),
(10015, 'Send Summaries with Referrals'),
(10016, 'Send this file'),
(10017, 'Send This Message'),
(10018, 'Send to'),
(10019, 'Send To'),
(10020, 'SEND TO'),
(10021, 'Send to all'),
(10022, 'Send to Archive'),
(10023, 'Send To HIE failed'),
(10024, 'Send to portal'),
(10025, 'Send to Portal'),
(10026, 'Send to Trash'),
(10027, 'Sender'),
(10028, 'Sender ID'),
(10029, 'Sender ID (ISA06)'),
(10030, 'Sender ID Qualifier (ISA05)'),
(10031, 'Sender IDs'),
(10032, 'Sender IDs - is only required if you are submitting an electronic order to an external facility'),
(10033, 'sender name'),
(10034, 'SENDING A MESSAGE'),
(10035, 'Sending application name will be provided by the facility that you will be connecting to'),
(10036, 'Sending Claims via STFP. Check status on the `Claim File Tracker`'),
(10037, 'Sending facility name is user defined'),
(10038, 'Sending From'),
(10039, 'Sending Invoice to Patient Portal Completed'),
(10040, 'Sending Templates or Profiles'),
(10041, 'Sending To'),
(10042, 'Sensitivities'),
(10043, 'Sensitivities (sensitivities)'),
(10044, 'Sensitivity'),
(10045, 'Sensitivity - lets you limit the information in this encounter to those with appropriate privileges'),
(10046, 'Sensitivity:'),
(10047, 'Sensory exam normal'),
(10048, 'Sent'),
(10049, 'Sent - Confirmed'),
(10050, 'Sent By, Leave Blank For All'),
(10051, 'Sent by:'),
(10052, 'Sent Date'),
(10053, 'Sent Items'),
(10054, 'Sent Medical Records?'),
(10055, 'Sent successfully'),
(10056, 'Sent Summary of Care Electronically?'),
(10057, 'Sent Summary of Care?'),
(10058, 'sent to printer.'),
(10059, 'Sent To, Leave Blank For All'),
(10060, 'Sent to:'),
(10061, 'Sent, but delivery not yet confirmed.'),
(10062, 'Sent, not received'),
(10063, 'Sent{{Mails}}'),
(10064, 'Sep'),
(10065, 'Separated'),
(10066, 'September'),
(10067, 'Seq'),
(10068, 'Sequence'),
(10069, 'Serbian'),
(10070, 'Serial Number'),
(10071, 'Serv Rep'),
(10072, 'Server error: try again later'),
(10073, 'Server Login'),
(10074, 'Server may be offline'),
(10075, 'Server message:'),
(10076, 'Server says thanks. Images state saved.'),
(10077, 'Server Status'),
(10078, 'Service'),
(10079, 'Service added'),
(10080, 'Service and Client Volume Report'),
(10081, 'Service Category'),
(10082, 'Service Code'),
(10083, 'Service Code Finance Reporting'),
(10084, 'Service Codes'),
(10085, 'Service Date'),
(10086, 'Service Date From'),
(10087, 'Service Date To'),
(10088, 'Service Date:'),
(10089, 'Service deleted'),
(10090, 'Service Facility'),
(10091, 'Service is not compatible with the sex of this client.'),
(10092, 'Service Location'),
(10093, 'Service Name'),
(10094, 'Service provided by specialist'),
(10095, 'Service provider changed'),
(10096, 'Service Reporting'),
(10097, 'Service Reporting Only'),
(10098, 'Services'),
(10099, 'Services by Category'),
(10100, 'Services Provided'),
(10101, 'Services provided'),
(10102, 'Services/Products'),
(10103, 'Session Type'),
(10104, 'Set'),
(10105, 'Set a facility cookie to remember the selected facility between logins.'),
(10106, 'Set As Completed'),
(10107, 'SET AS COMPLETED'),
(10108, 'Set aside some uninterrupted time for the data entry'),
(10109, 'Set Gateway to Production Mode'),
(10110, 'Set POS code in encounter'),
(10111, 'Set Price Level'),
(10112, 'Set processing priority for CDR engine based reports.'),
(10113, 'Set processing priority for creation of Patient Reminders (in full clinic mode).'),
(10114, 'Set the priority level'),
(10115, 'Set this to the full absolute path. For creating client SSL certificates for HTTPS.'),
(10116, 'Set To'),
(10117, 'Set to Default'),
(10118, 'Set to the number of prior passwords that are not allowed to use when changing a password.'),
(10119, 'set value to'),
(10120, 'Set which radio button is selected by default in \'Search for Additional Codes\' section'),
(10121, 'Sets the font of the address text on the envelope in mm'),
(10122, 'Setting'),
(10123, 'Setting the version number in the database...'),
(10124, 'Setting up 2FA'),
(10125, 'Settings'),
(10126, 'Setup MedEx'),
(10127, 'Setup the Fee Sheet'),
(10128, 'Several additional drop-down and text boxes will be visible'),
(10129, 'Several days'),
(10130, 'Severe'),
(10131, 'Severe anxiety disorder'),
(10132, 'Severe Migraine'),
(10133, 'Severity'),
(10134, 'Severity information will be missing if interaction is found'),
(10135, 'Severity of Pain'),
(10136, 'Severity of Pain:'),
(10137, 'Sex'),
(10138, 'Sexually Transmitted Disease'),
(10139, 'SFTP'),
(10140, 'SFTP Host'),
(10141, 'SFTP Local Directory'),
(10142, 'SFTP Login Credentials'),
(10143, 'SFTP Pass Credentials'),
(10144, 'SFTP Port'),
(10145, 'SFTP Remote Directory'),
(10146, 'SFTP will send the order as a HL7v2.3 message to the receiving lab using the SFTP protocol'),
(10147, 'Sha-1 Hash'),
(10148, 'Sharing'),
(10149, 'Shell command for printing from the server.'),
(10150, 'Shift'),
(10151, 'Shifts Reporting'),
(10152, 'Shona'),
(10153, 'Short Description'),
(10154, 'Shorthand'),
(10155, 'Shorthand Help'),
(10156, 'Shortness of Breath'),
(10157, 'Shortness Of Breath'),
(10158, 'Shortness Of Breath 2'),
(10159, 'Shot Record'),
(10160, 'Shot Record as of:'),
(10161, 'Should be Enabled'),
(10162, 'should be like nnnnn-nnnn-nn'),
(10163, 'Should be two letters'),
(10164, 'should contain 10 digits'),
(10165, 'should contain only 10 digits'),
(10166, 'Shoulder'),
(10167, 'Shoulder + clavicle'),
(10168, 'Shoulder Problems'),
(10169, 'Show'),
(10170, 'Show Active'),
(10171, 'Show Additional Insurance Information'),
(10172, 'Show Aging on Custom Statement'),
(10173, 'Show All'),
(10174, 'Show all payment history in Patient Ledger'),
(10175, 'Show all procedures'),
(10176, 'Show All Results'),
(10177, 'Show All Transactions'),
(10178, 'Show as Busy'),
(10179, 'Show Authorized Only'),
(10180, 'Show Available Times'),
(10181, 'Show both US and metric (main unit is metric)'),
(10182, 'Show both US and metric (main unit is US)'),
(10183, 'Show button for download fax template'),
(10184, 'Show button in the prescription list for download fax template'),
(10185, 'Show Current Signature On File'),
(10186, 'Show Details'),
(10187, 'Show Diagnoses Section'),
(10188, 'Show empty lots'),
(10189, 'Show Errors Only?'),
(10190, 'Show Extra Logo on Login'),
(10191, 'Show Graph'),
(10192, 'Show Help Modal'),
(10193, 'Show hovering event text on mouseover?'),
(10194, 'Show how many events on admin pages?'),
(10195, 'Show inactive'),
(10196, 'Show Inactive'),
(10197, 'Show Insurance Address Information in the Insurance Panel of Demographics.'),
(10198, 'Show IOP by Date'),
(10199, 'Show IOP by Time'),
(10200, 'Show labels on the login form'),
(10201, 'Show Menu'),
(10202, 'Show metric only'),
(10203, 'Show Mini Logo 1'),
(10204, 'Show Mini Logo 2'),
(10205, 'Show Notes'),
(10206, 'Show only latest values reported for each result code'),
(10207, 'Show only procedures not omitted'),
(10208, 'Show Password'),
(10209, 'Show Patient Encounter Number in Patient Flow Board'),
(10210, 'Show Patient ID in Patient Flow Board'),
(10211, 'Show Patient Notes'),
(10212, 'Show pounds and ounces'),
(10213, 'Show pounds as decimal value'),
(10214, 'Show Primary Complete'),
(10215, 'Show Products Section'),
(10216, 'Show Receipt'),
(10217, 'Show records'),
(10218, 'Show Referrals Section'),
(10219, 'Show Reminders'),
(10220, 'Show Report'),
(10221, 'Show search/submit links in block?'),
(10222, 'Show Selected for Drug Screens'),
(10223, 'Show Services Section'),
(10224, 'Show Status of Drug Screens'),
(10225, 'Show Tagline on Login Page'),
(10226, 'Show the custom state form for the add list widget (will ask for title and abbreviation).'),
(10227, 'Show the Impression/Plan Builder panel'),
(10228, 'Show the last three Refractions'),
(10229, 'Show the tagline from the login screen'),
(10230, 'Show this category on the patient summary screen even if no issues have been entered for this category.'),
(10231, 'Show Title on Login'),
(10232, 'Show track history'),
(10233, 'Show Unbilled Only'),
(10234, 'Show US only'),
(10235, 'Show Username and Password Labels on Login Page'),
(10236, 'Show Visit Reason in Patient Flow Board'),
(10237, 'show/hide executed query log'),
(10238, 'Show/Hide the Selection Area'),
(10239, 'Showing'),
(10240, 'Showing 0 to 0 of 0 entries'),
(10241, 'Showing items'),
(10242, 'Showing page'),
(10243, 'Showing result'),
(10244, 'Shows the hierarchal level of this line'),
(10245, 'Shutting Down Service ...'),
(10246, 'Sibling'),
(10247, 'Sibling History'),
(10248, 'Sibling in-law'),
(10249, 'Siblings'),
(10250, 'Sickle Cell'),
(10251, 'Sig'),
(10252, 'Sigmoid/Colonoscopy'),
(10253, 'Sign'),
(10254, 'Sign In'),
(10255, 'Sign Lab Results (write,addonly optional)'),
(10256, 'Sign Lab Results (write,addonly optional) (sign)'),
(10257, 'Sign Results'),
(10258, 'Sign-up'),
(10259, 'Sign-up successful for'),
(10260, 'Signature'),
(10261, 'Signature on File'),
(10262, 'Signature On File'),
(10263, 'Signature:'),
(10264, 'Signed'),
(10265, 'Signed Date'),
(10266, 'Signed Rx'),
(10267, 'Significant Other'),
(10268, 'Significant Swelling:'),
(10269, 'Simplified'),
(10270, 'Simplified Co-Pay'),
(10271, 'Simplified Demographics'),
(10272, 'Simplified Prescriptions'),
(10273, 'Simplified; Contraceptive Start Date on Tally Sheet'),
(10274, 'SINADI Report'),
(10275, 'Since'),
(10276, 'Sincerely,'),
(10277, 'Sindhi'),
(10278, 'Single'),
(10279, 'Single Tests'),
(10280, 'Single-selection list'),
(10281, 'Single-selection list with ability to add to the list'),
(10282, 'Singular'),
(10283, 'Sinhala'),
(10284, 'Sinhala, Sinhalese'),
(10285, 'Sinus Problems'),
(10286, 'Sinus Surgery'),
(10287, 'SINUS TENDERNESS:'),
(10288, 'Sinusitis'),
(10289, 'Sister'),
(10290, 'Site'),
(10291, 'Site Address (required for OAuth2 and FHIR)'),
(10292, 'Site Address (required for OAuth2 and FHIR). Example is'),
(10293, 'Site Address Override (if needed for OAuth2, FHIR or CCDA)'),
(10294, 'Site ID'),
(10295, 'Site ID for the Medical Information Integration, LLC Lab Exchange Service.'),
(10296, 'Site ID for the OpenEMR Support LLC Lab Exchange Service.'),
(10297, 'Site Worker'),
(10298, 'Six Months Ago'),
(10299, 'Six Months Ahead'),
(10300, 'Size'),
(10301, 'size'),
(10302, 'Size Height'),
(10303, 'Size must be a number between 1 and 999'),
(10304, 'Size Width'),
(10305, 'Size/List'),
(10306, 'Skilled Nursing Facility'),
(10307, 'Skin'),
(10308, 'Skin Cancer'),
(10309, 'Skin Disease'),
(10310, 'Skin Other'),
(10311, 'Skip Authorization of Patient Notes'),
(10312, 'Skipping illegal layout name'),
(10313, 'Skipping illegal list name'),
(10314, 'Skipping missing layout name'),
(10315, 'Skipping missing list name'),
(10316, 'Skipping section'),
(10317, 'Skipping SQL-Ledger dump - not implemented for Windows server'),
(10318, 'Sl.No'),
(10319, 'Slab Off'),
(10320, 'Sleep'),
(10321, 'Sleep patterns'),
(10322, 'Sleep Patterns'),
(10323, 'Sleeping'),
(10324, 'Sliding'),
(10325, 'Slovak'),
(10326, 'Slovene'),
(10327, 'Sm debt w/o'),
(10328, 'Smart App'),
(10329, 'SMART apps that display on the patient summary page can be enabled or disabled from this screen. Any OAUTH2 client requesting the \'launch\' scope will allow EMR users to launch an app from within the EHR.'),
(10330, 'SMART Enabled Apps'),
(10331, 'Smartphones can have authenticator apps that can calculate OTP using either time based or algorithm based approaches and is a common method of OTP delivery'),
(10332, 'Smarty Cache has been cleared'),
(10333, 'Smoker, current status unknown'),
(10334, 'Smoking'),
(10335, 'Smoking Status'),
(10336, 'SMS'),
(10337, 'SMS Auth'),
(10338, 'SMS based delivery of OTP is easy to implement with no additional steps needed by the user'),
(10339, 'SMS Confirmed'),
(10340, 'SMS Gateway'),
(10341, 'SMS Gateway API key'),
(10342, 'SMS Gateway API Key'),
(10343, 'SMS Gateway Password'),
(10344, 'SMS Gateway Username'),
(10345, 'SMS Messages'),
(10346, 'SMS Notification'),
(10347, 'SMS Notification Hours'),
(10348, 'SMS Notification Settings Updated Successfully'),
(10349, 'SMS OK'),
(10350, 'SMS send before'),
(10351, 'SMS Sent'),
(10352, 'SMS Text Usable Tags'),
(10353, 'SMS Text Usable Tags:'),
(10354, 'SMS Text, Usable Tag: ***NAME***, ***PROVIDER***, ***DATE***, ***STARTTIME***, ***ENDTIME***<br> i.e. Dear ***NAME***'),
(10355, 'SMS Text, Usable Tags: '),
(10356, 'SMS Zone'),
(10357, 'SMS zone - This section lets use send and receive SMS texts'),
(10358, 'SMS/Email Alert Settings'),
(10359, 'SMS/Email Alert Settings Updated Successfully'),
(10360, 'SMTP Password for Authentication'),
(10361, 'SMTP Security Protocol'),
(10362, 'SMTP security protocol to connect with. Required by some servers such as gmail.'),
(10363, 'SMTP Server Hostname'),
(10364, 'SMTP Server Port Number'),
(10365, 'SMTP User for Authentication'),
(10366, 'SNOMED'),
(10367, 'SNOMED (RF1) Clinical Term'),
(10368, 'SNOMED (RF1) Diagnosis'),
(10369, 'SNOMED (RF1) Procedure'),
(10370, 'SNOMED (RF2) Clinical Term'),
(10371, 'SNOMED (RF2) Diagnosis'),
(10372, 'SNOMED (RF2) Procedure'),
(10373, 'SNOMED Clinical Term'),
(10374, 'SNOMED Database'),
(10375, 'SNOMED Diagnosis'),
(10376, 'SNOMED Procedure'),
(10377, 'SNOMED-CT Code'),
(10378, 'Snoring'),
(10379, 'SOAP'),
(10380, 'Soap Import Status'),
(10381, 'Soc Hx{{Social History}}'),
(10382, 'Social'),
(10383, 'Social Difficulties'),
(10384, 'Social History'),
(10385, 'Social History Element'),
(10386, 'Social History:'),
(10387, 'Social Security Number'),
(10388, 'Social Security(Optional)'),
(10389, 'solution'),
(10390, 'Somali'),
(10391, 'Somatic Context'),
(10392, 'Some authorizations were not displayed. Click here to view all'),
(10393, 'Some codes were not displayed.'),
(10394, 'Some encounters were not displayed. Click here to view all.'),
(10395, 'Some error has occured during De Identification Process'),
(10396, 'Some global parameters on the setup and printing of the generated claims can be set in Adminstration > Globals > Billing'),
(10397, 'Some notes were not displayed.'),
(10398, 'Some office notes were not displayed. Click here to view all.'),
(10399, 'Some smaller local labs may agree to deal directly with the practice'),
(10400, 'some words'),
(10401, 'Someone else has just changed this visit. Please cancel this page and try again.'),
(10402, 'Something went wrong'),
(10403, 'Something went wrong.'),
(10404, 'Something went wrong. Please try again.'),
(10405, 'Something went wrong. Recommend contacting the clinic.'),
(10406, 'Somewhat difficult'),
(10407, 'Soon Due Interval (Clinical Reminders)'),
(10408, 'Soon Due Interval (Patient Reminders)'),
(10409, 'Sore Throat'),
(10410, 'Sorry No Appointment is Fixed'),
(10411, 'Sorry you are not privileged enough. Enrollment is limited to Adminstrator accounts.'),
(10412, 'Sorry! Not Authorized.'),
(10413, 'Sorry, there was a problem uploading your file'),
(10414, 'Sorry, there was a problem!'),
(10415, 'Sorry. Can not update history.'),
(10416, 'Sort alphabetically'),
(10417, 'Sort by'),
(10418, 'Sort By'),
(10419, 'Sort by Category'),
(10420, 'Sort by Checksum'),
(10421, 'Sort by Comments'),
(10422, 'Sort by Crt User'),
(10423, 'Sort by date'),
(10424, 'Sort by date/time'),
(10425, 'Sort by Event'),
(10426, 'Sort by Group'),
(10427, 'Sort by New Checksum'),
(10428, 'Sort by Old Checksum'),
(10429, 'Sort by PatientID'),
(10430, 'Sort by seq'),
(10431, 'Sort by Success'),
(10432, 'Sort by Tamper date/time'),
(10433, 'Sort by User'),
(10434, 'Sort by vaccine'),
(10435, 'Sort Down'),
(10436, 'Sort Result by'),
(10437, 'Sort Up'),
(10438, 'Source'),
(10439, 'Source CSV File'),
(10440, 'Source File'),
(10441, 'Source File Path'),
(10442, 'Source is missing for code '),
(10443, 'Source Lot'),
(10444, 'Source of the document'),
(10445, 'Source Patient'),
(10446, 'Source patient has no DOB'),
(10447, 'Source patient not found'),
(10448, 'Source:'),
(10449, 'South Ndebele'),
(10450, 'Southern Sotho'),
(10451, 'Space'),
(10452, 'SPACE'),
(10453, 'Span Entire Row'),
(10454, 'Spanish'),
(10455, 'Spanish (Latin American)'),
(10456, 'Spanish (Spain)'),
(10457, 'Spanish- Castilian'),
(10458, 'Special characters are not allowed'),
(10459, 'Special treatment for the Vitals form'),
(10460, 'Specialist'),
(10461, 'Specialist name and signature'),
(10462, 'Specialized physician'),
(10463, 'Specialty'),
(10464, 'Specialty Form'),
(10465, 'Specialty Systems'),
(10466, 'Specialty:'),
(10467, 'Specific'),
(10468, 'Specific Application'),
(10469, 'Specific Contraceptive Service'),
(10470, 'Specific Result'),
(10471, 'Specific Service'),
(10472, 'Specified'),
(10473, 'Specifies formatting for codes. # = digit, * = any character. Empty if not used.'),
(10474, 'Specifies formatting for codes. # = digit, @ = alpha, * = any character. Empty if not used.'),
(10475, 'Specifies formatting for invoice reference numbers.  # = digit, * = any character.  Empty if not used.'),
(10476, 'Specifies formatting for invoice reference numbers.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(10477, 'Specifies formatting for product NDC fields.  # = digit, * = any character.  Empty if not used.'),
(10478, 'Specifies formatting for product NDC fields.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(10479, 'Specifies formatting for the external patient ID.  # = digit, * = any character.  Empty if not used.'),
(10480, 'Specifies formatting for the external patient ID.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(10481, 'Specify the interval for automatic message checking, 5 or 10 minutes as a starting point'),
(10482, 'Specify the OpenEMR user who will receive notification of new incoming Direct messages'),
(10483, 'Specimen'),
(10484, 'Specimen Collections date has not been entered and this is not a PSC Hold Order!'),
(10485, 'Specimen number/identifier'),
(10486, 'Specimen Type'),
(10487, 'Specimen type'),
(10488, 'Speech Dictation'),
(10489, 'Spermicides'),
(10490, 'Sphere'),
(10491, 'Sphere Clinicfront in person (RETAIL) Transaction CustID'),
(10492, 'Sphere Clinicfront in person (RETAIL) Transaction CustID License Key'),
(10493, 'Sphere Clinicfront over phone (MOTO) Transaction CustID'),
(10494, 'Sphere Clinicfront over phone (MOTO) Transaction CustID License Key'),
(10495, 'Sphere Ecomm TC Link Password'),
(10496, 'Sphere MOTO TC Link Password'),
(10497, 'Sphere Patientfront (Ecomm) Transaction CustID'),
(10498, 'Sphere Patientfront (Ecomm) Transaction CustID License Key'),
(10499, 'Sphere RETAIL TC Link Password'),
(10500, 'Sphere Void/Credit Confirmation Password. OpenEMR confirms pin/password before proceeding with void/credit.'),
(10501, 'Sphere Void/Credit Confirmation PIN'),
(10502, 'Sph{{Sphere}}'),
(10503, 'SPH{{Sphere}}'),
(10504, 'Splenectomy'),
(10505, 'Spouse'),
(10506, 'Spouses History'),
(10507, 'Sputum'),
(10508, 'Sputum:'),
(10509, 'SQ'),
(10510, 'sql'),
(10511, 'SQL-Ledger'),
(10512, 'Squad'),
(10513, 'Squad Membership'),
(10514, 'Squads'),
(10515, 'Squads (squads)'),
(10516, 'Sr'),
(10517, 'Sr.'),
(10518, 'SRH'),
(10519, 'SRH - Family Planning'),
(10520, 'SRH Non Family Planning'),
(10521, 'SRH Referrals'),
(10522, 'SRH Visit Form'),
(10523, 'Srv Date'),
(10524, 'SS'),
(10525, 'SSL Certificate Administration'),
(10526, 'SSN'),
(10527, 'Stability'),
(10528, 'Stack Trace'),
(10529, 'Staged Releases'),
(10530, 'Standard'),
(10531, 'Standard check'),
(10532, 'Standard Code'),
(10533, 'Standard Code (LOINC)'),
(10534, 'Standard Error Logging'),
(10535, 'Standard Measures'),
(10536, 'Standard Measures (Active Alerts)'),
(10537, 'Standard Measures (Passive Alerts)'),
(10538, 'Standard Measures (Patient Reminders)'),
(10539, 'Standard Name'),
(10540, 'Standard; Simplified: only title, start date, comments and an Active checkbox;no diagnosis, occurrence, end date, referred-by or sports fields. ; Football Injury'),
(10541, 'Start'),
(10542, 'Start (yyyy-mm-dd): '),
(10543, 'Start Another Report'),
(10544, 'Start Assessment'),
(10545, 'Start Batch Processing'),
(10546, 'Start by clicking on Add Top Level to bring up the Enter Details pop-up box in the Add Mode'),
(10547, 'Start by clicking on the black plus sign at the end of the Serum Chemistry line to bring up the Enter Details pop-up'),
(10548, 'Start by clicking the Browse button and selecting the file to upload, and then clicking \'Upload\' to perform the upload and display the corresponding invoices. In this case the other parameters mentioned above do not apply and will be ignored. Uploading saves the file but does not yet process its contents -- that is done separately as described below.'),
(10549, 'Start Date'),
(10550, 'Start date'),
(10551, 'Start Date at This Clinic'),
(10552, 'Start Date should not be greater than End Date'),
(10553, 'Start date:'),
(10554, 'Start Date:'),
(10555, 'Start entering the data in an orderly manner, tier by tier, one top order group at a time'),
(10556, 'Start Time'),
(10557, 'Start watching server processes for upgrade version'),
(10558, 'Starting date'),
(10559, 'Starting Date'),
(10560, 'Starting date for search'),
(10561, 'Starting Date From'),
(10562, 'Starting Date To'),
(10563, 'stat'),
(10564, 'State'),
(10565, 'State Data Type'),
(10566, 'State Lic. #'),
(10567, 'State License Number'),
(10568, 'State list'),
(10569, 'State List (write,addonly optional)'),
(10570, 'State List (write,addonly optional) (state)'),
(10571, 'State List Widget Custom Fields'),
(10572, 'State Or Province'),
(10573, 'State/Locality'),
(10574, 'State/Parish'),
(10575, 'State:'),
(10576, 'Statement Appearance'),
(10577, 'Statement Logo GIF Filename'),
(10578, 'STATEMENT SUMMARY'),
(10579, 'statements and updating invoices.'),
(10580, 'Statements Sent'),
(10581, 'Statements Sent:'),
(10582, 'statements; invoices will not be updated.'),
(10583, 'Static Text'),
(10584, 'Statistics'),
(10585, 'Stats'),
(10586, 'Status'),
(10587, 'Status in the group'),
(10588, 'Status in the meeting'),
(10589, 'Status Of Admission'),
(10590, 'Status of Claim'),
(10591, 'Status quo'),
(10592, 'Status Type'),
(10593, 'STD/AIDS Couns'),
(10594, 'Stength and Conditioning'),
(10595, 'Step Child'),
(10596, 'Step Parent'),
(10597, 'Step Sibling'),
(10598, 'Stepchild'),
(10599, 'Steps for uploading CCR XML'),
(10600, 'Steps to install the DSM IV database'),
(10601, 'Steps to install the ICD 10 database'),
(10602, 'Steps to install the ICD 9 database'),
(10603, 'Steps to install the RxNorm database'),
(10604, 'Steps to install the Snomed database'),
(10605, 'Steps to install the VALUSET database'),
(10606, 'Stereopsis'),
(10607, 'Stiff Joints'),
(10608, 'Stiffness'),
(10609, 'Still Loading...'),
(10610, 'Stock Months'),
(10611, 'Stomach Pains'),
(10612, 'Stop'),
(10613, 'STOP'),
(10614, 'Stopping activity status checks. Internal Server Error'),
(10615, 'Stopping status checks. Csrf Error. No harm to upgrade and will continue.'),
(10616, 'Store your safe key at settings globals in security tab'),
(10617, 'Stored Hash'),
(10618, 'Strabismus'),
(10619, 'Strain of muscle'),
(10620, 'Streak'),
(10621, 'Stream'),
(10622, 'Street'),
(10623, 'Street Address'),
(10624, 'Street Address incomplete Missing'),
(10625, 'Street and Number'),
(10626, 'Strength'),
(10627, 'Strength and Conditioning'),
(10628, 'Strep Throat'),
(10629, 'Stress fracture'),
(10630, 'Stress Test'),
(10631, 'Stripe'),
(10632, 'Stroke'),
(10633, 'stroke'),
(10634, 'Strong password means at least 8 characters, and at least three of: a number, a lowercase letter, an uppercase letter, a special character.'),
(10635, 'Strong password means at least one of each: a number, a lowercase letter, an uppercase letter, a special character.'),
(10636, 'Style'),
(10637, 'Style of form used for adding new patients'),
(10638, 'Style your messsage and/or add Image/Video'),
(10639, 'Stylings'),
(10640, 'Sub Group'),
(10641, 'Sub-category'),
(10642, 'Sub-Total'),
(10643, 'Subcategory'),
(10644, 'subcategory'),
(10645, 'subcutaneously'),
(10646, 'Subject'),
(10647, 'Subjective'),
(10648, 'Sublingual'),
(10649, 'sublingual'),
(10650, 'Submit'),
(10651, 'submit'),
(10652, 'Submit All Content'),
(10653, 'Submit and Delete Request'),
(10654, 'Submit Changes For All Appts At Once'),
(10655, 'Submit Document'),
(10656, 'Submit Event'),
(10657, 'submit form'),
(10658, 'Submit Payment for Authorization'),
(10659, 'Submit Selected Content'),
(10660, 'Submitted'),
(10661, 'submitted'),
(10662, 'Submitted by'),
(10663, 'Submitter EDI Access Number (PER06)'),
(10664, 'Submitter Name (3rd Party Submitter Only)'),
(10665, 'Submitter Name (If applicable)'),
(10666, 'Subscriber'),
(10667, 'Subscriber Address'),
(10668, 'Subscriber Address Line 1'),
(10669, 'Subscriber Address Line 2'),
(10670, 'Subscriber City'),
(10671, 'Subscriber Country'),
(10672, 'Subscriber Date of Birth'),
(10673, 'Subscriber Employer'),
(10674, 'Subscriber Employer (SE)'),
(10675, 'Subscriber Employer Address'),
(10676, 'Subscriber Employer City'),
(10677, 'Subscriber Employer Country'),
(10678, 'Subscriber Employer State'),
(10679, 'Subscriber Employer Street'),
(10680, 'Subscriber Employer Zip'),
(10681, 'Subscriber Employer Zip Code'),
(10682, 'Subscriber First Name'),
(10683, 'Subscriber Last Name'),
(10684, 'Subscriber Member'),
(10685, 'Subscriber Middle Name'),
(10686, 'Subscriber Phone'),
(10687, 'Subscriber Relationship'),
(10688, 'Subscriber relationship is not self but name is the same! Is this really OK?'),
(10689, 'Subscriber relationship is not self but SS number is the same!'),
(10690, 'Subscriber relationship is self but name is different! Is this really OK?'),
(10691, 'Subscriber relationship is self but SS number is different!'),
(10692, 'Subscriber Sex'),
(10693, 'Subscriber SS'),
(10694, 'Subscriber State'),
(10695, 'Subscriber Zip'),
(10696, 'Subscriber/Policy'),
(10697, 'Subscribers will receive the username, password, and server address information with which to configure OpenEMR'),
(10698, 'Subscribter Phone'),
(10699, 'Substance'),
(10700, 'Substance Refusal Reason'),
(10701, 'Substitution'),
(10702, 'substitution allowed'),
(10703, 'Subtitle'),
(10704, 'Subtype'),
(10705, 'Success'),
(10706, 'success'),
(10707, 'Success confirming receipt of lab result'),
(10708, 'Success getting lab results'),
(10709, 'Success retrieving results from Lab Exchange Network'),
(10710, 'Successful'),
(10711, 'Successful payment'),
(10712, 'Successful Transfers'),
(10713, 'Successfully added category'),
(10714, 'successfully added to category,'),
(10715, 'Successfully Completed'),
(10716, 'Successfully Deleted'),
(10717, 'Successfully Imported the details. Please approve the patient from the Pending Approval Screen'),
(10718, 'Successfully installed the database.'),
(10719, 'Successfully installed the following database'),
(10720, 'Successfully marked claim'),
(10721, 'Successfully Modified'),
(10722, 'Successfully ordered form'),
(10723, 'Successfully processed claim'),
(10724, 'Successfully revoked access token'),
(10725, 'Successfully revoked refresh token'),
(10726, 'Successfully revoked Trusted User'),
(10727, 'Successfully Saved.Would you like to Allocate?'),
(10728, 'Successfully Saved.Would you like to Distribute?'),
(10729, 'Successfully Sent'),
(10730, 'successfully stored.'),
(10731, 'Successfully upgraded'),
(10732, 'Successfully upgraded the database.'),
(10733, 'Successfully upgraded the following database'),
(10734, 'Successfully Validated claim'),
(10735, 'successfully.'),
(10736, 'Suffix'),
(10737, 'Suggestions for the Imp/Plan are built from the Exam, the Past Ocular History (POH and POS) and the Past Medical History (PMH)'),
(10738, 'Suicide'),
(10739, 'Suite'),
(10740, 'Summary'),
(10741, 'Summary of'),
(10742, 'Summary of Acuities for this patient'),
(10743, 'Summary Of Care Provided?'),
(10744, 'Summary of Care Provided?'),
(10745, 'Summary of Care Sent'),
(10746, 'Summary of Care Sent Electronically'),
(10747, 'Sun'),
(10748, 'Sundanese'),
(10749, 'Sunday'),
(10750, 'Superbill'),
(10751, 'Superbill Codes'),
(10752, 'Superbill Codes Administration'),
(10753, 'Superbill Codes Administration (superbill)'),
(10754, 'Superbill Report'),
(10755, 'Superbill/Fee Sheet'),
(10756, 'Superbills'),
(10757, 'Superbills, sometimes referred to as Encounter Forms or Routing Slips, are an essential part of most medical practices.'),
(10758, 'Superuser'),
(10759, 'Superuser - can delete patients, encounters, issues (super)'),
(10760, 'Supervising'),
(10761, 'Supervising Doctor'),
(10762, 'Supervising Doctor DEA'),
(10763, 'Supervising Doctor First name'),
(10764, 'Supervising Doctor Last name'),
(10765, 'Supervising Doctor NPI'),
(10766, 'Supervising Doctor UPIN'),
(10767, 'Supervising Provider'),
(10768, 'Supervisor'),
(10769, 'Supplier'),
(10770, 'Supplier facility name'),
(10771, 'Support calendar events that apply to multiple providers'),
(10772, 'Support export/import of configuration data via the Backup page.'),
(10773, 'Support Multi-Provider Events'),
(10774, 'Support Phone Number'),
(10775, 'Support provider in line item in fee sheet'),
(10776, 'Supports AES-256-CBC encryption/decryption only.'),
(10777, 'Supports TripleDES encryption/decryption only.'),
(10778, 'sup{{superior}}'),
(10779, 'Surface Type'),
(10780, 'Surgeon'),
(10781, 'Surgeries'),
(10782, 'Surgery'),
(10783, 'Surgery Issue List'),
(10784, 'Suspended'),
(10785, 'suspension'),
(10786, 'Su{{Sunday}}'),
(10787, 'Svc Date'),
(10788, 'Svc Date:'),
(10789, 'Swahili'),
(10790, 'Swati'),
(10791, 'Sweating:'),
(10792, 'Swedish'),
(10793, 'Swelling'),
(10794, 'Swelling Right'),
(10795, 'Swollen Joints'),
(10796, 'Swollen Lymph Nodes'),
(10797, 'Symbol used as the decimal point for currency. Not used if Decimal Places is 0.'),
(10798, 'Symbol used to separate thousands for currency.'),
(10799, 'Symptoms'),
(10800, 'Sync Frequency'),
(10801, 'Synchronization with MedEx is paused'),
(10802, 'Synchronize'),
(10803, 'Synchronize translations with custom language table.'),
(10804, 'Synchronized new custom constant:'),
(10805, 'Synchronized new custom language:'),
(10806, 'Synchronized new definition (Language, Constant, Definition):'),
(10807, 'Syncope'),
(10808, 'Syndromic Surveillance'),
(10809, 'Syndromic Surveillance - Non Reported Issues'),
(10810, 'Syndromic Surveillance Report'),
(10811, 'Synovitis, impingement, bursitis'),
(10812, 'System'),
(10813, 'System Error Logging Options'),
(10814, 'System Error Logging Options.'),
(10815, 'system, user, and offline_access scopes require confidential app permissions.'),
(10816, 'Systolic'),
(10817, 'S{{Saturday}}'),
(10818, 's{{suffix to make Document plural, ie. Documents}}'),
(10819, 'S{{Sunday}}'),
(10820, 'T'),
(10821, 'T-Score'),
(10822, 't.i.d.'),
(10823, 'T.V.'),
(10824, 'Tab Log'),
(10825, 'Table'),
(10826, 'Table Action'),
(10827, 'Table Args'),
(10828, 'Table Code'),
(10829, 'Table creation failed'),
(10830, 'Table update failed'),
(10831, 'Tables'),
(10832, 'tablet'),
(10833, 'Tabs'),
(10834, 'Tabs Layout Theme'),
(10835, 'Tabs Layout Theme (need to logout/login after change this setting)'),
(10836, 'Tag to Encounter'),
(10837, 'Tag to Image Procedure'),
(10838, 'Tag to Procedure'),
(10839, 'Tagalog'),
(10840, 'Tagline text on the login page'),
(10841, 'Tahitian'),
(10842, 'Tajik'),
(10843, 'Take'),
(10844, 'Take care and click on the black + sign on the Electrolyte Panel line to create these Discrete Results'),
(10845, 'Take Insurance, from Drop Down'),
(10846, 'Take Payment From, from Drop Down'),
(10847, 'Takeback'),
(10848, 'Takes long'),
(10849, 'Takes you to the Register Time Based One Time Password Key - TOTP page'),
(10850, 'Takes you to the Register Universal 2nd Factor Key - U2F page'),
(10851, 'Tall Navigation Area'),
(10852, 'Tamil'),
(10853, 'Tamper Date'),
(10854, 'Tampered Checksum'),
(10855, 'Target and source DOB do not match'),
(10856, 'Target and source pid may not be the same!'),
(10857, 'Target and source SSN do not match'),
(10858, 'Target Date'),
(10859, 'Target Patient'),
(10860, 'Target patient has no DOB'),
(10861, 'Target patient not found'),
(10862, 'Target/Action Groups'),
(10863, 'Targets'),
(10864, 'Taskman: Documents in openEMR'),
(10865, 'Tatar'),
(10866, 'Tax Id'),
(10867, 'Tax ID'),
(10868, 'Tax Rate'),
(10869, 'Taxes'),
(10870, 'Taxonomy'),
(10871, 'TA{{temporal arteries}}'),
(10872, 'TB'),
(10873, 'TBUT'),
(10874, 'TBUT{{tear breakup time}}'),
(10875, 'Td'),
(10876, 'Team Injury Overview'),
(10877, 'Team Roster'),
(10878, 'Team Roster View'),
(10879, 'Team/Squad'),
(10880, 'Tear Break Up Time'),
(10881, 'Tel'),
(10882, 'Telehealth'),
(10883, 'Telephone'),
(10884, 'Telephone Country Code'),
(10885, 'Tell me more'),
(10886, 'Telugu'),
(10887, 'Temp'),
(10888, 'Temp Location'),
(10889, 'Temp Method'),
(10890, 'Temp. Art.{{temporal arteries}}'),
(10891, 'Temperature'),
(10892, 'Template'),
(10893, 'Template Actions'),
(10894, 'Template Category successfully changed to new Category'),
(10895, 'Template Maintenance'),
(10896, 'Template Name'),
(10897, 'Template names cannot start with numbers.'),
(10898, 'Template Repository'),
(10899, 'Template selector changed'),
(10900, 'Template Uploads'),
(10901, 'Template:'),
(10902, 'Templates'),
(10903, 'Templates are automatically uploaded to the Template Repository. All actions on template disposal such as sending templates based on what locations are selected from the Scope bar or selecting Profiles to activate in portal, will be carried out here.'),
(10904, 'Templates Successfully sent to Locations.'),
(10905, 'Temporal Art.{{Temporal Artery}}'),
(10906, 'Temporal Arteries'),
(10907, 'Temporal Artery'),
(10908, 'Temporary Lodging'),
(10909, 'temp{{temporal}}'),
(10910, 'Tendon injury'),
(10911, 'Tendonitis / osis / bursitis'),
(10912, 'Tension'),
(10913, 'Tentative Invoice Ref No'),
(10914, 'Terms and Conditions'),
(10915, 'Tertiary'),
(10916, 'Tertiary Insurance'),
(10917, 'Tertiary Insurance Data'),
(10918, 'Tertiary Insurance provider'),
(10919, 'Test'),
(10920, 'Test Code Information'),
(10921, 'Test only, skip updates'),
(10922, 'Test Ordered'),
(10923, 'Test Scheduling'),
(10924, 'Test System'),
(10925, 'Test Value'),
(10926, 'Test/Order'),
(10927, 'Test/Screening'),
(10928, 'Tests Performed'),
(10929, 'Text'),
(10930, 'Text Diagnosis'),
(10931, 'Text field'),
(10932, 'Text for Custom statement message.'),
(10933, 'Text for fifth account message.'),
(10934, 'Text for first account message.'),
(10935, 'Text for fourth account message.'),
(10936, 'Text for second account message.'),
(10937, 'Text for third account message.'),
(10938, 'Text Message permission'),
(10939, 'Text Templates'),
(10940, 'Text-date'),
(10941, 'text-date'),
(10942, 'Textarea'),
(10943, 'textarea'),
(10944, 'Textbox'),
(10945, 'textbox'),
(10946, 'Textbox list'),
(10947, 'textbox list'),
(10948, 'Thai'),
(10949, 'Thank You'),
(10950, 'Thank you'),
(10951, 'Thank you for allowing us to serve you.'),
(10952, 'Thank you for choosing'),
(10953, 'Thank You.'),
(10954, 'The \'Clear\' button will remove all annotations.'),
(10955, 'The \'Edit\' window is divided into two columns, \'Active\' and \'Inactive\'. The groups (AROs) that are listed in the active column are those groups that the user belongs to.'),
(10956, 'The \'Select Codes\' section will now have all the CPT and ICD codes that you entered grouped under the categories that you had decided upon'),
(10957, 'The *Tab* key creates each entry.'),
(10958, 'The 1500 Claim Form may also be used to report patient encounter data to federal, state, and/or other public health agencies'),
(10959, 'The 837P (Professional) is the standard format used by health care professionals and suppliers to transmit health care claims electronically'),
(10960, 'The ability to link individual issues to patient encounters will let the user quickly determine the outcome of the issue over time'),
(10961, 'The above statement failed'),
(10962, 'The ACL page two sections.'),
(10963, 'The actual amounts that will be displayed must exist in the database'),
(10964, 'The actual tests or procedures that can be searched for and ordered are highlighted in yellow'),
(10965, 'The Add icon is used to setup a tier that will be a direct descendant of this tier'),
(10966, 'The advantage of integrating the results with the patient\'s chart as structured data is the ability to manipulate it to see trends in one convenient location, to plot graphs with the data and use it in data analysis'),
(10967, 'The advantage of scanning the results into the chart is simplicity - no setup is required other than defining a directory/folder in the patient\'s chart under Documents where the result will be stored. Being unstructured data it does not have the above advantages and will not fulfill Meaningful Use criteria for Computerized Provider Order Entry (CPOE)'),
(10968, 'The Allscripts solution integrates the Allscripts ePrescribe web site with openEMR'),
(10969, 'The American Medical Association has defined 9 panels that can be ordered. Each panel contains several tests grouped together'),
(10970, 'The amount will be displayed in either the Payment or Adjustment column as the case may be'),
(10971, 'The Apache SSL server certificate and public key'),
(10972, 'The application generates challenge - a random number and passes it to the USB key along with the nonce and checksum stored in the application'),
(10973, 'The application then uses the public key that the USB device sent on registration to verify the response'),
(10974, 'The appointment status changes and encounter creations are managed through the Patient Tracker.'),
(10975, 'The Auth Name or API key for selected account. Auth Name for Authorize.Net and API Secret for Stripe.'),
(10976, 'The Balance column would be empty'),
(10977, 'The basic purpose of the authenticator app is to generate a 20 bytes (160 bits) code encoded in base32 using a secure hash function, SHA-1, and is called HMAC-SHA1 (Hash-based Message Authentication Code)'),
(10978, 'The basis for CCR is a Patient Care Referral Form developed by the Massachusetts Department of Public Health'),
(10979, 'The Billed Date/Payor column will show the date the line item payment was received and the Payor name - either insurance or patient'),
(10980, 'The Billed Date/Payor column will show the date the line item was billed and the Payor - either insurance or patient'),
(10981, 'The Body contains the clinical data that may be structured and organized as one or more sections or may be an unstructured blob of data'),
(10982, 'The Body Site, Administer Via and Laterality boxes can be left as Unassigned'),
(10983, 'The bottom group consists of the Copays'),
(10984, 'The Category column will be Custom Top Group and will be highlighted in pink'),
(10985, 'The Category column will say Order indicating that it is an order'),
(10986, 'The Category will be Result'),
(10987, 'The CDA is a plain text document that is coded using the Extensible Markup Language (XML) and contains a Header and Body'),
(10988, 'The Certificate Authority certificate'),
(10989, 'The Charge column would be blank'),
(10990, 'The Charge will be the actual amount being charged for each line item'),
(10991, 'The claim file: '),
(10992, 'The CMS 1500 form has 33 boxes and is divided into two sections'),
(10993, 'The Code column should have 905, the vendor specific Identifying code that was entered previously'),
(10994, 'The Code column will be empty as items listed as a Group are not used in the actual reporting of results and therefore do not have a distinct code number'),
(10995, 'The Code will be R905, the Identifying Code value that was entered for the Discrete Result'),
(10996, 'The code you entered was not valid'),
(10997, 'The compatible staged US Extension SNOMED package has already been installed.'),
(10998, 'The Contacts cell has various bits of contact information like phone numbers, email etc'),
(10999, 'The Continuity of Care Document (CCD) and Continuity of Care Record (CCR) were both selected as acceptable formats to extract information for clinical care summaries as a part of Meaningful Use Stage 1'),
(11000, 'The Continuity of Care Record (CCR) has been developed jointly by ASTM International - an organization that is involved in the development and delivery of voluntary consensus, the Massachusetts Medical Society (MMS), the Health Information Management and Systems Society (HIMSS), the American Academy of Family Physicians (AAFP), and the American Academy of Pediatrics'),
(11001, 'The Continuity of Care Record (CCR) is the clinical record of the patient’s current and historical health care status'),
(11002, 'The core dataset consists of'),
(11003, 'The corresponding private key'),
(11004, 'The created report can contain as much or as little information based on the need'),
(11005, 'The Current Authentication Method for the logged in user section will now feature the activated methods'),
(11006, 'The Current Authentication Method lists all the methods that are active'),
(11007, 'The custmomized Fee Sheet can be used. If and when you come across a code that is not there in the custom \'Select Codes\' section you can always use the \'Search for Additional Codes\' section'),
(11008, 'The Custom Favorite Item Tier should be the direct descendant or child of the relevant Custom Favorite Group'),
(11009, 'The custom grouping will also let you group two recognized panel of tests into a custom group and thus order them together, e.g. a custom group of Preop Labs may contain two panels, CBC and Renal Panel'),
(11010, 'The dashboard is the central location for convenient access the patient\'s medical record'),
(11011, 'The Dashboard page is divided into three sections'),
(11012, 'The data integrity test failed for this form'),
(11013, 'The data section of the dashboard page lists all pertinent items related to a patient'),
(11014, 'The dated reminder will start to appear 5 days before the reminder date under Dated Reminders '),
(11015, 'The default code type to search for in the Fee Sheet.'),
(11016, 'The default fee sheet can be modified and customized to make it more useful.'),
(11017, 'The default fee sheet is divided into several sections and is designed to be filled from top to bottom with the save button at the very end.'),
(11018, 'The default form can be customized by editing it in Administration > Layouts'),
(11019, 'The default has two buttons that is set for \'New Patient\' and \'Established\' patient'),
(11020, 'The default installation has six such groups - Accounting, Administrators, Clinicians, Emergency Login, Front Office and Physicians.'),
(11021, 'The default installation has the following items'),
(11022, 'The default installation lists 5 types of issues that can be documented'),
(11023, 'The default installation will not make the phone call automatically'),
(11024, 'The default is \'Standard\' usually used to reflect rates charged for insurance billing. You can have a different amount charged for credit card payment and for cash payment'),
(11025, 'The default is Normal, i.e. it is visible to everyone. Selecting High will restrict it to users belonging to the Physicians and Administrators groups by default'),
(11026, 'The default issue type is set to Problem'),
(11027, 'The default messaging center is divided into three sections - Messages, Reminders and Recalls'),
(11028, 'The default values for the rendering providers can be set'),
(11029, 'the Denial code is'),
(11030, 'the Denial Group code is'),
(11031, 'The Description column displays the short description that was entered, Serum chemistry tests'),
(11032, 'The Description column will reflect the description value that was entered previously'),
(11033, 'The Description should say Serum Uric Acid result'),
(11034, 'The Description will detail the type of payment or adjustment - Cash, Check, Electronic etc '),
(11035, 'The destination form was closed'),
(11036, 'The destination form was closed.'),
(11037, 'The destination form was closed; I cannot act on your selection.'),
(11038, 'The difference between the two is that for a panel of tests that are ordered together the individual tests are represented by Discrete Result only and these tests cannot be ordered separately unless they have also been setup as single tests'),
(11039, 'The Discrete result Tier must be the direct descendant or child of a Procedure Order Tier for proper display of results'),
(11040, 'The Discrete Results for each panel will contain the names of the individual tests to hold the values of the returned results - WBC, Hemoglobin, Platelets, Sodium, Potassium etc'),
(11041, 'The display window can be resized by clicking and dragging the bottom right corner of the window'),
(11042, 'The Each Appointment option will allow a new encounter regardless of same day visit.'),
(11043, 'The Encounter Preview button is useful for showing encounter type layout forms as seen when using form in an encounter. Note, this feature is only useful for showing encounter forms and won\'t display system forms like Demographics'),
(11044, 'The Encounters Section will display the date of encounter as well as the presenting complaint'),
(11045, 'The end result was a confusing collection of documents containing ambiguous and/or conflicting information'),
(11046, 'The Enter Details pop-up box will open in the Add Mode'),
(11047, 'The Enter Provider Details pop-up will be visible'),
(11048, 'The entire collection of ACOs forms the Access Control List (ACL).'),
(11049, 'The entity for a Custom Favorite Item is the entity chosen for the Custom Favorite Group and cannot be changed'),
(11050, 'The entity performing this procedure'),
(11051, 'The Entries contain data used for further computer processing'),
(11052, 'The entries highlighted in yellow can be ordered as a test or procedure those highlighted in pink can be ordered as a Custom Group'),
(11053, 'The EP, eligible hospital or CAH who receives a patient from another setting of care or provider of care or believes an encounter is relevant should perform medication reconciliation.'),
(11054, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral (Measure A).'),
(11055, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral (Measure B).'),
(11056, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral.'),
(11057, 'The event(s) have been approved.'),
(11058, 'The event(s) have been hidden.'),
(11059, 'The exported data appears in the text area below.  You can copy and paste this into an email or to any other desired destination.'),
(11060, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination (or) download the below link.'),
(11061, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination.'),
(11062, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination.{{MARK FOR DELETION DURING NEXT TRANSLATION BUILD}}'),
(11063, 'The features of a MedEx enabled installation are explained in this video'),
(11064, 'The file cannot be generated again. Do you want to proceed?'),
(11065, 'The file could not be saved to CouchDB.'),
(11066, 'The file could not be succesfully renamed, this error is usually related to permissions problems on the storage system.'),
(11067, 'The file could not be succesfully stored, this error is usually related to permissions problems on the storage system'),
(11068, 'The filter section can be hidden or revealed by clicking the arrowhead  on the bottom right '),
(11069, 'The filtered results will show up in the section below it'),
(11070, 'The finder table is grouped by past procedures then diagnosis code. Although there may be duplicate dx codes, they will be grouped with the appropriate procedure making building diagnoses list easier.'),
(11071, 'The first (\"target\") chart is the one that is considered the most complete and accurate. Demographics, history and insurance sections for this one will be retained.'),
(11072, 'The first column contains the Group/Category name that will be displayed on the button'),
(11073, 'The first column is the name that you gave this entry, i.e. Serum Chemistry. A vertical bar will precede the actual name. That indicates that there are no descendants or children to this entry'),
(11074, 'The first four sections deal with creating procedure orders in a structured manner in order to facilitate easy ordering of tests and entering the returned results manually'),
(11075, 'The first line will show the Encounter date and Reason as well as the Provider for that encounter'),
(11076, 'The first section lets you either link this message to a patient if so desired.'),
(11077, 'The first Segment in every HL7 Message is always the Message Header, a Segment that conveys the metadata of the message like who sent it and when. The Message header is indicated in the first three letters of the segment as MSH'),
(11078, 'The first step is signing up for a production Direct messaging account with EMR Direct by registering on their website'),
(11079, 'The first step is to download the SNOMED CT release. Access to SNOMED CT is provided by IHTSDO and their member countries. For more information see'),
(11080, 'The first step is to download the VALUESET release. Access to VALUESET is provided by NLM. Only valueset for Eligible Professionals need to be downloaded and it should be downloaded in XML format from Sorted By CMS ID column. For more details see the below link'),
(11081, 'The first step is to open an account with the Unified Medical Language System web site'),
(11082, 'The first step is to plan what your Fee Sheet \'Select Codes\' section should display'),
(11083, 'The first step is to select a Transaction type'),
(11084, 'The first step would be to create a top level entry. Do so by clicking on Add Top Level button'),
(11085, 'The first tab is the referral tab that constitutes the referral being made'),
(11086, 'The first two numbers in the first and second colum will be used to determine the sort order of the buttons and the lists that are present in the popup'),
(11087, 'The following calendar event has been added:'),
(11088, 'The following calendar event has been modifed:'),
(11089, 'The following categories will be removed from your category List'),
(11090, 'The following database release is currently installed'),
(11091, 'The following documents were attached to this Direct message:'),
(11092, 'The following EDI file failed save to archive'),
(11093, 'The following EDI file has been uploaded'),
(11094, 'The following EDI file upload failed to open'),
(11095, 'The following Emergency Login User is activated:'),
(11096, 'The following errors occurred'),
(11097, 'The following field has an invalid value'),
(11098, 'The following fields are empty.'),
(11099, 'The following fields are required'),
(11100, 'The following fields have to be filled to send a request.'),
(11101, 'The following fields have to be filled to send request.'),
(11102, 'The following International Snomed Release languages are supported'),
(11103, 'The following items are required for System Scopes'),
(11104, 'The following occurred'),
(11105, 'The following problems have the same diagnosis codes. Encounter issues will not be updated. Please use the encounter interface instead.'),
(11106, 'The following steps will help customize the Fee Sheet to mimic the old paper superbill with a list of CPT4 and ICD codes arranged in categories'),
(11107, 'The group (ARO) that you created will now appear in alphabetical order in the \'Groups and Access Controls\' section.'),
(11108, 'The Header defines the context for the clinical document as a whole'),
(11109, 'The header section will reveal patient specific information across most pages related to the patient\'s medical record'),
(11110, 'The Health Insurance Claim Form is often referred to by its form number CMS 1500 (HCFA 1500)'),
(11111, 'The help file is divided into the following sections'),
(11112, 'The help file there will guide you on further steps in setting up the lab tests'),
(11113, 'The help icon will let you access context sensitive help for each of the pages accessed'),
(11114, 'The hostname of the ATNA audit repository machine.'),
(11115, 'The hostname or URI of your LDAP or Active Directory server.'),
(11116, 'The Identifying Code has to be unique in order for the results to display correctly, you could just use R905 as an example'),
(11117, 'The Identifying code has to be unique, if sending to an external lab the vendor supplied Identifying Code has to be entered. We will enter an arbitrary unique value - WWT01'),
(11118, 'The Identifying Code is a vendor-specific code identifying this procedure or result. You can see examples of it in the paper lab slips that the labs use'),
(11119, 'The Identifying Code is essential for the proper display and tabulation of results'),
(11120, 'The Identifying Code of R34392-1, an arbitrary number, in this case the Identifying Code preceded by R to indicate result and succeeded by 1 to indicate the first in the sequence, it could be anything unique you choose'),
(11121, 'The information entered here is used to display a summary of the encounter. It is also used for billing purposes'),
(11122, 'The information entered in this form will be used to complete a paper claim'),
(11123, 'The information provided in the New Encounter Form and Fee Sheet in openEMR is used to generate the paper claim as well as electronic claims'),
(11124, 'The initial efforts led to the creation of duplicative and conflicting Implementation Guides (IGs) published by different standards organizations'),
(11125, 'The initial screen lets you select a method by offering you these two options.'),
(11126, 'The initial window is the invoice search page.  At the top you may enter a source (e.g. check number), pay date and check amount.  The reason for the source and pay date is so that you don\'t have to enter them over and over again for each claim.  The amount that you enter will be decreased for each invoice that is given part of the payment, and hopefully will end at zero when you are done.'),
(11127, 'The input should be a CSV file with 3 columns: layout ID, code type and code.'),
(11128, 'The installation directory needs to be created.'),
(11129, 'The installed International SNOMED version is not compatible with the staged US Extension SNOMED package.'),
(11130, 'The installed International SNOMED version is out of date and not compatible with the staged US Extension SNOMED file.'),
(11131, 'The installed version and the staged files are the same.'),
(11132, 'The installed version is a more recent version than the staged files.'),
(11133, 'The Instruction manual on how to fill the CMS 1500 form can be found here'),
(11134, 'The IP address of your domain controller(s).'),
(11135, 'The Issues can be entered in one of two ways'),
(11136, 'The Issues section will display all the issues entered for the patient and will display the type of issue, its title and a description'),
(11137, 'The items listed in the \'Active\' column delineate the privileges of this group (ARO) and constitutes this group\'s Access Control List (ACL).'),
(11138, 'The items that have asterisks after them are mandated'),
(11139, 'The job id you submitted was invalid'),
(11140, 'The label that appears to the user on the form'),
(11141, 'The last cell on the line in Encounter'),
(11142, 'The last line of this encounter block will give the encounter totals of Charges, Payments, Adjustments and the Balance'),
(11143, 'The last section deals with electronic orders'),
(11144, 'The last visit date will automatically be filled'),
(11145, 'The latest version is FHIR – Fast Healthcare Interoperability Resources – is a next generation standards framework created by HL7. This is gaining popularity but has not yet been widely implemented'),
(11146, 'The legacy code finder is still available for codes not found in this finder or code list editing.'),
(11147, 'The length should not exceed the following number of characters'),
(11148, 'The log entry with following id has been deleted'),
(11149, 'The log has'),
(11150, 'The log table will show a list of both messages and dated reminders if any'),
(11151, 'The LOINC code for serum uric acid is 3084-1, LOINC refers to it as Urate in Serum or Plasma'),
(11152, 'The merge will not run unless SSN and DOB for the two charts are identical. DOBs cannot be empty.'),
(11153, 'The message could not be sent at this time.'),
(11154, 'The message status will be New as it a new message that is being created'),
(11155, 'The messages that were sent by the user on that day will be displayed in the table below'),
(11156, 'The messaging center conveniently consolidates communications options in one place'),
(11157, 'The messaging center will open with the Messages tab activated and will display the logged in user\'s messages as indicated by the caption My Messages'),
(11158, 'The minimum information required to create a new encounter is to select a visit category'),
(11159, 'The miscellaneous billing options for HCFA-1500 form is used to provide additional information for an individual claim'),
(11160, 'The most common method is called 2-Factor Authorization or 2FA'),
(11161, 'The most important issue that needs to be addressed is who you are trying to connect to and what needs to happen at their end. Most major labs will not deal with individuals practices, in such cases a third party vendor will act an an intermediary who will be responsible for setting up a connection between the practice and the lab through their (the intermediary\'s) interface'),
(11162, 'The most popular maker of Security Keys is Yubico it offers regular USB versions as well as those made for devices that require USB-C connections, such as Apple’s newer Mac OS systems'),
(11163, 'The most popular open-source Electronic Health Record and Medical Practice Management solution.'),
(11164, 'The Name cell contains the name, date of birth, patient ID and date of last visit'),
(11165, 'The Narrative Block contains information that is rendered as readable text'),
(11166, 'The National Uniform Claim Committee (NUCC) is responsible for the maintenance of the 1500 Claim Form'),
(11167, 'The Nav Bar allows one to quickly navigate to various parts of the patient\'s medical record'),
(11168, 'The new category will be a sub-category of '),
(11169, 'The new list'),
(11170, 'The new password can not be the same as the current password.'),
(11171, 'The new password fields are not the same.'),
(11172, 'The new password is the same as the current password. Click Okay to accept anyway.'),
(11173, 'The NewCrop eRx Partner Name, NewCrop eRx Name and NewCrop eRx Password will be provided by the vendor'),
(11174, 'The next box is Body Site, not relevant for a blood test but may be more useful in say tracking injections or ordering X-rays'),
(11175, 'The next few lines will list all the E/M and CPT codes that were billed, one line per code'),
(11176, 'The next group consists of the ICD codes'),
(11177, 'The next three cells are the action cells that let you perform some recall activity'),
(11178, 'The next two boxes denoting the Identifying Code and Standard Code are very important'),
(11179, 'The Notes cell lets you add a note to an action that you take in the 3 action cells or just a note without any association to the action'),
(11180, 'The Number of Future Appointments to Display on the Statement.'),
(11181, 'The number of staged files is incorrect. Only place the file that you wish to install/upgrade to.'),
(11182, 'The number of staged files is incorrect. Only place the files that you wish to install/upgrade to.'),
(11183, 'The Office: Phone cell lets you indicate a phone call was made'),
(11184, 'The option Span Entire Row is useful when using Static Text in allowing text to wrap and span entire row regardless of column settings. Another use could be to create an empty row as spacer or add additional option Add Bottom Border to create a line break.Only Bottom Border Row is useful here.'),
(11185, 'The options for Outline and Border will either wrap a row in thin border or add a border to the bottom of an item.'),
(11186, 'The order in which the Category, Procedure or Result appears'),
(11187, 'The other 4 transaction types are simple transaction types - Patient Request, Physician Request, Legal and Billing'),
(11188, 'The other Segments contain additional information in a strictly structured fashion'),
(11189, 'The page will be redirected to Demographics. You can edit the country field and clickthrough to NewCrop again.'),
(11190, 'The page you requested was not found. Please check that you typed the URL correctly.'),
(11191, 'The parts of the program to which access can be controlled are called Access Control Objects (ACOs). '),
(11192, 'The password must be at least eight characters, and should'),
(11193, 'The password you entered is invalid'),
(11194, 'The Past Ocular History (POH) and Past Medical History (PMH) are negative.'),
(11195, 'The patient already registered to the group'),
(11196, 'The patient record request has been recorded.'),
(11197, 'The patient reminders have been sent'),
(11198, 'The patient reminders have been updated'),
(11199, 'The patient was not logged in when submitting this form'),
(11200, 'The patient will have to change their credentials at the first login'),
(11201, 'The Patients Rights'),
(11202, 'The Payment, Adjustment and Balance will be blank as these lines reflect only the charges being made'),
(11203, 'The payments posted cannot go below this date.This ensures that after taking the final report nobody post for previous dates.'),
(11204, 'The pop-up form heading will now read Enter Details for Individual Custom Favorite Item'),
(11205, 'The portal has data for this patient and form. Load it now?'),
(11206, 'The previous message can however be viewed by clicking on the View Log button'),
(11207, 'The Procedure Order page lists the following procedure types'),
(11208, 'The procedure request needs to be structured in a hierarchical manner and a unique identifying code assigned to it that will then be used to track and tabulate the result'),
(11209, 'The Procedures module is used to place and review orders'),
(11210, 'The process for forwarding the message is quite similar to that of creating a new message'),
(11211, 'The Progress cell lists all the actions along with any associated notes if any'),
(11212, 'The providers office has been notified. Thank you.'),
(11213, 'The public access key for secure tokenize of credit or debit card authorization. PCI compliance'),
(11214, 'The QR code also contains the user name and needs to be captured by the user on to their mobile device using an authenticator app'),
(11215, 'The raw data feed release can be obtained from'),
(11216, 'The Recall cell has the date of recall and the reason for recall'),
(11217, 'The Recalls tab has two buttons New Recall and Recall Board'),
(11218, 'The Recommendation Tier is optional'),
(11219, 'The remaining information below applies only if you are posting manually, or if you are doing manual corrections.'),
(11220, 'The reminder for the current day will have an orange exclamation icon'),
(11221, 'The reminders that are past the due date will have a red exclamation triangle icon'),
(11222, 'The requested document is not present at the expected location on the filesystem or there are not sufficient permissions to access it'),
(11223, 'The requested document is not present at the expected location on the filesystem or there are not sufficient permissions to access it.'),
(11224, 'The rest may be left blank if so preferred'),
(11225, 'The rest of the boxes related to the NewCrop eRx service can be left at default values'),
(11226, 'The Result Line will begin with a Name Serum Uric Acid that will be preceded by a vertical bar indicating no successors or children'),
(11227, 'The results could not be loaded'),
(11228, 'The results, Discrete Result, will be the fruit on this branch and we will create one such Discrete Result for each of the component tests, Sodium, Potassium, Chloride and Carbon Dioxide'),
(11229, 'The rows containing the CPT4 codes has several boxes that need to be filled to ensure proper billing of claims'),
(11230, 'The saved Medical Problem will now be listed as a single line in the main Issues page under Medical Problems'),
(11231, 'The Scope toolbar is global to the entire view. It consists of Location, Category and action buttons.'),
(11232, 'The screen refresh time in Seconds for the Patient Flow Board Screen.'),
(11233, 'The search field cannot be empty. Please enter a search term'),
(11234, 'The Search results are displayed in the section \'Search Results\'.'),
(11235, 'The second (\"source\") chart will have its demographics, history and insurance sections discarded.  Its other data will be merged into the target chart.'),
(11236, 'The second column contains the options that will be displayed when the button is clicked'),
(11237, 'The second column is Category and should say Top Group to indicate its position as the top item in this particular hierarchical tree that we will be constructing'),
(11238, 'The second section lets you choose to whom you wish to send the message'),
(11239, 'The second tab, is somewhat ambiguously named as Counter-Referral, is the place to document the received reply to the referral being made'),
(11240, 'The section labeled \'Invoice Search\' is where you put in your search parameters. You can search by patient name, chart number, encounter number or date of service, or any combination of these. You may also select whether you want to see all invoices, open invoices, or only invoices that are due (by the patient). Click the \'Search\' button to perform the search.'),
(11241, 'The selected code will be added to the coding text-box and the Description on the code will be added to the Title text-box'),
(11242, 'The selected codes will then appear in the \'Selected Fee Sheet Codes and Charges for Current Encounter\' section'),
(11243, 'The selections in this section will be used in charging for this encounter'),
(11244, 'The sequence is the order in which this top order item will be displayed on the page, 1 to denote the first top level group'),
(11245, 'The server address will be of the form '),
(11246, 'The setup for lab tests will be described in detail, minor modification to these steps will be needed to setup in-office procedures and other procedure types'),
(11247, 'The somewhat ambiguously named Counter-Referral is the space where the reply to the referral being made can be documented'),
(11248, 'The Source and Date columns are copied from the first page, so normally you will not need to touch those.  You can put a payment amount in the Pay column, an adjustment amount in the Adjust column, or both.  You can also click the \"W\" on the right to automatically compute an adjustment value that writes off the remainder of the charge for that line item.'),
(11249, 'The Source and Date columns are copied from the first page, so normally you will not need to touch those. You can put a payment amount in the Pay column, an adjustment amount in the Adjust column, or both. You can also click the \'W\' on the right to automatically compute an adjustment value that writes off the remainder of the charge for that line item.'),
(11250, 'The Specimen Type will be Blood, this drop-down list can also be edited as needed'),
(11251, 'The staged files release dates are not all from the same release.'),
(11252, 'The staged files revisions are not all from the same release.'),
(11253, 'The staged US Extension SNOMED package can not be installed until after the International SNOMED package has been installed.'),
(11254, 'The Standard Code is optional if using a local i.e. practice based lab but recommended when using an external lab'),
(11255, 'The Standard Code will be the LOINC code if sending to an external lab or can be any unique number. We will enter the LOINC code for Fasting Glucose 1558-6'),
(11256, 'the status of three chronic/inactive problems'),
(11257, 'The subsequent lines will indicate the details of the payments received, adjustments made and the balance due'),
(11258, 'The suffix of the account.'),
(11259, 'The system does not permit uploading files of with size 0.'),
(11260, 'The system does not permit uploading files with MIME content type'),
(11261, 'The system is also designed to parse incoming HL7 messages and place the results in the appropriate patient chart, failing which it will give you an opportunity to manually link it to a patient chart'),
(11262, 'The system is designed to both place orders electronically and receive the results electronically'),
(11263, 'The third column will contain the CPT code'),
(11264, 'The Tier column value will be 1 indicating it is a top level item'),
(11265, 'The Tier column value will be 3, indicating this is a successor or child to the first line above it having a value of 2'),
(11266, 'The Tier column will be 2, indicating this is a successor or child to the first line above it having a value of 1'),
(11267, 'The Tier Column would be 1 indicating it is the Top Group'),
(11268, 'The time granularity of the calendar and the smallest interval in minutes for an appointment slot.'),
(11269, 'The Title will be the name of the new group (ARO) that you are going to create.'),
(11270, 'The top group consists of charges for the encounter - one row per charge'),
(11271, 'The top portion of the Recall Board allows the setting of filters to display specified data'),
(11272, 'The traditional mechanism of using a login and password is no longer considered to be sufficient to prevent an unauthorized user from gaining access to the application'),
(11273, 'The Transaction ID for the credit was'),
(11274, 'The transaction_id for the void was'),
(11275, 'The translated label that will appear on the form in current language'),
(11276, 'The translated Title that will appear in current language'),
(11277, 'The translation of description in current language'),
(11278, 'The translation tables are synchronized.'),
(11279, 'The type of this entity'),
(11280, 'The Type will be blank'),
(11281, 'The Type will Insurance or Patient'),
(11282, 'The Type would be Allergy'),
(11283, 'The Type would be Dental Issues'),
(11284, 'The Type would be Medication'),
(11285, 'The Type would be Problem indicating a medical problem'),
(11286, 'The Type would be Surgery'),
(11287, 'The UB-04 (CMS 1450) is a claim form used by hospitals, nursing facilities, in-patient, and other facility providers'),
(11288, 'The Unit column would be blank'),
(11289, 'The Units will be 1 as each code is billed only once for the encounter'),
(11290, 'The upcoming reminders have a green exclamation icon'),
(11291, 'The USB devices communicate with the host computer using the human interface device (HID) protocol, essentially mimicking a keyboard'),
(11292, 'The USB key needs to be plugged in to the computer and then registered with OpenEMR'),
(11293, 'The USB key takes this the nonce supplied by the application after confirming the checksum and generates a private key using the process similar to that used in the registration process'),
(11294, 'The user\'s actual privileges are determined by the access to the parts of the program i.e. (ACO) that each group (ARO) has.'),
(11295, 'The Username fields are not the same.'),
(11296, 'The Username is your Direct Address'),
(11297, 'The values in the drop-down box can be edited by following the steps outlined in the Procedures > Providers help file'),
(11298, 'The values listed here will show up in the drop-down boxes that will be used to process orders'),
(11299, 'The vendor-specific code identifying this procedure or result'),
(11300, 'The vendor-specific code identifying this procedure or result. If no vendor enter any arbitrary unique number, preferably a 5 digit zero-padded e.g. 00211'),
(11301, 'The very first step would be install the ICD codes. Go to Administraion > Other > External Data Loads. Select the Code sets you want to install and click Install'),
(11302, 'The very last line of this report will give the Grand Total of Charges, Payments, Adjustments and the Balance'),
(11303, 'The Weno Exchange is well integrated with openEMR and is not subscription based'),
(11304, 'The X12 files as well as the resulting HTML output reports are archived in the \"era\" subdirectory of the main OpenEMR installation directory.  You will want to refer to these archives from time to time.  The URL is '),
(11305, 'The X12 files as well as the resulting HTML output reports are archived in the \'era\' subdirectory of the main OpenEMR installation directory. You will want to refer to these archives from time to time.'),
(11306, 'The zip file will contain the following items'),
(11307, 'Theme'),
(11308, 'Theme of the tabs layout (need to logout and then login to see this new setting).'),
(11309, 'Theme of the tabs layout (need to logout and then login to see this new setting). Note this is only applicable if use the Light or Manila general theme below.'),
(11310, 'Then pass it\'s name as a value to the element'),
(11311, 'Then press the flashing button on your key within 1 minute to complete registration'),
(11312, 'Then press the flashing button on your key within 1 minute.'),
(11313, 'Then the raw data feed release can be obtained from'),
(11314, 'Therapeutic Injections'),
(11315, 'Therapy'),
(11316, 'Therapy group'),
(11317, 'Therapy Group'),
(11318, 'Therapy Group Encounter'),
(11319, 'Therapy Group Finder'),
(11320, 'There are'),
(11321, 'There are 10 settings that are related to procedures included in the standard release of openEMR'),
(11322, 'There are 3 forms in the Core category - Demographics, Facility Specific User Information and History and all 5 forms in Transactions that can be edited '),
(11323, 'There are currently no prescriptions'),
(11324, 'There are errors with your submission.  These are outlined below.'),
(11325, 'There are four message statuses - New, Forwarded, Read and Done'),
(11326, 'There are multiple options regarding patient portals and information on how to setup the patient portal is available here'),
(11327, 'There are multiple patients with portal login'),
(11328, 'There are nine C-CDA templates that are currently defined'),
(11329, 'There are no charts checked out.'),
(11330, 'There are no clients registered in the system'),
(11331, 'There are no disclosures recorded for this patient.'),
(11332, 'There are no Glasses or Contact Lens Presciptions on file for this patient'),
(11333, 'There are no messages on file for this patient.'),
(11334, 'There are no New Submissions'),
(11335, 'There are no notes on file for this patient.'),
(11336, 'There are no record(s) found.'),
(11337, 'There are no transactions on file for this patient.'),
(11338, 'There are several versions of HL7, versions 2.x and version 3'),
(11339, 'There are several ways to customize the fee sheet. It depends on how comfortable you are in adding information to the database itself'),
(11340, 'There are three actions that are possible - Create a New Dated Reminder, Forward and Set as Completed'),
(11341, 'There are three actions that can be performed here - edit an existing group (ARO), add a new group (ARO) or delete an existing group (ARO).'),
(11342, 'There are three main template views. The first is the Repository where you store templates for future edits and disposal. '),
(11343, 'There are three main types of reports that can be created, two pertain to continuity of ongoing care - Continuity of Care Record (CCR) and Continuity of Care Document (CCD) and the third - Patient Report that creates a document containing various sections of the patient\'s medical record including demographics, medical issues, procedures and encounters. It also has the ability to include all or any of the scanned documents in the patient\'s chart'),
(11344, 'There are three options available when you create a Continuity of Care Document (CCD)'),
(11345, 'There are three options available when you create a Continuity of Care Record (CCR)'),
(11346, 'There are three sets of actions that can be performed on this page, in addition the form can be customized'),
(11347, 'There are two buttons that enable you to Check or Clear all available check-boxes'),
(11348, 'There are two options for the records that will be created'),
(11349, 'There are two sections that are visible'),
(11350, 'There are two sources that can be searched - MedlinePlus Connect or Local Content'),
(11351, 'There are two ways this can be accomplished, either by the manual method, by searching and entering data for individual invoices or by uploading an entire electronic remittance advice ERA file.'),
(11352, 'There are various selections to be filled, the minimum data needed to successfully save the referral is Referral Date, Refer To and Reason'),
(11353, 'There has been a mail error sending to'),
(11354, 'There is a charge transaction that has not been captured.'),
(11355, 'there is a contraception form new method but no contraception service'),
(11356, 'there is a contraception service but no contraception form new method'),
(11357, 'There is a lab order'),
(11358, 'There is a Post error'),
(11359, 'There is already a category named'),
(11360, 'There is already a subcategory named'),
(11361, 'There is already an item named'),
(11362, 'There is already an open patient record request.'),
(11363, 'There is no COA entry for AR account '),
(11364, 'There is no COA entry for cash account '),
(11365, 'There is no COA entry for income account '),
(11366, 'There is no current patient'),
(11367, 'There is no local content for this topic.'),
(11368, 'There is no match for invoice id'),
(11369, 'There is no match for invoice id = '),
(11370, 'There is no parts entry for services ID '),
(11371, 'There is no patient with portal login'),
(11372, 'There was a problem registering you. Recommend contacting clinic for assistance.'),
(11373, 'There was a problem sending the message.'),
(11374, 'There was an error while processing your request.'),
(11375, 'There was an OpenEMR SQL Escaping ERROR of the following string'),
(11376, 'Therefore each user has to individually activate this feature'),
(11377, 'These ACOs are grouped into ten broad categories that are part of the default installation. They are - Administration, Accounting, Patient Information, Encounter Information, Squads, Sensitivities, Lists, Placeholder, Nation Notes and Patient Portal. Each of these categories has one or several sub-categories that provide access to specific parts of the program.'),
(11378, 'These are free and can be downloaded from the respective app store for ios and android devices'),
(11379, 'These are the 2012 links'),
(11380, 'These are used to populate fields 3 and 4 in the HL7 MSH - message header'),
(11381, 'These are used to populate fields 5 and 6 in the HL7 MSH - message header'),
(11382, 'These credentials will be used by the patient to login to the patient portal for the first time'),
(11383, 'These custom groups are application specific and not user specific'),
(11384, 'These entries will be used to define the Providers in the Procedures module'),
(11385, 'These groups (AROs) can then be given a set of privileges by assigning different categories (ACOs).'),
(11386, 'These items can be edited if the user has sufficient privilege'),
(11387, 'These lists are used to determine who can access what in openEMR. They work in a top down manner, i.e. initially everybody is denied access to those parts of the program controlled by the ACL.'),
(11388, 'These numbers need to match to successfully authenticate the user'),
(11389, 'These Patient notes are sent without an assigned patient'),
(11390, 'These sub-categories represent the actual Access Control Objects (ACOs).'),
(11391, 'These templates are text only and will not render any other formatting other than pure text.'),
(11392, 'These three steps are essential before orders can be placed and received results linked to a patient\'s chart'),
(11393, 'These Transactions are generally used to document events that have already occurred'),
(11394, 'These two actions are available for all transactions'),
(11395, 'They are displayed in rows and are sub divided into three groups'),
(11396, 'They are Electrolyte Panel, Basic Metabolic Panel, Comprehensive Metabolic Panel, Renal Function Panel, General Health Panel, Obstetric Panel, Acute Hepatitis panel, Hepatic Function Panel and Lipid Panel'),
(11397, 'They are listed in ascending order by encounter date'),
(11398, 'They do not share the vulnerabilities of SMS based methods and generally do not require an internet connection except to keep their clocks synchronized with the current time'),
(11399, 'They will be provided by the facility that you will be connecting to'),
(11400, 'Thickened Right:'),
(11401, 'Thigh'),
(11402, 'Thigh + hamstring'),
(11403, 'Things that back office can only read'),
(11404, 'Things that back office can read and enter but not modify'),
(11405, 'Things that back office can read and modify'),
(11406, 'Things that back office can read and partly modify'),
(11407, 'Things that clinicians can only read'),
(11408, 'Things that clinicians can read and enter but not modify'),
(11409, 'Things that clinicians can read and modify'),
(11410, 'Things that clinicians can read and partly modify'),
(11411, 'Things that front office can only read'),
(11412, 'Things that front office can read and enter but not modify'),
(11413, 'Things that front office can read and modify'),
(11414, 'Things that front office can read and partly modify'),
(11415, 'Things that physicians can only read'),
(11416, 'Things that physicians can read and enter but not modify'),
(11417, 'Things that physicians can read and modify'),
(11418, 'Things that physicians can read and partly modify'),
(11419, 'Third'),
(11420, 'Third account message'),
(11421, 'This account already exists.'),
(11422, 'This action CANNOT be undone.'),
(11423, 'This action cannot be undone.'),
(11424, 'This action cannot be undone. Are you sure you wish to delete this form?'),
(11425, 'This action will be logged'),
(11426, 'This action will reset your claim!'),
(11427, 'This administration page is for managing the list of OAUTH2 registered applications that are authorized to use the APIs.'),
(11428, 'This Allows a Date Range to be Selected in Patient Flow Board.'),
(11429, 'This application has requested offline access to your data. This permission will allow the data you authorize below to be accessed for an extended period of time'),
(11430, 'This appointment slot is already used, please choose another.'),
(11431, 'This appointment slot is already used, use it anyway?'),
(11432, 'This appointment slot is not available, please choose another.'),
(11433, 'This Calendar Year'),
(11434, 'This charge was reversed via credit on following date'),
(11435, 'This charge was reversed via void on following date'),
(11436, 'This claim has been canceled.'),
(11437, 'This claim has been closed.'),
(11438, 'This claim has been denied.Reason:-'),
(11439, 'This claim has been forwarded to next level.'),
(11440, 'This claim has HCFA 1500 miscellaneous billing options'),
(11441, 'This Client ID Is Provided By Google For Your App (Required For Google Sign-in)'),
(11442, 'This client is currently disabled'),
(11443, 'This code is optional if only using manual lab data entry'),
(11444, 'This code is optional, but is a good practice to do so.'),
(11445, 'This code is optional, but is a good practice.'),
(11446, 'This code is optional.'),
(11447, 'This code type does not accept relations.'),
(11448, 'This completes a basic setup and will let use use the Fee Sheet to document charges for billing purposes'),
(11449, 'This context contains categories, which will be deleted. Do you still want to continue?'),
(11450, 'This Conversation'),
(11451, 'This Custom Favorite item can only be sent to the displayed lab, the one that was chosen in the Custom Favorite Group'),
(11452, 'This determines how appointments display on the calendar.'),
(11453, 'This determines which color schema used for appointment'),
(11454, 'This device is labeled as a Human Cell, Tissue or Cellular or Tissue-Based Product (HCT/P).'),
(11455, 'This device is required to be labeled as containing natural rubber latex or dry natural rubber.'),
(11456, 'This dialog is generated from patient problem diagnoses and the accumulated diagnoses of all past procedures.'),
(11457, 'This Enables provider in line item in the fee sheet'),
(11458, 'This Encounter'),
(11459, 'This encounter has been billed. If you need to change it, it must be re-opened.'),
(11460, 'This encounter has been billed. To make changes, re-open it or select Add More Items.'),
(11461, 'This encounter is locked. No new forms can be added.'),
(11462, 'This EOB item does not meet minimum print requirements setup in Globals or there is an unknown error.'),
(11463, 'This fax has already been sent to'),
(11464, 'This fax has already been sent.'),
(11465, 'This feature is not yet available'),
(11466, 'This feature is used to add patients to a recall list, i.e those that need an appointment at a future date but the appointment has not yet been scheduled'),
(11467, 'This feature is very experimental and not fully tested. Use at your own risk!'),
(11468, 'This feature will allow the default POS facility code to be overridden from the encounter.'),
(11469, 'This feature will allow the default POS facility code to be overriden from the encounter.'),
(11470, 'This field is used to decide whether to process the message as defined in HL7 Application (level 7) Processing rules'),
(11471, 'This form allows you to enter details of a visit or patient interaction'),
(11472, 'This fully functional Recall Board included in the default install can be used to add patients to the recall list'),
(11473, 'This gives you the option to delete any unwanted individual test in the group'),
(11474, 'This has to entered once in this form'),
(11475, 'This help file is divided into four sections'),
(11476, 'This help file is divided into the following sections'),
(11477, 'This ICD code can be automatically added to to Problem List by checking the P (Problem) checkbox. This selected item will show up in the Issues section under Medical problems'),
(11478, 'This invoice number has been changed to '),
(11479, 'This is a child of result'),
(11480, 'This is done in Administration > Users.'),
(11481, 'This is followed by the Edit and Add columns containing a pencil icon and a + icon'),
(11482, 'This is helpful if visits usually do not have charges.'),
(11483, 'This is not a valid request'),
(11484, 'This is passed to the application along with checksum value and is unique for each USB key and thereby the user who owns it'),
(11485, 'This is public information maintained by HHS/CMS. We cannot be responsible for the data received'),
(11486, 'This is required for both manual lab result entry and for electronic ordering tests and receiving results'),
(11487, 'This is required for your security as well as ours.'),
(11488, 'This is the Beginning date for the Ledger Report.'),
(11489, 'This is the chart that is to be merged into the main chart and then deleted.'),
(11490, 'This is the default Beginning date for the Patient Flow Board. (only applicable if Allow Date Range in option above is Enabled)'),
(11491, 'This is the default Ending date for the Patient Flow Board. (only applicable if Allow Date Range in option above is Enabled)'),
(11492, 'This is the default left print margin for CMS 1500. It will adjust the final printed output left or right.'),
(11493, 'This is the default left print margin for UB04. It will adjust the final printed output left or right.'),
(11494, 'This is the default top print margin for CMS 1500. It will adjust the final printed output up or down.'),
(11495, 'This is the default top print margin for UB04. It will adjust the final printed output up or down.'),
(11496, 'This is the Ending date for the Patient Flow Board Date Range. (only applicable if Allow Date Range in option above is Enabled)'),
(11497, 'This is the latest of multiple result values.'),
(11498, 'This is the main chart that is to receive the merged data.'),
(11499, 'This is the number of messages that will be displayed in the messages widget in the patient summary screen.'),
(11500, 'This is the recommended method for a non-technical user, if executed carefully will reduce configuration errors'),
(11501, 'This is where the referrals and various other simple transactions are created'),
(11502, 'This item does not have enough data to graph'),
(11503, 'This item will be displayed on the page on a single line'),
(11504, 'This key is generated by the application and is presented to the user in the form of a QR code'),
(11505, 'This key name is already in use by you. Try again.'),
(11506, 'This layout does not exist.'),
(11507, 'This layout ID already exists'),
(11508, 'This lets you manually enter the reply to the referral as structured data'),
(11509, 'This lets you set the price level for the charges and let you charge different rates for different modes of payment.'),
(11510, 'this location'),
(11511, 'This message need not necessarily be linked to a patient'),
(11512, 'This message text is not saved automatically. Copy and save it as appropriate for the content.'),
(11513, 'This method will however result in the data becoming non-structured and one would loose the ability to document the reply in an electronic format'),
(11514, 'This module is being used by '),
(11515, 'This module is in test mode. The database will not be changed.'),
(11516, 'This module is subscription based and needs to be enabled from Administration > Globals > Connectors > Enable NewCrop eRx Service'),
(11517, 'This module is well integrated with openEMR, there are however two non-subscription based alternatives, Weno and Allscripts that can be used instead'),
(11518, 'This module promotes efficient entry of EOB data.'),
(11519, 'This Month to Date'),
(11520, 'This name already exists under this parent.'),
(11521, 'This namespace already exists in database'),
(11522, 'This new category will be a sub-category of '),
(11523, 'This note goes on the bottom of every checkout receipt.'),
(11524, 'This order was already transmitted on'),
(11525, 'This page allows you to review each of the supported external dataloads that you can install and upgrade. Each section below can be expanded by clicking on the section header to review the status of the particular database of interest.'),
(11526, 'This page deactivated for security reasons.'),
(11527, 'This page lets you configure the orders and results'),
(11528, 'This page will inline include the login page, so that we do not have to click relogin every time.'),
(11529, 'This patient already has an appointment scheduled for'),
(11530, 'This patient does not allow SMS messaging!'),
(11531, 'This patient has already been added to the list'),
(11532, 'This patient has no activity.'),
(11533, 'This patient ID is already in use!'),
(11534, 'This portals authentication.'),
(11535, 'This product allows only one lot per warehouse.'),
(11536, 'This protocol is not implemented'),
(11537, 'This provider will be used as the default for services not specifying a provider.'),
(11538, 'This question is optional and not included in the final score'),
(11539, 'This report currently only works for ICD9 codes.'),
(11540, 'This run is incomplete due to time expiration.'),
(11541, 'This search field does not exist or is not supported'),
(11542, 'This section allows you to create and remove groups and modify or grant access privileges to existing groups. Check the check box to display section'),
(11543, 'This section can be customized to group the codes into various categories'),
(11544, 'This section DOES NOT let you create new ACOs.'),
(11545, 'This section is where the codes use to charge for the visit are selected'),
(11546, 'This section lets you search for the needed code if it is not in the default or customized options in \'Select Code\' section'),
(11547, 'This section will allow the logged in user to view existing methods or to delete them '),
(11548, 'This sets the Default Calendar View, Default is Day.'),
(11549, 'This specifies the Printing of the Custom End of Day Report grouped Provider or allow the Printing of Totals Only'),
(11550, 'This specifies whether to include date in Box 31.'),
(11551, 'This specifies which revision of the form the billing module should generate'),
(11552, 'This step will generate a file which you have to save for future use.'),
(11553, 'This step will generate a file which you have to save for future use. The file cannot be generated again. Do you want to proceed?'),
(11554, 'This transaction credited the following Transaction ID'),
(11555, 'This transaction voided the following Transaction ID'),
(11556, 'This user is not a member of any group'),
(11557, 'This user will receive notification of new incoming Direct messages'),
(11558, 'This utility is experimental.  Back up your database and documents before using it!'),
(11559, 'This utility is experimental. Back up your database and documents before using it!'),
(11560, 'This visit begins new contraceptive use'),
(11561, 'This visit will need a GCAC form, referral or procedure service.'),
(11562, 'This was the older metric-only Vitals form, now deprecated.'),
(11563, 'This Week to Date'),
(11564, 'This will abandon any edits!'),
(11565, 'This will abandon your unsaved changes. Are you sure?'),
(11566, 'This will activate the CCR(Continuity of Care Record) and CCD(Continuity of Care Document) reporting.'),
(11567, 'This will advance the receipt number. Please print the receipt if you have not already done so.'),
(11568, 'This will allow printing of a custom Message on the statements.'),
(11569, 'This will allow printing of the Patient Billing Note on the statements.'),
(11570, 'This will allow selection of the debugging (\'dummy\') language.'),
(11571, 'This will allow the display of help modal on help enabled pages'),
(11572, 'This will allow the use of the custom End of Day report and indicate which report to use.'),
(11573, 'This will allow use of the custom Dunning Messages on the statements.'),
(11574, 'This will be a \"dry run\" with no physical data updates.'),
(11575, 'This will clear the data from all Anterior Segment Exam fields'),
(11576, 'This will clear the data from all External Exam fields'),
(11577, 'This will clear the data from all Retina Exam fields'),
(11578, 'This will copy the selected code to the Diagnosis Codes box in the underlying Enter Details for Individual Custom Favorite Item pop-up form'),
(11579, 'This will create a backup in tar format and then send it to your web browser so you can save it'),
(11580, 'This will deactivate document the encryption and decryption features, and hide them in the UI.'),
(11581, 'This will disable the Edit button on all forms whose parent encounter is e-signed'),
(11582, 'This will disable the Edit button on any form that is e-signed'),
(11583, 'This will Display the Invoice Number in the Sales Report or the Patient Name and ID or Patient Name and Invoice Number.'),
(11584, 'This will enable encryption of items that are stored on CouchDB.'),
(11585, 'This will enable encryption of items that are stored on the drive.'),
(11586, 'This will enable signing an entire encounter, rather than individual forms'),
(11587, 'This will enable signing individual forms separately'),
(11588, 'This will enable the Ability to Exclude Selected Patient Statements from Printing.'),
(11589, 'This will fill in the Title text-box as well as ICD10 code in the Coding text-box'),
(11590, 'This will force the Billing Widget in the Patient Summary screen to always be open.'),
(11591, 'This will give the user the option to lock (separate locking and signing)'),
(11592, 'This will give you the option to set different price levels when you are manually entering CPT codes'),
(11593, 'This will hide any e-sign logs on the patient report'),
(11594, 'This will hide any encounter forms not E-Signed on the patient report'),
(11595, 'This will hide empty e-sign logs on the patient report'),
(11596, 'This will hide the Billing Widget in the Patient Summary screen'),
(11597, 'This will merge two patient charts into one.  It is useful when a patient has been duplicated by mistake.  If that happens often, fix your office procedures - do not run this routinely!'),
(11598, 'This will not prevent you from going to the e-Prescriptions site.'),
(11599, 'This will permanently delete all lots of this product. Related reports will be incomplete or incorrect. Are you sure?'),
(11600, 'This Will Print the Next Appointment on the Bottom of the Patient Ledger'),
(11601, 'This will re-display the secret key via the QR code that can then be captured and stored on the new Smartphone via its authenticator app'),
(11602, 'This will register a new U2F USB key'),
(11603, 'This will reveal the Register TOTP Key section for logged in user'),
(11604, 'This will Show Aging on the custom Statement.'),
(11605, 'This will turn off use of safe apostrophe, which is done by converting \' and \" to `.(it is highly recommended that this setting is turned off and that safe apostrophe\'s are used)'),
(11606, 'This will use the custom immunizations list rather than the standard CVX immunization list.'),
(11607, 'This will use the custom Statement showing the description instead of the codes.'),
(11608, 'This will use the custom Statment showing the description instead of the codes.'),
(11609, 'Thoracic physician'),
(11610, 'Thoracic spine'),
(11611, 'Those with adequate privilege would be able to able to Delete the transaction'),
(11612, 'Thous/CU.MM'),
(11613, 'Three Months Ago'),
(11614, 'Three Months Ahead'),
(11615, 'Three or four digits at back of your card'),
(11616, 'Thrills'),
(11617, 'Throat'),
(11618, 'Throat Cancer'),
(11619, 'Throat Cancer Surgery'),
(11620, 'Thrombosis/Stroke'),
(11621, 'Thu'),
(11622, 'Thumbnail size'),
(11623, 'Thurdsay'),
(11624, 'Thursday'),
(11625, 'Thus far the tests that can be ordered were placed in the Procedure Order Tier, only one test at a time can be placed in this tier, when ordering a recognized panel of tests the entire panel of tests is grouped together as a single test e.g. Sodium, Potassium, Chloride and Carbon dioxide grouped as Electrolyte Panel. The results of the individual returned tests in the panel are recorded as Discrete Results'),
(11626, 'Thyroid normal'),
(11627, 'Thyroid Problems'),
(11628, 'Th{{Thursday}}'),
(11629, 'TIA'),
(11630, 'Tibetan Standard, Tibetan, Central'),
(11631, 'Ticket'),
(11632, 'TID'),
(11633, 'Tier'),
(11634, 'Tier 1 - Group - e.g. Serum Chemistry'),
(11635, 'Tier 1 entries should be of Category Top Group'),
(11636, 'Tier 2 - Group (will display in category column as Sub Group) - e.g. Organ/Disease Panel'),
(11637, 'Tier 2 - Procedure Order - e.g. Serum Uric Acid'),
(11638, 'Tier 3 - Discrete Result - e.g. Serum Uric Acid - will hold the returned result value and Default Units, Default Range etc'),
(11639, 'Tier 3 - Procedure Order - e.g. Electrolyte Panel'),
(11640, 'Tier 4 - Discrete Result - The actual test names to hold the results returned Na, K, Cl, CO2 and Default Units, Default Range etc'),
(11641, 'Tigrinya'),
(11642, 'Time'),
(11643, 'Time Collected'),
(11644, 'Time Display Format'),
(11645, 'Time Increment for Add (minutes 1-60)'),
(11646, 'Time selection'),
(11647, 'Time slot is available, saving event'),
(11648, 'Time slot is open, saving event'),
(11649, 'Time Zone'),
(11650, 'Time-To-Live for Allergies SOAP Request in seconds'),
(11651, 'Time-To-Live for Medications SOAP Request in seconds'),
(11652, 'Time-To-Live for NewCrop eRx Allergies SOAP Request in seconds.'),
(11653, 'Time-To-Live for NewCrop eRx Medications SOAP Request in seconds.'),
(11654, 'Timed event'),
(11655, 'Times array (N/A)'),
(11656, 'Timestamp and Text'),
(11657, 'Timing'),
(11658, 'TIN'),
(11659, 'Tinnitus'),
(11660, 'Tips'),
(11661, 'Title'),
(11662, 'Title - The value that will be displayed - Each word to begin with an uppercase letter'),
(11663, 'Title is required'),
(11664, 'Title V'),
(11665, 'TitleCols must be a number between 1 and 999'),
(11666, 'Titles'),
(11667, 'TM\'S:'),
(11668, 'TMs/EAMs/EE, ext nose'),
(11669, 'To'),
(11670, 'to'),
(11671, 'TO'),
(11672, 'to absolute path of file'),
(11673, 'To access it click on the Recall Board menu item in the top navigation bar or click on the Recall Board button in the Message Center'),
(11674, 'To add a copay click the \'Add Copay\' button'),
(11675, 'To add messages, please click here'),
(11676, 'To add more options to the dropdown menu go to Administration > Lists > Manage Lists and select \'Price Level\' in the dropdown box and enter the types e.g: Credit Card, Cash etc.'),
(11677, 'To add notes, please click '),
(11678, 'To add notes, please click here'),
(11679, 'To Affected Area'),
(11680, 'to affected area'),
(11681, 'To allow for each procedure line to have a separate provider you have to check the \'Support provider in line item in fee sheet\' checkbox in Administration > Globals > Billing. If not checked the rendering provider in this section will be used for all claims'),
(11682, 'To authorize the patient portal for the patient go to Dashboard > Demographics > Edit > Choices and select Yes in Allow Patient Portal drop-down box and Save'),
(11683, 'To automatically open the specified form. Some sports teams use football_injury_audit here.'),
(11684, 'To be able to link this issue to an encounter click on the button to bring up the Issues and Encounters pop-up page'),
(11685, 'To Billing View'),
(11686, 'to category'),
(11687, 'To change and activate the default parameters in the Fee Sheet go to Administration > Globals > Billing'),
(11688, 'To Clinical View'),
(11689, 'To configure the lab test go to Procedures > Configuration'),
(11690, 'To copay'),
(11691, 'To create a new message click on the Add New button at the bottom'),
(11692, 'To create another panel of tests you will repeat this process but will start by creating a Procedure Order or fruit bearing branch Tier 3, for example - Acute Hepatitis panel under the main branch or Sub Group Organ/Disease Panel (Tier 2)'),
(11693, 'To Dashboard'),
(11694, 'To date must be later than From date!'),
(11695, 'To ded\'ble'),
(11696, 'To delete any or all the selected ICD10 codes click again on the Diagnosis Codes box to bring up the Select Diagnosis Codes pop-up window'),
(11697, 'To delink just click on the item to delink and it will get delinked and will no longer be highlighted'),
(11698, 'To Dems'),
(11699, 'To disable automatic message checking go to Administration > Globals > Connectors  and set phiMail Message Check Interval to 0 (zero) '),
(11700, 'To Disable client side SSL certificates, comment above lines in Apache configuration file and set'),
(11701, 'To Disable client side SSL certificates, comment above lines in Apache configuration file and turn off the \'Enable Client SSL\' global setting in OpenEMR and restart Apache server.'),
(11702, 'To Disable HTTPS, comment the above lines in Apache configuration file and restart Apache server.'),
(11703, 'To display the copay amount it must have been entered in the patient\'s insurance under Edit > Demographics'),
(11704, 'To do so click on the black + sign at the far end on the Serum Uric Acid order line to bring up the Enter Details pop-up'),
(11705, 'To edit an existing group (ARO) click on the icon next to the desired group. This will bring up the edit window.'),
(11706, 'To enable any other form of connectivity will require writing new code'),
(11707, 'To enable Client side ssl certificates'),
(11708, 'To Enable Client side SSL certificates authentication, HTTPS should be enabled.'),
(11709, 'To enable help - Go to  Administration > Globals > Features > Enable Help Modal'),
(11710, 'To enable help - Go to the User Name on top left > Settings > Features > Enable Help Modal'),
(11711, 'To enable help - Go to the User Name on top right > Settings > Features > Enable Help Modal'),
(11712, 'To Enable only HTTPS, perform the above changes and restart Apache server. If you want to configure client side certificates also, please configure them in the next section.'),
(11713, 'To enable Patient Portal go to Administration > Portal > Enable Version 2 Onsite Patient Portal, Enable Offsite Patient Portal or Enable CMS Portal'),
(11714, 'To encounter'),
(11715, 'To Enctr'),
(11716, 'To filter by sex'),
(11717, 'To fulfill Meaningful use requirements and help track its use you can check on the Sent Summary of Care check-box and the Sent Summary of Care Electronically check-box if appropriate'),
(11718, 'To fully delete hit \'Save\''),
(11719, 'To get started you choose one of the two radio buttons. \'Invoice Search\' or \'ERA Upload\' '),
(11720, 'To help explore the various components of the Report page especially if you want to use it as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR '),
(11721, 'To help familiarize you with the various components of the Dashboard page it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR'),
(11722, 'To help simplify implementations, commonly used templates were harmonized from existing CDA implementation guides and consolidated into a single implementation guide – the C-CDA Implementation Guide (IG) (07/2012)'),
(11723, 'To History'),
(11724, 'To include the scanned documents that are a part of the patient\'s record select the desired records by check the relevant check-boxes'),
(11725, 'To Issues'),
(11726, 'To link the Issues to an encounter first select the issue, it will be highlighted yellow, then click on one or more encounters to link them, the selected encounters will be highlighted in purple'),
(11727, 'To link this encounter/consult to an existing issue, click the '),
(11728, 'To link this encounter/consult to an existing issue, click the desired issue above to highlight it and then click [Save]. Hold down [Ctrl] button to select multiple issues.'),
(11729, 'To link this encounter/consult to an existing issue, click the desired issue above to highlight it and then click Save'),
(11730, 'to login again'),
(11731, 'To move the groups from one column to another select one or more items from the column that you need to move them out of and press the relevant button with the double chevrons.'),
(11732, 'To proceed you need a USB security key, a secure HTTPS web connection and a browser that supports U2F'),
(11733, 'To recap, a Group called Serum Chemistry (Tier 1) was created, a direct descendant or child called Serum Uric Acid (Tier 2) was created beneath it as a Procedure Order which had a single direct descendant or child also called Serum Uric Acid (Tier 3) as a Discrete Result that will hold the result value'),
(11734, 'To receive error notifications from the Direct Messaging service a valid Notification Email Address needs to be entered for the user named in Administration > Globals > Connectors > phiMail notification user'),
(11735, 'To record disclosures, please click'),
(11736, 'To register you need an authenticator app installed on your Smartphone'),
(11737, 'To Repository Location'),
(11738, 'To resend, delete the file from Communications and try again.'),
(11739, 'To resend, delete the file from Communications, reload this page and try again.'),
(11740, 'To reveal the filters click on the eye icon'),
(11741, 'to run'),
(11742, 'to search Location and Category current selections or refresh views. By selecting location and or category, all the tables in the form will reflect those selection.'),
(11743, 'To see to all the ACOs that are available click on the eye icon.'),
(11744, 'To select a particular code identify it in the returned results and click on it to select'),
(11745, 'To select multiple groups hold down the \'Shift\' or \'Ctrl\' keys while clicking.'),
(11746, 'To send template or available profiles to patient(s), simply select the patient(s) from the Location select then select the templates to be sent from the repository send check box.'),
(11747, 'To setup https access with client certificate authentication, do the following'),
(11748, 'To Skin'),
(11749, 'to skin'),
(11750, 'To summarize'),
(11751, 'to this visit?'),
(11752, 'To upload CCR document of already existing patient use Patient Summary Screen->Documents. For CCR document of a new patient use Miscellanous->New Documents screen'),
(11753, 'To upload local text or html templates click the Upload button in Template Repository title to expose the file select button. Next select a Category from Scope bar if wanted then click files select button to show the file browser. You may select as many files to upload within reason'),
(11754, 'To use the help page as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR '),
(11755, 'To use this help file as an instruction manual it is best to resize your browser to occupy half the screen, open another instance of the browser to fill the other half of the screen, login to openEMR and open the help file in this browser and resize it by clicking and dragging the bottom right corner so that it occupies the entire half screen'),
(11756, 'To use this help file as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR'),
(11757, 'To:'),
(11758, 'To: '),
(11759, 'TO_CITY'),
(11760, 'TO_FAX'),
(11761, 'TO_FNAME'),
(11762, 'TO_LNAME'),
(11763, 'TO_MNAME'),
(11764, 'TO_ORGANIZATION'),
(11765, 'TO_PHONE'),
(11766, 'TO_PHONECELL'),
(11767, 'TO_POSTAL'),
(11768, 'TO_STATE'),
(11769, 'TO_STREET'),
(11770, 'TO_TITLE'),
(11771, 'TO_VALEDICTORY'),
(11772, 'Tobacco'),
(11773, 'Tobacco Cessation Intervention'),
(11774, 'Tobacco Cessation Intervention (CQM)'),
(11775, 'Tobacco use'),
(11776, 'Tobacco Use'),
(11777, 'Tobacco Use Assessment'),
(11778, 'Tobacco Use Assessment (CQM)'),
(11779, 'Today'),
(11780, 'TODAY'),
(11781, 'today'),
(11782, 'Today\'s Balance'),
(11783, 'Today\'s Charges'),
(11784, 'Today\'s Date'),
(11785, 'Today\'s Events'),
(11786, 'Toggle'),
(11787, 'Toggle All'),
(11788, 'Toggle navigation'),
(11789, 'Toggle the Patient Panel'),
(11790, 'Toggle the right-sided PMSFH panel'),
(11791, 'Token'),
(11792, 'Token DB Id'),
(11793, 'Token details'),
(11794, 'Token Expiration'),
(11795, 'Token for connection to ASSE SOAP server'),
(11796, 'Token ID for the Medical Information Integration, LLC Lab Exchange Service.'),
(11797, 'Token ID for the OpenEMR Support LLC Lab Exchange Service.'),
(11798, 'Token JTI(DB token value)'),
(11799, 'Token Status'),
(11800, 'Token Tools'),
(11801, 'Token Type'),
(11802, 'Tonga (Tonga Islands)'),
(11803, 'Tonsillectomy'),
(11804, 'tonsillectomy'),
(11805, 'Too many search results found. Displaying a limited set of patients. Narrow your search results through the filters above.'),
(11806, 'Tooltips'),
(11807, 'Top'),
(11808, 'Top Group'),
(11809, 'Top Margin (mm)'),
(11810, 'Topic'),
(11811, 'Total'),
(11812, 'total'),
(11813, 'Total active actions'),
(11814, 'Total active reminders after update'),
(11815, 'Total active reminders before update'),
(11816, 'Total Adj'),
(11817, 'Total amount due'),
(11818, 'Total Amount Paid'),
(11819, 'Total Balance Due'),
(11820, 'Total Charge'),
(11821, 'Total Charges'),
(11822, 'Total Charges This Visit'),
(11823, 'Total Clients'),
(11824, 'Total Co-Pay'),
(11825, 'Total Cost'),
(11826, 'Total Distribution for following check number is not full'),
(11827, 'total entries'),
(11828, 'Total failed reminders sent via email'),
(11829, 'Total failed reminders sent via phone'),
(11830, 'Total for'),
(11831, 'Total for '),
(11832, 'Total for category'),
(11833, 'Total GAD-7 score'),
(11834, 'Total inactivated reminders'),
(11835, 'Total Minimum Amount of Statement to Allow Printing'),
(11836, 'Total Minimum Dollar Amount of Statement to Allow Printing.(only applicable if Allow Statement Exclusions from Printing is enabled)'),
(11837, 'Total new reminders'),
(11838, 'Total number of appointments'),
(11839, 'Total number of Drug Screen entries'),
(11840, 'Total Number of Immunizations'),
(11841, 'Total Number of Issues'),
(11842, 'Total number of Patient Flow Board entries'),
(11843, 'Total Number of Patients'),
(11844, 'Total of'),
(11845, 'Total Pages'),
(11846, 'Total Patient Balance'),
(11847, 'Total patients'),
(11848, 'Total Patients'),
(11849, 'Total Payments'),
(11850, 'Total Payments This Visit'),
(11851, 'Total pharmacies'),
(11852, 'Total Records'),
(11853, 'total records'),
(11854, 'Total Records Found'),
(11855, 'Total size'),
(11856, 'Total SRH & Family Planning'),
(11857, 'Total successful reminders sent via email'),
(11858, 'Total successful reminders sent via phone'),
(11859, 'Total Time'),
(11860, 'Total Transfers'),
(11861, 'Total unchanged reminders'),
(11862, 'Total unsent reminders after sending process'),
(11863, 'Total unsent reminders after update'),
(11864, 'Total unsent reminders before sending process'),
(11865, 'Total unsent reminders before update'),
(11866, 'Total updated reminders'),
(11867, 'Total Visit Charges'),
(11868, 'Totals'),
(11869, 'Totals for'),
(11870, 'Totals for '),
(11871, 'Totals Only'),
(11872, 'TOTP'),
(11873, 'TOTP - Cons'),
(11874, 'TOTP - Pros'),
(11875, 'TOTP - Time-Based One-Time Password'),
(11876, 'TOTP Key'),
(11877, 'TOTP Method already exists and is enabled. Try again.'),
(11878, 'TOTP Registration'),
(11879, 'TOTP Verification'),
(11880, 'To{{Destination}}'),
(11881, 'to{{Destination}}'),
(11882, 'TO{{Destination}}'),
(11883, 'to{{Range}}'),
(11884, 'To{{Range}}'),
(11885, 'to{{range}}'),
(11886, 'To{{range}}'),
(11887, 'Tpn{{Tonopen abbreviation}}'),
(11888, 'TP{{tonopen}}'),
(11889, 'tr'),
(11890, 'Track'),
(11891, 'Track Report'),
(11892, 'Tracks'),
(11893, 'Tracks - if the Track Anything feature is enabled it will display a list of values that can be tracked and graphed'),
(11894, 'Train'),
(11895, 'Trainer'),
(11896, 'Training'),
(11897, 'Training Type'),
(11898, 'Tran'),
(11899, 'Transact'),
(11900, 'Transaction'),
(11901, 'transaction'),
(11902, 'Transaction Cancelled'),
(11903, 'Transaction date must not be in the future or before 2000'),
(11904, 'Transaction Declined'),
(11905, 'Transaction Error'),
(11906, 'Transaction failed, duplicate lot'),
(11907, 'Transaction failed, insufficient quantity in destination lot'),
(11908, 'Transaction failed, quantity is less than zero'),
(11909, 'Transaction ID'),
(11910, 'Transaction Id'),
(11911, 'Transaction Not Successful'),
(11912, 'Transaction Progress'),
(11913, 'Transaction Type'),
(11914, 'Transactions'),
(11915, 'transactions'),
(11916, 'Transactions (write optional)'),
(11917, 'Transactions (write optional) (trans)'),
(11918, 'Transactions - lists various notes about happenings in a patient\'s chart with respect to billing, legal, patient request, physician request and also generates a patient referral or counter-referral'),
(11919, 'Transactions are for events or information not necessarily tied to one specific visit or encounter'),
(11920, 'Transactions provides a mechanism to link an activity to patient that is not encounter based'),
(11921, 'Transactions, e.g. referrals (write optional) (trans)'),
(11922, 'Transactions/Referrals'),
(11923, 'Transdermal'),
(11924, 'Transfer'),
(11925, 'Transfer date'),
(11926, 'Transfer failed, insufficient quantity in source lot'),
(11927, 'Transfer Summary'),
(11928, 'Transfer to'),
(11929, 'Transferred By'),
(11930, 'Transferred Date'),
(11931, 'Transfers'),
(11932, 'Transition Of Care'),
(11933, 'Transition/Transfer of Care?'),
(11934, 'Translate Access Control Groups'),
(11935, 'Translate Appointment Categories'),
(11936, 'Translate Document Categories'),
(11937, 'Translate Layouts'),
(11938, 'Translate Lists'),
(11939, 'Translate Patient Note Titles'),
(11940, 'translate this'),
(11941, 'Translated'),
(11942, 'Translation'),
(11943, 'Translations'),
(11944, 'Transmit'),
(11945, 'Transmit - securely transmit the CCD using phiMail Direct Messaging'),
(11946, 'Transmit - securely transmit the CCR using phiMail Direct Messaging'),
(11947, 'Transmit failed'),
(11948, 'Transmit Order'),
(11949, 'Transmit Selected Orders'),
(11950, 'Transmitter'),
(11951, 'Trash'),
(11952, 'Trauma'),
(11953, 'Treatment'),
(11954, 'Treatment Completion Status'),
(11955, 'Treatment Goals'),
(11956, 'Treatment Plan'),
(11957, 'Treatment Planning'),
(11958, 'Treatment Received'),
(11959, 'Treatment:'),
(11960, 'Treatment: '),
(11961, 'Tree'),
(11962, 'Trend'),
(11963, 'trftime($month_format, mktime(0, 0, 0, $i, 1, 2000)) );             $month_value'),
(11964, 'Tribal 638 Free-standing Facility'),
(11965, 'Tribal 638 Provider-based Facility'),
(11966, 'Trifocal'),
(11967, 'Trifocals'),
(11968, 'Trigger point / compartment syndrome / DOMS / cramp'),
(11969, 'Trimalleolar'),
(11970, 'Tropic 2.5%'),
(11971, 'Trouble relaxing'),
(11972, 'True'),
(11973, 'Trunk and abdomen'),
(11974, 'Trusted Direct Email Address'),
(11975, 'Trusted Email'),
(11976, 'Trying'),
(11977, 'Trying to create user with existing username!'),
(11978, 'Tsonga'),
(11979, 'tsp'),
(11980, 'Tswana'),
(11981, 'TTS'),
(11982, 'Tuberculosis'),
(11983, 'Tue'),
(11984, 'Tues &amp; Thur'),
(11985, 'Tuesday'),
(11986, 'Tumour'),
(11987, 'Turkish'),
(11988, 'Turkmen'),
(11989, 'Turn off auto calculations of adjustments in EOB'),
(11990, 'Turn Off birthday alert'),
(11991, 'Turn on Enable Client SSL'),
(11992, 'Turn on to show all payment history in Patient Ledger'),
(11993, 'Turn the Tooltips on/off'),
(11994, 'Tu{{Tuesday}}'),
(11995, 'Twi'),
(11996, 'twice daily'),
(11997, 'Two Years Ago'),
(11998, 'Two Years Ahead'),
(11999, 'Tx Date'),
(12000, 'Tympanic Membrane'),
(12001, 'Type'),
(12002, 'Type a brief message and hit Send Message '),
(12003, 'Type a name for the key in the text box'),
(12004, 'Type a name for your key, insert it into a USB port and click the Register button below'),
(12005, 'Type Id or Name.3 characters minimum (including spaces).'),
(12006, 'Type in Electrolyte Panel as the Name'),
(12007, 'Type in the location of the directory or folder in which the created orders (HL7 messages) will be stored'),
(12008, 'Type in the location of the directory or folder in which the returned results (HL7 messages) will be stored'),
(12009, 'Type in the URL of the external facility to which the order will be sent, this will be provided by the facility'),
(12010, 'Type in the username and password provided by the facility'),
(12011, 'Type Message...'),
(12012, 'Type of columns displayed for patient search results'),
(12013, 'Type of Disclosure'),
(12014, 'Type of Events'),
(12015, 'Type of group'),
(12016, 'Type of screen layout'),
(12017, 'Type or scan the patient identifier here'),
(12018, 'Type Sodium under Name and Sodium result under description'),
(12019, 'Type the message and click Send Message '),
(12020, 'Type the name of the drug in the Drug Search text-box'),
(12021, 'Type to search and select revenue code'),
(12022, 'Type to search.'),
(12023, 'Type Your message here'),
(12024, 'Types of Orders and Results'),
(12025, 'T{{one letter abbreviation for Tension/Pressure}}'),
(12026, 'T{{Thursday}}'),
(12027, 'T{{Tuesday}}'),
(12028, 'U2F'),
(12029, 'U2F - Cons'),
(12030, 'U2F - Pros'),
(12031, 'U2F devices are relatively costly'),
(12032, 'U2F Key Authentication error'),
(12033, 'U2F Key Verification'),
(12034, 'U2F Registration'),
(12035, 'U2F USB Device'),
(12036, 'UAC Appl'),
(12037, 'UAC Tot'),
(12038, 'UB04 FORM'),
(12039, 'UB04 FORM PDF'),
(12040, 'UB04 left margin in points'),
(12041, 'UB04 Margins'),
(12042, 'UB04 Margins Left'),
(12043, 'UB04 TEXT PDF'),
(12044, 'UB04 top margin in points'),
(12045, 'UCSMC codes provided by the University of Calgary Sports Medicine Centre'),
(12046, 'UDI (Unique Device Identifier)'),
(12047, 'UDI field is missing'),
(12048, 'UDI search failed'),
(12049, 'UDI{{Unique Device Identifier}}'),
(12050, 'Ukrainian'),
(12051, 'Ulcerations'),
(12052, 'Ulcerative Colitis'),
(12053, 'Ulcers:'),
(12054, 'Unable insert version information into database'),
(12055, 'Unable to access directory'),
(12056, 'Unable to access directory for lab npi:'),
(12057, 'Unable to access URL'),
(12058, 'Unable to complete transaction'),
(12059, 'Unable to create'),
(12060, 'Unable to create patient document subdirectory'),
(12061, 'Unable to decrypt these comments since decryption failed.'),
(12062, 'Unable to decrypt these comments since the PHP mycrypt module is not installed.'),
(12063, 'Unable to decrypt these comments since the PHP openssl module is not installed.'),
(12064, 'Unable to either create credentials or send email.'),
(12065, 'Unable to find window to build'),
(12066, 'Unable to find your records. Be sure to use your correct Dob, First and Last name and Email of record.'),
(12067, 'Unable to find your records. Be sure to use your correct Dob, First and Last name and Email of record. If you have opted out of email with none on file then leave blank.'),
(12068, 'Unable to locate the data in this file.'),
(12069, 'Unable to match this payment in ar_activity'),
(12070, 'Unable to modify application config Please give write permission to'),
(12071, 'Unable to Parse file! Verify File encoding'),
(12072, 'Unable to save file: Use back button!'),
(12073, 'Unable to save files. Use back button!'),
(12074, 'Unapplied'),
(12075, 'Unassigned'),
(12076, 'Unauthorized'),
(12077, 'Unauthorized access to ePrescription'),
(12078, 'Unauthorized access.'),
(12079, 'Unbilled'),
(12080, 'Unbilled Only'),
(12081, 'Uncategorized'),
(12082, 'Unchanged Entries verified'),
(12083, 'Uncle'),
(12084, 'under tongue'),
(12085, 'Underneath it will be some common drugs'),
(12086, 'Underneath it will be some common problems'),
(12087, 'Underweight'),
(12088, 'Undiagnosed'),
(12089, 'Undistributed'),
(12090, 'UNDISTRIBUTED'),
(12091, 'Undistributed is'),
(12092, 'Undo'),
(12093, 'Undo Checkout'),
(12094, 'Unexpected non-match, creating new patient for segment'),
(12095, 'Unique Clients'),
(12096, 'Unique human-readable identifier for this type'),
(12097, 'Unique Installation ID'),
(12098, 'Unique installation ID. Creates a random UUID if empty.'),
(12099, 'Unique New Clients'),
(12100, 'Unique numeric identifier for this type'),
(12101, 'Unique Seen Patients'),
(12102, 'Unique Seen Patients Report'),
(12103, 'Unique SP'),
(12104, 'Unit'),
(12105, 'Unit Price in Checkout and Receipt'),
(12106, 'Units'),
(12107, 'units'),
(12108, 'Units applicable to the result value'),
(12109, 'Units for Visit Forms'),
(12110, 'Units must be a number'),
(12111, 'Units not defined'),
(12112, 'Units/L'),
(12113, 'Unknown'),
(12114, 'unknown (see log)'),
(12115, 'Unknown Error'),
(12116, 'Unknown if ever smoked'),
(12117, 'Unknown or N/A'),
(12118, 'Unknown Script Error: See Browser Console for Detail'),
(12119, 'Unknown Selection'),
(12120, 'Unknown Transaction Error Maybe Subscriber Effective or DOB Dates'),
(12121, 'Unknown user id:'),
(12122, 'Unknown version'),
(12123, 'Unknown.'),
(12124, 'Unlike a message sent in Messages the dated reminder is not a part of the medical record'),
(12125, 'Unlike ordering a recognized panel as a single test and thus have all the component tests performed these three tests will be presented as three individual tests'),
(12126, 'Unlike the regular Groups that were created earlier, each Custom Favorite Group has an Identifying Code that has to be unique. As this is our custom group and not a lab recognized panel we will give it our arbitrary unique Identifying Code - CFGWWT001'),
(12127, 'Unlike the regular Procedure Order a Diagnostic Codes box is present allowing you to enter one or more ICD10 Diagnosis Codes as default diagnoses for this order'),
(12128, 'Unlike the regular Top Groups created thus far the Code column will have a value CFGWWT001'),
(12129, 'Unlike TOTP where there is no communication between the application and the device having the authenticator app each time the USB key is plugged in the application communicates with the USB key via the browser'),
(12130, 'unlink patient'),
(12131, 'Unnamed insurance company'),
(12132, 'Unregistered'),
(12133, 'Unregistered Modules'),
(12134, 'Unrelated Friend'),
(12135, 'Unselect All'),
(12136, 'Unselect all'),
(12137, 'Unselected'),
(12138, 'Unspecified'),
(12139, 'unstructured'),
(12140, 'Unstructured Documents - 2010'),
(12141, 'UNSUPPORTED database load file'),
(12142, 'Unsupported MDM OBX result type'),
(12143, 'until'),
(12144, 'until date'),
(12145, 'Until then you will continue to see payment details here.'),
(12146, 'Untimely filing'),
(12147, 'Unused'),
(12148, 'UOR'),
(12149, 'Up to'),
(12150, 'UPCOMING'),
(12151, 'Upcoming Appointments'),
(12152, 'Upcoming Events'),
(12153, 'Update'),
(12154, 'update'),
(12155, 'Update Active'),
(12156, 'Update by'),
(12157, 'Update Drug'),
(12158, 'Update files'),
(12159, 'Update From'),
(12160, 'Update Info'),
(12161, 'Update information when the patient goes to another provider, to support safety, quality, and continuity of patient care'),
(12162, 'Update List'),
(12163, 'Update Lot'),
(12164, 'Update policy number from ERA'),
(12165, 'Update Provider Number'),
(12166, 'Update Selected Items'),
(12167, 'Update Status'),
(12168, 'Update the chart to activate the Builder.'),
(12169, 'Update the chart to build this list'),
(12170, 'Update the following settings in Administration->Globals->Security'),
(12171, 'Update the following variables in file'),
(12172, 'Update User Information'),
(12173, 'Updated By'),
(12174, 'Updated Definitions'),
(12175, 'Updated Definitions List'),
(12176, 'Updated fields will be purple.'),
(12177, 'Updated!'),
(12178, 'Updates Successful'),
(12179, 'Updating Access Controls'),
(12180, 'Updating demographics is not authorized.'),
(12181, 'Updating global configuration defaults'),
(12182, 'Updating version indicators'),
(12183, 'UPGRADE'),
(12184, 'Upgrade'),
(12185, 'Upgrade ACL'),
(12186, 'Upgrade Database'),
(12187, 'Upgrade SQL'),
(12188, 'Upgrades the OpenEMR database to include Procedures, Functions and tables needed for De-identification process'),
(12189, 'Upgrading will continue'),
(12190, 'UPIN'),
(12191, 'Upload'),
(12192, 'Upload / Save'),
(12193, 'Upload a Template'),
(12194, 'Upload and Apply'),
(12195, 'Upload and Install'),
(12196, 'Upload configuration data'),
(12197, 'Upload Document'),
(12198, 'Upload failed!'),
(12199, 'Upload For'),
(12200, 'Upload Image to'),
(12201, 'Upload import file:'),
(12202, 'Upload Item'),
(12203, 'Upload Patient Education PDF to'),
(12204, 'Upload processed successfully'),
(12205, 'Upload Report'),
(12206, 'Upload Template for'),
(12207, 'Upload the xml file under the category CCR'),
(12208, 'Upload this file:'),
(12209, 'Uploaded'),
(12210, 'Upon a successful search you are presented with a list of invoices. You may click on one of the invoice numbers to open a second window, which is the data entry page for manual posting. You may also click on a patient name if you want to enter a note that the front office staff will see when the patient checks in, and you may select invoices to appear on patient statements and print those statements.'),
(12211, 'Upon clicking an invoice number the \"manual posting window\" appears. Here you can change the due date and notes for the invoice, select the party for whom you are posting, and select the insurances for which all expected paymants have been received.  Most importantly, for each billing code for which an amount was charged, you can enter payment and adjustment information.'),
(12212, 'Upon clicking an invoice number the \'manual posting window\' appears. Here you can change the due date and notes for the invoice, select the party for whom you are posting, and select the insurances for which all expected payments have been received. Most importantly, for each billing code for which an amount was charged, you can enter payment and adjustment information.'),
(12213, 'Upon entering the page there are two buttons visible below the navigation bar'),
(12214, 'Upon logging in to openEMR a small envelope icon is visible on the top right. It shows the number of pending messages and dated reminders'),
(12215, 'Upon reaching a predetermined point, either a date or value, the rule will trigger one or more events'),
(12216, 'Upon searching you are presented with a list of invoices.  You may click on one of the invoice numbers to open a second window, which is the data entry page for manual posting.  You may also click on a patient name if you want to enter a note that the front office staff will see when the patient checks in, and you may select invoices to appear on patient statements and print those statements.'),
(12217, 'Upon selecting a list to edit the edit page with the list values will be displayed'),
(12218, 'Upon successful registration you will be taken back to the Manage Multi Factor Authentication landing page'),
(12219, 'Upper arm'),
(12220, 'Upper Lids'),
(12221, 'Urdu'),
(12222, 'Urgency'),
(12223, 'Urgent Care'),
(12224, 'Urgent Care Facility'),
(12225, 'URI'),
(12226, 'Urine'),
(12227, 'Urine Dribbling'),
(12228, 'Urine Frequency'),
(12229, 'Urine Hesitancy'),
(12230, 'Urine Microalbumin'),
(12231, 'Urine Stream'),
(12232, 'Urine Urgency'),
(12233, 'URL'),
(12234, 'URL for NewCrop eRx Site Address.'),
(12235, 'URL for OpenEMR support.'),
(12236, 'URL for Phone Gateway.'),
(12237, 'URL for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(12238, 'URL for the WordPress site that supports the portal'),
(12239, 'URL of ASSE SOAP server. Must be blank if not a Uruguay site. Enter \"test\" for dummy data.'),
(12240, 'URL to a support page.'),
(12241, 'URLs for NewCrop eRx Service Address, separated by a semi-colon.'),
(12242, 'Uruguay ASSE Token'),
(12243, 'Uruguay ASSE URL'),
(12244, 'Uruguay SINADI statistical report.'),
(12245, 'USA'),
(12246, 'Usage'),
(12247, 'Usage - is only required if you are submitting an electronic order to an external facility'),
(12248, 'Usage Indicator (ISA15)'),
(12249, 'Usage Tips'),
(12250, 'USB based tokens are used for Universal 2nd Factor - U2F authentication and as they are connected to a computer do not need batteries'),
(12251, 'Use % alone in a field to just sort on that column'),
(12252, 'Use 24 hour time format?'),
(12253, 'Use a pdf template from zend module'),
(12254, 'Use a unique word to identify this group, it has to be a single word, if using two words link them together with an underscore or hyphen.'),
(12255, 'Use Active Directory'),
(12256, 'Use an html template from zend module'),
(12257, 'Use Avery Labels'),
(12258, 'Use Blood or Serum as Specimen Type'),
(12259, 'Use certified EHR technology to identify patient-specific education resources and provide those resources to the patient if appropriate(New).'),
(12260, 'Use certified EHR technology to identify patient-specific education resources and provide those resources to the patient if appropriate.'),
(12261, 'Use Charges Panel'),
(12262, 'Use CPOE for medication orders directly entered by any licensed healthcare professional who can enter orders into the medical record per state, local and professional guidelines.'),
(12263, 'Use CPOE for medication orders.'),
(12264, 'Use CPOE for medication orders.(Alternative)'),
(12265, 'Use CPOE for procedure orders.'),
(12266, 'Use CPOE for radiology orders.'),
(12267, 'Use Custom Dunning Messages'),
(12268, 'Use Custom End of Day Report'),
(12269, 'Use Custom Immunization List'),
(12270, 'Use Custom Statement'),
(12271, 'Use Date Range'),
(12272, 'Use Default'),
(12273, 'Use Defaults'),
(12274, 'Use Delete Option to Remove.'),
(12275, 'Use international date style?'),
(12276, 'Use LDAP for Authentication'),
(12277, 'Use Portal Dashboard to confirm with patient.'),
(12278, 'Use RxCUI'),
(12279, 'Use RxNorm'),
(12280, 'Use servers protocol and host in urls (portal internal only).'),
(12281, 'Use source filename'),
(12282, 'Use SSL (encrypted) connection to CouchDB'),
(12283, 'Use the fee sheet to charge for services or products. '),
(12284, 'Use the fields below for a purchase or transfer.'),
(12285, 'Use the help file on that page for further help'),
(12286, 'Use the latest versions of the following modern browsers - Chrome, Firefox, Safari, Edge and Opera'),
(12287, 'Use the Select User dropdown box to select the user(s) to whom the message will be sent'),
(12288, 'Use this feature only with newly installed sites, '),
(12289, 'Use this image'),
(12290, 'Use this section to delete existing groups or Access Request Objects (AROs)'),
(12291, 'Use topics?'),
(12292, 'Use Username'),
(12293, 'Used on the login and about pages'),
(12294, 'Used to enter information that pertains to this particular claim in order to facilitate processing and submitting this claim'),
(12295, 'User'),
(12296, 'user'),
(12297, 'User '),
(12298, 'User / Groups'),
(12299, 'User Administration'),
(12300, 'User and Facility Administration'),
(12301, 'User and Group Administration'),
(12302, 'User Cannot be Deleted'),
(12303, 'User Certificate Authentication is disabled'),
(12304, 'User Debug Error Catch'),
(12305, 'User Debugging Mode.'),
(12306, 'User Debugging Options'),
(12307, 'User Defined'),
(12308, 'User Defined Area 11'),
(12309, 'User Defined Area 12'),
(12310, 'User Defined Field'),
(12311, 'User Defined List 1'),
(12312, 'User Defined List 2'),
(12313, 'User Defined List 3'),
(12314, 'User Defined List 4'),
(12315, 'User Defined List 5'),
(12316, 'User Defined List 6'),
(12317, 'User Defined List 7'),
(12318, 'User Defined Text 1'),
(12319, 'User Defined Text 2'),
(12320, 'User Defined Text 3'),
(12321, 'User Defined Text 4'),
(12322, 'User Defined Text 5'),
(12323, 'User Defined Text 6'),
(12324, 'User Defined Text 7'),
(12325, 'User Defined Text 8'),
(12326, 'User First name'),
(12327, 'User Id'),
(12328, 'User ID'),
(12329, 'User is required to have this access control for Active Alerts and Passive Alerts'),
(12330, 'User Logon (If 03 above, else leave spaces) (ISA02)'),
(12331, 'User logon Required Indicator (ISA01~ use 00 or 03)'),
(12332, 'User Manual'),
(12333, 'User Manual Link Override'),
(12334, 'User Memberships'),
(12335, 'User Name'),
(12336, 'User Name must be at least 12 characters!'),
(12337, 'User name or Host name cannot be empty'),
(12338, 'User or Host name'),
(12339, 'User Password'),
(12340, 'User Password (ISA04~ if 01 above, else leave spaces)'),
(12341, 'User password required Indicator (ISA03~ use 00 or 01)'),
(12342, 'User Settings'),
(12343, 'User Signature'),
(12344, 'User Specific Setting'),
(12345, 'User UUID'),
(12346, 'User\'s New Password'),
(12347, 'user_notes'),
(12348, 'Userlist1'),
(12349, 'Userlist2'),
(12350, 'Userlist3'),
(12351, 'Userlist4'),
(12352, 'Userlist5'),
(12353, 'Userlist6'),
(12354, 'Userlist7'),
(12355, 'username'),
(12356, 'Username'),
(12357, 'Username for Phone Gateway.'),
(12358, 'Username for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(12359, 'Username for SMS Gateway'),
(12360, 'Username for SMS Gateway.'),
(12361, 'Username to connect to CouchDB'),
(12362, 'Username:'),
(12363, 'Users'),
(12364, 'Users is the standard windows CN, replace the DC stuff with your domain.'),
(12365, 'Users may leave it plugged in at all times thus negating its function in 2FA'),
(12366, 'Users with appropriate privileges can edit these items by clicking on the Edit button'),
(12367, 'Users/Groups/Logs Administration'),
(12368, 'Users/Groups/Logs Administration (users)'),
(12369, 'Usertext1'),
(12370, 'Usertext2'),
(12371, 'Usertext3'),
(12372, 'Usertext4'),
(12373, 'Usertext5'),
(12374, 'Usertext6'),
(12375, 'Usertext7'),
(12376, 'Usertext8'),
(12377, 'uses php <a href=\"http://php.net/strftime\">strftime</a> format'),
(12378, 'Using 2FA'),
(12379, 'Using a fruit tree as an easier to visualize analogy will explain the concept of this hierarchy better, the trunk of the tree is the Group (Serum Chemistry), the fruit bearing branch is the actual order, Procedure Order (Serum Uric acid) and the fruit is the result, Discrete Result, also called (Serum Uric Acid) that will hold the value of the returned result. Just as the fruit is not borne on the main trunk you should not place a Discrete Result as a direct descendant or child of a Top Group. Similarly the fruit bearing branch (Procedure Order) cannot be placed as a direct descendant or child of a fruit (Discrete Result)'),
(12380, 'Using technology to improve productivity'),
(12381, 'Using the details entered into the system openEMR will generate valid HL7 v2.3 messages in 3 formats, a text file that is automatically downloaded to the downloads folder of your browser, a HL7 message that is written to a folder or directory on the server running openEMR or use SFTP - Secure File Transfer Protocol, which is a network protocol that provides file access, file transfer, and file management over a secure connection and transfer this message to a lab'),
(12382, 'Using the Feesheet'),
(12383, 'Using the main headings on the lab slip will help start this process - Organ/Disease Panels, Hematology, Individual Tests, Microbiology, Other'),
(12384, 'Using this fruit tree analogy we can get a better understanding of the steps needed to create an order for a panel of tests'),
(12385, 'Utilize at your own risk. Always verify data received'),
(12386, 'UTIs'),
(12387, 'UUID'),
(12388, 'Uyghur, Uighur'),
(12389, 'Uzbek'),
(12390, 'VABiNoc{{Binocular visual acuity}}'),
(12391, 'VABiNoc{{Binocular Visual Acuity}}'),
(12392, 'VACATION'),
(12393, 'Vacation'),
(12394, 'Vaccine'),
(12395, 'Vaccine funding program eligibility category'),
(12396, 'Vaccine Type'),
(12397, 'Vaginal Ring'),
(12398, 'Valedictory'),
(12399, 'Validate'),
(12400, 'validate'),
(12401, 'Validate and Clear'),
(12402, 'Validate and Clear validates then sets claims status only, to billed, leaving billing process unaltered and claim submission resets to unsubmitted.'),
(12403, 'Validate Log'),
(12404, 'Validate Only'),
(12405, 'Validate Only does a claim validation dry run for errors leaving claim status unaltered.'),
(12406, 'Validating'),
(12407, 'Validating Claim'),
(12408, 'Validation error: Fix and resubmit.'),
(12409, 'Validation error: Fix and resubmit. Payment values are preserved!'),
(12410, 'Validation error: Fix and resubmit. This popup info is preserved!'),
(12411, 'Validation mechanism for when modifying patient demographics.'),
(12412, 'Validation rule'),
(12413, 'Value'),
(12414, 'Value 1'),
(12415, 'Value 2'),
(12416, 'Value if comparing'),
(12417, 'Value Should be Numeric'),
(12418, 'Var1'),
(12419, 'Var2'),
(12420, 'variable to one to run de-identification upgrade script'),
(12421, 'Variation in red color discrimination between the eyes (eg. OD=100, OS=75)'),
(12422, 'Variation in white (muscle) light brightness discrimination between the eyes (eg. OD=$1.00, OS=$0.75)'),
(12423, 'Varicella 1'),
(12424, 'Varicella 2'),
(12425, 'Varicose Veins'),
(12426, 'Various text fields and drop-down boxes will be displayed'),
(12427, 'Vascular condition'),
(12428, 'Vascular injury'),
(12429, 'Vascular Surgery'),
(12430, 'Va{{Visual Acuities}}'),
(12431, 'VB{{abbreviation for Vertical Prism Base}}'),
(12432, 'VD{{abbreviation for Vertex Distance}}'),
(12433, 'Venda'),
(12434, 'Vendor'),
(12435, 'Verification Status'),
(12436, 'Verified On'),
(12437, 'Verify'),
(12438, 'Verify Contents to apply to'),
(12439, 'Verify Email'),
(12440, 'Verify your email for patient portal registration'),
(12441, 'Version'),
(12442, 'Version 1 Onsite Patient Portal Site Address'),
(12443, 'Version 2 Onsite Patient Portal Site Address'),
(12444, 'Version 2.x is widely used in the healthcare industry and openEMR uses HL7 version 2.3 '),
(12445, 'Version Number'),
(12446, 'Version/Model Number'),
(12447, 'Vert Base{{abbreviation for Vertical Prism Base}}'),
(12448, 'Vert Distance{{abbreviation for Vertex Distance}}'),
(12449, 'Vert Fissure{{vertical fissure height}}'),
(12450, 'Vert Fissure{{vertical fissure}}'),
(12451, 'Vert Fusional Amps'),
(12452, 'Vert Prism{{abbreviation for Vertical Prism Power}}'),
(12453, 'Vertex Distance'),
(12454, 'Vertical Fissure: central height between lid margins'),
(12455, 'Vertical Fusional'),
(12456, 'Vertical Menu Style'),
(12457, 'Vertical Menu Style for frame based layouts'),
(12458, 'Vertical Menu Style for Frames'),
(12459, 'Vertical Prism Base'),
(12460, 'Vertical Prism Power'),
(12461, 'Vertigo'),
(12462, 'Very difficult'),
(12463, 'Very secure'),
(12464, 'Vessels'),
(12465, 'Veteran`s Administration'),
(12466, 'Veterans Administration Plan'),
(12467, 'VFC'),
(12468, 'Vfc'),
(12469, 'VFC eligible- American Indian/Alaskan Native'),
(12470, 'VFC eligible- Uninsured'),
(12471, 'VFC eligible-Federally Qualified Health Center Patient (under-insured)'),
(12472, 'VFC eligible-Medicaid/Medicaid Managed Care'),
(12473, 'VF{{vertical fissure}}'),
(12474, 'via'),
(12475, 'via{{shipped by/supplier}}'),
(12476, 'Vietnamese'),
(12477, 'View'),
(12478, 'view'),
(12479, 'view - can only read but not add or modify'),
(12480, 'View Allergies'),
(12481, 'View an x12-835 ERA file'),
(12482, 'View Batch Claim x12 text'),
(12483, 'View Blank Referral Form'),
(12484, 'View CCD'),
(12485, 'View CCDA'),
(12486, 'View Comprehensive Patient Report'),
(12487, 'View CSV tables'),
(12488, 'View details'),
(12489, 'View document'),
(12490, 'View EDI x12 file'),
(12491, 'View encounter'),
(12492, 'View ERA x12 text'),
(12493, 'View events in a popup window?'),
(12494, 'View Facility Specific User Information'),
(12495, 'View Four Panel'),
(12496, 'View local x12 file'),
(12497, 'View Log'),
(12498, 'View Messages'),
(12499, 'View mode - only administrator can edit another administrator user'),
(12500, 'View Page 1'),
(12501, 'View Page 2'),
(12502, 'View Past and Future Reminders'),
(12503, 'View Past Encounter'),
(12504, 'View Past Encounters'),
(12505, 'View Patient'),
(12506, 'View Plan Rules'),
(12507, 'View Printable'),
(12508, 'View Printable Report'),
(12509, 'View Printable Version'),
(12510, 'View related encounters'),
(12511, 'View Report'),
(12512, 'View the README file'),
(12513, 'View the Summary Report sent to'),
(12514, 'View the Summary Report sent to Fax Server.'),
(12515, 'View the Summary Report sent via Fax Server on'),
(12516, 'View, Download, Transmit (VDT)  (Measure B)'),
(12517, 'View, Download, Transmit (VDT) (Measure A)'),
(12518, 'View/Add/Update groups'),
(12519, 'View/Add/Update groups (gadd)'),
(12520, 'View/Create/Update groups appointment in calendar'),
(12521, 'View/Create/Update groups appointment in calendar (gcalendar)'),
(12522, 'View/Edit'),
(12523, 'View/Edit Allergies'),
(12524, 'View/edit issue'),
(12525, 'View/Print'),
(12526, 'View/Print Blank Referral Form'),
(12527, 'View/Print Blank Referral Form - that can be filled by hand'),
(12528, 'View:'),
(12529, 'VISA'),
(12530, 'VISA/MC/AMEX/Dis'),
(12531, 'VISA/MC/Discovery/HSA'),
(12532, 'Visceral damage/trauma/surgery'),
(12533, 'VisForm'),
(12534, 'Vision'),
(12535, 'Visit'),
(12536, 'Visit Attributes'),
(12537, 'Visit Categories'),
(12538, 'Visit Category'),
(12539, 'Visit Category:'),
(12540, 'Visit Date'),
(12541, 'Visit date'),
(12542, 'Visit Details'),
(12543, 'Visit Form Attributes'),
(12544, 'Visit form ID must start with LBF. Transaction form ID must start with LBT.'),
(12545, 'Visit Forms'),
(12546, 'Visit Forum'),
(12547, 'Visit History'),
(12548, 'Visit Patient Home Page'),
(12549, 'Visit Provider Home Page'),
(12550, 'Visit Reason'),
(12551, 'Visit Status'),
(12552, 'Visit Summary'),
(12553, 'Visit Test Server'),
(12554, 'Visit Type'),
(12555, 'Visited Patients'),
(12556, 'Visits'),
(12557, 'Visits by Item Report'),
(12558, 'Visits From'),
(12559, 'Visual Acuities'),
(12560, 'Visual Acuity'),
(12561, 'Visual Fields'),
(12562, 'Visualize this as not making a fruit hang off another fruit. Instead it should hang off the fruit bearing branch'),
(12563, 'Vital Signs'),
(12564, 'Vitals'),
(12565, 'Vitals (Metric)'),
(12566, 'Vitals Form Options'),
(12567, 'Vitreous'),
(12568, 'Voice'),
(12569, 'Voice Messages'),
(12570, 'Voice Sent'),
(12571, 'Voice your opinion'),
(12572, 'Void'),
(12573, 'Void All Checkouts'),
(12574, 'Void All Checkouts and Re-Open'),
(12575, 'Void Charge'),
(12576, 'Void Checkout and Re-Open'),
(12577, 'Void Dialog'),
(12578, 'Void Last Checkout'),
(12579, 'Void Notes'),
(12580, 'Void Reason'),
(12581, 'Void/Credit'),
(12582, 'Volapuk'),
(12583, 'Volapük'),
(12584, 'Vomiting'),
(12585, 'Voucher Number'),
(12586, 'VP{{abbreviation for Vertical Prism Power}}'),
(12587, 'V{{One letter abbrevation for Vision}}'),
(12588, 'W'),
(12589, 'W Rx{{Acuity with correction}}'),
(12590, 'W2W{{white-to-white}}'),
(12591, 'Waist Circ'),
(12592, 'Waist Circumference'),
(12593, 'Waiting'),
(12594, 'Walk-In'),
(12595, 'Walk-in Retail Health Clinic'),
(12596, 'Walloon'),
(12597, 'Walt Pennington'),
(12598, 'Ward of court'),
(12599, 'Warehouse'),
(12600, 'Warehouse changed'),
(12601, 'Warehouse Details'),
(12602, 'Warehouse maximum, 0 if not applicable'),
(12603, 'Warehouse minimum, 0 if not applicable'),
(12604, 'Warehouses'),
(12605, 'Warm'),
(12606, 'Warn and prevent web browser refresh'),
(12607, 'Warn, but do not prevent web browser refresh'),
(12608, 'Warning'),
(12609, 'WARNING'),
(12610, 'WARNING - FOLLOWING ACTIVE MEDICATIONS ARE ALLERGIES'),
(12611, 'Warning, Check Number already exist in the database'),
(12612, 'Warning, patient has ambiguous codes in the problems list!'),
(12613, 'Warning: A visit was already created for this patient today!'),
(12614, 'Warning: Contraception for a patient under 10 or over 50.'),
(12615, 'Warning: Contraception for a patient under 10 or over 65.'),
(12616, 'Warning: Contraceptive method is not compatible with a male patient.'),
(12617, 'WARNING: If you are using the 2012-10-31 Spanish version, then note you need to unzip it once before placing it in the contrib/snomed (this is because the released file was \"double-zipped\").'),
(12618, 'Warning: Most lots should have an expiration date. Continue anyway?'),
(12619, 'Warning: Navigation error. Please refresh this page.'),
(12620, 'Warning: Patient ID is not unique!'),
(12621, 'Warning: Source and target facilities differ. Continue anyway?'),
(12622, 'Warning: There is no product matching the contraceptive service.'),
(12623, 'Warning: There is no service matching the contraceptive product.'),
(12624, 'WARNING: This will overwrite configuration information with data from the uploaded file!'),
(12625, 'WARNINGS'),
(12626, 'Warnings'),
(12627, 'WARNINGS and Alerts/Reminders'),
(12628, 'was already uploaded'),
(12629, 'was not found'),
(12630, 'We appreciate prompt payment of balances due'),
(12631, 'We appreciate prompt payment of balances due.'),
(12632, 'We are going to create the test that can be ordered called Serum Uric Acid'),
(12633, 'We are sorry you are having troubles with your account.'),
(12634, 'we have seen your above patient for evaluation and treatment at our outpatient psychiatry clinic. Thank you for this referral.'),
(12635, 'We ran into some problems connecting your EHR to the MedEx servers'),
(12636, 'We received a credentials reset request. The link to reset your credentials is below.'),
(12637, 'We received a patient registration email verification request from this email address at'),
(12638, 'We received a patient registration email verification request. The link to verify your email is below.'),
(12639, 'We were unable to create an account.'),
(12640, 'We will be basing the Electrolyte panel off the main trunk or Group (Serum Chemistry)'),
(12641, 'We will be creating an order for three tests Blood Glucose, TSH and Vitamin D and group it in a custom group called Well Woman Tests and create a place to manually enter the returned results'),
(12642, 'We will go through the process of setting up the order for a single blood test - Serum Uric Acid'),
(12643, 'We will now create the order, or Procedure Order, called Electrolyte Panel that can be visualized as the fruit bearing branch in our hypothetical fruit tree'),
(12644, 'We will set up the order for the Electrolyte panel that consists of Serum Sodium, Potassium, Chloride and Carbon Dioxide'),
(12645, 'We will start with the most basic unit of the Procedure Orders module, to set up a single lab test order and the ability to manually record the returned result'),
(12646, 'We will use a Discrete Result for each test to hold the returned result values'),
(12647, 'We will use this branch to hold all the 9 panels, here we will be just creating the order representing one panel, the Electrolyte Panel'),
(12648, 'Weakness'),
(12649, 'Wear RX'),
(12650, 'Web based methods'),
(12651, 'Web based methods use Authentication-as-a-service and deliver OTP without need for tokens'),
(12652, 'Web Reference'),
(12653, 'Web Search'),
(12654, 'Web Service'),
(12655, 'Website'),
(12656, 'Website link for the Onsite Patient Portal.'),
(12657, 'Website link for the Patient Portal.'),
(12658, 'Website link for the Version 1 Onsite Patient Portal.'),
(12659, 'Website link for the Version 2 Onsite Patient Portal.'),
(12660, 'Wed'),
(12661, 'Wednesday'),
(12662, 'Week'),
(12663, 'week'),
(12664, 'Week View'),
(12665, 'Week(s)'),
(12666, 'Weekly Exposures'),
(12667, 'weeks'),
(12668, 'Weeks'),
(12669, 'Weight'),
(12670, 'Weight Assessment and Counseling for Children and Adolescents'),
(12671, 'Weight Assessment and Counseling for Children and Adolescents (CQM)'),
(12672, 'Weight Change'),
(12673, 'Weight Loss'),
(12674, 'Weight loss clinic'),
(12675, 'Welcome'),
(12676, 'Welcome to OpenEMR'),
(12677, 'Welsh'),
(12678, 'Weno Account Clinic ID information missing'),
(12679, 'Weno Account ID information missing'),
(12680, 'Weno Admin'),
(12681, 'Weno Encryption Key'),
(12682, 'Weno eRx'),
(12683, 'Weno eRx Account Id'),
(12684, 'Weno eRx Account Pass'),
(12685, 'Weno eRx Clinic ID'),
(12686, 'Weno ID'),
(12687, 'Weno Provider Account Password'),
(12688, 'Weno Provider ID'),
(12689, 'Weno Sample Code'),
(12690, 'Weno Service is Enabled'),
(12691, 'Western Frisian'),
(12692, 'We{{Wednesday}}'),
(12693, 'What constitutes the order and what is its electronic format, how is it sent, how is the result received, if the system will only receive results or send orders and receive results, what labs you will be connecting to and what needs to happen at the other end, whether or not a third party will be involved in this transaction'),
(12694, 'What is to be counted?'),
(12695, 'What kind of sorting will be in the drop lists.'),
(12696, 'Wheezes:'),
(12697, 'Wheezing'),
(12698, 'Wheezing:'),
(12699, 'When a new user is created, access control is granted by the administrator or by a user with similar privileges by selecting which groups (AROs) a user can belong to.'),
(12700, 'When and how often?'),
(12701, 'When Checked, Demographics Will Open in New Window from Patient Flow Board.'),
(12702, 'When Checked, Last Staff to Update Board Will Show in Patient Flow Board.'),
(12703, 'When checked, messages are processed for patients with Patient Demographic Choice: \"Hipaa Notice Received\" set to \"Unassigned\" or \"Yes\". When unchecked, this choice must = \"YES\" to process the patient reminder. For patients with Choice =\"No\", Reminders will need to be processed manually.'),
(12704, 'When Checked, Patient Encounter Number Will Show in Patient Flow Board.'),
(12705, 'When Checked, Patient ID Will Show in Patient Flow Board.'),
(12706, 'When Checked, Visit Reason Will Show in Patient Flow Board.'),
(12707, 'When dealing with protected health information (PHI) and personally identifying information (PII) it is important to allow only authorized users access to the data'),
(12708, 'When done, click Submit (below) to apply your choices.'),
(12709, 'When such an order is placed the returned results will contains the values for all components of CBC, Comprehensive Metabolic Panel and TSH'),
(12710, 'When the generated report is displayed in a separate tab there is an option that lets you view a Printable Version that can be printed'),
(12711, 'When the key is first registered it generates a random number, which is called a nonce'),
(12712, 'When the user initially visits this page the following message will be visible'),
(12713, 'When to follow up'),
(12714, 'When you are ready to run phiMail in production mode. Turn on this flag.'),
(12715, 'When you place an order you can search for Well Woman Tests under favorites and select it to automatically order Blood Glucose, TSH and Vitamin D with a single click'),
(12716, 'Where may related scanned or paper documents be found?'),
(12717, 'Where on your body does it occur?'),
(12718, 'Whether Insured'),
(12719, 'which days are your weekend days?'),
(12720, 'Which notes are to be displayed in the Billing Screen'),
(12721, 'While forwarding a dated reminder the old message is displayed, it can be overwritten'),
(12722, 'While it is intuitive to think of this module as the place where lab tests and imaging studies can be ordered and reviewed this module can also be used to track other procedures performed in office'),
(12723, 'While lab tests and radiological tests can be performed in the practice facility they are generally done at an external facility and the provider details for that entity will have to be entered in openEMR before the Procedure module setup can begin'),
(12724, 'Whiplash'),
(12725, 'White'),
(12726, 'White list'),
(12727, 'White-to-white'),
(12728, 'Who'),
(12729, 'Who replied?'),
(12730, 'Whose Online'),
(12731, 'Widowed'),
(12732, 'Width'),
(12733, 'Width in pixels of the left navigation frame in frame based layout.'),
(12734, 'Width in pixels of the left navigation frame.'),
(12735, 'Will add another dropdown menu in the CPT line to let you select a provider for that line item'),
(12736, 'will be hidden if'),
(12737, 'will have the following validation rules'),
(12738, 'With checked items plot'),
(12739, 'with import'),
(12740, 'with preferred language'),
(12741, 'With selected'),
(12742, 'With selected:'),
(12743, 'with the old name'),
(12744, 'With the U2F key you will need to plug it in to the USB port and then access OpenEMR using the latest versions of the following modern browsers - Chrome, Firefox, Safari, Edge and Opera and pressing the button on the device'),
(12745, 'with value'),
(12746, 'With whom may we leave a message?'),
(12747, 'Withheld'),
(12748, 'within hours'),
(12749, 'within hours:'),
(12750, 'within minutes'),
(12751, 'within minutes:'),
(12752, 'Without Facility'),
(12753, 'Without Provider'),
(12754, 'Without Update'),
(12755, 'Witness'),
(12756, 'wk'),
(12757, 'WNL'),
(12758, 'Wolof'),
(12759, 'Women'),
(12760, 'Women Only'),
(12761, 'WordPress Portal'),
(12762, 'Work'),
(12763, 'WORK NOTE'),
(12764, 'Work Phone'),
(12765, 'Work Phone Number'),
(12766, 'Work related?'),
(12767, 'Work/ Education/ Hobbies'),
(12768, 'Work/School Note'),
(12769, 'workday'),
(12770, 'Worker`s Compensation'),
(12771, 'Workers Compensation Health Plan'),
(12772, 'Working'),
(12773, 'Working Aged Beneficiary or Spouse with Employer Group Health Plan'),
(12774, 'Working on request.'),
(12775, 'Working!'),
(12776, 'Working... this may take a minute.'),
(12777, 'Worrying'),
(12778, 'Worrying too much about different things'),
(12779, 'Worse'),
(12780, 'Would you like the balance amount to apply to Global Account?'),
(12781, 'Would You Like them to be Marked as Cleared.'),
(12782, 'Would you like to Allocate?'),
(12783, 'Would you like to Cancel Distribution for this Patient?'),
(12784, 'Would you like to Delete Payment Distribution?'),
(12785, 'Would you like to Delete Payments?'),
(12786, 'Would you like to Modify and Finish Payments?'),
(12787, 'Would you like to Modify Payments?'),
(12788, 'Would you like to Post and Finish Payments?'),
(12789, 'Would you like to Post Payments?'),
(12790, 'Would you like to save?'),
(12791, 'Wrist'),
(12792, 'Wrist and hand'),
(12793, 'Wrist Problems'),
(12794, 'write'),
(12795, 'write - can read and fully modify'),
(12796, 'write off'),
(12797, 'Write Once'),
(12798, 'wsome'),
(12799, 'wsome - can read and partially modify'),
(12800, 'WSXGA+'),
(12801, 'WT'),
(12802, 'W{{Current Rx - wearing}}'),
(12803, 'W{{Wednesday}}'),
(12804, 'x Canceled'),
(12805, 'x Cancelled'),
(12806, 'X(T){{intermittent exophoria}}'),
(12807, 'X-12 Generated Successfully'),
(12808, 'X-12 Partner'),
(12809, 'X-ray'),
(12810, 'X-RAY Interpretation:'),
(12811, 'X-Ray Interpretation:'),
(12812, 'X12 only ICN resubmission No.'),
(12813, 'X12 only replacement claim:'),
(12814, 'X12 only: Replacement Claim'),
(12815, 'X12 only: Replacement Claim '),
(12816, 'X12 only: Replacement Claim, X12 only ICN resubmission No is used for electronic resubmission of claims. Requirement varies by insurer'),
(12817, 'X12 OPTIONS'),
(12818, 'X12 Partner'),
(12819, 'X12 Partners'),
(12820, 'x12 Segments'),
(12821, 'x12 Text'),
(12822, 'Xhosa'),
(12823, 'XHR Failed:'),
(12824, 'XML'),
(12825, 'XT{{exotropia}}'),
(12826, 'X{{exophoria}}'),
(12827, 'Y'),
(12828, 'year'),
(12829, 'Year'),
(12830, 'Year View'),
(12831, 'Year(s)'),
(12832, 'Years'),
(12833, 'years ago'),
(12834, 'Years or months'),
(12835, 'Years, months and days'),
(12836, 'Yes'),
(12837, 'YES'),
(12838, 'yes'),
(12839, 'YES!'),
(12840, 'Yes, Delete and Log'),
(12841, 'Yes, Delete this form'),
(12842, 'Yes/No'),
(12843, 'Yes:'),
(12844, 'Yiddish'),
(12845, 'Yoruba'),
(12846, 'You are about to delete a template'),
(12847, 'You are about to delete template'),
(12848, 'You are about to delete the following form from this encounter'),
(12849, 'You are about to permanently replace the existing template. Are you sure you wish to continue?'),
(12850, 'You are currently logged in as'),
(12851, 'You are currently not signed in.'),
(12852, 'You are in Grace Login period. Change your password before'),
(12853, 'You are not allowed to delete this event'),
(12854, 'You are not allowed to edit this event'),
(12855, 'You are not authorized for this.'),
(12856, 'You are not authorized to access this squad'),
(12857, 'You are not authorized to access this squad.'),
(12858, 'You are not authorized to add/edit issues'),
(12859, 'You are not authorized to schedule appointments.'),
(12860, 'You are not authorized to see this encounter.'),
(12861, 'You are not authorized!'),
(12862, 'You are posting against an old encounter?'),
(12863, 'You are sending to yourself!'),
(12864, 'You are using patient validation module'),
(12865, 'You can add multiple patients to the list'),
(12866, 'You can add multiple users by selecting them one at a time'),
(12867, 'You can also add an Issue from this page by clicking on the Add Issue button to bring up the Add issue pop-up page'),
(12868, 'You can change the type or leave it as it is'),
(12869, 'You can click on the envelope icon to access the messaging center'),
(12870, 'You can click on the patient name to quickly access the patient\'s chart'),
(12871, 'You can click on the Select All button to choose all authorized users'),
(12872, 'You can close the edit box by clicking on the \'slashed eye\' icon next to the group\'s name.'),
(12873, 'You can delete the recall by clicking on the X button on the top right corner of the cell'),
(12874, 'You can download the Loinc Universal LabOrders ValueSet.csv file from here'),
(12875, 'You can edit the title if you so choose'),
(12876, 'You can enter data into all 5 categories from this page'),
(12877, 'You can link the allergy to one or more encounters if appropriate'),
(12878, 'You can link the medication to one or more encounters if appropriate'),
(12879, 'You can not access this function directly.'),
(12880, 'You can not change status to \'Arrive\' before the appointment\'s time'),
(12881, 'You can only add to the existing message and cannot edit previously entered data'),
(12882, 'You can only place an order for Electrolyte Panel and have the entire panel tested and have their results returned'),
(12883, 'You can only select'),
(12884, 'You can search for and select the codes by clicking once on each line containing the code'),
(12885, 'You can sort the pending messages in ascending or descending order by clicking on the arrowhead in each cell of the table header'),
(12886, 'You can then proceed to link the newly added issue to encounters'),
(12887, 'You can upload content and label them by ICD10 code enable you to search and download the selected material'),
(12888, 'You can use LOINC codes for the Standard Codes'),
(12889, 'You can use the above method to create orders for the rest of the Organ/Disease Panels except for the General Health Panel that consists of CBC, Comprehensive Metabolic Panel and TSH and the Obstetric Panel that has CBC as one of its components'),
(12890, 'You can use the codes given on the paper lab slip of a local lab of major lab as the Identifying codes'),
(12891, 'You cannot access this page directly.'),
(12892, 'You cannot add a blank value for a category!'),
(12893, 'You cannot add a blank value for a subcategory!'),
(12894, 'You cannot add a blank value for an item!'),
(12895, 'You cannot edit the already chosen lab, if sending to different lab delete entry and create a new one'),
(12896, 'You cannot enter a future date with a completed value of YES.'),
(12897, 'You could manually edit this date should you choose to or an entirely different date'),
(12898, 'You did not choose any actions.'),
(12899, 'You do not have access to view/edit this note'),
(12900, 'You have'),
(12901, 'You have an invoice due for payment in your Patient Documents. There you may pay, download or print the invoice. Thank you.'),
(12902, 'You have attempted to alter content which is locked. Remove the lock if you want to do this. To unlock, remove the line, \'/*lock::*/\''),
(12903, 'You have been signed out. Thank you.'),
(12904, 'You have been successfully logged out.'),
(12905, 'You have chosen to be self insured or currently do not have insurance. Click next to continue registration.'),
(12906, 'You have finished the assessment.'),
(12907, 'You have not entered any clinical services or products. Click Cancel to add them. Or click OK if you want to save as-is.'),
(12908, 'You have now successfully completed an order for a single lab test'),
(12909, 'You have selected to delete'),
(12910, 'You have to have an understanding how the program is structured and the ability and willingness to modify the underlying code.'),
(12911, 'You have unsaved changes.'),
(12912, 'You have unsaved changes. Abandon them?'),
(12913, 'You have unsaved changes. Do you really want to close this form?'),
(12914, 'You may be required to change your password during first login.'),
(12915, 'You may only upload .txt files'),
(12916, 'You may optionally upload HL7 results from a file'),
(12917, 'You may put text here as the default complaint in the New Patient Encounter form.'),
(12918, 'You may send Message with Image or Video'),
(12919, 'You may still use formatting if template is also used in Nation Notes however, pure text will still render here.'),
(12920, 'You may type in a name of the person referring or leave blank'),
(12921, 'You may want to try returning to the the previous page and verifying that all fields have been filled out correctly.'),
(12922, 'You must activate Weno first! Go to Administration, Globals, Connectors'),
(12923, 'You must add a patient to the list before hitting ok'),
(12924, 'You must agree to the HIPAA Business Associate Agreement'),
(12925, 'You must agree to the Terms & Conditions before signing up'),
(12926, 'You must confirm this Username.'),
(12927, 'You must enter a new or reenter current password to keep it. Even for Username change.'),
(12928, 'You must enter a pass phrase to encrypt the document'),
(12929, 'You must enter a reason to cancel this appointment?'),
(12930, 'You must enter your own password to change user passwords. Leave blank to keep password unchanged.'),
(12931, 'You must first select an item in the section whose radio button is checked.'),
(12932, 'You must first select or add a patient or therapy group.'),
(12933, 'You must first select or add a patient.'),
(12934, 'You must first select or create an encounter.'),
(12935, 'You must provide a patient name or id to add to the list'),
(12936, 'You must select a visit category'),
(12937, 'You must select a visit category.'),
(12938, 'You must select some fields to continue.'),
(12939, 'You need administrator privileges to add more options'),
(12940, 'You need administrator privileges to disable the default Recall Board'),
(12941, 'You need administrator privileges to enable the MedEx Communication Service'),
(12942, 'You need administrator privileges to give access to other groups'),
(12943, 'You need administrator privileges to increase the number of reminders to show'),
(12944, 'You need administrator privileges to perform the changes to the values in the drop-down boxes.'),
(12945, 'You need administrator privileges to perform the setup'),
(12946, 'You need administrator privileges to perform this action'),
(12947, 'You need to go back and and create a provider'),
(12948, 'You should be running this test if this claim appeared to generate successfully but the actual claim file does not contain any data or only an unfinished portion of the amount of data it is supposed to contain. It is obvious with HCFA claims because they are human readable, with X12 claims it is a more difficult process to determine if the claim is properly complete.'),
(12949, 'You should not make Discrete Result for Potassium be a descendant of a preceding Discrete Result i.e Sodium , i.e have a Tier value of 5'),
(12950, 'You should select at least one context'),
(12951, 'You should select at least one Provider'),
(12952, 'You will be automatically redirected to Demographics. You may make the necessary corrections and navigate to NewCrop again.'),
(12953, 'You will be notified when the payment transaction is confirmed.'),
(12954, 'You will be notified when your payment is applied for this invoice.'),
(12955, 'You will need Administrator privileges to edit this form'),
(12956, 'You will need Administrator privileges to enable the patient portal'),
(12957, 'You will need Administrator Privileges to install the ICD10 code set'),
(12958, 'You will need Administrator privileges to setup phiMail Direct Messaging'),
(12959, 'You will need Administrator privileges to setup the NewCrop service and has to be setup in conjunction with technical support from the NewCrop eRx service'),
(12960, 'Your account has been successfully created however, we were unable to send the account information.'),
(12961, 'Your browser does not support HTML5 audio'),
(12962, 'Your Clinical Report'),
(12963, 'Your credentials are provided by your provider'),
(12964, 'Your current log on session will expire in 30 seconds.'),
(12965, 'Your current TOTP key QR code is displayed below.'),
(12966, 'Your Document History'),
(12967, 'your email address'),
(12968, 'Your email has been verified. Click Next.'),
(12969, 'Your email verification link has expired. Reset and try again.'),
(12970, 'Your end date is invalid'),
(12971, 'Your event has been deleted.'),
(12972, 'Your event has been modified.'),
(12973, 'Your event has been submitted.'),
(12974, 'Your file doesn\'t have an extension'),
(12975, 'Your file is too large'),
(12976, 'Your first day of the week.'),
(12977, 'Your Id is missing. Cancel and try again.'),
(12978, 'Your installation of OpenEMR has been registered'),
(12979, 'Your JWKS is invalid'),
(12980, 'Your Lab Results'),
(12981, 'Your list name has been changed to meet naming requirements.'),
(12982, 'Your message was submitted for delivery to'),
(12983, 'Your name for this category, procedure or result'),
(12984, 'Your new credentials have been sent. Check your email inbox and also possibly your spam folder. Once you log into your patient portal feel free to make an appointment or send us a secure message. We look forward to seeing you soon.'),
(12985, 'your next appointment at'),
(12986, 'Your on file email address'),
(12987, 'Your one time credential reset link has expired. Reset and try again.'),
(12988, 'Your Password'),
(12989, 'Your Password Expired. Please change your password.'),
(12990, 'Your Password Expires on'),
(12991, 'Your password expires today. Please change your password now.'),
(12992, 'Your Password Expires today. Please change your password.'),
(12993, 'Your password is your signature'),
(12994, 'Your Portal Login Web Address. Bookmark for future logins.'),
(12995, 'Your PostCalendar configuration has been reset to use defaults.'),
(12996, 'Your PostCalendar configuration has been updated.'),
(12997, 'Your repeating frequency must be an integer.'),
(12998, 'Your repeating frequency must be at least 1.'),
(12999, 'Your safe key is'),
(13000, 'Your start date is greater than your end date'),
(13001, 'Your start date is invalid'),
(13002, 'Your submission failed.'),
(13003, 'Your weekend days'),
(13004, 'Yubikey also sells more expensive U2F keys designed to work with mobile devices'),
(13005, 'yyyy-mm-dd'),
(13006, 'YYYY-MM-DD'),
(13007, 'yyyy-mm-dd date associated with this document'),
(13008, 'yyyy-mm-dd date destroyed'),
(13009, 'yyyy-mm-dd date of birth'),
(13010, 'yyyy-mm-dd Date of Birth'),
(13011, 'yyyy-mm-dd date of expiration'),
(13012, 'yyyy-mm-dd Date of onset or hospitalization'),
(13013, 'yyyy-mm-dd date of onset, surgery or start of medication'),
(13014, 'yyyy-mm-dd date of purchase or transfer'),
(13015, 'yyyy-mm-dd date of recovery or end of medication'),
(13016, 'yyyy-mm-dd Date of return to play'),
(13017, 'yyyy-mm-dd Date of service'),
(13018, 'yyyy-mm-dd date of this letter'),
(13019, 'yyyy-mm-dd date returned to play'),
(13020, 'yyyy-mm-dd document date'),
(13021, 'yyyy-mm-dd End Date'),
(13022, 'yyyy-mm-dd event date or starting date'),
(13023, 'yyyy-mm-dd H:m End Date'),
(13024, 'yyyy-mm-dd H:m End date'),
(13025, 'yyyy-mm-dd H:m Start Date'),
(13026, 'yyyy-mm-dd H:m Start date'),
(13027, 'yyyy-mm-dd hh:mm:ss'),
(13028, 'yyyy-mm-dd Hours(24):minutes'),
(13029, 'yyyy-mm-dd last date of this event'),
(13030, 'yyyy-mm-dd Start Date'),
(13031, 'yyyy-mm-dd starting date for search'),
(13032, 'ZEF segment internal error'),
(13033, 'Zend Module'),
(13034, 'Zend Module check in addition to standard check'),
(13035, 'Zero'),
(13036, 'Zero length attachment'),
(13037, 'Zero Stock Days'),
(13038, 'Zhuang, Chuang'),
(13039, 'Zip'),
(13040, 'Zip Code'),
(13041, 'ZIP Code'),
(13042, 'Zip Code Missing'),
(13043, 'Zip/Country:'),
(13044, 'Zoom'),
(13045, 'Zoom in'),
(13046, 'Zoom out'),
(13047, 'Zoom: click-drag, Pan: shift-click-drag, Restore: double-click'),
(13048, 'Zulu'),
(13049, ' but was '),
(13050, ' could not be accessed.'),
(13051, ' Do you really want to delete'),
(13052, ' Drug'),
(13053, ' emails not sent'),
(13054, ' from'),
(13055, ' has been created. '),
(13056, ' has been re-opened.'),
(13057, ' History'),
(13058, ' is not a number'),
(13059, ' is ready for re-billing.'),
(13060, ' LLL:'),
(13061, ' Lot'),
(13062, ' Medicaid Original Reference No. '),
(13063, ' min'),
(13064, ' not found!'),
(13065, ' Pecularities in many browsers may mean that the output below enters your screen in sudden jerks and that there are long pauses of several seconds where it  appears as though things may have crashed. That is not the case, you will eventually see output coming out line by line. There may be sequential numbers appearing  below, this is to indicate that even though nothing else may be displaying there is activity going on. These numbers will be interspersed with the content of the  billing and that is normal.'),
(13066, ' prescription has reached its limit of'),
(13067, ' until '),
(13068, ' update failed, not in database?'),
(13069, ' was marked as billed only.'),
(13070, ' was queued successfully.'),
(13071, '! Left w/o visit'),
(13072, '\" for code '),
(13073, '\" is CHECKED in PostCalendar Settings!'),
(13074, '# Ins/fin issue'),
(13075, '# of tablets:'),
(13076, '$'),
(13077, '$ Coding done'),
(13078, '$label (yyyy-mm-dd): '),
(13079, '%'),
(13080, '% Canceled < 24h'),
(13081, '% Cancelled <  24h '),
(13082, '\' should exist but does not.'),
(13083, '(% matches any string, _ matches any character)'),
(13084, '([ctrl] + click to select multiple recipients)'),
(13085, '(Back)'),
(13086, '(Click to edit)'),
(13087, '(Email delivery is immediate, while automated VOIP is sent to the service provider for further processing.)'),
(13088, '(More)'),
(13089, '(New Patient)'),
(13090, '(Notes and Authorizations)'),
(13091, '(Patient Notes)'),
(13092, '(Select one of these, or type your own title)'),
(13093, '(Shift-)Click or drag to change value'),
(13094, '* Reminder done'),
(13095, '** Please move surgeries to Issues!'),
(13096, '*Required'),
(13097, '+ Chart pulled'),
(13098, '+1'),
(13099, '+2'),
(13100, '+3'),
(13101, '- None'),
(13102, '- Not Reported'),
(13103, '-- All --'),
(13104, '--Select Role--'),
(13105, '.'),
(13106, '0'),
(13107, '0-10'),
(13108, '0-24'),
(13109, '02/12{{CMS 1500 format date revision setting in globals}}'),
(13110, '08/05{{CMS 1500 format date revision setting in globals}}'),
(13111, '1'),
(13112, '1 = North America. See http://www.wtng.info/ for a list of other country codes.'),
(13113, '1 Day From Now'),
(13114, '1 Month From Now'),
(13115, '1 Week From Now'),
(13116, '1 Year From Now'),
(13117, '1.Rest 2. Ice for two days 3. Compression, leave the dressing in place unless the foot develops numbness or pale color 4. Elevate the foot and leg'),
(13118, '11-14'),
(13119, '12 hr'),
(13120, '15-19'),
(13121, '1mm'),
(13122, '1st'),
(13123, '1st{{nth}}'),
(13124, '2'),
(13125, '2 Days From Now'),
(13126, '2 Months From Now'),
(13127, '2 Weeks From Now'),
(13128, '2 Years From Now'),
(13129, '2-20 years'),
(13130, '20-24'),
(13131, '2011 Automated Measure Calculations (AMC)'),
(13132, '2011 Clinical Quality Measures (CQM)'),
(13133, '2011 Official Clinical Quality Measures (CQM) Measure Groups'),
(13134, '2014 Automated Measure Calculations (AMC)'),
(13135, '2014 Automated Measure Calculations (AMC) - Stage I'),
(13136, '2014 Automated Measure Calculations (AMC) - Stage II'),
(13137, '2014 Clinical Quality Measures (CQM)'),
(13138, '2014 Official Clinical Quality Measures (CQM) Measure Groups'),
(13139, '2111-13'),
(13140, '24 hr'),
(13141, '25+'),
(13142, '25-29'),
(13143, '271 Returned'),
(13144, '2mm'),
(13145, '2nd'),
(13146, '2nd{{every}}'),
(13147, '2nd{{nth}}'),
(13148, '3 Days From Now'),
(13149, '3 months'),
(13150, '3 Months From Now'),
(13151, '3 times daily'),
(13152, '3 Weeks From Now'),
(13153, '30-34'),
(13154, '35-39'),
(13155, '3mm'),
(13156, '3rd'),
(13157, '3rd{{every}}'),
(13158, '3rd{{nth}}'),
(13159, '4 Days From Now'),
(13160, '4 months'),
(13161, '4 Months From Now'),
(13162, '4 times daily'),
(13163, '4 Weeks From Now'),
(13164, '40-44'),
(13165, '45+'),
(13166, '465.9, URI'),
(13167, '466.0, Bronchitis, Acute NOS'),
(13168, '486.0, Pneumonia, Acute'),
(13169, '491.21, COPD Exacerbation'),
(13170, '491.8, Bronchitis, Chronic'),
(13171, '493.92, Asthma, Acute Exac.'),
(13172, '496.0, COPD'),
(13173, '4K UHD'),
(13174, '4mm'),
(13175, '4th'),
(13176, '4th{{every}}'),
(13177, '4th{{nth}}'),
(13178, '5 Days From Now'),
(13179, '5 Months From Now'),
(13180, '5 Weeks From Now'),
(13181, '519.7, Bronchospasm'),
(13182, '5mm'),
(13183, '5th'),
(13184, '5th{{every}}'),
(13185, '6 Days From Now'),
(13186, '6 months'),
(13187, '6 Months From Now'),
(13188, '6 Weeks From Now'),
(13189, '6th'),
(13190, '6th{{every}}'),
(13191, '7 Months From Now'),
(13192, '8 Months From Now'),
(13193, '8-12 characters long, including at least one upper case letter, one lower case letter, one number, one special character and no common strings'),
(13194, '824.0 Fracture, medial malleolus, closed'),
(13195, '824.2 Fracture, lateral malleolus, closed'),
(13196, '824.6 Fracture, Trimalleolar, closed'),
(13197, '825.32 Fracture, of Navicular (ankle)'),
(13198, '825.35 Fracture, Base of fifth (5th) Metatarsal'),
(13199, '845.00 ankle sprain NOS'),
(13200, '845.01 Sprain Medial (Deltoid) Lig.'),
(13201, '845.02 Sprain, Calcaneal fibular'),
(13202, '9 Months From Now'),
(13203, '99212 Established - Uncomplicated'),
(13204, '99213 Established - Low Complexity'),
(13205, '< In exam room'),
(13206, '< Not Reported'),
(13207, '= Took Place'),
(13208, '> 3 HPI elements'),
(13209, '> Checked out'),
(13210, '> Did Not Take Place'),
(13211, '?'),
(13212, '? Did Not Attend'),
(13213, '? No show'),
(13214, '@ Arrived'),
(13215, '@ Attended'),
(13216, '[Change View]'),
(13217, '[Date of Last Encounter]'),
(13218, '[Days Since Last Encounter]'),
(13219, '[EOBs]'),
(13220, '[Export OFX]'),
(13221, '[not recommended]'),
(13222, '[Number Of Encounters]'),
(13223, '[Reports]'),
(13224, '[Select All]'),
(13225, '[SQL-Ledger]'),
(13226, '[Start Batch Processing]'),
(13227, '[View Log]'),
(13228, '[View Printable Report]'),
(13229, '^ Pending'),
(13230, '_PC_DUR_HOURS'),
(13231, '_PC_DUR_MINUTES'),
(13232, '_PC_LOCALE'),
(13233, '~ Arrived late'),
(13234, '~ Late Arrival');

--


--
-- Table structure for table `lang_definitions`
--


DROP TABLE IF EXISTS `lang_definitions`;
CREATE TABLE `lang_definitions` (
  `def_id` int(11) NOT NULL auto_increment,
  `cons_id` int(11) NOT NULL default '0',
  `lang_id` int(11) NOT NULL default '0',
  `definition` mediumtext,
  UNIQUE KEY `def_id` (`def_id`),
  KEY `cons_id` (`cons_id`),
  KEY `lang_cons` (`lang_id`, `cons_id`)
) ENGINE=InnoDB AUTO_INCREMENT=234779 ;


--
-- Dumping data for table `lang_definitions`
--

INSERT INTO `lang_definitions` VALUES (1, 1, 2, 'En');
INSERT INTO `lang_definitions` VALUES (2, 2, 2, 'Ett betalningsnr för att identifiera betalningen');
INSERT INTO `lang_definitions` VALUES (3, 4, 2, 'Klientcertifikat för admin användaren');
INSERT INTO `lang_definitions` VALUES (4, 7, 2, 'Ett klinikdokument är bifogat');
INSERT INTO `lang_definitions` VALUES (5, 13, 2, 'En distributör behövs');
INSERT INTO `lang_definitions` VALUES (6, 17, 2, 'Ett GCAC besöksformulär ska läggas till för detta besök');
INSERT INTO `lang_definitions` VALUES (7, 20, 2, 'Ett lot-nr krävs!');
INSERT INTO `lang_definitions` VALUES (8, 21, 2, 'Ett lot-nr krävs!');
INSERT INTO `lang_definitions` VALUES (9, 22, 2, 'En liten bokstav');
INSERT INTO `lang_definitions` VALUES (10, 28, 2, 'Ett tal');
INSERT INTO `lang_definitions` VALUES (11, 30, 2, 'En patient med detta ID finns redan');
INSERT INTO `lang_definitions` VALUES (12, 31, 2, 'En patient med detta namn finns redan');
INSERT INTO `lang_definitions` VALUES (13, 32, 2, 'En patient med detta personnummer ( SS ) finns redan');
INSERT INTO `lang_definitions` VALUES (14, 37, 2, 'Ett positivt nummer kommer visa antalet tidigare bokningar i en ruta på patientöversikten.');
INSERT INTO `lang_definitions` VALUES (15, 44, 2, 'Den remitterande instansen kan framgå vid varje besök');
INSERT INTO `lang_definitions` VALUES (16, 45, 2, 'En relaterad IPPF kod krävs!');
INSERT INTO `lang_definitions` VALUES (17, 52, 2, 'Ett specialtecken');
INSERT INTO `lang_definitions` VALUES (18, 56, 2, 'Ett unikt värde, som ej är synlig för användaren, identifierar detta fält.');
INSERT INTO `lang_definitions` VALUES (19, 62, 2, 'Före måltid');
INSERT INTO `lang_definitions` VALUES (20, 63, 2, 'förmiddag');
INSERT INTO `lang_definitions` VALUES (21, 67, 2, 'AB');
INSERT INTO `lang_definitions` VALUES (22, 68, 2, 'Förkortning');
INSERT INTO `lang_definitions` VALUES (23, 69, 2, 'Abscess');
INSERT INTO `lang_definitions` VALUES (24, 70, 2, 'Abdominell');
INSERT INTO `lang_definitions` VALUES (25, 71, 2, 'kan bära vikt fyra (4) steg:');
INSERT INTO `lang_definitions` VALUES (26, 72, 2, 'Patologisk');
INSERT INTO `lang_definitions` VALUES (27, 75, 2, 'ABN1');
INSERT INTO `lang_definitions` VALUES (28, 77, 2, 'Patologisk');
INSERT INTO `lang_definitions` VALUES (29, 78, 2, 'Patologiskt blodprov');
INSERT INTO `lang_definitions` VALUES (30, 79, 2, 'Avvikande hårväxt');
INSERT INTO `lang_definitions` VALUES (31, 80, 2, 'Patologisk mammografi');
INSERT INTO `lang_definitions` VALUES (32, 86, 2, 'Abort');
INSERT INTO `lang_definitions` VALUES (33, 87, 2, 'Abortrelaterad problematik');
INSERT INTO `lang_definitions` VALUES (34, 88, 2, 'Abortmetod');
INSERT INTO `lang_definitions` VALUES (35, 89, 2, 'Abortrelaterade kategorier');
INSERT INTO `lang_definitions` VALUES (36, 90, 2, 'Aborter');
INSERT INTO `lang_definitions` VALUES (37, 93, 2, 'Om kalendern');
INSERT INTO `lang_definitions` VALUES (38, 96, 2, 'Frånvaro av Diagnos');
INSERT INTO `lang_definitions` VALUES (39, 99, 2, 'Acceptera uppdrag');
INSERT INTO `lang_definitions` VALUES (40, 102, 2, 'acceptera betalning för');
INSERT INTO `lang_definitions` VALUES (41, 103, 2, 'acceptera betalning för');
INSERT INTO `lang_definitions` VALUES (42, 104, 2, 'Accepterar uppdrag');
INSERT INTO `lang_definitions` VALUES (43, 106, 2, 'Åtkomstkontroll');
INSERT INTO `lang_definitions` VALUES (44, 107, 2, 'Hantera åtkomst');
INSERT INTO `lang_definitions` VALUES (45, 115, 2, 'Åtkomst ej tillåten');
INSERT INTO `lang_definitions` VALUES (46, 116, 2, 'Åtkomst ej tillåten');
INSERT INTO `lang_definitions` VALUES (47, 119, 2, 'Öppna patientöversikten');
INSERT INTO `lang_definitions` VALUES (48, 127, 2, 'Konto namn');
INSERT INTO `lang_definitions` VALUES (49, 131, 2, 'Redovisning');
INSERT INTO `lang_definitions` VALUES (50, 138, 2, 'värker');
INSERT INTO `lang_definitions` VALUES (51, 140, 2, 'Begärt godokännande (ISA14)');
INSERT INTO `lang_definitions` VALUES (52, 141, 2, 'Godkännande, licenser och certifikat');
INSERT INTO `lang_definitions` VALUES (53, 142, 2, 'Användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (54, 143, 2, 'Administration av användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (55, 145, 2, 'Ej behörig administrera användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (56, 149, 2, 'Akne');
INSERT INTO `lang_definitions` VALUES (57, 152, 2, 'Aktuellt');
INSERT INTO `lang_definitions` VALUES (58, 153, 2, 'Aktivitetsdatum');
INSERT INTO `lang_definitions` VALUES (59, 154, 2, 'Åtgärd');
INSERT INTO `lang_definitions` VALUES (60, 158, 2, 'Åtgärder');
INSERT INTO `lang_definitions` VALUES (61, 160, 2, 'Rapportera fortsatt vårdbegäran (CCR/CCD)');
INSERT INTO `lang_definitions` VALUES (62, 165, 2, 'Aktiva');
INSERT INTO `lang_definitions` VALUES (63, 167, 2, 'Aktiv påminnelse');
INSERT INTO `lang_definitions` VALUES (64, 169, 2, 'Regler för aktiv påminnelse');
INSERT INTO `lang_definitions` VALUES (65, 170, 2, 'Aktiva påminnelser');
INSERT INTO `lang_definitions` VALUES (66, 176, 2, 'Aktivt besök');
INSERT INTO `lang_definitions` VALUES (67, 177, 2, 'Códigos de questões ativas');
INSERT INTO `lang_definitions` VALUES (68, 178, 2, 'Aktiva listor');
INSERT INTO `lang_definitions` VALUES (69, 180, 2, 'Aktiv patient');
INSERT INTO `lang_definitions` VALUES (70, 181, 2, 'Aktuella planeringar');
INSERT INTO `lang_definitions` VALUES (71, 191, 2, 'Aktiviteter');
INSERT INTO `lang_definitions` VALUES (72, 192, 2, 'Aktivitetstyp');
INSERT INTO `lang_definitions` VALUES (73, 203, 2, 'Akut förgiftning / Utsättning');
INSERT INTO `lang_definitions` VALUES (74, 205, 2, 'Akut försämring av kronisk');
INSERT INTO `lang_definitions` VALUES (75, 207, 2, 'Lägg till');
INSERT INTO `lang_definitions` VALUES (76, 208, 2, 'lägg till');
INSERT INTO `lang_definitions` VALUES (77, 209, 2, 'Lägg till');
INSERT INTO `lang_definitions` VALUES (78, 210, 2, 'Lägg till ett företag');
INSERT INTO `lang_definitions` VALUES (79, 215, 2, 'Lägg till ett apotek');
INSERT INTO `lang_definitions` VALUES (80, 218, 2, 'lägg till ett händelse för');
INSERT INTO `lang_definitions` VALUES (81, 220, 2, 'Lägg till som en ny anteckning');
INSERT INTO `lang_definitions` VALUES (82, 221, 2, 'Lägg till som ny');
INSERT INTO `lang_definitions` VALUES (83, 224, 2, 'Lägg till knappar');
INSERT INTO `lang_definitions` VALUES (84, 225, 2, 'Lägg till knappar för specialtecken och texter att visa längst upp i editorn för inkludering i texten med ett klick');
INSERT INTO `lang_definitions` VALUES (85, 226, 2, 'Lägg till en ny Kategori');
INSERT INTO `lang_definitions` VALUES (86, 227, 2, 'Lägg till en ny Konstant');
INSERT INTO `lang_definitions` VALUES (87, 228, 2, 'Lägg till ett sammanhang');
INSERT INTO `lang_definitions` VALUES (88, 229, 2, 'Lägg till en delbetalning');
INSERT INTO `lang_definitions` VALUES (89, 230, 2, 'Lägg till ett nytt kriterium');
INSERT INTO `lang_definitions` VALUES (90, 231, 2, 'Lägg till anpassad knapp');
INSERT INTO `lang_definitions` VALUES (91, 234, 2, 'Lägg till en ny diagnos');
INSERT INTO `lang_definitions` VALUES (92, 235, 2, 'Lägg till ett nytt Läkemedel');
INSERT INTO `lang_definitions` VALUES (93, 238, 2, 'Lägg till ett nytt besök');
INSERT INTO `lang_definitions` VALUES (94, 239, 2, 'Lägg till ett nytt besök/anteckning');
INSERT INTO `lang_definitions` VALUES (95, 240, 2, 'Lägg till en ny klinik');
INSERT INTO `lang_definitions` VALUES (96, 241, 2, 'Lägg till ett nytt fält');
INSERT INTO `lang_definitions` VALUES (97, 242, 2, 'Lägg till följande meningar till Apache konfigurationsfilen');
INSERT INTO `lang_definitions` VALUES (98, 243, 2, 'Lägg till en ny Grupp');
INSERT INTO `lang_definitions` VALUES (99, 245, 2, 'Lägg till en ny diagnos-kod (ICD)');
INSERT INTO `lang_definitions` VALUES (100, 246, 2, 'Lägg till en ny vaccination');
INSERT INTO `lang_definitions` VALUES (101, 247, 2, 'Inte tillåtet att lägga till!');
INSERT INTO `lang_definitions` VALUES (102, 248, 2, 'Lägg till händelse');
INSERT INTO `lang_definitions` VALUES (103, 250, 2, 'Lägg till ett nytt Språk');
INSERT INTO `lang_definitions` VALUES (104, 257, 2, 'Lägg till Ny');
INSERT INTO `lang_definitions` VALUES (105, 258, 2, 'Lägg till Ny');
INSERT INTO `lang_definitions` VALUES (106, 259, 2, 'Lägg till en ny kategori:');
INSERT INTO `lang_definitions` VALUES (107, 260, 2, 'Lägg till ett nytt certifikat till Apache konfigurationsfil');
INSERT INTO `lang_definitions` VALUES (108, 268, 2, 'Lägg till en ny grupp');
INSERT INTO `lang_definitions` VALUES (109, 270, 2, 'Lägg till en ny lot och överföring');
INSERT INTO `lang_definitions` VALUES (110, 272, 2, 'Lägg till en ny kommentar');
INSERT INTO `lang_definitions` VALUES (111, 273, 2, 'Lägg till en ny kommentar');
INSERT INTO `lang_definitions` VALUES (112, 274, 2, 'Lägg till en ny partner');
INSERT INTO `lang_definitions` VALUES (113, 284, 2, 'Lägg till en ny anteckning');
INSERT INTO `lang_definitions` VALUES (114, 288, 2, 'Lägg till en ny patient');
INSERT INTO `lang_definitions` VALUES (115, 289, 2, 'Lägg till ett nytt recept');
INSERT INTO `lang_definitions` VALUES (116, 290, 2, 'Lägg till åtgärd');
INSERT INTO `lang_definitions` VALUES (117, 291, 2, 'Lägg till Vårdgivares nummer');
INSERT INTO `lang_definitions` VALUES (118, 293, 2, 'Lägg till rehab');
INSERT INTO `lang_definitions` VALUES (119, 295, 2, 'Lägg till en ny regel');
INSERT INTO `lang_definitions` VALUES (120, 298, 2, 'Tillägg till');
INSERT INTO `lang_definitions` VALUES (121, 303, 2, 'Lägg till i medicinlista');
INSERT INTO `lang_definitions` VALUES (122, 304, 2, 'Tillägg av högsta nivå');
INSERT INTO `lang_definitions` VALUES (123, 305, 2, 'Lägg till en ny överföring');
INSERT INTO `lang_definitions` VALUES (124, 306, 2, 'Lägg till en ny användare');
INSERT INTO `lang_definitions` VALUES (125, 307, 2, 'Lägg till användaren i gruppen');
INSERT INTO `lang_definitions` VALUES (126, 309, 2, 'Lägg till/ändra elektroniskt recept');
INSERT INTO `lang_definitions` VALUES (127, 311, 2, 'Lägg till/ändra patientens överföringar');
INSERT INTO `lang_definitions` VALUES (128, 312, 2, 'tillagd');
INSERT INTO `lang_definitions` VALUES (129, 315, 2, 'Ej tillåtet att lägga till personuppgifter.');
INSERT INTO `lang_definitions` VALUES (130, 317, 2, 'Mb Addison');
INSERT INTO `lang_definitions` VALUES (131, 318, 2, 'Mb Addison');
INSERT INTO `lang_definitions` VALUES (132, 319, 2, 'Flera attribut');
INSERT INTO `lang_definitions` VALUES (133, 322, 2, 'Ytterligare Diagnos:');
INSERT INTO `lang_definitions` VALUES (134, 327, 2, 'Kompletterande anamnes');
INSERT INTO `lang_definitions` VALUES (135, 328, 2, 'Kompletterande anamnesuppgifter');
INSERT INTO `lang_definitions` VALUES (136, 329, 2, 'Kompletterande Information');
INSERT INTO `lang_definitions` VALUES (137, 333, 2, 'Kompletterande Lab. svar');
INSERT INTO `lang_definitions` VALUES (138, 334, 2, 'Kompletterande noteringar');
INSERT INTO `lang_definitions` VALUES (139, 336, 2, 'Ytterligare noteringar för detta resultat eller rekomendation');
INSERT INTO `lang_definitions` VALUES (140, 337, 2, 'Ytterligare noteringar:');
INSERT INTO `lang_definitions` VALUES (141, 338, 2, 'Ytterligare noteringar:');
INSERT INTO `lang_definitions` VALUES (142, 340, 2, 'Ytterligare röntgenanteckningar:');
INSERT INTO `lang_definitions` VALUES (143, 341, 2, 'Som tillägg, motsvarande US Snomed Extension Package can importeras separat efter instalation av den internationella (engelska) Snomed utgåvan');
INSERT INTO `lang_definitions` VALUES (144, 344, 2, 'Lägg endast till');
INSERT INTO `lang_definitions` VALUES (145, 346, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (146, 347, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (147, 348, 2, 'Adress');
INSERT INTO `lang_definitions` VALUES (148, 351, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (149, 352, 2, 'Tillgång till adressboken för företaget som utför denna åtgärd');
INSERT INTO `lang_definitions` VALUES (150, 353, 2, 'Tillgång till adressboken för distributören');
INSERT INTO `lang_definitions` VALUES (151, 354, 2, 'Tillgång till adressboken för försäljare');
INSERT INTO `lang_definitions` VALUES (152, 355, 2, 'Typer av adressböcker');
INSERT INTO `lang_definitions` VALUES (153, 364, 2, 'Adress1');
INSERT INTO `lang_definitions` VALUES (154, 365, 2, 'Adress2');
INSERT INTO `lang_definitions` VALUES (155, 367, 2, 'ADRESSATEN');
INSERT INTO `lang_definitions` VALUES (156, 370, 2, 'Justera');
INSERT INTO `lang_definitions` VALUES (157, 371, 2, 'Korrigera mängd');
INSERT INTO `lang_definitions` VALUES (158, 374, 2, 'Justera');
INSERT INTO `lang_definitions` VALUES (159, 376, 2, 'Korrigering');
INSERT INTO `lang_definitions` VALUES (160, 377, 2, 'Justera mängd');
INSERT INTO `lang_definitions` VALUES (161, 378, 2, 'Orsak till justering');
INSERT INTO `lang_definitions` VALUES (162, 382, 2, 'Justering av värde för kod');
INSERT INTO `lang_definitions` VALUES (163, 384, 2, 'Justeringar');
INSERT INTO `lang_definitions` VALUES (164, 386, 2, 'Administrera justeringar');
INSERT INTO `lang_definitions` VALUES (165, 387, 2, 'Administrera');
INSERT INTO `lang_definitions` VALUES (166, 388, 2, 'Admin E-postadress');
INSERT INTO `lang_definitions` VALUES (167, 389, 2, 'Administrera via');
INSERT INTO `lang_definitions` VALUES (168, 391, 2, 'Administrerad av');
INSERT INTO `lang_definitions` VALUES (169, 392, 2, 'Administrerad av');
INSERT INTO `lang_definitions` VALUES (170, 394, 2, 'Administrera plats');
INSERT INTO `lang_definitions` VALUES (171, 395, 2, 'Administration');
INSERT INTO `lang_definitions` VALUES (172, 397, 2, 'Administrera plats');
INSERT INTO `lang_definitions` VALUES (173, 399, 2, 'Administratörer');
INSERT INTO `lang_definitions` VALUES (174, 400, 2, 'Administratörer kan göra allt');
INSERT INTO `lang_definitions` VALUES (175, 401, 2, 'Godkänn datum');
INSERT INTO `lang_definitions` VALUES (176, 404, 2, 'Viktkontroller med uppföljning för vuxna');
INSERT INTO `lang_definitions` VALUES (177, 405, 2, 'Viktkontroller med uppföljning för vuxna');
INSERT INTO `lang_definitions` VALUES (178, 406, 2, 'Avancerade råd');
INSERT INTO `lang_definitions` VALUES (179, 407, 2, 'Avancerade råd');
INSERT INTO `lang_definitions` VALUES (180, 408, 2, 'Varning i avancerade råd');
INSERT INTO `lang_definitions` VALUES (181, 410, 2, 'Avancerad');
INSERT INTO `lang_definitions` VALUES (182, 413, 2, 'Råd');
INSERT INTO `lang_definitions` VALUES (183, 415, 2, 'Neutral grundstämning');
INSERT INTO `lang_definitions` VALUES (184, 419, 2, 'Joursamtal');
INSERT INTO `lang_definitions` VALUES (185, 420, 2, 'Efter flytt från det gamla lösenordshanteringen där lösenord sparadesokrypterat i användartabellenska denna flagga markeras så att enbart inloggning med den nya metoden kan användas');
INSERT INTO `lang_definitions` VALUES (186, 421, 2, 'Efter genomförandet av ovannämnda konfigurationer, importera admin. klientens certifikat till webläsaren och starta om Apache server ( tömma lösenord )');
INSERT INTO `lang_definitions` VALUES (187, 423, 2, 'Efter att PDF sparats, klicka på [View Log] för att söka efter fel.');
INSERT INTO `lang_definitions` VALUES (188, 426, 2, 'Efter sparandet av TEXT filer , klicka på [View Log] för att leta efter fel');
INSERT INTO `lang_definitions` VALUES (189, 429, 2, 'Efter sparandet av ditt parti, klicka på [View Log] för att granska för fel.');
INSERT INTO `lang_definitions` VALUES (190, 432, 2, 'När informationen är korrekt införd, klicka på Spara knappen.');
INSERT INTO `lang_definitions` VALUES (191, 437, 2, 'Planering av eftervård');
INSERT INTO `lang_definitions` VALUES (192, 439, 2, 'Igen');
INSERT INTO `lang_definitions` VALUES (193, 440, 2, 'Ålder');
INSERT INTO `lang_definitions` VALUES (194, 442, 2, 'Ålder av');
INSERT INTO `lang_definitions` VALUES (195, 443, 2, 'Ålderskategori');
INSERT INTO `lang_definitions` VALUES (196, 444, 2, 'Denna Åder är utanför befintlig intervall');
INSERT INTO `lang_definitions` VALUES (197, 445, 2, 'Format för att visa ålder');
INSERT INTO `lang_definitions` VALUES (198, 446, 2, 'Detta format för \"ålder från\" är inte tillåtet');
INSERT INTO `lang_definitions` VALUES (199, 447, 2, 'Detta format för \"ålder upp till\" är inte tillåtet');
INSERT INTO `lang_definitions` VALUES (200, 448, 2, 'Ålder från');
INSERT INTO `lang_definitions` VALUES (201, 449, 2, 'Ändra format för att visa ålder i år');
INSERT INTO `lang_definitions` VALUES (202, 450, 2, 'Högsta ålder');
INSERT INTO `lang_definitions` VALUES (203, 451, 2, 'Lägsta ålder');
INSERT INTO `lang_definitions` VALUES (204, 452, 2, 'Åldersintervall');
INSERT INTO `lang_definitions` VALUES (205, 454, 2, 'Kolumner med åldern');
INSERT INTO `lang_definitions` VALUES (206, 457, 2, 'Albansk');
INSERT INTO `lang_definitions` VALUES (207, 458, 2, 'Alkohol');
INSERT INTO `lang_definitions` VALUES (208, 459, 2, 'Alkoholkonsumtion');
INSERT INTO `lang_definitions` VALUES (209, 462, 2, 'Antal varningar');
INSERT INTO `lang_definitions` VALUES (210, 469, 2, 'Varningar');
INSERT INTO `lang_definitions` VALUES (211, 473, 2, 'Aleut-befolkning');
INSERT INTO `lang_definitions` VALUES (212, 474, 2, 'Alla');
INSERT INTO `lang_definitions` VALUES (213, 475, 2, 'Alla');
INSERT INTO `lang_definitions` VALUES (214, 477, 2, 'Alla (format A)');
INSERT INTO `lang_definitions` VALUES (215, 478, 2, 'Alla (format B)');
INSERT INTO `lang_definitions` VALUES (216, 479, 2, 'Allt ( Kumulativt )');
INSERT INTO `lang_definitions` VALUES (217, 482, 2, 'Alla Kategorier');
INSERT INTO `lang_definitions` VALUES (218, 484, 2, 'Alla koder');
INSERT INTO `lang_definitions` VALUES (219, 487, 2, 'Hela dagen');
INSERT INTO `lang_definitions` VALUES (220, 488, 2, 'Heldagshändelse');
INSERT INTO `lang_definitions` VALUES (221, 489, 2, 'Alla demografiska fält , med sökning och dubbel kontroll');
INSERT INTO `lang_definitions` VALUES (222, 492, 2, 'Alla kliniker');
INSERT INTO `lang_definitions` VALUES (223, 493, 2, 'Alla skador/problem/frågeställningar');
INSERT INTO `lang_definitions` VALUES (224, 495, 2, 'All språk är tillåtna');
INSERT INTO `lang_definitions` VALUES (225, 498, 2, 'Hela förnamnet eller en del av det');
INSERT INTO `lang_definitions` VALUES (226, 499, 2, 'Hela efternamnet eller en del av det');
INSERT INTO `lang_definitions` VALUES (227, 500, 2, 'Hela organisationen eller delar av namnet');
INSERT INTO `lang_definitions` VALUES (228, 505, 2, 'Alla produkter');
INSERT INTO `lang_definitions` VALUES (229, 506, 2, 'Alla vårdgivare');
INSERT INTO `lang_definitions` VALUES (230, 507, 2, 'Alla granskade och Negativa:');
INSERT INTO `lang_definitions` VALUES (231, 513, 2, 'Alla ämnen');
INSERT INTO `lang_definitions` VALUES (232, 516, 2, 'Alla användare');
INSERT INTO `lang_definitions` VALUES (233, 518, 2, 'Allergisk');
INSERT INTO `lang_definitions` VALUES (234, 520, 2, 'Allergier');
INSERT INTO `lang_definitions` VALUES (235, 523, 2, 'Allergier:');
INSERT INTO `lang_definitions` VALUES (236, 524, 2, 'Allergi');
INSERT INTO `lang_definitions` VALUES (237, 525, 2, 'Import av allergier klart');
INSERT INTO `lang_definitions` VALUES (238, 526, 2, 'Lista på allergier');
INSERT INTO `lang_definitions` VALUES (239, 527, 2, 'Allergisk reaktion');
INSERT INTO `lang_definitions` VALUES (240, 530, 2, 'Tilldela');
INSERT INTO `lang_definitions` VALUES (241, 531, 2, 'Tillåta');
INSERT INTO `lang_definitions` VALUES (242, 533, 2, 'Tillåt alla tillgängliga språk som val i menyn vid inloggning');
INSERT INTO `lang_definitions` VALUES (243, 535, 2, 'Tillåt att skapa krav innehållande diagnoser , men ej procedurer eller betalningar. De flesta kliniker vill inte ha det');
INSERT INTO `lang_definitions` VALUES (244, 536, 2, 'Tillåt debugg språk');
INSERT INTO `lang_definitions` VALUES (245, 539, 2, 'E-post tillåten');
INSERT INTO `lang_definitions` VALUES (246, 540, 2, 'Är e-post meddelande tillåtet ?');
INSERT INTO `lang_definitions` VALUES (247, 541, 2, 'Tillåt e-post?');
INSERT INTO `lang_definitions` VALUES (248, 542, 2, 'Tillåt krav i patient möte');
INSERT INTO `lang_definitions` VALUES (249, 545, 2, 'Tillåt utbyte av hälsoinformationen');
INSERT INTO `lang_definitions` VALUES (250, 547, 2, 'Tillåt att informationen om vaccinationer delas');
INSERT INTO `lang_definitions` VALUES (251, 548, 2, 'Tillåt användning av vaccinationsregistret');
INSERT INTO `lang_definitions` VALUES (252, 552, 2, 'Tillåt e-post meddelanden');
INSERT INTO `lang_definitions` VALUES (253, 575, 2, 'Tillåt patient-inloggning');
INSERT INTO `lang_definitions` VALUES (254, 583, 2, 'Tillåt SMS');
INSERT INTO `lang_definitions` VALUES (255, 584, 2, 'Är SMS meddelanden tillåtna ?');
INSERT INTO `lang_definitions` VALUES (256, 586, 2, 'Tillåt aktuella händelser att vara aktiva omedelbart ?');
INSERT INTO `lang_definitions` VALUES (257, 587, 2, 'Tillåt telefon meddelanden?');
INSERT INTO `lang_definitions` VALUES (258, 589, 2, 'Tillåt användare att publicera Globala Händelser');
INSERT INTO `lang_definitions` VALUES (259, 590, 2, 'Tillåt användare att publicera personliga kalendrar');
INSERT INTO `lang_definitions` VALUES (260, 596, 2, 'Tillåt telefonsvarare');
INSERT INTO `lang_definitions` VALUES (261, 597, 2, 'Tillåten');
INSERT INTO `lang_definitions` VALUES (262, 598, 2, 'Godkända språk');
INSERT INTO `lang_definitions` VALUES (263, 600, 2, 'Godkänt');
INSERT INTO `lang_definitions` VALUES (264, 610, 2, 'finns redan');
INSERT INTO `lang_definitions` VALUES (265, 612, 2, 'Finns redan');
INSERT INTO `lang_definitions` VALUES (266, 614, 2, 'Används redan, välj en annan identitetsbeteckning');
INSERT INTO `lang_definitions` VALUES (267, 615, 2, 'Används redan, välj en annan titel');
INSERT INTO `lang_definitions` VALUES (268, 617, 2, 'Alternativ Adress');
INSERT INTO `lang_definitions` VALUES (269, 621, 2, 'Ändra');
INSERT INTO `lang_definitions` VALUES (270, 628, 2, 'Alternativt kan du använda sökfunktionen för att lägga upp ett elektroniskt godkännande (X12 83l fil) som du fått från din betalare eller clearingorganisationer. Du kan göra detta genom att klicka på knappen Bläddra och välj den fil som ska laddas upp och sedan klicka på Sök för att ladda upp och visa motsvarande fakturor. I detta fall gäller inte de andra parametrar som nämns ovan och de kommer att ignoreras. Överföring sparar filen men processar ännuinte innehållet - detta är gjort separat enligt nedan.');
INSERT INTO `lang_definitions` VALUES (271, 631, 2, 'förmiddag');
INSERT INTO `lang_definitions` VALUES (272, 632, 2, 'Förmiddagens program');
INSERT INTO `lang_definitions` VALUES (273, 637, 2, 'Automatisk beräkning av åtgärder (AMC)');
INSERT INTO `lang_definitions` VALUES (274, 638, 2, 'Spåra AMC');
INSERT INTO `lang_definitions` VALUES (275, 645, 2, 'Ändra Befintlig notering');
INSERT INTO `lang_definitions` VALUES (276, 655, 2, 'Amerikansk indian');
INSERT INTO `lang_definitions` VALUES (277, 656, 2, 'Amerikans indian eller född i alaska');
INSERT INTO `lang_definitions` VALUES (278, 657, 2, 'AMEX');
INSERT INTO `lang_definitions` VALUES (279, 658, 2, 'Etiopier');
INSERT INTO `lang_definitions` VALUES (280, 659, 2, 'Belopp');
INSERT INTO `lang_definitions` VALUES (281, 660, 2, 'Administrerat belopp');
INSERT INTO `lang_definitions` VALUES (282, 662, 2, 'Begärt belopp');
INSERT INTO `lang_definitions` VALUES (283, 665, 2, 'Belopp från tidigare Saldo');
INSERT INTO `lang_definitions` VALUES (284, 666, 2, 'Belopp för besöket');
INSERT INTO `lang_definitions` VALUES (285, 667, 2, 'Belopp som betalts');
INSERT INTO `lang_definitions` VALUES (286, 668, 2, 'Belopp:');
INSERT INTO `lang_definitions` VALUES (287, 671, 2, 'fakturerat belopp');
INSERT INTO `lang_definitions` VALUES (288, 676, 2, 'Ett slutdatum senare än startdatum krävs för upprepade händelser!');
INSERT INTO `lang_definitions` VALUES (289, 678, 2, 'ett fel uppstod när OpenEMR sparades');
INSERT INTO `lang_definitions` VALUES (290, 679, 2, 'Ett fel uppstod när phpGACL sparades');
INSERT INTO `lang_definitions` VALUES (291, 680, 2, 'Ett fel uppstod när SQL-ledger sparades');
INSERT INTO `lang_definitions` VALUES (292, 685, 2, 'En ofullständig GCAC fråga har inrättats och knutits. Någon kommer att behöva fylla i det senare.');
INSERT INTO `lang_definitions` VALUES (293, 693, 2, 'Ett oförutsett fel uppkom');
INSERT INTO `lang_definitions` VALUES (294, 696, 2, 'En stor bokstav');
INSERT INTO `lang_definitions` VALUES (295, 698, 2, 'och');
INSERT INTO `lang_definitions` VALUES (296, 699, 2, 'Och');
INSERT INTO `lang_definitions` VALUES (297, 700, 2, 'OCH');
INSERT INTO `lang_definitions` VALUES (298, 701, 2, 'och');
INSERT INTO `lang_definitions` VALUES (299, 702, 2, 'och alla underordnade data? Denna åtgärd kommer att loggas');
INSERT INTO `lang_definitions` VALUES (300, 703, 2, 'och modifierare');
INSERT INTO `lang_definitions` VALUES (301, 704, 2, 'och hanterad.');
INSERT INTO `lang_definitions` VALUES (302, 706, 2, 'och starta om Apache servern.');
INSERT INTO `lang_definitions` VALUES (303, 707, 2, 'och orsaken är');
INSERT INTO `lang_definitions` VALUES (304, 709, 2, 'Anemi');
INSERT INTO `lang_definitions` VALUES (305, 710, 2, 'Ankel');
INSERT INTO `lang_definitions` VALUES (306, 711, 2, 'Ankel + häl');
INSERT INTO `lang_definitions` VALUES (307, 712, 2, 'Ankel Utvärderingsformulär');
INSERT INTO `lang_definitions` VALUES (308, 713, 2, 'Ankel problem');
INSERT INTO `lang_definitions` VALUES (309, 714, 2, 'Ankyloserande Spondylit');
INSERT INTO `lang_definitions` VALUES (310, 715, 2, 'Ankyloserande Spondylit');
INSERT INTO `lang_definitions` VALUES (311, 716, 2, 'Anorexia');
INSERT INTO `lang_definitions` VALUES (312, 717, 2, 'En annan sak du kan göra i utstationering fönstret är att begära en sekundära fakturering. Om du markerar rutan innan du sparar, så kommer den ursprungliga fordran att öppnas igen och köas på faktureringssidan och sedan behandlas under nästa faktureringskörning.');
INSERT INTO `lang_definitions` VALUES (313, 721, 2, 'framåt');
INSERT INTO `lang_definitions` VALUES (314, 726, 2, 'Anus, ingen rektal ömhet');
INSERT INTO `lang_definitions` VALUES (315, 727, 2, 'Ångest');
INSERT INTO `lang_definitions` VALUES (316, 729, 2, 'Valfri');
INSERT INTO `lang_definitions` VALUES (317, 732, 2, 'någon Kategori');
INSERT INTO `lang_definitions` VALUES (318, 738, 2, 'Någon del av en kod eller dess beskrivning');
INSERT INTO `lang_definitions` VALUES (319, 740, 2, 'Någon del av önskad specialitet');
INSERT INTO `lang_definitions` VALUES (320, 741, 2, 'någon del av medicinens namn eller id');
INSERT INTO `lang_definitions` VALUES (321, 742, 2, 'Någon del av vaccinations namn eller id');
INSERT INTO `lang_definitions` VALUES (322, 743, 2, 'Någon del av patientens namn, eller \"efternamn, förnamn \" eller \"X-Y \"');
INSERT INTO `lang_definitions` VALUES (323, 744, 2, 'Någon annan relevant information');
INSERT INTO `lang_definitions` VALUES (324, 750, 2, 'API nyckel till SMS portal');
INSERT INTO `lang_definitions` VALUES (325, 754, 2, 'Andningsuppehåll');
INSERT INTO `lang_definitions` VALUES (326, 761, 2, 'Utseende');
INSERT INTO `lang_definitions` VALUES (327, 762, 2, 'Utseende:');
INSERT INTO `lang_definitions` VALUES (328, 765, 2, 'Lägg till denna notering');
INSERT INTO `lang_definitions` VALUES (329, 767, 2, 'Lägg till den nuvarande noteringen');
INSERT INTO `lang_definitions` VALUES (330, 768, 2, 'Lägg till denna anmärkning');
INSERT INTO `lang_definitions` VALUES (331, 769, 2, 'Bifoga till denna notering');
INSERT INTO `lang_definitions` VALUES (332, 770, 2, 'Appendektomi');
INSERT INTO `lang_definitions` VALUES (333, 773, 2, 'Tällämpliga patienter');
INSERT INTO `lang_definitions` VALUES (334, 774, 2, 'Ansökan');
INSERT INTO `lang_definitions` VALUES (335, 775, 2, 'Namn på program vid inloggning och titel på sidan');
INSERT INTO `lang_definitions` VALUES (336, 777, 2, 'Mottagarkod (GS03. Om blank kommer ISA08 användas)');
INSERT INTO `lang_definitions` VALUES (337, 778, 2, 'Sändarkod (GS02)');
INSERT INTO `lang_definitions` VALUES (338, 779, 2, 'Programmets titel');
INSERT INTO `lang_definitions` VALUES (339, 780, 2, 'Gäller Formulär för vitalparametrar och tillväxtkurva');
INSERT INTO `lang_definitions` VALUES (340, 782, 2, 'Gäller formulär för vitalparametrar');
INSERT INTO `lang_definitions` VALUES (341, 783, 2, 'Tillämpa ändringen på nuvarande händelse, nuvarande och alla kommande händelser eller alla händelser?');
INSERT INTO `lang_definitions` VALUES (342, 784, 2, 'tillämpas på berörda området');
INSERT INTO `lang_definitions` VALUES (343, 785, 2, 'appliceras på huden');
INSERT INTO `lang_definitions` VALUES (344, 786, 2, 'Lägger till');
INSERT INTO `lang_definitions` VALUES (345, 787, 2, 'Lägger till patch till sidan');
INSERT INTO `lang_definitions` VALUES (346, 788, 2, 'Bokning');
INSERT INTO `lang_definitions` VALUES (347, 790, 2, 'Boknings datum');
INSERT INTO `lang_definitions` VALUES (348, 796, 2, 'Sätt att visa bokning');
INSERT INTO `lang_definitions` VALUES (349, 798, 2, 'Påminnelser för bokning');
INSERT INTO `lang_definitions` VALUES (350, 800, 2, 'Boknings status');
INSERT INTO `lang_definitions` VALUES (351, 801, 2, 'Boknings status');
INSERT INTO `lang_definitions` VALUES (352, 802, 2, 'Bokas inom');
INSERT INTO `lang_definitions` VALUES (353, 803, 2, 'Bokning/händelse färg');
INSERT INTO `lang_definitions` VALUES (354, 804, 2, 'Bokningar');
INSERT INTO `lang_definitions` VALUES (355, 805, 2, 'Bokningar ( valfritt att skriva )');
INSERT INTO `lang_definitions` VALUES (356, 806, 2, 'Bokningar (Skriv, några valbara)');
INSERT INTO `lang_definitions` VALUES (357, 812, 2, 'Bokningar och besök');
INSERT INTO `lang_definitions` VALUES (358, 814, 2, 'Bokningsrapport');
INSERT INTO `lang_definitions` VALUES (359, 815, 2, 'Boknings och besöksrapport');
INSERT INTO `lang_definitions` VALUES (360, 818, 2, 'Godkänn');
INSERT INTO `lang_definitions` VALUES (361, 821, 2, 'Godkänd');
INSERT INTO `lang_definitions` VALUES (362, 822, 2, 'Godkända administrativa händelser');
INSERT INTO `lang_definitions` VALUES (363, 828, 2, 'Bokningar-besök');
INSERT INTO `lang_definitions` VALUES (364, 830, 2, 'Bokningar');
INSERT INTO `lang_definitions` VALUES (365, 833, 2, 'Apr');
INSERT INTO `lang_definitions` VALUES (366, 834, 2, 'April');
INSERT INTO `lang_definitions` VALUES (367, 836, 2, 'Arabisk');
INSERT INTO `lang_definitions` VALUES (368, 838, 2, 'Arkivera');
INSERT INTO `lang_definitions` VALUES (369, 841, 2, 'Ska gruppnamnen översättas?');
INSERT INTO `lang_definitions` VALUES (370, 842, 2, 'Ska bokningstyperna översättas?');
INSERT INTO `lang_definitions` VALUES (371, 843, 2, 'Ska dokumenttyperna översättas?');
INSERT INTO `lang_definitions` VALUES (372, 844, 2, 'Ska avgifter tas ut för denna typ?');
INSERT INTO `lang_definitions` VALUES (373, 847, 2, 'Ska överskrifter på patientanteckningar översättas?');
INSERT INTO `lang_definitions` VALUES (374, 848, 2, 'Är koderna lagrade i externa sql-tabeller (0-Nej, 1-ICD10, 2-SNOMED(RF1), 3-SNOMED(RF2) )');
INSERT INTO `lang_definitions` VALUES (375, 850, 2, 'Är du beredd att genomföra en ny GCAC fråga för detta besök?');
INSERT INTO `lang_definitions` VALUES (376, 852, 2, 'Är du säker du vill bokföra dagens händelser?');
INSERT INTO `lang_definitions` VALUES (377, 853, 2, 'Är du säker på att du vill godkänna dessa händelser?');
INSERT INTO `lang_definitions` VALUES (378, 856, 2, 'Är du säker på att du vill ta bort detta formulär?');
INSERT INTO `lang_definitions` VALUES (379, 859, 2, 'Är du säker på att du vill ta bort denna friskrivning?');
INSERT INTO `lang_definitions` VALUES (380, 860, 2, 'Är du säker på att du vill ta bort denna händelse?');
INSERT INTO `lang_definitions` VALUES (381, 861, 2, 'Är du säker du vill ta bort detta från databasen?');
INSERT INTO `lang_definitions` VALUES (382, 864, 2, 'Är du säker på att du vill ta bort detta meddelande?');
INSERT INTO `lang_definitions` VALUES (383, 866, 2, 'Är du säker på att du vill ändra dessa händelser?');
INSERT INTO `lang_definitions` VALUES (384, 867, 2, 'Är du säker på att du vill dölja dessa händelser?');
INSERT INTO `lang_definitions` VALUES (385, 870, 2, 'Är du säker på att du vill visa dessa händelser?');
INSERT INTO `lang_definitions` VALUES (386, 871, 2, 'Är du säker på att du vill ta bort hela den valda gruppen');
INSERT INTO `lang_definitions` VALUES (387, 872, 2, 'Är du säker på att du vill ta bort hela listan');
INSERT INTO `lang_definitions` VALUES (388, 873, 2, 'Är du säker på att du vill ta bort fältet i');
INSERT INTO `lang_definitions` VALUES (389, 874, 2, 'Är du säker på att du vill ta bort markerade fält?');
INSERT INTO `lang_definitions` VALUES (390, 877, 2, 'Är du säker på att du vill fortsätta med dessa åtgärder?');
INSERT INTO `lang_definitions` VALUES (391, 879, 2, 'Område är ej specifiserat');
INSERT INTO `lang_definitions` VALUES (392, 880, 2, 'Arm');
INSERT INTO `lang_definitions` VALUES (393, 881, 2, 'Armensk');
INSERT INTO `lang_definitions` VALUES (394, 888, 2, 'Arrytmi');
INSERT INTO `lang_definitions` VALUES (395, 889, 2, 'Artrit');
INSERT INTO `lang_definitions` VALUES (396, 890, 2, 'Artrit / Degenerativ ledsjukdom');
INSERT INTO `lang_definitions` VALUES (397, 891, 2, 'Artrit / Degenerativ ledsjukdom');
INSERT INTO `lang_definitions` VALUES (398, 895, 2, 'som');
INSERT INTO `lang_definitions` VALUES (399, 900, 2, 'Per');
INSERT INTO `lang_definitions` VALUES (400, 908, 2, 'Asiatisk');
INSERT INTO `lang_definitions` VALUES (401, 912, 2, 'Bedömning');
INSERT INTO `lang_definitions` VALUES (402, 920, 2, 'Tilldelas');
INSERT INTO `lang_definitions` VALUES (403, 921, 2, 'Assistent');
INSERT INTO `lang_definitions` VALUES (404, 928, 2, 'Astma');
INSERT INTO `lang_definitions` VALUES (405, 929, 2, 'på');
INSERT INTO `lang_definitions` VALUES (406, 931, 2, 'Minst en sök parameter krävs om du väljer Alla');
INSERT INTO `lang_definitions` VALUES (407, 934, 2, 'Vid Båtbenet');
INSERT INTO `lang_definitions` VALUES (408, 935, 2, 'Vid Båtbenet:');
INSERT INTO `lang_definitions` VALUES (409, 936, 2, 'Idrottsgrupp');
INSERT INTO `lang_definitions` VALUES (410, 937, 2, 'Idrottsgrupp');
INSERT INTO `lang_definitions` VALUES (411, 938, 2, 'Idrottsskada');
INSERT INTO `lang_definitions` VALUES (412, 939, 2, 'CA certifikat för ATNA revision');
INSERT INTO `lang_definitions` VALUES (413, 940, 2, 'Värd för ATNA revision');
INSERT INTO `lang_definitions` VALUES (414, 941, 2, 'Lokalt certifikat för ATNA revision');
INSERT INTO `lang_definitions` VALUES (415, 942, 2, 'Posrt för ATNA revision');
INSERT INTO `lang_definitions` VALUES (416, 945, 2, 'Observera');
INSERT INTO `lang_definitions` VALUES (417, 947, 2, 'OBS');
INSERT INTO `lang_definitions` VALUES (418, 952, 2, 'revision CDR urval');
INSERT INTO `lang_definitions` VALUES (419, 959, 2, 'Revisionsloggning backup');
INSERT INTO `lang_definitions` VALUES (420, 960, 2, 'revisionsloggning blandad');
INSERT INTO `lang_definitions` VALUES (421, 961, 2, 'Revisionsloggning sorteringsordning');
INSERT INTO `lang_definitions` VALUES (422, 962, 2, 'Revisionsloggning patientjournal');
INSERT INTO `lang_definitions` VALUES (423, 963, 2, 'revisionsloggning schemaläggning');
INSERT INTO `lang_definitions` VALUES (424, 964, 2, 'Hantera säkerhet för revisorslog');
INSERT INTO `lang_definitions` VALUES (425, 965, 2, 'Urval av revisorlog');
INSERT INTO `lang_definitions` VALUES (426, 968, 2, 'Aug');
INSERT INTO `lang_definitions` VALUES (427, 969, 2, 'Augusti');
INSERT INTO `lang_definitions` VALUES (428, 971, 2, 'Rättigheter');
INSERT INTO `lang_definitions` VALUES (429, 972, 2, 'Rättighet/anteckningar');
INSERT INTO `lang_definitions` VALUES (430, 993, 2, 'Grupprättigheter');
INSERT INTO `lang_definitions` VALUES (431, 994, 2, 'Status på auktorisation');
INSERT INTO `lang_definitions` VALUES (432, 995, 2, 'Tillstånd');
INSERT INTO `lang_definitions` VALUES (433, 996, 2, 'Bemyndiga');
INSERT INTO `lang_definitions` VALUES (434, 997, 2, 'Auktorisera – alla möten');
INSERT INTO `lang_definitions` VALUES (435, 999, 2, 'Auktorisera - Mina möten');
INSERT INTO `lang_definitions` VALUES (436, 1003, 2, 'Auktorisera.net');
INSERT INTO `lang_definitions` VALUES (437, 1005, 2, 'Auktoriserad');
INSERT INTO `lang_definitions` VALUES (438, 1007, 2, 'Enbart auktoriserade');
INSERT INTO `lang_definitions` VALUES (439, 1012, 2, 'Skicka automatiskt');
INSERT INTO `lang_definitions` VALUES (440, 1015, 2, 'Skapa nytt besök automatiskt');
INSERT INTO `lang_definitions` VALUES (441, 1016, 2, 'Autogenererad');
INSERT INTO `lang_definitions` VALUES (442, 1018, 2, 'Automatiska beräkningar (AMC)');
INSERT INTO `lang_definitions` VALUES (443, 1023, 2, 'Spåra automatiska beräkningar (ATM)');
INSERT INTO `lang_definitions` VALUES (444, 1024, 2, 'Automatiska mätningar (AMC)');
INSERT INTO `lang_definitions` VALUES (445, 1026, 2, 'Automatiskt');
INSERT INTO `lang_definitions` VALUES (446, 1030, 2, 'Automatiskt skapa nytt besök när bokningsstatus är satt till ”@” (Kommit)');
INSERT INTO `lang_definitions` VALUES (447, 1035, 2, 'Trafikmedicin');
INSERT INTO `lang_definitions` VALUES (448, 1037, 2, 'Sparad automatisk');
INSERT INTO `lang_definitions` VALUES (449, 1040, 2, 'Tillgängliga kategorier');
INSERT INTO `lang_definitions` VALUES (450, 1045, 2, 'Tillgängliga tider');
INSERT INTO `lang_definitions` VALUES (451, 1050, 2, 'Månadsgenomsnitt');
INSERT INTO `lang_definitions` VALUES (452, 1054, 2, 'Avulsion / avulsion fraktur');
INSERT INTO `lang_definitions` VALUES (453, 1055, 2, 'Avulsion laterala malleolus');
INSERT INTO `lang_definitions` VALUES (454, 1056, 2, 'Avulsion mediala malleolus');
INSERT INTO `lang_definitions` VALUES (455, 1057, 2, 'Medvetandebaserad');
INSERT INTO `lang_definitions` VALUES (456, 1059, 2, 'Axillär');
INSERT INTO `lang_definitions` VALUES (457, 1066, 2, '2 ggr/dag');
INSERT INTO `lang_definitions` VALUES (458, 1067, 2, 'Tillbaka');
INSERT INTO `lang_definitions` VALUES (459, 1068, 2, 'tillbaka');
INSERT INTO `lang_definitions` VALUES (460, 1069, 2, 'Bakåt 8 besök');
INSERT INTO `lang_definitions` VALUES (461, 1070, 2, 'Bakåt 11 besök');
INSERT INTO `lang_definitions` VALUES (462, 1071, 2, 'Bakåt 5 besök');
INSERT INTO `lang_definitions` VALUES (463, 1072, 2, 'Bakåt 4 besök');
INSERT INTO `lang_definitions` VALUES (464, 1073, 2, 'Bakåt 9 besök');
INSERT INTO `lang_definitions` VALUES (465, 1074, 2, 'Bakåt 1 besök');
INSERT INTO `lang_definitions` VALUES (466, 1075, 2, 'Ryggsmärta');
INSERT INTO `lang_definitions` VALUES (467, 1076, 2, 'Ryggproblem');
INSERT INTO `lang_definitions` VALUES (468, 1077, 2, 'Bakåt 7 besök');
INSERT INTO `lang_definitions` VALUES (469, 1078, 2, 'Bakåt 6 besök');
INSERT INTO `lang_definitions` VALUES (470, 1079, 2, 'Ryggkirurgi');
INSERT INTO `lang_definitions` VALUES (471, 1080, 2, 'Bakåt 10 besök');
INSERT INTO `lang_definitions` VALUES (472, 1081, 2, 'Bakåt 3 besök');
INSERT INTO `lang_definitions` VALUES (473, 1082, 2, 'Tillbaka till Admin sidan');
INSERT INTO `lang_definitions` VALUES (474, 1087, 2, 'Tillbaka till patient');
INSERT INTO `lang_definitions` VALUES (475, 1089, 2, 'Tillbaka till användare');
INSERT INTO `lang_definitions` VALUES (476, 1090, 2, 'Tillbaka till Visa');
INSERT INTO `lang_definitions` VALUES (477, 1091, 2, 'Bakåt 12 besök');
INSERT INTO `lang_definitions` VALUES (478, 1092, 2, 'Bakåt 2 besök');
INSERT INTO `lang_definitions` VALUES (479, 1093, 2, 'Bakgrunds tjänster');
INSERT INTO `lang_definitions` VALUES (480, 1094, 2, 'Backup');
INSERT INTO `lang_definitions` VALUES (481, 1096, 2, 'Backup-filen har skapats. Kommer nu skicka till nedladdning.');
INSERT INTO `lang_definitions` VALUES (482, 1098, 2, 'Backup genomfört i');
INSERT INTO `lang_definitions` VALUES (483, 1100, 2, 'Dålig kontroll');
INSERT INTO `lang_definitions` VALUES (484, 1101, 2, 'Dålig fordran');
INSERT INTO `lang_definitions` VALUES (485, 1102, 2, 'Bahasa Indonesia');
INSERT INTO `lang_definitions` VALUES (486, 1103, 2, 'Bal');
INSERT INTO `lang_definitions` VALUES (487, 1106, 2, 'Balans');
INSERT INTO `lang_definitions` VALUES (488, 1107, 2, 'balans');
INSERT INTO `lang_definitions` VALUES (489, 1108, 2, 'Saldo mängd');
INSERT INTO `lang_definitions` VALUES (490, 1109, 2, 'Balanserade skulder');
INSERT INTO `lang_definitions` VALUES (491, 1113, 2, 'Bankavdrag');
INSERT INTO `lang_definitions` VALUES (492, 1117, 2, 'Basen av femte (5e) Metarsal');
INSERT INTO `lang_definitions` VALUES (493, 1118, 2, 'Basen av femte (5e) Metarsal');
INSERT INTO `lang_definitions` VALUES (494, 1126, 2, 'Samlingsfaktura');
INSERT INTO `lang_definitions` VALUES (495, 1127, 2, 'Samlingskummunikationsverktyg');
INSERT INTO `lang_definitions` VALUES (496, 1129, 2, 'Samlingsbetalning inskrivning');
INSERT INTO `lang_definitions` VALUES (497, 1130, 2, 'samlingsbetalning');
INSERT INTO `lang_definitions` VALUES (498, 1131, 2, 'Batchprocess påbörjad, detta kan ta ett tag.');
INSERT INTO `lang_definitions` VALUES (499, 1132, 2, 'Samlingsresultat');
INSERT INTO `lang_definitions` VALUES (500, 1133, 2, 'BatchCom');
INSERT INTO `lang_definitions` VALUES (501, 1140, 2, 'För att ID inte existerar');
INSERT INTO `lang_definitions` VALUES (502, 1150, 2, 'Starta');
INSERT INTO `lang_definitions` VALUES (503, 1152, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (504, 1156, 2, 'Tjänstens startdatum åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (505, 1157, 2, 'Start klockslag för kalenderhändelse');
INSERT INTO `lang_definitions` VALUES (506, 1164, 2, 'Rapningar');
INSERT INTO `lang_definitions` VALUES (507, 1169, 2, 'Bengali');
INSERT INTO `lang_definitions` VALUES (508, 1173, 2, 'Mellan');
INSERT INTO `lang_definitions` VALUES (509, 1180, 2, 'Bilateral');
INSERT INTO `lang_definitions` VALUES (510, 1181, 2, 'Bilaterala:');
INSERT INTO `lang_definitions` VALUES (511, 1184, 2, 'Faktura datuma:');
INSERT INTO `lang_definitions` VALUES (512, 1186, 2, 'Faktura');
INSERT INTO `lang_definitions` VALUES (513, 1187, 2, 'Fakturerade');
INSERT INTO `lang_definitions` VALUES (514, 1189, 2, 'Fakturering');
INSERT INTO `lang_definitions` VALUES (515, 1190, 2, 'Fakturering (skriv alternativ)');
INSERT INTO `lang_definitions` VALUES (516, 1194, 2, 'Fakturering attestera');
INSERT INTO `lang_definitions` VALUES (517, 1196, 2, 'Betalningskod för begärd service');
INSERT INTO `lang_definitions` VALUES (518, 1197, 2, 'Betalningskoder');
INSERT INTO `lang_definitions` VALUES (519, 1198, 2, 'Faktureringsdata');
INSERT INTO `lang_definitions` VALUES (520, 1199, 2, 'Fakturering avdelning');
INSERT INTO `lang_definitions` VALUES (521, 1200, 2, 'Fakturering Klinik');
INSERT INTO `lang_definitions` VALUES (522, 1202, 2, 'Faktureringsinformation');
INSERT INTO `lang_definitions` VALUES (523, 1203, 2, 'Faktureringsadress');
INSERT INTO `lang_definitions` VALUES (524, 1210, 2, 'Fakturaansvarig');
INSERT INTO `lang_definitions` VALUES (525, 1211, 2, 'Faktura Anmärkning');
INSERT INTO `lang_definitions` VALUES (526, 1212, 2, 'Fakturera anmärkning för');
INSERT INTO `lang_definitions` VALUES (527, 1213, 2, 'Fakturera notering:');
INSERT INTO `lang_definitions` VALUES (528, 1215, 2, 'Fakturera kö resultat:');
INSERT INTO `lang_definitions` VALUES (529, 1216, 2, 'Faktureringsrapport');
INSERT INTO `lang_definitions` VALUES (530, 1217, 2, 'Faktura status');
INSERT INTO `lang_definitions` VALUES (531, 1218, 2, 'Faktura status = Ej skickad');
INSERT INTO `lang_definitions` VALUES (532, 1219, 2, 'fakturera till');
INSERT INTO `lang_definitions` VALUES (533, 1223, 2, 'Biopsi');
INSERT INTO `lang_definitions` VALUES (534, 1225, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (535, 1226, 2, 'Födelse – 24 månader');
INSERT INTO `lang_definitions` VALUES (536, 1229, 2, 'Svart');
INSERT INTO `lang_definitions` VALUES (537, 1232, 2, 'Sotlunga');
INSERT INTO `lang_definitions` VALUES (538, 1233, 2, 'Afrikans amerikan');
INSERT INTO `lang_definitions` VALUES (539, 1234, 2, 'Cancer i urinblåsan');
INSERT INTO `lang_definitions` VALUES (540, 1235, 2, 'Infektioner i urinblåsan');
INSERT INTO `lang_definitions` VALUES (541, 1237, 2, 'Blankt formulär');
INSERT INTO `lang_definitions` VALUES (542, 1238, 2, 'Problem med blödning');
INSERT INTO `lang_definitions` VALUES (543, 1239, 2, 'Blinda punkter');
INSERT INTO `lang_definitions` VALUES (544, 1241, 2, 'Svullnad');
INSERT INTO `lang_definitions` VALUES (545, 1243, 2, 'Blockerade');
INSERT INTO `lang_definitions` VALUES (546, 1244, 2, 'Blod');
INSERT INTO `lang_definitions` VALUES (547, 1245, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (548, 1246, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (549, 1247, 2, 'Näsblod');
INSERT INTO `lang_definitions` VALUES (550, 1248, 2, 'Blått kors blå sköld');
INSERT INTO `lang_definitions` VALUES (551, 1250, 2, 'Blå linjerna i denna rapport är informativa. Svarta linjer visar tidigare information. Gröna linjerna visar förändringar som tillämpats framgångsrikt. Röda linjer visar fel eller förändringar som inte har genomförts, och dessa måste behandlas manuellt. För närvarande nekas fordringar och betalning reverseringar inte hanteras automatiskt och det kommer att visas i rött.');
INSERT INTO `lang_definitions` VALUES (552, 1251, 2, 'Dimsyn');
INSERT INTO `lang_definitions` VALUES (553, 1252, 2, 'BMI');
INSERT INTO `lang_definitions` VALUES (554, 1253, 2, 'BMI status');
INSERT INTO `lang_definitions` VALUES (555, 1255, 2, 'kroppsregion');
INSERT INTO `lang_definitions` VALUES (556, 1256, 2, 'Bkroppsdel');
INSERT INTO `lang_definitions` VALUES (557, 1257, 2, 'Kroppsdel, om tillämplig');
INSERT INTO `lang_definitions` VALUES (558, 1258, 2, 'Benömhet:');
INSERT INTO `lang_definitions` VALUES (559, 1259, 2, 'Benömhet: Malleoulus Medialis');
INSERT INTO `lang_definitions` VALUES (560, 1260, 2, 'Logisk');
INSERT INTO `lang_definitions` VALUES (561, 1264, 2, 'Båda öronen');
INSERT INTO `lang_definitions` VALUES (562, 1265, 2, 'båda öronen');
INSERT INTO `lang_definitions` VALUES (563, 1268, 2, 'Botten');
INSERT INTO `lang_definitions` VALUES (564, 1272, 2, 'RUTA 10 A. Anställningsrelaterad');
INSERT INTO `lang_definitions` VALUES (565, 1274, 2, 'RUTA 10 B. Bilolycka');
INSERT INTO `lang_definitions` VALUES (566, 1276, 2, 'RUTA 10 C. Övriga olyckor');
INSERT INTO `lang_definitions` VALUES (567, 1289, 2, 'BOX 15 Andere datum Qualifier');
INSERT INTO `lang_definitions` VALUES (568, 1290, 2, 'Ruta 15. Datum för samma eller liknande sjukdom (åååå-mm-dd)');
INSERT INTO `lang_definitions` VALUES (569, 1296, 2, 'FÄLT 16. Datum, oförmögen till arbete från (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (570, 1300, 2, 'FÄLT 16. Datum, oförmögen att arbeta tills (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (571, 1312, 2, 'FÄLT 18. Sjukhusvistelse datum, från (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (572, 1316, 2, 'FÄLT 18. Sjukhusvistelse till, datum (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (573, 1320, 2, 'FÄLT 20. Används externt lab?');
INSERT INTO `lang_definitions` VALUES (574, 1324, 2, 'Fält 22. Medicaid återinskickningskod (ICD-9)');
INSERT INTO `lang_definitions` VALUES (575, 1328, 2, 'Fält 23. Tidigare godkännande nr.');
INSERT INTO `lang_definitions` VALUES (576, 1329, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (577, 1330, 2, 'BT Diastoliskt');
INSERT INTO `lang_definitions` VALUES (578, 1331, 2, 'BT Systoliskt');
INSERT INTO `lang_definitions` VALUES (579, 1333, 2, 'BT Diastoliskt');
INSERT INTO `lang_definitions` VALUES (580, 1337, 2, 'BT Systoliskt');
INSERT INTO `lang_definitions` VALUES (581, 1340, 2, 'Brasiliansk portugisiska');
INSERT INTO `lang_definitions` VALUES (582, 1341, 2, 'Bröst');
INSERT INTO `lang_definitions` VALUES (583, 1342, 2, 'Bröst Biopsi');
INSERT INTO `lang_definitions` VALUES (584, 1343, 2, 'Bröst Avsluta');
INSERT INTO `lang_definitions` VALUES (585, 1344, 2, 'Bröstsjukdom');
INSERT INTO `lang_definitions` VALUES (586, 1345, 2, 'Bröstundersökning');
INSERT INTO `lang_definitions` VALUES (587, 1346, 2, 'Bröstvävnad');
INSERT INTO `lang_definitions` VALUES (588, 1348, 2, 'Andningsljud:');
INSERT INTO `lang_definitions` VALUES (589, 1351, 2, 'Brutna ben');
INSERT INTO `lang_definitions` VALUES (590, 1353, 2, 'Bronkit Formulär');
INSERT INTO `lang_definitions` VALUES (591, 1356, 2, 'Bläddra');
INSERT INTO `lang_definitions` VALUES (592, 1357, 2, 'Bläddra efter journal');
INSERT INTO `lang_definitions` VALUES (593, 1358, 2, 'Blåmärken / hematom');
INSERT INTO `lang_definitions` VALUES (594, 1362, 2, 'Utbuktningen Höger:');
INSERT INTO `lang_definitions` VALUES (595, 1364, 2, 'Sveda vid vattenkastning');
INSERT INTO `lang_definitions` VALUES (596, 1365, 2, 'Sveda vid vattenkastning');
INSERT INTO `lang_definitions` VALUES (597, 1368, 2, 'Upptagen');
INSERT INTO `lang_definitions` VALUES (598, 1370, 2, 'ännu ej behandlad');
INSERT INTO `lang_definitions` VALUES (599, 1371, 2, 'Skinka');
INSERT INTO `lang_definitions` VALUES (600, 1372, 2, 'Skinkan och SI-led');
INSERT INTO `lang_definitions` VALUES (601, 1374, 2, 'via');
INSERT INTO `lang_definitions` VALUES (602, 1375, 2, 'via');
INSERT INTO `lang_definitions` VALUES (603, 1381, 2, 'via munnen');
INSERT INTO `lang_definitions` VALUES (604, 1383, 2, 'Genom / Källa');
INSERT INTO `lang_definitions` VALUES (605, 1384, 2, 'Av:');
INSERT INTO `lang_definitions` VALUES (606, 1387, 2, 'Kopia');
INSERT INTO `lang_definitions` VALUES (607, 1391, 2, 'CA certifikat för att verifiera RFS 5425 TLS syslog server');
INSERT INTO `lang_definitions` VALUES (608, 1392, 2, 'Cache, livstid (i sekunder)');
INSERT INTO `lang_definitions` VALUES (609, 1393, 2, 'Cache template output?');
INSERT INTO `lang_definitions` VALUES (610, 1395, 2, 'Kaffe konsumtion');
INSERT INTO `lang_definitions` VALUES (611, 1396, 2, 'Kalender');
INSERT INTO `lang_definitions` VALUES (612, 1397, 2, 'Kalender sluttid');
INSERT INTO `lang_definitions` VALUES (613, 1398, 2, 'Kalender interval');
INSERT INTO `lang_definitions` VALUES (614, 1399, 2, 'Kalender skärm');
INSERT INTO `lang_definitions` VALUES (615, 1400, 2, 'Kalenderinställningar');
INSERT INTO `lang_definitions` VALUES (616, 1402, 2, 'Kalender starttid');
INSERT INTO `lang_definitions` VALUES (617, 1403, 2, 'Kalender UI');
INSERT INTO `lang_definitions` VALUES (618, 1404, 2, 'Kalendervy');
INSERT INTO `lang_definitions` VALUES (619, 1407, 2, 'Anrop till addForm() skriv här. <br>');
INSERT INTO `lang_definitions` VALUES (620, 1411, 2, 'Kalorier');
INSERT INTO `lang_definitions` VALUES (621, 1412, 2, 'Kambodjan');
INSERT INTO `lang_definitions` VALUES (622, 1413, 2, 'CAMOS');
INSERT INTO `lang_definitions` VALUES (623, 1420, 2, 'Avbryt');
INSERT INTO `lang_definitions` VALUES (624, 1423, 2, 'Förkasta ändringar');
INSERT INTO `lang_definitions` VALUES (625, 1426, 2, 'Avbruten');
INSERT INTO `lang_definitions` VALUES (626, 1429, 2, 'Cancer');
INSERT INTO `lang_definitions` VALUES (627, 1430, 2, 'Cancer screening: Colon cancer screening');
INSERT INTO `lang_definitions` VALUES (628, 1431, 2, 'Scancer screening: Mammografi');
INSERT INTO `lang_definitions` VALUES (629, 1432, 2, 'Cancer screening: Pap smear');
INSERT INTO `lang_definitions` VALUES (630, 1433, 2, 'Cancer screening: Prostata cancer');
INSERT INTO `lang_definitions` VALUES (631, 1434, 2, 'Det går ej att lägga till detta för att det redan existerar!');
INSERT INTO `lang_definitions` VALUES (632, 1436, 2, 'Kan inte lägga till / uppdatera den här posten eftersom duplikat redan finns!');
INSERT INTO `lang_definitions` VALUES (633, 1437, 2, 'Kan inte lagra. Kastat.');
INSERT INTO `lang_definitions` VALUES (634, 1438, 2, 'kan inte konverteras till JPEG. Kanske ImageMagick inte är installerad?');
INSERT INTO `lang_definitions` VALUES (635, 1439, 2, 'Kan inte tas bort. Utan åtgärd.');
INSERT INTO `lang_definitions` VALUES (636, 1440, 2, 'kan inte visas online eftersom denna filtyp inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (637, 1441, 2, 'kan inte visas online eftersom denna filtyp inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (638, 1442, 2, 'kan inte visas online eftersom den typen inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (639, 1445, 2, 'Det går inte att skapa');
INSERT INTO `lang_definitions` VALUES (640, 1450, 2, 'Kan ej hitta');
INSERT INTO `lang_definitions` VALUES (641, 1451, 2, 'Kan ej hitta filnamnet');
INSERT INTO `lang_definitions` VALUES (642, 1454, 2, 'Kan inte hitta patienten från SQL-ledgers kundnummer');
INSERT INTO `lang_definitions` VALUES (643, 1455, 2, 'Kan ej hitta postscript dokumenthänvisning i');
INSERT INTO `lang_definitions` VALUES (644, 1456, 2, 'Kan inte hitta vårdgivaren i SQL-ledger');
INSERT INTO `lang_definitions` VALUES (645, 1457, 2, 'Kan inte ändra betalning. Odebiterat belopp är negativt.');
INSERT INTO `lang_definitions` VALUES (646, 1459, 2, 'Går inte att öppna');
INSERT INTO `lang_definitions` VALUES (647, 1460, 2, 'Kan inte bokföra på försäkring. Betalningsansvarig är patienten.');
INSERT INTO `lang_definitions` VALUES (648, 1461, 2, 'Kan inte bokföra på patient. Betalningsansvarig är försäkring.');
INSERT INTO `lang_definitions` VALUES (649, 1462, 2, 'Kan inte bokföra betalning. Odebiterat belopp är negativt.');
INSERT INTO `lang_definitions` VALUES (650, 1463, 2, 'Kan ej läsa');
INSERT INTO `lang_definitions` VALUES (651, 1464, 2, 'Kan ej läsa i mappen');
INSERT INTO `lang_definitions` VALUES (652, 1465, 2, 'Kan inte uppdatera eftersom du inte redigerar en befintlig post!');
INSERT INTO `lang_definitions` VALUES (653, 1466, 2, 'Stor bokstav');
INSERT INTO `lang_definitions` VALUES (654, 1468, 2, 'kapsel');
INSERT INTO `lang_definitions` VALUES (655, 1469, 2, 'Kort');
INSERT INTO `lang_definitions` VALUES (656, 1478, 2, 'Hjärtkateterisering');
INSERT INTO `lang_definitions` VALUES (657, 1479, 2, 'Hjärteko');
INSERT INTO `lang_definitions` VALUES (658, 1480, 2, 'Kardiovaskulära');
INSERT INTO `lang_definitions` VALUES (659, 1492, 2, 'Brosk / menisk skada');
INSERT INTO `lang_definitions` VALUES (660, 1493, 2, 'Broskskada');
INSERT INTO `lang_definitions` VALUES (661, 1494, 2, 'Inga karotispulsar. Inga fotpulsar.');
INSERT INTO `lang_definitions` VALUES (662, 1496, 2, 'kontanter');
INSERT INTO `lang_definitions` VALUES (663, 1497, 2, 'Kontanter');
INSERT INTO `lang_definitions` VALUES (664, 1498, 2, 'Kontantbetalning');
INSERT INTO `lang_definitions` VALUES (665, 1499, 2, 'Kontantkvitton från vårdgivare');
INSERT INTO `lang_definitions` VALUES (666, 1502, 2, 'Kataraktkirurgi');
INSERT INTO `lang_definitions` VALUES (667, 1503, 2, 'Katarakt');
INSERT INTO `lang_definitions` VALUES (668, 1504, 2, 'Kategorier');
INSERT INTO `lang_definitions` VALUES (669, 1505, 2, 'Kategorier av');
INSERT INTO `lang_definitions` VALUES (670, 1506, 2, 'Kategori');
INSERT INTO `lang_definitions` VALUES (671, 1507, 2, 'kategori');
INSERT INTO `lang_definitions` VALUES (672, 1508, 2, 'Kategori');
INSERT INTO `lang_definitions` VALUES (673, 1512, 2, 'Kategori Detaljer');
INSERT INTO `lang_definitions` VALUES (674, 1513, 2, 'Kategori Gränser');
INSERT INTO `lang_definitions` VALUES (675, 1514, 2, 'Kategorinamn');
INSERT INTO `lang_definitions` VALUES (676, 1515, 2, 'Kategorinamn är tomt');
INSERT INTO `lang_definitions` VALUES (677, 1516, 2, 'Kategori/Titel');
INSERT INTO `lang_definitions` VALUES (678, 1517, 2, 'Kaukasisk');
INSERT INTO `lang_definitions` VALUES (679, 1518, 2, 'Kvitto på kontaktorsak att skriva för besök. Primär vårdgivar information');
INSERT INTO `lang_definitions` VALUES (680, 1541, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (681, 1542, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (682, 1544, 2, 'Mobiltelefonnummer');
INSERT INTO `lang_definitions` VALUES (683, 1546, 2, 'Central Certifiering');
INSERT INTO `lang_definitions` VALUES (684, 1548, 2, 'Central/sydamerikan');
INSERT INTO `lang_definitions` VALUES (685, 1549, 2, 'CA certifikats fil-mapp kan inte vara tom');
INSERT INTO `lang_definitions` VALUES (686, 1550, 2, 'CA nyckelfilsmapp kan inte vara tom');
INSERT INTO `lang_definitions` VALUES (687, 1551, 2, 'CA certifikat för att skicka till RFS 5425 TLS syslog server');
INSERT INTO `lang_definitions` VALUES (688, 1552, 2, 'Certifikat användare');
INSERT INTO `lang_definitions` VALUES (689, 1553, 2, 'Certifikat');
INSERT INTO `lang_definitions` VALUES (690, 1557, 2, 'ChampUS');
INSERT INTO `lang_definitions` VALUES (691, 1558, 2, 'ChampUSVA');
INSERT INTO `lang_definitions` VALUES (692, 1559, 2, 'ändra');
INSERT INTO `lang_definitions` VALUES (693, 1560, 2, 'Ändra');
INSERT INTO `lang_definitions` VALUES (694, 1561, 2, 'Ändra Aktivitet');
INSERT INTO `lang_definitions` VALUES (695, 1565, 2, 'Gick inte ändra. CouchDB fel?');
INSERT INTO `lang_definitions` VALUES (696, 1566, 2, 'Synpåverkan');
INSERT INTO `lang_definitions` VALUES (697, 1567, 2, 'Synpåverkan');
INSERT INTO `lang_definitions` VALUES (698, 1569, 2, 'Byta lösenord');
INSERT INTO `lang_definitions` VALUES (699, 1574, 2, 'Ändrad');
INSERT INTO `lang_definitions` VALUES (700, 1575, 2, 'Förändrad tarm');
INSERT INTO `lang_definitions` VALUES (701, 1578, 2, 'Byter patientidentitet för dokument');
INSERT INTO `lang_definitions` VALUES (702, 1583, 2, 'Karaktär');
INSERT INTO `lang_definitions` VALUES (703, 1584, 2, 'Tecken kvar');
INSERT INTO `lang_definitions` VALUES (704, 1585, 2, 'Avgift');
INSERT INTO `lang_definitions` VALUES (705, 1586, 2, 'Justering av avgift');
INSERT INTO `lang_definitions` VALUES (706, 1587, 2, 'Avgift kodad');
INSERT INTO `lang_definitions` VALUES (707, 1589, 2, 'Avgifter');
INSERT INTO `lang_definitions` VALUES (708, 1591, 2, 'Patientkort');
INSERT INTO `lang_definitions` VALUES (709, 1592, 2, 'Patientkort aktivitet');
INSERT INTO `lang_definitions` VALUES (710, 1593, 2, 'Patientkort Check-in/out Aktivitetsrapport?');
INSERT INTO `lang_definitions` VALUES (711, 1595, 2, 'Patientkort ID');
INSERT INTO `lang_definitions` VALUES (712, 1596, 2, 'Patientkort ID');
INSERT INTO `lang_definitions` VALUES (713, 1598, 2, 'Patientkort placering Aktivitet');
INSERT INTO `lang_definitions` VALUES (714, 1599, 2, 'Patientkort notering');
INSERT INTO `lang_definitions` VALUES (715, 1600, 2, 'Patientkort nr');
INSERT INTO `lang_definitions` VALUES (716, 1602, 2, 'Patientkort lagring placering');
INSERT INTO `lang_definitions` VALUES (717, 1605, 2, 'Patientkort spåra');
INSERT INTO `lang_definitions` VALUES (718, 1606, 2, 'Patientkort spåra');
INSERT INTO `lang_definitions` VALUES (719, 1609, 2, 'Patientkort utcheckning');
INSERT INTO `lang_definitions` VALUES (720, 1610, 2, 'Patientkort utcheckning');
INSERT INTO `lang_definitions` VALUES (721, 1615, 2, 'Controleer of u van plan bent om ansichtkaarten te verzenden via MedEx');
INSERT INTO `lang_definitions` VALUES (722, 1616, 2, 'Betalningsanvisning');
INSERT INTO `lang_definitions` VALUES (723, 1617, 2, 'Alla betalningsanvisningar');
INSERT INTO `lang_definitions` VALUES (724, 1619, 2, 'Betalningsanvisning belopp');
INSERT INTO `lang_definitions` VALUES (725, 1621, 2, 'Betalningsanvisning datum');
INSERT INTO `lang_definitions` VALUES (726, 1623, 2, 'Kontrollera skillnader i översättning med översättningstabellen');
INSERT INTO `lang_definitions` VALUES (727, 1630, 2, 'checka in till');
INSERT INTO `lang_definitions` VALUES (728, 1631, 2, 'Kontrollera indata');
INSERT INTO `lang_definitions` VALUES (729, 1633, 2, 'Kontrollera labdata');
INSERT INTO `lang_definitions` VALUES (730, 1634, 2, 'Markering betyder påtittat');
INSERT INTO `lang_definitions` VALUES (731, 1635, 2, 'Betalningsanvisning nr');
INSERT INTO `lang_definitions` VALUES (732, 1636, 2, 'Betalningsanvisning nr');
INSERT INTO `lang_definitions` VALUES (733, 1640, 2, 'Betalningsanvisning betalning');
INSERT INTO `lang_definitions` VALUES (734, 1641, 2, 'Markera ifall filen är krypterad');
INSERT INTO `lang_definitions` VALUES (735, 1645, 2, 'Markera om vårdgivare ska se alla bokade besök som standard och ej enbart deras egna');
INSERT INTO `lang_definitions` VALUES (736, 1647, 2, 'Markera för att skapa \'Problem\' utifrån denna diagnos');
INSERT INTO `lang_definitions` VALUES (737, 1651, 2, 'Check / EOB Datum:');
INSERT INTO `lang_definitions` VALUES (738, 1653, 2, 'Check / EOB Nr:');
INSERT INTO `lang_definitions` VALUES (739, 1654, 2, 'Check / Ref Nr');
INSERT INTO `lang_definitions` VALUES (740, 1655, 2, 'Check / Referensnummer');
INSERT INTO `lang_definitions` VALUES (741, 1656, 2, 'Markeringsrutor lista');
INSERT INTO `lang_definitions` VALUES (742, 1657, 2, 'Markeringsrutor lista');
INSERT INTO `lang_definitions` VALUES (743, 1658, 2, 'Markeringsruta m text');
INSERT INTO `lang_definitions` VALUES (744, 1659, 2, 'Markeringsruta m text');
INSERT INTO `lang_definitions` VALUES (745, 1663, 2, 'Markerade fält = ja, tom = nej');
INSERT INTO `lang_definitions` VALUES (746, 1665, 2, 'Markerade fält = ja, tom = nej');
INSERT INTO `lang_definitions` VALUES (747, 1674, 2, 'Kassa');
INSERT INTO `lang_definitions` VALUES (748, 1678, 2, 'Kontrollsumma');
INSERT INTO `lang_definitions` VALUES (749, 1679, 2, 'Bröstkorg');
INSERT INTO `lang_definitions` VALUES (750, 1680, 2, 'Chest CTAB');
INSERT INTO `lang_definitions` VALUES (751, 1681, 2, 'Bröstsmärtor');
INSERT INTO `lang_definitions` VALUES (752, 1682, 2, 'Bröstsmärta:');
INSERT INTO `lang_definitions` VALUES (753, 1683, 2, 'Bröstsmärtor');
INSERT INTO `lang_definitions` VALUES (754, 1685, 2, 'Byt');
INSERT INTO `lang_definitions` VALUES (755, 1687, 2, 'Huvudproblem');
INSERT INTO `lang_definitions` VALUES (756, 1690, 2, 'Barn');
INSERT INTO `lang_definitions` VALUES (757, 1692, 2, 'Barnvaccinations status');
INSERT INTO `lang_definitions` VALUES (758, 1693, 2, 'Frossbrytningar');
INSERT INTO `lang_definitions` VALUES (759, 1694, 2, 'Kinesiska');
INSERT INTO `lang_definitions` VALUES (760, 1695, 2, 'Kinesiska (Förenklad)');
INSERT INTO `lang_definitions` VALUES (761, 1696, 2, 'Kinesiska (traditionell)');
INSERT INTO `lang_definitions` VALUES (762, 1698, 2, 'Val');
INSERT INTO `lang_definitions` VALUES (763, 1699, 2, 'Kolecystektomi');
INSERT INTO `lang_definitions` VALUES (764, 1701, 2, 'Kolecystektomi');
INSERT INTO `lang_definitions` VALUES (765, 1702, 2, 'Välj');
INSERT INTO `lang_definitions` VALUES (766, 1705, 2, 'Välj ett avsnitt och klicka på ett objekt i den ;i den andra sektionen visas relaterade objekt. Klicka på avsnitten om du vill lägga till och ta bort relationer.');
INSERT INTO `lang_definitions` VALUES (767, 1707, 2, 'Välj kriteria');
INSERT INTO `lang_definitions` VALUES (768, 1713, 2, 'Välj fil');
INSERT INTO `lang_definitions` VALUES (769, 1714, 2, 'Välj från lista');
INSERT INTO `lang_definitions` VALUES (770, 1716, 2, 'Välj lista');
INSERT INTO `lang_definitions` VALUES (771, 1722, 2, 'Välj utskriftsformat för besöksrapport');
INSERT INTO `lang_definitions` VALUES (772, 1726, 2, 'Kronisk bronkit');
INSERT INTO `lang_definitions` VALUES (773, 1727, 2, 'Kronisk ledvärk');
INSERT INTO `lang_definitions` VALUES (774, 1728, 2, 'Kroniska njurbesvär');
INSERT INTO `lang_definitions` VALUES (775, 1731, 2, 'Kronisk synovit / utgjutning / ledvärk / gikt');
INSERT INTO `lang_definitions` VALUES (776, 1733, 2, 'Kronisk / Återkommande');
INSERT INTO `lang_definitions` VALUES (777, 1737, 2, 'Levercirros');
INSERT INTO `lang_definitions` VALUES (778, 1738, 2, 'Levercirros');
INSERT INTO `lang_definitions` VALUES (779, 1739, 2, 'Stad');
INSERT INTO `lang_definitions` VALUES (780, 1741, 2, 'Stadsnamn');
INSERT INTO `lang_definitions` VALUES (781, 1742, 2, 'Stad, stat');
INSERT INTO `lang_definitions` VALUES (782, 1743, 2, 'Stad, stat postnummer');
INSERT INTO `lang_definitions` VALUES (783, 1746, 2, 'Stad / stat');
INSERT INTO `lang_definitions` VALUES (784, 1747, 2, 'Begär');
INSERT INTO `lang_definitions` VALUES (785, 1748, 2, 'Begär');
INSERT INTO `lang_definitions` VALUES (786, 1751, 2, 'Begäran status');
INSERT INTO `lang_definitions` VALUES (787, 1753, 2, 'Begäran typ');
INSERT INTO `lang_definitions` VALUES (788, 1754, 2, 'Begäran skapade fil');
INSERT INTO `lang_definitions` VALUES (789, 1755, 2, 'Begäran skapade fil');
INSERT INTO `lang_definitions` VALUES (790, 1756, 2, 'Begäran');
INSERT INTO `lang_definitions` VALUES (791, 1759, 2, 'Klassificering');
INSERT INTO `lang_definitions` VALUES (792, 1760, 2, 'Rensa');
INSERT INTO `lang_definitions` VALUES (793, 1763, 2, 'RENSA AKTIV PATIENT');
INSERT INTO `lang_definitions` VALUES (794, 1765, 2, 'Rensa allt');
INSERT INTO `lang_definitions` VALUES (795, 1768, 2, 'Rensa HL7 data');
INSERT INTO `lang_definitions` VALUES (796, 1770, 2, 'Rensa justering');
INSERT INTO `lang_definitions` VALUES (797, 1777, 2, 'Rensa Smarty Cache');
INSERT INTO `lang_definitions` VALUES (798, 1780, 2, 'CLIA Antal');
INSERT INTO `lang_definitions` VALUES (799, 1781, 2, 'Klicka');
INSERT INTO `lang_definitions` VALUES (800, 1782, 2, 'Klicka \'export\' för att exportera din kategori, underkategori, enhet eller innehållsdata till en textfil. Någon likhet mellan denna textfil och en XML-fil är enbart en tillfällighet. Start och sluttaggar måste vara på samma rad, måste vara med små bokstäver och utan mellanrum. För att importera, bläddra efter filen, klicka på \'import\'. Om data är helt annorlunda kommer det läggas till existerande data. Om det finns likvärdiga enhetsnamn kommer de gamla att behållas och de nya läggas till med en siffra i slutet av namnet.');
INSERT INTO `lang_definitions` VALUES (801, 1785, 2, 'Klicka på en plats på bilden för att lägga till notering. Klicka igen för att ta bort den.');
INSERT INTO `lang_definitions` VALUES (802, 1789, 2, 'Klicka ”Download Certificate” för att ladda ner certifikatet i filen ssl.zip');
INSERT INTO `lang_definitions` VALUES (803, 1790, 2, 'Klicka för mer');
INSERT INTO `lang_definitions` VALUES (804, 1791, 2, 'Klicka för mer detaljer');
INSERT INTO `lang_definitions` VALUES (805, 1792, 2, 'Klicka för att beställa summering');
INSERT INTO `lang_definitions` VALUES (806, 1793, 2, 'Klicka för resultat');
INSERT INTO `lang_definitions` VALUES (807, 1796, 2, 'Klicka här');
INSERT INTO `lang_definitions` VALUES (808, 1797, 2, 'Klicka här för att lägga till patient');
INSERT INTO `lang_definitions` VALUES (809, 1798, 2, 'Klicka här för att lägga till ny skada, byta status och ändra dagliga aktiviteter');
INSERT INTO `lang_definitions` VALUES (810, 1800, 2, 'Klicka här för att välja ett datum');
INSERT INTO `lang_definitions` VALUES (811, 1801, 2, 'Klicka här för att välja datum och klockslag');
INSERT INTO `lang_definitions` VALUES (812, 1802, 2, 'Klicka här för att välja startdatum');
INSERT INTO `lang_definitions` VALUES (813, 1825, 2, 'Klicka här för att söka');
INSERT INTO `lang_definitions` VALUES (814, 1828, 2, 'Klicka här för att uppdatera prioritet, kategori och smeknamn inställningar');
INSERT INTO `lang_definitions` VALUES (815, 1832, 2, 'Klicka här, för att se alla.');
INSERT INTO `lang_definitions` VALUES (816, 1833, 2, 'Klicka här för att se och rita');
INSERT INTO `lang_definitions` VALUES (817, 1835, 2, 'Klicka här för att se och rita all vitalparametrar');
INSERT INTO `lang_definitions` VALUES (818, 1836, 2, 'Klicka här för att se patient detaljer');
INSERT INTO `lang_definitions` VALUES (819, 1837, 2, 'Klicka här för att se alla');
INSERT INTO `lang_definitions` VALUES (820, 1838, 2, 'Klicka här för att se/ändra mer detaljer');
INSERT INTO `lang_definitions` VALUES (821, 1841, 2, 'Klicka ”install” knappen för att installera databas utgåva sedan följande datum');
INSERT INTO `lang_definitions` VALUES (822, 1849, 2, 'Klicka någonstans på tid för att öka');
INSERT INTO `lang_definitions` VALUES (823, 1870, 2, 'Klicka på patientnamn för att öppna patientfilen');
INSERT INTO `lang_definitions` VALUES (824, 1872, 2, 'Klicka ”uppdatera” för att se alla resultat eller var vänlig ange sökkriterier ovan för att se specifika resultat');
INSERT INTO `lang_definitions` VALUES (825, 1896, 2, 'Klicka för att lägga till diagnos');
INSERT INTO `lang_definitions` VALUES (826, 1899, 2, 'Lklicka för att lägga till komponent');
INSERT INTO `lang_definitions` VALUES (827, 1900, 2, 'Klicka för att lägga till konsultation');
INSERT INTO `lang_definitions` VALUES (828, 1905, 2, 'Klicka för att ladda ner');
INSERT INTO `lang_definitions` VALUES (829, 1906, 2, 'Klicka för att ändra');
INSERT INTO `lang_definitions` VALUES (830, 1907, 2, 'Klicka för att ändra beskrivning');
INSERT INTO `lang_definitions` VALUES (831, 1908, 2, 'Klicka för att ändra denna händelse');
INSERT INTO `lang_definitions` VALUES (832, 1913, 2, 'Klicka för att skapa rapporten');
INSERT INTO `lang_definitions` VALUES (833, 1924, 2, 'Klicka för att skriva ut');
INSERT INTO `lang_definitions` VALUES (834, 1926, 2, 'Klicka för att lägga till/ta emot ny lot');
INSERT INTO `lang_definitions` VALUES (835, 1931, 2, 'Klicka för att välja');
INSERT INTO `lang_definitions` VALUES (836, 1932, 2, 'Klicka för att välja');
INSERT INTO `lang_definitions` VALUES (837, 1934, 2, 'Klicka för att välja en industristandard kod för denna åtgärd');
INSERT INTO `lang_definitions` VALUES (838, 1937, 2, 'Klicka för att välja valbar åtgärdskod');
INSERT INTO `lang_definitions` VALUES (839, 1939, 2, 'Klicka för att välja eller byta CVX kod');
INSERT INTO `lang_definitions` VALUES (840, 1940, 2, 'Klicka för att välja eller ändra diagnoser');
INSERT INTO `lang_definitions` VALUES (841, 1941, 2, 'Klicka för att välja eller ändra tjänst kod');
INSERT INTO `lang_definitions` VALUES (842, 1942, 2, 'Klicka för att välja patient');
INSERT INTO `lang_definitions` VALUES (843, 1943, 2, 'Klicka för att välja tillhörande kod');
INSERT INTO `lang_definitions` VALUES (844, 1945, 2, 'Klicka för att välja tjänster att utföra om resultatet är avvikande');
INSERT INTO `lang_definitions` VALUES (845, 1948, 2, 'Klicka för att välja önskad åtgärd');
INSERT INTO `lang_definitions` VALUES (846, 1955, 2, 'Klicka för att sortera');
INSERT INTO `lang_definitions` VALUES (847, 1958, 2, 'Klicka för att visa eller redigera');
INSERT INTO `lang_definitions` VALUES (848, 1960, 2, 'Klicka för att visa eller redigera');
INSERT INTO `lang_definitions` VALUES (849, 1962, 2, 'Klicka för visa/redigera');
INSERT INTO `lang_definitions` VALUES (850, 1964, 2, 'Klicka Uppdatera knappen för att uppdatera databasutgåvan från följande datum');
INSERT INTO `lang_definitions` VALUES (851, 1967, 2, 'Klicka på:');
INSERT INTO `lang_definitions` VALUES (852, 1990, 2, 'Kund certifikat utgångsdatum');
INSERT INTO `lang_definitions` VALUES (853, 1992, 2, 'kund certifikat giltighetsperiod');
INSERT INTO `lang_definitions` VALUES (854, 1993, 2, 'Kundcertifikats giltighet ska vara ett giltigt nummer');
INSERT INTO `lang_definitions` VALUES (855, 1994, 2, 'kund kopia');
INSERT INTO `lang_definitions` VALUES (856, 1998, 2, 'Sammanfattning av kundens sjukdomshistoria');
INSERT INTO `lang_definitions` VALUES (857, 1999, 2, 'Kund namn');
INSERT INTO `lang_definitions` VALUES (858, 2001, 2, 'Kund nummer');
INSERT INTO `lang_definitions` VALUES (859, 2002, 2, 'Kundprofil - Ny kund');
INSERT INTO `lang_definitions` VALUES (860, 2003, 2, 'Kundprofil - Unika kunder');
INSERT INTO `lang_definitions` VALUES (861, 2008, 2, 'Kunder');
INSERT INTO `lang_definitions` VALUES (862, 2009, 2, 'Klinik');
INSERT INTO `lang_definitions` VALUES (863, 2010, 2, 'Klinik kopiera');
INSERT INTO `lang_definitions` VALUES (864, 2011, 2, 'Kliniken Daily Record');
INSERT INTO `lang_definitions` VALUES (865, 2012, 2, 'Klinik ID');
INSERT INTO `lang_definitions` VALUES (866, 2013, 2, 'Klinisk');
INSERT INTO `lang_definitions` VALUES (867, 2014, 2, 'Kliniskt beslutsstöd Påminnelsehantering');
INSERT INTO `lang_definitions` VALUES (868, 2016, 2, 'Anamnes');
INSERT INTO `lang_definitions` VALUES (869, 2020, 2, 'Klinisk planering');
INSERT INTO `lang_definitions` VALUES (870, 2021, 2, 'Kliniska kvalitetskrav');
INSERT INTO `lang_definitions` VALUES (871, 2024, 2, 'Klinikens påminnelser');
INSERT INTO `lang_definitions` VALUES (872, 2028, 2, 'Klinikens rapporter');
INSERT INTO `lang_definitions` VALUES (873, 2029, 2, 'Kliniskt beslutsstöd Kategorier');
INSERT INTO `lang_definitions` VALUES (874, 2030, 2, 'Kliniskt beslutsstöd Enheter');
INSERT INTO `lang_definitions` VALUES (875, 2031, 2, 'Kliniskt beslutsstöd Urvalsfunktioner');
INSERT INTO `lang_definitions` VALUES (876, 2032, 2, 'Kliniskt beslutsstöd Mål metoder');
INSERT INTO `lang_definitions` VALUES (877, 2033, 2, 'Kliniskt beslutsstöd Enheter');
INSERT INTO `lang_definitions` VALUES (878, 2034, 2, 'Kliniskt beslutsstöd ålders intervaller');
INSERT INTO `lang_definitions` VALUES (879, 2035, 2, 'Kliniskt beslutsstöd jämförelser');
INSERT INTO `lang_definitions` VALUES (880, 2036, 2, 'Kliniskt beslutsstöd Typer av besök');
INSERT INTO `lang_definitions` VALUES (881, 2037, 2, 'Kliniskt beslutsstöd Påminnelser giltighet inställningar');
INSERT INTO `lang_definitions` VALUES (882, 2038, 2, 'Kliniskt beslutsstöd Påminnelser inaktiveringsinställningar');
INSERT INTO `lang_definitions` VALUES (883, 2039, 2, 'Kliniskt beslutsstöd påminnelser intervaller');
INSERT INTO `lang_definitions` VALUES (884, 2040, 2, 'Kliniskt beslutsstöd påminnelser metoder');
INSERT INTO `lang_definitions` VALUES (885, 2041, 2, 'Kliniskt beslutsstöd Mål intervaller');
INSERT INTO `lang_definitions` VALUES (886, 2042, 2, 'Kliniska mål');
INSERT INTO `lang_definitions` VALUES (887, 2043, 2, 'Kliniskt begrepp');
INSERT INTO `lang_definitions` VALUES (888, 2044, 2, 'Kliniska begrepp koder');
INSERT INTO `lang_definitions` VALUES (889, 2046, 2, 'Kliniskt verksamma');
INSERT INTO `lang_definitions` VALUES (890, 2047, 2, 'Kopiera');
INSERT INTO `lang_definitions` VALUES (891, 2048, 2, 'Kopiera tidigare besök');
INSERT INTO `lang_definitions` VALUES (892, 2049, 2, 'Stäng');
INSERT INTO `lang_definitions` VALUES (893, 2058, 2, 'Stäng fönstret');
INSERT INTO `lang_definitions` VALUES (894, 2060, 2, 'Stängt');
INSERT INTO `lang_definitions` VALUES (895, 2061, 2, 'cm');
INSERT INTO `lang_definitions` VALUES (896, 2064, 2, 'CMS 1500 marginal');
INSERT INTO `lang_definitions` VALUES (897, 2073, 2, 'CMS-id');
INSERT INTO `lang_definitions` VALUES (898, 2088, 2, 'CN2-12 intakta');
INSERT INTO `lang_definitions` VALUES (899, 2091, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (900, 2092, 2, 'Medbetalare Betalning');
INSERT INTO `lang_definitions` VALUES (901, 2095, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (902, 2097, 2, 'Kod');
INSERT INTO `lang_definitions` VALUES (903, 2098, 2, 'kod');
INSERT INTO `lang_definitions` VALUES (904, 2100, 2, 'Kodsökare');
INSERT INTO `lang_definitions` VALUES (905, 2101, 2, 'Kod måste vara två bokstäver (små bokstäver)');
INSERT INTO `lang_definitions` VALUES (906, 2102, 2, 'Kod eller symbol för att ange valuta');
INSERT INTO `lang_definitions` VALUES (907, 2104, 2, 'Kod text');
INSERT INTO `lang_definitions` VALUES (908, 2106, 2, 'Kod typer');
INSERT INTO `lang_definitions` VALUES (909, 2109, 2, 'Kod typer');
INSERT INTO `lang_definitions` VALUES (910, 2110, 2, 'Koder');
INSERT INTO `lang_definitions` VALUES (911, 2111, 2, 'Kodad');
INSERT INTO `lang_definitions` VALUES (912, 2112, 2, 'Koder');
INSERT INTO `lang_definitions` VALUES (913, 2114, 2, 'Kodning');
INSERT INTO `lang_definitions` VALUES (914, 2116, 2, 'Kodning – alla besök (skriv, med valbara alternativ)');
INSERT INTO `lang_definitions` VALUES (915, 2118, 2, 'Kodning – mina besök (skriv, med valbara alternativ)');
INSERT INTO `lang_definitions` VALUES (916, 2123, 2, 'Kodning ej godkänd');
INSERT INTO `lang_definitions` VALUES (917, 2124, 2, 'Kaffe');
INSERT INTO `lang_definitions` VALUES (918, 2128, 2, 'Med-försäkring');
INSERT INTO `lang_definitions` VALUES (919, 2129, 2, 'Förf.saml w / o');
INSERT INTO `lang_definitions` VALUES (920, 2131, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (921, 2132, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (922, 2133, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (923, 2134, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (924, 2135, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (925, 2140, 2, 'samlings datum');
INSERT INTO `lang_definitions` VALUES (926, 2142, 2, 'Samlingar');
INSERT INTO `lang_definitions` VALUES (927, 2143, 2, 'Samlingsrapport');
INSERT INTO `lang_definitions` VALUES (928, 2144, 2, 'Koloncancer');
INSERT INTO `lang_definitions` VALUES (929, 2145, 2, 'Koloncancer screening');
INSERT INTO `lang_definitions` VALUES (930, 2146, 2, 'Koloncancer Kirurgi');
INSERT INTO `lang_definitions` VALUES (931, 2147, 2, 'Koloskopi');
INSERT INTO `lang_definitions` VALUES (932, 2148, 2, 'Koloskopi');
INSERT INTO `lang_definitions` VALUES (933, 2149, 2, 'Färg');
INSERT INTO `lang_definitions` VALUES (934, 2155, 2, 'Färg förkortning');
INSERT INTO `lang_definitions` VALUES (935, 2156, 2, 'Kolumn');
INSERT INTO `lang_definitions` VALUES (936, 2157, 2, 'Kolumner');
INSERT INTO `lang_definitions` VALUES (937, 2159, 2, 'Slå ihop grupper');
INSERT INTO `lang_definitions` VALUES (938, 2160, 2, 'Komma');
INSERT INTO `lang_definitions` VALUES (939, 2162, 2, 'Kommentar');
INSERT INTO `lang_definitions` VALUES (940, 2163, 2, 'Kommentarer');
INSERT INTO `lang_definitions` VALUES (941, 2168, 2, 'Kommentarer om detta resultat eller rekomendation');
INSERT INTO `lang_definitions` VALUES (942, 2169, 2, 'Commercial Insurance Co');
INSERT INTO `lang_definitions` VALUES (943, 2170, 2, 'Godkänn Ändringar');
INSERT INTO `lang_definitions` VALUES (944, 2176, 2, 'Förbindelser');
INSERT INTO `lang_definitions` VALUES (945, 2179, 2, 'Företag');
INSERT INTO `lang_definitions` VALUES (946, 2180, 2, 'Företag namn');
INSERT INTO `lang_definitions` VALUES (947, 2181, 2, 'Komplett');
INSERT INTO `lang_definitions` VALUES (948, 2186, 2, 'Klar?');
INSERT INTO `lang_definitions` VALUES (949, 2187, 2, 'Remover por completo la capacidad de mostrar el Tablero de Flujo de Pacientes');
INSERT INTO `lang_definitions` VALUES (950, 2188, 2, 'Estado de finalización');
INSERT INTO `lang_definitions` VALUES (951, 2189, 2, 'Komplikationer orsakade av vårdgivare');
INSERT INTO `lang_definitions` VALUES (952, 2190, 2, 'Abortkomplikationer');
INSERT INTO `lang_definitions` VALUES (953, 2191, 2, 'Enheter');
INSERT INTO `lang_definitions` VALUES (954, 2200, 2, 'Datorstödd Medicinskt beställningssystem');
INSERT INTO `lang_definitions` VALUES (955, 2202, 2, 'Slutsatser');
INSERT INTO `lang_definitions` VALUES (956, 2210, 2, 'Inställningar');
INSERT INTO `lang_definitions` VALUES (957, 2211, 2, 'Inställningar import/export');
INSERT INTO `lang_definitions` VALUES (958, 2213, 2, 'Konfigurera Apache och open EMR för att använda klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (959, 2214, 2, 'Konfigurera Apache att använda Klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (960, 2215, 2, 'Konfigurera apache för att använda HTTPS');
INSERT INTO `lang_definitions` VALUES (961, 2216, 2, 'Konfigurera openEMR för att använda Klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (962, 2225, 2, 'Bekräfta Skapa ny patient');
INSERT INTO `lang_definitions` VALUES (963, 2227, 2, 'Bekräfta Nytt lösenord');
INSERT INTO `lang_definitions` VALUES (964, 2229, 2, 'Bekräfta Betalning');
INSERT INTO `lang_definitions` VALUES (965, 2238, 2, 'Medfödd');
INSERT INTO `lang_definitions` VALUES (966, 2240, 2, 'Konjunktiva, pupiller');
INSERT INTO `lang_definitions` VALUES (967, 2243, 2, 'Sammanbindningar');
INSERT INTO `lang_definitions` VALUES (968, 2245, 2, 'Konstant');
INSERT INTO `lang_definitions` VALUES (969, 2247, 2, 'Konstant namn');
INSERT INTO `lang_definitions` VALUES (970, 2248, 2, 'Konstantnamn är tomt');
INSERT INTO `lang_definitions` VALUES (971, 2249, 2, 'Konstanter');
INSERT INTO `lang_definitions` VALUES (972, 2250, 2, 'Förstoppning');
INSERT INTO `lang_definitions` VALUES (973, 2251, 2, 'Konstitutionella');
INSERT INTO `lang_definitions` VALUES (974, 2254, 2, 'Konsultation, kortfattad beskrivning');
INSERT INTO `lang_definitions` VALUES (975, 2259, 2, 'Kontakt');
INSERT INTO `lang_definitions` VALUES (976, 2260, 2, 'E-postadress');
INSERT INTO `lang_definitions` VALUES (977, 2261, 2, 'Epostadresser');
INSERT INTO `lang_definitions` VALUES (978, 2262, 2, 'Kontakta EMR direkt för att prenumerera på phiMail Direct meddelande service');
INSERT INTO `lang_definitions` VALUES (979, 2264, 2, 'Kontaktinformation');
INSERT INTO `lang_definitions` VALUES (980, 2268, 2, 'Kontaktlinser');
INSERT INTO `lang_definitions` VALUES (981, 2269, 2, 'Contact Medical Information Integration, LLC at http://mi-squared.com for Lab Exchange Service.');
INSERT INTO `lang_definitions` VALUES (982, 2270, 2, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing the eRx service');
INSERT INTO `lang_definitions` VALUES (983, 2273, 2, 'Kontaktnamn');
INSERT INTO `lang_definitions` VALUES (984, 2276, 2, 'Kontaktperson');
INSERT INTO `lang_definitions` VALUES (985, 2278, 2, 'Kontakttelefonnummer');
INSERT INTO `lang_definitions` VALUES (986, 2281, 2, 'Contact ZMG, LLC (zmghealth@gmail.com) for subscribing the eRx service');
INSERT INTO `lang_definitions` VALUES (987, 2283, 2, 'Innehåller minst tre av följande fyra enheter:');
INSERT INTO `lang_definitions` VALUES (988, 2284, 2, 'Behållare Gruppnamn');
INSERT INTO `lang_definitions` VALUES (989, 2285, 2, 'Innehåll');
INSERT INTO `lang_definitions` VALUES (990, 2286, 2, 'innehåll');
INSERT INTO `lang_definitions` VALUES (991, 2288, 2, 'Sammanhang');
INSERT INTO `lang_definitions` VALUES (992, 2289, 2, 'Sammanhangsnamn kan inte vara tomt');
INSERT INTO `lang_definitions` VALUES (993, 2290, 2, 'Fortsätt');
INSERT INTO `lang_definitions` VALUES (994, 2294, 2, 'Vårdplanerings dokument');
INSERT INTO `lang_definitions` VALUES (995, 2297, 2, 'Vårdplanering');
INSERT INTO `lang_definitions` VALUES (996, 2298, 2, 'kontraindikationer');
INSERT INTO `lang_definitions` VALUES (997, 2299, 2, 'Preventivmedel');
INSERT INTO `lang_definitions` VALUES (998, 2301, 2, 'Preventivmedelsproblematik');
INSERT INTO `lang_definitions` VALUES (999, 2302, 2, 'Preventivmedelsproblematik (specificera)');
INSERT INTO `lang_definitions` VALUES (1000, 2303, 2, 'Preventivmedel Metod');
INSERT INTO `lang_definitions` VALUES (1001, 2304, 2, 'Preventivmedel');
INSERT INTO `lang_definitions` VALUES (1002, 2305, 2, 'Preventivmedel, tjänster som tidigare startats');
INSERT INTO `lang_definitions` VALUES (1003, 2306, 2, 'Preventivmedel start');
INSERT INTO `lang_definitions` VALUES (1004, 2311, 2, 'Kontrollnummer');
INSERT INTO `lang_definitions` VALUES (1005, 2312, 2, 'Kontrollnummer');
INSERT INTO `lang_definitions` VALUES (1006, 2321, 2, 'medbetalare');
INSERT INTO `lang_definitions` VALUES (1007, 2322, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1008, 2323, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1009, 2324, 2, 'medbetalare nekar');
INSERT INTO `lang_definitions` VALUES (1010, 2326, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1011, 2327, 2, 'COPD');
INSERT INTO `lang_definitions` VALUES (1012, 2331, 2, 'Kopiera Sidor till Patientdiagram');
INSERT INTO `lang_definitions` VALUES (1013, 2335, 2, 'Kopiera Värderingar');
INSERT INTO `lang_definitions` VALUES (1014, 2336, 2, 'Kopiera databasfilen. Detta tar en stund...');
INSERT INTO `lang_definitions` VALUES (1015, 2337, 2, 'Upphovsrättsskydd');
INSERT INTO `lang_definitions` VALUES (1016, 2342, 2, 'Coronary Artery Bypass');
INSERT INTO `lang_definitions` VALUES (1017, 2343, 2, 'Coronary Artery Bypass Graft (CABG)');
INSERT INTO `lang_definitions` VALUES (1018, 2344, 2, 'Rättad');
INSERT INTO `lang_definitions` VALUES (1019, 2346, 2, 'CouchDB');
INSERT INTO `lang_definitions` VALUES (1020, 2347, 2, 'Kunde inte ansluta till CouchDB');
INSERT INTO `lang_definitions` VALUES (1021, 2349, 2, 'CouchDB databas');
INSERT INTO `lang_definitions` VALUES (1022, 2350, 2, 'CouchDB databas namn');
INSERT INTO `lang_definitions` VALUES (1023, 2353, 2, 'CouchDB värd');
INSERT INTO `lang_definitions` VALUES (1024, 2354, 2, 'CouchDB värdnamn');
INSERT INTO `lang_definitions` VALUES (1025, 2355, 2, 'CouchDB log på');
INSERT INTO `lang_definitions` VALUES (1026, 2356, 2, 'CouchDB lösenord');
INSERT INTO `lang_definitions` VALUES (1027, 2357, 2, 'CouchDB port');
INSERT INTO `lang_definitions` VALUES (1028, 2358, 2, 'CouchDB port');
INSERT INTO `lang_definitions` VALUES (1029, 2361, 2, 'CouchDB användarnamn');
INSERT INTO `lang_definitions` VALUES (1030, 2362, 2, 'Hosta');
INSERT INTO `lang_definitions` VALUES (1031, 2363, 2, 'Hosta:');
INSERT INTO `lang_definitions` VALUES (1032, 2370, 2, 'Kunde ej läsa fil');
INSERT INTO `lang_definitions` VALUES (1033, 2373, 2, 'Kunde inte skicka e-post på grund av en server problem');
INSERT INTO `lang_definitions` VALUES (1034, 2375, 2, 'Kunde inte skicka e-post på grund av en server problem');
INSERT INTO `lang_definitions` VALUES (1035, 2376, 2, 'Kunde inte skapa backup');
INSERT INTO `lang_definitions` VALUES (1036, 2377, 2, 'Kunde inte ta bort mapp');
INSERT INTO `lang_definitions` VALUES (1037, 2378, 2, 'Kunde inte ta bort gammal backup fil');
INSERT INTO `lang_definitions` VALUES (1038, 2379, 2, 'Kunde inte ta bort gammal export fil');
INSERT INTO `lang_definitions` VALUES (1039, 2380, 2, 'Waran INR kontroll');
INSERT INTO `lang_definitions` VALUES (1040, 2381, 2, 'Couns av metod');
INSERT INTO `lang_definitions` VALUES (1041, 2382, 2, 'Rådgivning');
INSERT INTO `lang_definitions` VALUES (1042, 2383, 2, 'Rådgivning, Aktivitet');
INSERT INTO `lang_definitions` VALUES (1043, 2386, 2, 'svarsremiss, formulär');
INSERT INTO `lang_definitions` VALUES (1044, 2387, 2, 'Nation');
INSERT INTO `lang_definitions` VALUES (1045, 2388, 2, 'Land');
INSERT INTO `lang_definitions` VALUES (1046, 2390, 2, 'Typ av nationsdata');
INSERT INTO `lang_definitions` VALUES (1047, 2391, 2, 'Nationslista');
INSERT INTO `lang_definitions` VALUES (1048, 2392, 2, 'Nationslista');
INSERT INTO `lang_definitions` VALUES (1049, 2394, 2, 'Nationsnamn ska representeras av två bokstäver');
INSERT INTO `lang_definitions` VALUES (1050, 2395, 2, 'Landsting');
INSERT INTO `lang_definitions` VALUES (1051, 2397, 2, 'kupong');
INSERT INTO `lang_definitions` VALUES (1052, 2404, 2, 'CPT');
INSERT INTO `lang_definitions` VALUES (1053, 2405, 2, 'CPT Koder');
INSERT INTO `lang_definitions` VALUES (1054, 2406, 2, 'CPT Koder');
INSERT INTO `lang_definitions` VALUES (1055, 2407, 2, 'CPT4 Åtgärder/Tjänster');
INSERT INTO `lang_definitions` VALUES (1056, 2408, 2, 'CPTII Mått på utförande');
INSERT INTO `lang_definitions` VALUES (1057, 2409, 2, 'Kvalitetscertifikat (GCP)');
INSERT INTO `lang_definitions` VALUES (1058, 2412, 2, 'Sprickor:');
INSERT INTO `lang_definitions` VALUES (1059, 2415, 2, 'kräm');
INSERT INTO `lang_definitions` VALUES (1060, 2417, 2, 'Skapa klient certifikat SSL för varje användare eller dator');
INSERT INTO `lang_definitions` VALUES (1061, 2418, 2, 'Skapa klientcertifikat för antingen användare eller datornamn');
INSERT INTO `lang_definitions` VALUES (1062, 2430, 2, 'Skapa en händelse');
INSERT INTO `lang_definitions` VALUES (1063, 2434, 2, 'Skapa och ladda ner en fullständig backup');
INSERT INTO `lang_definitions` VALUES (1064, 2436, 2, 'Skapa beackup');
INSERT INTO `lang_definitions` VALUES (1065, 2437, 2, 'Skapa grupp');
INSERT INTO `lang_definitions` VALUES (1066, 2438, 2, 'Skapa kientcertifikat');
INSERT INTO `lang_definitions` VALUES (1067, 2439, 2, 'Skapa klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (1068, 2442, 2, 'Skapa kopia');
INSERT INTO `lang_definitions` VALUES (1069, 2444, 2, 'Skapa backup av händelselog');
INSERT INTO `lang_definitions` VALUES (1070, 2446, 2, 'Skapa ny aktivitet');
INSERT INTO `lang_definitions` VALUES (1071, 2448, 2, 'Skapa ny patient');
INSERT INTO `lang_definitions` VALUES (1072, 2452, 2, 'Skapa externa port rättigheter');
INSERT INTO `lang_definitions` VALUES (1073, 2454, 2, 'Skapa interna port rättigheter');
INSERT INTO `lang_definitions` VALUES (1074, 2456, 2, 'Skapa Patientanteckning');
INSERT INTO `lang_definitions` VALUES (1075, 2458, 2, 'Skapa SSL certifikat utgivare och server certifikat');
INSERT INTO `lang_definitions` VALUES (1076, 2459, 2, 'Skapa besök');
INSERT INTO `lang_definitions` VALUES (1077, 2460, 2, 'Skapad');
INSERT INTO `lang_definitions` VALUES (1078, 2470, 2, 'Skapa exportfil');
INSERT INTO `lang_definitions` VALUES (1079, 2472, 2, 'Skapande av fil på värden misslyckades');
INSERT INTO `lang_definitions` VALUES (1080, 2473, 2, 'Skapare');
INSERT INTO `lang_definitions` VALUES (1081, 2475, 2, 'kredit');
INSERT INTO `lang_definitions` VALUES (1082, 2477, 2, 'Kreditkort');
INSERT INTO `lang_definitions` VALUES (1083, 2483, 2, 'Kredit');
INSERT INTO `lang_definitions` VALUES (1084, 2485, 2, 'Kriterier');
INSERT INTO `lang_definitions` VALUES (1085, 2488, 2, 'Crohn\'s sjukdom');
INSERT INTO `lang_definitions` VALUES (1086, 2489, 2, 'Chrons sjukdom');
INSERT INTO `lang_definitions` VALUES (1087, 2493, 2, 'export av kommaseparerad lista');
INSERT INTO `lang_definitions` VALUES (1088, 2494, 2, 'Kommaseparerad fil');
INSERT INTO `lang_definitions` VALUES (1089, 2495, 2, 'Kommaseparerad tabell');
INSERT INTO `lang_definitions` VALUES (1090, 2500, 2, 'Kubikmillimeter');
INSERT INTO `lang_definitions` VALUES (1091, 2501, 2, 'Kuban');
INSERT INTO `lang_definitions` VALUES (1092, 2503, 2, 'Valuta decimaler');
INSERT INTO `lang_definitions` VALUES (1093, 2504, 2, 'Valuta decimaltecken');
INSERT INTO `lang_definitions` VALUES (1094, 2505, 2, 'Valutatecken');
INSERT INTO `lang_definitions` VALUES (1095, 2506, 2, 'Valuta tusenseparator');
INSERT INTO `lang_definitions` VALUES (1096, 2507, 2, 'Pågående');
INSERT INTO `lang_definitions` VALUES (1097, 2508, 2, 'Alkohol aktuellt');
INSERT INTO `lang_definitions` VALUES (1098, 2512, 2, 'Pågående konsultation');
INSERT INTO `lang_definitions` VALUES (1099, 2513, 2, 'Aktuella kriterier');
INSERT INTO `lang_definitions` VALUES (1100, 2515, 2, 'Markeringsfärg för aktuell dag');
INSERT INTO `lang_definitions` VALUES (1101, 2516, 2, 'Röker dagligen');
INSERT INTO `lang_definitions` VALUES (1102, 2518, 2, 'Nuvarande filnamn är ändrat till');
INSERT INTO `lang_definitions` VALUES (1103, 2520, 2, 'Använder hash');
INSERT INTO `lang_definitions` VALUES (1104, 2521, 2, 'Nuvarande lokalisation');
INSERT INTO `lang_definitions` VALUES (1105, 2523, 2, 'Aktuell medicinering');
INSERT INTO `lang_definitions` VALUES (1106, 2525, 2, 'Aktuellt lösenord');
INSERT INTO `lang_definitions` VALUES (1107, 2527, 2, 'Pågående patient');
INSERT INTO `lang_definitions` VALUES (1108, 2534, 2, 'Aktuella droger');
INSERT INTO `lang_definitions` VALUES (1109, 2536, 2, 'Tillfällighetsrökare');
INSERT INTO `lang_definitions` VALUES (1110, 2544, 2, 'För närvarande Aktiv');
INSERT INTO `lang_definitions` VALUES (1111, 2548, 2, 'Pågår');
INSERT INTO `lang_definitions` VALUES (1112, 2550, 2, 'Ingen aktuell klinik');
INSERT INTO `lang_definitions` VALUES (1113, 2552, 2, 'Cushing Syndrom');
INSERT INTO `lang_definitions` VALUES (1114, 2553, 2, 'Cushings syndrom');
INSERT INTO `lang_definitions` VALUES (1115, 2556, 2, 'Anpassad');
INSERT INTO `lang_definitions` VALUES (1116, 2564, 2, 'Anpassat input');
INSERT INTO `lang_definitions` VALUES (1117, 2569, 2, 'Anpassad tabell');
INSERT INTO `lang_definitions` VALUES (1118, 2578, 2, 'CVX kod');
INSERT INTO `lang_definitions` VALUES (1119, 2579, 2, 'CVX kod koppling');
INSERT INTO `lang_definitions` VALUES (1120, 2580, 2, 'CVX vaccination');
INSERT INTO `lang_definitions` VALUES (1121, 2588, 2, 'CYP');
INSERT INTO `lang_definitions` VALUES (1122, 2589, 2, 'CYP Factor');
INSERT INTO `lang_definitions` VALUES (1123, 2590, 2, 'CYP Rapport');
INSERT INTO `lang_definitions` VALUES (1124, 2593, 2, 'Tjeckisk');
INSERT INTO `lang_definitions` VALUES (1125, 2594, 2, 'D');
INSERT INTO `lang_definitions` VALUES (1126, 2595, 2, 'D & C');
INSERT INTO `lang_definitions` VALUES (1127, 2596, 2, 'D & E');
INSERT INTO `lang_definitions` VALUES (1128, 2598, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1129, 2599, 2, 'dagligen');
INSERT INTO `lang_definitions` VALUES (1130, 2600, 2, 'Daglig registrering');
INSERT INTO `lang_definitions` VALUES (1131, 2605, 2, 'dansk');
INSERT INTO `lang_definitions` VALUES (1132, 2609, 2, 'Liknande data finns redan i databasen, ändra koden och / eller beskrivning');
INSERT INTO `lang_definitions` VALUES (1133, 2610, 2, 'Liknande data finns redan i databasen, ändra koden och / eller beskrivning');
INSERT INTO `lang_definitions` VALUES (1134, 2611, 2, 'Data kolumner');
INSERT INTO `lang_definitions` VALUES (1135, 2614, 2, 'Data fel');
INSERT INTO `lang_definitions` VALUES (1136, 2619, 2, 'Datattyp');
INSERT INTO `lang_definitions` VALUES (1137, 2620, 2, 'Databas');
INSERT INTO `lang_definitions` VALUES (1138, 2622, 2, 'Databas är inte installerad');
INSERT INTO `lang_definitions` VALUES (1139, 2624, 2, 'databas revision');
INSERT INTO `lang_definitions` VALUES (1140, 2625, 2, 'Databasrapportering');
INSERT INTO `lang_definitions` VALUES (1141, 2627, 2, 'Uppdatering av databas avslutad');
INSERT INTO `lang_definitions` VALUES (1142, 2628, 2, 'Datacols måste ha ett nummer mellan 1 och 999');
INSERT INTO `lang_definitions` VALUES (1143, 2629, 2, 'Datum');
INSERT INTO `lang_definitions` VALUES (1144, 2631, 2, 'DATUM');
INSERT INTO `lang_definitions` VALUES (1145, 2632, 2, 'Hantering av datum och tid');
INSERT INTO `lang_definitions` VALUES (1146, 2634, 2, 'Administreringsdatum');
INSERT INTO `lang_definitions` VALUES (1147, 2635, 2, 'datum och tid för insamling');
INSERT INTO `lang_definitions` VALUES (1148, 2636, 2, 'datum och tid för observation');
INSERT INTO `lang_definitions` VALUES (1149, 2638, 2, 'Datum och tid när provet togs');
INSERT INTO `lang_definitions` VALUES (1150, 2639, 2, 'datum kan inte vara senare än idag');
INSERT INTO `lang_definitions` VALUES (1151, 2640, 2, 'Datum då preventivmeddel insattes för första gången');
INSERT INTO `lang_definitions` VALUES (1152, 2641, 2, 'Skapat datum');
INSERT INTO `lang_definitions` VALUES (1153, 2642, 2, 'Datum avslutad');
INSERT INTO `lang_definitions` VALUES (1154, 2643, 2, 'Förstörd datum');
INSERT INTO `lang_definitions` VALUES (1155, 2644, 2, 'Sätt att visa datum');
INSERT INTO `lang_definitions` VALUES (1156, 2645, 2, 'Datumformat för \"mötet slutar\" är inte giltigt');
INSERT INTO `lang_definitions` VALUES (1157, 2646, 2, 'Datumformat för \"mötet startat \"är inte giltig');
INSERT INTO `lang_definitions` VALUES (1158, 2647, 2, 'Datumformat för \"Nästa Möte\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1159, 2648, 2, 'Datumformat för \"sista besök\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1160, 2650, 2, 'Datumformat för \"sista besök\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1161, 2651, 2, 'Datum för vaccinationsinformation');
INSERT INTO `lang_definitions` VALUES (1162, 2652, 2, 'Datum saknas för kod');
INSERT INTO `lang_definitions` VALUES (1163, 2653, 2, 'Huvudsakligt kriterium för datum');
INSERT INTO `lang_definitions` VALUES (1164, 2656, 2, 'Datum för bankinsättning åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1165, 2657, 2, 'datum för fakturering');
INSERT INTO `lang_definitions` VALUES (1166, 2658, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1167, 2659, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1168, 2660, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1169, 2663, 2, 'datum för registrering');
INSERT INTO `lang_definitions` VALUES (1170, 2665, 2, 'Datum för skada');
INSERT INTO `lang_definitions` VALUES (1171, 2669, 2, 'Datum för betalning åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1172, 2671, 2, 'Remissdatum');
INSERT INTO `lang_definitions` VALUES (1173, 2673, 2, 'Svarsdatum');
INSERT INTO `lang_definitions` VALUES (1174, 2674, 2, 'Rapportdatum');
INSERT INTO `lang_definitions` VALUES (1175, 2675, 2, 'Datum för tjänsten');
INSERT INTO `lang_definitions` VALUES (1176, 2677, 2, 'Datum för tjänst');
INSERT INTO `lang_definitions` VALUES (1177, 2678, 2, 'datum för tjänsten = idag');
INSERT INTO `lang_definitions` VALUES (1178, 2680, 2, 'Datum för tjänst MM / DD / ÅÅÅÅ');
INSERT INTO `lang_definitions` VALUES (1179, 2681, 2, 'Datum för tjänst:');
INSERT INTO `lang_definitions` VALUES (1180, 2682, 2, 'datum för signering');
INSERT INTO `lang_definitions` VALUES (1181, 2683, 2, 'datum för förändrat status');
INSERT INTO `lang_definitions` VALUES (1182, 2685, 2, 'Orderdatum');
INSERT INTO `lang_definitions` VALUES (1183, 2686, 2, 'Rapportdatum');
INSERT INTO `lang_definitions` VALUES (1184, 2687, 2, 'Datum för VIS deklaration');
INSERT INTO `lang_definitions` VALUES (1185, 2688, 2, 'datum beställd');
INSERT INTO `lang_definitions` VALUES (1186, 2692, 2, 'Val av datum');
INSERT INTO `lang_definitions` VALUES (1187, 2693, 2, 'Skickat datum');
INSERT INTO `lang_definitions` VALUES (1188, 2694, 2, 'Datum då meddelande skickades');
INSERT INTO `lang_definitions` VALUES (1189, 2697, 2, 'datumvärde kan inte vara tomt.');
INSERT INTO `lang_definitions` VALUES (1190, 2700, 2, 'datum/planerat besök');
INSERT INTO `lang_definitions` VALUES (1191, 2701, 2, 'Datum/anteckningar');
INSERT INTO `lang_definitions` VALUES (1192, 2702, 2, 'Datum / Anteckningar, senast');
INSERT INTO `lang_definitions` VALUES (1193, 2703, 2, 'datum/tid');
INSERT INTO `lang_definitions` VALUES (1194, 2704, 2, 'Datum:');
INSERT INTO `lang_definitions` VALUES (1195, 2707, 2, 'Daterad meddelande log');
INSERT INTO `lang_definitions` VALUES (1196, 2710, 2, 'Dag');
INSERT INTO `lang_definitions` VALUES (1197, 2711, 2, 'dag');
INSERT INTO `lang_definitions` VALUES (1198, 2714, 2, 'Överblick dag');
INSERT INTO `lang_definitions` VALUES (1199, 2715, 2, 'Dag (ar)');
INSERT INTO `lang_definitions` VALUES (1200, 2716, 2, 'Dag (ar) M-F');
INSERT INTO `lang_definitions` VALUES (1201, 2717, 2, 'dagar');
INSERT INTO `lang_definitions` VALUES (1202, 2718, 2, 'Dagar');
INSERT INTO `lang_definitions` VALUES (1203, 2719, 2, 'dagar sedan');
INSERT INTO `lang_definitions` VALUES (1204, 2720, 2, 'Dagar och spel Missade');
INSERT INTO `lang_definitions` VALUES (1205, 2721, 2, 'Dagar från förra mötet');
INSERT INTO `lang_definitions` VALUES (1206, 2722, 2, 'Missade dagar');
INSERT INTO `lang_definitions` VALUES (1207, 2725, 2, 'Dagar per Kolumn:');
INSERT INTO `lang_definitions` VALUES (1208, 2727, 2, 'dagar/kolumner');
INSERT INTO `lang_definitions` VALUES (1209, 2728, 2, 'DB installerad');
INSERT INTO `lang_definitions` VALUES (1210, 2729, 2, 'DD/MM/ÅÅÅÅ');
INSERT INTO `lang_definitions` VALUES (1211, 2730, 2, 'Avidentifiering');
INSERT INTO `lang_definitions` VALUES (1212, 2731, 2, 'Avidentifiering komplett');
INSERT INTO `lang_definitions` VALUES (1213, 2732, 2, 'Avidentifiering pågår');
INSERT INTO `lang_definitions` VALUES (1214, 2733, 2, 'Avidentifiering påpbörjad och sker i bakgrunden');
INSERT INTO `lang_definitions` VALUES (1215, 2734, 2, 'Avidentifiering kanske inte är komplett');
INSERT INTO `lang_definitions` VALUES (1216, 2735, 2, 'Avidentifierade filer sparas i');
INSERT INTO `lang_definitions` VALUES (1217, 2736, 2, 'Läkemedelsverket (DEA)');
INSERT INTO `lang_definitions` VALUES (1218, 2742, 2, 'Döv');
INSERT INTO `lang_definitions` VALUES (1219, 2746, 2, 'Debuginformation');
INSERT INTO `lang_definitions` VALUES (1220, 2748, 2, 'Debugging');
INSERT INTO `lang_definitions` VALUES (1221, 2749, 2, 'Dec');
INSERT INTO `lang_definitions` VALUES (1222, 2751, 2, 'Avslutad');
INSERT INTO `lang_definitions` VALUES (1223, 2758, 2, 'December');
INSERT INTO `lang_definitions` VALUES (1224, 2762, 2, 'Decimal pound eller pound/ounces delas med # (ex 5#4)');
INSERT INTO `lang_definitions` VALUES (1225, 2764, 2, 'Avdragsgill');
INSERT INTO `lang_definitions` VALUES (1226, 2765, 2, 'Genomförda avdrag');
INSERT INTO `lang_definitions` VALUES (1227, 2767, 2, 'Standard');
INSERT INTO `lang_definitions` VALUES (1228, 2770, 2, 'Standard Kalender vy');
INSERT INTO `lang_definitions` VALUES (1229, 2773, 2, 'Standard Besöksformulär Id');
INSERT INTO `lang_definitions` VALUES (1230, 2776, 2, 'Standard Klinik');
INSERT INTO `lang_definitions` VALUES (1231, 2781, 2, 'Standardspråk');
INSERT INTO `lang_definitions` VALUES (1232, 2782, 2, 'Standardspråk ifall inget annat är tillåtet eller valt');
INSERT INTO `lang_definitions` VALUES (1233, 2785, 2, 'Standardlista');
INSERT INTO `lang_definitions` VALUES (1234, 2787, 2, 'Standardmetod');
INSERT INTO `lang_definitions` VALUES (1235, 2788, 2, 'Standard tid för lösenords giltighet');
INSERT INTO `lang_definitions` VALUES (1236, 2789, 2, 'Standardtid för lösenords giltighetstid. 0 innebär oändlig giltighet.');
INSERT INTO `lang_definitions` VALUES (1237, 2790, 2, 'Standard patient land');
INSERT INTO `lang_definitions` VALUES (1238, 2794, 2, 'Standard prioritet');
INSERT INTO `lang_definitions` VALUES (1239, 2796, 2, 'Standard vårdgivare');
INSERT INTO `lang_definitions` VALUES (1240, 2798, 2, 'Standard range');
INSERT INTO `lang_definitions` VALUES (1241, 2799, 2, 'Standard kontaktorsak');
INSERT INTO `lang_definitions` VALUES (1242, 2804, 2, 'Standard inställningar');
INSERT INTO `lang_definitions` VALUES (1243, 2806, 2, 'Normalt status för \'Nytt fönster\' markering i patientlistan');
INSERT INTO `lang_definitions` VALUES (1244, 2807, 2, 'Standardmall');
INSERT INTO `lang_definitions` VALUES (1245, 2813, 2, 'Standard enhet');
INSERT INTO `lang_definitions` VALUES (1246, 2815, 2, 'Standardvärde');
INSERT INTO `lang_definitions` VALUES (1247, 2818, 2, 'Standard lager');
INSERT INTO `lang_definitions` VALUES (1248, 2819, 2, 'Standard X12 Partner');
INSERT INTO `lang_definitions` VALUES (1249, 2820, 2, 'Default / Global');
INSERT INTO `lang_definitions` VALUES (1250, 2827, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1251, 2828, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1252, 2829, 2, 'Fördröjd Återkommande (> 12 mån)');
INSERT INTO `lang_definitions` VALUES (1253, 2830, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1254, 2831, 2, 'ta bort');
INSERT INTO `lang_definitions` VALUES (1255, 2832, 2, 'Radera Kategorier med ID (s):');
INSERT INTO `lang_definitions` VALUES (1256, 2833, 2, 'Radera katogori');
INSERT INTO `lang_definitions` VALUES (1257, 2836, 2, 'Kunde ej radera!');
INSERT INTO `lang_definitions` VALUES (1258, 2837, 2, 'Ta bort grupp');
INSERT INTO `lang_definitions` VALUES (1259, 2838, 2, 'Ta bort lista');
INSERT INTO `lang_definitions` VALUES (1260, 2842, 2, 'Radera Sidor');
INSERT INTO `lang_definitions` VALUES (1261, 2843, 2, 'Ta bort patient, Möte, Formulär, Ämne, Dokument, Betalning, Fakturering eller transaktionstryck');
INSERT INTO `lang_definitions` VALUES (1262, 2845, 2, 'Ta bort rad');
INSERT INTO `lang_definitions` VALUES (1263, 2846, 2, 'Ta bort markerade enheter');
INSERT INTO `lang_definitions` VALUES (1264, 2849, 2, 'Borttagning OK');
INSERT INTO `lang_definitions` VALUES (1265, 2850, 2, 'Radera detta dokument');
INSERT INTO `lang_definitions` VALUES (1266, 2851, 2, 'Radera detta formulär');
INSERT INTO `lang_definitions` VALUES (1267, 2853, 2, 'Radera denna anteckning');
INSERT INTO `lang_definitions` VALUES (1268, 2855, 2, 'Borttagning OK');
INSERT INTO `lang_definitions` VALUES (1269, 2856, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1270, 2857, 2, 'Borttagen händelse kan inte återskapas. Är du säker på att du vill ta bort händelsen?');
INSERT INTO `lang_definitions` VALUES (1271, 2860, 2, 'Leverans bekräftad');
INSERT INTO `lang_definitions` VALUES (1272, 2863, 2, 'Leverans är inte tillåten till specificerad direkt adress.');
INSERT INTO `lang_definitions` VALUES (1273, 2865, 2, 'Leverans av bifogat kliniskt dokument var begärt av patienten');
INSERT INTO `lang_definitions` VALUES (1274, 2866, 2, 'Demens');
INSERT INTO `lang_definitions` VALUES (1275, 2868, 2, 'Demografi');
INSERT INTO `lang_definitions` VALUES (1276, 2869, 2, 'Demografi');
INSERT INTO `lang_definitions` VALUES (1277, 2873, 2, 'Demografi filter kriterier');
INSERT INTO `lang_definitions` VALUES (1278, 2875, 2, 'Demografi ej auktoriserad');
INSERT INTO `lang_definitions` VALUES (1279, 2876, 2, 'Demografi ej auktoriserad');
INSERT INTO `lang_definitions` VALUES (1280, 2877, 2, 'Nekad');
INSERT INTO `lang_definitions` VALUES (1281, 2879, 2, 'Nämnare');
INSERT INTO `lang_definitions` VALUES (1282, 2882, 2, 'Dental');
INSERT INTO `lang_definitions` VALUES (1283, 2883, 2, 'Tandvård ärende lista');
INSERT INTO `lang_definitions` VALUES (1284, 2884, 2, 'Tandvårds ärenden');
INSERT INTO `lang_definitions` VALUES (1285, 2889, 2, 'Beroende på vilken typ av räkning som testas kommer man kunna se HCFA liknande utskrift på blankt papper om HFCA-räkning testas, flera rader med blurrig text och information ifall X12-claim testas. Denna text är X12 EDI 4010A format. Ibland ser man udda konstiga tecken som liknar små figurer. Detta är kontrolltecken för sidmatning mm och det är helt normalt.');
INSERT INTO `lang_definitions` VALUES (1286, 2891, 2, 'Insättningsdatum');
INSERT INTO `lang_definitions` VALUES (1287, 2892, 2, 'Insättningsdatum kan inte vara senare än idag.');
INSERT INTO `lang_definitions` VALUES (1288, 2893, 2, 'Insättning Datum:');
INSERT INTO `lang_definitions` VALUES (1289, 2894, 2, 'Deprimerad');
INSERT INTO `lang_definitions` VALUES (1290, 2895, 2, 'Depression');
INSERT INTO `lang_definitions` VALUES (1291, 2901, 2, 'Beskrivning');
INSERT INTO `lang_definitions` VALUES (1292, 2902, 2, 'beskrivning');
INSERT INTO `lang_definitions` VALUES (1293, 2905, 2, 'Beskrivning av upptäckten');
INSERT INTO `lang_definitions` VALUES (1294, 2906, 2, 'Beskrivning av åtgärden eller resultatkod');
INSERT INTO `lang_definitions` VALUES (1295, 2907, 2, 'Beskrivning översättning');
INSERT INTO `lang_definitions` VALUES (1296, 2909, 2, 'Mål');
INSERT INTO `lang_definitions` VALUES (1297, 2910, 2, 'Målfilnamn');
INSERT INTO `lang_definitions` VALUES (1298, 2913, 2, 'Förstör Parti');
INSERT INTO `lang_definitions` VALUES (1299, 2914, 2, 'Förstör ...');
INSERT INTO `lang_definitions` VALUES (1300, 2915, 2, 'Förstörd');
INSERT INTO `lang_definitions` VALUES (1301, 2916, 2, 'Förstörda läkemedel');
INSERT INTO `lang_definitions` VALUES (1302, 2917, 2, 'Förstöras narkotika Rapport');
INSERT INTO `lang_definitions` VALUES (1303, 2919, 2, 'Detalj');
INSERT INTO `lang_definitions` VALUES (1304, 2924, 2, 'Detaljer');
INSERT INTO `lang_definitions` VALUES (1305, 2930, 2, 'Utvecklingsstörning');
INSERT INTO `lang_definitions` VALUES (1306, 2933, 2, 'Diabetes');
INSERT INTO `lang_definitions` VALUES (1307, 2934, 2, 'Diabetes Mellitus');
INSERT INTO `lang_definitions` VALUES (1308, 2935, 2, 'Diabetes: Blodtryckskontroll');
INSERT INTO `lang_definitions` VALUES (1309, 2936, 2, 'Diabetes: Ögonundersökning');
INSERT INTO `lang_definitions` VALUES (1310, 2937, 2, 'Diabetes: Ögonundersökning');
INSERT INTO `lang_definitions` VALUES (1311, 2938, 2, 'Diabetes: Fotundersökning');
INSERT INTO `lang_definitions` VALUES (1312, 2939, 2, 'Diabetes: Fotundersökning');
INSERT INTO `lang_definitions` VALUES (1313, 2940, 2, 'Diabetes: HbA1c dåligt reglerat');
INSERT INTO `lang_definitions` VALUES (1314, 2941, 2, 'Diabetes: HbA1c');
INSERT INTO `lang_definitions` VALUES (1315, 2942, 2, 'Diabetes: Blodfetter');
INSERT INTO `lang_definitions` VALUES (1316, 2943, 2, 'Diabetes: Urin microalbumin');
INSERT INTO `lang_definitions` VALUES (1317, 2944, 2, 'Diag');
INSERT INTO `lang_definitions` VALUES (1318, 2945, 2, 'Diagnoser');
INSERT INTO `lang_definitions` VALUES (1319, 2946, 2, 'Diagnos');
INSERT INTO `lang_definitions` VALUES (1320, 2947, 2, 'Diagnoskod');
INSERT INTO `lang_definitions` VALUES (1321, 2950, 2, 'Diagnos datum');
INSERT INTO `lang_definitions` VALUES (1322, 2952, 2, 'Diagnos måste kodas in i ett länkat patientmöte');
INSERT INTO `lang_definitions` VALUES (1323, 2953, 2, 'Diagnos namn');
INSERT INTO `lang_definitions` VALUES (1324, 2954, 2, 'Diagnos rapport');
INSERT INTO `lang_definitions` VALUES (1325, 2955, 2, 'Diagnos rapport');
INSERT INTO `lang_definitions` VALUES (1326, 2956, 2, 'Diagnos rapport enbart');
INSERT INTO `lang_definitions` VALUES (1327, 2957, 2, 'Diagnos titel');
INSERT INTO `lang_definitions` VALUES (1328, 2958, 2, 'Diagnos:');
INSERT INTO `lang_definitions` VALUES (1329, 2959, 2, 'Diagnos:');
INSERT INTO `lang_definitions` VALUES (1330, 2961, 2, 'Diagnostiska tester:');
INSERT INTO `lang_definitions` VALUES (1331, 2963, 2, 'Skala');
INSERT INTO `lang_definitions` VALUES (1332, 2966, 2, 'Membran/kapsel');
INSERT INTO `lang_definitions` VALUES (1333, 2967, 2, 'Diarée');
INSERT INTO `lang_definitions` VALUES (1334, 2970, 2, 'Diktat');
INSERT INTO `lang_definitions` VALUES (1335, 2971, 2, 'Diktat:');
INSERT INTO `lang_definitions` VALUES (1336, 2972, 2, 'Fick du en kopia av denna HIPAA notering?');
INSERT INTO `lang_definitions` VALUES (1337, 2975, 2, 'Diffus');
INSERT INTO `lang_definitions` VALUES (1338, 2976, 2, 'Digitalt signerad');
INSERT INTO `lang_definitions` VALUES (1339, 2986, 2, 'Direkt mail');
INSERT INTO `lang_definitions` VALUES (1340, 2987, 2, 'Log på direktmeddelande');
INSERT INTO `lang_definitions` VALUES (1341, 2988, 2, 'Direkt meddelande mottaget');
INSERT INTO `lang_definitions` VALUES (1342, 2989, 2, 'Direkt meddelande ej tillgängligt');
INSERT INTO `lang_definitions` VALUES (1343, 2990, 2, 'Kunde ej skicka direkt meddelande');
INSERT INTO `lang_definitions` VALUES (1344, 2993, 2, 'Arbetsledare, namn');
INSERT INTO `lang_definitions` VALUES (1345, 2994, 2, 'Kunde ej ta bort mapp. Fortsätt');
INSERT INTO `lang_definitions` VALUES (1346, 2995, 2, 'Funktionshinder');
INSERT INTO `lang_definitions` VALUES (1347, 3000, 2, 'Stäng av kalender');
INSERT INTO `lang_definitions` VALUES (1348, 3001, 2, 'Stäng av spårning av patientkort');
INSERT INTO `lang_definitions` VALUES (1349, 3004, 2, 'Stäng av vaccination');
INSERT INTO `lang_definitions` VALUES (1350, 3006, 2, 'Stäng av gammal metrisk vitala tecken formulär');
INSERT INTO `lang_definitions` VALUES (1351, 3009, 2, 'Stäng av phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (1352, 3010, 2, 'Stäng av receptförskrivning');
INSERT INTO `lang_definitions` VALUES (1353, 3012, 2, 'Stäng av användargrupp');
INSERT INTO `lang_definitions` VALUES (1354, 3013, 2, 'funktionshindrade');
INSERT INTO `lang_definitions` VALUES (1355, 3014, 2, 'Funktionshindrade');
INSERT INTO `lang_definitions` VALUES (1356, 3015, 2, 'Handikappad under 65 år med LGHP-försäkring');
INSERT INTO `lang_definitions` VALUES (1357, 3020, 2, 'Disk');
INSERT INTO `lang_definitions` VALUES (1358, 3023, 2, 'Utskrivning');
INSERT INTO `lang_definitions` VALUES (1359, 3025, 2, 'Flytningar från urinröret');
INSERT INTO `lang_definitions` VALUES (1360, 3027, 2, 'Rätt utskriven');
INSERT INTO `lang_definitions` VALUES (1361, 3028, 2, 'Rätt utskriven');
INSERT INTO `lang_definitions` VALUES (1362, 3032, 2, 'Utskriven');
INSERT INTO `lang_definitions` VALUES (1363, 3034, 2, 'Kvitto information');
INSERT INTO `lang_definitions` VALUES (1364, 3035, 2, 'Kvitto typ');
INSERT INTO `lang_definitions` VALUES (1365, 3036, 2, 'Kvitton typer');
INSERT INTO `lang_definitions` VALUES (1366, 3037, 2, 'Kvitton');
INSERT INTO `lang_definitions` VALUES (1367, 3042, 2, 'Rabatt');
INSERT INTO `lang_definitions` VALUES (1368, 3043, 2, 'Rabatt Belopp');
INSERT INTO `lang_definitions` VALUES (1369, 3044, 2, 'Rabatt nivå');
INSERT INTO `lang_definitions` VALUES (1370, 3045, 2, 'Rabatt procent');
INSERT INTO `lang_definitions` VALUES (1371, 3047, 2, 'Rabatt som belopp');
INSERT INTO `lang_definitions` VALUES (1372, 3048, 2, 'Rabatt vid checkout skrivs in som belopp i stället för som procent');
INSERT INTO `lang_definitions` VALUES (1373, 3050, 2, 'Diskreta resultat');
INSERT INTO `lang_definitions` VALUES (1374, 3052, 2, 'Sjukdom');
INSERT INTO `lang_definitions` VALUES (1375, 3055, 2, 'Förskjutning');
INSERT INTO `lang_definitions` VALUES (1376, 3059, 2, 'Antal:');
INSERT INTO `lang_definitions` VALUES (1377, 3060, 2, 'Skicka i väg');
INSERT INTO `lang_definitions` VALUES (1378, 3061, 2, 'Skicka mottagna dokument');
INSERT INTO `lang_definitions` VALUES (1379, 3065, 2, 'Utlämnad');
INSERT INTO `lang_definitions` VALUES (1380, 3068, 2, 'Visa avancerade inställningar på demografisidan');
INSERT INTO `lang_definitions` VALUES (1381, 3071, 2, 'Visa händelsedatum i blocket?');
INSERT INTO `lang_definitions` VALUES (1382, 3072, 2, 'Visa format får US vikter?');
INSERT INTO `lang_definitions` VALUES (1383, 3073, 2, 'Visa hur många händelser?');
INSERT INTO `lang_definitions` VALUES (1384, 3078, 2, 'Visa plats i blocket?');
INSERT INTO `lang_definitions` VALUES (1385, 3080, 2, 'Visa namn');
INSERT INTO `lang_definitions` VALUES (1386, 3083, 2, 'Visa kalender?');
INSERT INTO `lang_definitions` VALUES (1387, 3092, 2, 'Display dagens händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1388, 3093, 2, 'Visa ämne i blocket?');
INSERT INTO `lang_definitions` VALUES (1389, 3094, 2, 'Visa kommande händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1390, 3096, 2, 'Visa kommande händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1391, 3097, 2, 'Visa följande antal av de senaste meddelandena.');
INSERT INTO `lang_definitions` VALUES (1392, 3099, 2, 'Visa följande antal av senaste noteringarna');
INSERT INTO `lang_definitions` VALUES (1393, 3100, 2, 'Visa följande antal av de senaste noteringarna');
INSERT INTO `lang_definitions` VALUES (1394, 3107, 2, 'Distrubition');
INSERT INTO `lang_definitions` VALUES (1395, 3108, 2, 'Distribution');
INSERT INTO `lang_definitions` VALUES (1396, 3109, 2, 'Leverantör');
INSERT INTO `lang_definitions` VALUES (1397, 3114, 2, 'Divertikulit');
INSERT INTO `lang_definitions` VALUES (1398, 3115, 2, 'Divertikulit kirurgi');
INSERT INTO `lang_definitions` VALUES (1399, 3116, 2, 'Divertikulit');
INSERT INTO `lang_definitions` VALUES (1400, 3117, 2, 'Divertikulit Kirurgi');
INSERT INTO `lang_definitions` VALUES (1401, 3118, 2, 'Skild');
INSERT INTO `lang_definitions` VALUES (1402, 3119, 2, 'Yrsel:');
INSERT INTO `lang_definitions` VALUES (1403, 3122, 2, 'Ändra inte');
INSERT INTO `lang_definitions` VALUES (1404, 3124, 2, 'Visa inte Allergi uppladdad till NewCrop');
INSERT INTO `lang_definitions` VALUES (1405, 3126, 2, 'Visa inte medicinering uppladdad till NewCrop');
INSERT INTO `lang_definitions` VALUES (1406, 3129, 2, 'Visa inte kalender');
INSERT INTO `lang_definitions` VALUES (1407, 3133, 2, 'Lagra och sälj inga produkter');
INSERT INTO `lang_definitions` VALUES (1408, 3136, 2, 'Kräv inte att patientanteckningar blir godkända');
INSERT INTO `lang_definitions` VALUES (1409, 3137, 2, 'Inte HLR beslut');
INSERT INTO `lang_definitions` VALUES (1410, 3138, 2, 'spara inte');
INSERT INTO `lang_definitions` VALUES (1411, 3139, 2, 'ersätt inte');
INSERT INTO `lang_definitions` VALUES (1412, 3142, 2, 'gör ingenting');
INSERT INTO `lang_definitions` VALUES (1413, 3147, 2, 'Vill du verkligen radera?');
INSERT INTO `lang_definitions` VALUES (1414, 3148, 2, 'Vill du verkligen radera detta urval?');
INSERT INTO `lang_definitions` VALUES (1415, 3149, 2, 'Vill du verkligen ta bort den här gruppen');
INSERT INTO `lang_definitions` VALUES (1416, 3153, 2, 'Vill du fortsätta?');
INSERT INTO `lang_definitions` VALUES (1417, 3154, 2, 'Vill du ta bort detta?');
INSERT INTO `lang_definitions` VALUES (1418, 3155, 2, 'Vill du ta bort?');
INSERT INTO `lang_definitions` VALUES (1419, 3156, 2, 'Vill du ta bort denna post?');
INSERT INTO `lang_definitions` VALUES (1420, 3157, 2, 'Vill du fortsätta att lägga till den nya patienten?');
INSERT INTO `lang_definitions` VALUES (1421, 3158, 2, 'Vill du fortsätta med det nya namnet?');
INSERT INTO `lang_definitions` VALUES (1422, 3159, 2, 'Vill du PERMANENT ta bort vaccinationsregistreringen?');
INSERT INTO `lang_definitions` VALUES (1423, 3160, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1424, 3162, 2, 'Födelsedatum saknas, ange om möjligt');
INSERT INTO `lang_definitions` VALUES (1425, 3164, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1426, 3165, 2, 'Läkare');
INSERT INTO `lang_definitions` VALUES (1427, 3166, 2, 'Läkare:');
INSERT INTO `lang_definitions` VALUES (1428, 3167, 2, 'Läkares namn och underskrift');
INSERT INTO `lang_definitions` VALUES (1429, 3168, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1430, 3169, 2, 'dokument');
INSERT INTO `lang_definitions` VALUES (1431, 3171, 2, 'Dokument Kategorier');
INSERT INTO `lang_definitions` VALUES (1432, 3178, 2, 'Dokument kan inte flyttas till patienten id');
INSERT INTO `lang_definitions` VALUES (1433, 3180, 2, 'Dokument Datum');
INSERT INTO `lang_definitions` VALUES (1434, 3181, 2, 'Dokumentets datum och utförande uppdaterats');
INSERT INTO `lang_definitions` VALUES (1435, 3182, 2, 'Dokument id');
INSERT INTO `lang_definitions` VALUES (1436, 3185, 2, 'Dokument är flyttat till ny kategori');
INSERT INTO `lang_definitions` VALUES (1437, 3186, 2, 'Dokument är flyttat till patienten id');
INSERT INTO `lang_definitions` VALUES (1438, 3188, 2, 'Dokument kontrollerat');
INSERT INTO `lang_definitions` VALUES (1439, 3189, 2, 'Sätt att lagra dokument');
INSERT INTO `lang_definitions` VALUES (1440, 3190, 2, 'Namnbyte av dokument lyckats');
INSERT INTO `lang_definitions` VALUES (1441, 3196, 2, 'Dokument/avbildning lagrad');
INSERT INTO `lang_definitions` VALUES (1442, 3198, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1443, 3200, 2, 'Dokument (skriva, tilllägg frivilligt)');
INSERT INTO `lang_definitions` VALUES (1444, 3209, 2, 'Inskrivningsdatum');
INSERT INTO `lang_definitions` VALUES (1445, 3214, 2, 'stämmer inte med PV1 besöksnummer');
INSERT INTO `lang_definitions` VALUES (1446, 3215, 2, 'Verkar inte giltig');
INSERT INTO `lang_definitions` VALUES (1447, 3216, 2, 'Tillåter denna typ relaterade koder?');
INSERT INTO `lang_definitions` VALUES (1448, 3217, 2, 'Sambo');
INSERT INTO `lang_definitions` VALUES (1449, 3218, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1450, 3219, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1451, 3220, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1452, 3223, 2, 'Klart');
INSERT INTO `lang_definitions` VALUES (1453, 3225, 2, 'Klar med:');
INSERT INTO `lang_definitions` VALUES (1454, 3226, 2, 'Klar. Skickas för nedladdning');
INSERT INTO `lang_definitions` VALUES (1455, 3227, 2, 'Datum för tjänsten');
INSERT INTO `lang_definitions` VALUES (1456, 3228, 2, 'Dosering');
INSERT INTO `lang_definitions` VALUES (1457, 3232, 2, 'dubbelklicka för att redigera');
INSERT INTO `lang_definitions` VALUES (1458, 3234, 2, 'Dubbelseende');
INSERT INTO `lang_definitions` VALUES (1459, 3235, 2, 'Ladda ner');
INSERT INTO `lang_definitions` VALUES (1460, 3241, 2, 'Ladda ner ändå');
INSERT INTO `lang_definitions` VALUES (1461, 3242, 2, 'Ladda ner faktura fil, bokför och markera som skickad.');
INSERT INTO `lang_definitions` VALUES (1462, 3245, 2, 'Ladda ner certifikat');
INSERT INTO `lang_definitions` VALUES (1463, 3247, 2, 'Ladda ner configurationsdata');
INSERT INTO `lang_definitions` VALUES (1464, 3252, 2, 'ladda ner krypterad fil');
INSERT INTO `lang_definitions` VALUES (1465, 3260, 2, 'Ladda ner PDF');
INSERT INTO `lang_definitions` VALUES (1466, 3264, 2, 'Ladda ner utvald redogörelse');
INSERT INTO `lang_definitions` VALUES (1467, 3267, 2, 'Läkarkontroll');
INSERT INTO `lang_definitions` VALUES (1468, 3268, 2, 'Läkarbesök');
INSERT INTO `lang_definitions` VALUES (1469, 3269, 2, 'Dr.');
INSERT INTO `lang_definitions` VALUES (1470, 3273, 2, 'Drag för att flytta');
INSERT INTO `lang_definitions` VALUES (1471, 3275, 2, 'Dribblande');
INSERT INTO `lang_definitions` VALUES (1472, 3276, 2, 'Körkortsnr');
INSERT INTO `lang_definitions` VALUES (1473, 3278, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (1474, 3281, 2, 'Leta läkemedel');
INSERT INTO `lang_definitions` VALUES (1475, 3282, 2, 'Läkemedelsformulär');
INSERT INTO `lang_definitions` VALUES (1476, 3283, 2, 'Läkemeddels ID saknas!');
INSERT INTO `lang_definitions` VALUES (1477, 3284, 2, 'Läkemedel intervall');
INSERT INTO `lang_definitions` VALUES (1478, 3285, 2, 'Inventarielista, läkemedel');
INSERT INTO `lang_definitions` VALUES (1479, 3287, 2, 'Läkemedelsnamn');
INSERT INTO `lang_definitions` VALUES (1480, 3289, 2, 'Läkemedel administrationssätt');
INSERT INTO `lang_definitions` VALUES (1481, 3294, 2, 'Läkemedel, enheter');
INSERT INTO `lang_definitions` VALUES (1482, 3300, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (1483, 3301, 2, 'Läkemedel och produkter');
INSERT INTO `lang_definitions` VALUES (1484, 3302, 2, 'Muntorrhet');
INSERT INTO `lang_definitions` VALUES (1485, 3303, 2, 'DSM-4 Diagnos');
INSERT INTO `lang_definitions` VALUES (1486, 3304, 2, 'DT 1');
INSERT INTO `lang_definitions` VALUES (1487, 3305, 2, 'DT 2');
INSERT INTO `lang_definitions` VALUES (1488, 3306, 2, 'DT 3');
INSERT INTO `lang_definitions` VALUES (1489, 3307, 2, 'DT 4');
INSERT INTO `lang_definitions` VALUES (1490, 3308, 2, 'DT 5');
INSERT INTO `lang_definitions` VALUES (1491, 3309, 2, 'DTaP 1');
INSERT INTO `lang_definitions` VALUES (1492, 3310, 2, 'DTaP 2');
INSERT INTO `lang_definitions` VALUES (1493, 3311, 2, 'DTaP 3');
INSERT INTO `lang_definitions` VALUES (1494, 3312, 2, 'DTaP 4');
INSERT INTO `lang_definitions` VALUES (1495, 3313, 2, 'DTaP 5');
INSERT INTO `lang_definitions` VALUES (1496, 3315, 2, 'Förfaller');
INSERT INTO `lang_definitions` VALUES (1497, 3316, 2, 'Förfallodatum');
INSERT INTO `lang_definitions` VALUES (1498, 3318, 2, 'Förfallodatum mm / dd / yyyy eller åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1499, 3319, 2, 'Förfallodatum:');
INSERT INTO `lang_definitions` VALUES (1500, 3321, 2, 'Förfaller patienter');
INSERT INTO `lang_definitions` VALUES (1501, 3322, 2, 'Förfaller snart');
INSERT INTO `lang_definitions` VALUES (1502, 3323, 2, 'Förfallostatus');
INSERT INTO `lang_definitions` VALUES (1503, 3324, 2, 'Uppdatera förfallostatus');
INSERT INTO `lang_definitions` VALUES (1504, 3325, 2, 'Dumping OpenEMR database');
INSERT INTO `lang_definitions` VALUES (1505, 3326, 2, 'Dumping OpenEMR web directory tree');
INSERT INTO `lang_definitions` VALUES (1506, 3327, 2, 'Dumping phpGACL database');
INSERT INTO `lang_definitions` VALUES (1507, 3328, 2, 'Dumping phpGACL web directory tree');
INSERT INTO `lang_definitions` VALUES (1508, 3329, 2, 'Dumping SQL-Ledger database');
INSERT INTO `lang_definitions` VALUES (1509, 3330, 2, 'Dumping SQL-Ledger web directory tree');
INSERT INTO `lang_definitions` VALUES (1510, 3331, 2, 'Dubletter kontroll');
INSERT INTO `lang_definitions` VALUES (1511, 3338, 2, 'Dubletter av ID');
INSERT INTO `lang_definitions` VALUES (1512, 3339, 2, 'Dubletter av namn');
INSERT INTO `lang_definitions` VALUES (1513, 3340, 2, 'DUBLETTER VARNING');
INSERT INTO `lang_definitions` VALUES (1514, 3341, 2, 'Varaktig fullmakt');
INSERT INTO `lang_definitions` VALUES (1515, 3342, 2, 'Varaktighet');
INSERT INTO `lang_definitions` VALUES (1516, 3343, 2, 'varaktighet');
INSERT INTO `lang_definitions` VALUES (1517, 3345, 2, 'Holländsk');
INSERT INTO `lang_definitions` VALUES (1518, 3348, 2, 'Dysfagi');
INSERT INTO `lang_definitions` VALUES (1519, 3349, 2, 'Dyspné:');
INSERT INTO `lang_definitions` VALUES (1520, 3350, 2, 'Urinvägsbesvär');
INSERT INTO `lang_definitions` VALUES (1521, 3359, 2, 'E-recept?');
INSERT INTO `lang_definitions` VALUES (1522, 3360, 2, 'E-rapport');
INSERT INTO `lang_definitions` VALUES (1523, 3361, 2, 'E-recept?');
INSERT INTO `lang_definitions` VALUES (1524, 3363, 2, 'Förnya E-recept');
INSERT INTO `lang_definitions` VALUES (1525, 3367, 2, 'Varje mottagare måste själv ange att meddelanden är avslutade');
INSERT INTO `lang_definitions` VALUES (1526, 3373, 2, 'Tidig Återkommande (<2 Mo)');
INSERT INTO `lang_definitions` VALUES (1527, 3374, 2, 'Öron');
INSERT INTO `lang_definitions` VALUES (1528, 3381, 2, 'EKG');
INSERT INTO `lang_definitions` VALUES (1529, 3382, 2, 'Elektronisk begäran');
INSERT INTO `lang_definitions` VALUES (1530, 3385, 2, 'Ödem');
INSERT INTO `lang_definitions` VALUES (1531, 3392, 2, 'Redigera');
INSERT INTO `lang_definitions` VALUES (1532, 3394, 2, 'Redigera allergier');
INSERT INTO `lang_definitions` VALUES (1533, 3396, 2, 'Edit Kategorier');
INSERT INTO `lang_definitions` VALUES (1534, 3399, 2, 'Redigera definitioner');
INSERT INTO `lang_definitions` VALUES (1535, 3400, 2, 'Redigera diagnoser för');
INSERT INTO `lang_definitions` VALUES (1536, 3406, 2, 'Redigera Kliniker');
INSERT INTO `lang_definitions` VALUES (1537, 3408, 2, 'Redigera Klinikinformation');
INSERT INTO `lang_definitions` VALUES (1538, 3411, 2, 'Redigera form');
INSERT INTO `lang_definitions` VALUES (1539, 3416, 2, 'Redigera layout');
INSERT INTO `lang_definitions` VALUES (1540, 3418, 2, 'Redigera lista');
INSERT INTO `lang_definitions` VALUES (1541, 3424, 2, 'Redigera Struktur');
INSERT INTO `lang_definitions` VALUES (1542, 3432, 2, 'Utbildning');
INSERT INTO `lang_definitions` VALUES (1543, 3433, 2, 'Information');
INSERT INTO `lang_definitions` VALUES (1544, 3436, 2, 'Ikraftträdandedatum');
INSERT INTO `lang_definitions` VALUES (1545, 3438, 2, 'Effektivitet');
INSERT INTO `lang_definitions` VALUES (1546, 3443, 2, 'Ejaculation');
INSERT INTO `lang_definitions` VALUES (1547, 3444, 2, 'Armbåge');
INSERT INTO `lang_definitions` VALUES (1548, 3445, 2, 'Problem med armbågen');
INSERT INTO `lang_definitions` VALUES (1549, 3450, 2, 'Elektronisk remiss');
INSERT INTO `lang_definitions` VALUES (1550, 3461, 2, 'Email');
INSERT INTO `lang_definitions` VALUES (1551, 3472, 2, 'E-post från Batchcom');
INSERT INTO `lang_definitions` VALUES (1552, 3474, 2, 'E-postmeddelande');
INSERT INTO `lang_definitions` VALUES (1553, 3480, 2, 'E-post skicka innan');
INSERT INTO `lang_definitions` VALUES (1554, 3481, 2, 'Email, skicka');
INSERT INTO `lang_definitions` VALUES (1555, 3484, 2, 'Epost Ämnesord');
INSERT INTO `lang_definitions` VALUES (1556, 3487, 2, 'Email Text, användbara Tag: *** NAMN ***, dvs Bäste *** NAMN ***');
INSERT INTO `lang_definitions` VALUES (1557, 3495, 2, 'ICE Kontakt');
INSERT INTO `lang_definitions` VALUES (1558, 3496, 2, 'ICE kontaktperson');
INSERT INTO `lang_definitions` VALUES (1559, 3497, 2, 'ICE kontakt telefonnummer');
INSERT INTO `lang_definitions` VALUES (1560, 3498, 2, 'Akut Preventivmedel');
INSERT INTO `lang_definitions` VALUES (1561, 3504, 2, 'ICE Telefon');
INSERT INTO `lang_definitions` VALUES (1562, 3507, 2, 'Emfysem');
INSERT INTO `lang_definitions` VALUES (1563, 3508, 2, 'Anställd');
INSERT INTO `lang_definitions` VALUES (1564, 3509, 2, 'Arbetsgivare');
INSERT INTO `lang_definitions` VALUES (1565, 3510, 2, 'Arbetsgivarens adress');
INSERT INTO `lang_definitions` VALUES (1566, 3511, 2, 'Arbetsgivare Data');
INSERT INTO `lang_definitions` VALUES (1567, 3512, 2, 'Arbetsgivarens namn');
INSERT INTO `lang_definitions` VALUES (1568, 3514, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1569, 3520, 2, 'Ta bort värdet i \"E-tider\"');
INSERT INTO `lang_definitions` VALUES (1570, 3521, 2, 'Ta bort värde \"Email, skicka\"');
INSERT INTO `lang_definitions` VALUES (1571, 3522, 2, 'Ta bort värde i \"Email, ämne\"');
INSERT INTO `lang_definitions` VALUES (1572, 3523, 2, 'Ta bort i \"text\"');
INSERT INTO `lang_definitions` VALUES (1573, 3524, 2, 'Ta bort i \"Försörjarens namn\"');
INSERT INTO `lang_definitions` VALUES (1574, 3525, 2, 'Ta bort i \"Lösenord\"');
INSERT INTO `lang_definitions` VALUES (1575, 3526, 2, 'Ta bort \"SMS tider\"');
INSERT INTO `lang_definitions` VALUES (1576, 3527, 2, 'Ta bort \"SMS text\"');
INSERT INTO `lang_definitions` VALUES (1577, 3528, 2, 'Ta bort värdet i \"Användarnamn\"');
INSERT INTO `lang_definitions` VALUES (1578, 3651, 2, 'aktiverat');
INSERT INTO `lang_definitions` VALUES (1579, 3662, 2, 'Möte');
INSERT INTO `lang_definitions` VALUES (1580, 3665, 2, 'Patientmöte');
INSERT INTO `lang_definitions` VALUES (1581, 3666, 2, 'patientmöte');
INSERT INTO `lang_definitions` VALUES (1582, 3667, 2, 'Patientmöter');
INSERT INTO `lang_definitions` VALUES (1583, 3679, 2, 'Patientmöte formulär');
INSERT INTO `lang_definitions` VALUES (1584, 3686, 2, 'Patientmöte antal/nummer');
INSERT INTO `lang_definitions` VALUES (1585, 3708, 2, 'Patientmöte har kodats');
INSERT INTO `lang_definitions` VALUES (1586, 3709, 2, 'Patientmöte:');
INSERT INTO `lang_definitions` VALUES (1587, 3711, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (1588, 3712, 2, 'Patientmöte & Formulär');
INSERT INTO `lang_definitions` VALUES (1589, 3713, 2, 'Patientmöte & Formulär');
INSERT INTO `lang_definitions` VALUES (1590, 3714, 2, 'Encounters inte godkända');
INSERT INTO `lang_definitions` VALUES (1591, 3715, 2, 'Patientmöte, rapport');
INSERT INTO `lang_definitions` VALUES (1592, 3716, 2, 'Patientmöte, avsnitt');
INSERT INTO `lang_definitions` VALUES (1593, 3721, 2, 'Slut');
INSERT INTO `lang_definitions` VALUES (1594, 3722, 2, 'Slutar (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (1595, 3723, 2, 'Slutdatum');
INSERT INTO `lang_definitions` VALUES (1596, 3724, 2, 'Slutdatum');
INSERT INTO `lang_definitions` VALUES (1597, 3732, 2, 'Slutdatum:');
INSERT INTO `lang_definitions` VALUES (1598, 3737, 2, 'Sluttid');
INSERT INTO `lang_definitions` VALUES (1599, 3743, 2, 'Tjänsten slutar åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1600, 3747, 2, 'Endokrina');
INSERT INTO `lang_definitions` VALUES (1601, 3748, 2, 'Endoskopi');
INSERT INTO `lang_definitions` VALUES (1602, 3753, 2, 'Engelsk');
INSERT INTO `lang_definitions` VALUES (1603, 3754, 2, 'Engelsk');
INSERT INTO `lang_definitions` VALUES (1604, 3756, 2, 'Engelsk (indien)');
INSERT INTO `lang_definitions` VALUES (1605, 3757, 2, 'Engelsk (standard)');
INSERT INTO `lang_definitions` VALUES (1606, 3761, 2, 'ENT Ansvarsfrihet');
INSERT INTO `lang_definitions` VALUES (1607, 3762, 2, 'ENT Smärta');
INSERT INTO `lang_definitions` VALUES (1608, 3765, 2, 'Skriv en diagnos kod för att utesluta alla fakturor som inte innehåller det');
INSERT INTO `lang_definitions` VALUES (1609, 3839, 2, 'Ange dina sökkriterier ovan');
INSERT INTO `lang_definitions` VALUES (1610, 3852, 2, 'Miljöpåverkan');
INSERT INTO `lang_definitions` VALUES (1611, 3853, 2, 'EOB Data tillträde');
INSERT INTO `lang_definitions` VALUES (1612, 3858, 2, 'EOB Boknings - Instruktioner');
INSERT INTO `lang_definitions` VALUES (1613, 3859, 2, 'EOB Boknings - Faktura');
INSERT INTO `lang_definitions` VALUES (1614, 3860, 2, 'EOB Boknings - Patient Anmärkning');
INSERT INTO `lang_definitions` VALUES (1615, 3861, 2, 'EOB Boknings - Sök');
INSERT INTO `lang_definitions` VALUES (1616, 3863, 2, 'Epilepsi');
INSERT INTO `lang_definitions` VALUES (1617, 3873, 2, 'Radera');
INSERT INTO `lang_definitions` VALUES (1618, 3875, 2, 'Erektion');
INSERT INTO `lang_definitions` VALUES (1619, 3876, 2, 'Fel');
INSERT INTO `lang_definitions` VALUES (1620, 3883, 2, 'Fel i \"kön\" val');
INSERT INTO `lang_definitions` VALUES (1621, 3884, 2, 'Fel i \"HIPAA\" val');
INSERT INTO `lang_definitions` VALUES (1622, 3885, 2, 'Fel i \"Process\" val');
INSERT INTO `lang_definitions` VALUES (1623, 3886, 2, 'Fel i \"SMS Gateway\" val');
INSERT INTO `lang_definitions` VALUES (1624, 3887, 2, 'Fel i \"Sortera efter\" val');
INSERT INTO `lang_definitions` VALUES (1625, 3889, 2, 'Fel i JA eller NEJ alternativ');
INSERT INTO `lang_definitions` VALUES (1626, 3904, 2, 'fel under registrering!');
INSERT INTO `lang_definitions` VALUES (1627, 3905, 2, 'Fel vid sparande av fil');
INSERT INTO `lang_definitions` VALUES (1628, 3907, 2, 'Fel vid skrivning till fil');
INSERT INTO `lang_definitions` VALUES (1629, 3918, 2, 'FEL, kunde inte samla in data från servern');
INSERT INTO `lang_definitions` VALUES (1630, 3934, 2, 'FEL: kunde inte öppna table.sql bruten form?');
INSERT INTO `lang_definitions` VALUES (1631, 3942, 2, 'Fel: lösenord matchar inte. Kontrollera din stavning.');
INSERT INTO `lang_definitions` VALUES (1632, 3952, 2, 'Fel');
INSERT INTO `lang_definitions` VALUES (1633, 3960, 2, 'Erythema:');
INSERT INTO `lang_definitions` VALUES (1634, 3969, 2, 'Redan känd patient');
INSERT INTO `lang_definitions` VALUES (1635, 3971, 2, 'Modersmål/tolkspråk');
INSERT INTO `lang_definitions` VALUES (1636, 3972, 2, 'Modersmål/tolkspråk');
INSERT INTO `lang_definitions` VALUES (1637, 3973, 2, 'Modersmål/tolkspråk Lista');
INSERT INTO `lang_definitions` VALUES (1638, 3976, 2, 'ETIN');
INSERT INTO `lang_definitions` VALUES (1639, 3979, 2, 'Händelse');
INSERT INTO `lang_definitions` VALUES (1640, 3981, 2, 'Händelse Begins');
INSERT INTO `lang_definitions` VALUES (1641, 3982, 2, 'Händelse Kategori');
INSERT INTO `lang_definitions` VALUES (1642, 3983, 2, 'Händelse Datum');
INSERT INTO `lang_definitions` VALUES (1643, 3985, 2, 'Händelse, Beskrivning');
INSERT INTO `lang_definitions` VALUES (1644, 3986, 2, 'Händelse, detaljer');
INSERT INTO `lang_definitions` VALUES (1645, 3987, 2, 'Händelsen upprepas ej');
INSERT INTO `lang_definitions` VALUES (1646, 3988, 2, 'Händelse, Varaktighet');
INSERT INTO `lang_definitions` VALUES (1647, 3989, 2, 'Händelsens tid i minuter');
INSERT INTO `lang_definitions` VALUES (1648, 3990, 2, 'Händelse, Avgift');
INSERT INTO `lang_definitions` VALUES (1649, 3991, 2, 'Event Location');
INSERT INTO `lang_definitions` VALUES (1650, 3992, 2, 'Händelsen upprepas varje');
INSERT INTO `lang_definitions` VALUES (1651, 3993, 2, 'Händelsen upprepas den');
INSERT INTO `lang_definitions` VALUES (1652, 3994, 2, 'Händelse börjar timme');
INSERT INTO `lang_definitions` VALUES (1653, 3995, 2, 'Händelserubrik');
INSERT INTO `lang_definitions` VALUES (1654, 3996, 2, 'Händelserubrik');
INSERT INTO `lang_definitions` VALUES (1655, 3997, 2, 'Händelse Website');
INSERT INTO `lang_definitions` VALUES (1656, 3998, 2, 'Händelse');
INSERT INTO `lang_definitions` VALUES (1657, 3999, 2, 'Händelser för');
INSERT INTO `lang_definitions` VALUES (1658, 4000, 2, 'Händelsen öppnas i nytt fönster');
INSERT INTO `lang_definitions` VALUES (1659, 4003, 2, 'Varje');
INSERT INTO `lang_definitions` VALUES (1660, 4004, 2, 'Varje');
INSERT INTO `lang_definitions` VALUES (1661, 4006, 2, 'var 3:e timme');
INSERT INTO `lang_definitions` VALUES (1662, 4008, 2, 'var 4:e timme');
INSERT INTO `lang_definitions` VALUES (1663, 4010, 2, 'var 5:e timme');
INSERT INTO `lang_definitions` VALUES (1664, 4012, 2, 'var 6 timme');
INSERT INTO `lang_definitions` VALUES (1665, 4014, 2, 'var 8 timme');
INSERT INTO `lang_definitions` VALUES (1666, 4015, 2, 'Var fjärde');
INSERT INTO `lang_definitions` VALUES (1667, 4017, 2, 'Varannan');
INSERT INTO `lang_definitions` VALUES (1668, 4018, 2, 'Var tredje');
INSERT INTO `lang_definitions` VALUES (1669, 4019, 2, 'Varje, var andra, var 3:e, etc');
INSERT INTO `lang_definitions` VALUES (1670, 4021, 2, 'Tenta och testresultat');
INSERT INTO `lang_definitions` VALUES (1671, 4023, 2, 'Testresultat');
INSERT INTO `lang_definitions` VALUES (1672, 4027, 2, 'Examination Datum');
INSERT INTO `lang_definitions` VALUES (1673, 4033, 2, 'Exams / Tester');
INSERT INTO `lang_definitions` VALUES (1674, 4036, 2, 'Överdrivet rivande');
INSERT INTO `lang_definitions` VALUES (1675, 4046, 2, 'Motions mönster');
INSERT INTO `lang_definitions` VALUES (1676, 4047, 2, 'Övningsmönster');
INSERT INTO `lang_definitions` VALUES (1677, 4052, 2, 'lämna från Administration');
INSERT INTO `lang_definitions` VALUES (1678, 4066, 2, 'Utökad vy');
INSERT INTO `lang_definitions` VALUES (1679, 4067, 2, 'Förväntad form_mötes.pid att');
INSERT INTO `lang_definitions` VALUES (1680, 4068, 2, 'Utgångsdatum');
INSERT INTO `lang_definitions` VALUES (1681, 4069, 2, 'Utgångsdatum');
INSERT INTO `lang_definitions` VALUES (1682, 4071, 2, 'Förfaller');
INSERT INTO `lang_definitions` VALUES (1683, 4074, 2, 'Exportera');
INSERT INTO `lang_definitions` VALUES (1684, 4075, 2, 'Exportera som CSV');
INSERT INTO `lang_definitions` VALUES (1685, 4088, 2, 'Exportera till CSV');
INSERT INTO `lang_definitions` VALUES (1686, 4089, 2, 'Exportera till externa faktureringssystem');
INSERT INTO `lang_definitions` VALUES (1687, 4091, 2, 'Exponering för andra länder');
INSERT INTO `lang_definitions` VALUES (1688, 4112, 2, 'Extern remiss');
INSERT INTO `lang_definitions` VALUES (1689, 4114, 2, 'Extern remiss?');
INSERT INTO `lang_definitions` VALUES (1690, 4115, 2, 'Externa remisser');
INSERT INTO `lang_definitions` VALUES (1691, 4145, 2, 'F');
INSERT INTO `lang_definitions` VALUES (1692, 4148, 2, 'Kliniker');
INSERT INTO `lang_definitions` VALUES (1693, 4149, 2, 'Klinik');
INSERT INTO `lang_definitions` VALUES (1694, 4150, 2, 'klinik');
INSERT INTO `lang_definitions` VALUES (1695, 4151, 2, 'Klinikadm');
INSERT INTO `lang_definitions` VALUES (1696, 4154, 2, 'Klinikkod');
INSERT INTO `lang_definitions` VALUES (1697, 4163, 2, 'Klinik NPI');
INSERT INTO `lang_definitions` VALUES (1698, 4173, 2, 'Klinik:');
INSERT INTO `lang_definitions` VALUES (1699, 4175, 2, 'Misslyckades');
INSERT INTO `lang_definitions` VALUES (1700, 4201, 2, 'Familjehistoria');
INSERT INTO `lang_definitions` VALUES (1701, 4204, 2, 'Familjehistoria:');
INSERT INTO `lang_definitions` VALUES (1702, 4207, 2, 'Familj Storlek');
INSERT INTO `lang_definitions` VALUES (1703, 4213, 2, 'Fader');
INSERT INTO `lang_definitions` VALUES (1704, 4216, 2, 'Fatigue');
INSERT INTO `lang_definitions` VALUES (1705, 4218, 2, 'Fax');
INSERT INTO `lang_definitions` VALUES (1706, 4223, 2, 'Fax in');
INSERT INTO `lang_definitions` VALUES (1707, 4224, 2, 'Fax ut');
INSERT INTO `lang_definitions` VALUES (1708, 4228, 2, 'Februari');
INSERT INTO `lang_definitions` VALUES (1709, 4230, 2, 'Läkemedel ID');
INSERT INTO `lang_definitions` VALUES (1710, 4232, 2, 'Skatt ID');
INSERT INTO `lang_definitions` VALUES (1711, 4234, 2, 'Avgift');
INSERT INTO `lang_definitions` VALUES (1712, 4235, 2, 'avgift');
INSERT INTO `lang_definitions` VALUES (1713, 4237, 2, 'Avgift blankett');
INSERT INTO `lang_definitions` VALUES (1714, 4246, 2, 'Avgifter');
INSERT INTO `lang_definitions` VALUES (1715, 4247, 2, 'Kvinna');
INSERT INTO `lang_definitions` VALUES (1716, 4249, 2, 'Kvinnliga Kondomer');
INSERT INTO `lang_definitions` VALUES (1717, 4254, 2, 'Kvinna VSC');
INSERT INTO `lang_definitions` VALUES (1718, 4257, 2, 'Feber');
INSERT INTO `lang_definitions` VALUES (1719, 4258, 2, 'Feber:');
INSERT INTO `lang_definitions` VALUES (1720, 4295, 2, 'Filnamn');
INSERT INTO `lang_definitions` VALUES (1721, 4305, 2, 'Fyll här endast om du skickar e-postmeddelande till patienter');
INSERT INTO `lang_definitions` VALUES (1722, 4324, 2, 'Filter');
INSERT INTO `lang_definitions` VALUES (1723, 4327, 2, 'Slutgiltig diagnos');
INSERT INTO `lang_definitions` VALUES (1724, 4328, 2, 'Slutgiltig diagnos av specialist');
INSERT INTO `lang_definitions` VALUES (1725, 4330, 2, 'Finansiella');
INSERT INTO `lang_definitions` VALUES (1726, 4337, 2, 'Financial Review Datum');
INSERT INTO `lang_definitions` VALUES (1727, 4340, 2, 'Hitta');
INSERT INTO `lang_definitions` VALUES (1728, 4341, 2, 'Hitta Ledig');
INSERT INTO `lang_definitions` VALUES (1729, 4342, 2, 'Sök Ledig mötestider');
INSERT INTO `lang_definitions` VALUES (1730, 4345, 2, 'Hitta Patientient');
INSERT INTO `lang_definitions` VALUES (1731, 4348, 2, 'Undersökningsresultat');
INSERT INTO `lang_definitions` VALUES (1732, 4349, 2, 'Undersökningsresultat av specialist');
INSERT INTO `lang_definitions` VALUES (1733, 4350, 2, 'Fin');
INSERT INTO `lang_definitions` VALUES (1734, 4357, 2, 'Första');
INSERT INTO `lang_definitions` VALUES (1735, 4360, 2, 'Första dagen i veckan');
INSERT INTO `lang_definitions` VALUES (1736, 4363, 2, 'Förnamn');
INSERT INTO `lang_definitions` VALUES (1737, 4366, 2, 'Förnamn:');
INSERT INTO `lang_definitions` VALUES (1738, 4372, 2, 'Fitness');
INSERT INTO `lang_definitions` VALUES (1739, 4376, 2, 'Fitness att spela');
INSERT INTO `lang_definitions` VALUES (1740, 4403, 2, 'Influensavaccination');
INSERT INTO `lang_definitions` VALUES (1741, 4404, 2, 'Vätske-och elektrolyt problem');
INSERT INTO `lang_definitions` VALUES (1742, 4407, 2, 'Följa manuellt');
INSERT INTO `lang_definitions` VALUES (1743, 4423, 2, 'Fot');
INSERT INTO `lang_definitions` VALUES (1744, 4424, 2, 'Fotproblem');
INSERT INTO `lang_definitions` VALUES (1745, 4425, 2, 'Fot:');
INSERT INTO `lang_definitions` VALUES (1746, 4428, 2, 'Fotboll Skaderapport');
INSERT INTO `lang_definitions` VALUES (1747, 4429, 2, 'Skotyp');
INSERT INTO `lang_definitions` VALUES (1748, 4430, 2, 'för');
INSERT INTO `lang_definitions` VALUES (1749, 4491, 2, 'för:');
INSERT INTO `lang_definitions` VALUES (1750, 4497, 2, 'Underarm');
INSERT INTO `lang_definitions` VALUES (1751, 4498, 2, 'Formulär');
INSERT INTO `lang_definitions` VALUES (1752, 4504, 2, 'Format');
INSERT INTO `lang_definitions` VALUES (1753, 4507, 2, 'Format felaktigt för NDC');
INSERT INTO `lang_definitions` VALUES (1754, 4512, 2, 'Formulär');
INSERT INTO `lang_definitions` VALUES (1755, 4513, 2, 'Formulär administration');
INSERT INTO `lang_definitions` VALUES (1756, 4522, 2, 'Vidarebefordra Sidor via Fax');
INSERT INTO `lang_definitions` VALUES (1757, 4528, 2, 'Fjärde');
INSERT INTO `lang_definitions` VALUES (1758, 4530, 2, 'Fraktur');
INSERT INTO `lang_definitions` VALUES (1759, 4531, 2, 'Fracture på Navicula');
INSERT INTO `lang_definitions` VALUES (1760, 4532, 2, 'Fracture laterala malleolus');
INSERT INTO `lang_definitions` VALUES (1761, 4533, 2, 'Fracture mediala malleolus');
INSERT INTO `lang_definitions` VALUES (1762, 4544, 2, 'Fre');
INSERT INTO `lang_definitions` VALUES (1763, 4545, 2, 'Fredag');
INSERT INTO `lang_definitions` VALUES (1764, 4547, 2, 'Från');
INSERT INTO `lang_definitions` VALUES (1765, 4556, 2, 'Från:');
INSERT INTO `lang_definitions` VALUES (1766, 4557, 2, 'Från:');
INSERT INTO `lang_definitions` VALUES (1767, 4571, 2, 'Reception');
INSERT INTO `lang_definitions` VALUES (1768, 4574, 2, 'Reception, kvitton');
INSERT INTO `lang_definitions` VALUES (1769, 4575, 2, 'Reception, kvitton, rapport');
INSERT INTO `lang_definitions` VALUES (1770, 4577, 2, 'Frontal Höger:');
INSERT INTO `lang_definitions` VALUES (1771, 4594, 2, 'All utbildning');
INSERT INTO `lang_definitions` VALUES (1772, 4613, 2, 'Gallsten');
INSERT INTO `lang_definitions` VALUES (1773, 4614, 2, 'Game Period');
INSERT INTO `lang_definitions` VALUES (1774, 4615, 2, 'Spel');
INSERT INTO `lang_definitions` VALUES (1775, 4617, 2, 'spel / evenemang');
INSERT INTO `lang_definitions` VALUES (1776, 4620, 2, 'Gastrit');
INSERT INTO `lang_definitions` VALUES (1777, 4622, 2, 'Gastrointestinala');
INSERT INTO `lang_definitions` VALUES (1778, 4630, 2, 'GCAC Statistik Rapport');
INSERT INTO `lang_definitions` VALUES (1779, 4635, 2, 'Kön');
INSERT INTO `lang_definitions` VALUES (1780, 4637, 2, 'Allmänt');
INSERT INTO `lang_definitions` VALUES (1781, 4642, 2, 'Allmänna Tjänstekategori');
INSERT INTO `lang_definitions` VALUES (1782, 4651, 2, 'Skapa och hämta HCFA 1500 papper fordringar');
INSERT INTO `lang_definitions` VALUES (1783, 4654, 2, 'Skapa och hämta X12 parti');
INSERT INTO `lang_definitions` VALUES (1784, 4666, 2, 'Generera Skrivelse angående');
INSERT INTO `lang_definitions` VALUES (1785, 4676, 2, 'Generera rapport');
INSERT INTO `lang_definitions` VALUES (1786, 4690, 2, 'Skapad på');
INSERT INTO `lang_definitions` VALUES (1787, 4692, 2, 'Genererar');
INSERT INTO `lang_definitions` VALUES (1788, 4717, 2, 'Glaukom');
INSERT INTO `lang_definitions` VALUES (1789, 4720, 2, 'Global');
INSERT INTO `lang_definitions` VALUES (1790, 4728, 2, 'Gå');
INSERT INTO `lang_definitions` VALUES (1791, 4729, 2, 'gå');
INSERT INTO `lang_definitions` VALUES (1792, 4759, 2, 'Grad:');
INSERT INTO `lang_definitions` VALUES (1793, 4761, 2, 'Totalsumma');
INSERT INTO `lang_definitions` VALUES (1794, 4762, 2, 'Totalsummor');
INSERT INTO `lang_definitions` VALUES (1795, 4773, 2, 'Grupp');
INSERT INTO `lang_definitions` VALUES (1796, 4794, 2, 'Gruppnummer');
INSERT INTO `lang_definitions` VALUES (1797, 4802, 2, 'Grupp:');
INSERT INTO `lang_definitions` VALUES (1798, 4804, 2, 'Gruppnamn');
INSERT INTO `lang_definitions` VALUES (1799, 4807, 2, 'Grupper och åtkomstkontroller');
INSERT INTO `lang_definitions` VALUES (1800, 4811, 2, 'Droppar');
INSERT INTO `lang_definitions` VALUES (1801, 4828, 2, 'Hematom / blåmärken');
INSERT INTO `lang_definitions` VALUES (1802, 4832, 2, 'Hand + fingrar');
INSERT INTO `lang_definitions` VALUES (1803, 4833, 2, 'Handproblem');
INSERT INTO `lang_definitions` VALUES (1804, 4839, 2, 'Umbäranden w / o');
INSERT INTO `lang_definitions` VALUES (1805, 4850, 2, 'Farliga aktiviteter');
INSERT INTO `lang_definitions` VALUES (1806, 4860, 2, 'han PostCalendar');
INSERT INTO `lang_definitions` VALUES (1807, 4861, 2, 'Huvud');
INSERT INTO `lang_definitions` VALUES (1808, 4865, 2, 'Huvudvärk');
INSERT INTO `lang_definitions` VALUES (1809, 4878, 2, 'Heart Attack');
INSERT INTO `lang_definitions` VALUES (1810, 4880, 2, 'Hjärtsvikt');
INSERT INTO `lang_definitions` VALUES (1811, 4882, 2, 'Hjärtproblem');
INSERT INTO `lang_definitions` VALUES (1812, 4883, 2, 'Hjärtkirurgi');
INSERT INTO `lang_definitions` VALUES (1813, 4884, 2, 'Heart Transplant');
INSERT INTO `lang_definitions` VALUES (1814, 4885, 2, 'Heart:');
INSERT INTO `lang_definitions` VALUES (1815, 4893, 2, 'Längd');
INSERT INTO `lang_definitions` VALUES (1816, 4895, 2, 'Hjälp');
INSERT INTO `lang_definitions` VALUES (1817, 4896, 2, 'hjälp');
INSERT INTO `lang_definitions` VALUES (1818, 4902, 2, 'Hemoglobin');
INSERT INTO `lang_definitions` VALUES (1819, 4905, 2, 'Hepatit');
INSERT INTO `lang_definitions` VALUES (1820, 4915, 2, 'Bråck Reparation');
INSERT INTO `lang_definitions` VALUES (1821, 4916, 2, 'Diskbråck');
INSERT INTO `lang_definitions` VALUES (1822, 4917, 2, 'Herpes');
INSERT INTO `lang_definitions` VALUES (1823, 4921, 2, 'heyyo. du har varit här i');
INSERT INTO `lang_definitions` VALUES (1824, 4926, 2, 'Dolda');
INSERT INTO `lang_definitions` VALUES (1825, 4927, 2, 'Dolda Händelser Administration');
INSERT INTO `lang_definitions` VALUES (1826, 4928, 2, 'Gömma');
INSERT INTO `lang_definitions` VALUES (1827, 4930, 2, 'Dölj detaljer');
INSERT INTO `lang_definitions` VALUES (1828, 4935, 2, 'Göm meny');
INSERT INTO `lang_definitions` VALUES (1829, 4937, 2, 'Göm påminnelser');
INSERT INTO `lang_definitions` VALUES (1830, 4939, 2, 'Göm/Visa kolumner');
INSERT INTO `lang_definitions` VALUES (1831, 4941, 2, 'Hög');
INSERT INTO `lang_definitions` VALUES (1832, 4943, 2, 'Högt blodtryck');
INSERT INTO `lang_definitions` VALUES (1833, 4946, 2, 'Höft + ljumske');
INSERT INTO `lang_definitions` VALUES (1834, 4947, 2, 'Höft och ljumske');
INSERT INTO `lang_definitions` VALUES (1835, 4948, 2, 'Hip Problem');
INSERT INTO `lang_definitions` VALUES (1836, 4949, 2, 'Höftledsplastik');
INSERT INTO `lang_definitions` VALUES (1837, 4951, 2, 'Ej Tilldelad');
INSERT INTO `lang_definitions` VALUES (1838, 4954, 2, 'Spansktalande');
INSERT INTO `lang_definitions` VALUES (1839, 4959, 2, 'Historia');
INSERT INTO `lang_definitions` VALUES (1840, 4965, 2, 'Historikdata');
INSERT INTO `lang_definitions` VALUES (1841, 4989, 2, 'Håll ner [Ctrl] för flera val eller avmarkera');
INSERT INTO `lang_definitions` VALUES (1842, 4991, 2, 'Håll ned Ctrl för att välja flera objekt');
INSERT INTO `lang_definitions` VALUES (1843, 4992, 2, 'Håll ned Ctrl för att välja flera patruller');
INSERT INTO `lang_definitions` VALUES (1844, 4995, 2, 'Hem');
INSERT INTO `lang_definitions` VALUES (1845, 4997, 2, 'Hemtelefon');
INSERT INTO `lang_definitions` VALUES (1846, 5000, 2, 'Hemlös eller liknande?');
INSERT INTO `lang_definitions` VALUES (1847, 5002, 2, 'Hemlös');
INSERT INTO `lang_definitions` VALUES (1848, 5003, 2, 'Hemlös');
INSERT INTO `lang_definitions` VALUES (1849, 5016, 2, 'Timmar');
INSERT INTO `lang_definitions` VALUES (1850, 5019, 2, 'Hur uppstod skadan?');
INSERT INTO `lang_definitions` VALUES (1851, 5020, 2, 'Hur uppstod skadan?:');
INSERT INTO `lang_definitions` VALUES (1852, 5024, 2, 'Hur många månader att fråga efter kommande evenemang?');
INSERT INTO `lang_definitions` VALUES (1853, 5050, 2, 'Hyperaktiv');
INSERT INTO `lang_definitions` VALUES (1854, 5055, 2, 'Hyperthyroidism');
INSERT INTO `lang_definitions` VALUES (1855, 5057, 2, 'Hypotyreoidism');
INSERT INTO `lang_definitions` VALUES (1856, 5060, 2, 'Hysterektomi');
INSERT INTO `lang_definitions` VALUES (1857, 5062, 2, 'Jag är upptagen under denna tid.');
INSERT INTO `lang_definitions` VALUES (1858, 5063, 2, 'Jag har inte behörighet att läsa');
INSERT INTO `lang_definitions` VALUES (1859, 5091, 2, 'Identifierare (ett ord)');
INSERT INTO `lang_definitions` VALUES (1860, 5101, 2, 'Om alla uppgifter för alla kolumner är komplett för denna form');
INSERT INTO `lang_definitions` VALUES (1861, 5111, 2, 'Om namn, någon del av efternamn eller efternamn, förnamn');
INSERT INTO `lang_definitions` VALUES (1862, 5118, 2, 'Om personen avlidit ange dödsdatum');
INSERT INTO `lang_definitions` VALUES (1863, 5150, 2, 'om arbetslösa lägg till student');
INSERT INTO `lang_definitions` VALUES (1864, 5199, 2, 'Om du vill ändra datatyper, lägg till rader eller kolumner');
INSERT INTO `lang_definitions` VALUES (1865, 5207, 2, 'Sjukdom');
INSERT INTO `lang_definitions` VALUES (1866, 5216, 2, 'Vaccinering');
INSERT INTO `lang_definitions` VALUES (1867, 5223, 2, 'Vaccin, Lotnummer');
INSERT INTO `lang_definitions` VALUES (1868, 5224, 2, 'Vaccin, tillverkare');
INSERT INTO `lang_definitions` VALUES (1869, 5236, 2, 'Vaccineringar');
INSERT INTO `lang_definitions` VALUES (1870, 5238, 2, 'Vaccinera');
INSERT INTO `lang_definitions` VALUES (1871, 5244, 2, 'Implantat');
INSERT INTO `lang_definitions` VALUES (1872, 5245, 2, 'Importera');
INSERT INTO `lang_definitions` VALUES (1873, 5255, 2, 'Importera patient');
INSERT INTO `lang_definitions` VALUES (1874, 5256, 2, 'Importera Patientdemografi');
INSERT INTO `lang_definitions` VALUES (1875, 5265, 2, 'Importerad från Accounting');
INSERT INTO `lang_definitions` VALUES (1876, 5271, 2, 'förbättrad');
INSERT INTO `lang_definitions` VALUES (1877, 5273, 2, 'i');
INSERT INTO `lang_definitions` VALUES (1878, 5283, 2, 'i båda ögonen');
INSERT INTO `lang_definitions` VALUES (1879, 5288, 2, 'i vänster öga');
INSERT INTO `lang_definitions` VALUES (1880, 5289, 2, 'i näsborre');
INSERT INTO `lang_definitions` VALUES (1881, 5290, 2, 'Arbetar');
INSERT INTO `lang_definitions` VALUES (1882, 5302, 2, 'i höger öga');
INSERT INTO `lang_definitions` VALUES (1883, 5321, 2, 'Inaktiv Dagar');
INSERT INTO `lang_definitions` VALUES (1884, 5339, 2, 'Inkludera mätväden');
INSERT INTO `lang_definitions` VALUES (1885, 5345, 2, 'Inkomst');
INSERT INTO `lang_definitions` VALUES (1886, 5354, 2, 'ökat:');
INSERT INTO `lang_definitions` VALUES (1887, 5355, 2, 'Ansvarsförsäkring');
INSERT INTO `lang_definitions` VALUES (1888, 5358, 2, 'Obestämd');
INSERT INTO `lang_definitions` VALUES (1889, 5364, 2, 'Indikerar om detta problem/frågeställning är aktiv');
INSERT INTO `lang_definitions` VALUES (1890, 5368, 2, 'Hjälpbehövande Patienter Rapport');
INSERT INTO `lang_definitions` VALUES (1891, 5377, 2, 'Infektion / Abscess');
INSERT INTO `lang_definitions` VALUES (1892, 5378, 2, 'Infektioner');
INSERT INTO `lang_definitions` VALUES (1893, 5379, 2, 'Infert Couns');
INSERT INTO `lang_definitions` VALUES (1894, 5386, 2, 'Info');
INSERT INTO `lang_definitions` VALUES (1895, 5387, 2, 'Info test 1');
INSERT INTO `lang_definitions` VALUES (1896, 5388, 2, 'Info test 2');
INSERT INTO `lang_definitions` VALUES (1897, 5389, 2, 'Info test 3');
INSERT INTO `lang_definitions` VALUES (1898, 5390, 2, 'Info test 4');
INSERT INTO `lang_definitions` VALUES (1899, 5391, 2, 'Info test 5');
INSERT INTO `lang_definitions` VALUES (1900, 5392, 2, 'Info test 6');
INSERT INTO `lang_definitions` VALUES (1901, 5398, 2, 'inhalation');
INSERT INTO `lang_definitions` VALUES (1902, 5400, 2, 'inhalationer');
INSERT INTO `lang_definitions` VALUES (1903, 5403, 2, 'Ursprunglig användare');
INSERT INTO `lang_definitions` VALUES (1904, 5407, 2, 'Injeserbara');
INSERT INTO `lang_definitions` VALUES (1905, 5410, 2, 'Skadade ut');
INSERT INTO `lang_definitions` VALUES (1906, 5413, 2, 'Skademekanism');
INSERT INTO `lang_definitions` VALUES (1907, 5414, 2, 'Skada, översiktsrapport');
INSERT INTO `lang_definitions` VALUES (1908, 5416, 2, 'Skada Typ');
INSERT INTO `lang_definitions` VALUES (1909, 5422, 2, 'Inmatningsfält');
INSERT INTO `lang_definitions` VALUES (1910, 5427, 2, 'Ins justera');
INSERT INTO `lang_definitions` VALUES (1911, 5428, 2, 'Ins paketering');
INSERT INTO `lang_definitions` VALUES (1912, 5432, 2, 'Ins överskjutande');
INSERT INTO `lang_definitions` VALUES (1913, 5434, 2, 'Ins återbetalning');
INSERT INTO `lang_definitions` VALUES (1914, 5435, 2, 'Ins Sammering');
INSERT INTO `lang_definitions` VALUES (1915, 5437, 2, 'Ins1');
INSERT INTO `lang_definitions` VALUES (1916, 5438, 2, 'Ins2');
INSERT INTO `lang_definitions` VALUES (1917, 5439, 2, 'Ins3');
INSERT INTO `lang_definitions` VALUES (1918, 5441, 2, 'isättning misslyckades:');
INSERT INTO `lang_definitions` VALUES (1919, 5446, 2, 'Sätt gamla händelser i tabeller');
INSERT INTO `lang_definitions` VALUES (1920, 5452, 2, 'Insomnia');
INSERT INTO `lang_definitions` VALUES (1921, 5454, 2, 'Inspektion');
INSERT INTO `lang_definitions` VALUES (1922, 5455, 2, 'Instabilitet / subluxation');
INSERT INTO `lang_definitions` VALUES (1923, 5460, 2, 'installera DB');
INSERT INTO `lang_definitions` VALUES (1924, 5470, 2, 'Instruerad');
INSERT INTO `lang_definitions` VALUES (1925, 5473, 2, 'Instruktioner:');
INSERT INTO `lang_definitions` VALUES (1926, 5476, 2, 'Insulinberoende diabetiker');
INSERT INTO `lang_definitions` VALUES (1927, 5477, 2, 'Försäkring');
INSERT INTO `lang_definitions` VALUES (1928, 5478, 2, 'försäkring');
INSERT INTO `lang_definitions` VALUES (1929, 5485, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1930, 5486, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1931, 5487, 2, 'Försäkringsbolag Sök / Köp');
INSERT INTO `lang_definitions` VALUES (1932, 5489, 2, 'Försäkring Data');
INSERT INTO `lang_definitions` VALUES (1933, 5494, 2, 'Försäkring Number');
INSERT INTO `lang_definitions` VALUES (1934, 5498, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1935, 5518, 2, 'Internt fel - inga sidor valdes!');
INSERT INTO `lang_definitions` VALUES (1936, 5519, 2, 'Internt fel - patient-ID fanns inte!');
INSERT INTO `lang_definitions` VALUES (1937, 5522, 2, 'Internt fel!');
INSERT INTO `lang_definitions` VALUES (1938, 5525, 2, 'Internt fel: påstående');
INSERT INTO `lang_definitions` VALUES (1939, 5526, 2, 'Internt fel: möter\"');
INSERT INTO `lang_definitions` VALUES (1940, 5533, 2, 'Inre Övergångar');
INSERT INTO `lang_definitions` VALUES (1941, 5537, 2, 'Tolk');
INSERT INTO `lang_definitions` VALUES (1942, 5539, 2, 'Interstitiell lungsjukdom');
INSERT INTO `lang_definitions` VALUES (1943, 5540, 2, 'Interval');
INSERT INTO `lang_definitions` VALUES (1944, 5545, 2, 'Intolerans');
INSERT INTO `lang_definitions` VALUES (1945, 5548, 2, 'intramuskulärt');
INSERT INTO `lang_definitions` VALUES (1946, 5551, 2, 'intravenöst');
INSERT INTO `lang_definitions` VALUES (1947, 5552, 2, 'Introduktion');
INSERT INTO `lang_definitions` VALUES (1948, 5568, 2, 'Ogiltig eller saknas betalaren i källan för kod');
INSERT INTO `lang_definitions` VALUES (1949, 5573, 2, 'Ogiltig Service Kod');
INSERT INTO `lang_definitions` VALUES (1950, 5574, 2, 'Ogiltig källdestination\"');
INSERT INTO `lang_definitions` VALUES (1951, 5578, 2, 'Inventering');
INSERT INTO `lang_definitions` VALUES (1952, 5583, 2, 'Inventering är inte tillgänglig för denna beställning.');
INSERT INTO `lang_definitions` VALUES (1953, 5584, 2, 'Inventeringslista');
INSERT INTO `lang_definitions` VALUES (1954, 5587, 2, 'Faktura');
INSERT INTO `lang_definitions` VALUES (1955, 5588, 2, 'faktura');
INSERT INTO `lang_definitions` VALUES (1956, 5594, 2, 'Fakturadatum');
INSERT INTO `lang_definitions` VALUES (1957, 5596, 2, 'Fakturanhar inget datum!');
INSERT INTO `lang_definitions` VALUES (1958, 5604, 2, 'Faktura:');
INSERT INTO `lang_definitions` VALUES (1959, 5629, 2, 'Oregelbunden hjärtrytm');
INSERT INTO `lang_definitions` VALUES (1960, 5630, 2, 'Retlighet');
INSERT INTO `lang_definitions` VALUES (1961, 5631, 2, 'Irritation');
INSERT INTO `lang_definitions` VALUES (1962, 5636, 2, 'är ett obligatoriskt fält.');
INSERT INTO `lang_definitions` VALUES (1963, 5648, 2, 'inte är giltig (decimalbråk är OK).');
INSERT INTO `lang_definitions` VALUES (1964, 5649, 2, 'Är PHP använder felsäkert läge?');
INSERT INTO `lang_definitions` VALUES (1965, 5670, 2, 'Frågeställning');
INSERT INTO `lang_definitions` VALUES (1966, 5671, 2, 'frågeställning');
INSERT INTO `lang_definitions` VALUES (1967, 5678, 2, 'Aktuellt');
INSERT INTO `lang_definitions` VALUES (1968, 5680, 2, 'Aktuellt (Problem / Medicin / Allergi):');
INSERT INTO `lang_definitions` VALUES (1969, 5682, 2, 'Information och Patientmöten');
INSERT INTO `lang_definitions` VALUES (1970, 5683, 2, 'Information och möten för');
INSERT INTO `lang_definitions` VALUES (1971, 5688, 2, 'Problematik, ej behörig');
INSERT INTO `lang_definitions` VALUES (1972, 5689, 2, 'Frågeställningssektion');
INSERT INTO `lang_definitions` VALUES (1973, 5747, 2, 'Artikel');
INSERT INTO `lang_definitions` VALUES (1974, 5748, 2, 'artikel');
INSERT INTO `lang_definitions` VALUES (1975, 5754, 2, 'Poster laddades inte');
INSERT INTO `lang_definitions` VALUES (1976, 5763, 2, 'Januari');
INSERT INTO `lang_definitions` VALUES (1977, 5767, 2, 'Jobb-beskrivning');
INSERT INTO `lang_definitions` VALUES (1978, 5768, 2, 'Jobb id');
INSERT INTO `lang_definitions` VALUES (1979, 5769, 2, 'Led dislokation');
INSERT INTO `lang_definitions` VALUES (1980, 5770, 2, 'Led smärta');
INSERT INTO `lang_definitions` VALUES (1981, 5771, 2, 'Led vrickning');
INSERT INTO `lang_definitions` VALUES (1982, 5778, 2, 'Juli');
INSERT INTO `lang_definitions` VALUES (1983, 5781, 2, 'Juni');
INSERT INTO `lang_definitions` VALUES (1984, 5783, 2, 'Bara min');
INSERT INTO `lang_definitions` VALUES (1985, 5785, 2, 'Motivera');
INSERT INTO `lang_definitions` VALUES (1986, 5788, 2, 'Motivera / Spara');
INSERT INTO `lang_definitions` VALUES (1987, 5791, 2, 'k, här är resten');
INSERT INTO `lang_definitions` VALUES (1988, 5804, 2, 'Nyckelord');
INSERT INTO `lang_definitions` VALUES (1989, 5808, 2, 'Njurcancer');
INSERT INTO `lang_definitions` VALUES (1990, 5809, 2, 'Njursvikt');
INSERT INTO `lang_definitions` VALUES (1991, 5810, 2, 'Njure Infektioner');
INSERT INTO `lang_definitions` VALUES (1992, 5811, 2, 'Njursten');
INSERT INTO `lang_definitions` VALUES (1993, 5812, 2, 'Njurtransplantation');
INSERT INTO `lang_definitions` VALUES (1994, 5818, 2, 'Knä');
INSERT INTO `lang_definitions` VALUES (1995, 5819, 2, 'Knä Problem');
INSERT INTO `lang_definitions` VALUES (1996, 5820, 2, 'Knä Ersättning /protes');
INSERT INTO `lang_definitions` VALUES (1997, 5828, 2, 'Lab');
INSERT INTO `lang_definitions` VALUES (1998, 5839, 2, 'Lab Rapport');
INSERT INTO `lang_definitions` VALUES (1999, 5848, 2, 'Etikett');
INSERT INTO `lang_definitions` VALUES (2000, 5850, 2, 'Label Cols');
INSERT INTO `lang_definitions` VALUES (2001, 5854, 2, 'Etiketter');
INSERT INTO `lang_definitions` VALUES (2002, 5858, 2, 'Labs');
INSERT INTO `lang_definitions` VALUES (2003, 5859, 2, 'Laceration / hudkodition');
INSERT INTO `lang_definitions` VALUES (2004, 5860, 2, 'Laceration / nötning');
INSERT INTO `lang_definitions` VALUES (2005, 5866, 2, 'Språk');
INSERT INTO `lang_definitions` VALUES (2006, 5867, 2, 'Språk-kod');
INSERT INTO `lang_definitions` VALUES (2007, 5868, 2, 'Språk definition tillagd');
INSERT INTO `lang_definitions` VALUES (2008, 5873, 2, 'Språknamn');
INSERT INTO `lang_definitions` VALUES (2009, 5874, 2, 'Språk:');
INSERT INTO `lang_definitions` VALUES (2010, 5880, 2, 'Sist');
INSERT INTO `lang_definitions` VALUES (2011, 5882, 2, 'Datum för senaste aktivitet');
INSERT INTO `lang_definitions` VALUES (2012, 5885, 2, 'Sista betalnings dag på faktura:');
INSERT INTO `lang_definitions` VALUES (2013, 5891, 2, 'Senaste patientmötet');
INSERT INTO `lang_definitions` VALUES (2014, 5903, 2, 'Efternamn');
INSERT INTO `lang_definitions` VALUES (2015, 5904, 2, 'Efternamn');
INSERT INTO `lang_definitions` VALUES (2016, 5910, 2, 'Efternamn:');
INSERT INTO `lang_definitions` VALUES (2017, 5916, 2, 'Senast sparad');
INSERT INTO `lang_definitions` VALUES (2018, 5923, 2, 'Senast uppdaterad av');
INSERT INTO `lang_definitions` VALUES (2019, 5925, 2, 'Senaste besöket');
INSERT INTO `lang_definitions` VALUES (2020, 5929, 2, 'Sen Återkommande (2-12 mån)');
INSERT INTO `lang_definitions` VALUES (2021, 5934, 2, 'sidled fördrivna PMI:');
INSERT INTO `lang_definitions` VALUES (2022, 5950, 2, 'Layout Editor');
INSERT INTO `lang_definitions` VALUES (2023, 5958, 2, 'Layouter');
INSERT INTO `lang_definitions` VALUES (2024, 5970, 2, 'LDL');
INSERT INTO `lang_definitions` VALUES (2025, 5972, 2, 'lämna tom om fortfarande aktiv');
INSERT INTO `lang_definitions` VALUES (2026, 5974, 2, 'Lämna tomt för att hålla lösenord oförändrad.');
INSERT INTO `lang_definitions` VALUES (2027, 5979, 2, 'Kontakt via');
INSERT INTO `lang_definitions` VALUES (2028, 5981, 2, 'Lämna Form');
INSERT INTO `lang_definitions` VALUES (2029, 5985, 2, 'Vänster');
INSERT INTO `lang_definitions` VALUES (2030, 5988, 2, 'vänster öra');
INSERT INTO `lang_definitions` VALUES (2031, 5989, 2, 'vänster öra');
INSERT INTO `lang_definitions` VALUES (2032, 5998, 2, 'Vänster:');
INSERT INTO `lang_definitions` VALUES (2033, 5999, 2, 'Vänster:');
INSERT INTO `lang_definitions` VALUES (2034, 6000, 2, 'Ben smärta / Kramper');
INSERT INTO `lang_definitions` VALUES (2035, 6001, 2, 'Rättsärenden');
INSERT INTO `lang_definitions` VALUES (2036, 6004, 2, 'Förklaring:');
INSERT INTO `lang_definitions` VALUES (2037, 6005, 2, 'Längd');
INSERT INTO `lang_definitions` VALUES (2038, 6019, 2, 'Brev');
INSERT INTO `lang_definitions` VALUES (2039, 6020, 2, 'Brevgenerator');
INSERT INTO `lang_definitions` VALUES (2040, 6029, 2, 'Ansvar');
INSERT INTO `lang_definitions` VALUES (2041, 6030, 2, 'Ansvar för medicinskt');
INSERT INTO `lang_definitions` VALUES (2042, 6032, 2, 'passnr');
INSERT INTO `lang_definitions` VALUES (2043, 6043, 2, 'Livsstil');
INSERT INTO `lang_definitions` VALUES (2044, 6046, 2, 'Ligament skada eller vrickning');
INSERT INTO `lang_definitions` VALUES (2045, 6050, 2, 'Begränsning av händelser');
INSERT INTO `lang_definitions` VALUES (2046, 6067, 2, 'Förteckning');
INSERT INTO `lang_definitions` VALUES (2047, 6074, 2, 'List Editor');
INSERT INTO `lang_definitions` VALUES (2048, 6078, 2, 'Lista Insurance Companies');
INSERT INTO `lang_definitions` VALUES (2049, 6083, 2, 'Lista listor');
INSERT INTO `lang_definitions` VALUES (2050, 6085, 2, 'Lista Namn');
INSERT INTO `lang_definitions` VALUES (2051, 6091, 2, 'Lista recept');
INSERT INTO `lang_definitions` VALUES (2052, 6096, 2, 'Listor');
INSERT INTO `lang_definitions` VALUES (2053, 6112, 2, 'Ladda definitioner');
INSERT INTO `lang_definitions` VALUES (2054, 6121, 2, 'Laddar');
INSERT INTO `lang_definitions` VALUES (2055, 6129, 2, 'Lokalt');
INSERT INTO `lang_definitions` VALUES (2056, 6134, 2, 'Lokalitet');
INSERT INTO `lang_definitions` VALUES (2057, 6135, 2, 'Lokalisation');
INSERT INTO `lang_definitions` VALUES (2058, 6138, 2, 'Lokalisation ospecificerad');
INSERT INTO `lang_definitions` VALUES (2059, 6141, 2, 'Lokalisation');
INSERT INTO `lang_definitions` VALUES (2060, 6157, 2, 'Inloggad');
INSERT INTO `lang_definitions` VALUES (2061, 6158, 2, 'Inloggad som');
INSERT INTO `lang_definitions` VALUES (2062, 6159, 2, 'Inloggad som:');
INSERT INTO `lang_definitions` VALUES (2063, 6161, 2, 'Utloggad.');
INSERT INTO `lang_definitions` VALUES (2064, 6163, 2, 'Logga in');
INSERT INTO `lang_definitions` VALUES (2065, 6164, 2, 'logga in');
INSERT INTO `lang_definitions` VALUES (2066, 6175, 2, 'Logout');
INSERT INTO `lang_definitions` VALUES (2067, 6176, 2, 'logout');
INSERT INTO `lang_definitions` VALUES (2068, 6177, 2, 'Loggar');
INSERT INTO `lang_definitions` VALUES (2069, 6183, 2, 'Slå upp');
INSERT INTO `lang_definitions` VALUES (2070, 6184, 2, 'Batch');
INSERT INTO `lang_definitions` VALUES (2071, 6186, 2, 'Batchnummer');
INSERT INTO `lang_definitions` VALUES (2072, 6188, 2, 'låg');
INSERT INTO `lang_definitions` VALUES (2073, 6190, 2, 'Benet');
INSERT INTO `lang_definitions` VALUES (2074, 6199, 2, 'Lumbal delen av ryggraden');
INSERT INTO `lang_definitions` VALUES (2075, 6200, 2, 'LUNCH');
INSERT INTO `lang_definitions` VALUES (2076, 6201, 2, 'Lunch');
INSERT INTO `lang_definitions` VALUES (2077, 6202, 2, 'Lung Cancer');
INSERT INTO `lang_definitions` VALUES (2078, 6203, 2, 'Lung Cancer kirurgi');
INSERT INTO `lang_definitions` VALUES (2079, 6204, 2, 'Lungor:');
INSERT INTO `lang_definitions` VALUES (2080, 6205, 2, 'Lungor:');
INSERT INTO `lang_definitions` VALUES (2081, 6212, 2, 'M');
INSERT INTO `lang_definitions` VALUES (2082, 6213, 2, 'MA Kategori');
INSERT INTO `lang_definitions` VALUES (2083, 6225, 2, 'Huvudadress');
INSERT INTO `lang_definitions` VALUES (2084, 6237, 2, 'Gör ändringar i nuvarande kategorier.');
INSERT INTO `lang_definitions` VALUES (2085, 6241, 2, 'Försäkra \"');
INSERT INTO `lang_definitions` VALUES (2086, 6244, 2, 'Sjukdomskänsla:');
INSERT INTO `lang_definitions` VALUES (2087, 6247, 2, 'Man');
INSERT INTO `lang_definitions` VALUES (2088, 6248, 2, 'Manlig Kondomer');
INSERT INTO `lang_definitions` VALUES (2089, 6251, 2, 'Mammogram');
INSERT INTO `lang_definitions` VALUES (2090, 6261, 2, 'Administration');
INSERT INTO `lang_definitions` VALUES (2091, 6271, 2, 'Manuell post');
INSERT INTO `lang_definitions` VALUES (2092, 6275, 2, 'Tillverkare');
INSERT INTO `lang_definitions` VALUES (2093, 6286, 2, 'Mars');
INSERT INTO `lang_definitions` VALUES (2094, 6289, 2, 'Civilstånd');
INSERT INTO `lang_definitions` VALUES (2095, 6292, 2, 'Markera som faktureras men hoppa fakturering');
INSERT INTO `lang_definitions` VALUES (2096, 6293, 2, 'Markera som avklarad');
INSERT INTO `lang_definitions` VALUES (2097, 6294, 2, 'Markera som ej fakturerad');
INSERT INTO `lang_definitions` VALUES (2098, 6299, 2, 'Markerad som avslutad');
INSERT INTO `lang_definitions` VALUES (2099, 6300, 2, 'Gift');
INSERT INTO `lang_definitions` VALUES (2100, 6326, 2, 'Maxillary Höger:');
INSERT INTO `lang_definitions` VALUES (2101, 6341, 2, 'Maj');
INSERT INTO `lang_definitions` VALUES (2102, 6343, 2, 'MC');
INSERT INTO `lang_definitions` VALUES (2103, 6344, 2, 'mcg');
INSERT INTO `lang_definitions` VALUES (2104, 6360, 2, 'Medicinsk');
INSERT INTO `lang_definitions` VALUES (2105, 6371, 2, 'Medicinska problem');
INSERT INTO `lang_definitions` VALUES (2106, 6373, 2, 'Medicinska problem');
INSERT INTO `lang_definitions` VALUES (2107, 6375, 2, 'Journal');
INSERT INTO `lang_definitions` VALUES (2108, 6376, 2, 'Journal #');
INSERT INTO `lang_definitions` VALUES (2109, 6378, 2, 'Journaler');
INSERT INTO `lang_definitions` VALUES (2110, 6385, 2, 'Journal / Historia ( frivilligt att skriva )');
INSERT INTO `lang_definitions` VALUES (2111, 6389, 2, 'Medicin');
INSERT INTO `lang_definitions` VALUES (2112, 6397, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (2113, 6400, 2, 'Läkemedel:');
INSERT INTO `lang_definitions` VALUES (2114, 6401, 2, 'Medicinska enheter');
INSERT INTO `lang_definitions` VALUES (2115, 6402, 2, 'Medium');
INSERT INTO `lang_definitions` VALUES (2116, 6406, 2, 'Ledamot Association Statistik Rapport');
INSERT INTO `lang_definitions` VALUES (2117, 6408, 2, 'Minnes Problem');
INSERT INTO `lang_definitions` VALUES (2118, 6409, 2, 'Män');
INSERT INTO `lang_definitions` VALUES (2119, 6410, 2, 'Män och kvinnor');
INSERT INTO `lang_definitions` VALUES (2120, 6411, 2, 'Män Endast');
INSERT INTO `lang_definitions` VALUES (2121, 6413, 2, 'Klimakteriet');
INSERT INTO `lang_definitions` VALUES (2122, 6416, 2, 'Psykisk sjukdom');
INSERT INTO `lang_definitions` VALUES (2123, 6429, 2, 'Meddelande');
INSERT INTO `lang_definitions` VALUES (2124, 6430, 2, 'Meddelanden och Påminnelser');
INSERT INTO `lang_definitions` VALUES (2125, 6443, 2, 'MEDELANDE:');
INSERT INTO `lang_definitions` VALUES (2126, 6444, 2, 'Meddelanden');
INSERT INTO `lang_definitions` VALUES (2127, 6451, 2, 'Metod');
INSERT INTO `lang_definitions` VALUES (2128, 6455, 2, 'Metod för förstöring');
INSERT INTO `lang_definitions` VALUES (2129, 6463, 2, 'mg');
INSERT INTO `lang_definitions` VALUES (2130, 6464, 2, 'mg/ml');
INSERT INTO `lang_definitions` VALUES (2131, 6465, 2, 'g');
INSERT INTO `lang_definitions` VALUES (2132, 6466, 2, 'g/ml');
INSERT INTO `lang_definitions` VALUES (2133, 6471, 2, 'Mellan');
INSERT INTO `lang_definitions` VALUES (2134, 6472, 2, 'Mellannamn');
INSERT INTO `lang_definitions` VALUES (2135, 6473, 2, 'Mellannamn');
INSERT INTO `lang_definitions` VALUES (2136, 6487, 2, 'Migrerande eller säsongsarbetare?');
INSERT INTO `lang_definitions` VALUES (2137, 6489, 2, 'Migrerande / Säsong');
INSERT INTO `lang_definitions` VALUES (2138, 6511, 2, 'Protokoll');
INSERT INTO `lang_definitions` VALUES (2139, 6512, 2, 'minuter');
INSERT INTO `lang_definitions` VALUES (2140, 6518, 2, 'Diverse');
INSERT INTO `lang_definitions` VALUES (2141, 6520, 2, 'Missade');
INSERT INTO `lang_definitions` VALUES (2142, 6540, 2, 'Blandat');
INSERT INTO `lang_definitions` VALUES (2143, 6542, 2, 'ml');
INSERT INTO `lang_definitions` VALUES (2144, 6549, 2, 'Mobil');
INSERT INTO `lang_definitions` VALUES (2145, 6550, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (2146, 6582, 2, 'Mån');
INSERT INTO `lang_definitions` VALUES (2147, 6583, 2, 'Mån tills fredag');
INSERT INTO `lang_definitions` VALUES (2148, 6584, 2, 'Måndag, onsdag och fredag');
INSERT INTO `lang_definitions` VALUES (2149, 6585, 2, 'Måndag');
INSERT INTO `lang_definitions` VALUES (2150, 6589, 2, 'månad');
INSERT INTO `lang_definitions` VALUES (2151, 6590, 2, 'Månad');
INSERT INTO `lang_definitions` VALUES (2152, 6591, 2, 'Månadsvy');
INSERT INTO `lang_definitions` VALUES (2153, 6592, 2, 'Månad (er)');
INSERT INTO `lang_definitions` VALUES (2154, 6593, 2, 'Månadsinkomst');
INSERT INTO `lang_definitions` VALUES (2155, 6610, 2, 'Mer än 50 resultat, gör din sökning mer specifik.');
INSERT INTO `lang_definitions` VALUES (2156, 6622, 2, 'Moder');
INSERT INTO `lang_definitions` VALUES (2157, 6628, 2, 'Flytta');
INSERT INTO `lang_definitions` VALUES (2158, 6633, 2, 'Flytta till patient');
INSERT INTO `lang_definitions` VALUES (2159, 6635, 2, 'Flytta till...');
INSERT INTO `lang_definitions` VALUES (2160, 6636, 2, 'flytta up');
INSERT INTO `lang_definitions` VALUES (2161, 6642, 2, 'Herr.');
INSERT INTO `lang_definitions` VALUES (2162, 6649, 2, 'Fru.');
INSERT INTO `lang_definitions` VALUES (2163, 6651, 2, 'Fröken');
INSERT INTO `lang_definitions` VALUES (2164, 6665, 2, 'Multi Language Tool');
INSERT INTO `lang_definitions` VALUES (2165, 6670, 2, 'Flera områden');
INSERT INTO `lang_definitions` VALUES (2166, 6679, 2, 'Sorla:');
INSERT INTO `lang_definitions` VALUES (2167, 6680, 2, 'Muskel värk');
INSERT INTO `lang_definitions` VALUES (2168, 6686, 2, 'Muskel');
INSERT INTO `lang_definitions` VALUES (2169, 6687, 2, 'Muskel skada');
INSERT INTO `lang_definitions` VALUES (2170, 6688, 2, 'Muskuloskeletala');
INSERT INTO `lang_definitions` VALUES (2171, 6696, 2, 'Ömsesidigt Definierad');
INSERT INTO `lang_definitions` VALUES (2172, 6716, 2, 'Namn');
INSERT INTO `lang_definitions` VALUES (2173, 6721, 2, 'Namn 1');
INSERT INTO `lang_definitions` VALUES (2174, 6722, 2, 'Namn 2');
INSERT INTO `lang_definitions` VALUES (2175, 6723, 2, 'Namn på administratör');
INSERT INTO `lang_definitions` VALUES (2176, 6728, 2, 'Namn på försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2177, 6729, 2, 'Namn på Provider');
INSERT INTO `lang_definitions` VALUES (2178, 6740, 2, 'Namn:');
INSERT INTO `lang_definitions` VALUES (2179, 6744, 2, 'Narės:');
INSERT INTO `lang_definitions` VALUES (2180, 6745, 2, 'Narės: Normal Rätt');
INSERT INTO `lang_definitions` VALUES (2181, 6748, 2, 'Nasal mucosa rosa, septumets mittlinje');
INSERT INTO `lang_definitions` VALUES (2182, 6754, 2, 'Nationalitet');
INSERT INTO `lang_definitions` VALUES (2183, 6766, 2, 'Navigering');
INSERT INTO `lang_definitions` VALUES (2184, 6793, 2, 'Nacke');
INSERT INTO `lang_definitions` VALUES (2185, 6794, 2, 'Nackproblem');
INSERT INTO `lang_definitions` VALUES (2186, 6797, 2, 'Måste ange en beskrivning');
INSERT INTO `lang_definitions` VALUES (2187, 6798, 2, 'Ange ett returvärde');
INSERT INTO `lang_definitions` VALUES (2188, 6799, 2, 'Ange identifieraren');
INSERT INTO `lang_definitions` VALUES (2189, 6800, 2, 'Ange titel');
INSERT INTO `lang_definitions` VALUES (2190, 6805, 2, 'Ange sekundära fakturering');
INSERT INTO `lang_definitions` VALUES (2191, 6815, 2, 'Nervskada');
INSERT INTO `lang_definitions` VALUES (2192, 6818, 2, 'Neurala tillstånd / nervskada');
INSERT INTO `lang_definitions` VALUES (2193, 6831, 2, 'Ny');
INSERT INTO `lang_definitions` VALUES (2194, 6832, 2, 'Ny =>');
INSERT INTO `lang_definitions` VALUES (2195, 6834, 2, 'Nya mottagare');
INSERT INTO `lang_definitions` VALUES (2196, 6838, 2, 'Nytt möte');
INSERT INTO `lang_definitions` VALUES (2197, 6839, 2, 'Nya kategorier');
INSERT INTO `lang_definitions` VALUES (2198, 6841, 2, 'Nya kunder');
INSERT INTO `lang_definitions` VALUES (2199, 6842, 2, 'Ny konsultation');
INSERT INTO `lang_definitions` VALUES (2200, 6844, 2, 'Nytt definitionset tillagt');
INSERT INTO `lang_definitions` VALUES (2201, 6851, 2, 'Nya Patientbesöksformulär');
INSERT INTO `lang_definitions` VALUES (2202, 6852, 2, 'Nya möten som inte godkänts');
INSERT INTO `lang_definitions` VALUES (2203, 6854, 2, 'Nya Klinikinformation');
INSERT INTO `lang_definitions` VALUES (2204, 6858, 2, 'Ny grupp');
INSERT INTO `lang_definitions` VALUES (2205, 6873, 2, 'Ny begränsning av händelser');
INSERT INTO `lang_definitions` VALUES (2206, 6884, 2, 'Ny Patient');
INSERT INTO `lang_definitions` VALUES (2207, 6885, 2, 'NY PATIENT');
INSERT INTO `lang_definitions` VALUES (2208, 6886, 2, 'Nytt Patientbesök');
INSERT INTO `lang_definitions` VALUES (2209, 6888, 2, 'Nytt patient-ID');
INSERT INTO `lang_definitions` VALUES (2210, 6899, 2, 'Nya förslag');
INSERT INTO `lang_definitions` VALUES (2211, 6901, 2, 'Ny användare');
INSERT INTO `lang_definitions` VALUES (2212, 6903, 2, 'Nytt besök');
INSERT INTO `lang_definitions` VALUES (2213, 6904, 2, 'Ny/Sök');
INSERT INTO `lang_definitions` VALUES (2214, 6931, 2, 'Dagstidning');
INSERT INTO `lang_definitions` VALUES (2215, 6932, 2, 'Nästa');
INSERT INTO `lang_definitions` VALUES (2216, 6934, 2, 'Nästa dag');
INSERT INTO `lang_definitions` VALUES (2217, 6936, 2, 'Nästa Månad');
INSERT INTO `lang_definitions` VALUES (2218, 6942, 2, 'Nästa vecka');
INSERT INTO `lang_definitions` VALUES (2219, 6945, 2, 'Alias');
INSERT INTO `lang_definitions` VALUES (2220, 6947, 2, 'Nattliga svettningar');
INSERT INTO `lang_definitions` VALUES (2221, 6950, 2, 'Nej');
INSERT INTO `lang_definitions` VALUES (2222, 6951, 2, 'NEJ');
INSERT INTO `lang_definitions` VALUES (2223, 6953, 2, 'Ingen tillgång');
INSERT INTO `lang_definitions` VALUES (2224, 6971, 2, 'Inget faktureringssystem är aktivt');
INSERT INTO `lang_definitions` VALUES (2225, 6975, 2, 'Ingen kod specificerades!');
INSERT INTO `lang_definitions` VALUES (2226, 6979, 2, 'Ingen diagnos');
INSERT INTO `lang_definitions` VALUES (2227, 6986, 2, 'Inget slutdatum');
INSERT INTO `lang_definitions` VALUES (2228, 6987, 2, 'Inga poster funna, använda formuläret nedan för att lägga till en post.');
INSERT INTO `lang_definitions` VALUES (2229, 6989, 2, 'Inga händelser');
INSERT INTO `lang_definitions` VALUES (2230, 6994, 2, 'Ingen grupp valdes');
INSERT INTO `lang_definitions` VALUES (2231, 6995, 2, 'Inga bråck');
INSERT INTO `lang_definitions` VALUES (2232, 7000, 2, 'Nr Insurance Companies Found');
INSERT INTO `lang_definitions` VALUES (2233, 7041, 2, 'Inga tider hittades för denna period.');
INSERT INTO `lang_definitions` VALUES (2234, 7046, 2, 'Inga Partners hittades');
INSERT INTO `lang_definitions` VALUES (2235, 7051, 2, 'Inga perifera ödem');
INSERT INTO `lang_definitions` VALUES (2236, 7052, 2, 'Inga apotek hittades');
INSERT INTO `lang_definitions` VALUES (2237, 7053, 2, 'Inga recept hittades');
INSERT INTO `lang_definitions` VALUES (2238, 7055, 2, 'Ingen sjukdom / skada visas');
INSERT INTO `lang_definitions` VALUES (2239, 7075, 2, 'Inga resultat hittades i sökningen');
INSERT INTO `lang_definitions` VALUES (2240, 7077, 2, 'Inga resultat, försök igen.');
INSERT INTO `lang_definitions` VALUES (2241, 7081, 2, 'Ej kommit på avtalad tid');
INSERT INTO `lang_definitions` VALUES (2242, 7086, 2, 'Ingen hud dimpling eller bröst knölar');
INSERT INTO `lang_definitions` VALUES (2243, 7101, 2, 'Nr:');
INSERT INTO `lang_definitions` VALUES (2244, 7106, 2, 'Icke specifika skada');
INSERT INTO `lang_definitions` VALUES (2245, 7109, 2, 'Icke-insulinberoende diabetes');
INSERT INTO `lang_definitions` VALUES (2246, 7112, 2, 'Icke-SRH Medical');
INSERT INTO `lang_definitions` VALUES (2247, 7113, 2, 'Icke-SRH icke-medicinska');
INSERT INTO `lang_definitions` VALUES (2248, 7114, 2, 'Ingen');
INSERT INTO `lang_definitions` VALUES (2249, 7115, 2, 'ingen');
INSERT INTO `lang_definitions` VALUES (2250, 7119, 2, 'Inget av ovanstående');
INSERT INTO `lang_definitions` VALUES (2251, 7151, 2, 'Inte heller');
INSERT INTO `lang_definitions` VALUES (2252, 7152, 2, 'Normal');
INSERT INTO `lang_definitions` VALUES (2253, 7164, 2, 'Normal:');
INSERT INTO `lang_definitions` VALUES (2254, 7177, 2, 'Alla fält är obligatoriska för alla nummer eller kod typer.');
INSERT INTO `lang_definitions` VALUES (2255, 7179, 2, 'Ej tillåtet');
INSERT INTO `lang_definitions` VALUES (2256, 7180, 2, 'Ej tillåtet att ta bort gruppen Administratörer');
INSERT INTO `lang_definitions` VALUES (2257, 7182, 2, 'Ej tillåtet att inaktivera alla trygghet objekt');
INSERT INTO `lang_definitions` VALUES (2258, 7183, 2, 'Ej tillåtet att inaktivera allt från Administratörer ACL');
INSERT INTO `lang_definitions` VALUES (2259, 7184, 2, 'Ej tillåtet att ta bort admin-användare från gruppen Administratörer');
INSERT INTO `lang_definitions` VALUES (2260, 7190, 2, 'Ej behörighet att nå PostCalendar modulen');
INSERT INTO `lang_definitions` VALUES (2261, 7210, 2, 'Inte undersökt');
INSERT INTO `lang_definitions` VALUES (2262, 7211, 2, 'Inte undersökt:');
INSERT INTO `lang_definitions` VALUES (2263, 7212, 2, 'Inte undersökt:');
INSERT INTO `lang_definitions` VALUES (2264, 7224, 2, 'Inte sett sedan');
INSERT INTO `lang_definitions` VALUES (2265, 7232, 2, 'kommentera');
INSERT INTO `lang_definitions` VALUES (2266, 7247, 2, 'Kommentartyp');
INSERT INTO `lang_definitions` VALUES (2267, 7256, 2, 'Anmärkning: Denna kod har inte förts in av en auktoriserad användare. Endast godkända koder kan laddas upp till Open Medical Billing nätverket för bearbetning. Om du vill ladda upp dessa nummer kan du välja en auktoriserad användare här.');
INSERT INTO `lang_definitions` VALUES (2268, 7260, 2, 'OBS: Överföra filer med duplikat namn gör att filerna automatiskt ska döpas. Till exempel \"<i> file.jpg </ i>\" blir \"<i> file.jpg.1 </ i>\". Filnamnen anses unika per patient, inte per kategori.');
INSERT INTO `lang_definitions` VALUES (2269, 7261, 2, 'Kommentarer');
INSERT INTO `lang_definitions` VALUES (2270, 7281, 2, 'Ingenting valdes');
INSERT INTO `lang_definitions` VALUES (2271, 7285, 2, 'MEDDELANDE: PostCalendar Inlämning / Modifiering');
INSERT INTO `lang_definitions` VALUES (2272, 7286, 2, 'Besked');
INSERT INTO `lang_definitions` VALUES (2273, 7293, 2, 'Meddela Admin Om Händelse Inlämning / Modifieringsförslag?');
INSERT INTO `lang_definitions` VALUES (2274, 7298, 2, 'November');
INSERT INTO `lang_definitions` VALUES (2275, 7311, 2, 'NPI');
INSERT INTO `lang_definitions` VALUES (2276, 7314, 2, 'Nummer');
INSERT INTO `lang_definitions` VALUES (2277, 7320, 2, 'Antal kolumner i år-vy.');
INSERT INTO `lang_definitions` VALUES (2278, 7354, 2, 'Status');
INSERT INTO `lang_definitions` VALUES (2279, 7363, 2, 'Yrke');
INSERT INTO `lang_definitions` VALUES (2280, 7366, 2, 'Förekomst');
INSERT INTO `lang_definitions` VALUES (2281, 7368, 2, 'Oktober');
INSERT INTO `lang_definitions` VALUES (2282, 7374, 2, 'tabletter');
INSERT INTO `lang_definitions` VALUES (2283, 7375, 2, 'i månaden per');
INSERT INTO `lang_definitions` VALUES (2284, 7384, 2, 'Mottagningskommentarer');
INSERT INTO `lang_definitions` VALUES (2285, 7385, 2, 'Mottagningsbesök');
INSERT INTO `lang_definitions` VALUES (2286, 7400, 2, 'Avkomma');
INSERT INTO `lang_definitions` VALUES (2287, 7404, 2, 'salva');
INSERT INTO `lang_definitions` VALUES (2288, 7406, 2, 'OK');
INSERT INTO `lang_definitions` VALUES (2289, 7412, 2, 'Gamla klienter');
INSERT INTO `lang_definitions` VALUES (2290, 7428, 2, 'underlåtit att autoassign');
INSERT INTO `lang_definitions` VALUES (2291, 7430, 2, 'på');
INSERT INTO `lang_definitions` VALUES (2292, 7436, 2, 'På Hand');
INSERT INTO `lang_definitions` VALUES (2293, 7439, 2, 'På beställning');
INSERT INTO `lang_definitions` VALUES (2294, 7462, 2, 'När du byter lösenord måste du logga in på nytt.');
INSERT INTO `lang_definitions` VALUES (2295, 7483, 2, 'Endast aktiva');
INSERT INTO `lang_definitions` VALUES (2296, 7488, 2, 'endast om faktureringsadress');
INSERT INTO `lang_definitions` VALUES (2297, 7490, 2, 'Endast Inaktiva');
INSERT INTO `lang_definitions` VALUES (2298, 7492, 2, 'Endast Min');
INSERT INTO `lang_definitions` VALUES (2299, 7504, 2, 'Uppkomsten av sjukdom:');
INSERT INTO `lang_definitions` VALUES (2300, 7505, 2, 'Uppkomsten av sjukdom:');
INSERT INTO `lang_definitions` VALUES (2301, 7506, 2, 'Uppkomsten av Svullnad:');
INSERT INTO `lang_definitions` VALUES (2302, 7510, 2, 'Debut / Inskrivning. Datum:');
INSERT INTO `lang_definitions` VALUES (2303, 7519, 2, 'Öppen');
INSERT INTO `lang_definitions` VALUES (2304, 7575, 2, 'OpenEMR kräver Javascript för att utföra användarverifiering.');
INSERT INTO `lang_definitions` VALUES (2305, 7586, 2, 'Alternativ');
INSERT INTO `lang_definitions` VALUES (2306, 7590, 2, 'Valfritt');
INSERT INTO `lang_definitions` VALUES (2307, 7602, 2, 'Frivillig information om denna händelse');
INSERT INTO `lang_definitions` VALUES (2308, 7605, 2, 'Valfri procedurkodkod');
INSERT INTO `lang_definitions` VALUES (2309, 7608, 2, 'ELLER');
INSERT INTO `lang_definitions` VALUES (2310, 7609, 2, 'Eller');
INSERT INTO `lang_definitions` VALUES (2311, 7610, 2, 'Eller välj');
INSERT INTO `lang_definitions` VALUES (2312, 7616, 2, 'Eller ladda upp ERA fil:');
INSERT INTO `lang_definitions` VALUES (2313, 7620, 2, 'Ordning');
INSERT INTO `lang_definitions` VALUES (2314, 7665, 2, 'Organskada');
INSERT INTO `lang_definitions` VALUES (2315, 7666, 2, 'Organisation');
INSERT INTO `lang_definitions` VALUES (2316, 7670, 2, 'Orienterad x 3');
INSERT INTO `lang_definitions` VALUES (2317, 7687, 2, 'P.O. (via munnen)');
INSERT INTO `lang_definitions` VALUES (2318, 7692, 2, 'Övrigt');
INSERT INTO `lang_definitions` VALUES (2319, 7693, 2, 'annan');
INSERT INTO `lang_definitions` VALUES (2320, 7702, 2, 'Andra skador inte specificerade på någon annan plats');
INSERT INTO `lang_definitions` VALUES (2321, 7705, 2, 'annan månad');
INSERT INTO `lang_definitions` VALUES (2322, 7706, 2, 'Andra icke-federala program');
INSERT INTO `lang_definitions` VALUES (2323, 7708, 2, 'Andra relevanta Symtom');
INSERT INTO `lang_definitions` VALUES (2324, 7709, 2, 'Andra relevanta Symtom:');
INSERT INTO `lang_definitions` VALUES (2325, 7715, 2, 'Andra kirurgiska');
INSERT INTO `lang_definitions` VALUES (2326, 7724, 2, 'OU');
INSERT INTO `lang_definitions` VALUES (2327, 7730, 2, 'Utfall');
INSERT INTO `lang_definitions` VALUES (2328, 7733, 2, 'Outlook');
INSERT INTO `lang_definitions` VALUES (2329, 7743, 2, 'Överutnyttjande');
INSERT INTO `lang_definitions` VALUES (2330, 7751, 2, 'vid behov');
INSERT INTO `lang_definitions` VALUES (2331, 7758, 2, 'Pedriatisk');
INSERT INTO `lang_definitions` VALUES (2332, 7762, 2, 'Sidor');
INSERT INTO `lang_definitions` VALUES (2333, 7763, 2, 'Betald');
INSERT INTO `lang_definitions` VALUES (2334, 7764, 2, 'Betalt belopp som du kommer att fördela');
INSERT INTO `lang_definitions` VALUES (2335, 7766, 2, 'Betalas via');
INSERT INTO `lang_definitions` VALUES (2336, 7790, 2, 'Partner');
INSERT INTO `lang_definitions` VALUES (2337, 7802, 2, 'Lösenord');
INSERT INTO `lang_definitions` VALUES (2338, 7803, 2, 'Ändra lösenord');
INSERT INTO `lang_definitions` VALUES (2339, 7812, 2, 'Lösenord för SMS Gateway');
INSERT INTO `lang_definitions` VALUES (2340, 7821, 2, 'Lösenord:');
INSERT INTO `lang_definitions` VALUES (2341, 7836, 2, 'Tidigare möten');
INSERT INTO `lang_definitions` VALUES (2342, 7837, 2, 'Tidigare möten och dokument');
INSERT INTO `lang_definitions` VALUES (2343, 7846, 2, 'Klistra in HL7 Data');
INSERT INTO `lang_definitions` VALUES (2344, 7872, 2, 'Patient Allergier');
INSERT INTO `lang_definitions` VALUES (2345, 7875, 2, 'Patient träff/bokning');
INSERT INTO `lang_definitions` VALUES (2346, 7882, 2, 'Patient diagram ID');
INSERT INTO `lang_definitions` VALUES (2347, 7897, 2, 'Patientdata');
INSERT INTO `lang_definitions` VALUES (2348, 7907, 2, 'Patientdokument');
INSERT INTO `lang_definitions` VALUES (2349, 7915, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (2350, 7916, 2, 'Patientmötesformulär');
INSERT INTO `lang_definitions` VALUES (2351, 7917, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (2352, 7918, 2, 'Patientsök');
INSERT INTO `lang_definitions` VALUES (2353, 7932, 2, 'Patienthistoria');
INSERT INTO `lang_definitions` VALUES (2354, 7933, 2, 'Patientens historia / Livsstil');
INSERT INTO `lang_definitions` VALUES (2355, 7935, 2, 'Patient-ID');
INSERT INTO `lang_definitions` VALUES (2356, 7941, 2, 'Patient -vaccination');
INSERT INTO `lang_definitions` VALUES (2357, 7945, 2, 'Ej tilldelad!');
INSERT INTO `lang_definitions` VALUES (2358, 7949, 2, 'Patient -problem');
INSERT INTO `lang_definitions` VALUES (2359, 7958, 2, 'Patientlista');
INSERT INTO `lang_definitions` VALUES (2360, 7967, 2, 'Patientens medicinska problem');
INSERT INTO `lang_definitions` VALUES (2361, 7968, 2, 'Patient -Mediciner');
INSERT INTO `lang_definitions` VALUES (2362, 7976, 2, 'Patient: Namn och Adress');
INSERT INTO `lang_definitions` VALUES (2363, 7983, 2, 'Patientanteckning, typ');
INSERT INTO `lang_definitions` VALUES (2364, 7984, 2, 'Patient -kommentarer');
INSERT INTO `lang_definitions` VALUES (2365, 7987, 2, 'Patientnummer');
INSERT INTO `lang_definitions` VALUES (2366, 8005, 2, 'Patient -Journalrapport');
INSERT INTO `lang_definitions` VALUES (2367, 8020, 2, 'Patientrapport');
INSERT INTO `lang_definitions` VALUES (2368, 8024, 2, 'Patientförfrågan');
INSERT INTO `lang_definitions` VALUES (2369, 8046, 2, 'Patient -Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2370, 8049, 2, 'Patient -Remisser m.m.');
INSERT INTO `lang_definitions` VALUES (2371, 8057, 2, 'Patient / Klient');
INSERT INTO `lang_definitions` VALUES (2372, 8058, 2, 'Patient:');
INSERT INTO `lang_definitions` VALUES (2373, 8061, 2, 'Patienter');
INSERT INTO `lang_definitions` VALUES (2374, 8067, 2, 'Betala');
INSERT INTO `lang_definitions` VALUES (2375, 8071, 2, 'Betalningsdatum:');
INSERT INTO `lang_definitions` VALUES (2376, 8077, 2, 'Betalare');
INSERT INTO `lang_definitions` VALUES (2377, 8082, 2, 'Betalare Typ');
INSERT INTO `lang_definitions` VALUES (2378, 8083, 2, 'Utbetalande');
INSERT INTO `lang_definitions` VALUES (2379, 8086, 2, 'Betalning');
INSERT INTO `lang_definitions` VALUES (2380, 8094, 2, 'Betalningsdatum');
INSERT INTO `lang_definitions` VALUES (2381, 8101, 2, 'Betalningsmetod');
INSERT INTO `lang_definitions` VALUES (2382, 8112, 2, 'Betalning värde för kod');
INSERT INTO `lang_definitions` VALUES (2383, 8115, 2, 'Betalningar');
INSERT INTO `lang_definitions` VALUES (2384, 8141, 2, 'Oavslutad');
INSERT INTO `lang_definitions` VALUES (2385, 8147, 2, 'Oklart');
INSERT INTO `lang_definitions` VALUES (2386, 8160, 2, 'via näsborre');
INSERT INTO `lang_definitions` VALUES (2387, 8161, 2, 'via näsborre');
INSERT INTO `lang_definitions` VALUES (2388, 8164, 2, 'Rektalt');
INSERT INTO `lang_definitions` VALUES (2389, 8165, 2, 'rektalt');
INSERT INTO `lang_definitions` VALUES (2390, 8172, 2, 'Utför sökning');
INSERT INTO `lang_definitions` VALUES (2391, 8173, 2, 'Utför åtgärden');
INSERT INTO `lang_definitions` VALUES (2392, 8197, 2, 'Apotek');
INSERT INTO `lang_definitions` VALUES (2393, 8199, 2, 'Patient Insurance Distribution');
INSERT INTO `lang_definitions` VALUES (2394, 8208, 2, 'Pheumothorax');
INSERT INTO `lang_definitions` VALUES (2395, 8217, 2, 'Telefon');
INSERT INTO `lang_definitions` VALUES (2396, 8219, 2, 'Telefon samtalslistan');
INSERT INTO `lang_definitions` VALUES (2397, 8231, 2, 'Telefonnummer');
INSERT INTO `lang_definitions` VALUES (2398, 8243, 2, 'Hälsokontroll');
INSERT INTO `lang_definitions` VALUES (2399, 8245, 2, 'Läkares Begäran');
INSERT INTO `lang_definitions` VALUES (2400, 8246, 2, 'Läkares Underskrift');
INSERT INTO `lang_definitions` VALUES (2401, 8249, 2, 'Läkare');
INSERT INTO `lang_definitions` VALUES (2402, 8253, 2, 'välj');
INSERT INTO `lang_definitions` VALUES (2403, 8261, 2, 'Tablett Storlek');
INSERT INTO `lang_definitions` VALUES (2404, 8262, 2, 'Tabletter');
INSERT INTO `lang_definitions` VALUES (2405, 8276, 2, 'Vanlig text');
INSERT INTO `lang_definitions` VALUES (2406, 8277, 2, 'Planering');
INSERT INTO `lang_definitions` VALUES (2407, 8282, 2, 'Planering namn');
INSERT INTO `lang_definitions` VALUES (2408, 8293, 2, 'Planering:');
INSERT INTO `lang_definitions` VALUES (2409, 8296, 2, 'Planering');
INSERT INTO `lang_definitions` VALUES (2410, 8298, 2, 'Spelare');
INSERT INTO `lang_definitions` VALUES (2411, 8299, 2, 'Position');
INSERT INTO `lang_definitions` VALUES (2412, 8310, 2, 'Välj ett värde för');
INSERT INTO `lang_definitions` VALUES (2413, 8316, 2, 'Stäng detta fönster');
INSERT INTO `lang_definitions` VALUES (2414, 8317, 2, 'Jämför det nya namnet');
INSERT INTO `lang_definitions` VALUES (2415, 8386, 2, 'Vänligen använ endast alfabetiska tecken');
INSERT INTO `lang_definitions` VALUES (2416, 8387, 2, 'Vänligen använd endast alfabetiska tecken utan mellanslag');
INSERT INTO `lang_definitions` VALUES (2417, 8388, 2, 'Vänligen betala detta belopp');
INSERT INTO `lang_definitions` VALUES (2418, 8417, 2, 'Välj en händelse');
INSERT INTO `lang_definitions` VALUES (2419, 8459, 2, 'EM');
INSERT INTO `lang_definitions` VALUES (2420, 8473, 2, 'Lunginflammations Vaccination');
INSERT INTO `lang_definitions` VALUES (2421, 8481, 2, 'Förhållningssätt');
INSERT INTO `lang_definitions` VALUES (2422, 8489, 2, 'Polyper');
INSERT INTO `lang_definitions` VALUES (2423, 8491, 2, 'Dålig apptit');
INSERT INTO `lang_definitions` VALUES (2424, 8492, 2, 'Dålig cirkulation');
INSERT INTO `lang_definitions` VALUES (2425, 8493, 2, 'Dålig hörsel');
INSERT INTO `lang_definitions` VALUES (2426, 8499, 2, 'Popup-fönster');
INSERT INTO `lang_definitions` VALUES (2427, 8550, 2, 'Postnr');
INSERT INTO `lang_definitions` VALUES (2428, 8551, 2, 'Postnummer');
INSERT INTO `lang_definitions` VALUES (2429, 8565, 2, 'Överförings Datum');
INSERT INTO `lang_definitions` VALUES (2430, 8576, 2, 'Practice');
INSERT INTO `lang_definitions` VALUES (2431, 8595, 2, 'Graviditets test');
INSERT INTO `lang_definitions` VALUES (2432, 8598, 2, 'Förskottsbetalning');
INSERT INTO `lang_definitions` VALUES (2433, 8606, 2, 'Receptbelagda märken');
INSERT INTO `lang_definitions` VALUES (2434, 8610, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2435, 8613, 2, 'Föreskrifter och dispenser');
INSERT INTO `lang_definitions` VALUES (2436, 8614, 2, 'Recept och andra råd');
INSERT INTO `lang_definitions` VALUES (2437, 8615, 2, 'Recept och andra råd av specialist');
INSERT INTO `lang_definitions` VALUES (2438, 8617, 2, 'recept rapport');
INSERT INTO `lang_definitions` VALUES (2439, 8619, 2, 'Recept/råd');
INSERT INTO `lang_definitions` VALUES (2440, 8622, 2, 'Presentera Klagomål');
INSERT INTO `lang_definitions` VALUES (2441, 8624, 2, 'Tryck på fortsätt för att fortsätta');
INSERT INTO `lang_definitions` VALUES (2442, 8627, 2, 'Förmodad diagnos');
INSERT INTO `lang_definitions` VALUES (2443, 8628, 2, 'Förmodad diagnos från specialist');
INSERT INTO `lang_definitions` VALUES (2444, 8629, 2, 'Föregående');
INSERT INTO `lang_definitions` VALUES (2445, 8642, 2, 'Föregående');
INSERT INTO `lang_definitions` VALUES (2446, 8644, 2, 'Föregående konsultation');
INSERT INTO `lang_definitions` VALUES (2447, 8645, 2, 'Föregående dag');
INSERT INTO `lang_definitions` VALUES (2448, 8648, 2, 'Föregående månad');
INSERT INTO `lang_definitions` VALUES (2449, 8651, 2, 'Föregående vecka');
INSERT INTO `lang_definitions` VALUES (2450, 8652, 2, 'Pris');
INSERT INTO `lang_definitions` VALUES (2451, 8656, 2, 'Prisnivå');
INSERT INTO `lang_definitions` VALUES (2452, 8658, 2, 'Prisnivå:');
INSERT INTO `lang_definitions` VALUES (2453, 8661, 2, 'Primär');
INSERT INTO `lang_definitions` VALUES (2454, 8674, 2, 'Primära Försäkring');
INSERT INTO `lang_definitions` VALUES (2455, 8675, 2, 'Primära Försäkrings Data');
INSERT INTO `lang_definitions` VALUES (2456, 8676, 2, 'Primär försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2457, 8678, 2, 'Skriv ut');
INSERT INTO `lang_definitions` VALUES (2458, 8683, 2, 'Printa blankt remissformulär');
INSERT INTO `lang_definitions` VALUES (2459, 8697, 2, 'Skriv ut flera');
INSERT INTO `lang_definitions` VALUES (2460, 8717, 2, 'Skriv ut denna anmärkning');
INSERT INTO `lang_definitions` VALUES (2461, 8718, 2, 'Skriv ut Denna Anmärkning');
INSERT INTO `lang_definitions` VALUES (2462, 8722, 2, 'Utskrivbar');
INSERT INTO `lang_definitions` VALUES (2463, 8723, 2, 'Utskriftsversion');
INSERT INTO `lang_definitions` VALUES (2464, 8728, 2, 'Skriva ut resultat:');
INSERT INTO `lang_definitions` VALUES (2465, 8743, 2, 'Prioritet');
INSERT INTO `lang_definitions` VALUES (2466, 8747, 2, 'Privat');
INSERT INTO `lang_definitions` VALUES (2467, 8755, 2, 'Problem/anledningar');
INSERT INTO `lang_definitions` VALUES (2468, 8762, 2, 'Förfarande');
INSERT INTO `lang_definitions` VALUES (2469, 8807, 2, 'Förfarande');
INSERT INTO `lang_definitions` VALUES (2470, 8810, 2, 'Process');
INSERT INTO `lang_definitions` VALUES (2471, 8823, 2, 'Bearbetning');
INSERT INTO `lang_definitions` VALUES (2472, 8838, 2, 'Produkter');
INSERT INTO `lang_definitions` VALUES (2473, 8841, 2, 'Prof.');
INSERT INTO `lang_definitions` VALUES (2474, 8858, 2, 'Prostata Cancer');
INSERT INTO `lang_definitions` VALUES (2475, 8860, 2, 'Prostata undersökning');
INSERT INTO `lang_definitions` VALUES (2476, 8861, 2, 'Prostata problem');
INSERT INTO `lang_definitions` VALUES (2477, 8881, 2, 'Vårdgivare');
INSERT INTO `lang_definitions` VALUES (2478, 8886, 2, 'Vårdgivare ID');
INSERT INTO `lang_definitions` VALUES (2479, 8887, 2, 'Vårdgivare ID');
INSERT INTO `lang_definitions` VALUES (2480, 8888, 2, 'Vårdgivare ID på specificerad klinik');
INSERT INTO `lang_definitions` VALUES (2481, 8889, 2, 'Kan ej matcha vårdgivare');
INSERT INTO `lang_definitions` VALUES (2482, 8895, 2, 'Vårdgivare, nummmer');
INSERT INTO `lang_definitions` VALUES (2483, 8902, 2, 'Vårdgivare:');
INSERT INTO `lang_definitions` VALUES (2484, 8903, 2, 'Vårdgivare:');
INSERT INTO `lang_definitions` VALUES (2485, 8908, 2, 'PSA');
INSERT INTO `lang_definitions` VALUES (2486, 8910, 2, 'Psoriasis');
INSERT INTO `lang_definitions` VALUES (2487, 8912, 2, 'Psykisk diagnos');
INSERT INTO `lang_definitions` VALUES (2488, 8913, 2, 'Psykiatrisk mediciinering');
INSERT INTO `lang_definitions` VALUES (2489, 8914, 2, 'Psykiatrisk mediciinering');
INSERT INTO `lang_definitions` VALUES (2490, 8965, 2, 'Puls');
INSERT INTO `lang_definitions` VALUES (2491, 8977, 2, 'Var 3:e timme');
INSERT INTO `lang_definitions` VALUES (2492, 8978, 2, 'Var 4:e timme');
INSERT INTO `lang_definitions` VALUES (2493, 8979, 2, 'Var 5:e timme');
INSERT INTO `lang_definitions` VALUES (2494, 8980, 2, 'Var 6:e timme');
INSERT INTO `lang_definitions` VALUES (2495, 8981, 2, 'Var 8:e timme');
INSERT INTO `lang_definitions` VALUES (2496, 8982, 2, '1 ggr/dag');
INSERT INTO `lang_definitions` VALUES (2497, 8983, 2, '4ggr/dag');
INSERT INTO `lang_definitions` VALUES (2498, 8990, 2, 'Antal');
INSERT INTO `lang_definitions` VALUES (2499, 8991, 2, 'Kvalitet');
INSERT INTO `lang_definitions` VALUES (2500, 8993, 2, 'Kvantitet');
INSERT INTO `lang_definitions` VALUES (2501, 8996, 2, 'Kvantitet för NDC');
INSERT INTO `lang_definitions` VALUES (2502, 9010, 2, 'köad');
INSERT INTO `lang_definitions` VALUES (2503, 9011, 2, 'Kö Evenemang Administration');
INSERT INTO `lang_definitions` VALUES (2504, 9012, 2, 'köad för');
INSERT INTO `lang_definitions` VALUES (2505, 9014, 2, 'Kö föreläggande Administration');
INSERT INTO `lang_definitions` VALUES (2506, 9026, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2507, 9027, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2508, 9028, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2509, 9030, 2, 'Radio');
INSERT INTO `lang_definitions` VALUES (2510, 9031, 2, 'Radioknapp');
INSERT INTO `lang_definitions` VALUES (2511, 9038, 2, 'Utslag');
INSERT INTO `lang_definitions` VALUES (2512, 9039, 2, 'Betygsätta');
INSERT INTO `lang_definitions` VALUES (2513, 9041, 2, 'Andel');
INSERT INTO `lang_definitions` VALUES (2514, 9057, 2, 'Åter öppnas');
INSERT INTO `lang_definitions` VALUES (2515, 9062, 2, 'Reaktioner');
INSERT INTO `lang_definitions` VALUES (2516, 9072, 2, 'Riktigt namn');
INSERT INTO `lang_definitions` VALUES (2517, 9075, 2, 'Anledning');
INSERT INTO `lang_definitions` VALUES (2518, 9076, 2, 'Orsak till avslutande');
INSERT INTO `lang_definitions` VALUES (2519, 9079, 2, 'Anledning till remiss');
INSERT INTO `lang_definitions` VALUES (2520, 9081, 2, 'Anledning till besök');
INSERT INTO `lang_definitions` VALUES (2521, 9084, 2, 'Orsak / Form');
INSERT INTO `lang_definitions` VALUES (2522, 9099, 2, 'Kvitto');
INSERT INTO `lang_definitions` VALUES (2523, 9100, 2, 'Kvitto för betalning');
INSERT INTO `lang_definitions` VALUES (2524, 9103, 2, 'Kvitton Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2525, 9104, 2, 'Mottagna');
INSERT INTO `lang_definitions` VALUES (2526, 9105, 2, 'Mottagna av');
INSERT INTO `lang_definitions` VALUES (2527, 9106, 2, 'Mottagna fax');
INSERT INTO `lang_definitions` VALUES (2528, 9110, 2, 'Mottagare');
INSERT INTO `lang_definitions` VALUES (2529, 9111, 2, 'Mottagare ID');
INSERT INTO `lang_definitions` VALUES (2530, 9131, 2, 'Rekomendationer');
INSERT INTO `lang_definitions` VALUES (2531, 9132, 2, 'Rekomendationer och behandling');
INSERT INTO `lang_definitions` VALUES (2532, 9133, 2, 'Rekomendationer av specialist');
INSERT INTO `lang_definitions` VALUES (2533, 9176, 2, 'reduceras:');
INSERT INTO `lang_definitions` VALUES (2534, 9179, 2, 'Remitera');
INSERT INTO `lang_definitions` VALUES (2535, 9180, 2, 'Remiterad av');
INSERT INTO `lang_definitions` VALUES (2536, 9181, 2, 'Remissdatum');
INSERT INTO `lang_definitions` VALUES (2537, 9182, 2, 'Remiteras till');
INSERT INTO `lang_definitions` VALUES (2538, 9185, 2, 'Prioritetsnivå (Risknivå)');
INSERT INTO `lang_definitions` VALUES (2539, 9187, 2, 'Orsak till remiss');
INSERT INTO `lang_definitions` VALUES (2540, 9194, 2, 'Remittent, namn och signatur');
INSERT INTO `lang_definitions` VALUES (2541, 9195, 2, 'Remiss');
INSERT INTO `lang_definitions` VALUES (2542, 9196, 2, 'Remitterad av');
INSERT INTO `lang_definitions` VALUES (2543, 9197, 2, 'Remisskort');
INSERT INTO `lang_definitions` VALUES (2544, 9198, 2, 'Remissdadum');
INSERT INTO `lang_definitions` VALUES (2545, 9199, 2, 'Remissformulär');
INSERT INTO `lang_definitions` VALUES (2546, 9200, 2, 'REMISSFORMULÄR');
INSERT INTO `lang_definitions` VALUES (2547, 9204, 2, 'Remisskälla');
INSERT INTO `lang_definitions` VALUES (2548, 9206, 2, 'Remitteras till');
INSERT INTO `lang_definitions` VALUES (2549, 9207, 2, 'remittering');
INSERT INTO `lang_definitions` VALUES (2550, 9208, 2, 'remiss');
INSERT INTO `lang_definitions` VALUES (2551, 9209, 2, 'Remiterats från');
INSERT INTO `lang_definitions` VALUES (2552, 9210, 2, 'Remiterats från');
INSERT INTO `lang_definitions` VALUES (2553, 9213, 2, 'Remitterats till');
INSERT INTO `lang_definitions` VALUES (2554, 9214, 2, 'Remiterats av');
INSERT INTO `lang_definitions` VALUES (2555, 9225, 2, 'Påfyllnad');
INSERT INTO `lang_definitions` VALUES (2556, 9226, 2, 'påfyllnad');
INSERT INTO `lang_definitions` VALUES (2557, 9227, 2, 'Reflexer normala');
INSERT INTO `lang_definitions` VALUES (2558, 9231, 2, 'Uppdatera');
INSERT INTO `lang_definitions` VALUES (2559, 9249, 2, 'Registrerad');
INSERT INTO `lang_definitions` VALUES (2560, 9250, 2, 'registrerade');
INSERT INTO `lang_definitions` VALUES (2561, 9255, 2, 'Registreringsdag');
INSERT INTO `lang_definitions` VALUES (2562, 9259, 2, 'Rehabilitering');
INSERT INTO `lang_definitions` VALUES (2563, 9264, 2, 'Relaterat');
INSERT INTO `lang_definitions` VALUES (2564, 9270, 2, 'Förhållande');
INSERT INTO `lang_definitions` VALUES (2565, 9272, 2, 'Anhöriga');
INSERT INTO `lang_definitions` VALUES (2566, 9288, 2, 'Religion');
INSERT INTO `lang_definitions` VALUES (2567, 9293, 2, 'Relogin');
INSERT INTO `lang_definitions` VALUES (2568, 9321, 2, 'Ta bort grupp');
INSERT INTO `lang_definitions` VALUES (2569, 9350, 2, 'Upprepar');
INSERT INTO `lang_definitions` VALUES (2570, 9362, 2, 'Svars Datum');
INSERT INTO `lang_definitions` VALUES (2571, 9365, 2, 'Rapport');
INSERT INTO `lang_definitions` VALUES (2572, 9390, 2, 'Rapporter');
INSERT INTO `lang_definitions` VALUES (2573, 9415, 2, 'Nödvändig');
INSERT INTO `lang_definitions` VALUES (2574, 9428, 2, 'RESERVERAD');
INSERT INTO `lang_definitions` VALUES (2575, 9429, 2, 'reserverad');
INSERT INTO `lang_definitions` VALUES (2576, 9449, 2, 'Löst');
INSERT INTO `lang_definitions` VALUES (2577, 9465, 2, 'Begränsat Utbildning');
INSERT INTO `lang_definitions` VALUES (2578, 9466, 2, 'Resultat');
INSERT INTO `lang_definitions` VALUES (2579, 9485, 2, 'Infällda Höger:');
INSERT INTO `lang_definitions` VALUES (2580, 9486, 2, 'Avkastning');
INSERT INTO `lang_definitions` VALUES (2581, 9497, 2, 'Returvärde');
INSERT INTO `lang_definitions` VALUES (2582, 9498, 2, 'Återresa');
INSERT INTO `lang_definitions` VALUES (2583, 9521, 2, 'Översyn av System Kontroller');
INSERT INTO `lang_definitions` VALUES (2584, 9527, 2, 'Revision');
INSERT INTO `lang_definitions` VALUES (2585, 9533, 2, 'Höger');
INSERT INTO `lang_definitions` VALUES (2586, 9536, 2, 'Höger öra');
INSERT INTO `lang_definitions` VALUES (2587, 9537, 2, 'höger öra');
INSERT INTO `lang_definitions` VALUES (2588, 9545, 2, 'Höger:');
INSERT INTO `lang_definitions` VALUES (2589, 9546, 2, 'Ringningar i öron');
INSERT INTO `lang_definitions` VALUES (2590, 9547, 2, 'Tinitus');
INSERT INTO `lang_definitions` VALUES (2591, 9571, 2, 'Rutt');
INSERT INTO `lang_definitions` VALUES (2592, 9574, 2, 'Rader');
INSERT INTO `lang_definitions` VALUES (2593, 9577, 2, 'Massera:');
INSERT INTO `lang_definitions` VALUES (2594, 9578, 2, 'Gnuggar:');
INSERT INTO `lang_definitions` VALUES (2595, 9595, 2, 'Kör kommando:');
INSERT INTO `lang_definitions` VALUES (2596, 9601, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2597, 9602, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2598, 9634, 2, 'K');
INSERT INTO `lang_definitions` VALUES (2599, 9635, 2, 'Personnr');
INSERT INTO `lang_definitions` VALUES (2600, 9645, 2, 'Samma dag');
INSERT INTO `lang_definitions` VALUES (2601, 9648, 2, 'Sanktions Typ');
INSERT INTO `lang_definitions` VALUES (2602, 9653, 2, 'Lördag');
INSERT INTO `lang_definitions` VALUES (2603, 9654, 2, 'Lördag & söndag');
INSERT INTO `lang_definitions` VALUES (2604, 9655, 2, 'Lördag');
INSERT INTO `lang_definitions` VALUES (2605, 9656, 2, 'Spara');
INSERT INTO `lang_definitions` VALUES (2606, 9665, 2, 'Spara och fördela');
INSERT INTO `lang_definitions` VALUES (2607, 9668, 2, 'Spara som ny');
INSERT INTO `lang_definitions` VALUES (2608, 9674, 2, 'Spara ändringar');
INSERT INTO `lang_definitions` VALUES (2609, 9683, 2, 'Spara vaccination');
INSERT INTO `lang_definitions` VALUES (2610, 9698, 2, 'Spara transaktionen');
INSERT INTO `lang_definitions` VALUES (2611, 9707, 2, 'Inskannade');
INSERT INTO `lang_definitions` VALUES (2612, 9713, 2, 'Schema');
INSERT INTO `lang_definitions` VALUES (2613, 9731, 2, 'Skolios');
INSERT INTO `lang_definitions` VALUES (2614, 9744, 2, 'SE');
INSERT INTO `lang_definitions` VALUES (2615, 9745, 2, 'SE Adress');
INSERT INTO `lang_definitions` VALUES (2616, 9747, 2, 'SE Stad');
INSERT INTO `lang_definitions` VALUES (2617, 9748, 2, 'SE Land');
INSERT INTO `lang_definitions` VALUES (2618, 9753, 2, 'Söka');
INSERT INTO `lang_definitions` VALUES (2619, 9755, 2, 'söka');
INSERT INTO `lang_definitions` VALUES (2620, 9756, 2, 'Sök igen');
INSERT INTO `lang_definitions` VALUES (2621, 9762, 2, 'Sök efter:');
INSERT INTO `lang_definitions` VALUES (2622, 9769, 2, 'Sök efter:');
INSERT INTO `lang_definitions` VALUES (2623, 9777, 2, 'Sök efter eller lägg till patient');
INSERT INTO `lang_definitions` VALUES (2624, 9784, 2, 'Sökresultat:');
INSERT INTO `lang_definitions` VALUES (2625, 9791, 2, 'Sök i Evenemang');
INSERT INTO `lang_definitions` VALUES (2626, 9796, 2, 'Sök / Lägg till försäkringsgivaren');
INSERT INTO `lang_definitions` VALUES (2627, 9802, 2, 'Bilbältesanvändning');
INSERT INTO `lang_definitions` VALUES (2628, 9803, 2, 'Andra');
INSERT INTO `lang_definitions` VALUES (2629, 9807, 2, 'Sekundär');
INSERT INTO `lang_definitions` VALUES (2630, 9809, 2, 'Sekundär Försäkring');
INSERT INTO `lang_definitions` VALUES (2631, 9810, 2, 'Sekundär Försäkrings Data');
INSERT INTO `lang_definitions` VALUES (2632, 9827, 2, 'Se Alla');
INSERT INTO `lang_definitions` VALUES (2633, 9829, 2, 'Se Auktoriseringar');
INSERT INTO `lang_definitions` VALUES (2634, 9837, 2, 'Sett sedan');
INSERT INTO `lang_definitions` VALUES (2635, 9844, 2, 'Välj');
INSERT INTO `lang_definitions` VALUES (2636, 9859, 2, 'Välj Alla');
INSERT INTO `lang_definitions` VALUES (2637, 9971, 2, 'Selecionar usuários da lista suspensa');
INSERT INTO `lang_definitions` VALUES (2638, 9989, 2, 'Egen lön');
INSERT INTO `lang_definitions` VALUES (2639, 10001, 2, 'Överföring pågår');
INSERT INTO `lang_definitions` VALUES (2640, 10027, 2, 'Avsändare');
INSERT INTO `lang_definitions` VALUES (2641, 10028, 2, 'Avsändar ID');
INSERT INTO `lang_definitions` VALUES (2642, 10046, 2, 'Känslighet:');
INSERT INTO `lang_definitions` VALUES (2643, 10055, 2, 'Skickats');
INSERT INTO `lang_definitions` VALUES (2644, 10058, 2, 'skickas till skrivaren.');
INSERT INTO `lang_definitions` VALUES (2645, 10065, 2, 'Separerade');
INSERT INTO `lang_definitions` VALUES (2646, 10066, 2, 'September');
INSERT INTO `lang_definitions` VALUES (2647, 10088, 2, 'Service Datum:');
INSERT INTO `lang_definitions` VALUES (2648, 10092, 2, 'Service Location');
INSERT INTO `lang_definitions` VALUES (2649, 10098, 2, 'Tjänster');
INSERT INTO `lang_definitions` VALUES (2650, 10099, 2, 'Tjänster efter kategori');
INSERT INTO `lang_definitions` VALUES (2651, 10100, 2, 'Tjänster som Tillhandahålls');
INSERT INTO `lang_definitions` VALUES (2652, 10101, 2, 'Tjänster som tillhandahålls');
INSERT INTO `lang_definitions` VALUES (2653, 10125, 2, 'Inställningar');
INSERT INTO `lang_definitions` VALUES (2654, 10132, 2, 'Svår huvudvärk');
INSERT INTO `lang_definitions` VALUES (2655, 10135, 2, 'Svårighetsgrad av smärta');
INSERT INTO `lang_definitions` VALUES (2656, 10136, 2, 'Svårighetsgrad av smärta:');
INSERT INTO `lang_definitions` VALUES (2657, 10137, 2, 'Kön');
INSERT INTO `lang_definitions` VALUES (2658, 10138, 2, 'Sexuellt överförbara sjukdomar');
INSERT INTO `lang_definitions` VALUES (2659, 10148, 2, 'Dela');
INSERT INTO `lang_definitions` VALUES (2660, 10156, 2, 'Andnöd');
INSERT INTO `lang_definitions` VALUES (2661, 10162, 2, 'bör vara som nnnnn-nnnn-nn');
INSERT INTO `lang_definitions` VALUES (2662, 10166, 2, 'Axel');
INSERT INTO `lang_definitions` VALUES (2663, 10167, 2, 'Axel + nyckelben');
INSERT INTO `lang_definitions` VALUES (2664, 10168, 2, 'Axelproblem');
INSERT INTO `lang_definitions` VALUES (2665, 10169, 2, 'visa');
INSERT INTO `lang_definitions` VALUES (2666, 10178, 2, 'Visa som upptagen');
INSERT INTO `lang_definitions` VALUES (2667, 10179, 2, 'Visa endast behöriga');
INSERT INTO `lang_definitions` VALUES (2668, 10186, 2, 'Visa detaljer');
INSERT INTO `lang_definitions` VALUES (2669, 10220, 2, 'Visa rapport');
INSERT INTO `lang_definitions` VALUES (2670, 10233, 2, 'Visa endast icke fakturerad');
INSERT INTO `lang_definitions` VALUES (2671, 10249, 2, 'Syskon');
INSERT INTO `lang_definitions` VALUES (2672, 10260, 2, 'Underskrift');
INSERT INTO `lang_definitions` VALUES (2673, 10263, 2, 'Underskrift:');
INSERT INTO `lang_definitions` VALUES (2674, 10268, 2, 'Betydande Svullnad:');
INSERT INTO `lang_definitions` VALUES (2675, 10278, 2, 'Singel');
INSERT INTO `lang_definitions` VALUES (2676, 10300, 2, 'Storlek');
INSERT INTO `lang_definitions` VALUES (2677, 10305, 2, 'Storlek / Lista');
INSERT INTO `lang_definitions` VALUES (2678, 10307, 2, 'Hud');
INSERT INTO `lang_definitions` VALUES (2679, 10322, 2, 'sömn mönster');
INSERT INTO `lang_definitions` VALUES (2680, 10323, 2, 'sover');
INSERT INTO `lang_definitions` VALUES (2681, 10386, 2, 'Social History:');
INSERT INTO `lang_definitions` VALUES (2682, 10389, 2, 'lösning');
INSERT INTO `lang_definitions` VALUES (2683, 10394, 2, 'Vissa möten visas inte. Klicka här för att visa alla.');
INSERT INTO `lang_definitions` VALUES (2684, 10397, 2, 'Vissa anteckningar visades inte');
INSERT INTO `lang_definitions` VALUES (2685, 10400, 2, 'några ord');
INSERT INTO `lang_definitions` VALUES (2686, 10417, 2, 'Sortera efter');
INSERT INTO `lang_definitions` VALUES (2687, 10438, 2, 'Källa');
INSERT INTO `lang_definitions` VALUES (2688, 10442, 2, 'Källa saknas för kod');
INSERT INTO `lang_definitions` VALUES (2689, 10448, 2, 'Källa:');
INSERT INTO `lang_definitions` VALUES (2690, 10461, 2, 'Specialist namn och signatur');
INSERT INTO `lang_definitions` VALUES (2691, 10463, 2, 'Specialtet');
INSERT INTO `lang_definitions` VALUES (2692, 10466, 2, 'Specialitet:');
INSERT INTO `lang_definitions` VALUES (2693, 10467, 2, 'Särskilda');
INSERT INTO `lang_definitions` VALUES (2694, 10471, 2, 'Särskilda tjänster');
INSERT INTO `lang_definitions` VALUES (2695, 10488, 2, 'Tal diktamen');
INSERT INTO `lang_definitions` VALUES (2696, 10489, 2, 'Spermiedödande');
INSERT INTO `lang_definitions` VALUES (2697, 10505, 2, 'Maka');
INSERT INTO `lang_definitions` VALUES (2698, 10508, 2, 'Sputum:');
INSERT INTO `lang_definitions` VALUES (2699, 10524, 2, 'Personnummmer');
INSERT INTO `lang_definitions` VALUES (2700, 10526, 2, 'Persnr');
INSERT INTO `lang_definitions` VALUES (2701, 10527, 2, 'Stabilitet');
INSERT INTO `lang_definitions` VALUES (2702, 10530, 2, 'Standard');
INSERT INTO `lang_definitions` VALUES (2703, 10541, 2, 'Start');
INSERT INTO `lang_definitions` VALUES (2704, 10542, 2, 'Start (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (2705, 10549, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (2706, 10551, 2, 'Start datum vid denna klinik');
INSERT INTO `lang_definitions` VALUES (2707, 10553, 2, 'Startdatum:');
INSERT INTO `lang_definitions` VALUES (2708, 10554, 2, 'Startdatum:');
INSERT INTO `lang_definitions` VALUES (2709, 10556, 2, 'Start tid');
INSERT INTO `lang_definitions` VALUES (2710, 10559, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (2711, 10564, 2, 'Stat');
INSERT INTO `lang_definitions` VALUES (2712, 10573, 2, 'församling');
INSERT INTO `lang_definitions` VALUES (2713, 10584, 2, 'Statistik');
INSERT INTO `lang_definitions` VALUES (2714, 10585, 2, 'Övrigt');
INSERT INTO `lang_definitions` VALUES (2715, 10586, 2, 'Status');
INSERT INTO `lang_definitions` VALUES (2716, 10591, 2, 'Oförändrat');
INSERT INTO `lang_definitions` VALUES (2717, 10607, 2, 'Stela leder');
INSERT INTO `lang_definitions` VALUES (2718, 10611, 2, 'Ont i magen');
INSERT INTO `lang_definitions` VALUES (2719, 10619, 2, 'Överbelastade muskler');
INSERT INTO `lang_definitions` VALUES (2720, 10622, 2, 'Gata');
INSERT INTO `lang_definitions` VALUES (2721, 10625, 2, 'Gatu nummer');
INSERT INTO `lang_definitions` VALUES (2722, 10626, 2, 'styrka');
INSERT INTO `lang_definitions` VALUES (2723, 10629, 2, 'Stress fraktur');
INSERT INTO `lang_definitions` VALUES (2724, 10630, 2, 'Stresstest');
INSERT INTO `lang_definitions` VALUES (2725, 10632, 2, 'Stroke');
INSERT INTO `lang_definitions` VALUES (2726, 10642, 2, 'Delsumma');
INSERT INTO `lang_definitions` VALUES (2727, 10643, 2, 'Underkategori');
INSERT INTO `lang_definitions` VALUES (2728, 10644, 2, 'underkategori');
INSERT INTO `lang_definitions` VALUES (2729, 10645, 2, 'subkutant');
INSERT INTO `lang_definitions` VALUES (2730, 10647, 2, 'Anamnes');
INSERT INTO `lang_definitions` VALUES (2731, 10648, 2, 'Sublingual');
INSERT INTO `lang_definitions` VALUES (2732, 10649, 2, 'sublingual');
INSERT INTO `lang_definitions` VALUES (2733, 10650, 2, 'Lämna in');
INSERT INTO `lang_definitions` VALUES (2734, 10656, 2, 'Lämna in händelsen');
INSERT INTO `lang_definitions` VALUES (2735, 10657, 2, 'lämna in blanketten');
INSERT INTO `lang_definitions` VALUES (2736, 10662, 2, 'Inlämnat av');
INSERT INTO `lang_definitions` VALUES (2737, 10666, 2, 'Prenuremant');
INSERT INTO `lang_definitions` VALUES (2738, 10667, 2, 'Prenuremants Adress');
INSERT INTO `lang_definitions` VALUES (2739, 10701, 2, 'Ersättare');
INSERT INTO `lang_definitions` VALUES (2740, 10702, 2, 'Ersättare tillåts');
INSERT INTO `lang_definitions` VALUES (2741, 10738, 2, 'Självmord');
INSERT INTO `lang_definitions` VALUES (2742, 10740, 2, 'Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2743, 10747, 2, 'Sön');
INSERT INTO `lang_definitions` VALUES (2744, 10749, 2, 'Söndag');
INSERT INTO `lang_definitions` VALUES (2745, 10782, 2, 'Kirurgi');
INSERT INTO `lang_definitions` VALUES (2746, 10784, 2, 'avstänga');
INSERT INTO `lang_definitions` VALUES (2747, 10785, 2, 'Uppslammad vätska');
INSERT INTO `lang_definitions` VALUES (2748, 10792, 2, 'Svenska');
INSERT INTO `lang_definitions` VALUES (2749, 10822, 2, '3 ggr/dag');
INSERT INTO `lang_definitions` VALUES (2750, 10829, 2, 'Tabell skapas inte');
INSERT INTO `lang_definitions` VALUES (2751, 10830, 2, 'Tabell uppdateringen misslyckades');
INSERT INTO `lang_definitions` VALUES (2752, 10832, 2, 'tablett');
INSERT INTO `lang_definitions` VALUES (2753, 10843, 2, 'Ta');
INSERT INTO `lang_definitions` VALUES (2754, 10848, 2, 'Tar lång tid');
INSERT INTO `lang_definitions` VALUES (2755, 10869, 2, 'Skatter');
INSERT INTO `lang_definitions` VALUES (2756, 10892, 2, 'Mall');
INSERT INTO `lang_definitions` VALUES (2757, 10901, 2, 'Mall:');
INSERT INTO `lang_definitions` VALUES (2758, 10923, 2, 'Testa schema');
INSERT INTO `lang_definitions` VALUES (2759, 10924, 2, 'Testa system');
INSERT INTO `lang_definitions` VALUES (2760, 10949, 2, 'Tack');
INSERT INTO `lang_definitions` VALUES (2761, 10991, 2, 'Påstående ärendet:');
INSERT INTO `lang_definitions` VALUES (2762, 11057, 2, 'Händelsen har godkänts.');
INSERT INTO `lang_definitions` VALUES (2763, 11058, 2, 'Händelsen har gömts undan');
INSERT INTO `lang_definitions` VALUES (2764, 11087, 2, 'Följande kalenderhändelse har lagts till:');
INSERT INTO `lang_definitions` VALUES (2765, 11088, 2, 'Följande kalenderhändelse har modifierats:');
INSERT INTO `lang_definitions` VALUES (2766, 11314, 2, 'Terapeutiska Injektioner');
INSERT INTO `lang_definitions` VALUES (2767, 11324, 2, 'Det är fel med din ansökan. Dessa beskrivs nedan.');
INSERT INTO `lang_definitions` VALUES (2768, 11334, 2, 'Det finns inga nya synpunkter');
INSERT INTO `lang_definitions` VALUES (2769, 11374, 2, 'Det uppstod ett fel när din begäran behandlades.');
INSERT INTO `lang_definitions` VALUES (2770, 11400, 2, 'Förtjockad Höger:');
INSERT INTO `lang_definitions` VALUES (2771, 11401, 2, 'Lår');
INSERT INTO `lang_definitions` VALUES (2772, 11402, 2, 'Lår + knäsena');
INSERT INTO `lang_definitions` VALUES (2773, 11419, 2, 'Tredje');
INSERT INTO `lang_definitions` VALUES (2774, 11458, 2, 'Pågående besök');
INSERT INTO `lang_definitions` VALUES (2775, 11478, 2, 'Detta fakturanumret har ändrats till');
INSERT INTO `lang_definitions` VALUES (2776, 11532, 2, 'Denna patient har ingen aktivitet');
INSERT INTO `lang_definitions` VALUES (2777, 11533, 2, 'Denna patients ID används redan!');
INSERT INTO `lang_definitions` VALUES (2778, 11621, 2, 'Tor');
INSERT INTO `lang_definitions` VALUES (2779, 11623, 2, 'torsdag');
INSERT INTO `lang_definitions` VALUES (2780, 11624, 2, 'Torsdag');
INSERT INTO `lang_definitions` VALUES (2781, 11626, 2, 'Sköldkörtel normal');
INSERT INTO `lang_definitions` VALUES (2782, 11642, 2, 'Tid');
INSERT INTO `lang_definitions` VALUES (2783, 11654, 2, 'beräkna tid på händelse');
INSERT INTO `lang_definitions` VALUES (2784, 11656, 2, 'Tidsstämpel och Text');
INSERT INTO `lang_definitions` VALUES (2785, 11661, 2, 'Titel');
INSERT INTO `lang_definitions` VALUES (2786, 11669, 2, 'Till');
INSERT INTO `lang_definitions` VALUES (2787, 11670, 2, 'till');
INSERT INTO `lang_definitions` VALUES (2788, 11671, 2, 'TILL');
INSERT INTO `lang_definitions` VALUES (2789, 11679, 2, 'På det påverkade området');
INSERT INTO `lang_definitions` VALUES (2790, 11680, 2, 'på det påverkade området');
INSERT INTO `lang_definitions` VALUES (2791, 11686, 2, 'till kategori');
INSERT INTO `lang_definitions` VALUES (2792, 11690, 2, 'Till medbetalare');
INSERT INTO `lang_definitions` VALUES (2793, 11715, 2, 'Till Besök');
INSERT INTO `lang_definitions` VALUES (2794, 11716, 2, 'Om du vill filtrera efter kön');
INSERT INTO `lang_definitions` VALUES (2795, 11723, 2, 'Till Historik');
INSERT INTO `lang_definitions` VALUES (2796, 11725, 2, 'Till frågor');
INSERT INTO `lang_definitions` VALUES (2797, 11728, 2, 'För att länka detta besök till objekt i ovanstående lista, markera önskade objekt och klicka sedan på [spara]. Håll ner [Ctrl] för att markera fler objekt.');
INSERT INTO `lang_definitions` VALUES (2798, 11730, 2, 'för att logga in igen');
INSERT INTO `lang_definitions` VALUES (2799, 11748, 2, 'Huden');
INSERT INTO `lang_definitions` VALUES (2800, 11749, 2, 'huden');
INSERT INTO `lang_definitions` VALUES (2801, 11751, 2, 'Till detta besök?');
INSERT INTO `lang_definitions` VALUES (2802, 11757, 2, 'Till:');
INSERT INTO `lang_definitions` VALUES (2803, 11758, 2, 'Till:');
INSERT INTO `lang_definitions` VALUES (2804, 11772, 2, 'Tobak');
INSERT INTO `lang_definitions` VALUES (2805, 11775, 2, 'Tobaks användande');
INSERT INTO `lang_definitions` VALUES (2806, 11779, 2, 'Idag');
INSERT INTO `lang_definitions` VALUES (2807, 11784, 2, 'Dagens datum');
INSERT INTO `lang_definitions` VALUES (2808, 11785, 2, 'Dagens händelser');
INSERT INTO `lang_definitions` VALUES (2809, 11803, 2, 'Tonsillektomi');
INSERT INTO `lang_definitions` VALUES (2810, 11807, 2, 'Topp');
INSERT INTO `lang_definitions` VALUES (2811, 11810, 2, 'Ämne');
INSERT INTO `lang_definitions` VALUES (2812, 11811, 2, 'Totalt');
INSERT INTO `lang_definitions` VALUES (2813, 11812, 2, 'totalt');
INSERT INTO `lang_definitions` VALUES (2814, 11818, 2, 'Sammanlagt belopp som betalats');
INSERT INTO `lang_definitions` VALUES (2815, 11821, 2, 'Totala kostnader');
INSERT INTO `lang_definitions` VALUES (2816, 11823, 2, 'Totalt antal Kunder');
INSERT INTO `lang_definitions` VALUES (2817, 11830, 2, 'Totalt för');
INSERT INTO `lang_definitions` VALUES (2818, 11831, 2, 'Totalt för');
INSERT INTO `lang_definitions` VALUES (2819, 11832, 2, 'Totalt för kategori');
INSERT INTO `lang_definitions` VALUES (2820, 11843, 2, 'Totalt antal patienter');
INSERT INTO `lang_definitions` VALUES (2821, 11868, 2, 'Totalt');
INSERT INTO `lang_definitions` VALUES (2822, 11869, 2, 'Totalbeloppen för');
INSERT INTO `lang_definitions` VALUES (2823, 11870, 2, 'Totalbeloppen för');
INSERT INTO `lang_definitions` VALUES (2824, 11897, 2, 'Utbildnings sort');
INSERT INTO `lang_definitions` VALUES (2825, 11899, 2, 'Remiss m.m.');
INSERT INTO `lang_definitions` VALUES (2826, 11900, 2, 'Transaktion');
INSERT INTO `lang_definitions` VALUES (2827, 11901, 2, 'Transaktion');
INSERT INTO `lang_definitions` VALUES (2828, 11913, 2, 'Transaktionstyp');
INSERT INTO `lang_definitions` VALUES (2829, 11914, 2, 'Transaktioner');
INSERT INTO `lang_definitions` VALUES (2830, 11916, 2, 'Transaktioner (skriva valfritt)');
INSERT INTO `lang_definitions` VALUES (2831, 11922, 2, 'Transaktioner / Övergångar');
INSERT INTO `lang_definitions` VALUES (2832, 11940, 2, 'översätt detta');
INSERT INTO `lang_definitions` VALUES (2833, 11942, 2, 'översätta');
INSERT INTO `lang_definitions` VALUES (2834, 11952, 2, 'Trauma');
INSERT INTO `lang_definitions` VALUES (2835, 11955, 2, 'Behandlings mål');
INSERT INTO `lang_definitions` VALUES (2836, 11956, 2, 'Behandlings plan');
INSERT INTO `lang_definitions` VALUES (2837, 11959, 2, 'Behandling:');
INSERT INTO `lang_definitions` VALUES (2838, 11960, 2, 'Behandling:');
INSERT INTO `lang_definitions` VALUES (2839, 11979, 2, 'tesked');
INSERT INTO `lang_definitions` VALUES (2840, 11983, 2, 'Tis');
INSERT INTO `lang_definitions` VALUES (2841, 11985, 2, 'Tisdag');
INSERT INTO `lang_definitions` VALUES (2842, 11986, 2, 'Tumör');
INSERT INTO `lang_definitions` VALUES (2843, 11996, 2, 'två gånger dagligen');
INSERT INTO `lang_definitions` VALUES (2844, 12001, 2, 'Typ');
INSERT INTO `lang_definitions` VALUES (2845, 12017, 2, 'Skriv in eller skanna patientidentifikation här');
INSERT INTO `lang_definitions` VALUES (2846, 12051, 2, 'Ulcerations');
INSERT INTO `lang_definitions` VALUES (2847, 12052, 2, 'Ulcerös kolit');
INSERT INTO `lang_definitions` VALUES (2848, 12053, 2, 'Sår:');
INSERT INTO `lang_definitions` VALUES (2849, 12075, 2, 'Ej tilldelad');
INSERT INTO `lang_definitions` VALUES (2850, 12078, 2, 'Obehörig åtkomst.');
INSERT INTO `lang_definitions` VALUES (2851, 12084, 2, 'under tungan');
INSERT INTO `lang_definitions` VALUES (2852, 12087, 2, 'Undervikt');
INSERT INTO `lang_definitions` VALUES (2853, 12088, 2, 'odiagnosticerad');
INSERT INTO `lang_definitions` VALUES (2854, 12093, 2, 'Ångra Kassa');
INSERT INTO `lang_definitions` VALUES (2855, 12095, 2, 'Unika Kunder');
INSERT INTO `lang_definitions` VALUES (2856, 12099, 2, 'Unika nya kunder');
INSERT INTO `lang_definitions` VALUES (2857, 12104, 2, 'Enhet');
INSERT INTO `lang_definitions` VALUES (2858, 12106, 2, 'Enheter');
INSERT INTO `lang_definitions` VALUES (2859, 12107, 2, 'enheter');
INSERT INTO `lang_definitions` VALUES (2860, 12113, 2, 'Okänt');
INSERT INTO `lang_definitions` VALUES (2861, 12117, 2, 'Okänd eller N / A');
INSERT INTO `lang_definitions` VALUES (2862, 12131, 2, 'Namnlöst försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2863, 12132, 2, 'Oregistrerad');
INSERT INTO `lang_definitions` VALUES (2864, 12135, 2, 'Avmarkera alla');
INSERT INTO `lang_definitions` VALUES (2865, 12137, 2, 'Omarkerat');
INSERT INTO `lang_definitions` VALUES (2866, 12138, 2, 'Ospecificerad');
INSERT INTO `lang_definitions` VALUES (2867, 12143, 2, 'tills');
INSERT INTO `lang_definitions` VALUES (2868, 12147, 2, 'Outnyttjad');
INSERT INTO `lang_definitions` VALUES (2869, 12149, 2, 'Upp till');
INSERT INTO `lang_definitions` VALUES (2870, 12151, 2, 'Kommande möten');
INSERT INTO `lang_definitions` VALUES (2871, 12152, 2, 'Kommande evenemang');
INSERT INTO `lang_definitions` VALUES (2872, 12153, 2, 'Uppdatera');
INSERT INTO `lang_definitions` VALUES (2873, 12154, 2, 'uppdatera');
INSERT INTO `lang_definitions` VALUES (2874, 12158, 2, 'Uppdateringsfilerna');
INSERT INTO `lang_definitions` VALUES (2875, 12160, 2, 'Uppdatera Info');
INSERT INTO `lang_definitions` VALUES (2876, 12191, 2, 'Uppladdning');
INSERT INTO `lang_definitions` VALUES (2877, 12197, 2, 'Ladda upp dokument');
INSERT INTO `lang_definitions` VALUES (2878, 12201, 2, 'Ladda upp fil att importera:');
INSERT INTO `lang_definitions` VALUES (2879, 12205, 2, 'Ladda upp rapport');
INSERT INTO `lang_definitions` VALUES (2880, 12208, 2, 'Ladda upp den här filen:');
INSERT INTO `lang_definitions` VALUES (2881, 12219, 2, 'Överarmen');
INSERT INTO `lang_definitions` VALUES (2882, 12222, 2, 'Brådskande');
INSERT INTO `lang_definitions` VALUES (2883, 12228, 2, 'Urin Frekvens');
INSERT INTO `lang_definitions` VALUES (2884, 12229, 2, 'Urin Tveksamhet');
INSERT INTO `lang_definitions` VALUES (2885, 12233, 2, 'URL');
INSERT INTO `lang_definitions` VALUES (2886, 12252, 2, 'Använd 24-timmars format?');
INSERT INTO `lang_definitions` VALUES (2887, 12273, 2, 'Använd Standardinställningar');
INSERT INTO `lang_definitions` VALUES (2888, 12275, 2, 'Använd internationellt utseende på datum?');
INSERT INTO `lang_definitions` VALUES (2889, 12291, 2, 'Använd ämnen?');
INSERT INTO `lang_definitions` VALUES (2890, 12295, 2, 'Användare');
INSERT INTO `lang_definitions` VALUES (2891, 12299, 2, 'Användaradministration');
INSERT INTO `lang_definitions` VALUES (2892, 12300, 2, 'Användar-och Facility Administration');
INSERT INTO `lang_definitions` VALUES (2893, 12301, 2, 'Användare och grupp Administration');
INSERT INTO `lang_definitions` VALUES (2894, 12307, 2, 'Användardefinierad');
INSERT INTO `lang_definitions` VALUES (2895, 12308, 2, 'Användar definierad Area 11');
INSERT INTO `lang_definitions` VALUES (2896, 12309, 2, 'Användar definierad Area 12');
INSERT INTO `lang_definitions` VALUES (2897, 12334, 2, 'Användare Medlemskap');
INSERT INTO `lang_definitions` VALUES (2898, 12356, 2, 'Användarnamn');
INSERT INTO `lang_definitions` VALUES (2899, 12359, 2, 'Användarnamn för SMS Gateway');
INSERT INTO `lang_definitions` VALUES (2900, 12362, 2, 'Användarnamn:');
INSERT INTO `lang_definitions` VALUES (2901, 12363, 2, 'Användare');
INSERT INTO `lang_definitions` VALUES (2902, 12367, 2, 'Användare / grupper / Logs Administration');
INSERT INTO `lang_definitions` VALUES (2903, 12392, 2, 'SEMESTER');
INSERT INTO `lang_definitions` VALUES (2904, 12393, 2, 'Semester');
INSERT INTO `lang_definitions` VALUES (2905, 12394, 2, 'Vaccin');
INSERT INTO `lang_definitions` VALUES (2906, 12413, 2, 'Wert');
INSERT INTO `lang_definitions` VALUES (2907, 12414, 2, 'Wert 1');
INSERT INTO `lang_definitions` VALUES (2908, 12415, 2, 'Wert 2');
INSERT INTO `lang_definitions` VALUES (2909, 12417, 2, 'Wert muss numerisch sein');
INSERT INTO `lang_definitions` VALUES (2910, 12427, 2, 'Blodkärls kondition');
INSERT INTO `lang_definitions` VALUES (2911, 12428, 2, 'Blodkärsl skada');
INSERT INTO `lang_definitions` VALUES (2912, 12429, 2, 'Kärlkirurgi');
INSERT INTO `lang_definitions` VALUES (2913, 12441, 2, 'Version');
INSERT INTO `lang_definitions` VALUES (2914, 12461, 2, 'Svindel');
INSERT INTO `lang_definitions` VALUES (2915, 12477, 2, 'Visa');
INSERT INTO `lang_definitions` VALUES (2916, 12478, 2, 'visa');
INSERT INTO `lang_definitions` VALUES (2917, 12480, 2, 'Visa allergier');
INSERT INTO `lang_definitions` VALUES (2918, 12486, 2, 'Visa Omfattande Patient Rapport');
INSERT INTO `lang_definitions` VALUES (2919, 12489, 2, 'Visa dokument');
INSERT INTO `lang_definitions` VALUES (2920, 12491, 2, 'Visa möte');
INSERT INTO `lang_definitions` VALUES (2921, 12493, 2, 'Visa händelser i ett popup-fönster?');
INSERT INTO `lang_definitions` VALUES (2922, 12500, 2, 'Visa Sida 1');
INSERT INTO `lang_definitions` VALUES (2923, 12501, 2, 'Visa sida 2');
INSERT INTO `lang_definitions` VALUES (2924, 12510, 2, 'Se relaterade möten');
INSERT INTO `lang_definitions` VALUES (2925, 12528, 2, 'Visa:');
INSERT INTO `lang_definitions` VALUES (2926, 12529, 2, 'VISA');
INSERT INTO `lang_definitions` VALUES (2927, 12530, 2, 'VISA/MC/AMEX/Dis');
INSERT INTO `lang_definitions` VALUES (2928, 12532, 2, 'Visceral skada / trauma / kirurgi');
INSERT INTO `lang_definitions` VALUES (2929, 12539, 2, 'Besökskategori:');
INSERT INTO `lang_definitions` VALUES (2930, 12540, 2, 'Besöks Datum');
INSERT INTO `lang_definitions` VALUES (2931, 12556, 2, 'Besök');
INSERT INTO `lang_definitions` VALUES (2932, 12558, 2, 'Besök från');
INSERT INTO `lang_definitions` VALUES (2933, 12563, 2, 'Vitalparametrar');
INSERT INTO `lang_definitions` VALUES (2934, 12564, 2, 'Vitalparametrar');
INSERT INTO `lang_definitions` VALUES (2935, 12565, 2, 'Vitalparametrar (metriska)');
INSERT INTO `lang_definitions` VALUES (2936, 12566, 2, 'Vitalparametrar Formulär inställningar');
INSERT INTO `lang_definitions` VALUES (2937, 12584, 2, 'Kräkningar');
INSERT INTO `lang_definitions` VALUES (2938, 12588, 2, 'W');
INSERT INTO `lang_definitions` VALUES (2939, 12593, 2, 'Väntar');
INSERT INTO `lang_definitions` VALUES (2940, 12605, 2, 'Varm');
INSERT INTO `lang_definitions` VALUES (2941, 12609, 2, 'VARNING');
INSERT INTO `lang_definitions` VALUES (2942, 12613, 2, 'Varning: Ett besök var redan skapat för denna patient idag!');
INSERT INTO `lang_definitions` VALUES (2943, 12620, 2, 'Varning: patient-ID är inte unikt!');
INSERT INTO `lang_definitions` VALUES (2944, 12648, 2, 'Svaghet');
INSERT INTO `lang_definitions` VALUES (2945, 12655, 2, 'Hemsida');
INSERT INTO `lang_definitions` VALUES (2946, 12660, 2, 'Ons');
INSERT INTO `lang_definitions` VALUES (2947, 12661, 2, 'Onsdag');
INSERT INTO `lang_definitions` VALUES (2948, 12662, 2, 'Vecka');
INSERT INTO `lang_definitions` VALUES (2949, 12663, 2, 'vecka');
INSERT INTO `lang_definitions` VALUES (2950, 12664, 2, 'Veckovy');
INSERT INTO `lang_definitions` VALUES (2951, 12665, 2, 'Veckan (s)');
INSERT INTO `lang_definitions` VALUES (2952, 12669, 2, 'Vikt');
INSERT INTO `lang_definitions` VALUES (2953, 12672, 2, 'Vikt förändring');
INSERT INTO `lang_definitions` VALUES (2954, 12673, 2, 'Viktminskning');
INSERT INTO `lang_definitions` VALUES (2955, 12694, 2, 'Vad är det som räknas?');
INSERT INTO `lang_definitions` VALUES (2956, 12698, 2, 'Wheezing:');
INSERT INTO `lang_definitions` VALUES (2957, 12724, 2, 'Whiplash');
INSERT INTO `lang_definitions` VALUES (2958, 12728, 2, 'Vem');
INSERT INTO `lang_definitions` VALUES (2959, 12729, 2, 'Vem har svarat?');
INSERT INTO `lang_definitions` VALUES (2960, 12731, 2, 'Änka/änkeman');
INSERT INTO `lang_definitions` VALUES (2961, 12732, 2, 'Vidd');
INSERT INTO `lang_definitions` VALUES (2962, 12734, 2, 'Vidd i punkter på vänstra navigeringsfönstret');
INSERT INTO `lang_definitions` VALUES (2963, 12742, 2, 'Med vald:');
INSERT INTO `lang_definitions` VALUES (2964, 12743, 2, 'med det gamla namnet');
INSERT INTO `lang_definitions` VALUES (2965, 12746, 2, 'Med vem kan vi lämna ett meddelande?');
INSERT INTO `lang_definitions` VALUES (2966, 12747, 2, 'Återtagen/innehållen');
INSERT INTO `lang_definitions` VALUES (2967, 12748, 2, 'inom några timmar');
INSERT INTO `lang_definitions` VALUES (2968, 12749, 2, 'inom några timmar:');
INSERT INTO `lang_definitions` VALUES (2969, 12750, 2, 'inom några minuter');
INSERT INTO `lang_definitions` VALUES (2970, 12751, 2, 'inom några minuter:');
INSERT INTO `lang_definitions` VALUES (2971, 12754, 2, 'Utan Updatering');
INSERT INTO `lang_definitions` VALUES (2972, 12755, 2, 'vittne');
INSERT INTO `lang_definitions` VALUES (2973, 12759, 2, 'Kvinnor');
INSERT INTO `lang_definitions` VALUES (2974, 12760, 2, 'Enbart kvinnor');
INSERT INTO `lang_definitions` VALUES (2975, 12762, 2, 'Arbete');
INSERT INTO `lang_definitions` VALUES (2976, 12764, 2, 'Telefon, arbete');
INSERT INTO `lang_definitions` VALUES (2977, 12765, 2, 'Telefon, Arbete, Nummer');
INSERT INTO `lang_definitions` VALUES (2978, 12766, 2, 'Arbetsrelaterat?');
INSERT INTO `lang_definitions` VALUES (2979, 12767, 2, 'Arbete/ Utbildning/ Hobby');
INSERT INTO `lang_definitions` VALUES (2980, 12768, 2, 'Arbete / Skola Anmärkning');
INSERT INTO `lang_definitions` VALUES (2981, 12769, 2, 'arbetsdag');
INSERT INTO `lang_definitions` VALUES (2982, 12779, 2, 'förvärrad');
INSERT INTO `lang_definitions` VALUES (2983, 12791, 2, 'Handled');
INSERT INTO `lang_definitions` VALUES (2984, 12792, 2, 'Handled och hand');
INSERT INTO `lang_definitions` VALUES (2985, 12793, 2, 'Handleds Problem');
INSERT INTO `lang_definitions` VALUES (2986, 12794, 2, 'skriv');
INSERT INTO `lang_definitions` VALUES (2987, 12796, 2, 'avskriva');
INSERT INTO `lang_definitions` VALUES (2988, 12805, 2, 'x inställt');
INSERT INTO `lang_definitions` VALUES (2989, 12809, 2, 'Röntgen');
INSERT INTO `lang_definitions` VALUES (2990, 12810, 2, 'Röntgen Tolkning:');
INSERT INTO `lang_definitions` VALUES (2991, 12811, 2, 'Röntgen Tolkning:');
INSERT INTO `lang_definitions` VALUES (2992, 12815, 2, 'Endast X12: Ersättningskrav');
INSERT INTO `lang_definitions` VALUES (2993, 12818, 2, 'X12 Partner');
INSERT INTO `lang_definitions` VALUES (2994, 12819, 2, 'X12 Partners');
INSERT INTO `lang_definitions` VALUES (2995, 12827, 2, 'Y');
INSERT INTO `lang_definitions` VALUES (2996, 12828, 2, 'år');
INSERT INTO `lang_definitions` VALUES (2997, 12829, 2, 'År');
INSERT INTO `lang_definitions` VALUES (2998, 12830, 2, 'År Visa');
INSERT INTO `lang_definitions` VALUES (2999, 12831, 2, 'År');
INSERT INTO `lang_definitions` VALUES (3000, 12836, 2, 'Ja');
INSERT INTO `lang_definitions` VALUES (3001, 12837, 2, 'JA');
INSERT INTO `lang_definitions` VALUES (3002, 12838, 2, 'ja');
INSERT INTO `lang_definitions` VALUES (3003, 12839, 2, 'JA!');
INSERT INTO `lang_definitions` VALUES (3004, 12840, 2, 'Ja, radera och logga');
INSERT INTO `lang_definitions` VALUES (3005, 12842, 2, 'Ja/Nej');
INSERT INTO `lang_definitions` VALUES (3006, 12843, 2, 'Ja:');
INSERT INTO `lang_definitions` VALUES (3007, 12849, 2, 'Du håller på att permanent ersätta den befintliga mallen. Är du säker på att du vill fortsätta?');
INSERT INTO `lang_definitions` VALUES (3008, 12853, 2, 'Det är inte tillåtet att ta bort denna händelse');
INSERT INTO `lang_definitions` VALUES (3009, 12854, 2, 'Du har inte tillåtelse att redigera den här händelsen');
INSERT INTO `lang_definitions` VALUES (3010, 12855, 2, 'Du har inte behörighet för detta.');
INSERT INTO `lang_definitions` VALUES (3011, 12857, 2, 'Du har inte behörighet att komma åt den här gruppen.');
INSERT INTO `lang_definitions` VALUES (3012, 12858, 2, 'Du har inte behörighet att lägga till / redigera frågor');
INSERT INTO `lang_definitions` VALUES (3013, 12860, 2, 'Du har inte behörighet att se det här mötet.');
INSERT INTO `lang_definitions` VALUES (3014, 12879, 2, 'Du kan inte komma åt denna funktion direkt.');
INSERT INTO `lang_definitions` VALUES (3015, 12891, 2, 'Du kan inte komma åt den här sidan direkt.');
INSERT INTO `lang_definitions` VALUES (3016, 12898, 2, 'Du har inte valt några åtgärder.');
INSERT INTO `lang_definitions` VALUES (3017, 12899, 2, 'Du har inte behörighet att se / redigera denna anmärkning');
INSERT INTO `lang_definitions` VALUES (3018, 12933, 2, 'Du måste först välja eller lägga till en patient.');
INSERT INTO `lang_definitions` VALUES (3019, 12934, 2, 'Du måste först välja eller skapa ett möte.');
INSERT INTO `lang_definitions` VALUES (3020, 12938, 2, 'Du måste välja några områden för att fortsätta.');
INSERT INTO `lang_definitions` VALUES (3021, 12970, 2, 'Ditt slutdatum är ogiltig');
INSERT INTO `lang_definitions` VALUES (3022, 12971, 2, 'Din händelse har strukits.');
INSERT INTO `lang_definitions` VALUES (3023, 12972, 2, 'Din händelse har ändrats.');
INSERT INTO `lang_definitions` VALUES (3024, 12973, 2, 'Din händelse har lämnats in.');
INSERT INTO `lang_definitions` VALUES (3025, 12981, 2, 'Din namnlista har ändrats för att uppfylla namngivnings krav.');
INSERT INTO `lang_definitions` VALUES (3026, 12995, 2, 'Din Post Kalender konfiguration har återställts att använda standardvärden.');
INSERT INTO `lang_definitions` VALUES (3027, 12996, 2, 'Din Post Kalender konfiguration har uppdaterats.');
INSERT INTO `lang_definitions` VALUES (3028, 12997, 2, 'Den upprepade frekvens måste vara ett heltal.');
INSERT INTO `lang_definitions` VALUES (3029, 12998, 2, 'Den upprepade frekvensen måste vara minst 1.');
INSERT INTO `lang_definitions` VALUES (3030, 13000, 2, 'Ditt startdatum är större än ditt slutdatum');
INSERT INTO `lang_definitions` VALUES (3031, 13001, 2, 'Ditt startdatum är ogiltig');
INSERT INTO `lang_definitions` VALUES (3032, 13002, 2, 'Ditt förslag misslyckats.');
INSERT INTO `lang_definitions` VALUES (3033, 13005, 2, 'åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (3034, 13007, 2, 'åååå-mm-dd dag är förknippade med detta dokument');
INSERT INTO `lang_definitions` VALUES (3035, 13009, 2, 'åååå-mm-dd födelsedatum');
INSERT INTO `lang_definitions` VALUES (3036, 13010, 2, 'åååå-mm-dd Födelsedatum');
INSERT INTO `lang_definitions` VALUES (3037, 13011, 2, 'ååå-mm-dd datum för utlöpande');
INSERT INTO `lang_definitions` VALUES (3038, 13012, 2, 'åååå-mm-dd Datum för uppkomsten eller sjukhusvistelse');
INSERT INTO `lang_definitions` VALUES (3039, 13013, 2, 'åååå-mm-dd datum debut, kirurgi eller början av medicinering');
INSERT INTO `lang_definitions` VALUES (3040, 13015, 2, 'åååå-mm-dd dagen för tillfrisknande eller slutet av medicinering');
INSERT INTO `lang_definitions` VALUES (3041, 13017, 2, 'åååå-mm-dd Delgivningsdatum');
INSERT INTO `lang_definitions` VALUES (3042, 13018, 2, 'åååå-mm-dd dagen för denna skrivelse');
INSERT INTO `lang_definitions` VALUES (3043, 13020, 2, 'åååå-mm-dd dokumentets datum');
INSERT INTO `lang_definitions` VALUES (3044, 13022, 2, 'åååå-mm-dd händelse datum eller startdatum');
INSERT INTO `lang_definitions` VALUES (3045, 13029, 2, 'åååå-mm-dd sista datum för detta evenemang');
INSERT INTO `lang_definitions` VALUES (3046, 13035, 2, 'noll');
INSERT INTO `lang_definitions` VALUES (3047, 13039, 2, 'postadress');
INSERT INTO `lang_definitions` VALUES (3048, 13040, 2, 'postnummer');
INSERT INTO `lang_definitions` VALUES (3049, 13043, 2, 'land');
INSERT INTO `lang_definitions` VALUES (3050, 13049, 2, 'men var');
INSERT INTO `lang_definitions` VALUES (3051, 13050, 2, 'gick inte att komma åt');
INSERT INTO `lang_definitions` VALUES (3052, 13051, 2, 'Vill du verkligen radera');
INSERT INTO `lang_definitions` VALUES (3053, 13052, 2, 'läkemedel');
INSERT INTO `lang_definitions` VALUES (3054, 13053, 2, 'e-postmeddelande ej skickat');
INSERT INTO `lang_definitions` VALUES (3055, 13054, 2, 'från');
INSERT INTO `lang_definitions` VALUES (3056, 13055, 2, 'har skapats');
INSERT INTO `lang_definitions` VALUES (3057, 13056, 2, 'har återupptagits');
INSERT INTO `lang_definitions` VALUES (3058, 13057, 2, 'Historia');
INSERT INTO `lang_definitions` VALUES (3059, 13058, 2, 'är inget nummer');
INSERT INTO `lang_definitions` VALUES (3060, 13059, 2, 'är redo för ny fakturering');
INSERT INTO `lang_definitions` VALUES (3061, 13060, 2, 'LLL:');
INSERT INTO `lang_definitions` VALUES (3062, 13061, 2, 'Batchnr');
INSERT INTO `lang_definitions` VALUES (3063, 13062, 2, 'Medicaid orginal referensnr.');
INSERT INTO `lang_definitions` VALUES (3064, 13064, 2, 'finns ej!');
INSERT INTO `lang_definitions` VALUES (3065, 13067, 2, 'Tills');
INSERT INTO `lang_definitions` VALUES (3066, 13068, 2, 'Uppdateringen misslyckades, inte i databasen?');
INSERT INTO `lang_definitions` VALUES (3067, 13069, 2, 'präglades som faktureras endast.');
INSERT INTO `lang_definitions` VALUES (3068, 13070, 2, 'var kö framgångsrikt.');
INSERT INTO `lang_definitions` VALUES (3069, 13071, 2, '! Lämnat utan besök');
INSERT INTO `lang_definitions` VALUES (3070, 13072, 2, '\" För kod');
INSERT INTO `lang_definitions` VALUES (3071, 13073, 2, '\" Kontrolleras PostCalendar Inställningar!');
INSERT INTO `lang_definitions` VALUES (3072, 13076, 2, 'kr');
INSERT INTO `lang_definitions` VALUES (3073, 13077, 2, 'Kodningen av kronor är färdig');
INSERT INTO `lang_definitions` VALUES (3074, 13078, 2, '$ etikett (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3075, 13079, 2, '%');
INSERT INTO `lang_definitions` VALUES (3076, 13081, 2, '% Annullerat <24h');
INSERT INTO `lang_definitions` VALUES (3077, 13082, 2, 'bör finnas, men finns inte.');
INSERT INTO `lang_definitions` VALUES (3078, 13083, 2, '(% Matchar alla strängar, _ matchar alla tecken)');
INSERT INTO `lang_definitions` VALUES (3079, 13085, 2, '(Tillbaka)');
INSERT INTO `lang_definitions` VALUES (3080, 13086, 2, '(Klicka för att redigera)');
INSERT INTO `lang_definitions` VALUES (3081, 13088, 2, '(Mer)');
INSERT INTO `lang_definitions` VALUES (3082, 13089, 2, '(Ny Patient)');
INSERT INTO `lang_definitions` VALUES (3083, 13090, 2, '(Anteckningar och Auktoriseringar)');
INSERT INTO `lang_definitions` VALUES (3084, 13091, 2, '(Patient anteckningar)');
INSERT INTO `lang_definitions` VALUES (3085, 13092, 2, '(Välj ett av dessa, eller skriv din egen rubrik)');
INSERT INTO `lang_definitions` VALUES (3086, 13094, 2, '* Påminnelse skickad');
INSERT INTO `lang_definitions` VALUES (3087, 13095, 2, '** Gör om kirurgi till enheter');
INSERT INTO `lang_definitions` VALUES (3088, 13096, 2, '* Obligatorisk');
INSERT INTO `lang_definitions` VALUES (3089, 13097, 2, '+ Patientkort hämtat');
INSERT INTO `lang_definitions` VALUES (3090, 13101, 2, '- Ingen');
INSERT INTO `lang_definitions` VALUES (3091, 13103, 2, '-- Alla --');
INSERT INTO `lang_definitions` VALUES (3092, 13104, 2, '--Välj uppdrag--');
INSERT INTO `lang_definitions` VALUES (3093, 13105, 2, '.');
INSERT INTO `lang_definitions` VALUES (3094, 13106, 2, '0');
INSERT INTO `lang_definitions` VALUES (3095, 13107, 2, '0-10');
INSERT INTO `lang_definitions` VALUES (3096, 13108, 2, '0-24');
INSERT INTO `lang_definitions` VALUES (3097, 13111, 2, '1');
INSERT INTO `lang_definitions` VALUES (3098, 13112, 2, '46 = Sverige. Se http://www.wtng.info för lista på andra landskoder');
INSERT INTO `lang_definitions` VALUES (3099, 13117, 2, '1.Vila 2. Lägg på is i två dagar 3. Komprimering lämna förbandet på plats om inte foten utvecklar domningar eller blek färg 4. Ha foten och ben i Upphöjt läge.');
INSERT INTO `lang_definitions` VALUES (3100, 13118, 2, '11-14');
INSERT INTO `lang_definitions` VALUES (3101, 13119, 2, '12 hr');
INSERT INTO `lang_definitions` VALUES (3102, 13120, 2, '15-19');
INSERT INTO `lang_definitions` VALUES (3103, 13130, 2, '20-24');
INSERT INTO `lang_definitions` VALUES (3104, 13139, 2, '2111-13');
INSERT INTO `lang_definitions` VALUES (3105, 13142, 2, '25-29');
INSERT INTO `lang_definitions` VALUES (3106, 13145, 2, '2:a');
INSERT INTO `lang_definitions` VALUES (3107, 13149, 2, '3 månader');
INSERT INTO `lang_definitions` VALUES (3108, 13151, 2, '3 gånger dagligen');
INSERT INTO `lang_definitions` VALUES (3109, 13153, 2, '30-34');
INSERT INTO `lang_definitions` VALUES (3110, 13154, 2, '35-39');
INSERT INTO `lang_definitions` VALUES (3111, 13156, 2, '3:e');
INSERT INTO `lang_definitions` VALUES (3112, 13160, 2, '4 månader');
INSERT INTO `lang_definitions` VALUES (3113, 13162, 2, '4 gånger dagligen');
INSERT INTO `lang_definitions` VALUES (3114, 13164, 2, '40-44');
INSERT INTO `lang_definitions` VALUES (3115, 13165, 2, '45');
INSERT INTO `lang_definitions` VALUES (3116, 13175, 2, '4:e');
INSERT INTO `lang_definitions` VALUES (3117, 13183, 2, '5:e');
INSERT INTO `lang_definitions` VALUES (3118, 13185, 2, '6 dagar från nu');
INSERT INTO `lang_definitions` VALUES (3119, 13186, 2, '6 månader');
INSERT INTO `lang_definitions` VALUES (3120, 13187, 2, '6 månader från nu');
INSERT INTO `lang_definitions` VALUES (3121, 13188, 2, '6 veckor från nu');
INSERT INTO `lang_definitions` VALUES (3122, 13189, 2, '6:e');
INSERT INTO `lang_definitions` VALUES (3123, 13191, 2, '7 månader från nu');
INSERT INTO `lang_definitions` VALUES (3124, 13192, 2, '8 månader från nu');
INSERT INTO `lang_definitions` VALUES (3125, 13194, 2, '824.0 Sluten fraktur mediala malleolen');
INSERT INTO `lang_definitions` VALUES (3126, 13195, 2, '824.2 Sluten fraktur laterala malleolen');
INSERT INTO `lang_definitions` VALUES (3127, 13196, 2, '842.6 Sluten trimalleolarfraktur');
INSERT INTO `lang_definitions` VALUES (3128, 13197, 2, '825.32 Fraktur os naviculare (fotled)');
INSERT INTO `lang_definitions` VALUES (3129, 13198, 2, '825.35 Fraktur basen av 5:e metatarsalbenet');
INSERT INTO `lang_definitions` VALUES (3130, 13199, 2, '845.00 Stukad fotled UNS');
INSERT INTO `lang_definitions` VALUES (3131, 13200, 2, '845.01 Stukad fotled deltoideus lig.');
INSERT INTO `lang_definitions` VALUES (3132, 13201, 2, '845.02 Stukad fortled, fc-ligament');
INSERT INTO `lang_definitions` VALUES (3133, 13202, 2, '9 månader från nu');
INSERT INTO `lang_definitions` VALUES (3134, 13203, 2, '99212 Etablerade - okomplicerad');
INSERT INTO `lang_definitions` VALUES (3135, 13204, 2, '99213 Etablerade - Låg komplexitet');
INSERT INTO `lang_definitions` VALUES (3136, 13205, 2, '< I undersökningsrummet');
INSERT INTO `lang_definitions` VALUES (3137, 13209, 2, '> Avslutat');
INSERT INTO `lang_definitions` VALUES (3138, 13211, 2, '?');
INSERT INTO `lang_definitions` VALUES (3139, 13213, 2, '? Har ej dykt upp på avtalad tid');
INSERT INTO `lang_definitions` VALUES (3140, 13214, 2, 'Anlänt');
INSERT INTO `lang_definitions` VALUES (3141, 13216, 2, '[Ändra vy]');
INSERT INTO `lang_definitions` VALUES (3142, 13217, 2, '[Datum för senaste mötet]');
INSERT INTO `lang_definitions` VALUES (3143, 13218, 2, '[Dagar sedan senaste mötet]');
INSERT INTO `lang_definitions` VALUES (3144, 13221, 2, '[rekommenderas inte]');
INSERT INTO `lang_definitions` VALUES (3145, 13222, 2, '[Antalet möten]');
INSERT INTO `lang_definitions` VALUES (3146, 13223, 2, '[Rapporter]');
INSERT INTO `lang_definitions` VALUES (3147, 13224, 2, '[Markera alla]');
INSERT INTO `lang_definitions` VALUES (3148, 13225, 2, '[SQL-Ledger]');
INSERT INTO `lang_definitions` VALUES (3149, 13226, 2, '[Starta batchprocess]');
INSERT INTO `lang_definitions` VALUES (3150, 13227, 2, '[Titta på logg]');
INSERT INTO `lang_definitions` VALUES (3151, 13228, 2, '[Se utskrivbar rapport]');
INSERT INTO `lang_definitions` VALUES (3152, 13230, 2, '_PC_DUR_HOURS');
INSERT INTO `lang_definitions` VALUES (3153, 13231, 2, '_PC_DUR_MINUTES');
INSERT INTO `lang_definitions` VALUES (3154, 13232, 2, '_PC_LOCALE');
INSERT INTO `lang_definitions` VALUES (3155, 13233, 2, '~ Kommit sent');
INSERT INTO `lang_definitions` VALUES (3156, 1, 3, 'Un, Una');
INSERT INTO `lang_definitions` VALUES (3157, 2, 3, 'Un número de cheque o reclamación para identificar el pago');
INSERT INTO `lang_definitions` VALUES (3158, 3, 3, 'Debe escoger una reclamación para activar este menú');
INSERT INTO `lang_definitions` VALUES (3159, 4, 3, 'Un certificado de cliente para el usuario administrador');
INSERT INTO `lang_definitions` VALUES (3160, 5, 3, 'Una Regla de Decisión Clínica es información específica del paciente que se filtra y se presenta en el momento adecuado para mejorar la salud y la atención sanitaria');
INSERT INTO `lang_definitions` VALUES (3161, 6, 3, 'Adjunto está un documento clínico.');
INSERT INTO `lang_definitions` VALUES (3162, 7, 3, 'Adjunto está un documento clínico.');
INSERT INTO `lang_definitions` VALUES (3163, 8, 3, 'Un código de este tipo ya ha sido seleccionado. Elimínelo del campo si necesita reemplazarlo.');
INSERT INTO `lang_definitions` VALUES (3164, 10, 3, 'Necesita adquirir una clave de seguridad privada');
INSERT INTO `lang_definitions` VALUES (3165, 11, 3, 'Un código por defecto es opcional, ya que el código necesario puede ser introducido en el momento de crear la orden');
INSERT INTO `lang_definitions` VALUES (3166, 12, 3, 'Aquí puede encontrar una guía detallada acerca de cómo activar y establecer una regla de Decisión Clínica');
INSERT INTO `lang_definitions` VALUES (3167, 13, 3, 'Se requiere un distribuidor');
INSERT INTO `lang_definitions` VALUES (3168, 15, 3, 'Unas palabras para indicar el motivo de la visita');
INSERT INTO `lang_definitions` VALUES (3169, 16, 3, 'También se puede programar una cita de seguimiento directamente desde la hoja de honorarios.');
INSERT INTO `lang_definitions` VALUES (3170, 17, 3, 'Formulario de visita GCAC debe ser agregado a esta visita');
INSERT INTO `lang_definitions` VALUES (3171, 20, 3, 'Un número de lote es requerido');
INSERT INTO `lang_definitions` VALUES (3172, 21, 3, 'Un número de lote es requerido!');
INSERT INTO `lang_definitions` VALUES (3173, 22, 3, 'Una letra minúscula');
INSERT INTO `lang_definitions` VALUES (3174, 23, 3, 'Una nueva cita');
INSERT INTO `lang_definitions` VALUES (3175, 24, 3, 'Una nueva función ayuda a agrupar las pruebas solicitadas con frecuencia para poder pedirlas juntas');
INSERT INTO `lang_definitions` VALUES (3176, 26, 3, 'No se han podido enviar las credenciales de un nuevo paciente tras el registro en el portal.');
INSERT INTO `lang_definitions` VALUES (3177, 27, 3, 'Un nuevo submenú de pestañas será visible en la parte superior de la página del Centro de Mensajes');
INSERT INTO `lang_definitions` VALUES (3178, 28, 3, 'Un número');
INSERT INTO `lang_definitions` VALUES (3179, 29, 3, 'Debe seleccionar un paciente para generar un reporte');
INSERT INTO `lang_definitions` VALUES (3180, 30, 3, 'Un paciente con ese Nº ID ya existe');
INSERT INTO `lang_definitions` VALUES (3181, 31, 3, 'Un paciente con este nombre ya existe.');
INSERT INTO `lang_definitions` VALUES (3182, 32, 3, 'Un paciente con este Nº Seguridad Social ya existe');
INSERT INTO `lang_definitions` VALUES (3183, 33, 3, '¡Se requiere un pago! Por favor introduzca un concepto de pago');
INSERT INTO `lang_definitions` VALUES (3184, 34, 3, 'Un lugar donde documentar y mostrar el historial médico del paciente, familiar, y personal');
INSERT INTO `lang_definitions` VALUES (3185, 35, 3, 'Una notificación le alertará del éxito o fallo.');
INSERT INTO `lang_definitions` VALUES (3186, 36, 3, 'Un número positivo mostrará tantas citas pasadas en un Widget en la pantalla de resumen del cliente (un número negativo mostrará las citas pasadas en orden descendente)');
INSERT INTO `lang_definitions` VALUES (3187, 37, 3, 'Un número positivo mostrará tantas citas pasadas en un Widget en la pantalla de resumen del cliente (un número negativo mostrará las citas pasadas en orden descendente)');
INSERT INTO `lang_definitions` VALUES (3188, 38, 3, 'Un producto fue seleccionado pero no hay una sección de productos en este formulario');
INSERT INTO `lang_definitions` VALUES (3189, 39, 3, 'Puede seleccionar un proveedor o un almacén en el menú desplegable. Para que se muestre esta opción, \"Support provider in line item in fee sheet\" tiene que ser seleccionado en \"Administración > Globales > Página de facturación');
INSERT INTO `lang_definitions` VALUES (3190, 42, 3, 'Una derivación tiene una acción adicional - imprimir la derivación o guardarla como un fichero pdf');
INSERT INTO `lang_definitions` VALUES (3191, 43, 3, 'Una derivación es el tipo de transacción más común');
INSERT INTO `lang_definitions` VALUES (3192, 44, 3, 'Una fuente de derivación puede ser especificada para cada visita');
INSERT INTO `lang_definitions` VALUES (3193, 45, 3, 'Un código IPPF relacionado es requerido!');
INSERT INTO `lang_definitions` VALUES (3194, 46, 3, 'Se requiere una conexión web segura (HTTPS)  para U2F');
INSERT INTO `lang_definitions` VALUES (3195, 47, 3, 'Una breve descripción del grupo aparecerá cuando coloque le cursor sobre un grupo recién creado (ARO)');
INSERT INTO `lang_definitions` VALUES (3196, 48, 3, 'Una descripción breve de este grupo, pruebas de química de Serum');
INSERT INTO `lang_definitions` VALUES (3197, 49, 3, 'Una descripción breve del procedimiento o el código obtenido');
INSERT INTO `lang_definitions` VALUES (3198, 52, 3, 'Un carácter especial');
INSERT INTO `lang_definitions` VALUES (3199, 53, 3, 'Un formulario estandarizado llamado Formulario de Reclamación del Seguro se usa para enviar reclamaciones');
INSERT INTO `lang_definitions` VALUES (3200, 54, 3, 'Una tercera alternativa es escanear los resultados y guardarlos como un documento TIFF, JPEG, o PDF, en el gráfico del paciente bajo documentos');
INSERT INTO `lang_definitions` VALUES (3201, 55, 3, 'Aparecerá un formulario con dos pestañas');
INSERT INTO `lang_definitions` VALUES (3202, 56, 3, 'Un valor único para identificar este campo, no visible al usuario');
INSERT INTO `lang_definitions` VALUES (3203, 59, 3, 'Ya existe una visita para ese grupo hoy. Haga click en Cancelar para abrirla, o en OK para crear una nueva.');
INSERT INTO `lang_definitions` VALUES (3204, 60, 3, 'Ya existe una visita para este paciente hoy. Haga click en Cancelar para abrirla, o en OK para crear una nueva');
INSERT INTO `lang_definitions` VALUES (3205, 62, 3, 'antes de las comidas');
INSERT INTO `lang_definitions` VALUES (3206, 63, 3, 'a.m.');
INSERT INTO `lang_definitions` VALUES (3207, 65, 3, 'A/F Nivel de Derecho:');
INSERT INTO `lang_definitions` VALUES (3208, 67, 3, 'AB');
INSERT INTO `lang_definitions` VALUES (3209, 68, 3, 'Abreviatura');
INSERT INTO `lang_definitions` VALUES (3210, 69, 3, 'Abceso:');
INSERT INTO `lang_definitions` VALUES (3211, 70, 3, 'Abdominal');
INSERT INTO `lang_definitions` VALUES (3212, 71, 3, 'Capaz de cargar peso cuatro (4) pasos:');
INSERT INTO `lang_definitions` VALUES (3213, 72, 3, 'Anormal');
INSERT INTO `lang_definitions` VALUES (3214, 75, 3, 'ABN1');
INSERT INTO `lang_definitions` VALUES (3215, 76, 3, 'ABNL');
INSERT INTO `lang_definitions` VALUES (3216, 77, 3, 'Anormal');
INSERT INTO `lang_definitions` VALUES (3217, 78, 3, 'Análisis de sangre anormal');
INSERT INTO `lang_definitions` VALUES (3218, 79, 3, 'Crecimiento anormal del pelo');
INSERT INTO `lang_definitions` VALUES (3219, 80, 3, 'Mamografía anormal');
INSERT INTO `lang_definitions` VALUES (3220, 81, 3, 'Abortar');
INSERT INTO `lang_definitions` VALUES (3221, 86, 3, 'Aborto');
INSERT INTO `lang_definitions` VALUES (3222, 87, 3, 'Problemas del Aborto');
INSERT INTO `lang_definitions` VALUES (3223, 88, 3, 'Método abortivo');
INSERT INTO `lang_definitions` VALUES (3224, 89, 3, 'Categorías relacionadas al Aborto');
INSERT INTO `lang_definitions` VALUES (3225, 90, 3, 'Abortos');
INSERT INTO `lang_definitions` VALUES (3226, 91, 3, 'Acerca de');
INSERT INTO `lang_definitions` VALUES (3227, 92, 3, 'Acerca del panel de control del portal');
INSERT INTO `lang_definitions` VALUES (3228, 93, 3, 'Acerca del calendario');
INSERT INTO `lang_definitions` VALUES (3229, 94, 3, 'Acerca de su portala');
INSERT INTO `lang_definitions` VALUES (3230, 95, 3, 'Por encima de los límites de pánico');
INSERT INTO `lang_definitions` VALUES (3231, 96, 3, 'Ausencias por Diagnóstico');
INSERT INTO `lang_definitions` VALUES (3232, 98, 3, 'Aceptar');
INSERT INTO `lang_definitions` VALUES (3233, 99, 3, 'Aceptar la tarea');
INSERT INTO `lang_definitions` VALUES (3234, 101, 3, 'Aceptar pago');
INSERT INTO `lang_definitions` VALUES (3235, 102, 3, 'Aceptar pago por');
INSERT INTO `lang_definitions` VALUES (3236, 103, 3, 'Aceptar Pago por');
INSERT INTO `lang_definitions` VALUES (3237, 104, 3, 'Acepta la tarea');
INSERT INTO `lang_definitions` VALUES (3238, 105, 3, 'Se puede dar acceso a otros grupo editando Membresías o Grupos del Usuario y controles de acceso en Administracion > ACL');
INSERT INTO `lang_definitions` VALUES (3239, 106, 3, 'Control de acceso');
INSERT INTO `lang_definitions` VALUES (3240, 107, 3, 'Administración de la Lista de Control de Acceso');
INSERT INTO `lang_definitions` VALUES (3241, 108, 3, 'Ayuda para la Lista de control de acceso');
INSERT INTO `lang_definitions` VALUES (3242, 109, 3, 'Listas de control de acceso');
INSERT INTO `lang_definitions` VALUES (3243, 111, 3, 'Fecha de acceso');
INSERT INTO `lang_definitions` VALUES (3244, 112, 3, 'Acceso denegado');
INSERT INTO `lang_definitions` VALUES (3245, 114, 3, 'acceso no permitido');
INSERT INTO `lang_definitions` VALUES (3246, 115, 3, 'Acceso no permitido');
INSERT INTO `lang_definitions` VALUES (3247, 116, 3, 'Acceso no autorizado');
INSERT INTO `lang_definitions` VALUES (3248, 118, 3, 'Acceda a sus registros médicos');
INSERT INTO `lang_definitions` VALUES (3249, 119, 3, 'Acceder al Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (3250, 120, 3, 'Accidente');
INSERT INTO `lang_definitions` VALUES (3251, 121, 3, 'Cuenta');
INSERT INTO `lang_definitions` VALUES (3252, 126, 3, 'Cuenta validada. ¿Enviar credenciales nuevas?');
INSERT INTO `lang_definitions` VALUES (3253, 127, 3, 'Nombre de la Cuenta');
INSERT INTO `lang_definitions` VALUES (3254, 128, 3, 'Nombre de cuenta emitido para NewCrop eRx service.');
INSERT INTO `lang_definitions` VALUES (3255, 129, 3, 'Contraseña de cuenta emitida para NewCrop eRx service.');
INSERT INTO `lang_definitions` VALUES (3256, 131, 3, 'Contabilidad');
INSERT INTO `lang_definitions` VALUES (3257, 132, 3, 'Contabilidad');
INSERT INTO `lang_definitions` VALUES (3258, 135, 3, 'Contabilidad');
INSERT INTO `lang_definitions` VALUES (3259, 136, 3, 'Contab.');
INSERT INTO `lang_definitions` VALUES (3260, 137, 3, 'ACD{{profundidad de camara anterior}}');
INSERT INTO `lang_definitions` VALUES (3261, 138, 3, 'Dolores');
INSERT INTO `lang_definitions` VALUES (3262, 139, 3, 'Reconocer como mi firma electrónica');
INSERT INTO `lang_definitions` VALUES (3263, 140, 3, 'Solicitud de reconocimiento (ISA14)');
INSERT INTO `lang_definitions` VALUES (3264, 141, 3, 'Reconocimientos, Licencias y Certificaciones');
INSERT INTO `lang_definitions` VALUES (3265, 142, 3, 'ACL');
INSERT INTO `lang_definitions` VALUES (3266, 143, 3, 'Administración del ACL');
INSERT INTO `lang_definitions` VALUES (3267, 144, 3, 'Administración del ACL (ACL)');
INSERT INTO `lang_definitions` VALUES (3268, 145, 3, 'Administración del ACL no autorizada');
INSERT INTO `lang_definitions` VALUES (3269, 147, 3, 'ACL Control de Grano Fino');
INSERT INTO `lang_definitions` VALUES (3270, 148, 3, 'ACL actualizada exitósamente');
INSERT INTO `lang_definitions` VALUES (3271, 149, 3, 'Acné');
INSERT INTO `lang_definitions` VALUES (3272, 150, 3, 'ACO');
INSERT INTO `lang_definitions` VALUES (3273, 151, 3, 'ACOM{{Segmento anterior}}');
INSERT INTO `lang_definitions` VALUES (3274, 152, 3, 'Acta');
INSERT INTO `lang_definitions` VALUES (3275, 153, 3, 'Fecha de Acta');
INSERT INTO `lang_definitions` VALUES (3276, 154, 3, 'Acción');
INSERT INTO `lang_definitions` VALUES (3277, 155, 3, 'Acción tomada');
INSERT INTO `lang_definitions` VALUES (3278, 156, 3, 'Tiempo de la acción tomada');
INSERT INTO `lang_definitions` VALUES (3279, 157, 3, 'Usuario de la acción');
INSERT INTO `lang_definitions` VALUES (3280, 158, 3, 'Acciones');
INSERT INTO `lang_definitions` VALUES (3281, 159, 3, 'Activar');
INSERT INTO `lang_definitions` VALUES (3282, 160, 3, 'Activar Reportes CCR/CCD');
INSERT INTO `lang_definitions` VALUES (3283, 161, 3, 'Activar para ordenar columnas en orden ascendente');
INSERT INTO `lang_definitions` VALUES (3284, 162, 3, 'Activar para ordenar columnas en orden descendente');
INSERT INTO `lang_definitions` VALUES (3285, 163, 3, 'Activar soporte de reclamación UB04/837I');
INSERT INTO `lang_definitions` VALUES (3286, 165, 3, 'Activo');
INSERT INTO `lang_definitions` VALUES (3287, 167, 3, 'Alerta Activa');
INSERT INTO `lang_definitions` VALUES (3288, 169, 3, 'Reglas de Alerta Activa');
INSERT INTO `lang_definitions` VALUES (3289, 170, 3, 'Alertas activas/Recordatorios');
INSERT INTO `lang_definitions` VALUES (3290, 171, 3, 'Gráfica activa');
INSERT INTO `lang_definitions` VALUES (3291, 174, 3, 'Directorio Activo - Controladores de Dominio');
INSERT INTO `lang_definitions` VALUES (3292, 175, 3, 'Directorio Activo - Sufijo de Cuenta');
INSERT INTO `lang_definitions` VALUES (3293, 176, 3, 'Visita Activa');
INSERT INTO `lang_definitions` VALUES (3294, 177, 3, 'Códigos de problemas activos');
INSERT INTO `lang_definitions` VALUES (3295, 178, 3, 'Listas Activas');
INSERT INTO `lang_definitions` VALUES (3296, 179, 3, 'Mensajes activos');
INSERT INTO `lang_definitions` VALUES (3297, 180, 3, 'Paciente Activo');
INSERT INTO `lang_definitions` VALUES (3298, 181, 3, 'Planes Activos');
INSERT INTO `lang_definitions` VALUES (3299, 182, 3, 'Plantillas Activas');
INSERT INTO `lang_definitions` VALUES (3300, 183, 3, 'Activo{{Appointment}}');
INSERT INTO `lang_definitions` VALUES (3301, 184, 3, 'Activo{{Code}}');
INSERT INTO `lang_definitions` VALUES (3302, 185, 3, 'Activo{{Drug}}');
INSERT INTO `lang_definitions` VALUES (3303, 186, 3, 'Activo{{Issue}}');
INSERT INTO `lang_definitions` VALUES (3304, 187, 3, 'Activo{{Item}}');
INSERT INTO `lang_definitions` VALUES (3305, 188, 3, 'Activo{{Note}}');
INSERT INTO `lang_definitions` VALUES (3306, 189, 3, 'Activo{{Plan}}');
INSERT INTO `lang_definitions` VALUES (3307, 190, 3, 'Activo{{Service}}');
INSERT INTO `lang_definitions` VALUES (3308, 191, 3, 'Actividad');
INSERT INTO `lang_definitions` VALUES (3309, 192, 3, 'Tipo de Actividad');
INSERT INTO `lang_definitions` VALUES (3310, 194, 3, 'Agudeza');
INSERT INTO `lang_definitions` VALUES (3311, 195, 3, 'AGUDEZA');
INSERT INTO `lang_definitions` VALUES (3312, 196, 3, 'Agudeza con Autorefracción');
INSERT INTO `lang_definitions` VALUES (3313, 197, 3, 'Agudeza con Lentes de Contacto');
INSERT INTO `lang_definitions` VALUES (3314, 198, 3, 'Agudeza con corrección');
INSERT INTO `lang_definitions` VALUES (3315, 199, 3, 'Agudeza con refracción Ciclopégica');
INSERT INTO `lang_definitions` VALUES (3316, 200, 3, 'Agudeza con Refracción Manifiesta');
INSERT INTO `lang_definitions` VALUES (3317, 202, 3, 'Agudeza sin corrección');
INSERT INTO `lang_definitions` VALUES (3318, 205, 3, 'Agudo en Crónico');
INSERT INTO `lang_definitions` VALUES (3319, 207, 3, 'Añadir');
INSERT INTO `lang_definitions` VALUES (3320, 208, 3, 'añadir');
INSERT INTO `lang_definitions` VALUES (3321, 209, 3, 'AÑADIR');
INSERT INTO `lang_definitions` VALUES (3322, 210, 3, 'Añadir una Sociedad');
INSERT INTO `lang_definitions` VALUES (3323, 211, 3, 'Añadir condición médica');
INSERT INTO `lang_definitions` VALUES (3324, 215, 3, 'Añadir una Farmacia');
INSERT INTO `lang_definitions` VALUES (3325, 217, 3, 'Añadir todas las reglas al plan');
INSERT INTO `lang_definitions` VALUES (3326, 218, 3, 'Añadir un evento para');
INSERT INTO `lang_definitions` VALUES (3327, 219, 3, 'Añadir como mensaje nuevo');
INSERT INTO `lang_definitions` VALUES (3328, 220, 3, 'Añadir como nueva nota');
INSERT INTO `lang_definitions` VALUES (3329, 221, 3, 'Añadir como Nuevo');
INSERT INTO `lang_definitions` VALUES (3330, 222, 3, 'Añadir como nuevo paciente');
INSERT INTO `lang_definitions` VALUES (3331, 224, 3, 'Agregar Botones');
INSERT INTO `lang_definitions` VALUES (3332, 225, 3, 'Agregar botones para caracteres especiales, Textos serán mostrados sobre el editor para incluir en el texto con un Click.');
INSERT INTO `lang_definitions` VALUES (3333, 226, 3, 'Añadir Categoría');
INSERT INTO `lang_definitions` VALUES (3334, 227, 3, 'Añadir Constante');
INSERT INTO `lang_definitions` VALUES (3335, 228, 3, 'Añadir Contexto');
INSERT INTO `lang_definitions` VALUES (3336, 229, 3, 'Añadir Co-pago');
INSERT INTO `lang_definitions` VALUES (3337, 230, 3, 'Añadir Criterios');
INSERT INTO `lang_definitions` VALUES (3338, 231, 3, 'Añadir Botón Personalizado');
INSERT INTO `lang_definitions` VALUES (3339, 234, 3, 'Añadir Diagnóstico');
INSERT INTO `lang_definitions` VALUES (3340, 235, 3, 'Añadir Medicamento');
INSERT INTO `lang_definitions` VALUES (3341, 236, 3, 'Añadir Editar Transacciones Ayuda');
INSERT INTO `lang_definitions` VALUES (3342, 237, 3, 'Añadir visita');
INSERT INTO `lang_definitions` VALUES (3343, 238, 3, 'Añadir Visita');
INSERT INTO `lang_definitions` VALUES (3344, 239, 3, 'Añadir Visita/notas');
INSERT INTO `lang_definitions` VALUES (3345, 240, 3, 'Añadir Centro');
INSERT INTO `lang_definitions` VALUES (3346, 241, 3, 'Añadir Campo');
INSERT INTO `lang_definitions` VALUES (3347, 242, 3, 'Añadir las siguientes líneas al fichero de configuración de Apache');
INSERT INTO `lang_definitions` VALUES (3348, 243, 3, 'Añadir Grupo');
INSERT INTO `lang_definitions` VALUES (3349, 244, 3, 'Añadir grupo');
INSERT INTO `lang_definitions` VALUES (3350, 245, 3, 'Añadir Código CIE');
INSERT INTO `lang_definitions` VALUES (3351, 246, 3, 'Agregar Vacunación');
INSERT INTO `lang_definitions` VALUES (3352, 247, 3, 'Añadir no permitido!');
INSERT INTO `lang_definitions` VALUES (3353, 248, 3, 'Añadir Incidencia');
INSERT INTO `lang_definitions` VALUES (3354, 249, 3, 'Añadir objeto a seguir');
INSERT INTO `lang_definitions` VALUES (3355, 250, 3, 'Añadir Idioma');
INSERT INTO `lang_definitions` VALUES (3356, 252, 3, 'Añadir manualmente');
INSERT INTO `lang_definitions` VALUES (3357, 254, 3, 'Añadir Modo');
INSERT INTO `lang_definitions` VALUES (3358, 255, 3, 'Añadir modificadores para este tipo de campo. Puede seleccionar más de uno.');
INSERT INTO `lang_definitions` VALUES (3359, 256, 3, 'Añadir más artículos');
INSERT INTO `lang_definitions` VALUES (3360, 257, 3, 'Añadir Nuevo');
INSERT INTO `lang_definitions` VALUES (3361, 258, 3, 'Añadir nuevo');
INSERT INTO `lang_definitions` VALUES (3362, 259, 3, 'Añadir nueva categoría:');
INSERT INTO `lang_definitions` VALUES (3363, 260, 3, 'Añadir nuevos Certificados al fichero de configuración de Apache');
INSERT INTO `lang_definitions` VALUES (3364, 261, 3, 'Añadir nuevo componente');
INSERT INTO `lang_definitions` VALUES (3365, 262, 3, 'Añadir nuevos componentes');
INSERT INTO `lang_definitions` VALUES (3366, 263, 3, 'Añadir nueva base de datos');
INSERT INTO `lang_definitions` VALUES (3367, 264, 3, 'Añadir nueva entrada');
INSERT INTO `lang_definitions` VALUES (3368, 265, 3, 'Añadir nuevo evento');
INSERT INTO `lang_definitions` VALUES (3369, 266, 3, 'Añadir Nuevo Formulario');
INSERT INTO `lang_definitions` VALUES (3370, 267, 3, 'AÑADIR NUEVO GRUPO');
INSERT INTO `lang_definitions` VALUES (3371, 268, 3, 'Añadir Nuevo Grupo');
INSERT INTO `lang_definitions` VALUES (3372, 269, 3, 'Añadir nuevo problema');
INSERT INTO `lang_definitions` VALUES (3373, 270, 3, 'Añadir nuevo lote y transacción');
INSERT INTO `lang_definitions` VALUES (3374, 271, 3, 'Añadir nuevo mensaje');
INSERT INTO `lang_definitions` VALUES (3375, 272, 3, 'Añadir Nueva Nota');
INSERT INTO `lang_definitions` VALUES (3376, 273, 3, 'Añadir nueva nota');
INSERT INTO `lang_definitions` VALUES (3377, 274, 3, 'Añadir Nuevo Socio');
INSERT INTO `lang_definitions` VALUES (3378, 275, 3, 'Añadir Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (3379, 277, 3, 'AÑADIR NUEVO PLAN');
INSERT INTO `lang_definitions` VALUES (3380, 278, 3, 'Añadir Nuevo...');
INSERT INTO `lang_definitions` VALUES (3381, 279, 3, 'Añadir Nuevo{{Event}}');
INSERT INTO `lang_definitions` VALUES (3382, 280, 3, 'Añadir Nuevo{{Message}}');
INSERT INTO `lang_definitions` VALUES (3383, 281, 3, 'Añadir Nuevo{{Provider}}');
INSERT INTO `lang_definitions` VALUES (3384, 282, 3, 'Añadir Nuevo{{Rule}}');
INSERT INTO `lang_definitions` VALUES (3385, 283, 3, 'Añadir Nuevo{{Type}}');
INSERT INTO `lang_definitions` VALUES (3386, 284, 3, 'Añadir Nota');
INSERT INTO `lang_definitions` VALUES (3387, 285, 3, 'Añadir actividad al portal Onsite');
INSERT INTO `lang_definitions` VALUES (3388, 286, 3, 'Añadir Paquete');
INSERT INTO `lang_definitions` VALUES (3389, 287, 3, 'Añadir Paciente');
INSERT INTO `lang_definitions` VALUES (3390, 288, 3, 'Añadir Registro de Paciente');
INSERT INTO `lang_definitions` VALUES (3391, 289, 3, 'Añadir Receta');
INSERT INTO `lang_definitions` VALUES (3392, 290, 3, 'Añadir procedimiento');
INSERT INTO `lang_definitions` VALUES (3393, 291, 3, 'Añadir numero del proveedor');
INSERT INTO `lang_definitions` VALUES (3394, 292, 3, 'Añadir retiro');
INSERT INTO `lang_definitions` VALUES (3395, 293, 3, 'Añadir Rehabilitación');
INSERT INTO `lang_definitions` VALUES (3396, 295, 3, 'Añadir Regla');
INSERT INTO `lang_definitions` VALUES (3397, 297, 3, 'Añadir hora a la fecha');
INSERT INTO `lang_definitions` VALUES (3398, 298, 3, 'Añadir a');
INSERT INTO `lang_definitions` VALUES (3399, 299, 3, 'AÑADIR A MENSAJE EXISTENTE');
INSERT INTO `lang_definitions` VALUES (3400, 300, 3, 'Añadir a mensaje existente');
INSERT INTO `lang_definitions` VALUES (3401, 302, 3, 'Añadir a lista de Medicación');
INSERT INTO `lang_definitions` VALUES (3402, 303, 3, 'Añadir a Lista de Medicación');
INSERT INTO `lang_definitions` VALUES (3403, 304, 3, 'Añadir Nivel Superior');
INSERT INTO `lang_definitions` VALUES (3404, 305, 3, 'Añadir Transacción');
INSERT INTO `lang_definitions` VALUES (3405, 306, 3, 'Añadir Usuario');
INSERT INTO `lang_definitions` VALUES (3406, 307, 3, 'Añadir Usuario al Grupo');
INSERT INTO `lang_definitions` VALUES (3407, 308, 3, 'Añadir.{{Additional Measurements}}');
INSERT INTO `lang_definitions` VALUES (3408, 309, 3, 'Añadir/Editar Receta electrónica');
INSERT INTO `lang_definitions` VALUES (3409, 310, 3, 'Añadir/Editar problema');
INSERT INTO `lang_definitions` VALUES (3410, 311, 3, 'Añadir/Editar Transacción de paciente');
INSERT INTO `lang_definitions` VALUES (3411, 312, 3, 'Añadido');
INSERT INTO `lang_definitions` VALUES (3412, 313, 3, 'Añadiendo');
INSERT INTO `lang_definitions` VALUES (3413, 314, 3, 'Añadiendo un participante');
INSERT INTO `lang_definitions` VALUES (3414, 315, 3, 'Añadir datos demográficos no autorizado.');
INSERT INTO `lang_definitions` VALUES (3415, 317, 3, 'Síndrome de Addison');
INSERT INTO `lang_definitions` VALUES (3416, 318, 3, 'Síndrome de Addison');
INSERT INTO `lang_definitions` VALUES (3417, 319, 3, 'Atributos adicionales');
INSERT INTO `lang_definitions` VALUES (3418, 320, 3, 'Puntos de Datos adicionales');
INSERT INTO `lang_definitions` VALUES (3419, 321, 3, 'Fecha adicional:');
INSERT INTO `lang_definitions` VALUES (3420, 322, 3, 'Diagnóstico adicional:');
INSERT INTO `lang_definitions` VALUES (3421, 323, 3, 'Hallazgos adicionales');
INSERT INTO `lang_definitions` VALUES (3422, 324, 3, 'Se puede acceder a funcionalidades adicionales, incluyendo la capacidad de enviar mensajes de texto SMS, marcación telefónica automática, correos electrónicos, etc., habilitando el Servicio de Comunicación MedEx opcional');
INSERT INTO `lang_definitions` VALUES (3423, 327, 3, 'Historia Adicional');
INSERT INTO `lang_definitions` VALUES (3424, 328, 3, 'Notas adicionales a la historia');
INSERT INTO `lang_definitions` VALUES (3425, 329, 3, 'Información adicional');
INSERT INTO `lang_definitions` VALUES (3426, 330, 3, 'Puede encontrar información adicional sobre las páginas individuales en sus respectivos archivos de ayuda');
INSERT INTO `lang_definitions` VALUES (3427, 333, 3, 'Laboratorios adicionales');
INSERT INTO `lang_definitions` VALUES (3428, 334, 3, 'Notas adicionales');
INSERT INTO `lang_definitions` VALUES (3429, 337, 3, 'Notas adicionales:');
INSERT INTO `lang_definitions` VALUES (3430, 338, 3, 'Notas adicionales:');
INSERT INTO `lang_definitions` VALUES (3431, 340, 3, 'Notas de Rayos X adicionales:');
INSERT INTO `lang_definitions` VALUES (3432, 344, 3, 'Sólo añadir');
INSERT INTO `lang_definitions` VALUES (3433, 346, 3, 'Libreta Direcciones');
INSERT INTO `lang_definitions` VALUES (3434, 347, 3, 'Libreta Direcciones');
INSERT INTO `lang_definitions` VALUES (3435, 348, 3, 'Dirección');
INSERT INTO `lang_definitions` VALUES (3436, 349, 3, 'Dirección y Código Postal');
INSERT INTO `lang_definitions` VALUES (3437, 350, 3, 'Dirección y Provincia/Departamento');
INSERT INTO `lang_definitions` VALUES (3438, 351, 3, 'Libreta de Direcciones');
INSERT INTO `lang_definitions` VALUES (3439, 352, 3, 'Entrada a la libreta de Direcciones de la empresa que realiza este procedimiento');
INSERT INTO `lang_definitions` VALUES (3440, 353, 3, 'Entrada a la libreta de Direcciones para el distribuidor');
INSERT INTO `lang_definitions` VALUES (3441, 354, 3, 'Entrada a la Libreta de Direcciones para el vendedor');
INSERT INTO `lang_definitions` VALUES (3442, 355, 3, 'Tipos de Libreta de Direcciones');
INSERT INTO `lang_definitions` VALUES (3443, 356, 3, 'Etiqueta de Dirección');
INSERT INTO `lang_definitions` VALUES (3444, 357, 3, 'Etiquetas de Dirección');
INSERT INTO `lang_definitions` VALUES (3445, 358, 3, 'Dirección Línea 1');
INSERT INTO `lang_definitions` VALUES (3446, 359, 3, 'Dirección Línea 2');
INSERT INTO `lang_definitions` VALUES (3447, 360, 3, 'Dirección Sola');
INSERT INTO `lang_definitions` VALUES (3448, 361, 3, 'Dirección, Ciudad, Estado y Código Postal ');
INSERT INTO `lang_definitions` VALUES (3449, 363, 3, 'Dirección, Provincia/Estado/Departamento y Código Postal');
INSERT INTO `lang_definitions` VALUES (3450, 364, 3, 'Dirección1');
INSERT INTO `lang_definitions` VALUES (3451, 365, 3, 'Dirección2');
INSERT INTO `lang_definitions` VALUES (3452, 366, 3, 'DIRIGIDO A');
INSERT INTO `lang_definitions` VALUES (3453, 367, 3, 'DESTINATARIO');
INSERT INTO `lang_definitions` VALUES (3454, 368, 3, 'AÑADIR{{Bifocal Add}}');
INSERT INTO `lang_definitions` VALUES (3455, 369, 3, 'AÑADIR{{Near Add}}');
INSERT INTO `lang_definitions` VALUES (3456, 370, 3, 'Ajuste');
INSERT INTO `lang_definitions` VALUES (3457, 371, 3, 'Importe de Ajuste');
INSERT INTO `lang_definitions` VALUES (3458, 374, 3, 'Ajustar');
INSERT INTO `lang_definitions` VALUES (3459, 376, 3, 'Ajuste');
INSERT INTO `lang_definitions` VALUES (3460, 377, 3, 'Ajuste importe');
INSERT INTO `lang_definitions` VALUES (3461, 378, 3, 'Motivos del ajuste');
INSERT INTO `lang_definitions` VALUES (3462, 382, 3, 'Valor de ajuste para código');
INSERT INTO `lang_definitions` VALUES (3463, 384, 3, 'Ajustes');
INSERT INTO `lang_definitions` VALUES (3464, 386, 3, 'Ajuste administrador');
INSERT INTO `lang_definitions` VALUES (3465, 387, 3, 'Administrador');
INSERT INTO `lang_definitions` VALUES (3466, 388, 3, 'email administrador');
INSERT INTO `lang_definitions` VALUES (3467, 389, 3, 'Administrar a través de');
INSERT INTO `lang_definitions` VALUES (3468, 391, 3, 'Administrado');
INSERT INTO `lang_definitions` VALUES (3469, 392, 3, 'Administrado por');
INSERT INTO `lang_definitions` VALUES (3470, 393, 3, 'Fecha Administrado');
INSERT INTO `lang_definitions` VALUES (3471, 394, 3, 'Sitio Administrado');
INSERT INTO `lang_definitions` VALUES (3472, 395, 3, 'Administración');
INSERT INTO `lang_definitions` VALUES (3473, 397, 3, 'Sitio de administración');
INSERT INTO `lang_definitions` VALUES (3474, 399, 3, 'Administradores');
INSERT INTO `lang_definitions` VALUES (3475, 400, 3, 'Los administradores pueden hacer todo');
INSERT INTO `lang_definitions` VALUES (3476, 404, 3, 'Revisión Peso de Adulto y Seguimiento');
INSERT INTO `lang_definitions` VALUES (3477, 405, 3, 'Revisión Peso de Adulto y Seguimiento (GCC)');
INSERT INTO `lang_definitions` VALUES (3478, 406, 3, 'Instrucción anticipada');
INSERT INTO `lang_definitions` VALUES (3479, 407, 3, 'Directriz Anticipada');
INSERT INTO `lang_definitions` VALUES (3480, 408, 3, 'Aviso Directriz Anticipada');
INSERT INTO `lang_definitions` VALUES (3481, 410, 3, 'Anticipado');
INSERT INTO `lang_definitions` VALUES (3482, 413, 3, 'Consejo');
INSERT INTO `lang_definitions` VALUES (3483, 415, 3, 'Afecta normales');
INSERT INTO `lang_definitions` VALUES (3484, 416, 3, 'Afrikaans');
INSERT INTO `lang_definitions` VALUES (3485, 417, 3, 'después');
INSERT INTO `lang_definitions` VALUES (3486, 419, 3, 'Llamadas fuera de horario laboral');
INSERT INTO `lang_definitions` VALUES (3487, 421, 3, 'Después de hacer las configuraciones mencionadas, importar el certificado del cliente de administrador al navegador y reiniciar el servidor Apache (Contraseña vacía)');
INSERT INTO `lang_definitions` VALUES (3488, 422, 3, 'Después de guardar el PDF');
INSERT INTO `lang_definitions` VALUES (3489, 423, 3, 'Después de guardar el PDF, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3490, 424, 3, 'Después de guardar el PDF, haga clic en [View Log] para comprobar si hay errores.');
INSERT INTO `lang_definitions` VALUES (3491, 425, 3, 'Después de guardar el archivo de TEXTO');
INSERT INTO `lang_definitions` VALUES (3492, 426, 3, 'Después de guardar los ficheros de TEXTO, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3493, 429, 3, 'Después de guardar su Batch, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3494, 432, 3, 'Una vez completada la informacion correctamente, click en botón Guardar');
INSERT INTO `lang_definitions` VALUES (3495, 433, 3, 'Después de subir, haga click en el botón \"Importar\"');
INSERT INTO `lang_definitions` VALUES (3496, 437, 3, 'Planificación posterior al cuidado');
INSERT INTO `lang_definitions` VALUES (3497, 439, 3, 'Otra vez');
INSERT INTO `lang_definitions` VALUES (3498, 440, 3, 'Edad');
INSERT INTO `lang_definitions` VALUES (3499, 441, 3, 'Edad de fallecimiento');
INSERT INTO `lang_definitions` VALUES (3500, 442, 3, 'Por Edad');
INSERT INTO `lang_definitions` VALUES (3501, 443, 3, 'Categoría edad');
INSERT INTO `lang_definitions` VALUES (3502, 444, 3, 'Dato edad fuera de rango.');
INSERT INTO `lang_definitions` VALUES (3503, 445, 3, 'Formato para mostrar edad');
INSERT INTO `lang_definitions` VALUES (3504, 446, 3, 'Formato edad en \'desde edad\' no es válido');
INSERT INTO `lang_definitions` VALUES (3505, 447, 3, 'Formato edad en \'hasta edad\' no es válido');
INSERT INTO `lang_definitions` VALUES (3506, 448, 3, 'Edad desde');
INSERT INTO `lang_definitions` VALUES (3507, 449, 3, 'Edad en años para cambio de formato');
INSERT INTO `lang_definitions` VALUES (3508, 450, 3, 'Edad Máxima');
INSERT INTO `lang_definitions` VALUES (3509, 451, 3, 'Edad Mínima');
INSERT INTO `lang_definitions` VALUES (3510, 452, 3, 'Rango de Edad');
INSERT INTO `lang_definitions` VALUES (3511, 453, 3, 'Columnas del envejecimiento');
INSERT INTO `lang_definitions` VALUES (3512, 454, 3, 'Columnas del envejecimiento:');
INSERT INTO `lang_definitions` VALUES (3513, 456, 3, 'Akan');
INSERT INTO `lang_definitions` VALUES (3514, 457, 3, 'Albanés');
INSERT INTO `lang_definitions` VALUES (3515, 458, 3, 'Alcohol');
INSERT INTO `lang_definitions` VALUES (3516, 459, 3, 'Consumo de alcohol');
INSERT INTO `lang_definitions` VALUES (3517, 460, 3, 'Uso de alcohol');
INSERT INTO `lang_definitions` VALUES (3518, 461, 3, 'Alerta');
INSERT INTO `lang_definitions` VALUES (3519, 462, 3, 'Contador de Alerta');
INSERT INTO `lang_definitions` VALUES (3520, 464, 3, 'Alerta en cumpleaños y después');
INSERT INTO `lang_definitions` VALUES (3521, 466, 3, 'Alerta en cumpleaños del paciente');
INSERT INTO `lang_definitions` VALUES (3522, 467, 3, 'Alerta solo en el cumpleaños');
INSERT INTO `lang_definitions` VALUES (3523, 468, 3, 'Tiempo de alerta');
INSERT INTO `lang_definitions` VALUES (3524, 469, 3, 'Alertas');
INSERT INTO `lang_definitions` VALUES (3525, 470, 3, 'Registro de alertas');
INSERT INTO `lang_definitions` VALUES (3526, 471, 3, 'Alertas/Recordatorios');
INSERT INTO `lang_definitions` VALUES (3527, 472, 3, 'Alerta{{Mental Status}} ');
INSERT INTO `lang_definitions` VALUES (3528, 473, 3, 'ALEUTIANO');
INSERT INTO `lang_definitions` VALUES (3529, 474, 3, 'Todos');
INSERT INTO `lang_definitions` VALUES (3530, 475, 3, 'TODOS');
INSERT INTO `lang_definitions` VALUES (3531, 476, 3, 'todos');
INSERT INTO `lang_definitions` VALUES (3532, 477, 3, 'Todos (Formatos Compaginados A)');
INSERT INTO `lang_definitions` VALUES (3533, 478, 3, 'Todos (Formatos Compaginados B)');
INSERT INTO `lang_definitions` VALUES (3534, 479, 3, 'Todos (Acumulativo)');
INSERT INTO `lang_definitions` VALUES (3535, 480, 3, 'Todas las alertas');
INSERT INTO `lang_definitions` VALUES (3536, 481, 3, 'Todo los Cálculos de Medidas Automatizados (CMA)');
INSERT INTO `lang_definitions` VALUES (3537, 482, 3, 'Todas las Categorías');
INSERT INTO `lang_definitions` VALUES (3538, 484, 3, 'Todos los Códigos');
INSERT INTO `lang_definitions` VALUES (3539, 485, 3, '¡Todos los campos de credenciales son sensibles a las mayúsculas y minúsculas!');
INSERT INTO `lang_definitions` VALUES (3540, 486, 3, 'Todas las fechas');
INSERT INTO `lang_definitions` VALUES (3541, 487, 3, 'Todo el día');
INSERT INTO `lang_definitions` VALUES (3542, 488, 3, 'Evento de día completo');
INSERT INTO `lang_definitions` VALUES (3543, 489, 3, 'Todos los campos demográficos, con búsqueda y chequeo de dupicados');
INSERT INTO `lang_definitions` VALUES (3544, 491, 3, 'Todos los episodios');
INSERT INTO `lang_definitions` VALUES (3545, 492, 3, 'Todas las Clínicas');
INSERT INTO `lang_definitions` VALUES (3546, 493, 3, 'Todas las Lesiones/Problemas/Incidencias');
INSERT INTO `lang_definitions` VALUES (3547, 495, 3, 'Permitidos todos los Idiomas');
INSERT INTO `lang_definitions` VALUES (3548, 496, 3, 'Todos los Mensajes');
INSERT INTO `lang_definitions` VALUES (3549, 498, 3, 'Todo o parte del nombre');
INSERT INTO `lang_definitions` VALUES (3550, 499, 3, 'Todo o parte del apellido');
INSERT INTO `lang_definitions` VALUES (3551, 500, 3, 'Todo o parte de la organización');
INSERT INTO `lang_definitions` VALUES (3552, 502, 3, 'Todos los pacientes');
INSERT INTO `lang_definitions` VALUES (3553, 505, 3, 'Todos los productos');
INSERT INTO `lang_definitions` VALUES (3554, 506, 3, 'Todos los proveedores');
INSERT INTO `lang_definitions` VALUES (3555, 507, 3, 'Todos Revisados y Negativos:');
INSERT INTO `lang_definitions` VALUES (3556, 513, 3, 'Todos los Temas');
INSERT INTO `lang_definitions` VALUES (3557, 516, 3, 'Todos los Usuarios');
INSERT INTO `lang_definitions` VALUES (3558, 518, 3, 'Alérgico');
INSERT INTO `lang_definitions` VALUES (3559, 519, 3, 'Alérgico a');
INSERT INTO `lang_definitions` VALUES (3560, 520, 3, 'Alergias');
INSERT INTO `lang_definitions` VALUES (3561, 523, 3, 'Alergias:');
INSERT INTO `lang_definitions` VALUES (3562, 524, 3, 'Alergia');
INSERT INTO `lang_definitions` VALUES (3563, 525, 3, 'Importación de Alergia completado con éxito');
INSERT INTO `lang_definitions` VALUES (3564, 527, 3, 'Reacción Alérgica');
INSERT INTO `lang_definitions` VALUES (3565, 528, 3, 'ADVERTENCIA DE ALERGIA');
INSERT INTO `lang_definitions` VALUES (3566, 529, 3, 'Advertencia de Alergia');
INSERT INTO `lang_definitions` VALUES (3567, 530, 3, 'Asignar');
INSERT INTO `lang_definitions` VALUES (3568, 531, 3, 'Permitir');
INSERT INTO `lang_definitions` VALUES (3569, 532, 3, 'Permitir a los Administradores Eliinar Pacientes');
INSERT INTO `lang_definitions` VALUES (3570, 533, 3, 'Permitir todos los idiomas disponibles como opción en el menú de inicio sesión.');
INSERT INTO `lang_definitions` VALUES (3571, 535, 3, 'Permitir creación de reclamaciones con diagnósticos pero no procedimientos o cargos. La mayoría de clínicas no desean esto.');
INSERT INTO `lang_definitions` VALUES (3572, 536, 3, 'Permitir Depuración de Idioma');
INSERT INTO `lang_definitions` VALUES (3573, 538, 3, 'Permitir la entrada anticipada');
INSERT INTO `lang_definitions` VALUES (3574, 539, 3, 'Permitir Email');
INSERT INTO `lang_definitions` VALUES (3575, 540, 3, '¿Permitir mensajes email?');
INSERT INTO `lang_definitions` VALUES (3576, 541, 3, '¿Permitir Email?');
INSERT INTO `lang_definitions` VALUES (3577, 542, 3, 'Permitir reclamación de Visita');
INSERT INTO `lang_definitions` VALUES (3578, 543, 3, 'Permitir Episodio para Cada Cita');
INSERT INTO `lang_definitions` VALUES (3579, 544, 3, 'Permitir Intercambio de Información Médica ');
INSERT INTO `lang_definitions` VALUES (3580, 545, 3, 'Permitir el Intercambio de Información de Salud');
INSERT INTO `lang_definitions` VALUES (3581, 546, 3, 'Permitir Compartir Información de Inmunización');
INSERT INTO `lang_definitions` VALUES (3582, 547, 3, 'Permitir Compartir Información de Vacunación');
INSERT INTO `lang_definitions` VALUES (3583, 548, 3, 'Permitir el Uso del Registro de Vacunaciones');
INSERT INTO `lang_definitions` VALUES (3584, 552, 3, 'Permitir mensajes email');
INSERT INTO `lang_definitions` VALUES (3585, 554, 3, 'Permitir más de un seguro médico');
INSERT INTO `lang_definitions` VALUES (3586, 556, 3, 'Permitir múltiples bases de datos');
INSERT INTO `lang_definitions` VALUES (3587, 559, 3, 'Permitir Citas Online');
INSERT INTO `lang_definitions` VALUES (3588, 560, 3, 'Permitir Pagos Online');
INSERT INTO `lang_definitions` VALUES (3589, 561, 3, 'Permitir Chat Seguro');
INSERT INTO `lang_definitions` VALUES (3590, 562, 3, 'Permitir solo un seguro médico');
INSERT INTO `lang_definitions` VALUES (3591, 574, 3, 'Permitir el Registro de Pacientes');
INSERT INTO `lang_definitions` VALUES (3592, 575, 3, 'Permitir Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (3593, 583, 3, 'Permitir SMS');
INSERT INTO `lang_definitions` VALUES (3594, 584, 3, '¿Permitir SMS (mensajes de texto)?');
INSERT INTO `lang_definitions` VALUES (3595, 586, 3, '¿Permitir la activación instantánea de los eventos introducidos?');
INSERT INTO `lang_definitions` VALUES (3596, 587, 3, '¿Permitir mensajes telefónicos?');
INSERT INTO `lang_definitions` VALUES (3597, 588, 3, 'Permitir usar con múltiples bases de datos ');
INSERT INTO `lang_definitions` VALUES (3598, 589, 3, 'Permitir a los usuarios publicar eventos globales');
INSERT INTO `lang_definitions` VALUES (3599, 590, 3, 'Permitir a los usuarios publicar calendarios personales');
INSERT INTO `lang_definitions` VALUES (3600, 595, 3, 'Permitir llamadas de voz ');
INSERT INTO `lang_definitions` VALUES (3601, 596, 3, 'Permitir Mensaje de Voz');
INSERT INTO `lang_definitions` VALUES (3602, 597, 3, 'Permitido');
INSERT INTO `lang_definitions` VALUES (3603, 598, 3, 'Idiomas Permitidos');
INSERT INTO `lang_definitions` VALUES (3604, 600, 3, 'Asignado ©');
INSERT INTO `lang_definitions` VALUES (3605, 601, 3, 'Permite E-sign en todo el encuentro');
INSERT INTO `lang_definitions` VALUES (3606, 602, 3, 'Permite E-sign para formas individuales');
INSERT INTO `lang_definitions` VALUES (3607, 603, 3, 'Permitir Correo Electrónico');
INSERT INTO `lang_definitions` VALUES (3608, 604, 3, 'Permitir Mensajes de voz');
INSERT INTO `lang_definitions` VALUES (3609, 610, 3, 'ya existe');
INSERT INTO `lang_definitions` VALUES (3610, 611, 3, 'ya existe! Por favor, pruebe de nuevo');
INSERT INTO `lang_definitions` VALUES (3611, 612, 3, 'ya existe.');
INSERT INTO `lang_definitions` VALUES (3612, 613, 3, 'Ya ha sido registrado');
INSERT INTO `lang_definitions` VALUES (3613, 614, 3, 'Identificador ya usado, elija otro');
INSERT INTO `lang_definitions` VALUES (3614, 615, 3, 'Título ya usado, elija otro');
INSERT INTO `lang_definitions` VALUES (3615, 617, 3, 'Dirección alternativa');
INSERT INTO `lang_definitions` VALUES (3616, 618, 3, 'Ciudad Alternativa');
INSERT INTO `lang_definitions` VALUES (3617, 619, 3, 'Código Postal Alternativo');
INSERT INTO `lang_definitions` VALUES (3618, 620, 3, 'Estado Alternativo');
INSERT INTO `lang_definitions` VALUES (3619, 621, 3, 'modificar');
INSERT INTO `lang_definitions` VALUES (3620, 628, 3, 'De forma alternativa, puede usar la página de búsqueda para cargar un fichero electrónico (X12835) que haya recibido de su pagador. Puede hacerlo presionando el botón Explorar y seleccionar el fichero a cargar, y luego pulsando Explorar para ejecutar la carga y mostrar las facturas correspondientes. En este caso, los otros parámetros mencionados arriba no se aplican y pueden ser ignorados. La carga guarda el fichero pero no procesa su contenido - esto se realiza de forma separada como se describe abajo.');
INSERT INTO `lang_definitions` VALUES (3621, 631, 3, 'AM');
INSERT INTO `lang_definitions` VALUES (3622, 632, 3, 'Programa AM');
INSERT INTO `lang_definitions` VALUES (3623, 633, 3, 'Ambliopía');
INSERT INTO `lang_definitions` VALUES (3624, 634, 3, 'Ambulancia - Aérea o Marítima');
INSERT INTO `lang_definitions` VALUES (3625, 635, 3, 'Ambulancia - Terrestre');
INSERT INTO `lang_definitions` VALUES (3626, 636, 3, 'Centro Quirúrgico Ambulatorio');
INSERT INTO `lang_definitions` VALUES (3627, 637, 3, 'Cálculo Automático de Medidas (CAM)');
INSERT INTO `lang_definitions` VALUES (3628, 638, 3, 'Rastreo CAM');
INSERT INTO `lang_definitions` VALUES (3629, 645, 3, 'Corregir nota existente');
INSERT INTO `lang_definitions` VALUES (3630, 646, 3, 'Corrección');
INSERT INTO `lang_definitions` VALUES (3631, 647, 3, 'Corrección de');
INSERT INTO `lang_definitions` VALUES (3632, 648, 3, 'Lista de Correcciones');
INSERT INTO `lang_definitions` VALUES (3633, 649, 3, 'Estado de Correcciones');
INSERT INTO `lang_definitions` VALUES (3634, 650, 3, 'Correcciones');
INSERT INTO `lang_definitions` VALUES (3635, 655, 3, 'Indígena americano');
INSERT INTO `lang_definitions` VALUES (3636, 656, 3, 'Indígena americano o Nativo de Alaska');
INSERT INTO `lang_definitions` VALUES (3637, 657, 3, 'AMEX');
INSERT INTO `lang_definitions` VALUES (3638, 658, 3, 'Amárico (Lengua de Etiopia)');
INSERT INTO `lang_definitions` VALUES (3639, 659, 3, 'Importe');
INSERT INTO `lang_definitions` VALUES (3640, 660, 3, 'Cantidad Administrada');
INSERT INTO `lang_definitions` VALUES (3641, 662, 3, 'Importes Cargados');
INSERT INTO `lang_definitions` VALUES (3642, 665, 3, 'Importe Saldo Vencido');
INSERT INTO `lang_definitions` VALUES (3643, 666, 3, 'Importe por esta visita');
INSERT INTO `lang_definitions` VALUES (3644, 667, 3, 'Importe pagado');
INSERT INTO `lang_definitions` VALUES (3645, 668, 3, 'Importe:');
INSERT INTO `lang_definitions` VALUES (3646, 671, 3, 'Importe Facturado');
INSERT INTO `lang_definitions` VALUES (3647, 676, 3, '¡Se requiere una fecha de finalización posterior a la fecha de inicio para los eventos repetidos!');
INSERT INTO `lang_definitions` VALUES (3648, 678, 3, 'Ocurrió un error durante la descarga web de los directorios de OpenEMR');
INSERT INTO `lang_definitions` VALUES (3649, 679, 3, 'Ocurrió un error durante la descarga web de los directorios de phpGACL');
INSERT INTO `lang_definitions` VALUES (3650, 680, 3, 'Ocurrió un error durante la descarga web de los directorios SQL-Ledger');
INSERT INTO `lang_definitions` VALUES (3651, 685, 3, 'Una incidencia GCAC incompleta ha sido creada y vinculada. Alguien tendrá que completarla más tarde.');
INSERT INTO `lang_definitions` VALUES (3652, 693, 3, 'Ocurrio un error inesperado.');
INSERT INTO `lang_definitions` VALUES (3653, 696, 3, 'Una letra mayúscula');
INSERT INTO `lang_definitions` VALUES (3654, 698, 3, 'y');
INSERT INTO `lang_definitions` VALUES (3655, 699, 3, 'Y');
INSERT INTO `lang_definitions` VALUES (3656, 700, 3, 'Y');
INSERT INTO `lang_definitions` VALUES (3657, 701, 3, 'y');
INSERT INTO `lang_definitions` VALUES (3658, 702, 3, '¿y toda la información subordinada? Esta acción será registrada');
INSERT INTO `lang_definitions` VALUES (3659, 703, 3, 'y modificador');
INSERT INTO `lang_definitions` VALUES (3660, 704, 3, 'y procesado.');
INSERT INTO `lang_definitions` VALUES (3661, 706, 3, 'y reiniciar servidor Apache');
INSERT INTO `lang_definitions` VALUES (3662, 707, 3, 'y la Razón es');
INSERT INTO `lang_definitions` VALUES (3663, 709, 3, 'Anemia');
INSERT INTO `lang_definitions` VALUES (3664, 710, 3, 'Tobillo');
INSERT INTO `lang_definitions` VALUES (3665, 711, 3, 'Tobillo + talón');
INSERT INTO `lang_definitions` VALUES (3666, 712, 3, 'Formulario de Evaluación del tobillo');
INSERT INTO `lang_definitions` VALUES (3667, 713, 3, 'Problemas de tobillo');
INSERT INTO `lang_definitions` VALUES (3668, 714, 3, 'Espondilitis anquilosante');
INSERT INTO `lang_definitions` VALUES (3669, 715, 3, 'Espondilitis anquilosante');
INSERT INTO `lang_definitions` VALUES (3670, 716, 3, 'Anorexia');
INSERT INTO `lang_definitions` VALUES (3671, 717, 3, 'Otra cosa que puede hacer en la ventana de publicación es solicitar facturación secundaria. Si selecciona la casilla de verificación antes de guardar, la reclamación original será reabierta y puesta en cola en la página de Facturación, y será procesada en el siguiente proceso de facturación.');
INSERT INTO `lang_definitions` VALUES (3672, 721, 3, 'ante');
INSERT INTO `lang_definitions` VALUES (3673, 723, 3, 'Segmento Anterior');
INSERT INTO `lang_definitions` VALUES (3674, 724, 3, 'Valores por Defecto para el Segmento Anterior');
INSERT INTO `lang_definitions` VALUES (3675, 726, 3, 'Ano normal, recto sin distensión ni masa');
INSERT INTO `lang_definitions` VALUES (3676, 727, 3, 'Ansiedad');
INSERT INTO `lang_definitions` VALUES (3677, 729, 3, 'Cualquiera');
INSERT INTO `lang_definitions` VALUES (3678, 732, 3, 'Cualquier Categoría');
INSERT INTO `lang_definitions` VALUES (3679, 738, 3, 'Cualquier parte del código deseado o su descripción');
INSERT INTO `lang_definitions` VALUES (3680, 740, 3, 'Cualquier parte de la especialidad deseada');
INSERT INTO `lang_definitions` VALUES (3681, 741, 3, 'Cualquier parte del identificador o nombre de medicamento');
INSERT INTO `lang_definitions` VALUES (3682, 742, 3, 'Cualquier parte del identificador o nombre de vacuna');
INSERT INTO `lang_definitions` VALUES (3683, 743, 3, 'Cualquier parte del nombre del paciente, o Apellido, Nombre, o X-Y');
INSERT INTO `lang_definitions` VALUES (3684, 745, 3, '¿Algo más ocurre al mismo tiempo?');
INSERT INTO `lang_definitions` VALUES (3685, 750, 3, 'Clave API para puerta enlace SMS');
INSERT INTO `lang_definitions` VALUES (3686, 754, 3, 'Apnea');
INSERT INTO `lang_definitions` VALUES (3687, 761, 3, 'Aspecto');
INSERT INTO `lang_definitions` VALUES (3688, 762, 3, 'Aspecto:');
INSERT INTO `lang_definitions` VALUES (3689, 765, 3, 'Añadir esta nota');
INSERT INTO `lang_definitions` VALUES (3690, 767, 3, 'Añadir a la nota existente');
INSERT INTO `lang_definitions` VALUES (3691, 768, 3, 'Añadir a sta nota');
INSERT INTO `lang_definitions` VALUES (3692, 769, 3, 'Añadir a Esta Nota');
INSERT INTO `lang_definitions` VALUES (3693, 770, 3, 'Apendicectomía');
INSERT INTO `lang_definitions` VALUES (3694, 773, 3, 'Pacientes Aplicables');
INSERT INTO `lang_definitions` VALUES (3695, 775, 3, 'Nombre de aplicación para página de inicio de sesión y título de ventana principal');
INSERT INTO `lang_definitions` VALUES (3696, 777, 3, 'Código de Aplicación del receptor (GS03 - si está en blanco se usará ISA08)');
INSERT INTO `lang_definitions` VALUES (3697, 778, 3, 'Codigo de Aplicacion del Enviador (GS02)');
INSERT INTO `lang_definitions` VALUES (3698, 779, 3, 'Título de Aplicación');
INSERT INTO `lang_definitions` VALUES (3699, 780, 3, 'Se aplica al formulario de Constantes Vitales y Gráfica de Crecimiento');
INSERT INTO `lang_definitions` VALUES (3700, 783, 3, '¿Aplicar los cambios sólo al evento actual, a éste y todos los episodios futuros, o a todos los episodios?');
INSERT INTO `lang_definitions` VALUES (3701, 784, 3, 'aplicar a la zona afectada');
INSERT INTO `lang_definitions` VALUES (3702, 785, 3, 'aplicar a la piel');
INSERT INTO `lang_definitions` VALUES (3703, 786, 3, 'Aplicando');
INSERT INTO `lang_definitions` VALUES (3704, 787, 3, 'Aplicando parche al sitio');
INSERT INTO `lang_definitions` VALUES (3705, 788, 3, 'Cita');
INSERT INTO `lang_definitions` VALUES (3706, 790, 3, 'Fecha de Cita');
INSERT INTO `lang_definitions` VALUES (3707, 796, 3, 'Estilo de visualizacion de la cita');
INSERT INTO `lang_definitions` VALUES (3708, 798, 3, 'Regla para recordar Cita');
INSERT INTO `lang_definitions` VALUES (3709, 800, 3, 'Estado de la Cita');
INSERT INTO `lang_definitions` VALUES (3710, 801, 3, 'Estados de la cita');
INSERT INTO `lang_definitions` VALUES (3711, 802, 3, 'Cita dentro de');
INSERT INTO `lang_definitions` VALUES (3712, 803, 3, 'Color de Cita/Evento');
INSERT INTO `lang_definitions` VALUES (3713, 804, 3, 'Citas');
INSERT INTO `lang_definitions` VALUES (3714, 805, 3, 'Citas (escriba opcional)');
INSERT INTO `lang_definitions` VALUES (3715, 806, 3, 'Citas (escribir, algunos opcional)');
INSERT INTO `lang_definitions` VALUES (3716, 812, 3, 'Citas y Visitas');
INSERT INTO `lang_definitions` VALUES (3717, 813, 3, 'Encuentros para');
INSERT INTO `lang_definitions` VALUES (3718, 814, 3, 'Informe de citas');
INSERT INTO `lang_definitions` VALUES (3719, 815, 3, 'Informes Citas-Visitas');
INSERT INTO `lang_definitions` VALUES (3720, 818, 3, 'Aprobar');
INSERT INTO `lang_definitions` VALUES (3721, 821, 3, 'Aprobado');
INSERT INTO `lang_definitions` VALUES (3722, 822, 3, 'Eventos Administrativos Aprobados');
INSERT INTO `lang_definitions` VALUES (3723, 828, 3, 'Citas-Visitas');
INSERT INTO `lang_definitions` VALUES (3724, 830, 3, 'Citas');
INSERT INTO `lang_definitions` VALUES (3725, 833, 3, 'Abr');
INSERT INTO `lang_definitions` VALUES (3726, 834, 3, 'Abril');
INSERT INTO `lang_definitions` VALUES (3727, 836, 3, 'Arábigo');
INSERT INTO `lang_definitions` VALUES (3728, 837, 3, 'Aragonés');
INSERT INTO `lang_definitions` VALUES (3729, 838, 3, 'Archivo');
INSERT INTO `lang_definitions` VALUES (3730, 839, 3, 'Archivar los Registros Cronológicos');
INSERT INTO `lang_definitions` VALUES (3731, 840, 3, 'Archivas Registros (Logs) Viejos');
INSERT INTO `lang_definitions` VALUES (3732, 841, 3, '¿Se traducen los nombres del grupo de control de acceso?');
INSERT INTO `lang_definitions` VALUES (3733, 842, 3, '¿Se traducen los nombres de las categorías de cita?');
INSERT INTO `lang_definitions` VALUES (3734, 843, 3, '¿Se traducen los nombres de categorías de documento?');
INSERT INTO `lang_definitions` VALUES (3735, 844, 3, '¿Se cobran honorarios por este tipo?');
INSERT INTO `lang_definitions` VALUES (3736, 845, 3, 'están apagados');
INSERT INTO `lang_definitions` VALUES (3737, 846, 3, 'están encendidos');
INSERT INTO `lang_definitions` VALUES (3738, 847, 3, '¿Se traducen los títulos de las notas del paciente?');
INSERT INTO `lang_definitions` VALUES (3739, 848, 3, '¿Están los códigos archivados en tablas sql externas (0-No, 1-CIE10, 2-SNOMED(RF1), 3-SNOMED(rf2))?');
INSERT INTO `lang_definitions` VALUES (3740, 850, 3, '¿Está preparado para completar una nueva incidencia de GCAC (Global Connection Admission Control) para esta visita?');
INSERT INTO `lang_definitions` VALUES (3741, 852, 3, '¿Está seguro de enviar hoy?');
INSERT INTO `lang_definitions` VALUES (3742, 853, 3, '¿Está seguro que quiere aprobar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3743, 854, 3, '¿Está seguro de querer cancelar los cambios?');
INSERT INTO `lang_definitions` VALUES (3744, 856, 3, '¿Está seguro de que desea eliminar por completo este formulario?');
INSERT INTO `lang_definitions` VALUES (3745, 859, 3, '¿Está seguro que desea eliminar este aviso?');
INSERT INTO `lang_definitions` VALUES (3746, 860, 3, '¿Está seguro que quiere eliminar este evento?');
INSERT INTO `lang_definitions` VALUES (3747, 861, 3, '¿Está seguro que quiere eliminar este asunto de la base de datos?');
INSERT INTO `lang_definitions` VALUES (3748, 864, 3, '¿Está usted seguro que quiere eliminar esta nota?');
INSERT INTO `lang_definitions` VALUES (3749, 866, 3, '¿Está seguro que quiere editar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3750, 867, 3, '¿Está seguro que quiere ocultar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3751, 870, 3, '¿Está seguro que quiere visualizar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3752, 871, 3, 'Está seguro que desea eliminar el grupo entero nombrado');
INSERT INTO `lang_definitions` VALUES (3753, 872, 3, 'Está seguro que desea eliminar la lista entera');
INSERT INTO `lang_definitions` VALUES (3754, 873, 3, 'Está seguro que quiere eliminar el campo interno');
INSERT INTO `lang_definitions` VALUES (3755, 874, 3, '¿Está seguro que quiere eliminar los campos seleccionados?');
INSERT INTO `lang_definitions` VALUES (3756, 877, 3, '¿Está seguro que quiere continuar con estas acciones?');
INSERT INTO `lang_definitions` VALUES (3757, 879, 3, 'Zona no especificada');
INSERT INTO `lang_definitions` VALUES (3758, 880, 3, 'Brazo');
INSERT INTO `lang_definitions` VALUES (3759, 881, 3, 'Armenio');
INSERT INTO `lang_definitions` VALUES (3760, 888, 3, 'Arritmia');
INSERT INTO `lang_definitions` VALUES (3761, 889, 3, 'Artritis');
INSERT INTO `lang_definitions` VALUES (3762, 890, 3, 'Artritis/Enfermedad degenerativa de articulaciones');
INSERT INTO `lang_definitions` VALUES (3763, 891, 3, 'Artritis/Enfermedad degenerativa de articulaciones');
INSERT INTO `lang_definitions` VALUES (3764, 895, 3, 'como');
INSERT INTO `lang_definitions` VALUES (3765, 900, 3, 'Desde');
INSERT INTO `lang_definitions` VALUES (3766, 908, 3, 'Asiático');
INSERT INTO `lang_definitions` VALUES (3767, 912, 3, 'Evaluación');
INSERT INTO `lang_definitions` VALUES (3768, 920, 3, 'Asignado a');
INSERT INTO `lang_definitions` VALUES (3769, 921, 3, 'Ayudante');
INSERT INTO `lang_definitions` VALUES (3770, 928, 3, 'Asma');
INSERT INTO `lang_definitions` VALUES (3771, 929, 3, 'en');
INSERT INTO `lang_definitions` VALUES (3772, 931, 3, 'Se requiere al menos un parámetro de búsqueda si selecciona Todos.');
INSERT INTO `lang_definitions` VALUES (3773, 934, 3, 'En el Escafoides');
INSERT INTO `lang_definitions` VALUES (3774, 935, 3, 'En el Escafoides:');
INSERT INTO `lang_definitions` VALUES (3775, 936, 3, 'Equipo de atletismo');
INSERT INTO `lang_definitions` VALUES (3776, 938, 3, 'Lesión Deportiva');
INSERT INTO `lang_definitions` VALUES (3777, 939, 3, 'Certificado CA de ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3778, 940, 3, 'Host de auditoría ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3779, 941, 3, 'Certificado local de ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3780, 942, 3, 'Puerto de auditoría ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3781, 945, 3, 'Atención');
INSERT INTO `lang_definitions` VALUES (3782, 947, 3, 'Atención');
INSERT INTO `lang_definitions` VALUES (3783, 959, 3, 'Auditoría Backups de inicio de sesión');
INSERT INTO `lang_definitions` VALUES (3784, 960, 3, 'Auditoría de inicio de sesión varios');
INSERT INTO `lang_definitions` VALUES (3785, 961, 3, 'Auditoría Orden de inicio de sesión');
INSERT INTO `lang_definitions` VALUES (3786, 962, 3, 'Auditoría registro inicio de sesión del paciente');
INSERT INTO `lang_definitions` VALUES (3787, 963, 3, 'Auditoría Planificación inicio sesión');
INSERT INTO `lang_definitions` VALUES (3788, 964, 3, 'Auditoría Administración de Seguridad inicio sesión');
INSERT INTO `lang_definitions` VALUES (3789, 965, 3, 'Auditoría Consulta SELECT inicio sesión');
INSERT INTO `lang_definitions` VALUES (3790, 968, 3, 'Ago');
INSERT INTO `lang_definitions` VALUES (3791, 969, 3, 'Agosto');
INSERT INTO `lang_definitions` VALUES (3792, 971, 3, 'Autorización');
INSERT INTO `lang_definitions` VALUES (3793, 972, 3, 'Autorización/notas');
INSERT INTO `lang_definitions` VALUES (3794, 993, 3, 'Grupo de Autorización');
INSERT INTO `lang_definitions` VALUES (3795, 994, 3, 'Estatus de autorización');
INSERT INTO `lang_definitions` VALUES (3796, 995, 3, 'Autorizaciones');
INSERT INTO `lang_definitions` VALUES (3797, 996, 3, 'Autorizar');
INSERT INTO `lang_definitions` VALUES (3798, 997, 3, 'Autorizar - cualquier visita');
INSERT INTO `lang_definitions` VALUES (3799, 999, 3, 'Autorizar - mis visitas');
INSERT INTO `lang_definitions` VALUES (3800, 1005, 3, 'Autorizado');
INSERT INTO `lang_definitions` VALUES (3801, 1007, 3, 'Autorización solamente');
INSERT INTO `lang_definitions` VALUES (3802, 1012, 3, 'Envío automático');
INSERT INTO `lang_definitions` VALUES (3803, 1015, 3, 'Crear automáticamente nuevas visitas');
INSERT INTO `lang_definitions` VALUES (3804, 1016, 3, 'Auto-generado');
INSERT INTO `lang_definitions` VALUES (3805, 1018, 3, 'Cálculos Automáticos de Medida (CAM)');
INSERT INTO `lang_definitions` VALUES (3806, 1023, 3, 'Seguimiento Cálculos Automáticos de Medida (CAM)');
INSERT INTO `lang_definitions` VALUES (3807, 1024, 3, 'Medidas Automatizadas');
INSERT INTO `lang_definitions` VALUES (3808, 1026, 3, 'Automático');
INSERT INTO `lang_definitions` VALUES (3809, 1030, 3, 'Crear automáticamente nuevas visitas cuando en el estado de una cita se selecciona -@- (llegado)');
INSERT INTO `lang_definitions` VALUES (3810, 1035, 3, 'Automóvil Médico');
INSERT INTO `lang_definitions` VALUES (3811, 1037, 3, 'Autoguardado');
INSERT INTO `lang_definitions` VALUES (3812, 1040, 3, 'Categorías Disponibles');
INSERT INTO `lang_definitions` VALUES (3813, 1045, 3, 'Horas disponibles');
INSERT INTO `lang_definitions` VALUES (3814, 1050, 3, 'Media Mensual');
INSERT INTO `lang_definitions` VALUES (3815, 1054, 3, 'Avulsión/fractura por avulsión');
INSERT INTO `lang_definitions` VALUES (3816, 1055, 3, 'Avulsión de maleolo lateral');
INSERT INTO `lang_definitions` VALUES (3817, 1056, 3, 'Avulsión de maléolo tibial');
INSERT INTO `lang_definitions` VALUES (3818, 1057, 3, 'Basado en el Conocimiento');
INSERT INTO `lang_definitions` VALUES (3819, 1059, 3, 'Axilar');
INSERT INTO `lang_definitions` VALUES (3820, 1066, 3, 'dos veces por día');
INSERT INTO `lang_definitions` VALUES (3821, 1067, 3, 'Atrás');
INSERT INTO `lang_definitions` VALUES (3822, 1068, 3, 'atrás');
INSERT INTO `lang_definitions` VALUES (3823, 1069, 3, 'Retrocede ocho visitas');
INSERT INTO `lang_definitions` VALUES (3824, 1070, 3, 'Retrocede once visitas');
INSERT INTO `lang_definitions` VALUES (3825, 1071, 3, 'Retroceder cinco visitas');
INSERT INTO `lang_definitions` VALUES (3826, 1072, 3, 'Retrocede cuatro visitas');
INSERT INTO `lang_definitions` VALUES (3827, 1073, 3, 'Retrocede nueve visitas');
INSERT INTO `lang_definitions` VALUES (3828, 1074, 3, 'Retroced una visita');
INSERT INTO `lang_definitions` VALUES (3829, 1075, 3, 'Dolor de espalda');
INSERT INTO `lang_definitions` VALUES (3830, 1076, 3, 'Problemas de espalda');
INSERT INTO `lang_definitions` VALUES (3831, 1077, 3, 'Retrocede siete visitas');
INSERT INTO `lang_definitions` VALUES (3832, 1078, 3, 'Retrocede seis visitas');
INSERT INTO `lang_definitions` VALUES (3833, 1079, 3, 'Cirugia de espalda');
INSERT INTO `lang_definitions` VALUES (3834, 1080, 3, 'Retrocede diez visitas');
INSERT INTO `lang_definitions` VALUES (3835, 1081, 3, 'Retrocede tres visitas');
INSERT INTO `lang_definitions` VALUES (3836, 1082, 3, 'Volver a la página de Administración');
INSERT INTO `lang_definitions` VALUES (3837, 1087, 3, 'Volver al paciente');
INSERT INTO `lang_definitions` VALUES (3838, 1089, 3, 'Volver a los usuarios');
INSERT INTO `lang_definitions` VALUES (3839, 1090, 3, 'Volver a Vista');
INSERT INTO `lang_definitions` VALUES (3840, 1091, 3, 'Retrocede doce visitas');
INSERT INTO `lang_definitions` VALUES (3841, 1092, 3, 'Retrocede dos visitas');
INSERT INTO `lang_definitions` VALUES (3842, 1094, 3, 'Backup');
INSERT INTO `lang_definitions` VALUES (3843, 1096, 3, 'Se ha creado el fichero de backup. Ahora comenzará la descarga.');
INSERT INTO `lang_definitions` VALUES (3844, 1098, 3, 'Backup creado correctamente');
INSERT INTO `lang_definitions` VALUES (3845, 1100, 3, 'Cheque sin fondos');
INSERT INTO `lang_definitions` VALUES (3846, 1101, 3, 'Mal crédito');
INSERT INTO `lang_definitions` VALUES (3847, 1102, 3, 'Bahasa Indonesia');
INSERT INTO `lang_definitions` VALUES (3848, 1103, 3, 'Bal');
INSERT INTO `lang_definitions` VALUES (3849, 1106, 3, 'Balance');
INSERT INTO `lang_definitions` VALUES (3850, 1107, 3, 'balance');
INSERT INTO `lang_definitions` VALUES (3851, 1108, 3, 'Importe Balance');
INSERT INTO `lang_definitions` VALUES (3852, 1109, 3, 'Balance a pagar');
INSERT INTO `lang_definitions` VALUES (3853, 1113, 3, 'Recibo bancario');
INSERT INTO `lang_definitions` VALUES (3854, 1117, 3, 'Base del quinto (5to) Metatarsiano');
INSERT INTO `lang_definitions` VALUES (3855, 1118, 3, 'Base del quinto (5to) Metatarsiano:');
INSERT INTO `lang_definitions` VALUES (3856, 1127, 3, 'Herramienta de Comunicación del Batch');
INSERT INTO `lang_definitions` VALUES (3857, 1129, 3, 'Batch de entrada de pagos');
INSERT INTO `lang_definitions` VALUES (3858, 1130, 3, 'Serie de Pagos');
INSERT INTO `lang_definitions` VALUES (3859, 1131, 3, 'Iniciado proceso Batch; esto puede tardar unos minutos.');
INSERT INTO `lang_definitions` VALUES (3860, 1132, 3, 'Resultados de la serie (Batch)');
INSERT INTO `lang_definitions` VALUES (3861, 1133, 3, 'Comunicación en serie');
INSERT INTO `lang_definitions` VALUES (3862, 1140, 3, 'porque no existe ese id.');
INSERT INTO `lang_definitions` VALUES (3863, 1150, 3, 'Empezar');
INSERT INTO `lang_definitions` VALUES (3864, 1152, 3, 'Fecha comienzo');
INSERT INTO `lang_definitions` VALUES (3865, 1156, 3, 'Fecha de inicio de servicio aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (3866, 1157, 3, 'Hora de inicio del día para los eventos del calendario');
INSERT INTO `lang_definitions` VALUES (3867, 1164, 3, 'Eructo');
INSERT INTO `lang_definitions` VALUES (3868, 1169, 3, 'Bengali');
INSERT INTO `lang_definitions` VALUES (3869, 1173, 3, 'entre');
INSERT INTO `lang_definitions` VALUES (3870, 1180, 3, 'Bilateral');
INSERT INTO `lang_definitions` VALUES (3871, 1181, 3, 'Bilateral:');
INSERT INTO `lang_definitions` VALUES (3872, 1184, 3, 'Fecha factura:');
INSERT INTO `lang_definitions` VALUES (3873, 1186, 3, 'Factura/Cobrar');
INSERT INTO `lang_definitions` VALUES (3874, 1187, 3, 'Facturado');
INSERT INTO `lang_definitions` VALUES (3875, 1189, 3, 'Facturación');
INSERT INTO `lang_definitions` VALUES (3876, 1190, 3, 'Facturación (escritura opcional)');
INSERT INTO `lang_definitions` VALUES (3877, 1194, 3, 'Atención facturación');
INSERT INTO `lang_definitions` VALUES (3878, 1196, 3, 'Código de facturación para el Servicio Solicitado');
INSERT INTO `lang_definitions` VALUES (3879, 1197, 3, 'Códigos de facturación');
INSERT INTO `lang_definitions` VALUES (3880, 1198, 3, 'Datos de facturación');
INSERT INTO `lang_definitions` VALUES (3881, 1199, 3, 'Departamento de Facturación');
INSERT INTO `lang_definitions` VALUES (3882, 1200, 3, 'Centro de Facturación');
INSERT INTO `lang_definitions` VALUES (3883, 1202, 3, 'Información facturación');
INSERT INTO `lang_definitions` VALUES (3884, 1203, 3, 'Dirección facturación');
INSERT INTO `lang_definitions` VALUES (3885, 1210, 3, 'Administrador de Facturación');
INSERT INTO `lang_definitions` VALUES (3886, 1211, 3, 'Nota de facturación');
INSERT INTO `lang_definitions` VALUES (3887, 1212, 3, 'Nota de facturación para');
INSERT INTO `lang_definitions` VALUES (3888, 1213, 3, 'Nota de facturación:');
INSERT INTO `lang_definitions` VALUES (3889, 1215, 3, 'Resultados de la cola de la facturación:');
INSERT INTO `lang_definitions` VALUES (3890, 1216, 3, 'Informe de Facturación');
INSERT INTO `lang_definitions` VALUES (3891, 1217, 3, 'Estado de facturación');
INSERT INTO `lang_definitions` VALUES (3892, 1218, 3, 'Estado de Facturación = No facturados');
INSERT INTO `lang_definitions` VALUES (3893, 1219, 3, 'facturación para');
INSERT INTO `lang_definitions` VALUES (3894, 1223, 3, 'Biopsia');
INSERT INTO `lang_definitions` VALUES (3895, 1225, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (3896, 1229, 3, 'Negro');
INSERT INTO `lang_definitions` VALUES (3897, 1232, 3, 'Pulmón negro');
INSERT INTO `lang_definitions` VALUES (3898, 1233, 3, 'Negro o Afroamericano');
INSERT INTO `lang_definitions` VALUES (3899, 1234, 3, 'Cáncer de vejiga');
INSERT INTO `lang_definitions` VALUES (3900, 1235, 3, 'Infecciones de vejiga');
INSERT INTO `lang_definitions` VALUES (3901, 1237, 3, 'Formularios en Blanco');
INSERT INTO `lang_definitions` VALUES (3902, 1238, 3, 'Problemas de sangrado');
INSERT INTO `lang_definitions` VALUES (3903, 1239, 3, 'Puntos ciegos');
INSERT INTO `lang_definitions` VALUES (3904, 1241, 3, 'Hinchazón');
INSERT INTO `lang_definitions` VALUES (3905, 1243, 3, 'Atascado');
INSERT INTO `lang_definitions` VALUES (3906, 1244, 3, 'Sangre');
INSERT INTO `lang_definitions` VALUES (3907, 1245, 3, 'Presión Arterial');
INSERT INTO `lang_definitions` VALUES (3908, 1246, 3, 'Presión arterial');
INSERT INTO `lang_definitions` VALUES (3909, 1247, 3, 'Sangra por la nariz');
INSERT INTO `lang_definitions` VALUES (3910, 1248, 3, 'Blue Cross Blue Shield');
INSERT INTO `lang_definitions` VALUES (3911, 1250, 3, 'Las líneas azules en este reporte son informativas. Líneas negras muestran información existente. Líneas verdes muestran cambios aplicados correctamente. Líneas rojas indican errores o cambios que no fueron aplicados, y deben ser procesados manualmente. Reclamaciones actuales denegadas y pagos revertidos no se manejan automáticamente y aparecerán en rojo.');
INSERT INTO `lang_definitions` VALUES (3912, 1251, 3, 'Visión borrosa');
INSERT INTO `lang_definitions` VALUES (3913, 1252, 3, 'IMC');
INSERT INTO `lang_definitions` VALUES (3914, 1253, 3, 'Estado del IMC');
INSERT INTO `lang_definitions` VALUES (3915, 1255, 3, 'Región corporal');
INSERT INTO `lang_definitions` VALUES (3916, 1256, 3, 'Área Corporal');
INSERT INTO `lang_definitions` VALUES (3917, 1257, 3, 'Área corporal, si es aplicable');
INSERT INTO `lang_definitions` VALUES (3918, 1258, 3, 'Sensibilidad en hueso:');
INSERT INTO `lang_definitions` VALUES (3919, 1259, 3, 'Sensibilidad en hueso: Maléolo Tibial');
INSERT INTO `lang_definitions` VALUES (3920, 1260, 3, 'Boleano');
INSERT INTO `lang_definitions` VALUES (3921, 1262, 3, 'Infer.');
INSERT INTO `lang_definitions` VALUES (3922, 1264, 3, 'Ambos Oídos');
INSERT INTO `lang_definitions` VALUES (3923, 1265, 3, 'ambos oídos');
INSERT INTO `lang_definitions` VALUES (3924, 1268, 3, 'inferior');
INSERT INTO `lang_definitions` VALUES (3925, 1272, 3, 'CASILLA 10 A. relacionados con el Empleo');
INSERT INTO `lang_definitions` VALUES (3926, 1274, 3, 'CASILLA 10 B. Accidentes de tráfico');
INSERT INTO `lang_definitions` VALUES (3927, 1276, 3, 'CASILLA 10 C. Otros Accidentes');
INSERT INTO `lang_definitions` VALUES (3928, 1290, 3, 'CASILLA 15. Fecha de la misma o similar enfermedad (aaaa-mm-dd)');
INSERT INTO `lang_definitions` VALUES (3929, 1296, 3, 'CASILLA 16. Fecha de incapacidad a partir de (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3930, 1300, 3, 'CASILLA 16. Fecha de incapacidad (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3931, 1312, 3, 'CASILLA 18. Fecha de inicio de hospitalización (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3932, 1316, 3, 'CASILLA 18. Fecha de inicio de hospitalización (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3933, 1320, 3, 'CASILLA 20. ¿Se utiliza Laboratorio externo?');
INSERT INTO `lang_definitions` VALUES (3934, 1324, 3, 'CASILLA 22. Código del re-envío de Medicaid (CIE-9)');
INSERT INTO `lang_definitions` VALUES (3935, 1328, 3, 'CASILLA 23. Número de Autorización previa');
INSERT INTO `lang_definitions` VALUES (3936, 1329, 3, 'PA');
INSERT INTO `lang_definitions` VALUES (3937, 1330, 3, 'PA Diastólica');
INSERT INTO `lang_definitions` VALUES (3938, 1331, 3, 'PA Sistólica');
INSERT INTO `lang_definitions` VALUES (3939, 1333, 3, 'Pad');
INSERT INTO `lang_definitions` VALUES (3940, 1337, 3, 'Pas');
INSERT INTO `lang_definitions` VALUES (3941, 1340, 3, 'Portugués brasileño');
INSERT INTO `lang_definitions` VALUES (3942, 1341, 3, 'mama');
INSERT INTO `lang_definitions` VALUES (3943, 1342, 3, 'Biopsia de mama');
INSERT INTO `lang_definitions` VALUES (3944, 1343, 3, 'Secreción de la mama');
INSERT INTO `lang_definitions` VALUES (3945, 1344, 3, 'Enfermedad de la mama');
INSERT INTO `lang_definitions` VALUES (3946, 1345, 3, 'Revisión de mama');
INSERT INTO `lang_definitions` VALUES (3947, 1346, 3, 'Masa en la mama');
INSERT INTO `lang_definitions` VALUES (3948, 1348, 3, 'Sonidos respiratorios:');
INSERT INTO `lang_definitions` VALUES (3949, 1351, 3, 'Huesos fracturados');
INSERT INTO `lang_definitions` VALUES (3950, 1353, 3, 'Forma de bronquitis');
INSERT INTO `lang_definitions` VALUES (3951, 1356, 3, 'Explorar');
INSERT INTO `lang_definitions` VALUES (3952, 1357, 3, 'Explorar para Registro');
INSERT INTO `lang_definitions` VALUES (3953, 1358, 3, 'Contusiones/Hematomas');
INSERT INTO `lang_definitions` VALUES (3954, 1362, 3, 'Abultamiento derecho:');
INSERT INTO `lang_definitions` VALUES (3955, 1364, 3, 'Ardor al orinar');
INSERT INTO `lang_definitions` VALUES (3956, 1365, 3, 'Ardor Al Orinar');
INSERT INTO `lang_definitions` VALUES (3957, 1368, 3, 'Ocupado');
INSERT INTO `lang_definitions` VALUES (3958, 1370, 3, 'pero todavía no procesado.');
INSERT INTO `lang_definitions` VALUES (3959, 1371, 3, 'Glúteo');
INSERT INTO `lang_definitions` VALUES (3960, 1372, 3, 'Gluteos + S.I.');
INSERT INTO `lang_definitions` VALUES (3961, 1374, 3, 'por');
INSERT INTO `lang_definitions` VALUES (3962, 1375, 3, 'Por');
INSERT INTO `lang_definitions` VALUES (3963, 1381, 3, 'por boca');
INSERT INTO `lang_definitions` VALUES (3964, 1383, 3, 'Por/Origen');
INSERT INTO `lang_definitions` VALUES (3965, 1384, 3, 'Por:');
INSERT INTO `lang_definitions` VALUES (3966, 1387, 3, 'C');
INSERT INTO `lang_definitions` VALUES (3967, 1391, 3, 'Certificado de CA para verificar el RFC 5425 TLS del servidor syslog.');
INSERT INTO `lang_definitions` VALUES (3968, 1392, 3, 'Tiempo de Vida del Caché (en segundos)');
INSERT INTO `lang_definitions` VALUES (3969, 1393, 3, '¿Plantilla de salida del caché?');
INSERT INTO `lang_definitions` VALUES (3970, 1395, 3, 'Consumo de cafeína');
INSERT INTO `lang_definitions` VALUES (3971, 1396, 3, 'Calendario');
INSERT INTO `lang_definitions` VALUES (3972, 1397, 3, 'Fin Hora Calendario');
INSERT INTO `lang_definitions` VALUES (3973, 1398, 3, 'Intervalo Calendario');
INSERT INTO `lang_definitions` VALUES (3974, 1399, 3, 'Pantalla de calendario');
INSERT INTO `lang_definitions` VALUES (3975, 1400, 3, 'Ajustes del calendario');
INSERT INTO `lang_definitions` VALUES (3976, 1402, 3, 'Hora de inicio de calendario');
INSERT INTO `lang_definitions` VALUES (3977, 1403, 3, 'Calendario UI');
INSERT INTO `lang_definitions` VALUES (3978, 1404, 3, 'Vista de Calendario');
INSERT INTO `lang_definitions` VALUES (3979, 1407, 3, 'Llamada para añadir Formulario () va aquí.<br>');
INSERT INTO `lang_definitions` VALUES (3980, 1411, 3, 'Calorías');
INSERT INTO `lang_definitions` VALUES (3981, 1412, 3, 'Camboyano');
INSERT INTO `lang_definitions` VALUES (3982, 1413, 3, 'CAMOS');
INSERT INTO `lang_definitions` VALUES (3983, 1420, 3, 'Cancelar');
INSERT INTO `lang_definitions` VALUES (3984, 1423, 3, 'Cancelar cambios');
INSERT INTO `lang_definitions` VALUES (3985, 1426, 3, 'Cancelado');
INSERT INTO `lang_definitions` VALUES (3986, 1429, 3, 'Cáncer');
INSERT INTO `lang_definitions` VALUES (3987, 1430, 3, 'Detección de Cancer: Detección Cancer de Colon');
INSERT INTO `lang_definitions` VALUES (3988, 1431, 3, 'Detección de Cancer: Mamografía');
INSERT INTO `lang_definitions` VALUES (3989, 1432, 3, 'Detección de Cancer: Prueba de Papanicolau');
INSERT INTO `lang_definitions` VALUES (3990, 1433, 3, 'Detección de Cancer: Detección de Cancer de Próstata');
INSERT INTO `lang_definitions` VALUES (3991, 1434, 3, 'No se puede agregar esta entrada, ¡porque ya existe!');
INSERT INTO `lang_definitions` VALUES (3992, 1436, 3, '¡No se puede agregar/actualizar esta entrada porque ya existe un duplicado!');
INSERT INTO `lang_definitions` VALUES (3993, 1438, 3, 'no puede convertirse a JPEG. ¿probablemente ImageMagick no está instalado?');
INSERT INTO `lang_definitions` VALUES (3994, 1440, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador.');
INSERT INTO `lang_definitions` VALUES (3995, 1441, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador');
INSERT INTO `lang_definitions` VALUES (3996, 1442, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador.');
INSERT INTO `lang_definitions` VALUES (3997, 1445, 3, 'No se puede crear');
INSERT INTO `lang_definitions` VALUES (3998, 1450, 3, 'No se puede encontrar');
INSERT INTO `lang_definitions` VALUES (3999, 1451, 3, 'No se puede encontrar fichero de destino');
INSERT INTO `lang_definitions` VALUES (4000, 1454, 3, 'No puede encontrar al paciente con ese ID de cliente en SQL-Ledger');
INSERT INTO `lang_definitions` VALUES (4001, 1455, 3, 'No se puede encontrar el documento de referencia de postscript en');
INSERT INTO `lang_definitions` VALUES (4002, 1456, 3, 'No puede encontrar al facultativo con SQL-Ledger empleado');
INSERT INTO `lang_definitions` VALUES (4003, 1457, 3, 'No puede modificar los pagos. La no-distribución es negativa.');
INSERT INTO `lang_definitions` VALUES (4004, 1459, 3, 'No se puede abrir');
INSERT INTO `lang_definitions` VALUES (4005, 1460, 3, 'No se puede enviar al seguro.La entidad pagadora seleccionada es el paciente.');
INSERT INTO `lang_definitions` VALUES (4006, 1461, 3, 'No puede enviar al Paciente. La Entidad pagadora seleccionada es el seguro.');
INSERT INTO `lang_definitions` VALUES (4007, 1462, 3, 'No puede enviar pagos. La distribución es negativa.');
INSERT INTO `lang_definitions` VALUES (4008, 1463, 3, 'No se puede leer');
INSERT INTO `lang_definitions` VALUES (4009, 1464, 3, 'No se puede leer el directorio');
INSERT INTO `lang_definitions` VALUES (4010, 1465, 3, '¡No se puede actualizar porque no está editando una entrada existente!.');
INSERT INTO `lang_definitions` VALUES (4011, 1466, 3, 'Poner en Mayúsculas');
INSERT INTO `lang_definitions` VALUES (4012, 1468, 3, 'cápsula');
INSERT INTO `lang_definitions` VALUES (4013, 1469, 3, 'Tarjeta');
INSERT INTO `lang_definitions` VALUES (4014, 1478, 3, 'Cateterismo Cardiaco');
INSERT INTO `lang_definitions` VALUES (4015, 1479, 3, 'Ecocardiograma');
INSERT INTO `lang_definitions` VALUES (4016, 1480, 3, 'Cardiovascular');
INSERT INTO `lang_definitions` VALUES (4017, 1492, 3, 'Daño de cartílago/ condral / disco articular.');
INSERT INTO `lang_definitions` VALUES (4018, 1493, 3, 'Lesión de cartílago');
INSERT INTO `lang_definitions` VALUES (4019, 1494, 3, 'Nl Pulsos Carotideos, pulsos pedios nl');
INSERT INTO `lang_definitions` VALUES (4020, 1496, 3, 'efectivo');
INSERT INTO `lang_definitions` VALUES (4021, 1497, 3, 'Efectivo');
INSERT INTO `lang_definitions` VALUES (4022, 1498, 3, 'Entradas Efectivo');
INSERT INTO `lang_definitions` VALUES (4023, 1499, 3, 'Entradas de efectivo por facultativo');
INSERT INTO `lang_definitions` VALUES (4024, 1502, 3, 'Cirugía de cataratas');
INSERT INTO `lang_definitions` VALUES (4025, 1503, 3, 'Cataratas');
INSERT INTO `lang_definitions` VALUES (4026, 1504, 3, 'Categorías');
INSERT INTO `lang_definitions` VALUES (4027, 1505, 3, 'Categorías para');
INSERT INTO `lang_definitions` VALUES (4028, 1506, 3, 'Categoría');
INSERT INTO `lang_definitions` VALUES (4029, 1507, 3, 'categoría');
INSERT INTO `lang_definitions` VALUES (4030, 1508, 3, 'Categoría');
INSERT INTO `lang_definitions` VALUES (4031, 1512, 3, 'Detalles de Categoría');
INSERT INTO `lang_definitions` VALUES (4032, 1513, 3, 'Límites de Categoría');
INSERT INTO `lang_definitions` VALUES (4033, 1514, 3, 'Nombre de Categoría');
INSERT INTO `lang_definitions` VALUES (4034, 1515, 3, 'Nombre de la Categoria está vacío');
INSERT INTO `lang_definitions` VALUES (4035, 1516, 3, 'Categoría/Título');
INSERT INTO `lang_definitions` VALUES (4036, 1517, 3, 'Caucásico');
INSERT INTO `lang_definitions` VALUES (4037, 1518, 3, 'Imprime la receta de la visita con la información del proveedor primario');
INSERT INTO `lang_definitions` VALUES (4038, 1539, 3, 'CDR');
INSERT INTO `lang_definitions` VALUES (4039, 1541, 3, 'Celda');
INSERT INTO `lang_definitions` VALUES (4040, 1542, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (4041, 1544, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (4042, 1546, 3, 'Certificación central');
INSERT INTO `lang_definitions` VALUES (4043, 1548, 3, 'Centroamericano/Sudamericano');
INSERT INTO `lang_definitions` VALUES (4044, 1549, 3, 'La localización del fichero de Certificado de Autoridad crt no puede estar vacía');
INSERT INTO `lang_definitions` VALUES (4045, 1550, 3, 'La localizacion de la clave del fichero del Certificado de Autoridad no puede estar vacía');
INSERT INTO `lang_definitions` VALUES (4046, 1551, 3, 'Certificado para enviar a la RFC 5425 TLS del servidor syslog.');
INSERT INTO `lang_definitions` VALUES (4047, 1552, 3, 'Usuario del Certificado');
INSERT INTO `lang_definitions` VALUES (4048, 1553, 3, 'Certificados');
INSERT INTO `lang_definitions` VALUES (4049, 1557, 3, 'ChampUS');
INSERT INTO `lang_definitions` VALUES (4050, 1558, 3, 'ChampUSVA');
INSERT INTO `lang_definitions` VALUES (4051, 1559, 3, 'cambiar');
INSERT INTO `lang_definitions` VALUES (4052, 1560, 3, 'Cambio');
INSERT INTO `lang_definitions` VALUES (4053, 1561, 3, 'Cambia actividad');
INSERT INTO `lang_definitions` VALUES (4054, 1566, 3, 'Cambio en la Visión');
INSERT INTO `lang_definitions` VALUES (4055, 1567, 3, 'Cambio en la Visión');
INSERT INTO `lang_definitions` VALUES (4056, 1574, 3, 'Cambiado');
INSERT INTO `lang_definitions` VALUES (4057, 1575, 3, 'Intestino Cambiado');
INSERT INTO `lang_definitions` VALUES (4058, 1583, 3, 'Características');
INSERT INTO `lang_definitions` VALUES (4059, 1584, 3, 'Caracteres Restantes');
INSERT INTO `lang_definitions` VALUES (4060, 1585, 3, 'Cargo');
INSERT INTO `lang_definitions` VALUES (4061, 1586, 3, 'Ajuste del cargo');
INSERT INTO `lang_definitions` VALUES (4062, 1587, 3, 'Cobro codificado');
INSERT INTO `lang_definitions` VALUES (4063, 1589, 3, 'Cargos');
INSERT INTO `lang_definitions` VALUES (4064, 1591, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (4065, 1592, 3, 'Gráfico de Actividad');
INSERT INTO `lang_definitions` VALUES (4066, 1593, 3, 'Informe de Actividad - Entradas/Salidas de gráficos');
INSERT INTO `lang_definitions` VALUES (4067, 1595, 3, 'Nº Identificación de gráfico');
INSERT INTO `lang_definitions` VALUES (4068, 1596, 3, 'Nº Identificación de gráfico:');
INSERT INTO `lang_definitions` VALUES (4069, 1598, 3, 'Actividad de Localización de Gráficos');
INSERT INTO `lang_definitions` VALUES (4070, 1599, 3, 'Nota en el gráfico');
INSERT INTO `lang_definitions` VALUES (4071, 1600, 3, 'Número de gráfico');
INSERT INTO `lang_definitions` VALUES (4072, 1602, 3, 'Gráfico de Localizaciones archivadas');
INSERT INTO `lang_definitions` VALUES (4073, 1605, 3, 'Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (4074, 1606, 3, 'Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (4075, 1609, 3, 'Gráficas retiradas');
INSERT INTO `lang_definitions` VALUES (4076, 1610, 3, 'Gráficas retiradas');
INSERT INTO `lang_definitions` VALUES (4077, 1615, 3, 'Comprobar');
INSERT INTO `lang_definitions` VALUES (4078, 1616, 3, 'comprobar');
INSERT INTO `lang_definitions` VALUES (4079, 1617, 3, 'Comprobar todo');
INSERT INTO `lang_definitions` VALUES (4080, 1619, 3, 'Importe del cheque');
INSERT INTO `lang_definitions` VALUES (4081, 1621, 3, 'Fecha del cheque');
INSERT INTO `lang_definitions` VALUES (4082, 1623, 3, 'Comprobar diferencias entre las traducciones con Tabla del Idioma Personalizada');
INSERT INTO `lang_definitions` VALUES (4083, 1630, 3, 'Llegue a');
INSERT INTO `lang_definitions` VALUES (4084, 1631, 3, 'Comprobar Fecha Entrada');
INSERT INTO `lang_definitions` VALUES (4085, 1633, 3, 'Revisar los Resultados de Laboratorio');
INSERT INTO `lang_definitions` VALUES (4086, 1636, 3, 'Número de cheque');
INSERT INTO `lang_definitions` VALUES (4087, 1640, 3, 'Pago por Cheque');
INSERT INTO `lang_definitions` VALUES (4088, 1641, 3, 'Marque la casilla si es un fichero encriptado');
INSERT INTO `lang_definitions` VALUES (4089, 1645, 3, 'Selecciona ésto si quiere que los facultativos vean todas las citas por defecto y no sólo las suyas.');
INSERT INTO `lang_definitions` VALUES (4090, 1651, 3, 'Comprobar Fecha/EOB:');
INSERT INTO `lang_definitions` VALUES (4091, 1653, 3, 'Comprobar Número EOB.:');
INSERT INTO `lang_definitions` VALUES (4092, 1654, 3, 'Comprobar/Número de Referencia');
INSERT INTO `lang_definitions` VALUES (4093, 1655, 3, 'Comprobar/Número de referencia');
INSERT INTO `lang_definitions` VALUES (4094, 1656, 3, 'Lista de casillas');
INSERT INTO `lang_definitions` VALUES (4095, 1657, 3, 'Lista de casillas');
INSERT INTO `lang_definitions` VALUES (4096, 1658, 3, 'Casilla con Texto');
INSERT INTO `lang_definitions` VALUES (4097, 1659, 3, 'Casilla con texto');
INSERT INTO `lang_definitions` VALUES (4098, 1663, 3, 'Comprobado');
INSERT INTO `lang_definitions` VALUES (4099, 1665, 3, 'Casilla marcada = sí, vacía = no');
INSERT INTO `lang_definitions` VALUES (4100, 1674, 3, 'Comprobación');
INSERT INTO `lang_definitions` VALUES (4101, 1678, 3, 'Sumatorio');
INSERT INTO `lang_definitions` VALUES (4102, 1679, 3, 'Pecho');
INSERT INTO `lang_definitions` VALUES (4103, 1680, 3, 'Pecho CTAB');
INSERT INTO `lang_definitions` VALUES (4104, 1681, 3, 'Dolor de Pecho');
INSERT INTO `lang_definitions` VALUES (4105, 1682, 3, 'Dolor de Pecho:');
INSERT INTO `lang_definitions` VALUES (4106, 1683, 3, 'Dolores de Pecho');
INSERT INTO `lang_definitions` VALUES (4107, 1685, 3, 'Var');
INSERT INTO `lang_definitions` VALUES (4108, 1687, 3, 'Síntoma Principal');
INSERT INTO `lang_definitions` VALUES (4109, 1690, 3, 'Niño');
INSERT INTO `lang_definitions` VALUES (4110, 1692, 3, 'Estado de vacunación de la niñez (GCC)');
INSERT INTO `lang_definitions` VALUES (4111, 1693, 3, 'Escalofríos');
INSERT INTO `lang_definitions` VALUES (4112, 1694, 3, 'Chino');
INSERT INTO `lang_definitions` VALUES (4113, 1695, 3, 'Chino (simplificado)');
INSERT INTO `lang_definitions` VALUES (4114, 1696, 3, 'Chino (tradicional)');
INSERT INTO `lang_definitions` VALUES (4115, 1698, 3, 'Opciones');
INSERT INTO `lang_definitions` VALUES (4116, 1699, 3, 'Colecistectomía');
INSERT INTO `lang_definitions` VALUES (4117, 1701, 3, 'Colecistectomía');
INSERT INTO `lang_definitions` VALUES (4118, 1702, 3, 'Elegir');
INSERT INTO `lang_definitions` VALUES (4119, 1705, 3, 'Elija una sección y haga click en un elemento dentro de ella; luego, en la otra sección, verá remarcados los elementos relacionados, puede hacer click en esa sección para añadir y borrar relaciones.');
INSERT INTO `lang_definitions` VALUES (4120, 1707, 3, 'Criterios de selección');
INSERT INTO `lang_definitions` VALUES (4121, 1716, 3, 'Lista de Selecciones');
INSERT INTO `lang_definitions` VALUES (4122, 1722, 3, 'Seleccione formato de impresión para este informe de visitas.');
INSERT INTO `lang_definitions` VALUES (4123, 1726, 3, 'Bronquitis Crónica');
INSERT INTO `lang_definitions` VALUES (4124, 1727, 3, 'Dolor crónico de articulaciones');
INSERT INTO `lang_definitions` VALUES (4125, 1728, 3, 'Enfermedad Renal Crónica (ERC)');
INSERT INTO `lang_definitions` VALUES (4126, 1731, 3, 'Sinovitis crónica/derrame/dolor articular/gota');
INSERT INTO `lang_definitions` VALUES (4127, 1733, 3, 'Crónico/Recurrente');
INSERT INTO `lang_definitions` VALUES (4128, 1737, 3, 'Cirrosis de hígado');
INSERT INTO `lang_definitions` VALUES (4129, 1738, 3, 'Cirrosis del Hígado');
INSERT INTO `lang_definitions` VALUES (4130, 1739, 3, 'Ciudad');
INSERT INTO `lang_definitions` VALUES (4131, 1741, 3, 'Nombre de Ciudad');
INSERT INTO `lang_definitions` VALUES (4132, 1742, 3, 'Ciudad, Provincia');
INSERT INTO `lang_definitions` VALUES (4133, 1743, 3, 'Ciudad, Código Postal');
INSERT INTO `lang_definitions` VALUES (4134, 1746, 3, 'Ciudad/Provincia');
INSERT INTO `lang_definitions` VALUES (4135, 1747, 3, 'Reclamación');
INSERT INTO `lang_definitions` VALUES (4136, 1748, 3, 'Reclamación');
INSERT INTO `lang_definitions` VALUES (4137, 1752, 3, 'Prueba de Reclamación ha terminado');
INSERT INTO `lang_definitions` VALUES (4138, 1753, 3, 'Tipo de Reclamación');
INSERT INTO `lang_definitions` VALUES (4139, 1754, 3, 'Reclamación generada para presentar');
INSERT INTO `lang_definitions` VALUES (4140, 1755, 3, 'La Reclamación se ha guardado en el fichero');
INSERT INTO `lang_definitions` VALUES (4141, 1756, 3, 'Reclamaciones');
INSERT INTO `lang_definitions` VALUES (4142, 1759, 3, 'Clasificación');
INSERT INTO `lang_definitions` VALUES (4143, 1760, 3, 'Limpiar');
INSERT INTO `lang_definitions` VALUES (4144, 1765, 3, 'Limpiar todos');
INSERT INTO `lang_definitions` VALUES (4145, 1768, 3, 'Limpiar Datos HL7');
INSERT INTO `lang_definitions` VALUES (4146, 1770, 3, 'Limpiar Justificación');
INSERT INTO `lang_definitions` VALUES (4147, 1777, 3, 'Vaciar Cache Smarty');
INSERT INTO `lang_definitions` VALUES (4148, 1779, 3, 'Información requerida por la Cámara de compensación en la creación del Batch EDI 270');
INSERT INTO `lang_definitions` VALUES (4149, 1780, 3, 'Número CLIA');
INSERT INTO `lang_definitions` VALUES (4150, 1781, 3, 'Click');
INSERT INTO `lang_definitions` VALUES (4151, 1782, 3, 'Click \'export\' para exportar su Categoría, Subcategoría, Item o Datos contenidos a un fichero de texto. Cualquier similitud de este fichero con un fichero tipo XML es pura coincidencia. Las etiquetas de abrir y cerrar deben estar en la misma línea y deben ser minúsculas sin espacios. Para importar, localize el fichero y click \'Importar\'. Si los datos son completamente diferentes se unen a los datos existentes. Si hay datos con nombres similares, el nombre más antiguo se mantiene mientras que al nuevo se le agrega un número al final.');
INSERT INTO `lang_definitions` VALUES (4152, 1785, 3, 'Click en el gráfico para nueva anotacion, click de nuevo para eliminarla.');
INSERT INTO `lang_definitions` VALUES (4153, 1789, 3, 'Click descargar Certificado para descargar los certificados en el fichero ssl.zip');
INSERT INTO `lang_definitions` VALUES (4154, 1790, 3, 'Click para más');
INSERT INTO `lang_definitions` VALUES (4155, 1796, 3, 'Click aquí');
INSERT INTO `lang_definitions` VALUES (4156, 1797, 3, 'Click aquí para añadir un nuevo paciente.');
INSERT INTO `lang_definitions` VALUES (4157, 1798, 3, 'Click aqui para añadir un nuevo cambio de estado de la lesion y editar la actividad diaria.');
INSERT INTO `lang_definitions` VALUES (4158, 1800, 3, 'Click aquí para elegir una fecha');
INSERT INTO `lang_definitions` VALUES (4159, 1801, 3, 'Click aquí para elegir una fecha y hora');
INSERT INTO `lang_definitions` VALUES (4160, 1802, 3, 'Click aquí para elegir una fecha de inicio');
INSERT INTO `lang_definitions` VALUES (4161, 1825, 3, 'Click aquí para buscar');
INSERT INTO `lang_definitions` VALUES (4162, 1828, 3, 'Click aquí para actualizar configuración de prioridad, categoría y apodos');
INSERT INTO `lang_definitions` VALUES (4163, 1832, 3, 'Click aquí para ver todo.');
INSERT INTO `lang_definitions` VALUES (4164, 1833, 3, 'Click aqui para vista y gráficos');
INSERT INTO `lang_definitions` VALUES (4165, 1835, 3, 'Click aquí para vista y grafico de todas las constantes vitales.');
INSERT INTO `lang_definitions` VALUES (4166, 1836, 3, 'Click aquí para ver los detalles del paciente');
INSERT INTO `lang_definitions` VALUES (4167, 1837, 3, 'Click aquí para ver todos.');
INSERT INTO `lang_definitions` VALUES (4168, 1841, 3, 'Click botón Instalar para instalar la versión de la base de datos desde la siguiente fecha');
INSERT INTO `lang_definitions` VALUES (4169, 1849, 3, 'Click aquí para aumentar los intervalos de tiempo');
INSERT INTO `lang_definitions` VALUES (4170, 1870, 3, 'Click en Nombre Paciente para abrir el fichero del paciente');
INSERT INTO `lang_definitions` VALUES (4171, 1872, 3, 'Click Refrescar para ver todos los resultados o introduzca un criterio de búsqueda arriba para ver resultados específicos.');
INSERT INTO `lang_definitions` VALUES (4172, 1899, 3, 'Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4173, 1900, 3, 'Click para agregar nueva consulta');
INSERT INTO `lang_definitions` VALUES (4174, 1905, 3, 'Click para descargar');
INSERT INTO `lang_definitions` VALUES (4175, 1906, 3, 'Click para editar');
INSERT INTO `lang_definitions` VALUES (4176, 1908, 3, 'Click para editar este evento');
INSERT INTO `lang_definitions` VALUES (4177, 1913, 3, 'Click para generar el informe');
INSERT INTO `lang_definitions` VALUES (4178, 1924, 3, 'Click para imprimir');
INSERT INTO `lang_definitions` VALUES (4179, 1926, 3, 'Click para recibir (añadir) nuevo lote');
INSERT INTO `lang_definitions` VALUES (4180, 1931, 3, 'Click para seleccionar');
INSERT INTO `lang_definitions` VALUES (4181, 1932, 3, 'Click Para Seleccionar');
INSERT INTO `lang_definitions` VALUES (4182, 1934, 3, 'Click para seleccionar un código estándar industrial para este procedimiento');
INSERT INTO `lang_definitions` VALUES (4183, 1937, 3, 'Click para seleccionar el codigo de procedimiento opcional');
INSERT INTO `lang_definitions` VALUES (4184, 1939, 3, 'Click para seleccionar o cambiar código CVX');
INSERT INTO `lang_definitions` VALUES (4185, 1940, 3, 'Click para seleccionar o cambiar diagnósticos');
INSERT INTO `lang_definitions` VALUES (4186, 1941, 3, 'Click para seleccionar o cambiar códigos de servicios');
INSERT INTO `lang_definitions` VALUES (4187, 1942, 3, 'Click para seleccionar el paciente');
INSERT INTO `lang_definitions` VALUES (4188, 1943, 3, 'Click para seleccionar un código relacionado');
INSERT INTO `lang_definitions` VALUES (4189, 1945, 3, 'Click para seleccionar servicios a realizar si este resultado es anormal');
INSERT INTO `lang_definitions` VALUES (4190, 1948, 3, 'Click para seleccionar el procedimiento deseado');
INSERT INTO `lang_definitions` VALUES (4191, 1958, 3, 'Click para ver');
INSERT INTO `lang_definitions` VALUES (4192, 1960, 3, 'Click para ver o editar');
INSERT INTO `lang_definitions` VALUES (4193, 1962, 3, 'Click para ver/editar');
INSERT INTO `lang_definitions` VALUES (4194, 1964, 3, 'Click botón Actualizar para actualizar la versión de la base de datos desde la fecha siguiente');
INSERT INTO `lang_definitions` VALUES (4195, 1967, 3, 'Click:');
INSERT INTO `lang_definitions` VALUES (4196, 1990, 3, 'Días para Vencimiento del Certificado del Cliente');
INSERT INTO `lang_definitions` VALUES (4197, 1992, 3, 'Periodo de validación del Certificado del Cliente');
INSERT INTO `lang_definitions` VALUES (4198, 1993, 3, 'El certificado de validación del cliente debe ser un número válido');
INSERT INTO `lang_definitions` VALUES (4199, 1994, 3, 'Copia para el cliente');
INSERT INTO `lang_definitions` VALUES (4200, 1998, 3, 'Resumen de historia clínica del cliente');
INSERT INTO `lang_definitions` VALUES (4201, 2002, 3, 'Perfil de cliente - Nuevos Clientes');
INSERT INTO `lang_definitions` VALUES (4202, 2003, 3, 'Perfil de cliente - Clientes Únicos');
INSERT INTO `lang_definitions` VALUES (4203, 2008, 3, 'Clientes');
INSERT INTO `lang_definitions` VALUES (4204, 2009, 3, 'Clínica');
INSERT INTO `lang_definitions` VALUES (4205, 2010, 3, 'Copia para la Clínica');
INSERT INTO `lang_definitions` VALUES (4206, 2011, 3, 'Registro Diario de la Clínica');
INSERT INTO `lang_definitions` VALUES (4207, 2012, 3, 'Nº Identificación de Clínica');
INSERT INTO `lang_definitions` VALUES (4208, 2013, 3, 'Clínico');
INSERT INTO `lang_definitions` VALUES (4209, 2014, 3, 'Gestor de Alertas para las Reglas de Decisión Clinicas');
INSERT INTO `lang_definitions` VALUES (4210, 2020, 3, 'Planes Clínicos');
INSERT INTO `lang_definitions` VALUES (4211, 2021, 3, 'Medidas de Calidad Clínica (GCC)');
INSERT INTO `lang_definitions` VALUES (4212, 2024, 3, 'Recordatorios Clínicos');
INSERT INTO `lang_definitions` VALUES (4213, 2028, 3, 'Reportes Clínicos');
INSERT INTO `lang_definitions` VALUES (4214, 2029, 3, 'Reglas Clínicas para Categoría de Acción');
INSERT INTO `lang_definitions` VALUES (4215, 2030, 3, 'Reglas Clínicas para Asunto de Acción');
INSERT INTO `lang_definitions` VALUES (4216, 2031, 3, 'Reglas Clínicas para Métodos de filtro');
INSERT INTO `lang_definitions` VALUES (4217, 2032, 3, 'Reglas Clínicas para Objetivo de Métodos');
INSERT INTO `lang_definitions` VALUES (4218, 2033, 3, 'Reglas Clínicas');
INSERT INTO `lang_definitions` VALUES (4219, 2034, 3, 'Reglas Clínicas para Intervalos de Edad');
INSERT INTO `lang_definitions` VALUES (4220, 2035, 3, 'Reglas Clínicas de Comparación');
INSERT INTO `lang_definitions` VALUES (4221, 2036, 3, 'Reglas Clínicas de Tipos de Visitas');
INSERT INTO `lang_definitions` VALUES (4222, 2037, 3, 'Reglas Clínicas de opciones de Vencimientos de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4223, 2038, 3, 'Reglas Clínicas de opciones de Desactivación de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4224, 2039, 3, 'Reglas Clínicas de intervalos de recordatorios');
INSERT INTO `lang_definitions` VALUES (4225, 2040, 3, 'Reglas Clínicas de Métodos de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4226, 2041, 3, 'Reglas Clínicas de Intervalos de Destino');
INSERT INTO `lang_definitions` VALUES (4227, 2042, 3, 'Destinos Clínicos');
INSERT INTO `lang_definitions` VALUES (4228, 2045, 3, 'Vista de Clínica');
INSERT INTO `lang_definitions` VALUES (4229, 2046, 3, 'Médicos');
INSERT INTO `lang_definitions` VALUES (4230, 2047, 3, 'Clonar');
INSERT INTO `lang_definitions` VALUES (4231, 2048, 3, 'Clonar Visita Anterior');
INSERT INTO `lang_definitions` VALUES (4232, 2049, 3, 'Cerrar');
INSERT INTO `lang_definitions` VALUES (4233, 2057, 3, 'Cerrar Ventana');
INSERT INTO `lang_definitions` VALUES (4234, 2058, 3, 'cerrar ventana');
INSERT INTO `lang_definitions` VALUES (4235, 2060, 3, 'Cerrado');
INSERT INTO `lang_definitions` VALUES (4236, 2061, 3, 'cm');
INSERT INTO `lang_definitions` VALUES (4237, 2064, 3, 'Margenes del formulario CMS 1500');
INSERT INTO `lang_definitions` VALUES (4238, 2073, 3, 'CMS ID');
INSERT INTO `lang_definitions` VALUES (4239, 2088, 3, 'NC 2-12 Intacto');
INSERT INTO `lang_definitions` VALUES (4240, 2091, 3, 'Copago');
INSERT INTO `lang_definitions` VALUES (4241, 2092, 3, 'Copago pagado');
INSERT INTO `lang_definitions` VALUES (4242, 2095, 3, 'Copago');
INSERT INTO `lang_definitions` VALUES (4243, 2097, 3, 'Código');
INSERT INTO `lang_definitions` VALUES (4244, 2098, 3, 'código');
INSERT INTO `lang_definitions` VALUES (4245, 2100, 3, 'Buscador de Código');
INSERT INTO `lang_definitions` VALUES (4246, 2101, 3, 'Código debe ser dos letras en minúscula');
INSERT INTO `lang_definitions` VALUES (4247, 2102, 3, 'Código o símbolo para indicar moneda');
INSERT INTO `lang_definitions` VALUES (4248, 2104, 3, 'Código de Texto');
INSERT INTO `lang_definitions` VALUES (4249, 2106, 3, 'tipo de código');
INSERT INTO `lang_definitions` VALUES (4250, 2109, 3, 'Típos de Código');
INSERT INTO `lang_definitions` VALUES (4251, 2111, 3, 'Codificado');
INSERT INTO `lang_definitions` VALUES (4252, 2112, 3, 'Códigos');
INSERT INTO `lang_definitions` VALUES (4253, 2114, 3, 'Codificando');
INSERT INTO `lang_definitions` VALUES (4254, 2116, 3, 'Codificación - cualquier visita(escribir, con algunas opciones)');
INSERT INTO `lang_definitions` VALUES (4255, 2118, 3, 'Codificación - mis visitas(escribir, con algunas opciones)');
INSERT INTO `lang_definitions` VALUES (4256, 2123, 3, 'Codificación no autorizada');
INSERT INTO `lang_definitions` VALUES (4257, 2124, 3, 'Café');
INSERT INTO `lang_definitions` VALUES (4258, 2128, 3, 'Coseguro');
INSERT INTO `lang_definitions` VALUES (4259, 2129, 3, 'Coll w/o');
INSERT INTO `lang_definitions` VALUES (4260, 2131, 3, 'Contraer');
INSERT INTO `lang_definitions` VALUES (4261, 2132, 3, 'contraer');
INSERT INTO `lang_definitions` VALUES (4262, 2133, 3, 'Contraer Todo');
INSERT INTO `lang_definitions` VALUES (4263, 2134, 3, 'Contraer todo');
INSERT INTO `lang_definitions` VALUES (4264, 2135, 3, 'contraer todo');
INSERT INTO `lang_definitions` VALUES (4265, 2140, 3, 'Fecha de recolecciòn');
INSERT INTO `lang_definitions` VALUES (4266, 2142, 3, 'Recobro');
INSERT INTO `lang_definitions` VALUES (4267, 2143, 3, 'Informe de Recobro');
INSERT INTO `lang_definitions` VALUES (4268, 2144, 3, 'Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4269, 2145, 3, 'Detección de Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4270, 2146, 3, 'Cirugía de Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4271, 2147, 3, 'Colonoscopia');
INSERT INTO `lang_definitions` VALUES (4272, 2148, 3, 'colonoscopía');
INSERT INTO `lang_definitions` VALUES (4273, 2149, 3, 'Color');
INSERT INTO `lang_definitions` VALUES (4274, 2155, 3, 'Abreviatura de color');
INSERT INTO `lang_definitions` VALUES (4275, 2156, 3, 'Colunma');
INSERT INTO `lang_definitions` VALUES (4276, 2157, 3, 'Columnas');
INSERT INTO `lang_definitions` VALUES (4277, 2159, 3, 'Combinando Lotes');
INSERT INTO `lang_definitions` VALUES (4278, 2160, 3, 'Coma');
INSERT INTO `lang_definitions` VALUES (4279, 2162, 3, 'Comentario');
INSERT INTO `lang_definitions` VALUES (4280, 2163, 3, 'Comentarios');
INSERT INTO `lang_definitions` VALUES (4281, 2168, 3, 'Comentarios para este resultado o recomendación');
INSERT INTO `lang_definitions` VALUES (4282, 2169, 3, 'Sociedad Comercial de Seguros');
INSERT INTO `lang_definitions` VALUES (4283, 2170, 3, 'Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (4284, 2176, 3, 'Comunicaciones');
INSERT INTO `lang_definitions` VALUES (4285, 2179, 3, 'Compañía');
INSERT INTO `lang_definitions` VALUES (4286, 2180, 3, 'Nombre Empresa');
INSERT INTO `lang_definitions` VALUES (4287, 2181, 3, 'Completo');
INSERT INTO `lang_definitions` VALUES (4288, 2183, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (4289, 2186, 3, 'Terminado?');
INSERT INTO `lang_definitions` VALUES (4290, 2189, 3, 'Conplicaciones por el proveedor de servicios');
INSERT INTO `lang_definitions` VALUES (4291, 2190, 3, 'Complicaciones de aborto');
INSERT INTO `lang_definitions` VALUES (4292, 2191, 3, 'Componentes');
INSERT INTO `lang_definitions` VALUES (4293, 2200, 3, 'Sistema Computarizado de Pedidos Médicos');
INSERT INTO `lang_definitions` VALUES (4294, 2202, 3, 'Conclusiones');
INSERT INTO `lang_definitions` VALUES (4295, 2209, 3, 'Config');
INSERT INTO `lang_definitions` VALUES (4296, 2210, 3, 'Configuración');
INSERT INTO `lang_definitions` VALUES (4297, 2211, 3, 'Configuración Exportar/Importar');
INSERT INTO `lang_definitions` VALUES (4298, 2213, 3, 'Configure Apache y OpenEMR para usar certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4299, 2214, 3, 'Configure Apache para usar certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4300, 2215, 3, 'Configure Apache para usar HTTPS');
INSERT INTO `lang_definitions` VALUES (4301, 2216, 3, 'Configure Openemr para usar certificado SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4302, 2225, 3, 'Confirma Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4303, 2227, 3, 'Confirmar Nueva Contraseña');
INSERT INTO `lang_definitions` VALUES (4304, 2229, 3, 'Confirmar Pago');
INSERT INTO `lang_definitions` VALUES (4305, 2238, 3, 'Congénito');
INSERT INTO `lang_definitions` VALUES (4306, 2240, 3, 'Conjuntiva, pupilas');
INSERT INTO `lang_definitions` VALUES (4307, 2243, 3, 'Conectores');
INSERT INTO `lang_definitions` VALUES (4308, 2245, 3, 'Constante');
INSERT INTO `lang_definitions` VALUES (4309, 2247, 3, 'Nombre constante');
INSERT INTO `lang_definitions` VALUES (4310, 2248, 3, 'Nombre constante está en blanco');
INSERT INTO `lang_definitions` VALUES (4311, 2249, 3, 'constantes');
INSERT INTO `lang_definitions` VALUES (4312, 2250, 3, 'Estreñimiento');
INSERT INTO `lang_definitions` VALUES (4313, 2251, 3, 'Constitucional');
INSERT INTO `lang_definitions` VALUES (4314, 2254, 3, 'Breve Descripción de Consulta');
INSERT INTO `lang_definitions` VALUES (4315, 2259, 3, 'Contacto');
INSERT INTO `lang_definitions` VALUES (4316, 2260, 3, 'email del contacto');
INSERT INTO `lang_definitions` VALUES (4317, 2261, 3, 'email de contacto');
INSERT INTO `lang_definitions` VALUES (4318, 2264, 3, 'Informacion de contacto');
INSERT INTO `lang_definitions` VALUES (4319, 2268, 3, 'Lentes de Contacto');
INSERT INTO `lang_definitions` VALUES (4320, 2273, 3, 'Nombre del contacto');
INSERT INTO `lang_definitions` VALUES (4321, 2276, 3, 'Persona de Contacto');
INSERT INTO `lang_definitions` VALUES (4322, 2278, 3, 'Número de Teléfono de Contacto');
INSERT INTO `lang_definitions` VALUES (4323, 2281, 3, 'Contactar ZMG, LLC (zmghealth@gmail.com) para suscribir el servicio de receta electrónica');
INSERT INTO `lang_definitions` VALUES (4324, 2283, 3, 'contiene por lo menos tres de las cuatro cosas siguientes:');
INSERT INTO `lang_definitions` VALUES (4325, 2285, 3, 'Contenido');
INSERT INTO `lang_definitions` VALUES (4326, 2286, 3, 'contenido');
INSERT INTO `lang_definitions` VALUES (4327, 2288, 3, 'Contexto');
INSERT INTO `lang_definitions` VALUES (4328, 2289, 3, 'El nombre de contexto no puede estar vacío');
INSERT INTO `lang_definitions` VALUES (4329, 2290, 3, 'Continuar');
INSERT INTO `lang_definitions` VALUES (4330, 2294, 3, 'Continuidad del Documento de Atención (CCD)');
INSERT INTO `lang_definitions` VALUES (4331, 2297, 3, 'Continuidad del registro de cuidados (CCR)');
INSERT INTO `lang_definitions` VALUES (4332, 2298, 3, 'Contra Clientes');
INSERT INTO `lang_definitions` VALUES (4333, 2299, 3, 'Contracepción');
INSERT INTO `lang_definitions` VALUES (4334, 2301, 3, 'Incidencias de Anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4335, 2302, 3, 'Complicación anticonceptivos (especificar)');
INSERT INTO `lang_definitions` VALUES (4336, 2303, 3, 'Método Anticonceptivo');
INSERT INTO `lang_definitions` VALUES (4337, 2304, 3, 'Productos Anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4338, 2305, 3, 'Servicios anticonceptivos ya empezados');
INSERT INTO `lang_definitions` VALUES (4339, 2306, 3, 'Comienzo de anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4340, 2311, 3, 'Nº Identificación de control');
INSERT INTO `lang_definitions` VALUES (4341, 2312, 3, 'N º de control');
INSERT INTO `lang_definitions` VALUES (4342, 2321, 3, 'COPAGO');
INSERT INTO `lang_definitions` VALUES (4343, 2322, 3, 'Co-pago');
INSERT INTO `lang_definitions` VALUES (4344, 2323, 3, 'Co-Pago');
INSERT INTO `lang_definitions` VALUES (4345, 2324, 3, 'El Co-pago no es positivo');
INSERT INTO `lang_definitions` VALUES (4346, 2326, 3, 'Co-pagos');
INSERT INTO `lang_definitions` VALUES (4347, 2327, 3, 'COPD');
INSERT INTO `lang_definitions` VALUES (4348, 2331, 3, 'Copiar páginas a la Historia del Paciente');
INSERT INTO `lang_definitions` VALUES (4349, 2335, 3, 'Copiar Valores');
INSERT INTO `lang_definitions` VALUES (4350, 2336, 3, 'Copiando base de datos. Puede tardar algún tiempo');
INSERT INTO `lang_definitions` VALUES (4351, 2337, 3, 'Aviso de Derechos Reservados');
INSERT INTO `lang_definitions` VALUES (4352, 2342, 3, 'Bypass coronario arterial');
INSERT INTO `lang_definitions` VALUES (4353, 2343, 3, 'Cirugía de revascularización coronaria');
INSERT INTO `lang_definitions` VALUES (4354, 2344, 3, 'Corregido');
INSERT INTO `lang_definitions` VALUES (4355, 2346, 3, 'CouchDB');
INSERT INTO `lang_definitions` VALUES (4356, 2347, 3, 'Conexión a CouchDB fallida.');
INSERT INTO `lang_definitions` VALUES (4357, 2349, 3, 'bbdd CouchDB');
INSERT INTO `lang_definitions` VALUES (4358, 2350, 3, 'Nombre de bbdd CouchDB');
INSERT INTO `lang_definitions` VALUES (4359, 2353, 3, 'Host CouchDB');
INSERT INTO `lang_definitions` VALUES (4360, 2354, 3, 'Nombre Host CouchDB');
INSERT INTO `lang_definitions` VALUES (4361, 2355, 3, 'Activar Log CouchDB');
INSERT INTO `lang_definitions` VALUES (4362, 2356, 3, 'Contraseña CouchDB');
INSERT INTO `lang_definitions` VALUES (4363, 2357, 3, 'Puerto CouchDB');
INSERT INTO `lang_definitions` VALUES (4364, 2358, 3, 'puerto CouchDB');
INSERT INTO `lang_definitions` VALUES (4365, 2361, 3, 'Nombre usuario CouchDB');
INSERT INTO `lang_definitions` VALUES (4366, 2362, 3, 'Tos');
INSERT INTO `lang_definitions` VALUES (4367, 2363, 3, 'Tos:');
INSERT INTO `lang_definitions` VALUES (4368, 2370, 3, 'No se pudo leer el fichero');
INSERT INTO `lang_definitions` VALUES (4369, 2373, 3, 'email no enviado por problema en el servidor,');
INSERT INTO `lang_definitions` VALUES (4370, 2375, 3, 'No se pudo enviar email debido a problemas en el servidor.');
INSERT INTO `lang_definitions` VALUES (4371, 2376, 3, 'No se pudo crear el dir de backup:');
INSERT INTO `lang_definitions` VALUES (4372, 2377, 3, 'No se pudo eliminar dir:');
INSERT INTO `lang_definitions` VALUES (4373, 2378, 3, 'No se pudo eliminar el antiguo fichero de Backup:');
INSERT INTO `lang_definitions` VALUES (4374, 2379, 3, 'No se pudo eliminar el antiguo fichero de exportación:');
INSERT INTO `lang_definitions` VALUES (4375, 2380, 3, 'Tratamiento con Coumadin - Seguimiento del Ratio Internacional Normalizado (RIN)');
INSERT INTO `lang_definitions` VALUES (4376, 2381, 3, 'Counseling por Método');
INSERT INTO `lang_definitions` VALUES (4377, 2382, 3, 'Orientación');
INSERT INTO `lang_definitions` VALUES (4378, 2383, 3, 'Actividades de orientación');
INSERT INTO `lang_definitions` VALUES (4379, 2386, 3, 'FORMULARIO CONTADOR DE DERIVACIONES');
INSERT INTO `lang_definitions` VALUES (4380, 2387, 3, 'Contador-Derivación');
INSERT INTO `lang_definitions` VALUES (4381, 2388, 3, 'País');
INSERT INTO `lang_definitions` VALUES (4382, 2390, 3, 'Tipo de datos País');
INSERT INTO `lang_definitions` VALUES (4383, 2391, 3, 'Lista de País');
INSERT INTO `lang_definitions` VALUES (4384, 2392, 3, 'Lista del país (escriba, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (4385, 2394, 3, 'Nombre del Pais deber ser representados por dos letras');
INSERT INTO `lang_definitions` VALUES (4386, 2395, 3, 'condado');
INSERT INTO `lang_definitions` VALUES (4387, 2397, 3, 'Cupón');
INSERT INTO `lang_definitions` VALUES (4388, 2404, 3, 'CPT');
INSERT INTO `lang_definitions` VALUES (4389, 2405, 3, 'Código CPT');
INSERT INTO `lang_definitions` VALUES (4390, 2406, 3, 'Código CPT');
INSERT INTO `lang_definitions` VALUES (4391, 2407, 3, 'Procedimiento/Servicio CPT4');
INSERT INTO `lang_definitions` VALUES (4392, 2408, 3, 'Medidas de Rendimiento CPTII');
INSERT INTO `lang_definitions` VALUES (4393, 2409, 3, 'Gestión Calidad Continua (GCC)');
INSERT INTO `lang_definitions` VALUES (4394, 2412, 3, 'Crujidos, crepitaciones');
INSERT INTO `lang_definitions` VALUES (4395, 2415, 3, 'crema');
INSERT INTO `lang_definitions` VALUES (4396, 2417, 3, 'Crear un certificado SSL del Cliente por usuario o cliente de maquina');
INSERT INTO `lang_definitions` VALUES (4397, 2418, 3, 'Crear un certificado SSL del lado del cliente, ya sea para un usuario o un nombre de host cliente.');
INSERT INTO `lang_definitions` VALUES (4398, 2430, 3, 'Crear un evento');
INSERT INTO `lang_definitions` VALUES (4399, 2434, 3, 'Crear y descargar un respaldo completo');
INSERT INTO `lang_definitions` VALUES (4400, 2436, 3, 'Crear Respaldo');
INSERT INTO `lang_definitions` VALUES (4401, 2437, 3, 'Crear batch');
INSERT INTO `lang_definitions` VALUES (4402, 2438, 3, 'Crear Certificado de Cliente');
INSERT INTO `lang_definitions` VALUES (4403, 2439, 3, 'Crear Certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4404, 2442, 3, 'Crear Duplicado');
INSERT INTO `lang_definitions` VALUES (4405, 2444, 3, 'Crear backup de registro de eventos');
INSERT INTO `lang_definitions` VALUES (4406, 2446, 3, 'Crear nueva incidencia');
INSERT INTO `lang_definitions` VALUES (4407, 2448, 3, 'Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4408, 2452, 3, 'Crear Credenciales para el Portal Offsite');
INSERT INTO `lang_definitions` VALUES (4409, 2454, 3, 'Crear Credenciales para el Portal Onsite');
INSERT INTO `lang_definitions` VALUES (4410, 2456, 3, 'Crear nota de paciente');
INSERT INTO `lang_definitions` VALUES (4411, 2458, 3, 'Crear Certificado de Autoridad SSL y Certificados del Servidor.');
INSERT INTO `lang_definitions` VALUES (4412, 2459, 3, 'Crear visita');
INSERT INTO `lang_definitions` VALUES (4413, 2460, 3, 'Creado');
INSERT INTO `lang_definitions` VALUES (4414, 2470, 3, 'Creando fichero de exportación');
INSERT INTO `lang_definitions` VALUES (4415, 2473, 3, 'Creador');
INSERT INTO `lang_definitions` VALUES (4416, 2475, 3, 'crédito');
INSERT INTO `lang_definitions` VALUES (4417, 2477, 3, 'Tarjeta de Credito');
INSERT INTO `lang_definitions` VALUES (4418, 2483, 3, 'Créditos');
INSERT INTO `lang_definitions` VALUES (4419, 2485, 3, 'Criterio');
INSERT INTO `lang_definitions` VALUES (4420, 2488, 3, 'Enfermedad de Crohn');
INSERT INTO `lang_definitions` VALUES (4421, 2489, 3, 'Enfermedad de Crohn');
INSERT INTO `lang_definitions` VALUES (4422, 2493, 3, 'CSV');
INSERT INTO `lang_definitions` VALUES (4423, 2494, 3, 'Fichero CSV');
INSERT INTO `lang_definitions` VALUES (4424, 2500, 3, 'MM.CU (Mililitros cubicos)');
INSERT INTO `lang_definitions` VALUES (4425, 2501, 3, 'Cubano');
INSERT INTO `lang_definitions` VALUES (4426, 2503, 3, 'Número de decimales en moneda');
INSERT INTO `lang_definitions` VALUES (4427, 2504, 3, 'Tipo de Cambio - Símbolo de Punto Decimal');
INSERT INTO `lang_definitions` VALUES (4428, 2505, 3, 'Indicador de Tipo de Cambio');
INSERT INTO `lang_definitions` VALUES (4429, 2506, 3, 'Tipo de Cambio - Separador de Miles');
INSERT INTO `lang_definitions` VALUES (4430, 2507, 3, 'Actual');
INSERT INTO `lang_definitions` VALUES (4431, 2508, 3, 'Alcohol actual');
INSERT INTO `lang_definitions` VALUES (4432, 2512, 3, 'Consulta Actual');
INSERT INTO `lang_definitions` VALUES (4433, 2513, 3, 'Criterio Actual');
INSERT INTO `lang_definitions` VALUES (4434, 2515, 3, 'Color resaltado del presente día');
INSERT INTO `lang_definitions` VALUES (4435, 2516, 3, 'Actualmente fumador diario');
INSERT INTO `lang_definitions` VALUES (4436, 2518, 3, 'El nombre de fichero actual fue cambiado a');
INSERT INTO `lang_definitions` VALUES (4437, 2520, 3, 'Hash actual');
INSERT INTO `lang_definitions` VALUES (4438, 2521, 3, 'Ubicación actual');
INSERT INTO `lang_definitions` VALUES (4439, 2523, 3, 'Medicamentos Actuales');
INSERT INTO `lang_definitions` VALUES (4440, 2525, 3, 'Contraseña Actual');
INSERT INTO `lang_definitions` VALUES (4441, 2527, 3, 'Paciente Actual');
INSERT INTO `lang_definitions` VALUES (4442, 2534, 3, 'Drogas no farmacológicas actuales');
INSERT INTO `lang_definitions` VALUES (4443, 2536, 3, 'Actualmente fumador ocasional');
INSERT INTO `lang_definitions` VALUES (4444, 2544, 3, 'Actualmente Activo');
INSERT INTO `lang_definitions` VALUES (4445, 2550, 3, 'Actualmente no hay clínicas');
INSERT INTO `lang_definitions` VALUES (4446, 2552, 3, 'Síndrome de Cushing');
INSERT INTO `lang_definitions` VALUES (4447, 2553, 3, 'Síndrome de Cushing');
INSERT INTO `lang_definitions` VALUES (4448, 2556, 3, 'Costumbre');
INSERT INTO `lang_definitions` VALUES (4449, 2564, 3, '¿Entrada cliente?');
INSERT INTO `lang_definitions` VALUES (4450, 2569, 3, 'Tabla Cliente');
INSERT INTO `lang_definitions` VALUES (4451, 2578, 3, 'Código CVX');
INSERT INTO `lang_definitions` VALUES (4452, 2579, 3, 'Mapa de Código CVX');
INSERT INTO `lang_definitions` VALUES (4453, 2580, 3, 'Vacunación CVX');
INSERT INTO `lang_definitions` VALUES (4454, 2582, 3, 'Ciclo');
INSERT INTO `lang_definitions` VALUES (4455, 2588, 3, 'CYP');
INSERT INTO `lang_definitions` VALUES (4456, 2589, 3, 'Factor de CYP');
INSERT INTO `lang_definitions` VALUES (4457, 2590, 3, 'Informe de CYP');
INSERT INTO `lang_definitions` VALUES (4458, 2593, 3, 'Checo');
INSERT INTO `lang_definitions` VALUES (4459, 2594, 3, 'D');
INSERT INTO `lang_definitions` VALUES (4460, 2595, 3, 'D&C');
INSERT INTO `lang_definitions` VALUES (4461, 2596, 3, 'D&E');
INSERT INTO `lang_definitions` VALUES (4462, 2598, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4463, 2599, 3, 'diariamente');
INSERT INTO `lang_definitions` VALUES (4464, 2600, 3, 'Registro Diario');
INSERT INTO `lang_definitions` VALUES (4465, 2605, 3, 'Danés');
INSERT INTO `lang_definitions` VALUES (4466, 2609, 3, 'Información parecida está ya en la base de datos, por favor cambie el código o la descripción');
INSERT INTO `lang_definitions` VALUES (4467, 2610, 3, 'Información parecida está ya en la base de datos, por favor cambie el nombre de la constante');
INSERT INTO `lang_definitions` VALUES (4468, 2611, 3, 'Datos Cols');
INSERT INTO `lang_definitions` VALUES (4469, 2614, 3, 'Error de datos');
INSERT INTO `lang_definitions` VALUES (4470, 2619, 3, 'Tipo de datos');
INSERT INTO `lang_definitions` VALUES (4471, 2620, 3, 'Base de datos');
INSERT INTO `lang_definitions` VALUES (4472, 2622, 3, 'Base de datos sin instalar');
INSERT INTO `lang_definitions` VALUES (4473, 2624, 3, 'Revisión bbdd');
INSERT INTO `lang_definitions` VALUES (4474, 2625, 3, 'Información de la base de datos');
INSERT INTO `lang_definitions` VALUES (4475, 2627, 3, 'Actualización de base de datos completa');
INSERT INTO `lang_definitions` VALUES (4476, 2628, 3, 'DataCols debe ser un número entre 1 y 999');
INSERT INTO `lang_definitions` VALUES (4477, 2629, 3, 'Fecha');
INSERT INTO `lang_definitions` VALUES (4478, 2631, 3, 'FECHA');
INSERT INTO `lang_definitions` VALUES (4479, 2634, 3, 'Fecha adminstrada');
INSERT INTO `lang_definitions` VALUES (4480, 2635, 3, 'Fecha y hora de coleccion de muestra');
INSERT INTO `lang_definitions` VALUES (4481, 2636, 3, 'Fecha y hora de esta observación');
INSERT INTO `lang_definitions` VALUES (4482, 2638, 3, 'Fecha y hora cuando la muestra fue colectada');
INSERT INTO `lang_definitions` VALUES (4483, 2639, 3, 'La fecha no puede ser mayor a la de hoy');
INSERT INTO `lang_definitions` VALUES (4484, 2640, 3, 'Fecha en que fueron provistos inicialmente los servicios anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4485, 2641, 3, 'Fecha Creacion');
INSERT INTO `lang_definitions` VALUES (4486, 2642, 3, 'Fecha Defunción');
INSERT INTO `lang_definitions` VALUES (4487, 2643, 3, 'Fecha destruída');
INSERT INTO `lang_definitions` VALUES (4488, 2644, 3, 'Formato visualización de fecha');
INSERT INTO `lang_definitions` VALUES (4489, 2645, 3, 'Formato fecha para última cita no es válido');
INSERT INTO `lang_definitions` VALUES (4490, 2646, 3, 'Formato fecha para inicio de cita no es válido');
INSERT INTO `lang_definitions` VALUES (4491, 2647, 3, 'Formato fecha en \'Próxima Cita\' no es válido');
INSERT INTO `lang_definitions` VALUES (4492, 2648, 3, 'Formato fecha en \'no visto desde\' no es válido');
INSERT INTO `lang_definitions` VALUES (4493, 2650, 3, 'Formato fecha en \'visto en\' no es válido');
INSERT INTO `lang_definitions` VALUES (4494, 2651, 3, 'Comunicados de fechas de vacunación entregados');
INSERT INTO `lang_definitions` VALUES (4495, 2652, 3, 'Falta fecha para código');
INSERT INTO `lang_definitions` VALUES (4496, 2653, 3, 'Criterio maestro de fecha');
INSERT INTO `lang_definitions` VALUES (4497, 2656, 3, 'Fecha ingreso en banco aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4498, 2657, 3, 'Fecha de factura');
INSERT INTO `lang_definitions` VALUES (4499, 2658, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4500, 2659, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4501, 2660, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4502, 2663, 3, 'Fecha de entrada');
INSERT INTO `lang_definitions` VALUES (4503, 2665, 3, 'Fecha de la lesión');
INSERT INTO `lang_definitions` VALUES (4504, 2669, 3, 'Fecha de pago aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4505, 2671, 3, 'Fecha de derivación');
INSERT INTO `lang_definitions` VALUES (4506, 2673, 3, 'Fecha de la respuesta');
INSERT INTO `lang_definitions` VALUES (4507, 2675, 3, 'Fecha De Servicio');
INSERT INTO `lang_definitions` VALUES (4508, 2677, 3, 'Fecha de servicio');
INSERT INTO `lang_definitions` VALUES (4509, 2678, 3, 'Fecha de servicio = hoy');
INSERT INTO `lang_definitions` VALUES (4510, 2680, 3, 'Fecha de servicio mm/dd/aaaa');
INSERT INTO `lang_definitions` VALUES (4511, 2681, 3, 'Fecha de Servicio:');
INSERT INTO `lang_definitions` VALUES (4512, 2682, 3, 'Fecha de firma');
INSERT INTO `lang_definitions` VALUES (4513, 2685, 3, 'Fecha de esta orden');
INSERT INTO `lang_definitions` VALUES (4514, 2686, 3, 'Fecha de este reporte');
INSERT INTO `lang_definitions` VALUES (4515, 2687, 3, 'Fecha de la Declaración de VIS');
INSERT INTO `lang_definitions` VALUES (4516, 2688, 3, 'Fecha en que se ordenó');
INSERT INTO `lang_definitions` VALUES (4517, 2692, 3, 'Seleccionador de fecha');
INSERT INTO `lang_definitions` VALUES (4518, 2693, 3, 'Fecha Envio');
INSERT INTO `lang_definitions` VALUES (4519, 2694, 3, 'Fecha del mensaje enviado');
INSERT INTO `lang_definitions` VALUES (4520, 2697, 3, 'La fecha no puede estar en blanco');
INSERT INTO `lang_definitions` VALUES (4521, 2700, 3, 'Fecha/Cita');
INSERT INTO `lang_definitions` VALUES (4522, 2701, 3, 'Fecha/Notas');
INSERT INTO `lang_definitions` VALUES (4523, 2702, 3, 'Fecha/Notas de Último');
INSERT INTO `lang_definitions` VALUES (4524, 2703, 3, 'Fecha/Hora');
INSERT INTO `lang_definitions` VALUES (4525, 2704, 3, 'Fecha:');
INSERT INTO `lang_definitions` VALUES (4526, 2707, 3, 'Registro mensaje fechado');
INSERT INTO `lang_definitions` VALUES (4527, 2710, 3, 'Día');
INSERT INTO `lang_definitions` VALUES (4528, 2711, 3, 'dia');
INSERT INTO `lang_definitions` VALUES (4529, 2714, 3, 'Vista de día');
INSERT INTO `lang_definitions` VALUES (4530, 2715, 3, 'Día(s)');
INSERT INTO `lang_definitions` VALUES (4531, 2716, 3, 'Día(s) L-V');
INSERT INTO `lang_definitions` VALUES (4532, 2717, 3, 'días');
INSERT INTO `lang_definitions` VALUES (4533, 2718, 3, 'Días');
INSERT INTO `lang_definitions` VALUES (4534, 2719, 3, 'días pasados');
INSERT INTO `lang_definitions` VALUES (4535, 2720, 3, 'Dïas y juegos perdidos');
INSERT INTO `lang_definitions` VALUES (4536, 2721, 3, 'Días Desde la Última Visita');
INSERT INTO `lang_definitions` VALUES (4537, 2722, 3, 'Dias faltados');
INSERT INTO `lang_definitions` VALUES (4538, 2725, 3, 'Días por columna');
INSERT INTO `lang_definitions` VALUES (4539, 2727, 3, 'Días/Col');
INSERT INTO `lang_definitions` VALUES (4540, 2728, 3, 'DB instalado');
INSERT INTO `lang_definitions` VALUES (4541, 2729, 3, 'DD/MM/AAAA');
INSERT INTO `lang_definitions` VALUES (4542, 2730, 3, 'Anonimato');
INSERT INTO `lang_definitions` VALUES (4543, 2731, 3, 'El proceso de anonimato está completo');
INSERT INTO `lang_definitions` VALUES (4544, 2732, 3, 'El proceso de anonimato está en proceso');
INSERT INTO `lang_definitions` VALUES (4545, 2733, 3, 'El proceso de anonimato ha iniciado y está corriendo en el fondo');
INSERT INTO `lang_definitions` VALUES (4546, 2734, 3, 'Los datos anónimos pueden no estar completos');
INSERT INTO `lang_definitions` VALUES (4547, 2735, 3, 'Los ficheros anónimos serán guardados en');
INSERT INTO `lang_definitions` VALUES (4548, 2736, 3, 'DEA');
INSERT INTO `lang_definitions` VALUES (4549, 2742, 3, 'Sordera');
INSERT INTO `lang_definitions` VALUES (4550, 2746, 3, 'Elimine errores de la información');
INSERT INTO `lang_definitions` VALUES (4551, 2749, 3, 'Dic');
INSERT INTO `lang_definitions` VALUES (4552, 2751, 3, 'DIFUNTO');
INSERT INTO `lang_definitions` VALUES (4553, 2758, 3, 'Diciembre');
INSERT INTO `lang_definitions` VALUES (4554, 2764, 3, 'Deducible');
INSERT INTO `lang_definitions` VALUES (4555, 2765, 3, 'Deducible alcanzado');
INSERT INTO `lang_definitions` VALUES (4556, 2767, 3, 'Por Defecto');
INSERT INTO `lang_definitions` VALUES (4557, 2770, 3, 'Vista Calendario por defecto');
INSERT INTO `lang_definitions` VALUES (4558, 2773, 3, 'Formulario ID para Visita por defecto');
INSERT INTO `lang_definitions` VALUES (4559, 2776, 3, 'Centro por defecto');
INSERT INTO `lang_definitions` VALUES (4560, 2781, 3, 'Idioma por defecto');
INSERT INTO `lang_definitions` VALUES (4561, 2782, 3, 'Idioma por defecto si no se permite otro, o bien elegir.');
INSERT INTO `lang_definitions` VALUES (4562, 2785, 3, 'Lista por defecto (escriba, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4563, 2787, 3, 'Método por defecto');
INSERT INTO `lang_definitions` VALUES (4564, 2788, 3, 'Días Expiración Contraseña por Defecto');
INSERT INTO `lang_definitions` VALUES (4565, 2789, 3, 'El periodo de vencimiento de la contraseña por defecto es 0. Ésto significa que la función está desactivada');
INSERT INTO `lang_definitions` VALUES (4566, 2790, 3, 'País por defecto del Paciente');
INSERT INTO `lang_definitions` VALUES (4567, 2796, 3, 'Médico por defecto');
INSERT INTO `lang_definitions` VALUES (4568, 2798, 3, 'Rango por defecto');
INSERT INTO `lang_definitions` VALUES (4569, 2799, 3, 'Razón por defecto de la visita');
INSERT INTO `lang_definitions` VALUES (4570, 2804, 3, 'Configuración por defecto');
INSERT INTO `lang_definitions` VALUES (4571, 2806, 3, 'Estado de la casilla por defecto de nueva ventana en la lista de pacientes.');
INSERT INTO `lang_definitions` VALUES (4572, 2807, 3, 'Plantilla por defecto');
INSERT INTO `lang_definitions` VALUES (4573, 2813, 3, 'Unidades por defecto');
INSERT INTO `lang_definitions` VALUES (4574, 2815, 3, 'Valor por defecto');
INSERT INTO `lang_definitions` VALUES (4575, 2818, 3, 'Deposito por defecto');
INSERT INTO `lang_definitions` VALUES (4576, 2819, 3, 'Socio X12 por defecto');
INSERT INTO `lang_definitions` VALUES (4577, 2820, 3, 'Por defecto/Global');
INSERT INTO `lang_definitions` VALUES (4578, 2827, 3, 'Borrar');
INSERT INTO `lang_definitions` VALUES (4579, 2828, 3, 'borrar');
INSERT INTO `lang_definitions` VALUES (4580, 2829, 3, 'Repetición retrasada (> 12 Mo)');
INSERT INTO `lang_definitions` VALUES (4581, 2830, 3, 'Eliminar');
INSERT INTO `lang_definitions` VALUES (4582, 2831, 3, 'eliminar');
INSERT INTO `lang_definitions` VALUES (4583, 2832, 3, 'Eliminar Categorías con identificador(es) :');
INSERT INTO `lang_definitions` VALUES (4584, 2833, 3, 'Borrar Categoría');
INSERT INTO `lang_definitions` VALUES (4585, 2837, 3, 'Eliminar Grupo');
INSERT INTO `lang_definitions` VALUES (4586, 2838, 3, 'Eliminar Lista');
INSERT INTO `lang_definitions` VALUES (4587, 2842, 3, 'Eliminar Páginas');
INSERT INTO `lang_definitions` VALUES (4588, 2843, 3, 'Borrar Paciente, visita, formulario, Incidencia, Documento, Pago, facturación o Transacción');
INSERT INTO `lang_definitions` VALUES (4589, 2845, 3, 'Borrar fila');
INSERT INTO `lang_definitions` VALUES (4590, 2846, 3, 'Borrar ítems selectos');
INSERT INTO `lang_definitions` VALUES (4591, 2849, 3, 'Eliminar éxito.');
INSERT INTO `lang_definitions` VALUES (4592, 2850, 3, 'Eliminar este documento');
INSERT INTO `lang_definitions` VALUES (4593, 2851, 3, 'Eliminar este formulario');
INSERT INTO `lang_definitions` VALUES (4594, 2853, 3, 'Eliminar esta nota');
INSERT INTO `lang_definitions` VALUES (4595, 2855, 3, 'Borrado Completado');
INSERT INTO `lang_definitions` VALUES (4596, 2857, 3, 'No se puede deshacer la eliminación de este evento. No se puede recuperar una vez que se ha hecho. ¿Está seguro que desea eliminar este evento?');
INSERT INTO `lang_definitions` VALUES (4597, 2866, 3, 'Demencia');
INSERT INTO `lang_definitions` VALUES (4598, 2868, 3, 'Datos demográficos');
INSERT INTO `lang_definitions` VALUES (4599, 2869, 3, 'Demografía (escribir, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4600, 2873, 3, 'Criterio de Filtro Demográficos');
INSERT INTO `lang_definitions` VALUES (4601, 2875, 3, 'Datos demográficos no autorizados');
INSERT INTO `lang_definitions` VALUES (4602, 2876, 3, 'Datos demográficos no autorizados');
INSERT INTO `lang_definitions` VALUES (4603, 2877, 3, 'Denegado');
INSERT INTO `lang_definitions` VALUES (4604, 2879, 3, 'Denominador');
INSERT INTO `lang_definitions` VALUES (4605, 2882, 3, 'Dental');
INSERT INTO `lang_definitions` VALUES (4606, 2884, 3, 'Incidencias Dentales');
INSERT INTO `lang_definitions` VALUES (4607, 2889, 3, 'Dependiendo del tipo de cuenta que usted prueba, usted verá salida tipo HCFA en una página en blanco para las cuentas de HCFA, o usted verá muchas líneas de texto e información alteradas, si usted está probando una demanda X12. Ese texto mutilado es el formato del X12 IED 4010A. Usted verá de vez en cuando los caracteres extraños que parecen dominós o basura, se trata de caracteres de control tales como alimentaciones de página y son normales.');
INSERT INTO `lang_definitions` VALUES (4608, 2891, 3, 'Fecha de depósito');
INSERT INTO `lang_definitions` VALUES (4609, 2892, 3, 'La fecha del deposiito no puede ser mayor a la de hoy');
INSERT INTO `lang_definitions` VALUES (4610, 2893, 3, 'Fecha del depósito');
INSERT INTO `lang_definitions` VALUES (4611, 2894, 3, 'Depresivo');
INSERT INTO `lang_definitions` VALUES (4612, 2895, 3, 'Depresión');
INSERT INTO `lang_definitions` VALUES (4613, 2901, 3, 'Descripción');
INSERT INTO `lang_definitions` VALUES (4614, 2902, 3, 'descripción');
INSERT INTO `lang_definitions` VALUES (4615, 2905, 3, 'Descripción de la publicación');
INSERT INTO `lang_definitions` VALUES (4616, 2906, 3, 'Desceripcion de este procedimiento o codigo resultante');
INSERT INTO `lang_definitions` VALUES (4617, 2907, 3, 'Traducción de la descripción');
INSERT INTO `lang_definitions` VALUES (4618, 2909, 3, 'Destino');
INSERT INTO `lang_definitions` VALUES (4619, 2910, 3, 'Nombre del fichero destino');
INSERT INTO `lang_definitions` VALUES (4620, 2913, 3, 'Destruir todo el lote');
INSERT INTO `lang_definitions` VALUES (4621, 2914, 3, 'Destruido ...');
INSERT INTO `lang_definitions` VALUES (4622, 2915, 3, 'Destruido');
INSERT INTO `lang_definitions` VALUES (4623, 2916, 3, 'Drogas destruidas');
INSERT INTO `lang_definitions` VALUES (4624, 2917, 3, 'Informe drogas destruidas');
INSERT INTO `lang_definitions` VALUES (4625, 2919, 3, 'Detalle');
INSERT INTO `lang_definitions` VALUES (4626, 2924, 3, 'Detalles');
INSERT INTO `lang_definitions` VALUES (4627, 2930, 3, 'Anormalidad del desarrollo');
INSERT INTO `lang_definitions` VALUES (4628, 2933, 3, 'Diabetes');
INSERT INTO `lang_definitions` VALUES (4629, 2934, 3, 'Diabetes Mellitus');
INSERT INTO `lang_definitions` VALUES (4630, 2935, 3, 'Diabetes: Gestión presión arterial (GCC)');
INSERT INTO `lang_definitions` VALUES (4631, 2936, 3, 'Diabetes:Examen Ocular');
INSERT INTO `lang_definitions` VALUES (4632, 2937, 3, 'Diabetes: Examen ocular (GCC)');
INSERT INTO `lang_definitions` VALUES (4633, 2938, 3, 'Diabetes: Examen de los pies');
INSERT INTO `lang_definitions` VALUES (4634, 2939, 3, 'Diabetes: Examen de los pies (GCC)');
INSERT INTO `lang_definitions` VALUES (4635, 2940, 3, 'Diabetes:Control HbA1c Deficiente (GCC)');
INSERT INTO `lang_definitions` VALUES (4636, 2941, 3, 'Diabetes: Hemoglobina A1C');
INSERT INTO `lang_definitions` VALUES (4637, 2942, 3, 'Diabetes: Gestión LDL y Control (GCC)');
INSERT INTO `lang_definitions` VALUES (4638, 2943, 3, 'Diabetes: Microalbúmina de la orina');
INSERT INTO `lang_definitions` VALUES (4639, 2944, 3, 'Diag');
INSERT INTO `lang_definitions` VALUES (4640, 2945, 3, 'Diagnósticos');
INSERT INTO `lang_definitions` VALUES (4641, 2946, 3, 'Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4642, 2947, 3, 'Cód. Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4643, 2948, 3, 'Códigos diagnósticos');
INSERT INTO `lang_definitions` VALUES (4644, 2950, 3, 'Fecha de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4645, 2952, 3, 'El diagnóstico debe ser codificado en una visita vinculada');
INSERT INTO `lang_definitions` VALUES (4646, 2953, 3, 'Nombre del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4647, 2954, 3, 'Reporte del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4648, 2955, 3, 'Informe de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4649, 2956, 3, 'Informe sólo de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4650, 2957, 3, 'Título del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4651, 2958, 3, 'Diagnóstico:');
INSERT INTO `lang_definitions` VALUES (4652, 2959, 3, 'Diagnóstico:');
INSERT INTO `lang_definitions` VALUES (4653, 2960, 3, 'Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4654, 2961, 3, 'Pruebas diagnósticas:');
INSERT INTO `lang_definitions` VALUES (4655, 2963, 3, 'Diales');
INSERT INTO `lang_definitions` VALUES (4656, 2966, 3, 'Diafragmas/Capuchón cervical');
INSERT INTO `lang_definitions` VALUES (4657, 2967, 3, 'Diarrea');
INSERT INTO `lang_definitions` VALUES (4658, 2968, 3, 'Diastólico');
INSERT INTO `lang_definitions` VALUES (4659, 2970, 3, 'Dictado');
INSERT INTO `lang_definitions` VALUES (4660, 2971, 3, 'Dictado:');
INSERT INTO `lang_definitions` VALUES (4661, 2972, 3, '¿Usted recibió una copia del aviso de HIPAA?');
INSERT INTO `lang_definitions` VALUES (4662, 2975, 3, 'Difuso:');
INSERT INTO `lang_definitions` VALUES (4663, 2976, 3, 'Firmado digitalmente');
INSERT INTO `lang_definitions` VALUES (4664, 2977, 3, 'Dilatado con');
INSERT INTO `lang_definitions` VALUES (4665, 2982, 3, 'Directo');
INSERT INTO `lang_definitions` VALUES (4666, 2983, 3, 'Dirección Directa');
INSERT INTO `lang_definitions` VALUES (4667, 2984, 3, 'Dirección Directa');
INSERT INTO `lang_definitions` VALUES (4668, 2985, 3, 'Mail directo');
INSERT INTO `lang_definitions` VALUES (4669, 2986, 3, 'Correo Directo');
INSERT INTO `lang_definitions` VALUES (4670, 2987, 3, 'Registro Mens. Directo');
INSERT INTO `lang_definitions` VALUES (4671, 2988, 3, 'Mens.Directo recibido');
INSERT INTO `lang_definitions` VALUES (4672, 2989, 3, 'Mensaje directo no disponible ahora');
INSERT INTO `lang_definitions` VALUES (4673, 2990, 3, 'Falla de envío de mensaje directo');
INSERT INTO `lang_definitions` VALUES (4674, 2991, 3, 'Directivas');
INSERT INTO `lang_definitions` VALUES (4675, 2993, 3, 'Nombre del director');
INSERT INTO `lang_definitions` VALUES (4676, 2995, 3, 'inhabilitación');
INSERT INTO `lang_definitions` VALUES (4677, 3000, 3, 'Deshabilitar calendario');
INSERT INTO `lang_definitions` VALUES (4678, 3001, 3, 'Deshabilitar Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (4679, 3004, 3, 'Deshabilitar vacunaciones');
INSERT INTO `lang_definitions` VALUES (4680, 3006, 3, 'Deshabilitar vieja forma métrica de constantes vitales');
INSERT INTO `lang_definitions` VALUES (4681, 3009, 3, 'Deshabilitar phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (4682, 3010, 3, 'Deshabilitar prescriciones');
INSERT INTO `lang_definitions` VALUES (4683, 3012, 3, 'Deshabilitar grupos de usuarios');
INSERT INTO `lang_definitions` VALUES (4684, 3013, 3, 'inhabilitado');
INSERT INTO `lang_definitions` VALUES (4685, 3014, 3, 'inhabilitado');
INSERT INTO `lang_definitions` VALUES (4686, 3015, 3, 'Beneficiario discapacitado menor de 65 años con un Plan de salud para grandes grupos (LGHP)');
INSERT INTO `lang_definitions` VALUES (4687, 3020, 3, 'DISCO');
INSERT INTO `lang_definitions` VALUES (4688, 3023, 3, 'Descarga');
INSERT INTO `lang_definitions` VALUES (4689, 3025, 3, 'Pérdidas/secreciones de la uretra');
INSERT INTO `lang_definitions` VALUES (4690, 3027, 3, 'Derecho de alta');
INSERT INTO `lang_definitions` VALUES (4691, 3028, 3, 'Derecho de alta:');
INSERT INTO `lang_definitions` VALUES (4692, 3034, 3, 'Informacion de publicación');
INSERT INTO `lang_definitions` VALUES (4693, 3035, 3, 'Tipo de publicación');
INSERT INTO `lang_definitions` VALUES (4694, 3036, 3, 'Tipos de publicación');
INSERT INTO `lang_definitions` VALUES (4695, 3037, 3, 'Publicaciones');
INSERT INTO `lang_definitions` VALUES (4696, 3041, 3, 'Suspender');
INSERT INTO `lang_definitions` VALUES (4697, 3042, 3, 'Descuento');
INSERT INTO `lang_definitions` VALUES (4698, 3043, 3, 'Suma de descuento');
INSERT INTO `lang_definitions` VALUES (4699, 3044, 3, 'Nivel del Descuento');
INSERT INTO `lang_definitions` VALUES (4700, 3045, 3, 'Porcentaje de descuento');
INSERT INTO `lang_definitions` VALUES (4701, 3047, 3, 'Descuentos como importes monetarios');
INSERT INTO `lang_definitions` VALUES (4702, 3048, 3, 'Descuentos a la hora de salida se introducen como cantidades de dinero, a diferencia de porcentaje.');
INSERT INTO `lang_definitions` VALUES (4703, 3050, 3, 'Resultado discreto');
INSERT INTO `lang_definitions` VALUES (4704, 3052, 3, 'Enfermedad');
INSERT INTO `lang_definitions` VALUES (4705, 3055, 3, 'Dislocación');
INSERT INTO `lang_definitions` VALUES (4706, 3059, 3, '# Disp');
INSERT INTO `lang_definitions` VALUES (4707, 3060, 3, 'Informe');
INSERT INTO `lang_definitions` VALUES (4708, 3061, 3, 'Remitir documento recibido');
INSERT INTO `lang_definitions` VALUES (4709, 3065, 3, 'Prescrito');
INSERT INTO `lang_definitions` VALUES (4710, 3068, 3, 'Mostrar las directivas anticipadas en la página de la demografía.');
INSERT INTO `lang_definitions` VALUES (4711, 3071, 3, '¿Mostrar fechas de eventos en bloque?');
INSERT INTO `lang_definitions` VALUES (4712, 3073, 3, '¿Mostrar cuántos eventos?');
INSERT INTO `lang_definitions` VALUES (4713, 3078, 3, '¿Mostrar lugar/sitio en bloque?');
INSERT INTO `lang_definitions` VALUES (4714, 3080, 3, 'Nombre Pantalla');
INSERT INTO `lang_definitions` VALUES (4715, 3083, 3, '¿Mostrar el calendario?');
INSERT INTO `lang_definitions` VALUES (4716, 3092, 3, '¿Mostrar los eventos de hoy en el bloque?');
INSERT INTO `lang_definitions` VALUES (4717, 3093, 3, '¿Mostrar tema en el bloque?');
INSERT INTO `lang_definitions` VALUES (4718, 3094, 3, '¿Mostrar los eventos próximos en tabla?');
INSERT INTO `lang_definitions` VALUES (4719, 3096, 3, 'Mostrar columnas');
INSERT INTO `lang_definitions` VALUES (4720, 3097, 3, 'Viendo el siguiente número de las publicaciones más recientes:');
INSERT INTO `lang_definitions` VALUES (4721, 3099, 3, 'Mostrando el siguiente número de las notas más recientes');
INSERT INTO `lang_definitions` VALUES (4722, 3100, 3, 'Mostrando el siguiente número de las notas más recientes:');
INSERT INTO `lang_definitions` VALUES (4723, 3107, 3, 'Distribución');
INSERT INTO `lang_definitions` VALUES (4724, 3108, 3, 'Distribuciones');
INSERT INTO `lang_definitions` VALUES (4725, 3109, 3, 'Distribuidor');
INSERT INTO `lang_definitions` VALUES (4726, 3114, 3, 'Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4727, 3115, 3, 'Operación de Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4728, 3116, 3, 'Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4729, 3117, 3, 'Operación de Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4730, 3118, 3, 'Divorciado');
INSERT INTO `lang_definitions` VALUES (4731, 3119, 3, 'Mareo:');
INSERT INTO `lang_definitions` VALUES (4732, 3122, 3, 'No cambiar');
INSERT INTO `lang_definitions` VALUES (4733, 3124, 3, 'No mostrar alergia subida a NewCrop');
INSERT INTO `lang_definitions` VALUES (4734, 3126, 3, 'No mostrar medicación subida a NewCrop');
INSERT INTO `lang_definitions` VALUES (4735, 3129, 3, 'No mostrar el calendario');
INSERT INTO `lang_definitions` VALUES (4736, 3133, 3, 'No inventariar ni vender nigun producto');
INSERT INTO `lang_definitions` VALUES (4737, 3136, 3, 'No requiere notas del paciente para ser autorizado');
INSERT INTO `lang_definitions` VALUES (4738, 3137, 3, 'Orden de No Resucitar');
INSERT INTO `lang_definitions` VALUES (4739, 3138, 3, 'no guardar');
INSERT INTO `lang_definitions` VALUES (4740, 3139, 3, 'no sustituir');
INSERT INTO `lang_definitions` VALUES (4741, 3142, 3, 'no actuar');
INSERT INTO `lang_definitions` VALUES (4742, 3147, 3, 'De verdad quiere suprimir?');
INSERT INTO `lang_definitions` VALUES (4743, 3148, 3, '¿Verdaderamente desea borrar la selección?');
INSERT INTO `lang_definitions` VALUES (4744, 3149, 3, 'Está seguro que quiere eliminar este grupo');
INSERT INTO `lang_definitions` VALUES (4745, 3153, 3, '¿Quiere continuar?');
INSERT INTO `lang_definitions` VALUES (4746, 3154, 3, '¿Quiere borrar esto?');
INSERT INTO `lang_definitions` VALUES (4747, 3155, 3, '¿Quiere borrar?');
INSERT INTO `lang_definitions` VALUES (4748, 3156, 3, '¿Desea remover este registro?');
INSERT INTO `lang_definitions` VALUES (4749, 3157, 3, '¿Desea continuar añadiendo este nuevo paciente?');
INSERT INTO `lang_definitions` VALUES (4750, 3158, 3, '¿Usted desea continuar con el nuevo nombre?');
INSERT INTO `lang_definitions` VALUES (4751, 3159, 3, '¿Usted desea suprimir DEFINITIVAMENTE este registro de vacunación?');
INSERT INTO `lang_definitions` VALUES (4752, 3160, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4753, 3162, 3, 'Falta F.Nacimiento, por favor insertarla si es posible');
INSERT INTO `lang_definitions` VALUES (4754, 3164, 3, 'Documentos');
INSERT INTO `lang_definitions` VALUES (4755, 3165, 3, 'Médico');
INSERT INTO `lang_definitions` VALUES (4756, 3166, 3, 'Médico:');
INSERT INTO `lang_definitions` VALUES (4757, 3167, 3, 'Nombre del médico y firma');
INSERT INTO `lang_definitions` VALUES (4758, 3168, 3, 'Documento');
INSERT INTO `lang_definitions` VALUES (4759, 3169, 3, 'documento');
INSERT INTO `lang_definitions` VALUES (4760, 3171, 3, 'Categorías documento');
INSERT INTO `lang_definitions` VALUES (4761, 3178, 3, 'El documento no ha podido ser trasladado al Nº Identificación del paciente');
INSERT INTO `lang_definitions` VALUES (4762, 3180, 3, 'Fecha de documento');
INSERT INTO `lang_definitions` VALUES (4763, 3181, 3, 'Fecha del documento e incidencia actualizadas con éxito');
INSERT INTO `lang_definitions` VALUES (4764, 3182, 3, 'Nº Identificación de Documento');
INSERT INTO `lang_definitions` VALUES (4765, 3185, 3, 'Documento se trasladó a nueva categoría');
INSERT INTO `lang_definitions` VALUES (4766, 3186, 3, 'Documento se trasladó al Nº Identificación del paciente');
INSERT INTO `lang_definitions` VALUES (4767, 3188, 3, 'Documento aprobó la comprobación de integridad');
INSERT INTO `lang_definitions` VALUES (4768, 3189, 3, 'Método de archivo de documentos');
INSERT INTO `lang_definitions` VALUES (4769, 3190, 3, 'Documento renombrado con éxito');
INSERT INTO `lang_definitions` VALUES (4770, 3196, 3, 'Depósito de documentos/Imágenes');
INSERT INTO `lang_definitions` VALUES (4771, 3198, 3, 'Documentos');
INSERT INTO `lang_definitions` VALUES (4772, 3200, 3, 'Documentos (escribir, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (4773, 3209, 3, 'DOE');
INSERT INTO `lang_definitions` VALUES (4774, 3216, 3, '¿Este tipo permite codigos relacionados?');
INSERT INTO `lang_definitions` VALUES (4775, 3217, 3, 'Socio doméstico');
INSERT INTO `lang_definitions` VALUES (4776, 3218, 3, 'No Guardar');
INSERT INTO `lang_definitions` VALUES (4777, 3219, 3, 'No Guardar');
INSERT INTO `lang_definitions` VALUES (4778, 3220, 3, 'No Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (4779, 3223, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (4780, 3225, 3, 'Hecho con:');
INSERT INTO `lang_definitions` VALUES (4781, 3226, 3, 'Terminado. Ahora se enviará la descarga');
INSERT INTO `lang_definitions` VALUES (4782, 3227, 3, 'DOS');
INSERT INTO `lang_definitions` VALUES (4783, 3228, 3, 'Dosis');
INSERT INTO `lang_definitions` VALUES (4784, 3232, 3, 'Doble click para editar');
INSERT INTO `lang_definitions` VALUES (4785, 3234, 3, 'Visión doble');
INSERT INTO `lang_definitions` VALUES (4786, 3235, 3, 'Descarga');
INSERT INTO `lang_definitions` VALUES (4787, 3241, 3, 'Descargar de todas formas');
INSERT INTO `lang_definitions` VALUES (4788, 3242, 3, 'Descargar expediente de factura, mandar a contabilidad y marcar como facturado.');
INSERT INTO `lang_definitions` VALUES (4789, 3245, 3, 'Certificados de descargas');
INSERT INTO `lang_definitions` VALUES (4790, 3247, 3, 'Descargar datos de configuración');
INSERT INTO `lang_definitions` VALUES (4791, 3252, 3, 'Descargar fichero encriptado');
INSERT INTO `lang_definitions` VALUES (4792, 3253, 3, 'Descargar FAX');
INSERT INTO `lang_definitions` VALUES (4793, 3258, 3, 'Descargar o Borrar una plantilla');
INSERT INTO `lang_definitions` VALUES (4794, 3260, 3, 'Descargar PDF');
INSERT INTO `lang_definitions` VALUES (4795, 3264, 3, 'Descargar seleccionados');
INSERT INTO `lang_definitions` VALUES (4796, 3267, 3, 'Revisar médico');
INSERT INTO `lang_definitions` VALUES (4797, 3268, 3, 'Visitar médico');
INSERT INTO `lang_definitions` VALUES (4798, 3269, 3, 'Dr.');
INSERT INTO `lang_definitions` VALUES (4799, 3273, 3, 'Arrastre para mover');
INSERT INTO `lang_definitions` VALUES (4800, 3275, 3, 'Goteo');
INSERT INTO `lang_definitions` VALUES (4801, 3276, 3, 'Permiso de conducir o D.N.I.');
INSERT INTO `lang_definitions` VALUES (4802, 3278, 3, 'Medicamento');
INSERT INTO `lang_definitions` VALUES (4803, 3281, 3, 'Buscador de medicamentos');
INSERT INTO `lang_definitions` VALUES (4804, 3282, 3, 'Formularios de Medicamento');
INSERT INTO `lang_definitions` VALUES (4805, 3283, 3, 'Nº Identificación medicamento falta!');
INSERT INTO `lang_definitions` VALUES (4806, 3284, 3, 'Intervalos de Medicamento');
INSERT INTO `lang_definitions` VALUES (4807, 3285, 3, 'Inventario de Medicamentos');
INSERT INTO `lang_definitions` VALUES (4808, 3287, 3, 'Nombre del Medicamento');
INSERT INTO `lang_definitions` VALUES (4809, 3289, 3, 'Vía de administración del Medicamento');
INSERT INTO `lang_definitions` VALUES (4810, 3294, 3, 'Unidades de Medicamento');
INSERT INTO `lang_definitions` VALUES (4811, 3300, 3, 'Medicamentos');
INSERT INTO `lang_definitions` VALUES (4812, 3301, 3, 'Medicamentos y productos');
INSERT INTO `lang_definitions` VALUES (4813, 3302, 3, 'Boca seca');
INSERT INTO `lang_definitions` VALUES (4814, 3303, 3, 'Diagnóstico DSMIV');
INSERT INTO `lang_definitions` VALUES (4815, 3304, 3, 'DT 1');
INSERT INTO `lang_definitions` VALUES (4816, 3305, 3, 'DT 2');
INSERT INTO `lang_definitions` VALUES (4817, 3306, 3, 'DT 3');
INSERT INTO `lang_definitions` VALUES (4818, 3307, 3, 'DT 4');
INSERT INTO `lang_definitions` VALUES (4819, 3308, 3, 'DT 5');
INSERT INTO `lang_definitions` VALUES (4820, 3309, 3, 'DTaP 1');
INSERT INTO `lang_definitions` VALUES (4821, 3310, 3, 'DTaP 2');
INSERT INTO `lang_definitions` VALUES (4822, 3311, 3, 'DTaP 3');
INSERT INTO `lang_definitions` VALUES (4823, 3312, 3, 'DTaP 4');
INSERT INTO `lang_definitions` VALUES (4824, 3313, 3, 'DTaP 5');
INSERT INTO `lang_definitions` VALUES (4825, 3315, 3, 'Adeudado');
INSERT INTO `lang_definitions` VALUES (4826, 3316, 3, 'Fecha del parto');
INSERT INTO `lang_definitions` VALUES (4827, 3318, 3, 'Fecha del parto mm/dd/aaaa o aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4828, 3319, 3, 'Fecha del parto:');
INSERT INTO `lang_definitions` VALUES (4829, 3320, 3, 'Deuda Seguro');
INSERT INTO `lang_definitions` VALUES (4830, 3321, 3, 'Deuda Paciente');
INSERT INTO `lang_definitions` VALUES (4831, 3322, 3, 'Deuda próxima');
INSERT INTO `lang_definitions` VALUES (4832, 3323, 3, 'Estado de Deuda');
INSERT INTO `lang_definitions` VALUES (4833, 3324, 3, 'Actualización Estado de Deuda');
INSERT INTO `lang_definitions` VALUES (4834, 3325, 3, 'Volcar OpenEMR base de datos');
INSERT INTO `lang_definitions` VALUES (4835, 3326, 3, 'Volcar OpenEMR web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4836, 3327, 3, 'Volcar phpGACL base de datos');
INSERT INTO `lang_definitions` VALUES (4837, 3328, 3, 'volcar phpGACL web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4838, 3329, 3, 'Volcar SQL-Ledger base de datos');
INSERT INTO `lang_definitions` VALUES (4839, 3330, 3, 'Volcar phpGACL web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4840, 3331, 3, 'Compruebe duplicado');
INSERT INTO `lang_definitions` VALUES (4841, 3338, 3, 'ID duplicado en linea');
INSERT INTO `lang_definitions` VALUES (4842, 3339, 3, 'Nombre duplicado en linea');
INSERT INTO `lang_definitions` VALUES (4843, 3340, 3, 'AVISO DE DUPLICACION');
INSERT INTO `lang_definitions` VALUES (4844, 3341, 3, 'Poder Legal Duradero');
INSERT INTO `lang_definitions` VALUES (4845, 3342, 3, 'Duración');
INSERT INTO `lang_definitions` VALUES (4846, 3343, 3, 'duración');
INSERT INTO `lang_definitions` VALUES (4847, 3345, 3, 'Holandés');
INSERT INTO `lang_definitions` VALUES (4848, 3347, 3, 'Dx Rep');
INSERT INTO `lang_definitions` VALUES (4849, 3348, 3, 'Disfagia');
INSERT INTO `lang_definitions` VALUES (4850, 3349, 3, 'Disnea');
INSERT INTO `lang_definitions` VALUES (4851, 3350, 3, 'Disuria');
INSERT INTO `lang_definitions` VALUES (4852, 3353, 3, 'E-Mail');
INSERT INTO `lang_definitions` VALUES (4853, 3354, 3, 'E-mail');
INSERT INTO `lang_definitions` VALUES (4854, 3359, 3, '¿E-Receta?');
INSERT INTO `lang_definitions` VALUES (4855, 3361, 3, 'Receta Electrónica');
INSERT INTO `lang_definitions` VALUES (4856, 3363, 3, 'Renovación Receta Electrónica');
INSERT INTO `lang_definitions` VALUES (4857, 3367, 3, 'Cada destinatario debe establecer sus propios mensajes como terminados.');
INSERT INTO `lang_definitions` VALUES (4858, 3373, 3, 'Repetición Temprana (<2 Mo)');
INSERT INTO `lang_definitions` VALUES (4859, 3374, 3, 'Orejas');
INSERT INTO `lang_definitions` VALUES (4860, 3381, 3, 'Electrocardiograma');
INSERT INTO `lang_definitions` VALUES (4861, 3382, 3, 'Reclamaciones electrónicas');
INSERT INTO `lang_definitions` VALUES (4862, 3385, 3, 'Edema');
INSERT INTO `lang_definitions` VALUES (4863, 3390, 3, 'Adjuntar fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (4864, 3391, 3, 'Respuesta de carga de fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (4865, 3392, 3, 'Editar');
INSERT INTO `lang_definitions` VALUES (4866, 3393, 3, 'editar');
INSERT INTO `lang_definitions` VALUES (4867, 3394, 3, 'Editar alergias');
INSERT INTO `lang_definitions` VALUES (4868, 3396, 3, 'Editar categorías');
INSERT INTO `lang_definitions` VALUES (4869, 3398, 3, 'Editar Definiciones');
INSERT INTO `lang_definitions` VALUES (4870, 3399, 3, 'Editar definiciones');
INSERT INTO `lang_definitions` VALUES (4871, 3400, 3, 'Editar diagnóstico para');
INSERT INTO `lang_definitions` VALUES (4872, 3401, 3, 'editar publicación');
INSERT INTO `lang_definitions` VALUES (4873, 3406, 3, 'Editar Clínicas');
INSERT INTO `lang_definitions` VALUES (4874, 3407, 3, 'Editar Centro');
INSERT INTO `lang_definitions` VALUES (4875, 3408, 3, 'Editar información del Centro');
INSERT INTO `lang_definitions` VALUES (4876, 3409, 3, 'Editar información de instalación de usuario específico');
INSERT INTO `lang_definitions` VALUES (4877, 3410, 3, 'editar fichero en');
INSERT INTO `lang_definitions` VALUES (4878, 3411, 3, 'Editar forma');
INSERT INTO `lang_definitions` VALUES (4879, 3412, 3, 'Editar configuración global');
INSERT INTO `lang_definitions` VALUES (4880, 3414, 3, 'Edición no permitida');
INSERT INTO `lang_definitions` VALUES (4881, 3416, 3, 'Editar el diseño');
INSERT INTO `lang_definitions` VALUES (4882, 3418, 3, 'Editar la lista');
INSERT INTO `lang_definitions` VALUES (4883, 3422, 3, 'Editar Pago');
INSERT INTO `lang_definitions` VALUES (4884, 3424, 3, 'Editar estructura');
INSERT INTO `lang_definitions` VALUES (4885, 3427, 3, 'Editar usuario');
INSERT INTO `lang_definitions` VALUES (4886, 3428, 3, 'Editar configuración de usuario');
INSERT INTO `lang_definitions` VALUES (4887, 3429, 3, 'Editar su información');
INSERT INTO `lang_definitions` VALUES (4888, 3431, 3, 'La edición falló');
INSERT INTO `lang_definitions` VALUES (4889, 3432, 3, 'Educación');
INSERT INTO `lang_definitions` VALUES (4890, 3433, 3, 'Fecha educación');
INSERT INTO `lang_definitions` VALUES (4891, 3435, 3, 'Debería haber recibido una copia del GNU con este programa, si no, escriba al Free');
INSERT INTO `lang_definitions` VALUES (4892, 3436, 3, 'Fecha efectiva');
INSERT INTO `lang_definitions` VALUES (4893, 3438, 3, 'Efectividad');
INSERT INTO `lang_definitions` VALUES (4894, 3440, 3, 'EIN');
INSERT INTO `lang_definitions` VALUES (4895, 3443, 3, 'Eyaculaciones');
INSERT INTO `lang_definitions` VALUES (4896, 3444, 3, 'Codo');
INSERT INTO `lang_definitions` VALUES (4897, 3445, 3, 'Problemas del codo');
INSERT INTO `lang_definitions` VALUES (4898, 3446, 3, 'Electrónico');
INSERT INTO `lang_definitions` VALUES (4899, 3450, 3, 'Mandatos Electronicos');
INSERT INTO `lang_definitions` VALUES (4900, 3454, 3, 'Elegibilidad');
INSERT INTO `lang_definitions` VALUES (4901, 3455, 3, 'Elegibilidad Batch Consulta 270');
INSERT INTO `lang_definitions` VALUES (4902, 3456, 3, 'Elegibilidad de Respuesta');
INSERT INTO `lang_definitions` VALUES (4903, 3458, 3, 'Estado de elegibilidad para la vacuna suministrada para niños');
INSERT INTO `lang_definitions` VALUES (4904, 3459, 3, 'Elegible');
INSERT INTO `lang_definitions` VALUES (4905, 3461, 3, 'email');
INSERT INTO `lang_definitions` VALUES (4906, 3464, 3, 'email');
INSERT INTO `lang_definitions` VALUES (4907, 3466, 3, 'email del remitente para los recordatorios de pacientes. Las respuestas de los pacientes irán a esa dirección. Es importante usar una dirección del dominio de la Clínica para evitar que las respuestas de recordatorios de los pacientes vayan a la carpeta de correo basura.');
INSERT INTO `lang_definitions` VALUES (4908, 3467, 3, 'email, si hay, para recibir notificaciones administrativas.');
INSERT INTO `lang_definitions` VALUES (4909, 3468, 3, 'email, si hay, para recibir mensajes de activación de inicio sesión de usuario.');
INSERT INTO `lang_definitions` VALUES (4910, 3469, 3, 'Autenticación email');
INSERT INTO `lang_definitions` VALUES (4911, 3472, 3, 'email de Batchcom');
INSERT INTO `lang_definitions` VALUES (4912, 3474, 3, 'Notificación email');
INSERT INTO `lang_definitions` VALUES (4913, 3475, 3, 'Horario Notificación Email');
INSERT INTO `lang_definitions` VALUES (4914, 3476, 3, 'Informe de notificación de email');
INSERT INTO `lang_definitions` VALUES (4915, 3480, 3, 'email enviado antes');
INSERT INTO `lang_definitions` VALUES (4916, 3481, 3, 'Remitente de email');
INSERT INTO `lang_definitions` VALUES (4917, 3482, 3, 'Email enviado');
INSERT INTO `lang_definitions` VALUES (4918, 3483, 3, 'email enviado a');
INSERT INTO `lang_definitions` VALUES (4919, 3484, 3, 'Asunto del email');
INSERT INTO `lang_definitions` VALUES (4920, 3487, 3, 'Texto del email, etiqueta útil: ***NAME***, Ej. Estimado ***NAME***');
INSERT INTO `lang_definitions` VALUES (4921, 3488, 3, 'Texto email, etiqueta útil:***NAME***, por ej. Querido ***NAME***{{No traducir el elemento ***NAME*** de esta constante}}');
INSERT INTO `lang_definitions` VALUES (4922, 3489, 3, 'Método de envío de email');
INSERT INTO `lang_definitions` VALUES (4923, 3490, 3, 'Email enviado a las siguientes direcciones');
INSERT INTO `lang_definitions` VALUES (4924, 3495, 3, 'Contacto en caso de emergencia');
INSERT INTO `lang_definitions` VALUES (4925, 3496, 3, 'Persona de Contacto de Emergencia');
INSERT INTO `lang_definitions` VALUES (4926, 3497, 3, 'Teléfono de Contacto de Emergencias');
INSERT INTO `lang_definitions` VALUES (4927, 3498, 3, 'Emergencia anticonceptiva');
INSERT INTO `lang_definitions` VALUES (4928, 3499, 3, 'Acceso de Emergencia');
INSERT INTO `lang_definitions` VALUES (4929, 3500, 3, 'Inicio sesión de Emergencia ACL elegido. El usuario esta aún activo, favor desactivar usuario y activarlo cuando la situación de emergencia lo requiera. Visitar Administración>Usuario para activación o deactivación');
INSERT INTO `lang_definitions` VALUES (4930, 3501, 3, 'El email de activación de inicio de sesión de emergencia ha de circular sólo si los siguientes ajustes del fichero interfase/globals.php están configurados:');
INSERT INTO `lang_definitions` VALUES (4931, 3502, 3, 'email de inicio de sesión de emergencia');
INSERT INTO `lang_definitions` VALUES (4932, 3503, 3, 'El usuario de Inicio de sesión de emergencia puede hacer cualquier cosa');
INSERT INTO `lang_definitions` VALUES (4933, 3504, 3, 'Teléfono de emergencia');
INSERT INTO `lang_definitions` VALUES (4934, 3507, 3, 'Enfisema');
INSERT INTO `lang_definitions` VALUES (4935, 3508, 3, 'Empleado');
INSERT INTO `lang_definitions` VALUES (4936, 3509, 3, 'Empresa');
INSERT INTO `lang_definitions` VALUES (4937, 3510, 3, 'Dirección del empleador');
INSERT INTO `lang_definitions` VALUES (4938, 3511, 3, 'Datos de la empresa');
INSERT INTO `lang_definitions` VALUES (4939, 3512, 3, 'Nombre de Empresa');
INSERT INTO `lang_definitions` VALUES (4940, 3513, 3, 'VACIO');
INSERT INTO `lang_definitions` VALUES (4941, 3514, 3, 'Vacio');
INSERT INTO `lang_definitions` VALUES (4942, 3520, 3, 'Valor vacío en -Horas de eEmail-');
INSERT INTO `lang_definitions` VALUES (4943, 3521, 3, 'Valor vacío en -Remitente de email-');
INSERT INTO `lang_definitions` VALUES (4944, 3522, 3, 'Valor vacío en-Tema de email-');
INSERT INTO `lang_definitions` VALUES (4945, 3523, 3, 'Valor vacío en-Texto de email-');
INSERT INTO `lang_definitions` VALUES (4946, 3524, 3, 'Valor vacío en -Nombre del Facultativo-');
INSERT INTO `lang_definitions` VALUES (4947, 3525, 3, 'Valor vacío en -Contraseña-');
INSERT INTO `lang_definitions` VALUES (4948, 3526, 3, 'Valor vacío en -Horas de SMS-');
INSERT INTO `lang_definitions` VALUES (4949, 3527, 3, 'Vaciar en el valor -Texto SMS-');
INSERT INTO `lang_definitions` VALUES (4950, 3528, 3, 'Vaciar en el valor -Usuario-');
INSERT INTO `lang_definitions` VALUES (4951, 3537, 3, 'Activar aviso MCA');
INSERT INTO `lang_definitions` VALUES (4952, 3539, 3, 'Activar Informe MCA');
INSERT INTO `lang_definitions` VALUES (4953, 3540, 3, 'Activar seguimiento MCA');
INSERT INTO `lang_definitions` VALUES (4954, 3542, 3, 'Activar auditoría RANA');
INSERT INTO `lang_definitions` VALUES (4955, 3544, 3, 'Inicio de sesión Auditoría habilitado');
INSERT INTO `lang_definitions` VALUES (4956, 3545, 3, 'Activar Auditoría Registro y Autenticación del Nodo (ATNA)');
INSERT INTO `lang_definitions` VALUES (4957, 3547, 3, 'Activar Informe Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4958, 3552, 3, 'Activar Cliente SSL');
INSERT INTO `lang_definitions` VALUES (4959, 3553, 3, 'Activar Cliente SSL con certificado de autenticación.');
INSERT INTO `lang_definitions` VALUES (4960, 3555, 3, 'Activar Reglas Clínicas de Decisión (CDR)');
INSERT INTO `lang_definitions` VALUES (4961, 3558, 3, 'Activar informe medidas de calidad clínica (GCC)');
INSERT INTO `lang_definitions` VALUES (4962, 3559, 3, 'Activar popup recordatorios clínicos');
INSERT INTO `lang_definitions` VALUES (4963, 3560, 3, 'Activar Widget Recordatorios clínicos');
INSERT INTO `lang_definitions` VALUES (4964, 3564, 3, 'Activar Informes GCC');
INSERT INTO `lang_definitions` VALUES (4965, 3576, 3, 'Habilitar tarifas en el menú de la izquierda');
INSERT INTO `lang_definitions` VALUES (4966, 3584, 3, 'Activar Soporte Hylafax');
INSERT INTO `lang_definitions` VALUES (4967, 3586, 3, 'Activar el estado de importación de mensajes para Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (4968, 3590, 3, 'Activar intercambio Laboratorio');
INSERT INTO `lang_definitions` VALUES (4969, 3592, 3, 'Habilitar registro para documentos subidos/bajados de CouchDB');
INSERT INTO `lang_definitions` VALUES (4970, 3593, 3, 'Activar registro de todas las consultas SQL SELECT.');
INSERT INTO `lang_definitions` VALUES (4971, 3594, 3, 'Activar registro de backup de actividades relacionadas.');
INSERT INTO `lang_definitions` VALUES (4972, 3596, 3, 'Activar inicio sesión de actividades varias.');
INSERT INTO `lang_definitions` VALUES (4973, 3597, 3, 'Activar registro de actividades solicitadas.');
INSERT INTO `lang_definitions` VALUES (4974, 3598, 3, 'Activar registro de modificaciones del registro de pacientes.');
INSERT INTO `lang_definitions` VALUES (4975, 3599, 3, 'Activar registro de programar actividades.');
INSERT INTO `lang_definitions` VALUES (4976, 3600, 3, 'Activar registro de seguridad y administración de actividades.');
INSERT INTO `lang_definitions` VALUES (4977, 3603, 3, 'Activar servicio Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (4978, 3608, 3, 'Activar Portal Paciente Externo');
INSERT INTO `lang_definitions` VALUES (4979, 3609, 3, 'Activar Portal paciente desde el exterior.');
INSERT INTO `lang_definitions` VALUES (4980, 3611, 3, 'Activar Portal paciente in-situ');
INSERT INTO `lang_definitions` VALUES (4981, 3614, 3, 'Activar Portal paciente in-situ.');
INSERT INTO `lang_definitions` VALUES (4982, 3630, 3, 'Activar widget recordatorios del paciente');
INSERT INTO `lang_definitions` VALUES (4983, 3634, 3, 'Activar aviso fecha requerida para Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4984, 3636, 3, 'Activar Informe de Seguimiento de Fecha para Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4985, 3638, 3, 'Activar Soporte escaner');
INSERT INTO `lang_definitions` VALUES (4986, 3643, 3, 'Activar servicio de soporte OpenEMR LLC Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (4987, 3644, 3, 'Activar Certificado de Autenticación del usuario.');
INSERT INTO `lang_definitions` VALUES (4988, 3650, 3, 'Activar servicio ZMG, Receta electrónica LLC');
INSERT INTO `lang_definitions` VALUES (4989, 3651, 3, 'Activado');
INSERT INTO `lang_definitions` VALUES (4990, 3659, 3, 'Activar el viejo panel de cargos para introducir códigos de facturas y pagos. No se recomienda usar la hoja de honorarios en su lugar.');
INSERT INTO `lang_definitions` VALUES (4991, 3662, 3, 'Encuentro');
INSERT INTO `lang_definitions` VALUES (4992, 3664, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4993, 3665, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4994, 3666, 3, 'visita');
INSERT INTO `lang_definitions` VALUES (4995, 3667, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4996, 3668, 3, 'Visita a un hospitalizado agudo o ED');
INSERT INTO `lang_definitions` VALUES (4997, 3674, 3, 'Fecha visita');
INSERT INTO `lang_definitions` VALUES (4998, 3679, 3, 'Formularios visita');
INSERT INTO `lang_definitions` VALUES (4999, 3680, 3, 'visita de salud y evaluación de comportamiento');
INSERT INTO `lang_definitions` VALUES (5000, 3681, 3, 'Histórico de visitas');
INSERT INTO `lang_definitions` VALUES (5001, 3682, 3, 'ID Visita');
INSERT INTO `lang_definitions` VALUES (5002, 3683, 3, 'Visita gripe');
INSERT INTO `lang_definitions` VALUES (5003, 3686, 3, 'número visita');
INSERT INTO `lang_definitions` VALUES (5004, 3688, 3, 'visita cuidado enfermería');
INSERT INTO `lang_definitions` VALUES (5005, 3689, 3, 'visita centro enfermería');
INSERT INTO `l