/**
 * Custom CKEditor configuration for the limited version used by plaintext editors.
 * @package openemr
 * @link      http://www.open-emr.org
 * @author    Stephen Nielson <snielson@discoverandchange.com>
 * @copyright Copyright (c) 2025 Stephen Nielson <snielson@discoverandchange.com>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 * @license   There are segments of code in this file that have been generated via Claude.ai and are licensed as Public Domain.  They have been marked with a header and footer.
 * @license   There are segments of code in this file that have been generated via ChatGPT and are licensed as Public Domain.  They have been marked with a header and footer.
 */
(function(configList) {
    if (!window.CKEDITOR) {
        console.error("Missing CKEDITOR library, cannot create custom config.");
        return;
    }
    class InsertNewLine extends CKEDITOR.Plugin {
        init() {
            let editor = this.editor;
            editor.ui.componentFactory.add( 'oeNewline', (locale) => {
                // The button will be an instance of ButtonView.
                const button = new CKEDITOR.ButtonView(locale);

                button.set( {
                    label: 'Enter Key',
                    tooltip: true,
                    // AI GENERATION START - generated by Claude.AI 2025-02-24
                    icon: "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 30 30\">\n" +
                        "  <!-- Key outline -->\n" +
                        "  <rect x=\"2\" y=\"2\" width=\"26\" height=\"26\" rx=\"3\" ry=\"3\" fill=\"#f0f0f0\" stroke=\"#333\" stroke-width=\"1.5\"/>\n" +
                        "  \n" +
                        "  <!-- Enter arrow -->\n" +
                        "  <path d=\"M22 8 L22 15 L8 15 L8 12 L5 16 L8 20 L8 17 L24 17 L24 8 Z\" fill=\"#333\" stroke=\"none\"/>\n" +
                        "</svg>",
                    // AI GENERATION END
                    withText: false
                } );

                button.on( 'execute', () => {
                    // Change the model using the model writer.
                    editor.model.change( (writer) => {
                        const softBreak = writer.createElement('softBreak');
                        editor.model.insertContent(softBreak);
                    } );
                } );


                return button;
            });
        }
    }
    class InsertParagraph extends CKEDITOR.Plugin {
        init() {
            let editor = this.editor;
            editor.ui.componentFactory.add( 'oeParagraph', (locale) => {
                // The button will be an instance of ButtonView.
                const button = new CKEDITOR.ButtonView(locale);

                button.set( {
                    label: 'Insert Paragraph',
                    tooltip: true,
                    // AI GENERATION START - generated by ChatGPT 2025-02-24
                    icon: "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 30 30\">  \n" +
                        "  <!-- Paragraph symbol (pilcrow) -->\n" +
                        "  <path d=\"M10 7 C7 7 5 9 5 12 C5 15 7 17 10 17 L14 17 L14 23 L16 23 L16 7 L19 7 L19 23 L21 23 L21 7 Z\" \n" +
                        "        fill=\"#333\" stroke=\"none\"/>\n" +
                        "  \n" +
                        "  <!-- Distinctive rounded head of the paragraph symbol -->\n" +
                        "  <path d=\"M10 7 C7 7 5 9 5 12 C5 15 7 17 10 17 L14 17\" \n" +
                        "        fill=\"none\" stroke=\"#333\" stroke-width=\"2.5\" stroke-linecap=\"round\"/>\n" +
                        "</svg>",
                    // AI GENERATION END
                    withText: false
                } );

                button.on( 'execute', () => {
                    // Change the model using the model writer.
                    editor.execute('insertParagraph', {
                        position: editor.model.document.selection.getLastPosition()
                    });
                } );


                return button;
            });
        }
    }

    class InsertQuestionMark extends CKEDITOR.Plugin {
        init() {
            let editor = this.editor;
            editor.ui.componentFactory.add( 'oeQuestionMark', (locale) => {
                // The button will be an instance of ButtonView.
                const button = new CKEDITOR.ButtonView(locale);

                button.set( {
                    label: 'Insert Question Mark',
                    tooltip: true,
                    // AI GENERATION START - generated by ChatGPT 2025-02-24
                    icon: "<svg \n" +
                        "    xmlns=\"http://www.w3.org/2000/svg\" \n" +
                        "    width=\"100\" \n" +
                        "    height=\"100\" \n" +
                        "    viewBox=\"0 0 24 24\" \n" +
                        "    fill=\"none\" \n" +
                        "    stroke=\"white\" \n" +
                        "    stroke-width=\"2\" \n" +
                        "    stroke-linecap=\"round\" \n" +
                        "    stroke-linejoin=\"round\">\n" +
                        "    <!-- Circular Border -->\n" +
                        "    <circle cx=\"12\" cy=\"12\" r=\"10\" />\n" +
                        "    <!-- Question Mark -->\n" +
                        "    <path d=\"M12 16h.01\" /> \n" +
                        "    <path d=\"M12 12c1.5 0 2-1 2-2s-1-2-2-2-2 1-2 2\" />\n" +
                        "</svg>",
                    // AI GENERATION END
                    withText: false
                } );

                button.on( 'execute', () => {
                    // Change the model using the model writer.
                    editor.model.change( (writer) => {

                        // Insert the text at the user's current position.
                        // CKEDITOR.instances.textarea1.insertText('\r\n');
                        const textNode = writer.createText('?');
                        const position = editor.model.document.selection.getFirstPosition();
                        editor.model.insertContent(textNode, position);
                    } );
                } );


                return button;
            });
        }
    }

    const {
        // Alignment,
        // Autoformat,
        // AutoImage,
        // Autosave,
        // BalloonToolbar,
        // BlockQuote,
        // Bold,
        // Emoji,
        Essentials,
        // GeneralHtmlSupport,
        // Heading,
        // HorizontalLine,
        // ImageBlock,
        // ImageCaption,
        // ImageInline,
        // ImageInsertViaUrl,
        // ImageResize,
        // ImageStyle,
        // ImageTextAlternative,
        // ImageToolbar,
        // Indent,
        // IndentBlock,
        // Italic,
        // List,
        // ListProperties,
        // MediaEmbed,
        // Mention,
        Paragraph,
        // PasteFromOffice,
        // RemoveFormat,
        SourceEditing,
        SpecialCharacters,
        SpecialCharactersArrows,
        SpecialCharactersCurrency,
        SpecialCharactersEssentials,
        SpecialCharactersLatin,
        SpecialCharactersMathematical,
        SpecialCharactersText,
        // Strikethrough,
        // Style,
        // Subscript,
        // Superscript,
        // Table,
        // TableCaption,
        // TableCellProperties,
        // TableColumnResize,
        // TableProperties,
        // TableToolbar,
        // TextTransformation,
        // Underline
    } = CKEDITOR;
    configList.defaultConfig = {
            toolbar: {
                items: [
                    'oeParagraph'
                    ,'oeNewline'
                    ,'oeQuestionMark'
                    ,'undo'
                    ,'redo'
                    ,'specialCharacters'
                ],
                shouldNotGroupWhenFull: true
            },
            plugins: [
                // Alignment,
                // Autoformat,
                // AutoImage,
                // Autosave,
                // BalloonToolbar,
                // BlockQuote,
                // Bold,
                // Emoji,
                Essentials,
                // GeneralHtmlSupport,
                // Heading,
                // HorizontalLine,
                // ImageBlock,
                // ImageCaption,
                // ImageInline,
                // ImageInsertViaUrl,
                // ImageResize,
                // ImageStyle,
                // ImageTextAlternative,
                // ImageToolbar,
                // Indent,
                // IndentBlock,
                // Italic,
                // List,
                // ListProperties,
                // MediaEmbed,
                // Mention,
                Paragraph,
                // PasteFromOffice,
                // RemoveFormat,
                SourceEditing,
                SpecialCharacters,
                SpecialCharactersArrows,
                SpecialCharactersCurrency,
                SpecialCharactersEssentials,
                SpecialCharactersLatin,
                SpecialCharactersMathematical,
                SpecialCharactersText,
                // Strikethrough,
                // Style,
                // Subscript,
                // Superscript,
                // Table,
                // TableCaption,
                // TableCellProperties,
                // TableColumnResize,
                // TableProperties,
                // TableToolbar,
                // TextTransformation,
                // Underline,
                InsertParagraph,
                InsertNewLine,
                InsertQuestionMark
            ],
            initialData: '',
            licenseKey: 'GPL'
    };
    window.oeCKEditorConfigs = configList;
})(window.oeCKEditorConfigs = window.oeCKEditorConfigs || {});
