<?php

/** @package    verysimple::HTTP */

use OpenEMR\Common\Session\SessionWrapperFactory;

/**
 * Context Persistence Storage
 *
 * The context provides an object that can be uses globally for
 * dependency injection when passing information that should be
 * available to an entire application
 *
 * @package verysimple::HTTP
 * @author VerySimple Inc.
 * @copyright 1997-2007 VerySimple, Inc. http://www.verysimple.com
 * @license http://www.gnu.org/licenses/lgpl.html LGPL
 * @version 1.0
 */
class Context
{
    public $GUID;

    /**
     * Constructor initializes the session
     */
    public function __construct()
    {
        if (session_id() == '') {
            session_start();
            error_log("DEBUG: This session_start, which is in Context.php, should never be called.");
        }
    }

    /**
     * Returns a persisted object or value
     *
     * @param
     *          var
     * @param
     *          default value (default = null)
     * @return value of var (or default)
     */
    public function Get($var, $default = null)
    {
        $session = SessionWrapperFactory::getInstance()->getWrapper();
        return $session->has($this->GUID . "_" . $var) ? unserialize($session->get($this->GUID . "_" . $var)) : null;
    }

    /**
     * Persists an object or value
     *
     * @access public
     * @param
     *          var
     * @param
     *          value
     * @return object || null
     */
    public function Set($var, $val)
    {
        $session = SessionWrapperFactory::getInstance()->getWrapper();
        $session->set($this->GUID . "_" . $var, serialize($val));
    }
}
