<?php

// Copyright (C) 2010-2011 Aron Racho <aron@mi-squred.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

namespace OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary;

use OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary\RuleCriteria;
use OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary\RuleCriteriaBuilder;
use OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary\RuleCriteriaType;
use OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary\RuleCriteriaAge;
use OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary\TimeUnit;

/**
 * Description of OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary\RuleCriteriaAgeBuilder
 *
 * @author aron
 */
class RuleCriteriaAgeBuilder extends RuleCriteriaBuilder
{
    /**
     * @return RuleCriteriaType
     */
    function resolveRuleCriteriaType($method, $methodDetail, $value)
    {
        if (strpos((string) $method, "age_max")) {
            return RuleCriteriaType::from(RuleCriteriaType::ageMax);
        }

        if (strpos((string) $method, "age_min")) {
            return RuleCriteriaType::from(RuleCriteriaType::ageMin);
        }

        return null;
    }

    /**
     * @param RuleCriteriaType $ruleCriteriaType
     * @return RuleCriteria
     */
    function build($ruleCriteriaType, $value, $methodDetail)
    {
        $method = $ruleCriteriaType->method;
        $criteria = new RuleCriteriaAge(
            $method == 'age_max' ? 'max' : 'min',
            $value,
            TimeUnit::from($methodDetail)
        );

        $criteria->value = $value;
        return $criteria;
    }

    /**
     *
     * @param RuleCriteriaType $criteriaType
     */
    function newInstance($criteriaType)
    {
        if ($criteriaType->code == RuleCriteriaType::ageMin) {
            return new RuleCriteriaAge('min');
        }

        if ($criteriaType->code == RuleCriteriaType::ageMax) {
            return new RuleCriteriaAge('max');
        }

        return null;
    }
}
