<?php

namespace OpenEMR\FHIR\R4;

/*!
 * This class was generated with the PHPFHIR library (https://github.com/dcarbone/php-fhir) using
 * class definitions from HL7 FHIR (https://www.hl7.org/fhir/)
 *
 * Class creation date: June 14th, 2019
 *
 * PHPFHIR Copyright:
 *
 * Copyright 2016-2017 Daniel Carbone (daniel.p.carbone@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

class PHPFHIRAutoloader
{
    const ROOT_DIR = __DIR__;

    /** @var array */
    private static $_classMap =  [
    \OpenEMR\FHIR\R4\PHPFHIRParserMap::class => 'OpenEMR/FHIR/R4/PHPFHIRParserMap.php',
    \OpenEMR\FHIR\R4\PHPFHIRHelper::class => 'OpenEMR/FHIR/R4/PHPFHIRHelper.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDate.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDateTime.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRString.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRInteger.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIROid::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIROid.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCanonical.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUri.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRUuid::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUuid.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUrl.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRInstant.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBoolean.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBase64Binary.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUnsignedInt.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMarkdown.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTime.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRId.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPositiveInt.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDecimal.php',
    \OpenEMR\FHIR\R4\FHIRResourceContainer::class => 'OpenEMR/FHIR/R4/FHIRResourceContainer.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExtension.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRBackboneElement::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBackboneElement.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNarrative.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrativeStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNarrativeStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement::class => 'OpenEMR/FHIR/R4/FHIRElement.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMeta.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAddress.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAddressUse::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAddressUse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAddressType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAddressType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRContributor::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContributor.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRContributorType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContributorType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAttachment.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRCount::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity/FHIRCount.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDataRequirement.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementCodeFilter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDataRequirement/FHIRDataRequirementCodeFilter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementDateFilter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDataRequirement/FHIRDataRequirementDateFilter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementSort::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDataRequirement/FHIRDataRequirementSort.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSortDirection::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSortDirection.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDosage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage\FHIRDosageDoseAndRate::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDosage/FHIRDosageDoseAndRate.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMoney.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRHumanName::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRHumanName.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRNameUse::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNameUse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContactPoint.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPointSystem::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContactPointSystem.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPointUse::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContactPointUse.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMarketingStatus::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMarketingStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIdentifier.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifierUse::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIdentifierUse.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceAmount::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceAmount.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceAmount\FHIRSubstanceAmountReferenceRange::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceAmount/FHIRSubstanceAmountReferenceRange.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCoding.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledData::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSampledData.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledDataDataType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSampledDataDataType.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPopulation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPopulation.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRatio.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDistance::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity/FHIRDistance.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity/FHIRAge.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRReference.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTriggerDefinition.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTriggerType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantityComparator::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantityComparator.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPeriod.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity/FHIRDuration.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRange.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRelatedArtifact.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifactType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRelatedArtifactType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAnnotation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRProductShelfLife::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProductShelfLife.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContactDetail.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUsageContext.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExpression.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRExpressionLanguage::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExpressionLanguage.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSignature.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTiming.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming\FHIRTimingRepeat::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTiming/FHIRTimingRepeat.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRUnitsOfTime::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUnitsOfTime.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREventTiming::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREventTiming.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRProdCharacteristic::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProdCharacteristic.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCodeableConcept.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRParameterDefinition::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRParameterDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionConstraint::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionConstraint.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionMapping::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionMapping.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionBase::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionBase.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionType::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionType.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionExample::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionExample.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionSlicing::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionSlicing.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionBinding::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionBinding.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionDiscriminator::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionDiscriminator.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRPropertyRepresentation::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPropertyRepresentation.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRConstraintSeverity::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConstraintSeverity.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAggregationMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAggregationMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRReferenceVersionRules::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRReferenceVersionRules.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSlicingRules::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSlicingRules.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRBindingStrength::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBindingStrength.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDiscriminatorType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDiscriminatorType.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDomainResource::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDomainResource.php',
    \OpenEMR\FHIR\R4\FHIRResource::class => 'OpenEMR/FHIR/R4/FHIRResource.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPublicationStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSearchParamType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSearchParamType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAdministrativeGender::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAdministrativeGender.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRVersion::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFHIRVersion.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRNoteType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNoteType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRemittanceOutcome::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRemittanceOutcome.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRConceptMapEquivalence::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConceptMapEquivalence.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentReferenceStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDocumentReferenceStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAccount::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAccount.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAccount\FHIRAccountCoverage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAccount/FHIRAccountCoverage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAccount\FHIRAccountGuarantor::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAccount/FHIRAccountGuarantor.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAccountStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAccountStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRActivityDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRActivityDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRActivityDefinition\FHIRActivityDefinitionParticipant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRActivityDefinition/FHIRActivityDefinitionParticipant.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRActivityDefinition\FHIRActivityDefinitionDynamicValue::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRActivityDefinition/FHIRActivityDefinitionDynamicValue.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRActionParticipantType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionParticipantType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestIntent::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRequestIntent.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestResourceType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRequestResourceType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestPriority::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRequestPriority.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAdverseEvent::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAdverseEvent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAdverseEvent\FHIRAdverseEventSuspectEntity::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAdverseEvent/FHIRAdverseEventSuspectEntity.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAdverseEvent\FHIRAdverseEventCausality::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAdverseEvent/FHIRAdverseEventCausality.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAdverseEventActuality::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAdverseEventActuality.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAllergyIntolerance::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAllergyIntolerance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAllergyIntolerance\FHIRAllergyIntoleranceReaction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAllergyIntolerance/FHIRAllergyIntoleranceReaction.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceCriticality::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAllergyIntoleranceCriticality.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAllergyIntoleranceType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceCategory::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAllergyIntoleranceCategory.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceSeverity::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAllergyIntoleranceSeverity.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAppointment::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAppointment.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAppointment\FHIRAppointmentParticipant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAppointment/FHIRAppointmentParticipant.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRParticipantRequired::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRParticipantRequired.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAppointmentStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAppointmentStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRParticipationStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRParticipationStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAppointmentResponse::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAppointmentResponse.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAuditEvent::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAuditEvent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventAgent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventAgent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventNetwork::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventNetwork.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventSource::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventSource.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventEntity::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventEntity.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventDetail.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventOutcome::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAuditEventOutcome.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventAction::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAuditEventAction.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventAgentNetworkType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAuditEventAgentNetworkType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBasic::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRBasic.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBinary::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBinary.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBiologicallyDerivedProduct::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRBiologicallyDerivedProduct.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductCollection::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBiologicallyDerivedProduct/FHIRBiologicallyDerivedProductCollection.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductProcessing::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBiologicallyDerivedProduct/FHIRBiologicallyDerivedProductProcessing.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductManipulation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBiologicallyDerivedProduct/FHIRBiologicallyDerivedProductManipulation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductStorage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBiologicallyDerivedProduct/FHIRBiologicallyDerivedProductStorage.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductCategory::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBiologicallyDerivedProductCategory.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBiologicallyDerivedProductStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductStorageScale::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBiologicallyDerivedProductStorageScale.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBodyStructure::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRBodyStructure.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleLink::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleLink.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleEntry::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleEntry.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleSearch::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleSearch.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleRequest::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleRequest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleResponse::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleResponse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRHTTPVerb::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRHTTPVerb.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRBundleType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBundleType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSearchEntryMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSearchEntryMode.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCapabilityStatement::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCapabilityStatement.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSoftware::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSoftware.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementImplementation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementImplementation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementRest::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementRest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSecurity::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSecurity.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementResource::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementResource.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementInteraction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementInteraction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSearchParam::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSearchParam.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementOperation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementOperation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementInteraction1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementInteraction1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementMessaging::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementMessaging.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementEndpoint::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementEndpoint.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSupportedMessage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSupportedMessage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementDocument::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementDocument.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCapabilityStatementKind::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCapabilityStatementKind.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREventCapabilityMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREventCapabilityMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRResourceVersionPolicy::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResourceVersionPolicy.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDocumentMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRestfulCapabilityMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRestfulCapabilityMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTypeRestfulInteraction::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTypeRestfulInteraction.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSystemRestfulInteraction::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSystemRestfulInteraction.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRConditionalReadStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConditionalReadStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRReferenceHandlingPolicy::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRReferenceHandlingPolicy.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRConditionalDeleteStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConditionalDeleteStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCarePlan::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCarePlan.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCarePlan\FHIRCarePlanActivity::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCarePlan/FHIRCarePlanActivity.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCarePlan\FHIRCarePlanDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCarePlan/FHIRCarePlanDetail.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanActivityKind::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCarePlanActivityKind.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanActivityStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCarePlanActivityStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanIntent::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCarePlanIntent.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRequestStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCareTeam::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCareTeam.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCareTeam\FHIRCareTeamParticipant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCareTeam/FHIRCareTeamParticipant.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCareTeamStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCareTeamStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCatalogEntry::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCatalogEntry.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCatalogEntry\FHIRCatalogEntryRelatedEntry::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCatalogEntry/FHIRCatalogEntryRelatedEntry.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCatalogEntryRelationType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCatalogEntryRelationType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRChargeItem::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRChargeItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItem\FHIRChargeItemPerformer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRChargeItem/FHIRChargeItemPerformer.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRChargeItemStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRChargeItemStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRChargeItemDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRChargeItemDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionApplicability::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRChargeItemDefinition/FHIRChargeItemDefinitionApplicability.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionPropertyGroup::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRChargeItemDefinition/FHIRChargeItemDefinitionPropertyGroup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionPriceComponent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRChargeItemDefinition/FHIRChargeItemDefinitionPriceComponent.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRInvoicePriceComponentType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRInvoicePriceComponentType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClaim::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRClaim.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimRelated::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimRelated.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimPayee::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimPayee.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimCareTeam::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimCareTeam.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimSupportingInfo::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimSupportingInfo.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimDiagnosis::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimDiagnosis.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimProcedure::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimProcedure.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimInsurance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimInsurance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimAccident::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimAccident.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimDetail.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimSubDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimSubDetail.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRUse::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFinancialResourceStatusCodes.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClaimResponse::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRClaimResponse.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseAdjudication.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseDetail.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseSubDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseSubDetail.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAddItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseAddItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseDetail1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseDetail1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseSubDetail1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseSubDetail1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseTotal::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseTotal.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponsePayment::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponsePayment.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseProcessNote::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseProcessNote.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseInsurance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseInsurance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseError::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseError.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRClaimProcessingCodes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRClaimProcessingCodes.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClinicalImpression::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRClinicalImpression.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClinicalImpression\FHIRClinicalImpressionInvestigation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClinicalImpression/FHIRClinicalImpressionInvestigation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRClinicalImpression\FHIRClinicalImpressionFinding::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClinicalImpression/FHIRClinicalImpressionFinding.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRClinicalImpressionStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRClinicalImpressionStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCodeSystem::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCodeSystem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemFilter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemFilter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemProperty::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemProperty.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemConcept::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemConcept.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemDesignation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemDesignation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemProperty1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemProperty1.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRFilterOperator::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFilterOperator.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRPropertyType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPropertyType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeSystemHierarchyMeaning::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCodeSystemHierarchyMeaning.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeSystemContentMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCodeSystemContentMode.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCommunication::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCommunication.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCommunication\FHIRCommunicationPayload::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCommunication/FHIRCommunicationPayload.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREventStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREventStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCommunicationRequest::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCommunicationRequest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCommunicationRequest\FHIRCommunicationRequestPayload::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCommunicationRequest/FHIRCommunicationRequestPayload.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCompartmentDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCompartmentDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCompartmentDefinition\FHIRCompartmentDefinitionResource::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCompartmentDefinition/FHIRCompartmentDefinitionResource.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCompartmentType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCompartmentType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRComposition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRComposition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionAttester::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRComposition/FHIRCompositionAttester.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionRelatesTo::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRComposition/FHIRCompositionRelatesTo.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionEvent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRComposition/FHIRCompositionEvent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionSection::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRComposition/FHIRCompositionSection.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRVConfidentialityClassification::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRVConfidentialityClassification.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCompositionStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCompositionStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentRelationshipType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDocumentRelationshipType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCompositionAttestationMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCompositionAttestationMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRListMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRListMode.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRConceptMap::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRConceptMap.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapGroup::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapGroup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapElement::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapElement.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapTarget::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapTarget.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapDependsOn::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapDependsOn.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapUnmapped::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapUnmapped.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRConceptMapGroupUnmappedMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConceptMapGroupUnmappedMode.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCondition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCondition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCondition\FHIRConditionStage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCondition/FHIRConditionStage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCondition\FHIRConditionEvidence::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCondition/FHIRConditionEvidence.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRConsent::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRConsent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentPolicy::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentPolicy.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentVerification::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentVerification.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentProvision::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentProvision.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentActor::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentActor.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentData::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentData.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentProvisionType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConsentProvisionType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentDataMeaning::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConsentDataMeaning.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentState::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConsentState.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRContract::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRContract.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractContentDefinition::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractContentDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractTerm::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractTerm.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSecurityLabel::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractSecurityLabel.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractOffer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractOffer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractParty::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractParty.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAnswer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractAnswer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAsset::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractAsset.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractContext::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractContext.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractValuedItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractValuedItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractAction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSubject::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractSubject.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSigner::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractSigner.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractFriendly::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractFriendly.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractLegal::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractLegal.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractRule::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractRule.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRContractResourceStatusCodes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContractResourceStatusCodes.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRContractResourcePublicationStatusCodes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContractResourcePublicationStatusCodes.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverage::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCoverage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageClass::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverage/FHIRCoverageClass.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageCostToBeneficiary::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverage/FHIRCoverageCostToBeneficiary.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageException::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverage/FHIRCoverageException.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverageEligibilityRequest::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCoverageEligibilityRequest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestSupportingInfo::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityRequest/FHIRCoverageEligibilityRequestSupportingInfo.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestInsurance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityRequest/FHIRCoverageEligibilityRequestInsurance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityRequest/FHIRCoverageEligibilityRequestItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestDiagnosis::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityRequest/FHIRCoverageEligibilityRequestDiagnosis.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREligibilityRequestPurpose::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREligibilityRequestPurpose.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverageEligibilityResponse::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCoverageEligibilityResponse.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseInsurance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityResponse/FHIRCoverageEligibilityResponseInsurance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityResponse/FHIRCoverageEligibilityResponseItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseBenefit::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityResponse/FHIRCoverageEligibilityResponseBenefit.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseError::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityResponse/FHIRCoverageEligibilityResponseError.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREligibilityResponsePurpose::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREligibilityResponsePurpose.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDetectedIssue::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDetectedIssue.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDetectedIssue\FHIRDetectedIssueEvidence::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDetectedIssue/FHIRDetectedIssueEvidence.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDetectedIssue\FHIRDetectedIssueMitigation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDetectedIssue/FHIRDetectedIssueMitigation.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRObservationStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRObservationStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDetectedIssueSeverity::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDetectedIssueSeverity.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDevice::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDevice.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceUdiCarrier::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceUdiCarrier.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceDeviceName::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceDeviceName.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceSpecialization::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceSpecialization.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceVersion::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceVersion.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceProperty::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceProperty.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRDeviceStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFHIRDeviceStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceNameType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceNameType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRUDIEntryType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUDIEntryType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDeviceDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionUdiDeviceIdentifier::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionUdiDeviceIdentifier.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionDeviceName::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionDeviceName.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionSpecialization::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionSpecialization.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionCapability::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionCapability.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionProperty::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionProperty.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionMaterial::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionMaterial.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceMetric::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDeviceMetric.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceMetric\FHIRDeviceMetricCalibration::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceMetric/FHIRDeviceMetricCalibration.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCalibrationType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricCalibrationType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricColor::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricColor.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCalibrationState::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricCalibrationState.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricOperationalStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricOperationalStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCategory::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricCategory.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceRequest::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDeviceRequest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceRequest\FHIRDeviceRequestParameter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceRequest/FHIRDeviceRequestParameter.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceUseStatement::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDeviceUseStatement.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceUseStatementStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceUseStatementStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDiagnosticReport::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDiagnosticReport.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDiagnosticReport\FHIRDiagnosticReportMedia::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDiagnosticReport/FHIRDiagnosticReportMedia.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDiagnosticReportStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDiagnosticReportStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDocumentManifest::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDocumentManifest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentManifest\FHIRDocumentManifestRelated::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDocumentManifest/FHIRDocumentManifestRelated.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDocumentReference::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDocumentReference.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceRelatesTo::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceRelatesTo.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceContent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceContent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceContext::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceContext.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREffectEvidenceSynthesis::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREffectEvidenceSynthesis.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisSampleSize::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisSampleSize.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisResultsByExposure::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisResultsByExposure.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisEffectEstimate::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisEffectEstimate.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisPrecisionEstimate::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisPrecisionEstimate.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisCertainty::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisCertainty.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisCertaintySubcomponent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisCertaintySubcomponent.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRExposureState::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExposureState.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREncounter::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREncounter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterStatusHistory::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterStatusHistory.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterClassHistory::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterClassHistory.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterParticipant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterParticipant.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterDiagnosis::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterDiagnosis.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterHospitalization::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterHospitalization.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterLocation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterLocation.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREncounterLocationStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREncounterLocationStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREncounterStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREncounterStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREndpoint::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREndpoint.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREndpointStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREndpointStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREnrollmentRequest::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREnrollmentRequest.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREnrollmentResponse::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREnrollmentResponse.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREpisodeOfCare::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREpisodeOfCare.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREpisodeOfCare\FHIREpisodeOfCareStatusHistory::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREpisodeOfCare/FHIREpisodeOfCareStatusHistory.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREpisodeOfCare\FHIREpisodeOfCareDiagnosis::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREpisodeOfCare/FHIREpisodeOfCareDiagnosis.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREpisodeOfCareStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREpisodeOfCareStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREventDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREventDefinition.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREvidence::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREvidence.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREvidenceVariable::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREvidenceVariable.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIREvidenceVariable\FHIREvidenceVariableCharacteristic::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIREvidenceVariable/FHIREvidenceVariableCharacteristic.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREvidenceVariableType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREvidenceVariableType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRGroupMeasure::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGroupMeasure.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRExampleScenario::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRExampleScenario.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioActor::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioActor.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioInstance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioInstance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioVersion::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioVersion.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioContainedInstance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioContainedInstance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioProcess::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioProcess.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioStep::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioStep.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioOperation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioOperation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioAlternative::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioAlternative.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRExampleScenarioActorType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExampleScenarioActorType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRResourceType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResourceType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRExplanationOfBenefit::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRExplanationOfBenefit.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitRelated::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitRelated.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitPayee::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitPayee.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitCareTeam::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitCareTeam.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSupportingInfo::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitSupportingInfo.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDiagnosis::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDiagnosis.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitProcedure::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitProcedure.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitInsurance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitInsurance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAccident::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAccident.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAdjudication.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDetail.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSubDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitSubDetail.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAddItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAddItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDetail1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDetail1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSubDetail1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitSubDetail1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitTotal::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitTotal.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitPayment::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitPayment.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitProcessNote::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitProcessNote.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitBenefitBalance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitBenefitBalance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitFinancial::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitFinancial.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRExplanationOfBenefitStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExplanationOfBenefitStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRFamilyMemberHistory::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRFamilyMemberHistory.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRFamilyMemberHistory\FHIRFamilyMemberHistoryCondition::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRFamilyMemberHistory/FHIRFamilyMemberHistoryCondition.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRFamilyHistoryStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFamilyHistoryStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRFlag::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRFlag.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRFlagStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFlagStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGoal::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRGoal.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRGoal\FHIRGoalTarget::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGoal/FHIRGoalTarget.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRGoalLifecycleStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGoalLifecycleStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGraphDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRGraphDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionLink::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionLink.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionTarget::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionTarget.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionCompartment::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionCompartment.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRGraphCompartmentUse::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGraphCompartmentUse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRGraphCompartmentRule::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGraphCompartmentRule.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGroup::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRGroup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRGroup\FHIRGroupCharacteristic::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGroup/FHIRGroupCharacteristic.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRGroup\FHIRGroupMember::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGroup/FHIRGroupMember.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRGroupType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGroupType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGuidanceResponse::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRGuidanceResponse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRGuidanceResponseStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGuidanceResponseStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRHealthcareService::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRHealthcareService.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceEligibility::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRHealthcareService/FHIRHealthcareServiceEligibility.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceAvailableTime::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRHealthcareService/FHIRHealthcareServiceAvailableTime.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceNotAvailable::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRHealthcareService/FHIRHealthcareServiceNotAvailable.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRDaysOfWeek::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDaysOfWeek.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImagingStudy::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImagingStudy.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudySeries::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImagingStudy/FHIRImagingStudySeries.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudyPerformer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImagingStudy/FHIRImagingStudyPerformer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudyInstance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImagingStudy/FHIRImagingStudyInstance.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRImagingStudyStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRImagingStudyStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunization::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImmunization.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationPerformer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunization/FHIRImmunizationPerformer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationEducation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunization/FHIRImmunizationEducation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationReaction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunization/FHIRImmunizationReaction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationProtocolApplied::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunization/FHIRImmunizationProtocolApplied.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRImmunizationStatusCodes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRImmunizationStatusCodes.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunizationEvaluation::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImmunizationEvaluation.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRImmunizationEvaluationStatusCodes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRImmunizationEvaluationStatusCodes.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunizationRecommendation::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImmunizationRecommendation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunizationRecommendation\FHIRImmunizationRecommendationRecommendation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunizationRecommendation/FHIRImmunizationRecommendationRecommendation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunizationRecommendation\FHIRImmunizationRecommendationDateCriterion::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunizationRecommendation/FHIRImmunizationRecommendationDateCriterion.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImplementationGuide::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImplementationGuide.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideDependsOn::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideDependsOn.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideGlobal::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideGlobal.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideDefinition::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideGrouping::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideGrouping.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideResource::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideResource.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuidePage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuidePage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideParameter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideParameter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideTemplate::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideTemplate.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideManifest::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideManifest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideResource1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideResource1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuidePage1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuidePage1.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRGuideParameterCode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGuideParameterCode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSPDXLicense::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSPDXLicense.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRGuidePageGeneration::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGuidePageGeneration.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRInsurancePlan::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRInsurancePlan.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanContact::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanContact.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanCoverage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanCoverage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanBenefit::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanBenefit.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanLimit::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanLimit.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanPlan::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanPlan.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanGeneralCost::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanGeneralCost.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanSpecificCost::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanSpecificCost.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanBenefit1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanBenefit1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanCost::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanCost.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRInvoice::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRInvoice.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoiceParticipant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInvoice/FHIRInvoiceParticipant.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoiceLineItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInvoice/FHIRInvoiceLineItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoicePriceComponent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInvoice/FHIRInvoicePriceComponent.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRInvoiceStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRInvoiceStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLibrary::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRLibrary.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLinkage::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRLinkage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRLinkage\FHIRLinkageItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRLinkage/FHIRLinkageItem.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRLinkageType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRLinkageType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRList::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRList.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRList\FHIRListEntry::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRList/FHIRListEntry.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRListStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRListStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLocation::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRLocation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRLocation\FHIRLocationPosition::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRLocation/FHIRLocationPosition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRLocation\FHIRLocationHoursOfOperation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRLocation/FHIRLocationHoursOfOperation.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRLocationMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRLocationMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRLocationStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRLocationStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMeasure::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMeasure.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasure\FHIRMeasureGroup::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasureGroup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasure\FHIRMeasurePopulation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasurePopulation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasure\FHIRMeasureStratifier::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasureStratifier.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasure\FHIRMeasureComponent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasureComponent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasure\FHIRMeasureSupplementalData::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasureSupplementalData.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMeasureReport::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMeasureReport.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasureReport\FHIRMeasureReportGroup::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportGroup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasureReport\FHIRMeasureReportPopulation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportPopulation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasureReport\FHIRMeasureReportStratifier::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportStratifier.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasureReport\FHIRMeasureReportStratum::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportStratum.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasureReport\FHIRMeasureReportComponent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportComponent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMeasureReport\FHIRMeasureReportPopulation1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportPopulation1.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMeasureReportStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMeasureReportStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMeasureReportType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMeasureReportType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedia::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedia.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedication::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedication.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedication\FHIRMedicationIngredient::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedication/FHIRMedicationIngredient.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedication\FHIRMedicationBatch::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedication/FHIRMedicationBatch.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMedicationStatusCodes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMedicationStatusCodes.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationAdministration::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationAdministration.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationAdministration\FHIRMedicationAdministrationPerformer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationAdministration/FHIRMedicationAdministrationPerformer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationAdministration\FHIRMedicationAdministrationDosage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationAdministration/FHIRMedicationAdministrationDosage.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationDispense::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationDispense.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationDispense\FHIRMedicationDispensePerformer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationDispense/FHIRMedicationDispensePerformer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationDispense\FHIRMedicationDispenseSubstitution::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationDispense/FHIRMedicationDispenseSubstitution.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationKnowledge::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationKnowledge.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeRelatedMedicationKnowledge::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeRelatedMedicationKnowledge.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeMonograph::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeMonograph.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeIngredient::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeIngredient.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeCost::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeCost.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeMonitoringProgram::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeMonitoringProgram.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeAdministrationGuidelines::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeAdministrationGuidelines.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeDosage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeDosage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgePatientCharacteristics::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgePatientCharacteristics.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeMedicineClassification::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeMedicineClassification.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgePackaging::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgePackaging.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeDrugCharacteristic::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeDrugCharacteristic.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeRegulatory::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeRegulatory.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeSubstitution::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeSubstitution.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeSchedule::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeSchedule.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeMaxDispense::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeMaxDispense.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationKnowledge\FHIRMedicationKnowledgeKinetics::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeKinetics.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationRequest::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationRequest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationRequest\FHIRMedicationRequestDispenseRequest::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestDispenseRequest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationRequest\FHIRMedicationRequestInitialFill::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestInitialFill.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicationRequest\FHIRMedicationRequestSubstitution::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestSubstitution.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMedicationrequestStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMedicationrequestStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMedicationRequestIntent::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMedicationRequestIntent.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationStatement::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationStatement.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProduct::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProduct.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProduct\FHIRMedicinalProductName::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductName.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProduct\FHIRMedicinalProductNamePart::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductNamePart.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProduct\FHIRMedicinalProductCountryLanguage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductCountryLanguage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProduct\FHIRMedicinalProductManufacturingBusinessOperation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductManufacturingBusinessOperation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProduct\FHIRMedicinalProductSpecialDesignation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductSpecialDesignation.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductAuthorization::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductAuthorization.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductAuthorization\FHIRMedicinalProductAuthorizationJurisdictionalAuthorization::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductAuthorization/FHIRMedicinalProductAuthorizationJurisdictionalAuthorization.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductAuthorization\FHIRMedicinalProductAuthorizationProcedure::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductAuthorization/FHIRMedicinalProductAuthorizationProcedure.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductContraindication::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductContraindication.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductContraindication\FHIRMedicinalProductContraindicationOtherTherapy::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductContraindication/FHIRMedicinalProductContraindicationOtherTherapy.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductIndication::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductIndication.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductIndication\FHIRMedicinalProductIndicationOtherTherapy::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIndication/FHIRMedicinalProductIndicationOtherTherapy.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductIngredient::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductIngredient.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductIngredient\FHIRMedicinalProductIngredientSpecifiedSubstance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIngredient/FHIRMedicinalProductIngredientSpecifiedSubstance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductIngredient\FHIRMedicinalProductIngredientStrength::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIngredient/FHIRMedicinalProductIngredientStrength.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductIngredient\FHIRMedicinalProductIngredientReferenceStrength::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIngredient/FHIRMedicinalProductIngredientReferenceStrength.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductIngredient\FHIRMedicinalProductIngredientSubstance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIngredient/FHIRMedicinalProductIngredientSubstance.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductInteraction::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductInteraction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductInteraction\FHIRMedicinalProductInteractionInteractant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductInteraction/FHIRMedicinalProductInteractionInteractant.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductManufactured::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductManufactured.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductPackaged::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductPackaged.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductPackaged\FHIRMedicinalProductPackagedBatchIdentifier::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPackaged/FHIRMedicinalProductPackagedBatchIdentifier.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductPackaged\FHIRMedicinalProductPackagedPackageItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPackaged/FHIRMedicinalProductPackagedPackageItem.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductPharmaceutical::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductPharmaceutical.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductPharmaceutical\FHIRMedicinalProductPharmaceuticalCharacteristics::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPharmaceutical/FHIRMedicinalProductPharmaceuticalCharacteristics.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductPharmaceutical\FHIRMedicinalProductPharmaceuticalRouteOfAdministration::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPharmaceutical/FHIRMedicinalProductPharmaceuticalRouteOfAdministration.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductPharmaceutical\FHIRMedicinalProductPharmaceuticalTargetSpecies::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPharmaceutical/FHIRMedicinalProductPharmaceuticalTargetSpecies.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMedicinalProductPharmaceutical\FHIRMedicinalProductPharmaceuticalWithdrawalPeriod::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPharmaceutical/FHIRMedicinalProductPharmaceuticalWithdrawalPeriod.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductUndesirableEffect::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductUndesirableEffect.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMessageDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMessageDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMessageDefinition\FHIRMessageDefinitionFocus::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageDefinition/FHIRMessageDefinitionFocus.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMessageDefinition\FHIRMessageDefinitionAllowedResponse::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageDefinition/FHIRMessageDefinitionAllowedResponse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMessageSignificanceCategory::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMessageSignificanceCategory.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRMessageheaderResponseRequest::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMessageheaderResponseRequest.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMessageHeader::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMessageHeader.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMessageHeader\FHIRMessageHeaderDestination::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderDestination.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMessageHeader\FHIRMessageHeaderSource::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderSource.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMessageHeader\FHIRMessageHeaderResponse::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderResponse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRResponseType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResponseType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMolecularSequence::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMolecularSequence.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMolecularSequence\FHIRMolecularSequenceReferenceSeq::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceReferenceSeq.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMolecularSequence\FHIRMolecularSequenceVariant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceVariant.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMolecularSequence\FHIRMolecularSequenceQuality::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceQuality.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMolecularSequence\FHIRMolecularSequenceRoc::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceRoc.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMolecularSequence\FHIRMolecularSequenceRepository::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceRepository.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMolecularSequence\FHIRMolecularSequenceStructureVariant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceStructureVariant.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMolecularSequence\FHIRMolecularSequenceOuter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceOuter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRMolecularSequence\FHIRMolecularSequenceInner::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceInner.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStrandType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStrandType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIROrientationType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIROrientationType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRRepositoryType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRepositoryType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQualityType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQualityType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSequenceType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSequenceType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRNamingSystem::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRNamingSystem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRNamingSystem\FHIRNamingSystemUniqueId::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNamingSystem/FHIRNamingSystemUniqueId.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRNamingSystemIdentifierType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNamingSystemIdentifierType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRNamingSystemType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNamingSystemType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRNutritionOrder::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRNutritionOrder.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRNutritionOrder\FHIRNutritionOrderOralDiet::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderOralDiet.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRNutritionOrder\FHIRNutritionOrderNutrient::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderNutrient.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRNutritionOrder\FHIRNutritionOrderTexture::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderTexture.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRNutritionOrder\FHIRNutritionOrderSupplement::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderSupplement.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRNutritionOrder\FHIRNutritionOrderEnteralFormula::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderEnteralFormula.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRNutritionOrder\FHIRNutritionOrderAdministration::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderAdministration.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRObservation::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRObservation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRObservation\FHIRObservationReferenceRange::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRObservation/FHIRObservationReferenceRange.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRObservation\FHIRObservationComponent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRObservation/FHIRObservationComponent.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRObservationDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRObservationDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRObservationDefinition\FHIRObservationDefinitionQuantitativeDetails::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRObservationDefinition/FHIRObservationDefinitionQuantitativeDetails.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRObservationDefinition\FHIRObservationDefinitionQualifiedInterval::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRObservationDefinition/FHIRObservationDefinitionQualifiedInterval.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRObservationDataType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRObservationDataType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRObservationRangeCategory::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRObservationRangeCategory.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIROperationDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIROperationDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIROperationDefinition\FHIROperationDefinitionParameter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionParameter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIROperationDefinition\FHIROperationDefinitionBinding::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionBinding.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIROperationDefinition\FHIROperationDefinitionReferencedFrom::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionReferencedFrom.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIROperationDefinition\FHIROperationDefinitionOverload::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionOverload.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIROperationParameterUse::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIROperationParameterUse.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIROperationKind::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIROperationKind.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIROperationOutcome::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIROperationOutcome.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIROperationOutcome\FHIROperationOutcomeIssue::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationOutcome/FHIROperationOutcomeIssue.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRIssueType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIssueType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRIssueSeverity::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIssueSeverity.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIROrganization::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIROrganization.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIROrganization\FHIROrganizationContact::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIROrganization/FHIROrganizationContact.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIROrganizationAffiliation::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIROrganizationAffiliation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRParameters::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRParameters.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRParameters\FHIRParametersParameter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRParameters/FHIRParametersParameter.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPatient::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPatient.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPatient\FHIRPatientContact::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPatient/FHIRPatientContact.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPatient\FHIRPatientCommunication::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPatient/FHIRPatientCommunication.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPatient\FHIRPatientLink::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPatient/FHIRPatientLink.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRLinkType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRLinkType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPaymentNotice::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPaymentNotice.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPaymentReconciliation::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPaymentReconciliation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPaymentReconciliation\FHIRPaymentReconciliationDetail::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPaymentReconciliation/FHIRPaymentReconciliationDetail.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPaymentReconciliation\FHIRPaymentReconciliationProcessNote::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPaymentReconciliation/FHIRPaymentReconciliationProcessNote.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPerson::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPerson.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPerson\FHIRPersonLink::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPerson/FHIRPersonLink.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentityAssuranceLevel::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIdentityAssuranceLevel.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPlanDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPlanDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPlanDefinition\FHIRPlanDefinitionGoal::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionGoal.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPlanDefinition\FHIRPlanDefinitionTarget::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionTarget.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPlanDefinition\FHIRPlanDefinitionAction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionAction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPlanDefinition\FHIRPlanDefinitionCondition::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionCondition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPlanDefinition\FHIRPlanDefinitionRelatedAction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionRelatedAction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPlanDefinition\FHIRPlanDefinitionParticipant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionParticipant.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPlanDefinition\FHIRPlanDefinitionDynamicValue::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionDynamicValue.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRActionRequiredBehavior::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionRequiredBehavior.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRActionRelationshipType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionRelationshipType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRActionGroupingBehavior::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionGroupingBehavior.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRActionSelectionBehavior::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionSelectionBehavior.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRActionCardinalityBehavior::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionCardinalityBehavior.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRActionPrecheckBehavior::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionPrecheckBehavior.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRActionConditionKind::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionConditionKind.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPractitioner::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPractitioner.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPractitioner\FHIRPractitionerQualification::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPractitioner/FHIRPractitionerQualification.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPractitionerRole::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPractitionerRole.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPractitionerRole\FHIRPractitionerRoleAvailableTime::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPractitionerRole/FHIRPractitionerRoleAvailableTime.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRPractitionerRole\FHIRPractitionerRoleNotAvailable::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPractitionerRole/FHIRPractitionerRoleNotAvailable.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRProcedure::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRProcedure.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRProcedure\FHIRProcedurePerformer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProcedure/FHIRProcedurePerformer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRProcedure\FHIRProcedureFocalDevice::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProcedure/FHIRProcedureFocalDevice.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRProvenance::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRProvenance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRProvenance\FHIRProvenanceAgent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProvenance/FHIRProvenanceAgent.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRProvenance\FHIRProvenanceEntity::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProvenance/FHIRProvenanceEntity.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRProvenanceEntityRole::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRProvenanceEntityRole.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRQuestionnaire::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRQuestionnaire.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRQuestionnaire\FHIRQuestionnaireItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRQuestionnaire\FHIRQuestionnaireEnableWhen::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireEnableWhen.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRQuestionnaire\FHIRQuestionnaireAnswerOption::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireAnswerOption.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRQuestionnaire\FHIRQuestionnaireInitial::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireInitial.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuestionnaireItemType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuestionnaireItemType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIREnableWhenBehavior::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIREnableWhenBehavior.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuestionnaireItemOperator::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuestionnaireItemOperator.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRQuestionnaireResponse::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRQuestionnaireResponse.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRQuestionnaireResponse\FHIRQuestionnaireResponseItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaireResponse/FHIRQuestionnaireResponseItem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRQuestionnaireResponse\FHIRQuestionnaireResponseAnswer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaireResponse/FHIRQuestionnaireResponseAnswer.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRQuestionnaireResponseStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuestionnaireResponseStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRRelatedPerson::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRRelatedPerson.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRelatedPerson\FHIRRelatedPersonCommunication::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRelatedPerson/FHIRRelatedPersonCommunication.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRRequestGroup::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRRequestGroup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRequestGroup\FHIRRequestGroupAction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRequestGroup/FHIRRequestGroupAction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRequestGroup\FHIRRequestGroupCondition::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRequestGroup/FHIRRequestGroupCondition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRequestGroup\FHIRRequestGroupRelatedAction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRequestGroup/FHIRRequestGroupRelatedAction.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRResearchDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRResearchDefinition.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRResearchElementDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRResearchElementDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRResearchElementDefinition\FHIRResearchElementDefinitionCharacteristic::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRResearchElementDefinition/FHIRResearchElementDefinitionCharacteristic.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRResearchElementType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResearchElementType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRVariableType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRVariableType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRResearchStudy::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRResearchStudy.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRResearchStudy\FHIRResearchStudyArm::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRResearchStudy/FHIRResearchStudyArm.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRResearchStudy\FHIRResearchStudyObjective::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRResearchStudy/FHIRResearchStudyObjective.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRResearchStudyStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResearchStudyStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRResearchSubject::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRResearchSubject.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRResearchSubjectStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResearchSubjectStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRRiskAssessment::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRRiskAssessment.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRiskAssessment\FHIRRiskAssessmentPrediction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskAssessment/FHIRRiskAssessmentPrediction.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRRiskEvidenceSynthesis::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRRiskEvidenceSynthesis.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRiskEvidenceSynthesis\FHIRRiskEvidenceSynthesisSampleSize::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisSampleSize.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRiskEvidenceSynthesis\FHIRRiskEvidenceSynthesisRiskEstimate::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisRiskEstimate.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRiskEvidenceSynthesis\FHIRRiskEvidenceSynthesisPrecisionEstimate::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisPrecisionEstimate.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRiskEvidenceSynthesis\FHIRRiskEvidenceSynthesisCertainty::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisCertainty.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRRiskEvidenceSynthesis\FHIRRiskEvidenceSynthesisCertaintySubcomponent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisCertaintySubcomponent.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSchedule::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSchedule.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSearchParameter::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSearchParameter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSearchParameter\FHIRSearchParameterComponent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSearchParameter/FHIRSearchParameterComponent.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRXPathUsageType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRXPathUsageType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSearchModifierCode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSearchModifierCode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSearchComparator::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSearchComparator.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRServiceRequest::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRServiceRequest.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSlot::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSlot.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSlotStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSlotStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSpecimen::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSpecimen.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSpecimen\FHIRSpecimenCollection::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimen/FHIRSpecimenCollection.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSpecimen\FHIRSpecimenProcessing::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimen/FHIRSpecimenProcessing.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSpecimen\FHIRSpecimenContainer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimen/FHIRSpecimenContainer.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSpecimenStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSpecimenStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSpecimenDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSpecimenDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSpecimenDefinition\FHIRSpecimenDefinitionTypeTested::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimenDefinition/FHIRSpecimenDefinitionTypeTested.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSpecimenDefinition\FHIRSpecimenDefinitionContainer::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimenDefinition/FHIRSpecimenDefinitionContainer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSpecimenDefinition\FHIRSpecimenDefinitionAdditive::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimenDefinition/FHIRSpecimenDefinitionAdditive.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSpecimenDefinition\FHIRSpecimenDefinitionHandling::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimenDefinition/FHIRSpecimenDefinitionHandling.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSpecimenContainedPreference::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSpecimenContainedPreference.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRStructureDefinition::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRStructureDefinition.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureDefinition\FHIRStructureDefinitionMapping::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionMapping.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureDefinition\FHIRStructureDefinitionContext::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionContext.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureDefinition\FHIRStructureDefinitionSnapshot::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionSnapshot.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureDefinition\FHIRStructureDefinitionDifferential::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionDifferential.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStructureDefinitionKind::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureDefinitionKind.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTypeDerivationRule::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTypeDerivationRule.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRExtensionContextType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExtensionContextType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRStructureMap::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRStructureMap.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureMap\FHIRStructureMapStructure::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapStructure.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureMap\FHIRStructureMapGroup::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapGroup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureMap\FHIRStructureMapInput::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapInput.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureMap\FHIRStructureMapRule::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapRule.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureMap\FHIRStructureMapSource::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapSource.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureMap\FHIRStructureMapTarget::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapTarget.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureMap\FHIRStructureMapParameter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapParameter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRStructureMap\FHIRStructureMapDependent::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapDependent.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStructureMapInputMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapInputMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStructureMapContextType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapContextType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStructureMapTargetListMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapTargetListMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStructureMapTransform::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapTransform.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStructureMapSourceListMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapSourceListMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStructureMapGroupTypeMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapGroupTypeMode.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStructureMapModelMode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapModelMode.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubscription::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubscription.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubscription\FHIRSubscriptionChannel::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubscription/FHIRSubscriptionChannel.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSubscriptionStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSubscriptionStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSubscriptionChannelType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSubscriptionChannelType.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstance::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstance\FHIRSubstanceInstance::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstance/FHIRSubstanceInstance.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstance\FHIRSubstanceIngredient::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstance/FHIRSubstanceIngredient.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRSubstanceStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFHIRSubstanceStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceNucleicAcid::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceNucleicAcid.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceNucleicAcid\FHIRSubstanceNucleicAcidSubunit::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceNucleicAcid/FHIRSubstanceNucleicAcidSubunit.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceNucleicAcid\FHIRSubstanceNucleicAcidLinkage::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceNucleicAcid/FHIRSubstanceNucleicAcidLinkage.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceNucleicAcid\FHIRSubstanceNucleicAcidSugar::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceNucleicAcid/FHIRSubstanceNucleicAcidSugar.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstancePolymer::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstancePolymer.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstancePolymer\FHIRSubstancePolymerMonomerSet::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerMonomerSet.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstancePolymer\FHIRSubstancePolymerStartingMaterial::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerStartingMaterial.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstancePolymer\FHIRSubstancePolymerRepeat::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerRepeat.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstancePolymer\FHIRSubstancePolymerRepeatUnit::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerRepeatUnit.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstancePolymer\FHIRSubstancePolymerDegreeOfPolymerisation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerDegreeOfPolymerisation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstancePolymer\FHIRSubstancePolymerStructuralRepresentation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerStructuralRepresentation.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceProtein::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceProtein.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceProtein\FHIRSubstanceProteinSubunit::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceProtein/FHIRSubstanceProteinSubunit.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceReferenceInformation::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceReferenceInformation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceReferenceInformation\FHIRSubstanceReferenceInformationGene::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceReferenceInformation/FHIRSubstanceReferenceInformationGene.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceReferenceInformation\FHIRSubstanceReferenceInformationGeneElement::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceReferenceInformation/FHIRSubstanceReferenceInformationGeneElement.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceReferenceInformation\FHIRSubstanceReferenceInformationClassification::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceReferenceInformation/FHIRSubstanceReferenceInformationClassification.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceReferenceInformation\FHIRSubstanceReferenceInformationTarget::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceReferenceInformation/FHIRSubstanceReferenceInformationTarget.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceSourceMaterial::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceSourceMaterial.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSourceMaterial\FHIRSubstanceSourceMaterialFractionDescription::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialFractionDescription.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSourceMaterial\FHIRSubstanceSourceMaterialOrganism::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialOrganism.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSourceMaterial\FHIRSubstanceSourceMaterialAuthor::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialAuthor.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSourceMaterial\FHIRSubstanceSourceMaterialHybrid::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialHybrid.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSourceMaterial\FHIRSubstanceSourceMaterialOrganismGeneral::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialOrganismGeneral.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSourceMaterial\FHIRSubstanceSourceMaterialPartDescription::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialPartDescription.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceSpecification::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceSpecification.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationMoiety::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationMoiety.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationProperty::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationProperty.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationStructure::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationStructure.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationIsotope::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationIsotope.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationMolecularWeight::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationMolecularWeight.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationRepresentation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationRepresentation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationCode::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationCode.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationName::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationName.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationOfficial::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationOfficial.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceSpecification\FHIRSubstanceSpecificationRelationship::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationRelationship.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSupplyDelivery::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSupplyDelivery.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSupplyDelivery\FHIRSupplyDeliverySuppliedItem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSupplyDelivery/FHIRSupplyDeliverySuppliedItem.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSupplyDeliveryStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSupplyDeliveryStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSupplyRequest::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSupplyRequest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRSupplyRequest\FHIRSupplyRequestParameter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSupplyRequest/FHIRSupplyRequestParameter.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRSupplyRequestStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSupplyRequestStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRTask::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRTask.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTask\FHIRTaskRestriction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTask/FHIRTaskRestriction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTask\FHIRTaskInput::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTask/FHIRTaskInput.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTask\FHIRTaskOutput::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTask/FHIRTaskOutput.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTaskStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTaskStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTaskIntent::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTaskIntent.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRTerminologyCapabilities::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRTerminologyCapabilities.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesSoftware::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesSoftware.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesImplementation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesImplementation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesCodeSystem::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesCodeSystem.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesVersion::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesVersion.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesFilter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesFilter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesExpansion::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesExpansion.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesParameter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesParameter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesValidateCode::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesValidateCode.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesTranslation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesTranslation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTerminologyCapabilities\FHIRTerminologyCapabilitiesClosure::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesClosure.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeSearchSupport::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCodeSearchSupport.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRTestReport::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRTestReport.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportParticipant::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportParticipant.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportSetup::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportSetup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportAction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportAction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportOperation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportOperation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportAssert::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportAssert.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportTest::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportTest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportAction1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportAction1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportTeardown::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportTeardown.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestReport\FHIRTestReportAction2::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportAction2.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTestReportStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestReportStatus.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTestReportActionResult::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestReportActionResult.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTestReportParticipantType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestReportParticipantType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTestReportResult::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestReportResult.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRTestScript::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRTestScript.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptOrigin::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptOrigin.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptDestination::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptDestination.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptMetadata::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptMetadata.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptLink::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptLink.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptCapability::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptCapability.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptFixture::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptFixture.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptVariable::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptVariable.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptSetup::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptSetup.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptAction::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptAction.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptOperation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptOperation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptRequestHeader::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptRequestHeader.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptAssert::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptAssert.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptTest::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptTest.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptAction1::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptAction1.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptTeardown::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptTeardown.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRTestScript\FHIRTestScriptAction2::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptAction2.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAssertionDirectionType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAssertionDirectionType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAssertionOperatorType::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAssertionOperatorType.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRAssertionResponseTypes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAssertionResponseTypes.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRTestScriptRequestMethodCode::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestScriptRequestMethodCode.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRValueSet::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRValueSet.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRValueSet\FHIRValueSetCompose::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetCompose.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRValueSet\FHIRValueSetInclude::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetInclude.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRValueSet\FHIRValueSetConcept::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetConcept.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRValueSet\FHIRValueSetDesignation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetDesignation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRValueSet\FHIRValueSetFilter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetFilter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRValueSet\FHIRValueSetExpansion::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetExpansion.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRValueSet\FHIRValueSetParameter::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetParameter.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRValueSet\FHIRValueSetContains::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetContains.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRVerificationResult::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRVerificationResult.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRVerificationResult\FHIRVerificationResultPrimarySource::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVerificationResult/FHIRVerificationResultPrimarySource.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRVerificationResult\FHIRVerificationResultAttestation::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVerificationResult/FHIRVerificationResultAttestation.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRVerificationResult\FHIRVerificationResultValidator::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVerificationResult/FHIRVerificationResultValidator.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRStatus::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStatus.php',
    \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRVisionPrescription::class => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRVisionPrescription.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRVisionPrescription\FHIRVisionPrescriptionLensSpecification::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVisionPrescription/FHIRVisionPrescriptionLensSpecification.php',
    \OpenEMR\FHIR\R4\FHIRResource\FHIRVisionPrescription\FHIRVisionPrescriptionPrism::class => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVisionPrescription/FHIRVisionPrescriptionPrism.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRVisionBase::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRVisionBase.php',
    \OpenEMR\FHIR\R4\FHIRElement\FHIRVisionEyes::class => 'OpenEMR/FHIR/R4/FHIRElement/FHIRVisionEyes.php',
    ];

    /** @var bool */
    private static $_registered = false;

    /**
     * @return bool
     * @throws \Exception
     */
    public static function register()
    {
        if (self::$_registered) {
            return self::$_registered;
        }
        return self::$_registered = spl_autoload_register(self::loadClass(...), true);
    }

    /**
     * @return bool
     */
    public static function unregister()
    {
        if (self::$_registered) {
            if (spl_autoload_unregister(self::loadClass(...))) {
                self::$_registered = false;
                return true;
            }
        }
        return false;
    }

    /**
     * Please see associated documentation for more information on what this method looks for.
     *
     * @param string $class
     * @return bool|null
     */
    public static function loadClass($class)
    {
        if (isset(self::$_classMap[$class])) {
            return (bool)require sprintf('%s/%s', self::ROOT_DIR, self::$_classMap[$class]);
        }
        return null;
    }
}
