<?php

namespace OpenEMR\FHIR\R4;

/*!
 * This class was generated with the PHPFHIR library (https://github.com/dcarbone/php-fhir) using
 * class definitions from HL7 FHIR (https://www.hl7.org/fhir/)
 *
 * Class creation date: June 14th, 2019
 *
 * PHPFHIR Copyright:
 *
 * Copyright 2016-2017 Daniel Carbone (daniel.p.carbone@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

class PHPFHIRParserMap implements \ArrayAccess, \Iterator
{
    /** @var array */
    private $_bigDumbMap =  [
    'date' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'date-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'dateTime' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'dateTime-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'code' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'code-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'string' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'integer' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'integer-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'oid' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIROid::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'oid-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'canonical' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'canonical-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'uri' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'uri-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'uuid' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUuid::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'uuid-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'url' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'url-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'instant' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'instant-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'boolean' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'boolean-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'base64Binary' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'base64Binary-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'unsignedInt' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'unsignedInt-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'markdown' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'markdown-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'time' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'time-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'id' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'id-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'positiveInt' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'positiveInt-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'decimal' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'ResourceContainer' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
    'extendedElementName' => null,
    'properties' =>
     [
      'Account' =>
       [
        'setter' => 'setAccount',
        'element' => 'Account',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAccount::class,
      ],
      'ActivityDefinition' =>
       [
        'setter' => 'setActivityDefinition',
        'element' => 'ActivityDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRActivityDefinition::class,
      ],
      'AdverseEvent' =>
       [
        'setter' => 'setAdverseEvent',
        'element' => 'AdverseEvent',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAdverseEvent::class,
      ],
      'AllergyIntolerance' =>
       [
        'setter' => 'setAllergyIntolerance',
        'element' => 'AllergyIntolerance',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAllergyIntolerance::class,
      ],
      'Appointment' =>
       [
        'setter' => 'setAppointment',
        'element' => 'Appointment',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAppointment::class,
      ],
      'AppointmentResponse' =>
       [
        'setter' => 'setAppointmentResponse',
        'element' => 'AppointmentResponse',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAppointmentResponse::class,
      ],
      'AuditEvent' =>
       [
        'setter' => 'setAuditEvent',
        'element' => 'AuditEvent',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAuditEvent::class,
      ],
      'Basic' =>
       [
        'setter' => 'setBasic',
        'element' => 'Basic',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBasic::class,
      ],
      'Binary' =>
       [
        'setter' => 'setBinary',
        'element' => 'Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBinary::class,
      ],
      'BiologicallyDerivedProduct' =>
       [
        'setter' => 'setBiologicallyDerivedProduct',
        'element' => 'BiologicallyDerivedProduct',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBiologicallyDerivedProduct::class,
      ],
      'BodyStructure' =>
       [
        'setter' => 'setBodyStructure',
        'element' => 'BodyStructure',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBodyStructure::class,
      ],
      'Bundle' =>
       [
        'setter' => 'setBundle',
        'element' => 'Bundle',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle::class,
      ],
      'CapabilityStatement' =>
       [
        'setter' => 'setCapabilityStatement',
        'element' => 'CapabilityStatement',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCapabilityStatement::class,
      ],
      'CarePlan' =>
       [
        'setter' => 'setCarePlan',
        'element' => 'CarePlan',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCarePlan::class,
      ],
      'CareTeam' =>
       [
        'setter' => 'setCareTeam',
        'element' => 'CareTeam',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCareTeam::class,
      ],
      'CatalogEntry' =>
       [
        'setter' => 'setCatalogEntry',
        'element' => 'CatalogEntry',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCatalogEntry::class,
      ],
      'ChargeItem' =>
       [
        'setter' => 'setChargeItem',
        'element' => 'ChargeItem',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRChargeItem::class,
      ],
      'ChargeItemDefinition' =>
       [
        'setter' => 'setChargeItemDefinition',
        'element' => 'ChargeItemDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRChargeItemDefinition::class,
      ],
      'Claim' =>
       [
        'setter' => 'setClaim',
        'element' => 'Claim',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClaim::class,
      ],
      'ClaimResponse' =>
       [
        'setter' => 'setClaimResponse',
        'element' => 'ClaimResponse',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClaimResponse::class,
      ],
      'ClinicalImpression' =>
       [
        'setter' => 'setClinicalImpression',
        'element' => 'ClinicalImpression',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClinicalImpression::class,
      ],
      'CodeSystem' =>
       [
        'setter' => 'setCodeSystem',
        'element' => 'CodeSystem',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCodeSystem::class,
      ],
      'Communication' =>
       [
        'setter' => 'setCommunication',
        'element' => 'Communication',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCommunication::class,
      ],
      'CommunicationRequest' =>
       [
        'setter' => 'setCommunicationRequest',
        'element' => 'CommunicationRequest',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCommunicationRequest::class,
      ],
      'CompartmentDefinition' =>
       [
        'setter' => 'setCompartmentDefinition',
        'element' => 'CompartmentDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCompartmentDefinition::class,
      ],
      'Composition' =>
       [
        'setter' => 'setComposition',
        'element' => 'Composition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRComposition::class,
      ],
      'ConceptMap' =>
       [
        'setter' => 'setConceptMap',
        'element' => 'ConceptMap',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRConceptMap::class,
      ],
      'Condition' =>
       [
        'setter' => 'setCondition',
        'element' => 'Condition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCondition::class,
      ],
      'Consent' =>
       [
        'setter' => 'setConsent',
        'element' => 'Consent',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRConsent::class,
      ],
      'Contract' =>
       [
        'setter' => 'setContract',
        'element' => 'Contract',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRContract::class,
      ],
      'Coverage' =>
       [
        'setter' => 'setCoverage',
        'element' => 'Coverage',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverage::class,
      ],
      'CoverageEligibilityRequest' =>
       [
        'setter' => 'setCoverageEligibilityRequest',
        'element' => 'CoverageEligibilityRequest',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverageEligibilityRequest::class,
      ],
      'CoverageEligibilityResponse' =>
       [
        'setter' => 'setCoverageEligibilityResponse',
        'element' => 'CoverageEligibilityResponse',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverageEligibilityResponse::class,
      ],
      'DetectedIssue' =>
       [
        'setter' => 'setDetectedIssue',
        'element' => 'DetectedIssue',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDetectedIssue::class,
      ],
      'Device' =>
       [
        'setter' => 'setDevice',
        'element' => 'Device',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDevice::class,
      ],
      'DeviceDefinition' =>
       [
        'setter' => 'setDeviceDefinition',
        'element' => 'DeviceDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceDefinition::class,
      ],
      'DeviceMetric' =>
       [
        'setter' => 'setDeviceMetric',
        'element' => 'DeviceMetric',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceMetric::class,
      ],
      'DeviceRequest' =>
       [
        'setter' => 'setDeviceRequest',
        'element' => 'DeviceRequest',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceRequest::class,
      ],
      'DeviceUseStatement' =>
       [
        'setter' => 'setDeviceUseStatement',
        'element' => 'DeviceUseStatement',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceUseStatement::class,
      ],
      'DiagnosticReport' =>
       [
        'setter' => 'setDiagnosticReport',
        'element' => 'DiagnosticReport',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDiagnosticReport::class,
      ],
      'DocumentManifest' =>
       [
        'setter' => 'setDocumentManifest',
        'element' => 'DocumentManifest',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDocumentManifest::class,
      ],
      'DocumentReference' =>
       [
        'setter' => 'setDocumentReference',
        'element' => 'DocumentReference',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDocumentReference::class,
      ],
      'EffectEvidenceSynthesis' =>
       [
        'setter' => 'setEffectEvidenceSynthesis',
        'element' => 'EffectEvidenceSynthesis',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREffectEvidenceSynthesis::class,
      ],
      'Encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Encounter',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREncounter::class,
      ],
      'Endpoint' =>
       [
        'setter' => 'setEndpoint',
        'element' => 'Endpoint',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREndpoint::class,
      ],
      'EnrollmentRequest' =>
       [
        'setter' => 'setEnrollmentRequest',
        'element' => 'EnrollmentRequest',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREnrollmentRequest::class,
      ],
      'EnrollmentResponse' =>
       [
        'setter' => 'setEnrollmentResponse',
        'element' => 'EnrollmentResponse',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREnrollmentResponse::class,
      ],
      'EpisodeOfCare' =>
       [
        'setter' => 'setEpisodeOfCare',
        'element' => 'EpisodeOfCare',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREpisodeOfCare::class,
      ],
      'EventDefinition' =>
       [
        'setter' => 'setEventDefinition',
        'element' => 'EventDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREventDefinition::class,
      ],
      'Evidence' =>
       [
        'setter' => 'setEvidence',
        'element' => 'Evidence',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREvidence::class,
      ],
      'EvidenceVariable' =>
       [
        'setter' => 'setEvidenceVariable',
        'element' => 'EvidenceVariable',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREvidenceVariable::class,
      ],
      'ExampleScenario' =>
       [
        'setter' => 'setExampleScenario',
        'element' => 'ExampleScenario',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRExampleScenario::class,
      ],
      'ExplanationOfBenefit' =>
       [
        'setter' => 'setExplanationOfBenefit',
        'element' => 'ExplanationOfBenefit',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRExplanationOfBenefit::class,
      ],
      'FamilyMemberHistory' =>
       [
        'setter' => 'setFamilyMemberHistory',
        'element' => 'FamilyMemberHistory',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRFamilyMemberHistory::class,
      ],
      'Flag' =>
       [
        'setter' => 'setFlag',
        'element' => 'Flag',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRFlag::class,
      ],
      'Goal' =>
       [
        'setter' => 'setGoal',
        'element' => 'Goal',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGoal::class,
      ],
      'GraphDefinition' =>
       [
        'setter' => 'setGraphDefinition',
        'element' => 'GraphDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGraphDefinition::class,
      ],
      'Group' =>
       [
        'setter' => 'setGroup',
        'element' => 'Group',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGroup::class,
      ],
      'GuidanceResponse' =>
       [
        'setter' => 'setGuidanceResponse',
        'element' => 'GuidanceResponse',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGuidanceResponse::class,
      ],
      'HealthcareService' =>
       [
        'setter' => 'setHealthcareService',
        'element' => 'HealthcareService',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRHealthcareService::class,
      ],
      'ImagingStudy' =>
       [
        'setter' => 'setImagingStudy',
        'element' => 'ImagingStudy',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImagingStudy::class,
      ],
      'Immunization' =>
       [
        'setter' => 'setImmunization',
        'element' => 'Immunization',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunization::class,
      ],
      'ImmunizationEvaluation' =>
       [
        'setter' => 'setImmunizationEvaluation',
        'element' => 'ImmunizationEvaluation',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunizationEvaluation::class,
      ],
      'ImmunizationRecommendation' =>
       [
        'setter' => 'setImmunizationRecommendation',
        'element' => 'ImmunizationRecommendation',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunizationRecommendation::class,
      ],
      'ImplementationGuide' =>
       [
        'setter' => 'setImplementationGuide',
        'element' => 'ImplementationGuide',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImplementationGuide::class,
      ],
      'InsurancePlan' =>
       [
        'setter' => 'setInsurancePlan',
        'element' => 'InsurancePlan',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRInsurancePlan::class,
      ],
      'Invoice' =>
       [
        'setter' => 'setInvoice',
        'element' => 'Invoice',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRInvoice::class,
      ],
      'Library' =>
       [
        'setter' => 'setLibrary',
        'element' => 'Library',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLibrary::class,
      ],
      'Linkage' =>
       [
        'setter' => 'setLinkage',
        'element' => 'Linkage',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLinkage::class,
      ],
      'List' =>
       [
        'setter' => 'setList',
        'element' => 'List',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRList::class,
      ],
      'Location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Location',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLocation::class,
      ],
      'Measure' =>
       [
        'setter' => 'setMeasure',
        'element' => 'Measure',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMeasure::class,
      ],
      'MeasureReport' =>
       [
        'setter' => 'setMeasureReport',
        'element' => 'MeasureReport',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMeasureReport::class,
      ],
      'Media' =>
       [
        'setter' => 'setMedia',
        'element' => 'Media',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedia::class,
      ],
      'Medication' =>
       [
        'setter' => 'setMedication',
        'element' => 'Medication',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedication::class,
      ],
      'MedicationAdministration' =>
       [
        'setter' => 'setMedicationAdministration',
        'element' => 'MedicationAdministration',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationAdministration::class,
      ],
      'MedicationDispense' =>
       [
        'setter' => 'setMedicationDispense',
        'element' => 'MedicationDispense',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationDispense::class,
      ],
      'MedicationKnowledge' =>
       [
        'setter' => 'setMedicationKnowledge',
        'element' => 'MedicationKnowledge',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationKnowledge::class,
      ],
      'MedicationRequest' =>
       [
        'setter' => 'setMedicationRequest',
        'element' => 'MedicationRequest',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationRequest::class,
      ],
      'MedicationStatement' =>
       [
        'setter' => 'setMedicationStatement',
        'element' => 'MedicationStatement',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicationStatement::class,
      ],
      'MedicinalProduct' =>
       [
        'setter' => 'setMedicinalProduct',
        'element' => 'MedicinalProduct',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProduct::class,
      ],
      'MedicinalProductAuthorization' =>
       [
        'setter' => 'setMedicinalProductAuthorization',
        'element' => 'MedicinalProductAuthorization',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductAuthorization::class,
      ],
      'MedicinalProductContraindication' =>
       [
        'setter' => 'setMedicinalProductContraindication',
        'element' => 'MedicinalProductContraindication',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductContraindication::class,
      ],
      'MedicinalProductIndication' =>
       [
        'setter' => 'setMedicinalProductIndication',
        'element' => 'MedicinalProductIndication',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductIndication::class,
      ],
      'MedicinalProductIngredient' =>
       [
        'setter' => 'setMedicinalProductIngredient',
        'element' => 'MedicinalProductIngredient',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductIngredient::class,
      ],
      'MedicinalProductInteraction' =>
       [
        'setter' => 'setMedicinalProductInteraction',
        'element' => 'MedicinalProductInteraction',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductInteraction::class,
      ],
      'MedicinalProductManufactured' =>
       [
        'setter' => 'setMedicinalProductManufactured',
        'element' => 'MedicinalProductManufactured',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductManufactured::class,
      ],
      'MedicinalProductPackaged' =>
       [
        'setter' => 'setMedicinalProductPackaged',
        'element' => 'MedicinalProductPackaged',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductPackaged::class,
      ],
      'MedicinalProductPharmaceutical' =>
       [
        'setter' => 'setMedicinalProductPharmaceutical',
        'element' => 'MedicinalProductPharmaceutical',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductPharmaceutical::class,
      ],
      'MedicinalProductUndesirableEffect' =>
       [
        'setter' => 'setMedicinalProductUndesirableEffect',
        'element' => 'MedicinalProductUndesirableEffect',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMedicinalProductUndesirableEffect::class,
      ],
      'MessageDefinition' =>
       [
        'setter' => 'setMessageDefinition',
        'element' => 'MessageDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMessageDefinition::class,
      ],
      'MessageHeader' =>
       [
        'setter' => 'setMessageHeader',
        'element' => 'MessageHeader',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMessageHeader::class,
      ],
      'MolecularSequence' =>
       [
        'setter' => 'setMolecularSequence',
        'element' => 'MolecularSequence',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRMolecularSequence::class,
      ],
      'NamingSystem' =>
       [
        'setter' => 'setNamingSystem',
        'element' => 'NamingSystem',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRNamingSystem::class,
      ],
      'NutritionOrder' =>
       [
        'setter' => 'setNutritionOrder',
        'element' => 'NutritionOrder',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRNutritionOrder::class,
      ],
      'Observation' =>
       [
        'setter' => 'setObservation',
        'element' => 'Observation',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRObservation::class,
      ],
      'ObservationDefinition' =>
       [
        'setter' => 'setObservationDefinition',
        'element' => 'ObservationDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRObservationDefinition::class,
      ],
      'OperationDefinition' =>
       [
        'setter' => 'setOperationDefinition',
        'element' => 'OperationDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIROperationDefinition::class,
      ],
      'OperationOutcome' =>
       [
        'setter' => 'setOperationOutcome',
        'element' => 'OperationOutcome',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIROperationOutcome::class,
      ],
      'Organization' =>
       [
        'setter' => 'setOrganization',
        'element' => 'Organization',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIROrganization::class,
      ],
      'OrganizationAffiliation' =>
       [
        'setter' => 'setOrganizationAffiliation',
        'element' => 'OrganizationAffiliation',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIROrganizationAffiliation::class,
      ],
      'Patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Patient',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPatient::class,
      ],
      'PaymentNotice' =>
       [
        'setter' => 'setPaymentNotice',
        'element' => 'PaymentNotice',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPaymentNotice::class,
      ],
      'PaymentReconciliation' =>
       [
        'setter' => 'setPaymentReconciliation',
        'element' => 'PaymentReconciliation',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPaymentReconciliation::class,
      ],
      'Person' =>
       [
        'setter' => 'setPerson',
        'element' => 'Person',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPerson::class,
      ],
      'PlanDefinition' =>
       [
        'setter' => 'setPlanDefinition',
        'element' => 'PlanDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPlanDefinition::class,
      ],
      'Practitioner' =>
       [
        'setter' => 'setPractitioner',
        'element' => 'Practitioner',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPractitioner::class,
      ],
      'PractitionerRole' =>
       [
        'setter' => 'setPractitionerRole',
        'element' => 'PractitionerRole',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRPractitionerRole::class,
      ],
      'Procedure' =>
       [
        'setter' => 'setProcedure',
        'element' => 'Procedure',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRProcedure::class,
      ],
      'Provenance' =>
       [
        'setter' => 'setProvenance',
        'element' => 'Provenance',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRProvenance::class,
      ],
      'Questionnaire' =>
       [
        'setter' => 'setQuestionnaire',
        'element' => 'Questionnaire',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRQuestionnaire::class,
      ],
      'QuestionnaireResponse' =>
       [
        'setter' => 'setQuestionnaireResponse',
        'element' => 'QuestionnaireResponse',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRQuestionnaireResponse::class,
      ],
      'RelatedPerson' =>
       [
        'setter' => 'setRelatedPerson',
        'element' => 'RelatedPerson',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRRelatedPerson::class,
      ],
      'RequestGroup' =>
       [
        'setter' => 'setRequestGroup',
        'element' => 'RequestGroup',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRRequestGroup::class,
      ],
      'ResearchDefinition' =>
       [
        'setter' => 'setResearchDefinition',
        'element' => 'ResearchDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRResearchDefinition::class,
      ],
      'ResearchElementDefinition' =>
       [
        'setter' => 'setResearchElementDefinition',
        'element' => 'ResearchElementDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRResearchElementDefinition::class,
      ],
      'ResearchStudy' =>
       [
        'setter' => 'setResearchStudy',
        'element' => 'ResearchStudy',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRResearchStudy::class,
      ],
      'ResearchSubject' =>
       [
        'setter' => 'setResearchSubject',
        'element' => 'ResearchSubject',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRResearchSubject::class,
      ],
      'RiskAssessment' =>
       [
        'setter' => 'setRiskAssessment',
        'element' => 'RiskAssessment',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRRiskAssessment::class,
      ],
      'RiskEvidenceSynthesis' =>
       [
        'setter' => 'setRiskEvidenceSynthesis',
        'element' => 'RiskEvidenceSynthesis',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRRiskEvidenceSynthesis::class,
      ],
      'Schedule' =>
       [
        'setter' => 'setSchedule',
        'element' => 'Schedule',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSchedule::class,
      ],
      'SearchParameter' =>
       [
        'setter' => 'setSearchParameter',
        'element' => 'SearchParameter',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSearchParameter::class,
      ],
      'ServiceRequest' =>
       [
        'setter' => 'setServiceRequest',
        'element' => 'ServiceRequest',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRServiceRequest::class,
      ],
      'Slot' =>
       [
        'setter' => 'setSlot',
        'element' => 'Slot',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSlot::class,
      ],
      'Specimen' =>
       [
        'setter' => 'setSpecimen',
        'element' => 'Specimen',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSpecimen::class,
      ],
      'SpecimenDefinition' =>
       [
        'setter' => 'setSpecimenDefinition',
        'element' => 'SpecimenDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSpecimenDefinition::class,
      ],
      'StructureDefinition' =>
       [
        'setter' => 'setStructureDefinition',
        'element' => 'StructureDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRStructureDefinition::class,
      ],
      'StructureMap' =>
       [
        'setter' => 'setStructureMap',
        'element' => 'StructureMap',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRStructureMap::class,
      ],
      'Subscription' =>
       [
        'setter' => 'setSubscription',
        'element' => 'Subscription',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubscription::class,
      ],
      'Substance' =>
       [
        'setter' => 'setSubstance',
        'element' => 'Substance',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstance::class,
      ],
      'SubstanceNucleicAcid' =>
       [
        'setter' => 'setSubstanceNucleicAcid',
        'element' => 'SubstanceNucleicAcid',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceNucleicAcid::class,
      ],
      'SubstancePolymer' =>
       [
        'setter' => 'setSubstancePolymer',
        'element' => 'SubstancePolymer',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstancePolymer::class,
      ],
      'SubstanceProtein' =>
       [
        'setter' => 'setSubstanceProtein',
        'element' => 'SubstanceProtein',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceProtein::class,
      ],
      'SubstanceReferenceInformation' =>
       [
        'setter' => 'setSubstanceReferenceInformation',
        'element' => 'SubstanceReferenceInformation',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceReferenceInformation::class,
      ],
      'SubstanceSourceMaterial' =>
       [
        'setter' => 'setSubstanceSourceMaterial',
        'element' => 'SubstanceSourceMaterial',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceSourceMaterial::class,
      ],
      'SubstanceSpecification' =>
       [
        'setter' => 'setSubstanceSpecification',
        'element' => 'SubstanceSpecification',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSubstanceSpecification::class,
      ],
      'SupplyDelivery' =>
       [
        'setter' => 'setSupplyDelivery',
        'element' => 'SupplyDelivery',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSupplyDelivery::class,
      ],
      'SupplyRequest' =>
       [
        'setter' => 'setSupplyRequest',
        'element' => 'SupplyRequest',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRSupplyRequest::class,
      ],
      'Task' =>
       [
        'setter' => 'setTask',
        'element' => 'Task',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRTask::class,
      ],
      'TerminologyCapabilities' =>
       [
        'setter' => 'setTerminologyCapabilities',
        'element' => 'TerminologyCapabilities',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRTerminologyCapabilities::class,
      ],
      'TestReport' =>
       [
        'setter' => 'setTestReport',
        'element' => 'TestReport',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRTestReport::class,
      ],
      'TestScript' =>
       [
        'setter' => 'setTestScript',
        'element' => 'TestScript',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRTestScript::class,
      ],
      'ValueSet' =>
       [
        'setter' => 'setValueSet',
        'element' => 'ValueSet',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRValueSet::class,
      ],
      'VerificationResult' =>
       [
        'setter' => 'setVerificationResult',
        'element' => 'VerificationResult',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRVerificationResult::class,
      ],
      'VisionPrescription' =>
       [
        'setter' => 'setVisionPrescription',
        'element' => 'VisionPrescription',
        'type' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRVisionPrescription::class,
      ],
      'Parameters' =>
       [
        'setter' => 'setParameters',
        'element' => 'Parameters',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRParameters::class,
      ],
    ],
    ],
    'Extension' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'valueBase64Binary' =>
       [
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'valueBoolean' =>
       [
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'valueCanonical' =>
       [
        'setter' => 'setValueCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'valueCode' =>
       [
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'valueDate' =>
       [
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'valueDateTime' =>
       [
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'valueDecimal' =>
       [
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'valueId' =>
       [
        'setter' => 'setValueId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'valueInstant' =>
       [
        'setter' => 'setValueInstant',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'valueInteger' =>
       [
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'valueMarkdown' =>
       [
        'setter' => 'setValueMarkdown',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'valueOid' =>
       [
        'setter' => 'setValueOid',
        'element' => 'oid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIROid::class,
      ],
      'valuePositiveInt' =>
       [
        'setter' => 'setValuePositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'valueString' =>
       [
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueTime' =>
       [
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'valueUnsignedInt' =>
       [
        'setter' => 'setValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'valueUri' =>
       [
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'valueUrl' =>
       [
        'setter' => 'setValueUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'valueUuid' =>
       [
        'setter' => 'setValueUuid',
        'element' => 'uuid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUuid::class,
      ],
      'valueAddress' =>
       [
        'setter' => 'setValueAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'valueAge' =>
       [
        'setter' => 'setValueAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'valueAnnotation' =>
       [
        'setter' => 'setValueAnnotation',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'valueAttachment' =>
       [
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'valueCodeableConcept' =>
       [
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueCoding' =>
       [
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'valueContactPoint' =>
       [
        'setter' => 'setValueContactPoint',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'valueCount' =>
       [
        'setter' => 'setValueCount',
        'element' => 'Count',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRCount::class,
      ],
      'valueDistance' =>
       [
        'setter' => 'setValueDistance',
        'element' => 'Distance',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDistance::class,
      ],
      'valueDuration' =>
       [
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'valueHumanName' =>
       [
        'setter' => 'setValueHumanName',
        'element' => 'HumanName',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHumanName::class,
      ],
      'valueIdentifier' =>
       [
        'setter' => 'setValueIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'valueMoney' =>
       [
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'valuePeriod' =>
       [
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueRange' =>
       [
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'valueRatio' =>
       [
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
      ],
      'valueReference' =>
       [
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'valueSampledData' =>
       [
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledData::class,
      ],
      'valueSignature' =>
       [
        'setter' => 'setValueSignature',
        'element' => 'Signature',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class,
      ],
      'valueTiming' =>
       [
        'setter' => 'setValueTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'valueContactDetail' =>
       [
        'setter' => 'setValueContactDetail',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'valueContributor' =>
       [
        'setter' => 'setValueContributor',
        'element' => 'Contributor',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContributor::class,
      ],
      'valueDataRequirement' =>
       [
        'setter' => 'setValueDataRequirement',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
      'valueExpression' =>
       [
        'setter' => 'setValueExpression',
        'element' => 'Expression',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
      ],
      'valueParameterDefinition' =>
       [
        'setter' => 'setValueParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParameterDefinition::class,
      ],
      'valueRelatedArtifact' =>
       [
        'setter' => 'setValueRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'valueTriggerDefinition' =>
       [
        'setter' => 'setValueTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class,
      ],
      'valueUsageContext' =>
       [
        'setter' => 'setValueUsageContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'valueDosage' =>
       [
        'setter' => 'setValueDosage',
        'element' => 'Dosage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'BackboneElement' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBackboneElement::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
    ],
    ],
    'Narrative' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'NarrativeStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrativeStatus::class,
      ],
      'div' =>
       [
        'setter' => 'setDiv',
        'element' => 'html',
        'type' => 'string',
      ],
    ],
    ],
    'NarrativeStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrativeStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'NarrativeStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'Element' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement::class,
    'extendedElementName' => null,
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'Meta' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'versionId' =>
       [
        'setter' => 'setVersionId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'lastUpdated' =>
       [
        'setter' => 'setLastUpdated',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'profile' =>
       [
        'setter' => 'addProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'security' =>
       [
        'setter' => 'addSecurity',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'tag' =>
       [
        'setter' => 'addTag',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
    ],
    ],
    'Address' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'AddressUse',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddressUse::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'AddressType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddressType::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'line' =>
       [
        'setter' => 'addLine',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'city' =>
       [
        'setter' => 'setCity',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'district' =>
       [
        'setter' => 'setDistrict',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'state' =>
       [
        'setter' => 'setState',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'postalCode' =>
       [
        'setter' => 'setPostalCode',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'country' =>
       [
        'setter' => 'setCountry',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'AddressUse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddressUse::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AddressUse-list',
        'type' => 'string',
      ],
    ],
    ],
    'AddressType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddressType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AddressType-list',
        'type' => 'string',
      ],
    ],
    ],
    'Contributor' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContributor::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'ContributorType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContributorType::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
    ],
    ],
    'ContributorType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContributorType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ContributorType-list',
        'type' => 'string',
      ],
    ],
    ],
    'Attachment' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'contentType' =>
       [
        'setter' => 'setContentType',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'data' =>
       [
        'setter' => 'setData',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'size' =>
       [
        'setter' => 'setSize',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'hash' =>
       [
        'setter' => 'setHash',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'creation' =>
       [
        'setter' => 'setCreation',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
    ],
    ],
    'Count' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRCount::class,
    'extendedElementName' => 'Quantity',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'comparator' =>
       [
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantityComparator::class,
      ],
      'unit' =>
       [
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
    ],
    ],
    'DataRequirement' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'profile' =>
       [
        'setter' => 'addProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'subjectCodeableConcept' =>
       [
        'setter' => 'setSubjectCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subjectReference' =>
       [
        'setter' => 'setSubjectReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'mustSupport' =>
       [
        'setter' => 'addMustSupport',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'codeFilter' =>
       [
        'setter' => 'addCodeFilter',
        'element' => 'DataRequirement.CodeFilter',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementCodeFilter::class,
      ],
      'dateFilter' =>
       [
        'setter' => 'addDateFilter',
        'element' => 'DataRequirement.DateFilter',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementDateFilter::class,
      ],
      'limit' =>
       [
        'setter' => 'setLimit',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'sort' =>
       [
        'setter' => 'addSort',
        'element' => 'DataRequirement.Sort',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementSort::class,
      ],
    ],
    ],
    'DataRequirement.CodeFilter' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementCodeFilter::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'path' =>
       [
        'setter' => 'setPath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'searchParam' =>
       [
        'setter' => 'setSearchParam',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueSet' =>
       [
        'setter' => 'setValueSet',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'code' =>
       [
        'setter' => 'addCode',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
    ],
    ],
    'DataRequirement.DateFilter' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementDateFilter::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'path' =>
       [
        'setter' => 'setPath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'searchParam' =>
       [
        'setter' => 'setSearchParam',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueDateTime' =>
       [
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'valuePeriod' =>
       [
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'valueDuration' =>
       [
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
    ],
    ],
    'DataRequirement.Sort' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDataRequirement\FHIRDataRequirementSort::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'path' =>
       [
        'setter' => 'setPath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'direction' =>
       [
        'setter' => 'setDirection',
        'element' => 'SortDirection',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSortDirection::class,
      ],
    ],
    ],
    'SortDirection' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSortDirection::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'SortDirection-list',
        'type' => 'string',
      ],
    ],
    ],
    'Dosage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'additionalInstruction' =>
       [
        'setter' => 'addAdditionalInstruction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'patientInstruction' =>
       [
        'setter' => 'setPatientInstruction',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'timing' =>
       [
        'setter' => 'setTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'asNeededBoolean' =>
       [
        'setter' => 'setAsNeededBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'asNeededCodeableConcept' =>
       [
        'setter' => 'setAsNeededCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'site' =>
       [
        'setter' => 'setSite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'route' =>
       [
        'setter' => 'setRoute',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'method' =>
       [
        'setter' => 'setMethod',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'doseAndRate' =>
       [
        'setter' => 'addDoseAndRate',
        'element' => 'Dosage.DoseAndRate',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage\FHIRDosageDoseAndRate::class,
      ],
      'maxDosePerPeriod' =>
       [
        'setter' => 'setMaxDosePerPeriod',
        'element' => 'Ratio',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
      ],
      'maxDosePerAdministration' =>
       [
        'setter' => 'setMaxDosePerAdministration',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'maxDosePerLifetime' =>
       [
        'setter' => 'setMaxDosePerLifetime',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
    ],
    ],
    'Dosage.DoseAndRate' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage\FHIRDosageDoseAndRate::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'doseRange' =>
       [
        'setter' => 'setDoseRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'doseQuantity' =>
       [
        'setter' => 'setDoseQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'rateRatio' =>
       [
        'setter' => 'setRateRatio',
        'element' => 'Ratio',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
      ],
      'rateRange' =>
       [
        'setter' => 'setRateRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'rateQuantity' =>
       [
        'setter' => 'setRateQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
    ],
    ],
    'Money' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'currency' =>
       [
        'setter' => 'setCurrency',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
    ],
    ],
    'HumanName' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHumanName::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'NameUse',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNameUse::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'family' =>
       [
        'setter' => 'setFamily',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'given' =>
       [
        'setter' => 'addGiven',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'prefix' =>
       [
        'setter' => 'addPrefix',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'suffix' =>
       [
        'setter' => 'addSuffix',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'NameUse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNameUse::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'NameUse-list',
        'type' => 'string',
      ],
    ],
    ],
    'ContactPoint' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'ContactPointSystem',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPointSystem::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'ContactPointUse',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPointUse::class,
      ],
      'rank' =>
       [
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'ContactPointSystem' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPointSystem::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ContactPointSystem-list',
        'type' => 'string',
      ],
    ],
    ],
    'ContactPointUse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPointUse::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ContactPointUse-list',
        'type' => 'string',
      ],
    ],
    ],
    'MarketingStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRMarketingStatus::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'country' =>
       [
        'setter' => 'setCountry',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'setJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'dateRange' =>
       [
        'setter' => 'setDateRange',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'restoreDate' =>
       [
        'setter' => 'setRestoreDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
    ],
    ],
    'Identifier' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'IdentifierUse',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifierUse::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'assigner' =>
       [
        'setter' => 'setAssigner',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'IdentifierUse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifierUse::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'IdentifierUse-list',
        'type' => 'string',
      ],
    ],
    ],
    'SubstanceAmount' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceAmount::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'amountQuantity' =>
       [
        'setter' => 'setAmountQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'amountRange' =>
       [
        'setter' => 'setAmountRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'amountString' =>
       [
        'setter' => 'setAmountString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'amountType' =>
       [
        'setter' => 'setAmountType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'amountText' =>
       [
        'setter' => 'setAmountText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'referenceRange' =>
       [
        'setter' => 'setReferenceRange',
        'element' => 'SubstanceAmount.ReferenceRange',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceAmount\FHIRSubstanceAmountReferenceRange::class,
      ],
    ],
    ],
    'SubstanceAmount.ReferenceRange' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRSubstanceAmount\FHIRSubstanceAmountReferenceRange::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'lowLimit' =>
       [
        'setter' => 'setLowLimit',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'highLimit' =>
       [
        'setter' => 'setHighLimit',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
    ],
    ],
    'Coding' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'display' =>
       [
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'userSelected' =>
       [
        'setter' => 'setUserSelected',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
    ],
    ],
    'SampledData' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledData::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'origin' =>
       [
        'setter' => 'setOrigin',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'lowerLimit' =>
       [
        'setter' => 'setLowerLimit',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'upperLimit' =>
       [
        'setter' => 'setUpperLimit',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'dimensions' =>
       [
        'setter' => 'setDimensions',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'data' =>
       [
        'setter' => 'setData',
        'element' => 'SampledDataDataType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledDataDataType::class,
      ],
    ],
    ],
    'SampledDataDataType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledDataDataType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'SampledDataDataType-primitive',
        'type' => 'string',
      ],
    ],
    ],
    'Population' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRPopulation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'ageRange' =>
       [
        'setter' => 'setAgeRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'ageCodeableConcept' =>
       [
        'setter' => 'setAgeCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'gender' =>
       [
        'setter' => 'setGender',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'race' =>
       [
        'setter' => 'setRace',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'physiologicalCondition' =>
       [
        'setter' => 'setPhysiologicalCondition',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Ratio' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'numerator' =>
       [
        'setter' => 'setNumerator',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'denominator' =>
       [
        'setter' => 'setDenominator',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
    ],
    ],
    'Distance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDistance::class,
    'extendedElementName' => 'Quantity',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'comparator' =>
       [
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantityComparator::class,
      ],
      'unit' =>
       [
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
    ],
    ],
    'Age' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
    'extendedElementName' => 'Quantity',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'comparator' =>
       [
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantityComparator::class,
      ],
      'unit' =>
       [
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
    ],
    ],
    'Reference' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'display' =>
       [
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'TriggerDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'TriggerType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerType::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'timingTiming' =>
       [
        'setter' => 'setTimingTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'timingReference' =>
       [
        'setter' => 'setTimingReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'timingDate' =>
       [
        'setter' => 'setTimingDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'timingDateTime' =>
       [
        'setter' => 'setTimingDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'data' =>
       [
        'setter' => 'addData',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
      'condition' =>
       [
        'setter' => 'setCondition',
        'element' => 'Expression',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
      ],
    ],
    ],
    'TriggerType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'TriggerType-list',
        'type' => 'string',
      ],
    ],
    ],
    'Quantity' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'comparator' =>
       [
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantityComparator::class,
      ],
      'unit' =>
       [
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
    ],
    ],
    'QuantityComparator' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantityComparator::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'QuantityComparator-list',
        'type' => 'string',
      ],
    ],
    ],
    'Period' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'start' =>
       [
        'setter' => 'setStart',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'end' =>
       [
        'setter' => 'setEnd',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
    ],
    ],
    'Duration' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
    'extendedElementName' => 'Quantity',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'comparator' =>
       [
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantityComparator::class,
      ],
      'unit' =>
       [
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
    ],
    ],
    'Range' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'low' =>
       [
        'setter' => 'setLow',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'high' =>
       [
        'setter' => 'setHigh',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
    ],
    ],
    'RelatedArtifact' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'RelatedArtifactType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifactType::class,
      ],
      'label' =>
       [
        'setter' => 'setLabel',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'display' =>
       [
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'citation' =>
       [
        'setter' => 'setCitation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'document' =>
       [
        'setter' => 'setDocument',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'resource' =>
       [
        'setter' => 'setResource',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'RelatedArtifactType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifactType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'RelatedArtifactType-list',
        'type' => 'string',
      ],
    ],
    ],
    'Annotation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'authorReference' =>
       [
        'setter' => 'setAuthorReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'authorString' =>
       [
        'setter' => 'setAuthorString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'time' =>
       [
        'setter' => 'setTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'ProductShelfLife' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRProductShelfLife::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'specialPrecautionsForStorage' =>
       [
        'setter' => 'addSpecialPrecautionsForStorage',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'ContactDetail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'telecom' =>
       [
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
    ],
    ],
    'UsageContext' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'valueCodeableConcept' =>
       [
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueRange' =>
       [
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'valueReference' =>
       [
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Expression' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'ExpressionLanguage',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpressionLanguage::class,
      ],
      'expression' =>
       [
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
    ],
    ],
    'ExpressionLanguage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpressionLanguage::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ExpressionLanguage-list',
        'type' => 'string',
      ],
    ],
    ],
    'Signature' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'when' =>
       [
        'setter' => 'setWhen',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'who' =>
       [
        'setter' => 'setWho',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'onBehalfOf' =>
       [
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'targetFormat' =>
       [
        'setter' => 'setTargetFormat',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'sigFormat' =>
       [
        'setter' => 'setSigFormat',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'data' =>
       [
        'setter' => 'setData',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
    ],
    ],
    'Timing' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'event' =>
       [
        'setter' => 'addEvent',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'repeat' =>
       [
        'setter' => 'setRepeat',
        'element' => 'Timing.Repeat',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming\FHIRTimingRepeat::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Timing.Repeat' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming\FHIRTimingRepeat::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'boundsDuration' =>
       [
        'setter' => 'setBoundsDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'boundsRange' =>
       [
        'setter' => 'setBoundsRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'boundsPeriod' =>
       [
        'setter' => 'setBoundsPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'count' =>
       [
        'setter' => 'setCount',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'countMax' =>
       [
        'setter' => 'setCountMax',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'duration' =>
       [
        'setter' => 'setDuration',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'durationMax' =>
       [
        'setter' => 'setDurationMax',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'durationUnit' =>
       [
        'setter' => 'setDurationUnit',
        'element' => 'UnitsOfTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnitsOfTime::class,
      ],
      'frequency' =>
       [
        'setter' => 'setFrequency',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'frequencyMax' =>
       [
        'setter' => 'setFrequencyMax',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'periodMax' =>
       [
        'setter' => 'setPeriodMax',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'periodUnit' =>
       [
        'setter' => 'setPeriodUnit',
        'element' => 'UnitsOfTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnitsOfTime::class,
      ],
      'dayOfWeek' =>
       [
        'setter' => 'addDayOfWeek',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'timeOfDay' =>
       [
        'setter' => 'addTimeOfDay',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'when' =>
       [
        'setter' => 'addWhen',
        'element' => 'EventTiming',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREventTiming::class,
      ],
      'offset' =>
       [
        'setter' => 'setOffset',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
    ],
    ],
    'UnitsOfTime' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnitsOfTime::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'UnitsOfTime-list',
        'type' => 'string',
      ],
    ],
    ],
    'EventTiming' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREventTiming::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EventTiming-list',
        'type' => 'string',
      ],
    ],
    ],
    'ProdCharacteristic' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRProdCharacteristic::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'height' =>
       [
        'setter' => 'setHeight',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'width' =>
       [
        'setter' => 'setWidth',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'depth' =>
       [
        'setter' => 'setDepth',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'weight' =>
       [
        'setter' => 'setWeight',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'nominalVolume' =>
       [
        'setter' => 'setNominalVolume',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'externalDiameter' =>
       [
        'setter' => 'setExternalDiameter',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'shape' =>
       [
        'setter' => 'setShape',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'color' =>
       [
        'setter' => 'addColor',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'imprint' =>
       [
        'setter' => 'addImprint',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'image' =>
       [
        'setter' => 'addImage',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'scoring' =>
       [
        'setter' => 'setScoring',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'CodeableConcept' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'coding' =>
       [
        'setter' => 'addCoding',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ParameterDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParameterDefinition::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'min' =>
       [
        'setter' => 'setMin',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'max' =>
       [
        'setter' => 'setMax',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'profile' =>
       [
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'ElementDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'path' =>
       [
        'setter' => 'setPath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'representation' =>
       [
        'setter' => 'addRepresentation',
        'element' => 'PropertyRepresentation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPropertyRepresentation::class,
      ],
      'sliceName' =>
       [
        'setter' => 'setSliceName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'sliceIsConstraining' =>
       [
        'setter' => 'setSliceIsConstraining',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'label' =>
       [
        'setter' => 'setLabel',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'code' =>
       [
        'setter' => 'addCode',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'slicing' =>
       [
        'setter' => 'setSlicing',
        'element' => 'ElementDefinition.Slicing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionSlicing::class,
      ],
      'short' =>
       [
        'setter' => 'setShort',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'definition' =>
       [
        'setter' => 'setDefinition',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'requirements' =>
       [
        'setter' => 'setRequirements',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'alias' =>
       [
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'min' =>
       [
        'setter' => 'setMin',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'max' =>
       [
        'setter' => 'setMax',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'base' =>
       [
        'setter' => 'setBase',
        'element' => 'ElementDefinition.Base',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionBase::class,
      ],
      'contentReference' =>
       [
        'setter' => 'setContentReference',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'ElementDefinition.Type',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionType::class,
      ],
      'defaultValueBase64Binary' =>
       [
        'setter' => 'setDefaultValueBase64Binary',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'defaultValueBoolean' =>
       [
        'setter' => 'setDefaultValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'defaultValueCanonical' =>
       [
        'setter' => 'setDefaultValueCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'defaultValueCode' =>
       [
        'setter' => 'setDefaultValueCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'defaultValueDate' =>
       [
        'setter' => 'setDefaultValueDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'defaultValueDateTime' =>
       [
        'setter' => 'setDefaultValueDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'defaultValueDecimal' =>
       [
        'setter' => 'setDefaultValueDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'defaultValueId' =>
       [
        'setter' => 'setDefaultValueId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'defaultValueInstant' =>
       [
        'setter' => 'setDefaultValueInstant',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'defaultValueInteger' =>
       [
        'setter' => 'setDefaultValueInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'defaultValueMarkdown' =>
       [
        'setter' => 'setDefaultValueMarkdown',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'defaultValueOid' =>
       [
        'setter' => 'setDefaultValueOid',
        'element' => 'oid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIROid::class,
      ],
      'defaultValuePositiveInt' =>
       [
        'setter' => 'setDefaultValuePositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'defaultValueString' =>
       [
        'setter' => 'setDefaultValueString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'defaultValueTime' =>
       [
        'setter' => 'setDefaultValueTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'defaultValueUnsignedInt' =>
       [
        'setter' => 'setDefaultValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'defaultValueUri' =>
       [
        'setter' => 'setDefaultValueUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'defaultValueUrl' =>
       [
        'setter' => 'setDefaultValueUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'defaultValueUuid' =>
       [
        'setter' => 'setDefaultValueUuid',
        'element' => 'uuid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUuid::class,
      ],
      'defaultValueAddress' =>
       [
        'setter' => 'setDefaultValueAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'defaultValueAge' =>
       [
        'setter' => 'setDefaultValueAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'defaultValueAnnotation' =>
       [
        'setter' => 'setDefaultValueAnnotation',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'defaultValueAttachment' =>
       [
        'setter' => 'setDefaultValueAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'defaultValueCodeableConcept' =>
       [
        'setter' => 'setDefaultValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'defaultValueCoding' =>
       [
        'setter' => 'setDefaultValueCoding',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'defaultValueContactPoint' =>
       [
        'setter' => 'setDefaultValueContactPoint',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'defaultValueCount' =>
       [
        'setter' => 'setDefaultValueCount',
        'element' => 'Count',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRCount::class,
      ],
      'defaultValueDistance' =>
       [
        'setter' => 'setDefaultValueDistance',
        'element' => 'Distance',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDistance::class,
      ],
      'defaultValueDuration' =>
       [
        'setter' => 'setDefaultValueDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'defaultValueHumanName' =>
       [
        'setter' => 'setDefaultValueHumanName',
        'element' => 'HumanName',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHumanName::class,
      ],
      'defaultValueIdentifier' =>
       [
        'setter' => 'setDefaultValueIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'defaultValueMoney' =>
       [
        'setter' => 'setDefaultValueMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'defaultValuePeriod' =>
       [
        'setter' => 'setDefaultValuePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'defaultValueQuantity' =>
       [
        'setter' => 'setDefaultValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'defaultValueRange' =>
       [
        'setter' => 'setDefaultValueRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'defaultValueRatio' =>
       [
        'setter' => 'setDefaultValueRatio',
        'element' => 'Ratio',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
      ],
      'defaultValueReference' =>
       [
        'setter' => 'setDefaultValueReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'defaultValueSampledData' =>
       [
        'setter' => 'setDefaultValueSampledData',
        'element' => 'SampledData',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledData::class,
      ],
      'defaultValueSignature' =>
       [
        'setter' => 'setDefaultValueSignature',
        'element' => 'Signature',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class,
      ],
      'defaultValueTiming' =>
       [
        'setter' => 'setDefaultValueTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'defaultValueContactDetail' =>
       [
        'setter' => 'setDefaultValueContactDetail',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'defaultValueContributor' =>
       [
        'setter' => 'setDefaultValueContributor',
        'element' => 'Contributor',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContributor::class,
      ],
      'defaultValueDataRequirement' =>
       [
        'setter' => 'setDefaultValueDataRequirement',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
      'defaultValueExpression' =>
       [
        'setter' => 'setDefaultValueExpression',
        'element' => 'Expression',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
      ],
      'defaultValueParameterDefinition' =>
       [
        'setter' => 'setDefaultValueParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParameterDefinition::class,
      ],
      'defaultValueRelatedArtifact' =>
       [
        'setter' => 'setDefaultValueRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'defaultValueTriggerDefinition' =>
       [
        'setter' => 'setDefaultValueTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class,
      ],
      'defaultValueUsageContext' =>
       [
        'setter' => 'setDefaultValueUsageContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'defaultValueDosage' =>
       [
        'setter' => 'setDefaultValueDosage',
        'element' => 'Dosage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage::class,
      ],
      'meaningWhenMissing' =>
       [
        'setter' => 'setMeaningWhenMissing',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'orderMeaning' =>
       [
        'setter' => 'setOrderMeaning',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'fixedBase64Binary' =>
       [
        'setter' => 'setFixedBase64Binary',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'fixedBoolean' =>
       [
        'setter' => 'setFixedBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'fixedCanonical' =>
       [
        'setter' => 'setFixedCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'fixedCode' =>
       [
        'setter' => 'setFixedCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'fixedDate' =>
       [
        'setter' => 'setFixedDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'fixedDateTime' =>
       [
        'setter' => 'setFixedDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'fixedDecimal' =>
       [
        'setter' => 'setFixedDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'fixedId' =>
       [
        'setter' => 'setFixedId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'fixedInstant' =>
       [
        'setter' => 'setFixedInstant',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'fixedInteger' =>
       [
        'setter' => 'setFixedInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'fixedMarkdown' =>
       [
        'setter' => 'setFixedMarkdown',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'fixedOid' =>
       [
        'setter' => 'setFixedOid',
        'element' => 'oid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIROid::class,
      ],
      'fixedPositiveInt' =>
       [
        'setter' => 'setFixedPositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'fixedString' =>
       [
        'setter' => 'setFixedString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'fixedTime' =>
       [
        'setter' => 'setFixedTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'fixedUnsignedInt' =>
       [
        'setter' => 'setFixedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'fixedUri' =>
       [
        'setter' => 'setFixedUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'fixedUrl' =>
       [
        'setter' => 'setFixedUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'fixedUuid' =>
       [
        'setter' => 'setFixedUuid',
        'element' => 'uuid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUuid::class,
      ],
      'fixedAddress' =>
       [
        'setter' => 'setFixedAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'fixedAge' =>
       [
        'setter' => 'setFixedAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'fixedAnnotation' =>
       [
        'setter' => 'setFixedAnnotation',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'fixedAttachment' =>
       [
        'setter' => 'setFixedAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'fixedCodeableConcept' =>
       [
        'setter' => 'setFixedCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'fixedCoding' =>
       [
        'setter' => 'setFixedCoding',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'fixedContactPoint' =>
       [
        'setter' => 'setFixedContactPoint',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'fixedCount' =>
       [
        'setter' => 'setFixedCount',
        'element' => 'Count',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRCount::class,
      ],
      'fixedDistance' =>
       [
        'setter' => 'setFixedDistance',
        'element' => 'Distance',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDistance::class,
      ],
      'fixedDuration' =>
       [
        'setter' => 'setFixedDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'fixedHumanName' =>
       [
        'setter' => 'setFixedHumanName',
        'element' => 'HumanName',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHumanName::class,
      ],
      'fixedIdentifier' =>
       [
        'setter' => 'setFixedIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'fixedMoney' =>
       [
        'setter' => 'setFixedMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'fixedPeriod' =>
       [
        'setter' => 'setFixedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'fixedQuantity' =>
       [
        'setter' => 'setFixedQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'fixedRange' =>
       [
        'setter' => 'setFixedRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'fixedRatio' =>
       [
        'setter' => 'setFixedRatio',
        'element' => 'Ratio',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
      ],
      'fixedReference' =>
       [
        'setter' => 'setFixedReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'fixedSampledData' =>
       [
        'setter' => 'setFixedSampledData',
        'element' => 'SampledData',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledData::class,
      ],
      'fixedSignature' =>
       [
        'setter' => 'setFixedSignature',
        'element' => 'Signature',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class,
      ],
      'fixedTiming' =>
       [
        'setter' => 'setFixedTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'fixedContactDetail' =>
       [
        'setter' => 'setFixedContactDetail',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'fixedContributor' =>
       [
        'setter' => 'setFixedContributor',
        'element' => 'Contributor',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContributor::class,
      ],
      'fixedDataRequirement' =>
       [
        'setter' => 'setFixedDataRequirement',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
      'fixedExpression' =>
       [
        'setter' => 'setFixedExpression',
        'element' => 'Expression',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
      ],
      'fixedParameterDefinition' =>
       [
        'setter' => 'setFixedParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParameterDefinition::class,
      ],
      'fixedRelatedArtifact' =>
       [
        'setter' => 'setFixedRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'fixedTriggerDefinition' =>
       [
        'setter' => 'setFixedTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class,
      ],
      'fixedUsageContext' =>
       [
        'setter' => 'setFixedUsageContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'fixedDosage' =>
       [
        'setter' => 'setFixedDosage',
        'element' => 'Dosage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage::class,
      ],
      'patternBase64Binary' =>
       [
        'setter' => 'setPatternBase64Binary',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'patternBoolean' =>
       [
        'setter' => 'setPatternBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'patternCanonical' =>
       [
        'setter' => 'setPatternCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'patternCode' =>
       [
        'setter' => 'setPatternCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'patternDate' =>
       [
        'setter' => 'setPatternDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'patternDateTime' =>
       [
        'setter' => 'setPatternDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'patternDecimal' =>
       [
        'setter' => 'setPatternDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'patternId' =>
       [
        'setter' => 'setPatternId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'patternInstant' =>
       [
        'setter' => 'setPatternInstant',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'patternInteger' =>
       [
        'setter' => 'setPatternInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'patternMarkdown' =>
       [
        'setter' => 'setPatternMarkdown',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'patternOid' =>
       [
        'setter' => 'setPatternOid',
        'element' => 'oid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIROid::class,
      ],
      'patternPositiveInt' =>
       [
        'setter' => 'setPatternPositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'patternString' =>
       [
        'setter' => 'setPatternString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'patternTime' =>
       [
        'setter' => 'setPatternTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'patternUnsignedInt' =>
       [
        'setter' => 'setPatternUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'patternUri' =>
       [
        'setter' => 'setPatternUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'patternUrl' =>
       [
        'setter' => 'setPatternUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'patternUuid' =>
       [
        'setter' => 'setPatternUuid',
        'element' => 'uuid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUuid::class,
      ],
      'patternAddress' =>
       [
        'setter' => 'setPatternAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'patternAge' =>
       [
        'setter' => 'setPatternAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'patternAnnotation' =>
       [
        'setter' => 'setPatternAnnotation',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'patternAttachment' =>
       [
        'setter' => 'setPatternAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'patternCodeableConcept' =>
       [
        'setter' => 'setPatternCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'patternCoding' =>
       [
        'setter' => 'setPatternCoding',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'patternContactPoint' =>
       [
        'setter' => 'setPatternContactPoint',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'patternCount' =>
       [
        'setter' => 'setPatternCount',
        'element' => 'Count',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRCount::class,
      ],
      'patternDistance' =>
       [
        'setter' => 'setPatternDistance',
        'element' => 'Distance',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDistance::class,
      ],
      'patternDuration' =>
       [
        'setter' => 'setPatternDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'patternHumanName' =>
       [
        'setter' => 'setPatternHumanName',
        'element' => 'HumanName',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHumanName::class,
      ],
      'patternIdentifier' =>
       [
        'setter' => 'setPatternIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'patternMoney' =>
       [
        'setter' => 'setPatternMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'patternPeriod' =>
       [
        'setter' => 'setPatternPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'patternQuantity' =>
       [
        'setter' => 'setPatternQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'patternRange' =>
       [
        'setter' => 'setPatternRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'patternRatio' =>
       [
        'setter' => 'setPatternRatio',
        'element' => 'Ratio',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
      ],
      'patternReference' =>
       [
        'setter' => 'setPatternReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'patternSampledData' =>
       [
        'setter' => 'setPatternSampledData',
        'element' => 'SampledData',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledData::class,
      ],
      'patternSignature' =>
       [
        'setter' => 'setPatternSignature',
        'element' => 'Signature',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class,
      ],
      'patternTiming' =>
       [
        'setter' => 'setPatternTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'patternContactDetail' =>
       [
        'setter' => 'setPatternContactDetail',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'patternContributor' =>
       [
        'setter' => 'setPatternContributor',
        'element' => 'Contributor',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContributor::class,
      ],
      'patternDataRequirement' =>
       [
        'setter' => 'setPatternDataRequirement',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
      'patternExpression' =>
       [
        'setter' => 'setPatternExpression',
        'element' => 'Expression',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
      ],
      'patternParameterDefinition' =>
       [
        'setter' => 'setPatternParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParameterDefinition::class,
      ],
      'patternRelatedArtifact' =>
       [
        'setter' => 'setPatternRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'patternTriggerDefinition' =>
       [
        'setter' => 'setPatternTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class,
      ],
      'patternUsageContext' =>
       [
        'setter' => 'setPatternUsageContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'patternDosage' =>
       [
        'setter' => 'setPatternDosage',
        'element' => 'Dosage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage::class,
      ],
      'example' =>
       [
        'setter' => 'addExample',
        'element' => 'ElementDefinition.Example',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionExample::class,
      ],
      'minValueDate' =>
       [
        'setter' => 'setMinValueDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'minValueDateTime' =>
       [
        'setter' => 'setMinValueDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'minValueInstant' =>
       [
        'setter' => 'setMinValueInstant',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'minValueTime' =>
       [
        'setter' => 'setMinValueTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'minValueDecimal' =>
       [
        'setter' => 'setMinValueDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'minValueInteger' =>
       [
        'setter' => 'setMinValueInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'minValuePositiveInt' =>
       [
        'setter' => 'setMinValuePositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'minValueUnsignedInt' =>
       [
        'setter' => 'setMinValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'minValueQuantity' =>
       [
        'setter' => 'setMinValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'maxValueDate' =>
       [
        'setter' => 'setMaxValueDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'maxValueDateTime' =>
       [
        'setter' => 'setMaxValueDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'maxValueInstant' =>
       [
        'setter' => 'setMaxValueInstant',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'maxValueTime' =>
       [
        'setter' => 'setMaxValueTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'maxValueDecimal' =>
       [
        'setter' => 'setMaxValueDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'maxValueInteger' =>
       [
        'setter' => 'setMaxValueInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'maxValuePositiveInt' =>
       [
        'setter' => 'setMaxValuePositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'maxValueUnsignedInt' =>
       [
        'setter' => 'setMaxValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'maxValueQuantity' =>
       [
        'setter' => 'setMaxValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'maxLength' =>
       [
        'setter' => 'setMaxLength',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'condition' =>
       [
        'setter' => 'addCondition',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'constraint' =>
       [
        'setter' => 'addConstraint',
        'element' => 'ElementDefinition.Constraint',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionConstraint::class,
      ],
      'mustSupport' =>
       [
        'setter' => 'setMustSupport',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'isModifier' =>
       [
        'setter' => 'setIsModifier',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'isModifierReason' =>
       [
        'setter' => 'setIsModifierReason',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'isSummary' =>
       [
        'setter' => 'setIsSummary',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'binding' =>
       [
        'setter' => 'setBinding',
        'element' => 'ElementDefinition.Binding',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionBinding::class,
      ],
      'mapping' =>
       [
        'setter' => 'addMapping',
        'element' => 'ElementDefinition.Mapping',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionMapping::class,
      ],
    ],
    ],
    'ElementDefinition.Constraint' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionConstraint::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'key' =>
       [
        'setter' => 'setKey',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'requirements' =>
       [
        'setter' => 'setRequirements',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'severity' =>
       [
        'setter' => 'setSeverity',
        'element' => 'ConstraintSeverity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConstraintSeverity::class,
      ],
      'human' =>
       [
        'setter' => 'setHuman',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'expression' =>
       [
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'xpath' =>
       [
        'setter' => 'setXpath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'ElementDefinition.Mapping' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionMapping::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identity' =>
       [
        'setter' => 'setIdentity',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'map' =>
       [
        'setter' => 'setMap',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ElementDefinition.Base' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionBase::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'path' =>
       [
        'setter' => 'setPath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'min' =>
       [
        'setter' => 'setMin',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'max' =>
       [
        'setter' => 'setMax',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ElementDefinition.Type' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionType::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'profile' =>
       [
        'setter' => 'addProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'targetProfile' =>
       [
        'setter' => 'addTargetProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'aggregation' =>
       [
        'setter' => 'addAggregation',
        'element' => 'AggregationMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAggregationMode::class,
      ],
      'versioning' =>
       [
        'setter' => 'setVersioning',
        'element' => 'ReferenceVersionRules',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReferenceVersionRules::class,
      ],
    ],
    ],
    'ElementDefinition.Example' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionExample::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'label' =>
       [
        'setter' => 'setLabel',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueBase64Binary' =>
       [
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'valueBoolean' =>
       [
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'valueCanonical' =>
       [
        'setter' => 'setValueCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'valueCode' =>
       [
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'valueDate' =>
       [
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'valueDateTime' =>
       [
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'valueDecimal' =>
       [
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'valueId' =>
       [
        'setter' => 'setValueId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'valueInstant' =>
       [
        'setter' => 'setValueInstant',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'valueInteger' =>
       [
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'valueMarkdown' =>
       [
        'setter' => 'setValueMarkdown',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'valueOid' =>
       [
        'setter' => 'setValueOid',
        'element' => 'oid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIROid::class,
      ],
      'valuePositiveInt' =>
       [
        'setter' => 'setValuePositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'valueString' =>
       [
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueTime' =>
       [
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'valueUnsignedInt' =>
       [
        'setter' => 'setValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'valueUri' =>
       [
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'valueUrl' =>
       [
        'setter' => 'setValueUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'valueUuid' =>
       [
        'setter' => 'setValueUuid',
        'element' => 'uuid',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUuid::class,
      ],
      'valueAddress' =>
       [
        'setter' => 'setValueAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'valueAge' =>
       [
        'setter' => 'setValueAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'valueAnnotation' =>
       [
        'setter' => 'setValueAnnotation',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'valueAttachment' =>
       [
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'valueCodeableConcept' =>
       [
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueCoding' =>
       [
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'valueContactPoint' =>
       [
        'setter' => 'setValueContactPoint',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'valueCount' =>
       [
        'setter' => 'setValueCount',
        'element' => 'Count',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRCount::class,
      ],
      'valueDistance' =>
       [
        'setter' => 'setValueDistance',
        'element' => 'Distance',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDistance::class,
      ],
      'valueDuration' =>
       [
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'valueHumanName' =>
       [
        'setter' => 'setValueHumanName',
        'element' => 'HumanName',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHumanName::class,
      ],
      'valueIdentifier' =>
       [
        'setter' => 'setValueIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'valueMoney' =>
       [
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'valuePeriod' =>
       [
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueRange' =>
       [
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'valueRatio' =>
       [
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
      ],
      'valueReference' =>
       [
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'valueSampledData' =>
       [
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSampledData::class,
      ],
      'valueSignature' =>
       [
        'setter' => 'setValueSignature',
        'element' => 'Signature',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class,
      ],
      'valueTiming' =>
       [
        'setter' => 'setValueTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'valueContactDetail' =>
       [
        'setter' => 'setValueContactDetail',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'valueContributor' =>
       [
        'setter' => 'setValueContributor',
        'element' => 'Contributor',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContributor::class,
      ],
      'valueDataRequirement' =>
       [
        'setter' => 'setValueDataRequirement',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
      'valueExpression' =>
       [
        'setter' => 'setValueExpression',
        'element' => 'Expression',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
      ],
      'valueParameterDefinition' =>
       [
        'setter' => 'setValueParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParameterDefinition::class,
      ],
      'valueRelatedArtifact' =>
       [
        'setter' => 'setValueRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'valueTriggerDefinition' =>
       [
        'setter' => 'setValueTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class,
      ],
      'valueUsageContext' =>
       [
        'setter' => 'setValueUsageContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'valueDosage' =>
       [
        'setter' => 'setValueDosage',
        'element' => 'Dosage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage::class,
      ],
    ],
    ],
    'ElementDefinition.Slicing' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionSlicing::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'discriminator' =>
       [
        'setter' => 'addDiscriminator',
        'element' => 'ElementDefinition.Discriminator',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionDiscriminator::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'ordered' =>
       [
        'setter' => 'setOrdered',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'rules' =>
       [
        'setter' => 'setRules',
        'element' => 'SlicingRules',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSlicingRules::class,
      ],
    ],
    ],
    'ElementDefinition.Binding' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionBinding::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'strength' =>
       [
        'setter' => 'setStrength',
        'element' => 'BindingStrength',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBindingStrength::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueSet' =>
       [
        'setter' => 'setValueSet',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'ElementDefinition.Discriminator' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRElementDefinition\FHIRElementDefinitionDiscriminator::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'DiscriminatorType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDiscriminatorType::class,
      ],
      'path' =>
       [
        'setter' => 'setPath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'PropertyRepresentation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPropertyRepresentation::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'PropertyRepresentation-list',
        'type' => 'string',
      ],
    ],
    ],
    'ConstraintSeverity' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConstraintSeverity::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ConstraintSeverity-list',
        'type' => 'string',
      ],
    ],
    ],
    'AggregationMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAggregationMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AggregationMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'ReferenceVersionRules' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReferenceVersionRules::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ReferenceVersionRules-list',
        'type' => 'string',
      ],
    ],
    ],
    'SlicingRules' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSlicingRules::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'SlicingRules-list',
        'type' => 'string',
      ],
    ],
    ],
    'BindingStrength' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBindingStrength::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'BindingStrength-list',
        'type' => 'string',
      ],
    ],
    ],
    'DiscriminatorType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDiscriminatorType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DiscriminatorType-list',
        'type' => 'string',
      ],
    ],
    ],
    'DomainResource' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDomainResource::class,
    'extendedElementName' => 'Resource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
    ],
    ],
    'Resource' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource::class,
    'extendedElementName' => null,
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
    ],
    ],
    'PublicationStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'PublicationStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'SearchParamType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSearchParamType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'SearchParamType-list',
        'type' => 'string',
      ],
    ],
    ],
    'AdministrativeGender' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAdministrativeGender::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AdministrativeGender-list',
        'type' => 'string',
      ],
    ],
    ],
    'FHIRVersion' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRVersion::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'FHIRVersion-list',
        'type' => 'string',
      ],
    ],
    ],
    'NoteType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNoteType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'NoteType-list',
        'type' => 'string',
      ],
    ],
    ],
    'RemittanceOutcome' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRemittanceOutcome::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'RemittanceOutcome-list',
        'type' => 'string',
      ],
    ],
    ],
    'ConceptMapEquivalence' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConceptMapEquivalence::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ConceptMapEquivalence-list',
        'type' => 'string',
      ],
    ],
    ],
    'DocumentReferenceStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentReferenceStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DocumentReferenceStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'Account' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAccount::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'AccountStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAccountStatus::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subject' =>
       [
        'setter' => 'addSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'servicePeriod' =>
       [
        'setter' => 'setServicePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'coverage' =>
       [
        'setter' => 'addCoverage',
        'element' => 'Account.Coverage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAccount\FHIRAccountCoverage::class,
      ],
      'owner' =>
       [
        'setter' => 'setOwner',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'guarantor' =>
       [
        'setter' => 'addGuarantor',
        'element' => 'Account.Guarantor',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAccount\FHIRAccountGuarantor::class,
      ],
      'partOf' =>
       [
        'setter' => 'setPartOf',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Account.Coverage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAccount\FHIRAccountCoverage::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'coverage' =>
       [
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
    ],
    ],
    'Account.Guarantor' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAccount\FHIRAccountGuarantor::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'party' =>
       [
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'onHold' =>
       [
        'setter' => 'setOnHold',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'AccountStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAccountStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AccountStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'ActivityDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRActivityDefinition::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subtitle' =>
       [
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'subjectCodeableConcept' =>
       [
        'setter' => 'setSubjectCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subjectReference' =>
       [
        'setter' => 'setSubjectReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'usage' =>
       [
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'approvalDate' =>
       [
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'lastReviewDate' =>
       [
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'topic' =>
       [
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'editor' =>
       [
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'reviewer' =>
       [
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'endorser' =>
       [
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'relatedArtifact' =>
       [
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'library' =>
       [
        'setter' => 'addLibrary',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'kind' =>
       [
        'setter' => 'setKind',
        'element' => 'RequestResourceType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestResourceType::class,
      ],
      'profile' =>
       [
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'intent' =>
       [
        'setter' => 'setIntent',
        'element' => 'RequestIntent',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestIntent::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestPriority::class,
      ],
      'doNotPerform' =>
       [
        'setter' => 'setDoNotPerform',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'timingTiming' =>
       [
        'setter' => 'setTimingTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'timingDateTime' =>
       [
        'setter' => 'setTimingDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'timingAge' =>
       [
        'setter' => 'setTimingAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'timingPeriod' =>
       [
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'timingRange' =>
       [
        'setter' => 'setTimingRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'timingDuration' =>
       [
        'setter' => 'setTimingDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'participant' =>
       [
        'setter' => 'addParticipant',
        'element' => 'ActivityDefinition.Participant',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRActivityDefinition\FHIRActivityDefinitionParticipant::class,
      ],
      'productReference' =>
       [
        'setter' => 'setProductReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'productCodeableConcept' =>
       [
        'setter' => 'setProductCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'dosage' =>
       [
        'setter' => 'addDosage',
        'element' => 'Dosage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDosage::class,
      ],
      'bodySite' =>
       [
        'setter' => 'addBodySite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'specimenRequirement' =>
       [
        'setter' => 'addSpecimenRequirement',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'observationRequirement' =>
       [
        'setter' => 'addObservationRequirement',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'observationResultRequirement' =>
       [
        'setter' => 'addObservationResultRequirement',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'transform' =>
       [
        'setter' => 'setTransform',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'dynamicValue' =>
       [
        'setter' => 'addDynamicValue',
        'element' => 'ActivityDefinition.DynamicValue',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRActivityDefinition\FHIRActivityDefinitionDynamicValue::class,
      ],
    ],
    ],
    'ActivityDefinition.Participant' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRActivityDefinition\FHIRActivityDefinitionParticipant::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'ActionParticipantType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRActionParticipantType::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'ActivityDefinition.DynamicValue' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRActivityDefinition\FHIRActivityDefinitionDynamicValue::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'path' =>
       [
        'setter' => 'setPath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'expression' =>
       [
        'setter' => 'setExpression',
        'element' => 'Expression',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
      ],
    ],
    ],
    'ActionParticipantType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRActionParticipantType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ActionParticipantType-list',
        'type' => 'string',
      ],
    ],
    ],
    'RequestIntent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestIntent::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'RequestIntent-list',
        'type' => 'string',
      ],
    ],
    ],
    'RequestResourceType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestResourceType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'RequestResourceType-list',
        'type' => 'string',
      ],
    ],
    ],
    'RequestPriority' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestPriority::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'RequestPriority-list',
        'type' => 'string',
      ],
    ],
    ],
    'AdverseEvent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAdverseEvent::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'actuality' =>
       [
        'setter' => 'setActuality',
        'element' => 'AdverseEventActuality',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAdverseEventActuality::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'event' =>
       [
        'setter' => 'setEvent',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'detected' =>
       [
        'setter' => 'setDetected',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'recordedDate' =>
       [
        'setter' => 'setRecordedDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'resultingCondition' =>
       [
        'setter' => 'addResultingCondition',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'seriousness' =>
       [
        'setter' => 'setSeriousness',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'severity' =>
       [
        'setter' => 'setSeverity',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'recorder' =>
       [
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'contributor' =>
       [
        'setter' => 'addContributor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'suspectEntity' =>
       [
        'setter' => 'addSuspectEntity',
        'element' => 'AdverseEvent.SuspectEntity',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAdverseEvent\FHIRAdverseEventSuspectEntity::class,
      ],
      'subjectMedicalHistory' =>
       [
        'setter' => 'addSubjectMedicalHistory',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'referenceDocument' =>
       [
        'setter' => 'addReferenceDocument',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'study' =>
       [
        'setter' => 'addStudy',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'AdverseEvent.SuspectEntity' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAdverseEvent\FHIRAdverseEventSuspectEntity::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'instance' =>
       [
        'setter' => 'setInstance',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'causality' =>
       [
        'setter' => 'addCausality',
        'element' => 'AdverseEvent.Causality',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAdverseEvent\FHIRAdverseEventCausality::class,
      ],
    ],
    ],
    'AdverseEvent.Causality' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAdverseEvent\FHIRAdverseEventCausality::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'assessment' =>
       [
        'setter' => 'setAssessment',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productRelatedness' =>
       [
        'setter' => 'setProductRelatedness',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'author' =>
       [
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'method' =>
       [
        'setter' => 'setMethod',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'AdverseEventActuality' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAdverseEventActuality::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AdverseEventActuality-list',
        'type' => 'string',
      ],
    ],
    ],
    'AllergyIntolerance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAllergyIntolerance::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'clinicalStatus' =>
       [
        'setter' => 'setClinicalStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'verificationStatus' =>
       [
        'setter' => 'setVerificationStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'AllergyIntoleranceType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceType::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'AllergyIntoleranceCategory',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceCategory::class,
      ],
      'criticality' =>
       [
        'setter' => 'setCriticality',
        'element' => 'AllergyIntoleranceCriticality',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceCriticality::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'onsetDateTime' =>
       [
        'setter' => 'setOnsetDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'onsetAge' =>
       [
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'onsetPeriod' =>
       [
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'onsetRange' =>
       [
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'onsetString' =>
       [
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'recordedDate' =>
       [
        'setter' => 'setRecordedDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'recorder' =>
       [
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'asserter' =>
       [
        'setter' => 'setAsserter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'lastOccurrence' =>
       [
        'setter' => 'setLastOccurrence',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'reaction' =>
       [
        'setter' => 'addReaction',
        'element' => 'AllergyIntolerance.Reaction',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAllergyIntolerance\FHIRAllergyIntoleranceReaction::class,
      ],
    ],
    ],
    'AllergyIntolerance.Reaction' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAllergyIntolerance\FHIRAllergyIntoleranceReaction::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'substance' =>
       [
        'setter' => 'setSubstance',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'manifestation' =>
       [
        'setter' => 'addManifestation',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'onset' =>
       [
        'setter' => 'setOnset',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'severity' =>
       [
        'setter' => 'setSeverity',
        'element' => 'AllergyIntoleranceSeverity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceSeverity::class,
      ],
      'exposureRoute' =>
       [
        'setter' => 'setExposureRoute',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'AllergyIntoleranceCriticality' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceCriticality::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceCriticality-list',
        'type' => 'string',
      ],
    ],
    ],
    'AllergyIntoleranceType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceType-list',
        'type' => 'string',
      ],
    ],
    ],
    'AllergyIntoleranceCategory' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceCategory::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceCategory-list',
        'type' => 'string',
      ],
    ],
    ],
    'AllergyIntoleranceSeverity' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAllergyIntoleranceSeverity::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceSeverity-list',
        'type' => 'string',
      ],
    ],
    ],
    'Appointment' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAppointment::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'AppointmentStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAppointmentStatus::class,
      ],
      'cancelationReason' =>
       [
        'setter' => 'setCancelationReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'serviceCategory' =>
       [
        'setter' => 'addServiceCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'serviceType' =>
       [
        'setter' => 'addServiceType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'specialty' =>
       [
        'setter' => 'addSpecialty',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'appointmentType' =>
       [
        'setter' => 'setAppointmentType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'supportingInformation' =>
       [
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'start' =>
       [
        'setter' => 'setStart',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'end' =>
       [
        'setter' => 'setEnd',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'minutesDuration' =>
       [
        'setter' => 'setMinutesDuration',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'slot' =>
       [
        'setter' => 'addSlot',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'patientInstruction' =>
       [
        'setter' => 'setPatientInstruction',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'participant' =>
       [
        'setter' => 'addParticipant',
        'element' => 'Appointment.Participant',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAppointment\FHIRAppointmentParticipant::class,
      ],
      'requestedPeriod' =>
       [
        'setter' => 'addRequestedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'Appointment.Participant' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAppointment\FHIRAppointmentParticipant::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'actor' =>
       [
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'required' =>
       [
        'setter' => 'setRequired',
        'element' => 'ParticipantRequired',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParticipantRequired::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ParticipationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParticipationStatus::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'ParticipantRequired' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParticipantRequired::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ParticipantRequired-list',
        'type' => 'string',
      ],
    ],
    ],
    'AppointmentStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAppointmentStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AppointmentStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'ParticipationStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParticipationStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ParticipationStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'AppointmentResponse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAppointmentResponse::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'appointment' =>
       [
        'setter' => 'setAppointment',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'start' =>
       [
        'setter' => 'setStart',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'end' =>
       [
        'setter' => 'setEnd',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'participantType' =>
       [
        'setter' => 'addParticipantType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'actor' =>
       [
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'participantStatus' =>
       [
        'setter' => 'setParticipantStatus',
        'element' => 'ParticipationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParticipationStatus::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'AuditEvent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRAuditEvent::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'subtype' =>
       [
        'setter' => 'addSubtype',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'action' =>
       [
        'setter' => 'setAction',
        'element' => 'AuditEventAction',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventAction::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'recorded' =>
       [
        'setter' => 'setRecorded',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'AuditEventOutcome',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventOutcome::class,
      ],
      'outcomeDesc' =>
       [
        'setter' => 'setOutcomeDesc',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'purposeOfEvent' =>
       [
        'setter' => 'addPurposeOfEvent',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'agent' =>
       [
        'setter' => 'addAgent',
        'element' => 'AuditEvent.Agent',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventAgent::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'AuditEvent.Source',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventSource::class,
      ],
      'entity' =>
       [
        'setter' => 'addEntity',
        'element' => 'AuditEvent.Entity',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventEntity::class,
      ],
    ],
    ],
    'AuditEvent.Agent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventAgent::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'role' =>
       [
        'setter' => 'addRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'who' =>
       [
        'setter' => 'setWho',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'altId' =>
       [
        'setter' => 'setAltId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'requestor' =>
       [
        'setter' => 'setRequestor',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'policy' =>
       [
        'setter' => 'addPolicy',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'media' =>
       [
        'setter' => 'setMedia',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'network' =>
       [
        'setter' => 'setNetwork',
        'element' => 'AuditEvent.Network',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventNetwork::class,
      ],
      'purposeOfUse' =>
       [
        'setter' => 'addPurposeOfUse',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'AuditEvent.Network' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventNetwork::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'address' =>
       [
        'setter' => 'setAddress',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'AuditEventAgentNetworkType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventAgentNetworkType::class,
      ],
    ],
    ],
    'AuditEvent.Source' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventSource::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'site' =>
       [
        'setter' => 'setSite',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'observer' =>
       [
        'setter' => 'setObserver',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
    ],
    ],
    'AuditEvent.Entity' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventEntity::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'what' =>
       [
        'setter' => 'setWhat',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'lifecycle' =>
       [
        'setter' => 'setLifecycle',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'securityLabel' =>
       [
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'query' =>
       [
        'setter' => 'setQuery',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'AuditEvent.Detail',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventDetail::class,
      ],
    ],
    ],
    'AuditEvent.Detail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRAuditEvent\FHIRAuditEventDetail::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueString' =>
       [
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueBase64Binary' =>
       [
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
    ],
    ],
    'AuditEventOutcome' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventOutcome::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AuditEventOutcome-list',
        'type' => 'string',
      ],
    ],
    ],
    'AuditEventAction' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventAction::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AuditEventAction-list',
        'type' => 'string',
      ],
    ],
    ],
    'AuditEventAgentNetworkType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAuditEventAgentNetworkType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'AuditEventAgentNetworkType-list',
        'type' => 'string',
      ],
    ],
    ],
    'Basic' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBasic::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'author' =>
       [
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Binary' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBinary::class,
    'extendedElementName' => 'Resource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'contentType' =>
       [
        'setter' => 'setContentType',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'securityContext' =>
       [
        'setter' => 'setSecurityContext',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'data' =>
       [
        'setter' => 'setData',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
    ],
    ],
    'BiologicallyDerivedProduct' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBiologicallyDerivedProduct::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'productCategory' =>
       [
        'setter' => 'setProductCategory',
        'element' => 'BiologicallyDerivedProductCategory',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductCategory::class,
      ],
      'productCode' =>
       [
        'setter' => 'setProductCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'BiologicallyDerivedProductStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductStatus::class,
      ],
      'request' =>
       [
        'setter' => 'addRequest',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'parent' =>
       [
        'setter' => 'addParent',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'collection' =>
       [
        'setter' => 'setCollection',
        'element' => 'BiologicallyDerivedProduct.Collection',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductCollection::class,
      ],
      'processing' =>
       [
        'setter' => 'addProcessing',
        'element' => 'BiologicallyDerivedProduct.Processing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductProcessing::class,
      ],
      'manipulation' =>
       [
        'setter' => 'setManipulation',
        'element' => 'BiologicallyDerivedProduct.Manipulation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductManipulation::class,
      ],
      'storage' =>
       [
        'setter' => 'addStorage',
        'element' => 'BiologicallyDerivedProduct.Storage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductStorage::class,
      ],
    ],
    ],
    'BiologicallyDerivedProduct.Collection' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductCollection::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'collector' =>
       [
        'setter' => 'setCollector',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'collectedDateTime' =>
       [
        'setter' => 'setCollectedDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'collectedPeriod' =>
       [
        'setter' => 'setCollectedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'BiologicallyDerivedProduct.Processing' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductProcessing::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'procedure' =>
       [
        'setter' => 'setProcedure',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'additive' =>
       [
        'setter' => 'setAdditive',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'timeDateTime' =>
       [
        'setter' => 'setTimeDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'timePeriod' =>
       [
        'setter' => 'setTimePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'BiologicallyDerivedProduct.Manipulation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductManipulation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'timeDateTime' =>
       [
        'setter' => 'setTimeDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'timePeriod' =>
       [
        'setter' => 'setTimePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'BiologicallyDerivedProduct.Storage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBiologicallyDerivedProduct\FHIRBiologicallyDerivedProductStorage::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'temperature' =>
       [
        'setter' => 'setTemperature',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'scale' =>
       [
        'setter' => 'setScale',
        'element' => 'BiologicallyDerivedProductStorageScale',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductStorageScale::class,
      ],
      'duration' =>
       [
        'setter' => 'setDuration',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'BiologicallyDerivedProductCategory' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductCategory::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'BiologicallyDerivedProductCategory-list',
        'type' => 'string',
      ],
    ],
    ],
    'BiologicallyDerivedProductStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'BiologicallyDerivedProductStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'BiologicallyDerivedProductStorageScale' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBiologicallyDerivedProductStorageScale::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'BiologicallyDerivedProductStorageScale-list',
        'type' => 'string',
      ],
    ],
    ],
    'BodyStructure' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRBodyStructure::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'active' =>
       [
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'morphology' =>
       [
        'setter' => 'setMorphology',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'locationQualifier' =>
       [
        'setter' => 'addLocationQualifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'image' =>
       [
        'setter' => 'addImage',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Bundle' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle::class,
    'extendedElementName' => 'Resource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'BundleType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBundleType::class,
      ],
      'timestamp' =>
       [
        'setter' => 'setTimestamp',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'total' =>
       [
        'setter' => 'setTotal',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'link' =>
       [
        'setter' => 'addLink',
        'element' => 'Bundle.Link',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleLink::class,
      ],
      'entry' =>
       [
        'setter' => 'addEntry',
        'element' => 'Bundle.Entry',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleEntry::class,
      ],
      'signature' =>
       [
        'setter' => 'setSignature',
        'element' => 'Signature',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class,
      ],
    ],
    ],
    'Bundle.Link' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleLink::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'relation' =>
       [
        'setter' => 'setRelation',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
    ],
    ],
    'Bundle.Entry' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleEntry::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'link' =>
       [
        'setter' => 'addLink',
        'element' => 'Bundle.Link',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleLink::class,
      ],
      'fullUrl' =>
       [
        'setter' => 'setFullUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'resource' =>
       [
        'setter' => 'setResource',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'search' =>
       [
        'setter' => 'setSearch',
        'element' => 'Bundle.Search',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleSearch::class,
      ],
      'request' =>
       [
        'setter' => 'setRequest',
        'element' => 'Bundle.Request',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleRequest::class,
      ],
      'response' =>
       [
        'setter' => 'setResponse',
        'element' => 'Bundle.Response',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleResponse::class,
      ],
    ],
    ],
    'Bundle.Search' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleSearch::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'SearchEntryMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSearchEntryMode::class,
      ],
      'score' =>
       [
        'setter' => 'setScore',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
    ],
    ],
    'Bundle.Request' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleRequest::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'method' =>
       [
        'setter' => 'setMethod',
        'element' => 'HTTPVerb',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHTTPVerb::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'ifNoneMatch' =>
       [
        'setter' => 'setIfNoneMatch',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'ifModifiedSince' =>
       [
        'setter' => 'setIfModifiedSince',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'ifMatch' =>
       [
        'setter' => 'setIfMatch',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'ifNoneExist' =>
       [
        'setter' => 'setIfNoneExist',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'Bundle.Response' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRBundle\FHIRBundleResponse::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'etag' =>
       [
        'setter' => 'setEtag',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'lastModified' =>
       [
        'setter' => 'setLastModified',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
    ],
    ],
    'HTTPVerb' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHTTPVerb::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'HTTPVerb-list',
        'type' => 'string',
      ],
    ],
    ],
    'BundleType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBundleType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'BundleType-list',
        'type' => 'string',
      ],
    ],
    ],
    'SearchEntryMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSearchEntryMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'SearchEntryMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'CapabilityStatement' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCapabilityStatement::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'kind' =>
       [
        'setter' => 'setKind',
        'element' => 'CapabilityStatementKind',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCapabilityStatementKind::class,
      ],
      'instantiates' =>
       [
        'setter' => 'addInstantiates',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'imports' =>
       [
        'setter' => 'addImports',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'software' =>
       [
        'setter' => 'setSoftware',
        'element' => 'CapabilityStatement.Software',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSoftware::class,
      ],
      'implementation' =>
       [
        'setter' => 'setImplementation',
        'element' => 'CapabilityStatement.Implementation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementImplementation::class,
      ],
      'fhirVersion' =>
       [
        'setter' => 'setFhirVersion',
        'element' => 'FHIRVersion',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRVersion::class,
      ],
      'format' =>
       [
        'setter' => 'addFormat',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'patchFormat' =>
       [
        'setter' => 'addPatchFormat',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'implementationGuide' =>
       [
        'setter' => 'addImplementationGuide',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'rest' =>
       [
        'setter' => 'addRest',
        'element' => 'CapabilityStatement.Rest',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementRest::class,
      ],
      'messaging' =>
       [
        'setter' => 'addMessaging',
        'element' => 'CapabilityStatement.Messaging',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementMessaging::class,
      ],
      'document' =>
       [
        'setter' => 'addDocument',
        'element' => 'CapabilityStatement.Document',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementDocument::class,
      ],
    ],
    ],
    'CapabilityStatement.Software' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSoftware::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'releaseDate' =>
       [
        'setter' => 'setReleaseDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
    ],
    ],
    'CapabilityStatement.Implementation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementImplementation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'custodian' =>
       [
        'setter' => 'setCustodian',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'CapabilityStatement.Rest' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementRest::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'RestfulCapabilityMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRestfulCapabilityMode::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'security' =>
       [
        'setter' => 'setSecurity',
        'element' => 'CapabilityStatement.Security',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSecurity::class,
      ],
      'resource' =>
       [
        'setter' => 'addResource',
        'element' => 'CapabilityStatement.Resource',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementResource::class,
      ],
      'interaction' =>
       [
        'setter' => 'addInteraction',
        'element' => 'CapabilityStatement.Interaction1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementInteraction1::class,
      ],
      'searchParam' =>
       [
        'setter' => 'addSearchParam',
        'element' => 'CapabilityStatement.SearchParam',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSearchParam::class,
      ],
      'operation' =>
       [
        'setter' => 'addOperation',
        'element' => 'CapabilityStatement.Operation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementOperation::class,
      ],
      'compartment' =>
       [
        'setter' => 'addCompartment',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'CapabilityStatement.Security' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSecurity::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'cors' =>
       [
        'setter' => 'setCors',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'service' =>
       [
        'setter' => 'addService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'CapabilityStatement.Resource' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementResource::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'profile' =>
       [
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'supportedProfile' =>
       [
        'setter' => 'addSupportedProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'interaction' =>
       [
        'setter' => 'addInteraction',
        'element' => 'CapabilityStatement.Interaction',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementInteraction::class,
      ],
      'versioning' =>
       [
        'setter' => 'setVersioning',
        'element' => 'ResourceVersionPolicy',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRResourceVersionPolicy::class,
      ],
      'readHistory' =>
       [
        'setter' => 'setReadHistory',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'updateCreate' =>
       [
        'setter' => 'setUpdateCreate',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'conditionalCreate' =>
       [
        'setter' => 'setConditionalCreate',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'conditionalRead' =>
       [
        'setter' => 'setConditionalRead',
        'element' => 'ConditionalReadStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConditionalReadStatus::class,
      ],
      'conditionalUpdate' =>
       [
        'setter' => 'setConditionalUpdate',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'conditionalDelete' =>
       [
        'setter' => 'setConditionalDelete',
        'element' => 'ConditionalDeleteStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConditionalDeleteStatus::class,
      ],
      'referencePolicy' =>
       [
        'setter' => 'addReferencePolicy',
        'element' => 'ReferenceHandlingPolicy',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReferenceHandlingPolicy::class,
      ],
      'searchInclude' =>
       [
        'setter' => 'addSearchInclude',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'searchRevInclude' =>
       [
        'setter' => 'addSearchRevInclude',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'searchParam' =>
       [
        'setter' => 'addSearchParam',
        'element' => 'CapabilityStatement.SearchParam',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSearchParam::class,
      ],
      'operation' =>
       [
        'setter' => 'addOperation',
        'element' => 'CapabilityStatement.Operation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementOperation::class,
      ],
    ],
    ],
    'CapabilityStatement.Interaction' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementInteraction::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'TypeRestfulInteraction',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTypeRestfulInteraction::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'CapabilityStatement.SearchParam' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSearchParam::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'definition' =>
       [
        'setter' => 'setDefinition',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'SearchParamType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSearchParamType::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'CapabilityStatement.Operation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementOperation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'definition' =>
       [
        'setter' => 'setDefinition',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'CapabilityStatement.Interaction1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementInteraction1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'SystemRestfulInteraction',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSystemRestfulInteraction::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'CapabilityStatement.Messaging' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementMessaging::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'endpoint' =>
       [
        'setter' => 'addEndpoint',
        'element' => 'CapabilityStatement.Endpoint',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementEndpoint::class,
      ],
      'reliableCache' =>
       [
        'setter' => 'setReliableCache',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'supportedMessage' =>
       [
        'setter' => 'addSupportedMessage',
        'element' => 'CapabilityStatement.SupportedMessage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSupportedMessage::class,
      ],
    ],
    ],
    'CapabilityStatement.Endpoint' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementEndpoint::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'protocol' =>
       [
        'setter' => 'setProtocol',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'address' =>
       [
        'setter' => 'setAddress',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
    ],
    ],
    'CapabilityStatement.SupportedMessage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementSupportedMessage::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'EventCapabilityMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREventCapabilityMode::class,
      ],
      'definition' =>
       [
        'setter' => 'setDefinition',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'CapabilityStatement.Document' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCapabilityStatement\FHIRCapabilityStatementDocument::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'DocumentMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentMode::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'profile' =>
       [
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'CapabilityStatementKind' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCapabilityStatementKind::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CapabilityStatementKind-list',
        'type' => 'string',
      ],
    ],
    ],
    'EventCapabilityMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREventCapabilityMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EventCapabilityMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'ResourceVersionPolicy' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRResourceVersionPolicy::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ResourceVersionPolicy-list',
        'type' => 'string',
      ],
    ],
    ],
    'DocumentMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DocumentMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'RestfulCapabilityMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRestfulCapabilityMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'RestfulCapabilityMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'TypeRestfulInteraction' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTypeRestfulInteraction::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'TypeRestfulInteraction-list',
        'type' => 'string',
      ],
    ],
    ],
    'SystemRestfulInteraction' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSystemRestfulInteraction::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'SystemRestfulInteraction-list',
        'type' => 'string',
      ],
    ],
    ],
    'ConditionalReadStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConditionalReadStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ConditionalReadStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'ReferenceHandlingPolicy' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReferenceHandlingPolicy::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ReferenceHandlingPolicy-list',
        'type' => 'string',
      ],
    ],
    ],
    'ConditionalDeleteStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConditionalDeleteStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ConditionalDeleteStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'CarePlan' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCarePlan::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'instantiatesCanonical' =>
       [
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'instantiatesUri' =>
       [
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'replaces' =>
       [
        'setter' => 'addReplaces',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'partOf' =>
       [
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'RequestStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestStatus::class,
      ],
      'intent' =>
       [
        'setter' => 'setIntent',
        'element' => 'CarePlanIntent',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanIntent::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'author' =>
       [
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'contributor' =>
       [
        'setter' => 'addContributor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'careTeam' =>
       [
        'setter' => 'addCareTeam',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'addresses' =>
       [
        'setter' => 'addAddresses',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'supportingInfo' =>
       [
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'goal' =>
       [
        'setter' => 'addGoal',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'activity' =>
       [
        'setter' => 'addActivity',
        'element' => 'CarePlan.Activity',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCarePlan\FHIRCarePlanActivity::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'CarePlan.Activity' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCarePlan\FHIRCarePlanActivity::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'outcomeCodeableConcept' =>
       [
        'setter' => 'addOutcomeCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'outcomeReference' =>
       [
        'setter' => 'addOutcomeReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'progress' =>
       [
        'setter' => 'addProgress',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'detail' =>
       [
        'setter' => 'setDetail',
        'element' => 'CarePlan.Detail',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCarePlan\FHIRCarePlanDetail::class,
      ],
    ],
    ],
    'CarePlan.Detail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCarePlan\FHIRCarePlanDetail::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'kind' =>
       [
        'setter' => 'setKind',
        'element' => 'CarePlanActivityKind',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanActivityKind::class,
      ],
      'instantiatesCanonical' =>
       [
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'instantiatesUri' =>
       [
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'goal' =>
       [
        'setter' => 'addGoal',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'CarePlanActivityStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanActivityStatus::class,
      ],
      'statusReason' =>
       [
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'doNotPerform' =>
       [
        'setter' => 'setDoNotPerform',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'scheduledTiming' =>
       [
        'setter' => 'setScheduledTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'scheduledPeriod' =>
       [
        'setter' => 'setScheduledPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'scheduledString' =>
       [
        'setter' => 'setScheduledString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'performer' =>
       [
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'productCodeableConcept' =>
       [
        'setter' => 'setProductCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productReference' =>
       [
        'setter' => 'setProductReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'dailyAmount' =>
       [
        'setter' => 'setDailyAmount',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'CarePlanActivityKind' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanActivityKind::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CarePlanActivityKind-list',
        'type' => 'string',
      ],
    ],
    ],
    'CarePlanActivityStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanActivityStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CarePlanActivityStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'CarePlanIntent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCarePlanIntent::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CarePlanIntent-list',
        'type' => 'string',
      ],
    ],
    ],
    'RequestStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'RequestStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'CareTeam' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCareTeam::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'CareTeamStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCareTeamStatus::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'participant' =>
       [
        'setter' => 'addParticipant',
        'element' => 'CareTeam.Participant',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCareTeam\FHIRCareTeamParticipant::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'managingOrganization' =>
       [
        'setter' => 'addManagingOrganization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'telecom' =>
       [
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'CareTeam.Participant' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCareTeam\FHIRCareTeamParticipant::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'role' =>
       [
        'setter' => 'addRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'member' =>
       [
        'setter' => 'setMember',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'onBehalfOf' =>
       [
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'CareTeamStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCareTeamStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CareTeamStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'CatalogEntry' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCatalogEntry::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'orderable' =>
       [
        'setter' => 'setOrderable',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'referencedItem' =>
       [
        'setter' => 'setReferencedItem',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'additionalIdentifier' =>
       [
        'setter' => 'addAdditionalIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'classification' =>
       [
        'setter' => 'addClassification',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'validityPeriod' =>
       [
        'setter' => 'setValidityPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'validTo' =>
       [
        'setter' => 'setValidTo',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'lastUpdated' =>
       [
        'setter' => 'setLastUpdated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'additionalCharacteristic' =>
       [
        'setter' => 'addAdditionalCharacteristic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'additionalClassification' =>
       [
        'setter' => 'addAdditionalClassification',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'relatedEntry' =>
       [
        'setter' => 'addRelatedEntry',
        'element' => 'CatalogEntry.RelatedEntry',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCatalogEntry\FHIRCatalogEntryRelatedEntry::class,
      ],
    ],
    ],
    'CatalogEntry.RelatedEntry' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCatalogEntry\FHIRCatalogEntryRelatedEntry::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'relationtype' =>
       [
        'setter' => 'setRelationtype',
        'element' => 'CatalogEntryRelationType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCatalogEntryRelationType::class,
      ],
      'item' =>
       [
        'setter' => 'setItem',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'CatalogEntryRelationType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCatalogEntryRelationType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CatalogEntryRelationType-list',
        'type' => 'string',
      ],
    ],
    ],
    'ChargeItem' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRChargeItem::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'definitionUri' =>
       [
        'setter' => 'addDefinitionUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'definitionCanonical' =>
       [
        'setter' => 'addDefinitionCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ChargeItemStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRChargeItemStatus::class,
      ],
      'partOf' =>
       [
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'context' =>
       [
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'occurrenceDateTime' =>
       [
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'occurrencePeriod' =>
       [
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'occurrenceTiming' =>
       [
        'setter' => 'setOccurrenceTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'performer' =>
       [
        'setter' => 'addPerformer',
        'element' => 'ChargeItem.Performer',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItem\FHIRChargeItemPerformer::class,
      ],
      'performingOrganization' =>
       [
        'setter' => 'setPerformingOrganization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'requestingOrganization' =>
       [
        'setter' => 'setRequestingOrganization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'costCenter' =>
       [
        'setter' => 'setCostCenter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'bodysite' =>
       [
        'setter' => 'addBodysite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'factorOverride' =>
       [
        'setter' => 'setFactorOverride',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'priceOverride' =>
       [
        'setter' => 'setPriceOverride',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'overrideReason' =>
       [
        'setter' => 'setOverrideReason',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'enterer' =>
       [
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'enteredDate' =>
       [
        'setter' => 'setEnteredDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'reason' =>
       [
        'setter' => 'addReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'service' =>
       [
        'setter' => 'addService',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'productReference' =>
       [
        'setter' => 'setProductReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'productCodeableConcept' =>
       [
        'setter' => 'setProductCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'account' =>
       [
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'supportingInformation' =>
       [
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ChargeItem.Performer' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItem\FHIRChargeItemPerformer::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'function' =>
       [
        'setter' => 'setFunction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'actor' =>
       [
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ChargeItemStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRChargeItemStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ChargeItemStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'ChargeItemDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRChargeItemDefinition::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'derivedFromUri' =>
       [
        'setter' => 'addDerivedFromUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'partOf' =>
       [
        'setter' => 'addPartOf',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'replaces' =>
       [
        'setter' => 'addReplaces',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'approvalDate' =>
       [
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'lastReviewDate' =>
       [
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'instance' =>
       [
        'setter' => 'addInstance',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'applicability' =>
       [
        'setter' => 'addApplicability',
        'element' => 'ChargeItemDefinition.Applicability',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionApplicability::class,
      ],
      'propertyGroup' =>
       [
        'setter' => 'addPropertyGroup',
        'element' => 'ChargeItemDefinition.PropertyGroup',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionPropertyGroup::class,
      ],
    ],
    ],
    'ChargeItemDefinition.Applicability' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionApplicability::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'expression' =>
       [
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ChargeItemDefinition.PropertyGroup' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionPropertyGroup::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'applicability' =>
       [
        'setter' => 'addApplicability',
        'element' => 'ChargeItemDefinition.Applicability',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionApplicability::class,
      ],
      'priceComponent' =>
       [
        'setter' => 'addPriceComponent',
        'element' => 'ChargeItemDefinition.PriceComponent',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionPriceComponent::class,
      ],
    ],
    ],
    'ChargeItemDefinition.PriceComponent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRChargeItemDefinition\FHIRChargeItemDefinitionPriceComponent::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'InvoicePriceComponentType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInvoicePriceComponentType::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'amount' =>
       [
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
    ],
    ],
    'InvoicePriceComponentType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInvoicePriceComponentType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'InvoicePriceComponentType-list',
        'type' => 'string',
      ],
    ],
    ],
    'Claim' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClaim::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subType' =>
       [
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'Use',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUse::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'billablePeriod' =>
       [
        'setter' => 'setBillablePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'enterer' =>
       [
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'insurer' =>
       [
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'provider' =>
       [
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'fundsReserve' =>
       [
        'setter' => 'setFundsReserve',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'related' =>
       [
        'setter' => 'addRelated',
        'element' => 'Claim.Related',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimRelated::class,
      ],
      'prescription' =>
       [
        'setter' => 'setPrescription',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'originalPrescription' =>
       [
        'setter' => 'setOriginalPrescription',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'payee' =>
       [
        'setter' => 'setPayee',
        'element' => 'Claim.Payee',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimPayee::class,
      ],
      'referral' =>
       [
        'setter' => 'setReferral',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'facility' =>
       [
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'careTeam' =>
       [
        'setter' => 'addCareTeam',
        'element' => 'Claim.CareTeam',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimCareTeam::class,
      ],
      'supportingInfo' =>
       [
        'setter' => 'addSupportingInfo',
        'element' => 'Claim.SupportingInfo',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimSupportingInfo::class,
      ],
      'diagnosis' =>
       [
        'setter' => 'addDiagnosis',
        'element' => 'Claim.Diagnosis',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimDiagnosis::class,
      ],
      'procedure' =>
       [
        'setter' => 'addProcedure',
        'element' => 'Claim.Procedure',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimProcedure::class,
      ],
      'insurance' =>
       [
        'setter' => 'addInsurance',
        'element' => 'Claim.Insurance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimInsurance::class,
      ],
      'accident' =>
       [
        'setter' => 'setAccident',
        'element' => 'Claim.Accident',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimAccident::class,
      ],
      'item' =>
       [
        'setter' => 'addItem',
        'element' => 'Claim.Item',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimItem::class,
      ],
      'total' =>
       [
        'setter' => 'setTotal',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
    ],
    ],
    'Claim.Related' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimRelated::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'claim' =>
       [
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'relationship' =>
       [
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
    ],
    ],
    'Claim.Payee' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimPayee::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'party' =>
       [
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Claim.CareTeam' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimCareTeam::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'provider' =>
       [
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'responsible' =>
       [
        'setter' => 'setResponsible',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'qualification' =>
       [
        'setter' => 'setQualification',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Claim.SupportingInfo' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimSupportingInfo::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'timingDate' =>
       [
        'setter' => 'setTimingDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'timingPeriod' =>
       [
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'valueBoolean' =>
       [
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'valueString' =>
       [
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueAttachment' =>
       [
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'valueReference' =>
       [
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reason' =>
       [
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Claim.Diagnosis' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimDiagnosis::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'diagnosisCodeableConcept' =>
       [
        'setter' => 'setDiagnosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'diagnosisReference' =>
       [
        'setter' => 'setDiagnosisReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'onAdmission' =>
       [
        'setter' => 'setOnAdmission',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'packageCode' =>
       [
        'setter' => 'setPackageCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Claim.Procedure' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimProcedure::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'procedureCodeableConcept' =>
       [
        'setter' => 'setProcedureCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'procedureReference' =>
       [
        'setter' => 'setProcedureReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'udi' =>
       [
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Claim.Insurance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimInsurance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'focal' =>
       [
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'coverage' =>
       [
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'businessArrangement' =>
       [
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'preAuthRef' =>
       [
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'claimResponse' =>
       [
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Claim.Accident' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimAccident::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'locationAddress' =>
       [
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'locationReference' =>
       [
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Claim.Item' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'careTeamSequence' =>
       [
        'setter' => 'addCareTeamSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'diagnosisSequence' =>
       [
        'setter' => 'addDiagnosisSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'procedureSequence' =>
       [
        'setter' => 'addProcedureSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'informationSequence' =>
       [
        'setter' => 'addInformationSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'revenue' =>
       [
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'programCode' =>
       [
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'servicedDate' =>
       [
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'servicedPeriod' =>
       [
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'locationCodeableConcept' =>
       [
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'locationAddress' =>
       [
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'locationReference' =>
       [
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'udi' =>
       [
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'bodySite' =>
       [
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subSite' =>
       [
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'encounter' =>
       [
        'setter' => 'addEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'Claim.Detail',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimDetail::class,
      ],
    ],
    ],
    'Claim.Detail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimDetail::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'revenue' =>
       [
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'programCode' =>
       [
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'udi' =>
       [
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'subDetail' =>
       [
        'setter' => 'addSubDetail',
        'element' => 'Claim.SubDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimSubDetail::class,
      ],
    ],
    ],
    'Claim.SubDetail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaim\FHIRClaimSubDetail::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'revenue' =>
       [
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'programCode' =>
       [
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'udi' =>
       [
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Use' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUse::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'Use-list',
        'type' => 'string',
      ],
    ],
    ],
    'FinancialResourceStatusCodes' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'FinancialResourceStatusCodes-list',
        'type' => 'string',
      ],
    ],
    ],
    'ClaimResponse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClaimResponse::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subType' =>
       [
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'Use',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUse::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'insurer' =>
       [
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'requestor' =>
       [
        'setter' => 'setRequestor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'request' =>
       [
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'ClaimProcessingCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRClaimProcessingCodes::class,
      ],
      'disposition' =>
       [
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'preAuthRef' =>
       [
        'setter' => 'setPreAuthRef',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'preAuthPeriod' =>
       [
        'setter' => 'setPreAuthPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'payeeType' =>
       [
        'setter' => 'setPayeeType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'item' =>
       [
        'setter' => 'addItem',
        'element' => 'ClaimResponse.Item',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseItem::class,
      ],
      'addItem' =>
       [
        'setter' => 'addAddItem',
        'element' => 'ClaimResponse.AddItem',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAddItem::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class,
      ],
      'total' =>
       [
        'setter' => 'addTotal',
        'element' => 'ClaimResponse.Total',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseTotal::class,
      ],
      'payment' =>
       [
        'setter' => 'setPayment',
        'element' => 'ClaimResponse.Payment',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponsePayment::class,
      ],
      'fundsReserve' =>
       [
        'setter' => 'setFundsReserve',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'formCode' =>
       [
        'setter' => 'setFormCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'form' =>
       [
        'setter' => 'setForm',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'processNote' =>
       [
        'setter' => 'addProcessNote',
        'element' => 'ClaimResponse.ProcessNote',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseProcessNote::class,
      ],
      'communicationRequest' =>
       [
        'setter' => 'addCommunicationRequest',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'insurance' =>
       [
        'setter' => 'addInsurance',
        'element' => 'ClaimResponse.Insurance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseInsurance::class,
      ],
      'error' =>
       [
        'setter' => 'addError',
        'element' => 'ClaimResponse.Error',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseError::class,
      ],
    ],
    ],
    'ClaimResponse.Item' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'itemSequence' =>
       [
        'setter' => 'setItemSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'ClaimResponse.Detail',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseDetail::class,
      ],
    ],
    ],
    'ClaimResponse.Adjudication' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reason' =>
       [
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'amount' =>
       [
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
    ],
    ],
    'ClaimResponse.Detail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseDetail::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'detailSequence' =>
       [
        'setter' => 'setDetailSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class,
      ],
      'subDetail' =>
       [
        'setter' => 'addSubDetail',
        'element' => 'ClaimResponse.SubDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseSubDetail::class,
      ],
    ],
    ],
    'ClaimResponse.SubDetail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseSubDetail::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'subDetailSequence' =>
       [
        'setter' => 'setSubDetailSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class,
      ],
    ],
    ],
    'ClaimResponse.AddItem' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAddItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'itemSequence' =>
       [
        'setter' => 'addItemSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'detailSequence' =>
       [
        'setter' => 'addDetailSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'subdetailSequence' =>
       [
        'setter' => 'addSubdetailSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'provider' =>
       [
        'setter' => 'addProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'programCode' =>
       [
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'servicedDate' =>
       [
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'servicedPeriod' =>
       [
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'locationCodeableConcept' =>
       [
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'locationAddress' =>
       [
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'locationReference' =>
       [
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'bodySite' =>
       [
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subSite' =>
       [
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'ClaimResponse.Detail1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseDetail1::class,
      ],
    ],
    ],
    'ClaimResponse.Detail1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseDetail1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class,
      ],
      'subDetail' =>
       [
        'setter' => 'addSubDetail',
        'element' => 'ClaimResponse.SubDetail1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseSubDetail1::class,
      ],
    ],
    ],
    'ClaimResponse.SubDetail1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseSubDetail1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseAdjudication::class,
      ],
    ],
    ],
    'ClaimResponse.Total' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseTotal::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'amount' =>
       [
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
    ],
    ],
    'ClaimResponse.Payment' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponsePayment::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'adjustment' =>
       [
        'setter' => 'setAdjustment',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'adjustmentReason' =>
       [
        'setter' => 'setAdjustmentReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'amount' =>
       [
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
    ],
    ],
    'ClaimResponse.ProcessNote' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseProcessNote::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'number' =>
       [
        'setter' => 'setNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'NoteType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNoteType::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'ClaimResponse.Insurance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseInsurance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'focal' =>
       [
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'coverage' =>
       [
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'businessArrangement' =>
       [
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'claimResponse' =>
       [
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ClaimResponse.Error' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClaimResponse\FHIRClaimResponseError::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'itemSequence' =>
       [
        'setter' => 'setItemSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'detailSequence' =>
       [
        'setter' => 'setDetailSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'subDetailSequence' =>
       [
        'setter' => 'setSubDetailSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'ClaimProcessingCodes' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRClaimProcessingCodes::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ClaimProcessingCodes-list',
        'type' => 'string',
      ],
    ],
    ],
    'ClinicalImpression' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRClinicalImpression::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ClinicalImpressionStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRClinicalImpressionStatus::class,
      ],
      'statusReason' =>
       [
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'effectiveDateTime' =>
       [
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'assessor' =>
       [
        'setter' => 'setAssessor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'previous' =>
       [
        'setter' => 'setPrevious',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'problem' =>
       [
        'setter' => 'addProblem',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'investigation' =>
       [
        'setter' => 'addInvestigation',
        'element' => 'ClinicalImpression.Investigation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClinicalImpression\FHIRClinicalImpressionInvestigation::class,
      ],
      'protocol' =>
       [
        'setter' => 'addProtocol',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'summary' =>
       [
        'setter' => 'setSummary',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'finding' =>
       [
        'setter' => 'addFinding',
        'element' => 'ClinicalImpression.Finding',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClinicalImpression\FHIRClinicalImpressionFinding::class,
      ],
      'prognosisCodeableConcept' =>
       [
        'setter' => 'addPrognosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'prognosisReference' =>
       [
        'setter' => 'addPrognosisReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'supportingInfo' =>
       [
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'ClinicalImpression.Investigation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClinicalImpression\FHIRClinicalImpressionInvestigation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'item' =>
       [
        'setter' => 'addItem',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ClinicalImpression.Finding' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRClinicalImpression\FHIRClinicalImpressionFinding::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'itemCodeableConcept' =>
       [
        'setter' => 'setItemCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'itemReference' =>
       [
        'setter' => 'setItemReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'basis' =>
       [
        'setter' => 'setBasis',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ClinicalImpressionStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRClinicalImpressionStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ClinicalImpressionStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'CodeSystem' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCodeSystem::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'caseSensitive' =>
       [
        'setter' => 'setCaseSensitive',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'valueSet' =>
       [
        'setter' => 'setValueSet',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'hierarchyMeaning' =>
       [
        'setter' => 'setHierarchyMeaning',
        'element' => 'CodeSystemHierarchyMeaning',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeSystemHierarchyMeaning::class,
      ],
      'compositional' =>
       [
        'setter' => 'setCompositional',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'versionNeeded' =>
       [
        'setter' => 'setVersionNeeded',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'content' =>
       [
        'setter' => 'setContent',
        'element' => 'CodeSystemContentMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeSystemContentMode::class,
      ],
      'supplements' =>
       [
        'setter' => 'setSupplements',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'count' =>
       [
        'setter' => 'setCount',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'filter' =>
       [
        'setter' => 'addFilter',
        'element' => 'CodeSystem.Filter',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemFilter::class,
      ],
      'property' =>
       [
        'setter' => 'addProperty',
        'element' => 'CodeSystem.Property',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemProperty::class,
      ],
      'concept' =>
       [
        'setter' => 'addConcept',
        'element' => 'CodeSystem.Concept',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemConcept::class,
      ],
    ],
    ],
    'CodeSystem.Filter' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemFilter::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'operator' =>
       [
        'setter' => 'addOperator',
        'element' => 'FilterOperator',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFilterOperator::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'CodeSystem.Property' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemProperty::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'uri' =>
       [
        'setter' => 'setUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'PropertyType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPropertyType::class,
      ],
    ],
    ],
    'CodeSystem.Concept' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemConcept::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'display' =>
       [
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'definition' =>
       [
        'setter' => 'setDefinition',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'designation' =>
       [
        'setter' => 'addDesignation',
        'element' => 'CodeSystem.Designation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemDesignation::class,
      ],
      'property' =>
       [
        'setter' => 'addProperty',
        'element' => 'CodeSystem.Property1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemProperty1::class,
      ],
      'concept' =>
       [
        'setter' => 'addConcept',
        'element' => 'CodeSystem.Concept',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemConcept::class,
      ],
    ],
    ],
    'CodeSystem.Designation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemDesignation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'CodeSystem.Property1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCodeSystem\FHIRCodeSystemProperty1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'valueCode' =>
       [
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'valueCoding' =>
       [
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'valueString' =>
       [
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueInteger' =>
       [
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'valueBoolean' =>
       [
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'valueDateTime' =>
       [
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'valueDecimal' =>
       [
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
    ],
    ],
    'FilterOperator' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFilterOperator::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'FilterOperator-list',
        'type' => 'string',
      ],
    ],
    ],
    'PropertyType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPropertyType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'PropertyType-list',
        'type' => 'string',
      ],
    ],
    ],
    'CodeSystemHierarchyMeaning' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeSystemHierarchyMeaning::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CodeSystemHierarchyMeaning-list',
        'type' => 'string',
      ],
    ],
    ],
    'CodeSystemContentMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeSystemContentMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CodeSystemContentMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'Communication' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCommunication::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'instantiatesCanonical' =>
       [
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'instantiatesUri' =>
       [
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'partOf' =>
       [
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'inResponseTo' =>
       [
        'setter' => 'addInResponseTo',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'EventStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREventStatus::class,
      ],
      'statusReason' =>
       [
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestPriority::class,
      ],
      'medium' =>
       [
        'setter' => 'addMedium',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'topic' =>
       [
        'setter' => 'setTopic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'about' =>
       [
        'setter' => 'addAbout',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'sent' =>
       [
        'setter' => 'setSent',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'received' =>
       [
        'setter' => 'setReceived',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'recipient' =>
       [
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'sender' =>
       [
        'setter' => 'setSender',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'payload' =>
       [
        'setter' => 'addPayload',
        'element' => 'Communication.Payload',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCommunication\FHIRCommunicationPayload::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'Communication.Payload' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCommunication\FHIRCommunicationPayload::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'contentString' =>
       [
        'setter' => 'setContentString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contentAttachment' =>
       [
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'contentReference' =>
       [
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'EventStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREventStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EventStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'CommunicationRequest' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCommunicationRequest::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'replaces' =>
       [
        'setter' => 'addReplaces',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'groupIdentifier' =>
       [
        'setter' => 'setGroupIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'RequestStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestStatus::class,
      ],
      'statusReason' =>
       [
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestPriority::class,
      ],
      'doNotPerform' =>
       [
        'setter' => 'setDoNotPerform',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'medium' =>
       [
        'setter' => 'addMedium',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'about' =>
       [
        'setter' => 'addAbout',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'payload' =>
       [
        'setter' => 'addPayload',
        'element' => 'CommunicationRequest.Payload',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCommunicationRequest\FHIRCommunicationRequestPayload::class,
      ],
      'occurrenceDateTime' =>
       [
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'occurrencePeriod' =>
       [
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'authoredOn' =>
       [
        'setter' => 'setAuthoredOn',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'requester' =>
       [
        'setter' => 'setRequester',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'recipient' =>
       [
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'sender' =>
       [
        'setter' => 'setSender',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'CommunicationRequest.Payload' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCommunicationRequest\FHIRCommunicationRequestPayload::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'contentString' =>
       [
        'setter' => 'setContentString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contentAttachment' =>
       [
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'contentReference' =>
       [
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'CompartmentDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCompartmentDefinition::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CompartmentType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCompartmentType::class,
      ],
      'search' =>
       [
        'setter' => 'setSearch',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'resource' =>
       [
        'setter' => 'addResource',
        'element' => 'CompartmentDefinition.Resource',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCompartmentDefinition\FHIRCompartmentDefinitionResource::class,
      ],
    ],
    ],
    'CompartmentDefinition.Resource' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCompartmentDefinition\FHIRCompartmentDefinitionResource::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'param' =>
       [
        'setter' => 'addParam',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'documentation' =>
       [
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'CompartmentType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCompartmentType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CompartmentType-list',
        'type' => 'string',
      ],
    ],
    ],
    'Composition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRComposition::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'CompositionStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCompositionStatus::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'confidentiality' =>
       [
        'setter' => 'setConfidentiality',
        'element' => 'vConfidentialityClassification',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRVConfidentialityClassification::class,
      ],
      'attester' =>
       [
        'setter' => 'addAttester',
        'element' => 'Composition.Attester',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionAttester::class,
      ],
      'custodian' =>
       [
        'setter' => 'setCustodian',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'relatesTo' =>
       [
        'setter' => 'addRelatesTo',
        'element' => 'Composition.RelatesTo',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionRelatesTo::class,
      ],
      'event' =>
       [
        'setter' => 'addEvent',
        'element' => 'Composition.Event',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionEvent::class,
      ],
      'section' =>
       [
        'setter' => 'addSection',
        'element' => 'Composition.Section',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionSection::class,
      ],
    ],
    ],
    'Composition.Attester' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionAttester::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'CompositionAttestationMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCompositionAttestationMode::class,
      ],
      'time' =>
       [
        'setter' => 'setTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'party' =>
       [
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Composition.RelatesTo' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionRelatesTo::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'DocumentRelationshipType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentRelationshipType::class,
      ],
      'targetIdentifier' =>
       [
        'setter' => 'setTargetIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'targetReference' =>
       [
        'setter' => 'setTargetReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Composition.Event' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionEvent::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Composition.Section' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionSection::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'focus' =>
       [
        'setter' => 'setFocus',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'ListMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRListMode::class,
      ],
      'orderedBy' =>
       [
        'setter' => 'setOrderedBy',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'entry' =>
       [
        'setter' => 'addEntry',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'emptyReason' =>
       [
        'setter' => 'setEmptyReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'section' =>
       [
        'setter' => 'addSection',
        'element' => 'Composition.Section',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRComposition\FHIRCompositionSection::class,
      ],
    ],
    ],
    'vConfidentialityClassification' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRVConfidentialityClassification::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'vConfidentialityClassification-list',
        'type' => 'string',
      ],
    ],
    ],
    'CompositionStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCompositionStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CompositionStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'DocumentRelationshipType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentRelationshipType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DocumentRelationshipType-list',
        'type' => 'string',
      ],
    ],
    ],
    'CompositionAttestationMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCompositionAttestationMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'CompositionAttestationMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'ListMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRListMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ListMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'ConceptMap' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRConceptMap::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'sourceUri' =>
       [
        'setter' => 'setSourceUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'sourceCanonical' =>
       [
        'setter' => 'setSourceCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'targetUri' =>
       [
        'setter' => 'setTargetUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'targetCanonical' =>
       [
        'setter' => 'setTargetCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'group' =>
       [
        'setter' => 'addGroup',
        'element' => 'ConceptMap.Group',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapGroup::class,
      ],
    ],
    ],
    'ConceptMap.Group' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapGroup::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'sourceVersion' =>
       [
        'setter' => 'setSourceVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'target' =>
       [
        'setter' => 'setTarget',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'targetVersion' =>
       [
        'setter' => 'setTargetVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'element' =>
       [
        'setter' => 'addElement',
        'element' => 'ConceptMap.Element',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapElement::class,
      ],
      'unmapped' =>
       [
        'setter' => 'setUnmapped',
        'element' => 'ConceptMap.Unmapped',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapUnmapped::class,
      ],
    ],
    ],
    'ConceptMap.Element' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapElement::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'display' =>
       [
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'target' =>
       [
        'setter' => 'addTarget',
        'element' => 'ConceptMap.Target',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapTarget::class,
      ],
    ],
    ],
    'ConceptMap.Target' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapTarget::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'display' =>
       [
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'equivalence' =>
       [
        'setter' => 'setEquivalence',
        'element' => 'ConceptMapEquivalence',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConceptMapEquivalence::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'dependsOn' =>
       [
        'setter' => 'addDependsOn',
        'element' => 'ConceptMap.DependsOn',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapDependsOn::class,
      ],
      'product' =>
       [
        'setter' => 'addProduct',
        'element' => 'ConceptMap.DependsOn',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapDependsOn::class,
      ],
    ],
    ],
    'ConceptMap.DependsOn' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapDependsOn::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'property' =>
       [
        'setter' => 'setProperty',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'system' =>
       [
        'setter' => 'setSystem',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'display' =>
       [
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ConceptMap.Unmapped' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConceptMap\FHIRConceptMapUnmapped::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'ConceptMapGroupUnmappedMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConceptMapGroupUnmappedMode::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'display' =>
       [
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'ConceptMapGroupUnmappedMode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConceptMapGroupUnmappedMode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ConceptMapGroupUnmappedMode-list',
        'type' => 'string',
      ],
    ],
    ],
    'Condition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCondition::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'clinicalStatus' =>
       [
        'setter' => 'setClinicalStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'verificationStatus' =>
       [
        'setter' => 'setVerificationStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'severity' =>
       [
        'setter' => 'setSeverity',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'bodySite' =>
       [
        'setter' => 'addBodySite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'onsetDateTime' =>
       [
        'setter' => 'setOnsetDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'onsetAge' =>
       [
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'onsetPeriod' =>
       [
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'onsetRange' =>
       [
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'onsetString' =>
       [
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'abatementDateTime' =>
       [
        'setter' => 'setAbatementDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'abatementAge' =>
       [
        'setter' => 'setAbatementAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'abatementPeriod' =>
       [
        'setter' => 'setAbatementPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'abatementRange' =>
       [
        'setter' => 'setAbatementRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'abatementString' =>
       [
        'setter' => 'setAbatementString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'recordedDate' =>
       [
        'setter' => 'setRecordedDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'recorder' =>
       [
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'asserter' =>
       [
        'setter' => 'setAsserter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'stage' =>
       [
        'setter' => 'addStage',
        'element' => 'Condition.Stage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCondition\FHIRConditionStage::class,
      ],
      'evidence' =>
       [
        'setter' => 'addEvidence',
        'element' => 'Condition.Evidence',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCondition\FHIRConditionEvidence::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'Condition.Stage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCondition\FHIRConditionStage::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'summary' =>
       [
        'setter' => 'setSummary',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'assessment' =>
       [
        'setter' => 'addAssessment',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Condition.Evidence' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCondition\FHIRConditionEvidence::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Consent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRConsent::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ConsentState',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentState::class,
      ],
      'scope' =>
       [
        'setter' => 'setScope',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'dateTime' =>
       [
        'setter' => 'setDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'performer' =>
       [
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'organization' =>
       [
        'setter' => 'addOrganization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'sourceAttachment' =>
       [
        'setter' => 'setSourceAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'sourceReference' =>
       [
        'setter' => 'setSourceReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'policy' =>
       [
        'setter' => 'addPolicy',
        'element' => 'Consent.Policy',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentPolicy::class,
      ],
      'policyRule' =>
       [
        'setter' => 'setPolicyRule',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'verification' =>
       [
        'setter' => 'addVerification',
        'element' => 'Consent.Verification',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentVerification::class,
      ],
      'provision' =>
       [
        'setter' => 'setProvision',
        'element' => 'Consent.Provision',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentProvision::class,
      ],
    ],
    ],
    'Consent.Policy' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentPolicy::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'authority' =>
       [
        'setter' => 'setAuthority',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'uri' =>
       [
        'setter' => 'setUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
    ],
    ],
    'Consent.Verification' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentVerification::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'verified' =>
       [
        'setter' => 'setVerified',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'verifiedWith' =>
       [
        'setter' => 'setVerifiedWith',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'verificationDate' =>
       [
        'setter' => 'setVerificationDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
    ],
    ],
    'Consent.Provision' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentProvision::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'ConsentProvisionType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentProvisionType::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'actor' =>
       [
        'setter' => 'addActor',
        'element' => 'Consent.Actor',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentActor::class,
      ],
      'action' =>
       [
        'setter' => 'addAction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'securityLabel' =>
       [
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'purpose' =>
       [
        'setter' => 'addPurpose',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'class' =>
       [
        'setter' => 'addClass',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'code' =>
       [
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'dataPeriod' =>
       [
        'setter' => 'setDataPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'data' =>
       [
        'setter' => 'addData',
        'element' => 'Consent.Data',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentData::class,
      ],
      'provision' =>
       [
        'setter' => 'addProvision',
        'element' => 'Consent.Provision',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentProvision::class,
      ],
    ],
    ],
    'Consent.Actor' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentActor::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Consent.Data' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRConsent\FHIRConsentData::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'meaning' =>
       [
        'setter' => 'setMeaning',
        'element' => 'ConsentDataMeaning',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentDataMeaning::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ConsentProvisionType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentProvisionType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ConsentProvisionType-list',
        'type' => 'string',
      ],
    ],
    ],
    'ConsentDataMeaning' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentDataMeaning::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ConsentDataMeaning-list',
        'type' => 'string',
      ],
    ],
    ],
    'ConsentState' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRConsentState::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ConsentState-list',
        'type' => 'string',
      ],
    ],
    ],
    'Contract' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRContract::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ContractResourceStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContractResourceStatusCodes::class,
      ],
      'legalState' =>
       [
        'setter' => 'setLegalState',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'instantiatesCanonical' =>
       [
        'setter' => 'setInstantiatesCanonical',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'instantiatesUri' =>
       [
        'setter' => 'setInstantiatesUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'contentDerivative' =>
       [
        'setter' => 'setContentDerivative',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'issued' =>
       [
        'setter' => 'setIssued',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'applies' =>
       [
        'setter' => 'setApplies',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'expirationType' =>
       [
        'setter' => 'setExpirationType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'addSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'authority' =>
       [
        'setter' => 'addAuthority',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'domain' =>
       [
        'setter' => 'addDomain',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'site' =>
       [
        'setter' => 'addSite',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subtitle' =>
       [
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'alias' =>
       [
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'author' =>
       [
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'scope' =>
       [
        'setter' => 'setScope',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'topicCodeableConcept' =>
       [
        'setter' => 'setTopicCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'topicReference' =>
       [
        'setter' => 'setTopicReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subType' =>
       [
        'setter' => 'addSubType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'contentDefinition' =>
       [
        'setter' => 'setContentDefinition',
        'element' => 'Contract.ContentDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractContentDefinition::class,
      ],
      'term' =>
       [
        'setter' => 'addTerm',
        'element' => 'Contract.Term',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractTerm::class,
      ],
      'supportingInfo' =>
       [
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'relevantHistory' =>
       [
        'setter' => 'addRelevantHistory',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'signer' =>
       [
        'setter' => 'addSigner',
        'element' => 'Contract.Signer',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSigner::class,
      ],
      'friendly' =>
       [
        'setter' => 'addFriendly',
        'element' => 'Contract.Friendly',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractFriendly::class,
      ],
      'legal' =>
       [
        'setter' => 'addLegal',
        'element' => 'Contract.Legal',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractLegal::class,
      ],
      'rule' =>
       [
        'setter' => 'addRule',
        'element' => 'Contract.Rule',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractRule::class,
      ],
      'legallyBindingAttachment' =>
       [
        'setter' => 'setLegallyBindingAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'legallyBindingReference' =>
       [
        'setter' => 'setLegallyBindingReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Contract.ContentDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractContentDefinition::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subType' =>
       [
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'publicationDate' =>
       [
        'setter' => 'setPublicationDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publicationStatus' =>
       [
        'setter' => 'setPublicationStatus',
        'element' => 'ContractResourcePublicationStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContractResourcePublicationStatusCodes::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'Contract.Term' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractTerm::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'issued' =>
       [
        'setter' => 'setIssued',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'applies' =>
       [
        'setter' => 'setApplies',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'topicCodeableConcept' =>
       [
        'setter' => 'setTopicCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'topicReference' =>
       [
        'setter' => 'setTopicReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subType' =>
       [
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'securityLabel' =>
       [
        'setter' => 'addSecurityLabel',
        'element' => 'Contract.SecurityLabel',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSecurityLabel::class,
      ],
      'offer' =>
       [
        'setter' => 'setOffer',
        'element' => 'Contract.Offer',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractOffer::class,
      ],
      'asset' =>
       [
        'setter' => 'addAsset',
        'element' => 'Contract.Asset',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAsset::class,
      ],
      'action' =>
       [
        'setter' => 'addAction',
        'element' => 'Contract.Action',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAction::class,
      ],
      'group' =>
       [
        'setter' => 'addGroup',
        'element' => 'Contract.Term',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractTerm::class,
      ],
    ],
    ],
    'Contract.SecurityLabel' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSecurityLabel::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'number' =>
       [
        'setter' => 'addNumber',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'classification' =>
       [
        'setter' => 'setClassification',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'control' =>
       [
        'setter' => 'addControl',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
    ],
    ],
    'Contract.Offer' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractOffer::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'party' =>
       [
        'setter' => 'addParty',
        'element' => 'Contract.Party',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractParty::class,
      ],
      'topic' =>
       [
        'setter' => 'setTopic',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'decision' =>
       [
        'setter' => 'setDecision',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'decisionMode' =>
       [
        'setter' => 'addDecisionMode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'answer' =>
       [
        'setter' => 'addAnswer',
        'element' => 'Contract.Answer',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAnswer::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'linkId' =>
       [
        'setter' => 'addLinkId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'securityLabelNumber' =>
       [
        'setter' => 'addSecurityLabelNumber',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
    ],
    ],
    'Contract.Party' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractParty::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'reference' =>
       [
        'setter' => 'addReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Contract.Answer' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAnswer::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'valueBoolean' =>
       [
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'valueDecimal' =>
       [
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'valueInteger' =>
       [
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'valueDate' =>
       [
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'valueDateTime' =>
       [
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'valueTime' =>
       [
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'valueString' =>
       [
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueUri' =>
       [
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'valueAttachment' =>
       [
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'valueCoding' =>
       [
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueReference' =>
       [
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Contract.Asset' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAsset::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'scope' =>
       [
        'setter' => 'setScope',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'typeReference' =>
       [
        'setter' => 'addTypeReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'subtype' =>
       [
        'setter' => 'addSubtype',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'relationship' =>
       [
        'setter' => 'setRelationship',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'context' =>
       [
        'setter' => 'addContext',
        'element' => 'Contract.Context',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractContext::class,
      ],
      'condition' =>
       [
        'setter' => 'setCondition',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'periodType' =>
       [
        'setter' => 'addPeriodType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'period' =>
       [
        'setter' => 'addPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'usePeriod' =>
       [
        'setter' => 'addUsePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'linkId' =>
       [
        'setter' => 'addLinkId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'answer' =>
       [
        'setter' => 'addAnswer',
        'element' => 'Contract.Answer',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAnswer::class,
      ],
      'securityLabelNumber' =>
       [
        'setter' => 'addSecurityLabelNumber',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'valuedItem' =>
       [
        'setter' => 'addValuedItem',
        'element' => 'Contract.ValuedItem',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractValuedItem::class,
      ],
    ],
    ],
    'Contract.Context' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractContext::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'code' =>
       [
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'Contract.ValuedItem' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractValuedItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'entityCodeableConcept' =>
       [
        'setter' => 'setEntityCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'entityReference' =>
       [
        'setter' => 'setEntityReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'effectiveTime' =>
       [
        'setter' => 'setEffectiveTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'points' =>
       [
        'setter' => 'setPoints',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'payment' =>
       [
        'setter' => 'setPayment',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'paymentDate' =>
       [
        'setter' => 'setPaymentDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'responsible' =>
       [
        'setter' => 'setResponsible',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'recipient' =>
       [
        'setter' => 'setRecipient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'linkId' =>
       [
        'setter' => 'addLinkId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'securityLabelNumber' =>
       [
        'setter' => 'addSecurityLabelNumber',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
    ],
    ],
    'Contract.Action' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractAction::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'doNotPerform' =>
       [
        'setter' => 'setDoNotPerform',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'addSubject',
        'element' => 'Contract.Subject',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSubject::class,
      ],
      'intent' =>
       [
        'setter' => 'setIntent',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'linkId' =>
       [
        'setter' => 'addLinkId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'context' =>
       [
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'contextLinkId' =>
       [
        'setter' => 'addContextLinkId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'occurrenceDateTime' =>
       [
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'occurrencePeriod' =>
       [
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'occurrenceTiming' =>
       [
        'setter' => 'setOccurrenceTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'requester' =>
       [
        'setter' => 'addRequester',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'requesterLinkId' =>
       [
        'setter' => 'addRequesterLinkId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'performerType' =>
       [
        'setter' => 'addPerformerType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'performerRole' =>
       [
        'setter' => 'setPerformerRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'performer' =>
       [
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'performerLinkId' =>
       [
        'setter' => 'addPerformerLinkId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reason' =>
       [
        'setter' => 'addReason',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'reasonLinkId' =>
       [
        'setter' => 'addReasonLinkId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'securityLabelNumber' =>
       [
        'setter' => 'addSecurityLabelNumber',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
    ],
    ],
    'Contract.Subject' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSubject::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'reference' =>
       [
        'setter' => 'addReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Contract.Signer' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractSigner::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'party' =>
       [
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'signature' =>
       [
        'setter' => 'addSignature',
        'element' => 'Signature',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSignature::class,
      ],
    ],
    ],
    'Contract.Friendly' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractFriendly::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'contentAttachment' =>
       [
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'contentReference' =>
       [
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Contract.Legal' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractLegal::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'contentAttachment' =>
       [
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'contentReference' =>
       [
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Contract.Rule' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRContract\FHIRContractRule::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'contentAttachment' =>
       [
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'contentReference' =>
       [
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ContractResourceStatusCodes' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContractResourceStatusCodes::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ContractResourceStatusCodes-list',
        'type' => 'string',
      ],
    ],
    ],
    'ContractResourcePublicationStatusCodes' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContractResourcePublicationStatusCodes::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ContractResourcePublicationStatusCodes-list',
        'type' => 'string',
      ],
    ],
    ],
    'Coverage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverage::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'policyHolder' =>
       [
        'setter' => 'setPolicyHolder',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'subscriber' =>
       [
        'setter' => 'setSubscriber',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'subscriberId' =>
       [
        'setter' => 'setSubscriberId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'beneficiary' =>
       [
        'setter' => 'setBeneficiary',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'dependent' =>
       [
        'setter' => 'setDependent',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'relationship' =>
       [
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'payor' =>
       [
        'setter' => 'addPayor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'class' =>
       [
        'setter' => 'addClass',
        'element' => 'Coverage.Class',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageClass::class,
      ],
      'order' =>
       [
        'setter' => 'setOrder',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'network' =>
       [
        'setter' => 'setNetwork',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'costToBeneficiary' =>
       [
        'setter' => 'addCostToBeneficiary',
        'element' => 'Coverage.CostToBeneficiary',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageCostToBeneficiary::class,
      ],
      'subrogation' =>
       [
        'setter' => 'setSubrogation',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'contract' =>
       [
        'setter' => 'addContract',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Coverage.Class' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageClass::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'Coverage.CostToBeneficiary' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageCostToBeneficiary::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueMoney' =>
       [
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'exception' =>
       [
        'setter' => 'addException',
        'element' => 'Coverage.Exception',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageException::class,
      ],
    ],
    ],
    'Coverage.Exception' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverage\FHIRCoverageException::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'CoverageEligibilityRequest' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverageEligibilityRequest::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'purpose' =>
       [
        'setter' => 'addPurpose',
        'element' => 'EligibilityRequestPurpose',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREligibilityRequestPurpose::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'servicedDate' =>
       [
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'servicedPeriod' =>
       [
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'enterer' =>
       [
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'provider' =>
       [
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'insurer' =>
       [
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'facility' =>
       [
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'supportingInfo' =>
       [
        'setter' => 'addSupportingInfo',
        'element' => 'CoverageEligibilityRequest.SupportingInfo',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestSupportingInfo::class,
      ],
      'insurance' =>
       [
        'setter' => 'addInsurance',
        'element' => 'CoverageEligibilityRequest.Insurance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestInsurance::class,
      ],
      'item' =>
       [
        'setter' => 'addItem',
        'element' => 'CoverageEligibilityRequest.Item',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestItem::class,
      ],
    ],
    ],
    'CoverageEligibilityRequest.SupportingInfo' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestSupportingInfo::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'information' =>
       [
        'setter' => 'setInformation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'appliesToAll' =>
       [
        'setter' => 'setAppliesToAll',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
    ],
    ],
    'CoverageEligibilityRequest.Insurance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestInsurance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'focal' =>
       [
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'coverage' =>
       [
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'businessArrangement' =>
       [
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'CoverageEligibilityRequest.Item' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'supportingInfoSequence' =>
       [
        'setter' => 'addSupportingInfoSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'provider' =>
       [
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'facility' =>
       [
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'diagnosis' =>
       [
        'setter' => 'addDiagnosis',
        'element' => 'CoverageEligibilityRequest.Diagnosis',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestDiagnosis::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'CoverageEligibilityRequest.Diagnosis' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityRequest\FHIRCoverageEligibilityRequestDiagnosis::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'diagnosisCodeableConcept' =>
       [
        'setter' => 'setDiagnosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'diagnosisReference' =>
       [
        'setter' => 'setDiagnosisReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'EligibilityRequestPurpose' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREligibilityRequestPurpose::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EligibilityRequestPurpose-list',
        'type' => 'string',
      ],
    ],
    ],
    'CoverageEligibilityResponse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRCoverageEligibilityResponse::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class,
      ],
      'purpose' =>
       [
        'setter' => 'addPurpose',
        'element' => 'EligibilityResponsePurpose',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREligibilityResponsePurpose::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'servicedDate' =>
       [
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'servicedPeriod' =>
       [
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'requestor' =>
       [
        'setter' => 'setRequestor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'request' =>
       [
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'RemittanceOutcome',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRemittanceOutcome::class,
      ],
      'disposition' =>
       [
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'insurer' =>
       [
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'insurance' =>
       [
        'setter' => 'addInsurance',
        'element' => 'CoverageEligibilityResponse.Insurance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseInsurance::class,
      ],
      'preAuthRef' =>
       [
        'setter' => 'setPreAuthRef',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'form' =>
       [
        'setter' => 'setForm',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'error' =>
       [
        'setter' => 'addError',
        'element' => 'CoverageEligibilityResponse.Error',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseError::class,
      ],
    ],
    ],
    'CoverageEligibilityResponse.Insurance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseInsurance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'coverage' =>
       [
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'inforce' =>
       [
        'setter' => 'setInforce',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'benefitPeriod' =>
       [
        'setter' => 'setBenefitPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'item' =>
       [
        'setter' => 'addItem',
        'element' => 'CoverageEligibilityResponse.Item',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseItem::class,
      ],
    ],
    ],
    'CoverageEligibilityResponse.Item' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'provider' =>
       [
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'excluded' =>
       [
        'setter' => 'setExcluded',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'network' =>
       [
        'setter' => 'setNetwork',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'unit' =>
       [
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'term' =>
       [
        'setter' => 'setTerm',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'benefit' =>
       [
        'setter' => 'addBenefit',
        'element' => 'CoverageEligibilityResponse.Benefit',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseBenefit::class,
      ],
      'authorizationRequired' =>
       [
        'setter' => 'setAuthorizationRequired',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'authorizationSupporting' =>
       [
        'setter' => 'addAuthorizationSupporting',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'authorizationUrl' =>
       [
        'setter' => 'setAuthorizationUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
    ],
    ],
    'CoverageEligibilityResponse.Benefit' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseBenefit::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'allowedUnsignedInt' =>
       [
        'setter' => 'setAllowedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'allowedString' =>
       [
        'setter' => 'setAllowedString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'allowedMoney' =>
       [
        'setter' => 'setAllowedMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'usedUnsignedInt' =>
       [
        'setter' => 'setUsedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'usedString' =>
       [
        'setter' => 'setUsedString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'usedMoney' =>
       [
        'setter' => 'setUsedMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
    ],
    ],
    'CoverageEligibilityResponse.Error' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRCoverageEligibilityResponse\FHIRCoverageEligibilityResponseError::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'EligibilityResponsePurpose' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREligibilityResponsePurpose::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EligibilityResponsePurpose-list',
        'type' => 'string',
      ],
    ],
    ],
    'DetectedIssue' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDetectedIssue::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ObservationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRObservationStatus::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'severity' =>
       [
        'setter' => 'setSeverity',
        'element' => 'DetectedIssueSeverity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDetectedIssueSeverity::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'identifiedDateTime' =>
       [
        'setter' => 'setIdentifiedDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'identifiedPeriod' =>
       [
        'setter' => 'setIdentifiedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'author' =>
       [
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'implicated' =>
       [
        'setter' => 'addImplicated',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'evidence' =>
       [
        'setter' => 'addEvidence',
        'element' => 'DetectedIssue.Evidence',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDetectedIssue\FHIRDetectedIssueEvidence::class,
      ],
      'detail' =>
       [
        'setter' => 'setDetail',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'mitigation' =>
       [
        'setter' => 'addMitigation',
        'element' => 'DetectedIssue.Mitigation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDetectedIssue\FHIRDetectedIssueMitigation::class,
      ],
    ],
    ],
    'DetectedIssue.Evidence' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDetectedIssue\FHIRDetectedIssueEvidence::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'DetectedIssue.Mitigation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDetectedIssue\FHIRDetectedIssueMitigation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'action' =>
       [
        'setter' => 'setAction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'author' =>
       [
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ObservationStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRObservationStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ObservationStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'DetectedIssueSeverity' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDetectedIssueSeverity::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DetectedIssueSeverity-list',
        'type' => 'string',
      ],
    ],
    ],
    'Device' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDevice::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'definition' =>
       [
        'setter' => 'setDefinition',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'udiCarrier' =>
       [
        'setter' => 'addUdiCarrier',
        'element' => 'Device.UdiCarrier',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceUdiCarrier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FHIRDeviceStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRDeviceStatus::class,
      ],
      'statusReason' =>
       [
        'setter' => 'addStatusReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'distinctIdentifier' =>
       [
        'setter' => 'setDistinctIdentifier',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'manufacturer' =>
       [
        'setter' => 'setManufacturer',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'manufactureDate' =>
       [
        'setter' => 'setManufactureDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'expirationDate' =>
       [
        'setter' => 'setExpirationDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'lotNumber' =>
       [
        'setter' => 'setLotNumber',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'serialNumber' =>
       [
        'setter' => 'setSerialNumber',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'deviceName' =>
       [
        'setter' => 'addDeviceName',
        'element' => 'Device.DeviceName',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceDeviceName::class,
      ],
      'modelNumber' =>
       [
        'setter' => 'setModelNumber',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'partNumber' =>
       [
        'setter' => 'setPartNumber',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'specialization' =>
       [
        'setter' => 'addSpecialization',
        'element' => 'Device.Specialization',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceSpecialization::class,
      ],
      'version' =>
       [
        'setter' => 'addVersion',
        'element' => 'Device.Version',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceVersion::class,
      ],
      'property' =>
       [
        'setter' => 'addProperty',
        'element' => 'Device.Property',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceProperty::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'owner' =>
       [
        'setter' => 'setOwner',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'safety' =>
       [
        'setter' => 'addSafety',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'parent' =>
       [
        'setter' => 'setParent',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Device.UdiCarrier' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceUdiCarrier::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'deviceIdentifier' =>
       [
        'setter' => 'setDeviceIdentifier',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'issuer' =>
       [
        'setter' => 'setIssuer',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'setJurisdiction',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'carrierAIDC' =>
       [
        'setter' => 'setCarrierAIDC',
        'element' => 'base64Binary',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBase64Binary::class,
      ],
      'carrierHRF' =>
       [
        'setter' => 'setCarrierHRF',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'entryType' =>
       [
        'setter' => 'setEntryType',
        'element' => 'UDIEntryType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUDIEntryType::class,
      ],
    ],
    ],
    'Device.DeviceName' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceDeviceName::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'DeviceNameType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceNameType::class,
      ],
    ],
    ],
    'Device.Specialization' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceSpecialization::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'systemType' =>
       [
        'setter' => 'setSystemType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'Device.Version' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceVersion::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'component' =>
       [
        'setter' => 'setComponent',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'Device.Property' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDevice\FHIRDeviceProperty::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'addValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueCode' =>
       [
        'setter' => 'addValueCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'FHIRDeviceStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRDeviceStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'FHIRDeviceStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'DeviceNameType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceNameType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DeviceNameType-list',
        'type' => 'string',
      ],
    ],
    ],
    'UDIEntryType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUDIEntryType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'UDIEntryType-list',
        'type' => 'string',
      ],
    ],
    ],
    'DeviceDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceDefinition::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'udiDeviceIdentifier' =>
       [
        'setter' => 'addUdiDeviceIdentifier',
        'element' => 'DeviceDefinition.UdiDeviceIdentifier',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionUdiDeviceIdentifier::class,
      ],
      'manufacturerString' =>
       [
        'setter' => 'setManufacturerString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'manufacturerReference' =>
       [
        'setter' => 'setManufacturerReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'deviceName' =>
       [
        'setter' => 'addDeviceName',
        'element' => 'DeviceDefinition.DeviceName',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionDeviceName::class,
      ],
      'modelNumber' =>
       [
        'setter' => 'setModelNumber',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'specialization' =>
       [
        'setter' => 'addSpecialization',
        'element' => 'DeviceDefinition.Specialization',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionSpecialization::class,
      ],
      'version' =>
       [
        'setter' => 'addVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'safety' =>
       [
        'setter' => 'addSafety',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'shelfLifeStorage' =>
       [
        'setter' => 'addShelfLifeStorage',
        'element' => 'ProductShelfLife',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRProductShelfLife::class,
      ],
      'physicalCharacteristics' =>
       [
        'setter' => 'setPhysicalCharacteristics',
        'element' => 'ProdCharacteristic',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRProdCharacteristic::class,
      ],
      'languageCode' =>
       [
        'setter' => 'addLanguageCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'capability' =>
       [
        'setter' => 'addCapability',
        'element' => 'DeviceDefinition.Capability',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionCapability::class,
      ],
      'property' =>
       [
        'setter' => 'addProperty',
        'element' => 'DeviceDefinition.Property',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionProperty::class,
      ],
      'owner' =>
       [
        'setter' => 'setOwner',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'onlineInformation' =>
       [
        'setter' => 'setOnlineInformation',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'parentDevice' =>
       [
        'setter' => 'setParentDevice',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'material' =>
       [
        'setter' => 'addMaterial',
        'element' => 'DeviceDefinition.Material',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionMaterial::class,
      ],
    ],
    ],
    'DeviceDefinition.UdiDeviceIdentifier' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionUdiDeviceIdentifier::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'deviceIdentifier' =>
       [
        'setter' => 'setDeviceIdentifier',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'issuer' =>
       [
        'setter' => 'setIssuer',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'setJurisdiction',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
    ],
    ],
    'DeviceDefinition.DeviceName' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionDeviceName::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'DeviceNameType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceNameType::class,
      ],
    ],
    ],
    'DeviceDefinition.Specialization' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionSpecialization::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'systemType' =>
       [
        'setter' => 'setSystemType',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'DeviceDefinition.Capability' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionCapability::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'description' =>
       [
        'setter' => 'addDescription',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'DeviceDefinition.Property' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionProperty::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'addValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueCode' =>
       [
        'setter' => 'addValueCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'DeviceDefinition.Material' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceDefinition\FHIRDeviceDefinitionMaterial::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'substance' =>
       [
        'setter' => 'setSubstance',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'alternate' =>
       [
        'setter' => 'setAlternate',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'allergenicIndicator' =>
       [
        'setter' => 'setAllergenicIndicator',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
    ],
    ],
    'DeviceMetric' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceMetric::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'unit' =>
       [
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'parent' =>
       [
        'setter' => 'setParent',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'operationalStatus' =>
       [
        'setter' => 'setOperationalStatus',
        'element' => 'DeviceMetricOperationalStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricOperationalStatus::class,
      ],
      'color' =>
       [
        'setter' => 'setColor',
        'element' => 'DeviceMetricColor',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricColor::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'DeviceMetricCategory',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCategory::class,
      ],
      'measurementPeriod' =>
       [
        'setter' => 'setMeasurementPeriod',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'calibration' =>
       [
        'setter' => 'addCalibration',
        'element' => 'DeviceMetric.Calibration',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceMetric\FHIRDeviceMetricCalibration::class,
      ],
    ],
    ],
    'DeviceMetric.Calibration' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceMetric\FHIRDeviceMetricCalibration::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'DeviceMetricCalibrationType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCalibrationType::class,
      ],
      'state' =>
       [
        'setter' => 'setState',
        'element' => 'DeviceMetricCalibrationState',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCalibrationState::class,
      ],
      'time' =>
       [
        'setter' => 'setTime',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
    ],
    ],
    'DeviceMetricCalibrationType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCalibrationType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DeviceMetricCalibrationType-list',
        'type' => 'string',
      ],
    ],
    ],
    'DeviceMetricColor' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricColor::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DeviceMetricColor-list',
        'type' => 'string',
      ],
    ],
    ],
    'DeviceMetricCalibrationState' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCalibrationState::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DeviceMetricCalibrationState-list',
        'type' => 'string',
      ],
    ],
    ],
    'DeviceMetricOperationalStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricOperationalStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DeviceMetricOperationalStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'DeviceMetricCategory' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceMetricCategory::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DeviceMetricCategory-list',
        'type' => 'string',
      ],
    ],
    ],
    'DeviceRequest' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceRequest::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'instantiatesCanonical' =>
       [
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'instantiatesUri' =>
       [
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'priorRequest' =>
       [
        'setter' => 'addPriorRequest',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'groupIdentifier' =>
       [
        'setter' => 'setGroupIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'RequestStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestStatus::class,
      ],
      'intent' =>
       [
        'setter' => 'setIntent',
        'element' => 'RequestIntent',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestIntent::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRequestPriority::class,
      ],
      'codeReference' =>
       [
        'setter' => 'setCodeReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'codeCodeableConcept' =>
       [
        'setter' => 'setCodeCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'parameter' =>
       [
        'setter' => 'addParameter',
        'element' => 'DeviceRequest.Parameter',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceRequest\FHIRDeviceRequestParameter::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'occurrenceDateTime' =>
       [
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'occurrencePeriod' =>
       [
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'occurrenceTiming' =>
       [
        'setter' => 'setOccurrenceTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'authoredOn' =>
       [
        'setter' => 'setAuthoredOn',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'requester' =>
       [
        'setter' => 'setRequester',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'performerType' =>
       [
        'setter' => 'setPerformerType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'performer' =>
       [
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'insurance' =>
       [
        'setter' => 'addInsurance',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'supportingInfo' =>
       [
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'relevantHistory' =>
       [
        'setter' => 'addRelevantHistory',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'DeviceRequest.Parameter' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDeviceRequest\FHIRDeviceRequestParameter::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueCodeableConcept' =>
       [
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueRange' =>
       [
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'valueBoolean' =>
       [
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
    ],
    ],
    'DeviceUseStatement' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDeviceUseStatement::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'DeviceUseStatementStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceUseStatementStatus::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'derivedFrom' =>
       [
        'setter' => 'addDerivedFrom',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'timingTiming' =>
       [
        'setter' => 'setTimingTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'timingPeriod' =>
       [
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'timingDateTime' =>
       [
        'setter' => 'setTimingDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'recordedOn' =>
       [
        'setter' => 'setRecordedOn',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'device' =>
       [
        'setter' => 'setDevice',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'bodySite' =>
       [
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'DeviceUseStatementStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDeviceUseStatementStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DeviceUseStatementStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'DiagnosticReport' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDiagnosticReport::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'DiagnosticReportStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDiagnosticReportStatus::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'effectiveDateTime' =>
       [
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'issued' =>
       [
        'setter' => 'setIssued',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'performer' =>
       [
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'resultsInterpreter' =>
       [
        'setter' => 'addResultsInterpreter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'specimen' =>
       [
        'setter' => 'addSpecimen',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'result' =>
       [
        'setter' => 'addResult',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'imagingStudy' =>
       [
        'setter' => 'addImagingStudy',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'media' =>
       [
        'setter' => 'addMedia',
        'element' => 'DiagnosticReport.Media',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDiagnosticReport\FHIRDiagnosticReportMedia::class,
      ],
      'conclusion' =>
       [
        'setter' => 'setConclusion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'conclusionCode' =>
       [
        'setter' => 'addConclusionCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'presentedForm' =>
       [
        'setter' => 'addPresentedForm',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
    ],
    ],
    'DiagnosticReport.Media' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDiagnosticReport\FHIRDiagnosticReportMedia::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'link' =>
       [
        'setter' => 'setLink',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'DiagnosticReportStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDiagnosticReportStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DiagnosticReportStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'DocumentManifest' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDocumentManifest::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'masterIdentifier' =>
       [
        'setter' => 'setMasterIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'DocumentReferenceStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentReferenceStatus::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'recipient' =>
       [
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'content' =>
       [
        'setter' => 'addContent',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'related' =>
       [
        'setter' => 'addRelated',
        'element' => 'DocumentManifest.Related',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentManifest\FHIRDocumentManifestRelated::class,
      ],
    ],
    ],
    'DocumentManifest.Related' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentManifest\FHIRDocumentManifestRelated::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'ref' =>
       [
        'setter' => 'setRef',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'DocumentReference' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRDocumentReference::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'masterIdentifier' =>
       [
        'setter' => 'setMasterIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'DocumentReferenceStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentReferenceStatus::class,
      ],
      'docStatus' =>
       [
        'setter' => 'setDocStatus',
        'element' => 'CompositionStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCompositionStatus::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'instant',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInstant::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'authenticator' =>
       [
        'setter' => 'setAuthenticator',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'custodian' =>
       [
        'setter' => 'setCustodian',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'relatesTo' =>
       [
        'setter' => 'addRelatesTo',
        'element' => 'DocumentReference.RelatesTo',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceRelatesTo::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'securityLabel' =>
       [
        'setter' => 'addSecurityLabel',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'content' =>
       [
        'setter' => 'addContent',
        'element' => 'DocumentReference.Content',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceContent::class,
      ],
      'context' =>
       [
        'setter' => 'setContext',
        'element' => 'DocumentReference.Context',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceContext::class,
      ],
    ],
    ],
    'DocumentReference.RelatesTo' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceRelatesTo::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'DocumentRelationshipType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDocumentRelationshipType::class,
      ],
      'target' =>
       [
        'setter' => 'setTarget',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'DocumentReference.Content' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceContent::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'attachment' =>
       [
        'setter' => 'setAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'format' =>
       [
        'setter' => 'setFormat',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
    ],
    ],
    'DocumentReference.Context' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRDocumentReference\FHIRDocumentReferenceContext::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'encounter' =>
       [
        'setter' => 'addEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'event' =>
       [
        'setter' => 'addEvent',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'facilityType' =>
       [
        'setter' => 'setFacilityType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'practiceSetting' =>
       [
        'setter' => 'setPracticeSetting',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'sourcePatientInfo' =>
       [
        'setter' => 'setSourcePatientInfo',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'related' =>
       [
        'setter' => 'addRelated',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'EffectEvidenceSynthesis' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREffectEvidenceSynthesis::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'approvalDate' =>
       [
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'lastReviewDate' =>
       [
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'topic' =>
       [
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'editor' =>
       [
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'reviewer' =>
       [
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'endorser' =>
       [
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'relatedArtifact' =>
       [
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'synthesisType' =>
       [
        'setter' => 'setSynthesisType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'studyType' =>
       [
        'setter' => 'setStudyType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'population' =>
       [
        'setter' => 'setPopulation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'exposure' =>
       [
        'setter' => 'setExposure',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'exposureAlternative' =>
       [
        'setter' => 'setExposureAlternative',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'sampleSize' =>
       [
        'setter' => 'setSampleSize',
        'element' => 'EffectEvidenceSynthesis.SampleSize',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisSampleSize::class,
      ],
      'resultsByExposure' =>
       [
        'setter' => 'addResultsByExposure',
        'element' => 'EffectEvidenceSynthesis.ResultsByExposure',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisResultsByExposure::class,
      ],
      'effectEstimate' =>
       [
        'setter' => 'addEffectEstimate',
        'element' => 'EffectEvidenceSynthesis.EffectEstimate',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisEffectEstimate::class,
      ],
      'certainty' =>
       [
        'setter' => 'addCertainty',
        'element' => 'EffectEvidenceSynthesis.Certainty',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisCertainty::class,
      ],
    ],
    ],
    'EffectEvidenceSynthesis.SampleSize' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisSampleSize::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'numberOfStudies' =>
       [
        'setter' => 'setNumberOfStudies',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'numberOfParticipants' =>
       [
        'setter' => 'setNumberOfParticipants',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
    ],
    ],
    'EffectEvidenceSynthesis.ResultsByExposure' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisResultsByExposure::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'exposureState' =>
       [
        'setter' => 'setExposureState',
        'element' => 'ExposureState',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExposureState::class,
      ],
      'variantState' =>
       [
        'setter' => 'setVariantState',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'riskEvidenceSynthesis' =>
       [
        'setter' => 'setRiskEvidenceSynthesis',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'EffectEvidenceSynthesis.EffectEstimate' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisEffectEstimate::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'variantState' =>
       [
        'setter' => 'setVariantState',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'unitOfMeasure' =>
       [
        'setter' => 'setUnitOfMeasure',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'precisionEstimate' =>
       [
        'setter' => 'addPrecisionEstimate',
        'element' => 'EffectEvidenceSynthesis.PrecisionEstimate',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisPrecisionEstimate::class,
      ],
    ],
    ],
    'EffectEvidenceSynthesis.PrecisionEstimate' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisPrecisionEstimate::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'level' =>
       [
        'setter' => 'setLevel',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'from' =>
       [
        'setter' => 'setFrom',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'to' =>
       [
        'setter' => 'setTo',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
    ],
    ],
    'EffectEvidenceSynthesis.Certainty' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisCertainty::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'rating' =>
       [
        'setter' => 'addRating',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'certaintySubcomponent' =>
       [
        'setter' => 'addCertaintySubcomponent',
        'element' => 'EffectEvidenceSynthesis.CertaintySubcomponent',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisCertaintySubcomponent::class,
      ],
    ],
    ],
    'EffectEvidenceSynthesis.CertaintySubcomponent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREffectEvidenceSynthesis\FHIREffectEvidenceSynthesisCertaintySubcomponent::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'rating' =>
       [
        'setter' => 'addRating',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'ExposureState' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExposureState::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ExposureState-list',
        'type' => 'string',
      ],
    ],
    ],
    'Encounter' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREncounter::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'EncounterStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREncounterStatus::class,
      ],
      'statusHistory' =>
       [
        'setter' => 'addStatusHistory',
        'element' => 'Encounter.StatusHistory',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterStatusHistory::class,
      ],
      'class' =>
       [
        'setter' => 'setClass',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'classHistory' =>
       [
        'setter' => 'addClassHistory',
        'element' => 'Encounter.ClassHistory',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterClassHistory::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'serviceType' =>
       [
        'setter' => 'setServiceType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'episodeOfCare' =>
       [
        'setter' => 'addEpisodeOfCare',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'participant' =>
       [
        'setter' => 'addParticipant',
        'element' => 'Encounter.Participant',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterParticipant::class,
      ],
      'appointment' =>
       [
        'setter' => 'addAppointment',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'length' =>
       [
        'setter' => 'setLength',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'diagnosis' =>
       [
        'setter' => 'addDiagnosis',
        'element' => 'Encounter.Diagnosis',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterDiagnosis::class,
      ],
      'account' =>
       [
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'hospitalization' =>
       [
        'setter' => 'setHospitalization',
        'element' => 'Encounter.Hospitalization',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterHospitalization::class,
      ],
      'location' =>
       [
        'setter' => 'addLocation',
        'element' => 'Encounter.Location',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterLocation::class,
      ],
      'serviceProvider' =>
       [
        'setter' => 'setServiceProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'partOf' =>
       [
        'setter' => 'setPartOf',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Encounter.StatusHistory' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterStatusHistory::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'EncounterStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREncounterStatus::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'Encounter.ClassHistory' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterClassHistory::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'class' =>
       [
        'setter' => 'setClass',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'Encounter.Participant' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterParticipant::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'individual' =>
       [
        'setter' => 'setIndividual',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Encounter.Diagnosis' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterDiagnosis::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'condition' =>
       [
        'setter' => 'setCondition',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'rank' =>
       [
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
    ],
    ],
    'Encounter.Hospitalization' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterHospitalization::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'preAdmissionIdentifier' =>
       [
        'setter' => 'setPreAdmissionIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'origin' =>
       [
        'setter' => 'setOrigin',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'admitSource' =>
       [
        'setter' => 'setAdmitSource',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reAdmission' =>
       [
        'setter' => 'setReAdmission',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'dietPreference' =>
       [
        'setter' => 'addDietPreference',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'specialCourtesy' =>
       [
        'setter' => 'addSpecialCourtesy',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'specialArrangement' =>
       [
        'setter' => 'addSpecialArrangement',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'destination' =>
       [
        'setter' => 'setDestination',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'dischargeDisposition' =>
       [
        'setter' => 'setDischargeDisposition',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'Encounter.Location' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREncounter\FHIREncounterLocation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'EncounterLocationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREncounterLocationStatus::class,
      ],
      'physicalType' =>
       [
        'setter' => 'setPhysicalType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'EncounterLocationStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREncounterLocationStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EncounterLocationStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'EncounterStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREncounterStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EncounterStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'Endpoint' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREndpoint::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'EndpointStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREndpointStatus::class,
      ],
      'connectionType' =>
       [
        'setter' => 'setConnectionType',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'managingOrganization' =>
       [
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'payloadType' =>
       [
        'setter' => 'addPayloadType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'payloadMimeType' =>
       [
        'setter' => 'addPayloadMimeType',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'address' =>
       [
        'setter' => 'setAddress',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'header' =>
       [
        'setter' => 'addHeader',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'EndpointStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREndpointStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EndpointStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'EnrollmentRequest' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREnrollmentRequest::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'insurer' =>
       [
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'provider' =>
       [
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'candidate' =>
       [
        'setter' => 'setCandidate',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'coverage' =>
       [
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'EnrollmentResponse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREnrollmentResponse::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFinancialResourceStatusCodes::class,
      ],
      'request' =>
       [
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'RemittanceOutcome',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRemittanceOutcome::class,
      ],
      'disposition' =>
       [
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'organization' =>
       [
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'requestProvider' =>
       [
        'setter' => 'setRequestProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'EpisodeOfCare' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREpisodeOfCare::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'EpisodeOfCareStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREpisodeOfCareStatus::class,
      ],
      'statusHistory' =>
       [
        'setter' => 'addStatusHistory',
        'element' => 'EpisodeOfCare.StatusHistory',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREpisodeOfCare\FHIREpisodeOfCareStatusHistory::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'diagnosis' =>
       [
        'setter' => 'addDiagnosis',
        'element' => 'EpisodeOfCare.Diagnosis',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREpisodeOfCare\FHIREpisodeOfCareDiagnosis::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'managingOrganization' =>
       [
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'referralRequest' =>
       [
        'setter' => 'addReferralRequest',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'careManager' =>
       [
        'setter' => 'setCareManager',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'team' =>
       [
        'setter' => 'addTeam',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'account' =>
       [
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'EpisodeOfCare.StatusHistory' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREpisodeOfCare\FHIREpisodeOfCareStatusHistory::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'EpisodeOfCareStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREpisodeOfCareStatus::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'EpisodeOfCare.Diagnosis' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREpisodeOfCare\FHIREpisodeOfCareDiagnosis::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'condition' =>
       [
        'setter' => 'setCondition',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'rank' =>
       [
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
    ],
    ],
    'EpisodeOfCareStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREpisodeOfCareStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EpisodeOfCareStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'EventDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREventDefinition::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subtitle' =>
       [
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'subjectCodeableConcept' =>
       [
        'setter' => 'setSubjectCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subjectReference' =>
       [
        'setter' => 'setSubjectReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'usage' =>
       [
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'approvalDate' =>
       [
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'lastReviewDate' =>
       [
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'topic' =>
       [
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'editor' =>
       [
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'reviewer' =>
       [
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'endorser' =>
       [
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'relatedArtifact' =>
       [
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'trigger' =>
       [
        'setter' => 'addTrigger',
        'element' => 'TriggerDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class,
      ],
    ],
    ],
    'Evidence' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREvidence::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'shortTitle' =>
       [
        'setter' => 'setShortTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subtitle' =>
       [
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'approvalDate' =>
       [
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'lastReviewDate' =>
       [
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'topic' =>
       [
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'editor' =>
       [
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'reviewer' =>
       [
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'endorser' =>
       [
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'relatedArtifact' =>
       [
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'exposureBackground' =>
       [
        'setter' => 'setExposureBackground',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'exposureVariant' =>
       [
        'setter' => 'addExposureVariant',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'outcome' =>
       [
        'setter' => 'addOutcome',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'EvidenceVariable' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIREvidenceVariable::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'shortTitle' =>
       [
        'setter' => 'setShortTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subtitle' =>
       [
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'approvalDate' =>
       [
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'lastReviewDate' =>
       [
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'topic' =>
       [
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'editor' =>
       [
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'reviewer' =>
       [
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'endorser' =>
       [
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'relatedArtifact' =>
       [
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'EvidenceVariableType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIREvidenceVariableType::class,
      ],
      'characteristic' =>
       [
        'setter' => 'addCharacteristic',
        'element' => 'EvidenceVariable.Characteristic',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIREvidenceVariable\FHIREvidenceVariableCharacteristic::class,
      ],
    ],
    ],
    'EvidenceVariable.Characteristic' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIREvidenceVariable\FHIREvidenceVariableCharacteristic::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'definitionReference' =>
       [
        'setter' => 'setDefinitionReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'definitionCanonical' =>
       [
        'setter' => 'setDefinitionCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'definitionCodeableConcept' =>
       [
        'setter' => 'setDefinitionCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'definitionExpression' =>
       [
        'setter' => 'setDefinitionExpression',
        'element' => 'Expression',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExpression::class,
      ],
      'definitionDataRequirement' =>
       [
        'setter' => 'setDefinitionDataRequirement',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
      'definitionTriggerDefinition' =>
       [
        'setter' => 'setDefinitionTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTriggerDefinition::class,
      ],
      'usageContext' =>
       [
        'setter' => 'addUsageContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'exclude' =>
       [
        'setter' => 'setExclude',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'participantEffectiveDateTime' =>
       [
        'setter' => 'setParticipantEffectiveDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'participantEffectivePeriod' =>
       [
        'setter' => 'setParticipantEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'participantEffectiveDuration' =>
       [
        'setter' => 'setParticipantEffectiveDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'participantEffectiveTiming' =>
       [
        'setter' => 'setParticipantEffectiveTiming',
        'element' => 'Timing',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRTiming::class,
      ],
      'timeFromStart' =>
       [
        'setter' => 'setTimeFromStart',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
      'groupMeasure' =>
       [
        'setter' => 'setGroupMeasure',
        'element' => 'GroupMeasure',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGroupMeasure::class,
      ],
    ],
    ],
    'EvidenceVariableType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIREvidenceVariableType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'EvidenceVariableType-list',
        'type' => 'string',
      ],
    ],
    ],
    'GroupMeasure' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGroupMeasure::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'GroupMeasure-list',
        'type' => 'string',
      ],
    ],
    ],
    'ExampleScenario' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRExampleScenario::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'actor' =>
       [
        'setter' => 'addActor',
        'element' => 'ExampleScenario.Actor',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioActor::class,
      ],
      'instance' =>
       [
        'setter' => 'addInstance',
        'element' => 'ExampleScenario.Instance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioInstance::class,
      ],
      'process' =>
       [
        'setter' => 'addProcess',
        'element' => 'ExampleScenario.Process',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioProcess::class,
      ],
      'workflow' =>
       [
        'setter' => 'addWorkflow',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'ExampleScenario.Actor' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioActor::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'actorId' =>
       [
        'setter' => 'setActorId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'ExampleScenarioActorType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExampleScenarioActorType::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'ExampleScenario.Instance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioInstance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'resourceId' =>
       [
        'setter' => 'setResourceId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'resourceType' =>
       [
        'setter' => 'setResourceType',
        'element' => 'ResourceType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRResourceType::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'version' =>
       [
        'setter' => 'addVersion',
        'element' => 'ExampleScenario.Version',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioVersion::class,
      ],
      'containedInstance' =>
       [
        'setter' => 'addContainedInstance',
        'element' => 'ExampleScenario.ContainedInstance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioContainedInstance::class,
      ],
    ],
    ],
    'ExampleScenario.Version' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioVersion::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'versionId' =>
       [
        'setter' => 'setVersionId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'ExampleScenario.ContainedInstance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioContainedInstance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'resourceId' =>
       [
        'setter' => 'setResourceId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'versionId' =>
       [
        'setter' => 'setVersionId',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ExampleScenario.Process' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioProcess::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'preConditions' =>
       [
        'setter' => 'setPreConditions',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'postConditions' =>
       [
        'setter' => 'setPostConditions',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'step' =>
       [
        'setter' => 'addStep',
        'element' => 'ExampleScenario.Step',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioStep::class,
      ],
    ],
    ],
    'ExampleScenario.Step' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioStep::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'process' =>
       [
        'setter' => 'addProcess',
        'element' => 'ExampleScenario.Process',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioProcess::class,
      ],
      'pause' =>
       [
        'setter' => 'setPause',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'operation' =>
       [
        'setter' => 'setOperation',
        'element' => 'ExampleScenario.Operation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioOperation::class,
      ],
      'alternative' =>
       [
        'setter' => 'addAlternative',
        'element' => 'ExampleScenario.Alternative',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioAlternative::class,
      ],
    ],
    ],
    'ExampleScenario.Operation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioOperation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'number' =>
       [
        'setter' => 'setNumber',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'initiator' =>
       [
        'setter' => 'setInitiator',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'receiver' =>
       [
        'setter' => 'setReceiver',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'initiatorActive' =>
       [
        'setter' => 'setInitiatorActive',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'receiverActive' =>
       [
        'setter' => 'setReceiverActive',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'request' =>
       [
        'setter' => 'setRequest',
        'element' => 'ExampleScenario.ContainedInstance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioContainedInstance::class,
      ],
      'response' =>
       [
        'setter' => 'setResponse',
        'element' => 'ExampleScenario.ContainedInstance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioContainedInstance::class,
      ],
    ],
    ],
    'ExampleScenario.Alternative' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioAlternative::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'step' =>
       [
        'setter' => 'addStep',
        'element' => 'ExampleScenario.Step',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExampleScenario\FHIRExampleScenarioStep::class,
      ],
    ],
    ],
    'ExampleScenarioActorType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExampleScenarioActorType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ExampleScenarioActorType-list',
        'type' => 'string',
      ],
    ],
    ],
    'ResourceType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRResourceType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ResourceType-list',
        'type' => 'string',
      ],
    ],
    ],
    'ExplanationOfBenefit' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRExplanationOfBenefit::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ExplanationOfBenefitStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExplanationOfBenefitStatus::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subType' =>
       [
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'Use',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUse::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'billablePeriod' =>
       [
        'setter' => 'setBillablePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'created' =>
       [
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'enterer' =>
       [
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'insurer' =>
       [
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'provider' =>
       [
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'fundsReserveRequested' =>
       [
        'setter' => 'setFundsReserveRequested',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'fundsReserve' =>
       [
        'setter' => 'setFundsReserve',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'related' =>
       [
        'setter' => 'addRelated',
        'element' => 'ExplanationOfBenefit.Related',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitRelated::class,
      ],
      'prescription' =>
       [
        'setter' => 'setPrescription',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'originalPrescription' =>
       [
        'setter' => 'setOriginalPrescription',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'payee' =>
       [
        'setter' => 'setPayee',
        'element' => 'ExplanationOfBenefit.Payee',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitPayee::class,
      ],
      'referral' =>
       [
        'setter' => 'setReferral',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'facility' =>
       [
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'claim' =>
       [
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'claimResponse' =>
       [
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'ClaimProcessingCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRClaimProcessingCodes::class,
      ],
      'disposition' =>
       [
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'preAuthRef' =>
       [
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'preAuthRefPeriod' =>
       [
        'setter' => 'addPreAuthRefPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'careTeam' =>
       [
        'setter' => 'addCareTeam',
        'element' => 'ExplanationOfBenefit.CareTeam',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitCareTeam::class,
      ],
      'supportingInfo' =>
       [
        'setter' => 'addSupportingInfo',
        'element' => 'ExplanationOfBenefit.SupportingInfo',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSupportingInfo::class,
      ],
      'diagnosis' =>
       [
        'setter' => 'addDiagnosis',
        'element' => 'ExplanationOfBenefit.Diagnosis',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDiagnosis::class,
      ],
      'procedure' =>
       [
        'setter' => 'addProcedure',
        'element' => 'ExplanationOfBenefit.Procedure',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitProcedure::class,
      ],
      'precedence' =>
       [
        'setter' => 'setPrecedence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'insurance' =>
       [
        'setter' => 'addInsurance',
        'element' => 'ExplanationOfBenefit.Insurance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitInsurance::class,
      ],
      'accident' =>
       [
        'setter' => 'setAccident',
        'element' => 'ExplanationOfBenefit.Accident',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAccident::class,
      ],
      'item' =>
       [
        'setter' => 'addItem',
        'element' => 'ExplanationOfBenefit.Item',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitItem::class,
      ],
      'addItem' =>
       [
        'setter' => 'addAddItem',
        'element' => 'ExplanationOfBenefit.AddItem',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAddItem::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class,
      ],
      'total' =>
       [
        'setter' => 'addTotal',
        'element' => 'ExplanationOfBenefit.Total',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitTotal::class,
      ],
      'payment' =>
       [
        'setter' => 'setPayment',
        'element' => 'ExplanationOfBenefit.Payment',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitPayment::class,
      ],
      'formCode' =>
       [
        'setter' => 'setFormCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'form' =>
       [
        'setter' => 'setForm',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'processNote' =>
       [
        'setter' => 'addProcessNote',
        'element' => 'ExplanationOfBenefit.ProcessNote',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitProcessNote::class,
      ],
      'benefitPeriod' =>
       [
        'setter' => 'setBenefitPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'benefitBalance' =>
       [
        'setter' => 'addBenefitBalance',
        'element' => 'ExplanationOfBenefit.BenefitBalance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitBenefitBalance::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Related' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitRelated::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'claim' =>
       [
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'relationship' =>
       [
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Payee' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitPayee::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'party' =>
       [
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.CareTeam' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitCareTeam::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'provider' =>
       [
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'responsible' =>
       [
        'setter' => 'setResponsible',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'qualification' =>
       [
        'setter' => 'setQualification',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.SupportingInfo' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSupportingInfo::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'timingDate' =>
       [
        'setter' => 'setTimingDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'timingPeriod' =>
       [
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'valueBoolean' =>
       [
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'valueString' =>
       [
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueAttachment' =>
       [
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'valueReference' =>
       [
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reason' =>
       [
        'setter' => 'setReason',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Diagnosis' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDiagnosis::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'diagnosisCodeableConcept' =>
       [
        'setter' => 'setDiagnosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'diagnosisReference' =>
       [
        'setter' => 'setDiagnosisReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'onAdmission' =>
       [
        'setter' => 'setOnAdmission',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'packageCode' =>
       [
        'setter' => 'setPackageCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Procedure' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitProcedure::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'procedureCodeableConcept' =>
       [
        'setter' => 'setProcedureCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'procedureReference' =>
       [
        'setter' => 'setProcedureReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'udi' =>
       [
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Insurance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitInsurance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'focal' =>
       [
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'coverage' =>
       [
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'preAuthRef' =>
       [
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Accident' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAccident::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'locationAddress' =>
       [
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'locationReference' =>
       [
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Item' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'careTeamSequence' =>
       [
        'setter' => 'addCareTeamSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'diagnosisSequence' =>
       [
        'setter' => 'addDiagnosisSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'procedureSequence' =>
       [
        'setter' => 'addProcedureSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'informationSequence' =>
       [
        'setter' => 'addInformationSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'revenue' =>
       [
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'programCode' =>
       [
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'servicedDate' =>
       [
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'servicedPeriod' =>
       [
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'locationCodeableConcept' =>
       [
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'locationAddress' =>
       [
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'locationReference' =>
       [
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'udi' =>
       [
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'bodySite' =>
       [
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subSite' =>
       [
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'encounter' =>
       [
        'setter' => 'addEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'ExplanationOfBenefit.Detail',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDetail::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Adjudication' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reason' =>
       [
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'amount' =>
       [
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Detail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDetail::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'revenue' =>
       [
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'programCode' =>
       [
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'udi' =>
       [
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class,
      ],
      'subDetail' =>
       [
        'setter' => 'addSubDetail',
        'element' => 'ExplanationOfBenefit.SubDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSubDetail::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.SubDetail' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSubDetail::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'revenue' =>
       [
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'programCode' =>
       [
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'udi' =>
       [
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.AddItem' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAddItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'itemSequence' =>
       [
        'setter' => 'addItemSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'detailSequence' =>
       [
        'setter' => 'addDetailSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'subDetailSequence' =>
       [
        'setter' => 'addSubDetailSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'provider' =>
       [
        'setter' => 'addProvider',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'programCode' =>
       [
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'servicedDate' =>
       [
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'servicedPeriod' =>
       [
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'locationCodeableConcept' =>
       [
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'locationAddress' =>
       [
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'locationReference' =>
       [
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'bodySite' =>
       [
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subSite' =>
       [
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class,
      ],
      'detail' =>
       [
        'setter' => 'addDetail',
        'element' => 'ExplanationOfBenefit.Detail1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDetail1::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Detail1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitDetail1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class,
      ],
      'subDetail' =>
       [
        'setter' => 'addSubDetail',
        'element' => 'ExplanationOfBenefit.SubDetail1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSubDetail1::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.SubDetail1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitSubDetail1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'productOrService' =>
       [
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'modifier' =>
       [
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'unitPrice' =>
       [
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'net' =>
       [
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'noteNumber' =>
       [
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'adjudication' =>
       [
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitAdjudication::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Total' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitTotal::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'amount' =>
       [
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Payment' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitPayment::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'adjustment' =>
       [
        'setter' => 'setAdjustment',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'adjustmentReason' =>
       [
        'setter' => 'setAdjustmentReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'amount' =>
       [
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'identifier' =>
       [
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.ProcessNote' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitProcessNote::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'number' =>
       [
        'setter' => 'setNumber',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'NoteType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNoteType::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.BenefitBalance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitBenefitBalance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'excluded' =>
       [
        'setter' => 'setExcluded',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'network' =>
       [
        'setter' => 'setNetwork',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'unit' =>
       [
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'term' =>
       [
        'setter' => 'setTerm',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'financial' =>
       [
        'setter' => 'addFinancial',
        'element' => 'ExplanationOfBenefit.Financial',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitFinancial::class,
      ],
    ],
    ],
    'ExplanationOfBenefit.Financial' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRExplanationOfBenefit\FHIRExplanationOfBenefitFinancial::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'allowedUnsignedInt' =>
       [
        'setter' => 'setAllowedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'allowedString' =>
       [
        'setter' => 'setAllowedString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'allowedMoney' =>
       [
        'setter' => 'setAllowedMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'usedUnsignedInt' =>
       [
        'setter' => 'setUsedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'usedMoney' =>
       [
        'setter' => 'setUsedMoney',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
    ],
    ],
    'ExplanationOfBenefitStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExplanationOfBenefitStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ExplanationOfBenefitStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'FamilyMemberHistory' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRFamilyMemberHistory::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'instantiatesCanonical' =>
       [
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'instantiatesUri' =>
       [
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FamilyHistoryStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFamilyHistoryStatus::class,
      ],
      'dataAbsentReason' =>
       [
        'setter' => 'setDataAbsentReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'relationship' =>
       [
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'sex' =>
       [
        'setter' => 'setSex',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'bornPeriod' =>
       [
        'setter' => 'setBornPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'bornDate' =>
       [
        'setter' => 'setBornDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'bornString' =>
       [
        'setter' => 'setBornString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'ageAge' =>
       [
        'setter' => 'setAgeAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'ageRange' =>
       [
        'setter' => 'setAgeRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'ageString' =>
       [
        'setter' => 'setAgeString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'estimatedAge' =>
       [
        'setter' => 'setEstimatedAge',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'deceasedBoolean' =>
       [
        'setter' => 'setDeceasedBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'deceasedAge' =>
       [
        'setter' => 'setDeceasedAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'deceasedRange' =>
       [
        'setter' => 'setDeceasedRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'deceasedDate' =>
       [
        'setter' => 'setDeceasedDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'deceasedString' =>
       [
        'setter' => 'setDeceasedString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'condition' =>
       [
        'setter' => 'addCondition',
        'element' => 'FamilyMemberHistory.Condition',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRFamilyMemberHistory\FHIRFamilyMemberHistoryCondition::class,
      ],
    ],
    ],
    'FamilyMemberHistory.Condition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRFamilyMemberHistory\FHIRFamilyMemberHistoryCondition::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'outcome' =>
       [
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'contributedToDeath' =>
       [
        'setter' => 'setContributedToDeath',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'onsetAge' =>
       [
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRAge::class,
      ],
      'onsetRange' =>
       [
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'onsetPeriod' =>
       [
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'onsetString' =>
       [
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'FamilyHistoryStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFamilyHistoryStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'FamilyHistoryStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'Flag' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRFlag::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'FlagStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFlagStatus::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'author' =>
       [
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'FlagStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFlagStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'FlagStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'Goal' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGoal::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'lifecycleStatus' =>
       [
        'setter' => 'setLifecycleStatus',
        'element' => 'GoalLifecycleStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGoalLifecycleStatus::class,
      ],
      'achievementStatus' =>
       [
        'setter' => 'setAchievementStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'priority' =>
       [
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'startDate' =>
       [
        'setter' => 'setStartDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'startCodeableConcept' =>
       [
        'setter' => 'setStartCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'target' =>
       [
        'setter' => 'addTarget',
        'element' => 'Goal.Target',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGoal\FHIRGoalTarget::class,
      ],
      'statusDate' =>
       [
        'setter' => 'setStatusDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'statusReason' =>
       [
        'setter' => 'setStatusReason',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'expressedBy' =>
       [
        'setter' => 'setExpressedBy',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'addresses' =>
       [
        'setter' => 'addAddresses',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'outcomeCode' =>
       [
        'setter' => 'addOutcomeCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'outcomeReference' =>
       [
        'setter' => 'addOutcomeReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Goal.Target' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGoal\FHIRGoalTarget::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'measure' =>
       [
        'setter' => 'setMeasure',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'detailQuantity' =>
       [
        'setter' => 'setDetailQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'detailRange' =>
       [
        'setter' => 'setDetailRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'detailCodeableConcept' =>
       [
        'setter' => 'setDetailCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'detailString' =>
       [
        'setter' => 'setDetailString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'detailBoolean' =>
       [
        'setter' => 'setDetailBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'detailInteger' =>
       [
        'setter' => 'setDetailInteger',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'detailRatio' =>
       [
        'setter' => 'setDetailRatio',
        'element' => 'Ratio',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRatio::class,
      ],
      'dueDate' =>
       [
        'setter' => 'setDueDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'dueDuration' =>
       [
        'setter' => 'setDueDuration',
        'element' => 'Duration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity\FHIRDuration::class,
      ],
    ],
    ],
    'GoalLifecycleStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGoalLifecycleStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'GoalLifecycleStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'GraphDefinition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGraphDefinition::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'start' =>
       [
        'setter' => 'setStart',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'profile' =>
       [
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'link' =>
       [
        'setter' => 'addLink',
        'element' => 'GraphDefinition.Link',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionLink::class,
      ],
    ],
    ],
    'GraphDefinition.Link' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionLink::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'path' =>
       [
        'setter' => 'setPath',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'sliceName' =>
       [
        'setter' => 'setSliceName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'min' =>
       [
        'setter' => 'setMin',
        'element' => 'integer',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInteger::class,
      ],
      'max' =>
       [
        'setter' => 'setMax',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'target' =>
       [
        'setter' => 'addTarget',
        'element' => 'GraphDefinition.Target',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionTarget::class,
      ],
    ],
    ],
    'GraphDefinition.Target' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionTarget::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'params' =>
       [
        'setter' => 'setParams',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'profile' =>
       [
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'compartment' =>
       [
        'setter' => 'addCompartment',
        'element' => 'GraphDefinition.Compartment',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionCompartment::class,
      ],
      'link' =>
       [
        'setter' => 'addLink',
        'element' => 'GraphDefinition.Link',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionLink::class,
      ],
    ],
    ],
    'GraphDefinition.Compartment' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGraphDefinition\FHIRGraphDefinitionCompartment::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'use' =>
       [
        'setter' => 'setUse',
        'element' => 'GraphCompartmentUse',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGraphCompartmentUse::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CompartmentType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCompartmentType::class,
      ],
      'rule' =>
       [
        'setter' => 'setRule',
        'element' => 'GraphCompartmentRule',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGraphCompartmentRule::class,
      ],
      'expression' =>
       [
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'GraphCompartmentUse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGraphCompartmentUse::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'GraphCompartmentUse-list',
        'type' => 'string',
      ],
    ],
    ],
    'GraphCompartmentRule' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGraphCompartmentRule::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'GraphCompartmentRule-list',
        'type' => 'string',
      ],
    ],
    ],
    'Group' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGroup::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'active' =>
       [
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'GroupType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGroupType::class,
      ],
      'actual' =>
       [
        'setter' => 'setActual',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'quantity' =>
       [
        'setter' => 'setQuantity',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'managingEntity' =>
       [
        'setter' => 'setManagingEntity',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'characteristic' =>
       [
        'setter' => 'addCharacteristic',
        'element' => 'Group.Characteristic',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGroup\FHIRGroupCharacteristic::class,
      ],
      'member' =>
       [
        'setter' => 'addMember',
        'element' => 'Group.Member',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGroup\FHIRGroupMember::class,
      ],
    ],
    ],
    'Group.Characteristic' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGroup\FHIRGroupCharacteristic::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueCodeableConcept' =>
       [
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'valueBoolean' =>
       [
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'valueQuantity' =>
       [
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'valueRange' =>
       [
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRange::class,
      ],
      'valueReference' =>
       [
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'exclude' =>
       [
        'setter' => 'setExclude',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'Group.Member' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRGroup\FHIRGroupMember::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'entity' =>
       [
        'setter' => 'setEntity',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'inactive' =>
       [
        'setter' => 'setInactive',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
    ],
    ],
    'GroupType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGroupType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'GroupType-list',
        'type' => 'string',
      ],
    ],
    ],
    'GuidanceResponse' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRGuidanceResponse::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'requestIdentifier' =>
       [
        'setter' => 'setRequestIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'moduleUri' =>
       [
        'setter' => 'setModuleUri',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'moduleCanonical' =>
       [
        'setter' => 'setModuleCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'moduleCodeableConcept' =>
       [
        'setter' => 'setModuleCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'GuidanceResponseStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGuidanceResponseStatus::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'occurrenceDateTime' =>
       [
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'performer' =>
       [
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'evaluationMessage' =>
       [
        'setter' => 'addEvaluationMessage',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'outputParameters' =>
       [
        'setter' => 'setOutputParameters',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'result' =>
       [
        'setter' => 'setResult',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'dataRequirement' =>
       [
        'setter' => 'addDataRequirement',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
    ],
    ],
    'GuidanceResponseStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGuidanceResponseStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'GuidanceResponseStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'HealthcareService' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRHealthcareService::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'active' =>
       [
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'providedBy' =>
       [
        'setter' => 'setProvidedBy',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'category' =>
       [
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'specialty' =>
       [
        'setter' => 'addSpecialty',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'location' =>
       [
        'setter' => 'addLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'extraDetails' =>
       [
        'setter' => 'setExtraDetails',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'photo' =>
       [
        'setter' => 'setPhoto',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
      'telecom' =>
       [
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'coverageArea' =>
       [
        'setter' => 'addCoverageArea',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'serviceProvisionCode' =>
       [
        'setter' => 'addServiceProvisionCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'eligibility' =>
       [
        'setter' => 'addEligibility',
        'element' => 'HealthcareService.Eligibility',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceEligibility::class,
      ],
      'program' =>
       [
        'setter' => 'addProgram',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'characteristic' =>
       [
        'setter' => 'addCharacteristic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'communication' =>
       [
        'setter' => 'addCommunication',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'referralMethod' =>
       [
        'setter' => 'addReferralMethod',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'appointmentRequired' =>
       [
        'setter' => 'setAppointmentRequired',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'availableTime' =>
       [
        'setter' => 'addAvailableTime',
        'element' => 'HealthcareService.AvailableTime',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceAvailableTime::class,
      ],
      'notAvailable' =>
       [
        'setter' => 'addNotAvailable',
        'element' => 'HealthcareService.NotAvailable',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceNotAvailable::class,
      ],
      'availabilityExceptions' =>
       [
        'setter' => 'setAvailabilityExceptions',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'endpoint' =>
       [
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'HealthcareService.Eligibility' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceEligibility::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
    ],
    ],
    'HealthcareService.AvailableTime' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceAvailableTime::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'daysOfWeek' =>
       [
        'setter' => 'addDaysOfWeek',
        'element' => 'DaysOfWeek',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDaysOfWeek::class,
      ],
      'allDay' =>
       [
        'setter' => 'setAllDay',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'availableStartTime' =>
       [
        'setter' => 'setAvailableStartTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
      'availableEndTime' =>
       [
        'setter' => 'setAvailableEndTime',
        'element' => 'time',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRTime::class,
      ],
    ],
    ],
    'HealthcareService.NotAvailable' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRHealthcareService\FHIRHealthcareServiceNotAvailable::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'during' =>
       [
        'setter' => 'setDuring',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
    ],
    ],
    'DaysOfWeek' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDaysOfWeek::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'DaysOfWeek-list',
        'type' => 'string',
      ],
    ],
    ],
    'ImagingStudy' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImagingStudy::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ImagingStudyStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRImagingStudyStatus::class,
      ],
      'modality' =>
       [
        'setter' => 'addModality',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'started' =>
       [
        'setter' => 'setStarted',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'basedOn' =>
       [
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'referrer' =>
       [
        'setter' => 'setReferrer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'interpreter' =>
       [
        'setter' => 'addInterpreter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'endpoint' =>
       [
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'numberOfSeries' =>
       [
        'setter' => 'setNumberOfSeries',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'numberOfInstances' =>
       [
        'setter' => 'setNumberOfInstances',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'procedureReference' =>
       [
        'setter' => 'setProcedureReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'procedureCode' =>
       [
        'setter' => 'addProcedureCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'series' =>
       [
        'setter' => 'addSeries',
        'element' => 'ImagingStudy.Series',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudySeries::class,
      ],
    ],
    ],
    'ImagingStudy.Series' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudySeries::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'uid' =>
       [
        'setter' => 'setUid',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'number' =>
       [
        'setter' => 'setNumber',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'modality' =>
       [
        'setter' => 'setModality',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'numberOfInstances' =>
       [
        'setter' => 'setNumberOfInstances',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'endpoint' =>
       [
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'bodySite' =>
       [
        'setter' => 'setBodySite',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'laterality' =>
       [
        'setter' => 'setLaterality',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'specimen' =>
       [
        'setter' => 'addSpecimen',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'started' =>
       [
        'setter' => 'setStarted',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'performer' =>
       [
        'setter' => 'addPerformer',
        'element' => 'ImagingStudy.Performer',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudyPerformer::class,
      ],
      'instance' =>
       [
        'setter' => 'addInstance',
        'element' => 'ImagingStudy.Instance',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudyInstance::class,
      ],
    ],
    ],
    'ImagingStudy.Performer' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudyPerformer::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'function' =>
       [
        'setter' => 'setFunction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'actor' =>
       [
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ImagingStudy.Instance' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImagingStudy\FHIRImagingStudyInstance::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'uid' =>
       [
        'setter' => 'setUid',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'sopClass' =>
       [
        'setter' => 'setSopClass',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'number' =>
       [
        'setter' => 'setNumber',
        'element' => 'unsignedInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUnsignedInt::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ImagingStudyStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRImagingStudyStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ImagingStudyStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'Immunization' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunization::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ImmunizationStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRImmunizationStatusCodes::class,
      ],
      'statusReason' =>
       [
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'vaccineCode' =>
       [
        'setter' => 'setVaccineCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'occurrenceDateTime' =>
       [
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'occurrenceString' =>
       [
        'setter' => 'setOccurrenceString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'recorded' =>
       [
        'setter' => 'setRecorded',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'primarySource' =>
       [
        'setter' => 'setPrimarySource',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'reportOrigin' =>
       [
        'setter' => 'setReportOrigin',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'location' =>
       [
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'manufacturer' =>
       [
        'setter' => 'setManufacturer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'lotNumber' =>
       [
        'setter' => 'setLotNumber',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'expirationDate' =>
       [
        'setter' => 'setExpirationDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'site' =>
       [
        'setter' => 'setSite',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'route' =>
       [
        'setter' => 'setRoute',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'doseQuantity' =>
       [
        'setter' => 'setDoseQuantity',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'performer' =>
       [
        'setter' => 'addPerformer',
        'element' => 'Immunization.Performer',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationPerformer::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'reasonCode' =>
       [
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reasonReference' =>
       [
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'isSubpotent' =>
       [
        'setter' => 'setIsSubpotent',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'subpotentReason' =>
       [
        'setter' => 'addSubpotentReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'education' =>
       [
        'setter' => 'addEducation',
        'element' => 'Immunization.Education',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationEducation::class,
      ],
      'programEligibility' =>
       [
        'setter' => 'addProgramEligibility',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'fundingSource' =>
       [
        'setter' => 'setFundingSource',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'reaction' =>
       [
        'setter' => 'addReaction',
        'element' => 'Immunization.Reaction',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationReaction::class,
      ],
      'protocolApplied' =>
       [
        'setter' => 'addProtocolApplied',
        'element' => 'Immunization.ProtocolApplied',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationProtocolApplied::class,
      ],
    ],
    ],
    'Immunization.Performer' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationPerformer::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'function' =>
       [
        'setter' => 'setFunction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'actor' =>
       [
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Immunization.Education' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationEducation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'documentType' =>
       [
        'setter' => 'setDocumentType',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'publicationDate' =>
       [
        'setter' => 'setPublicationDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'presentationDate' =>
       [
        'setter' => 'setPresentationDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
    ],
    ],
    'Immunization.Reaction' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationReaction::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'detail' =>
       [
        'setter' => 'setDetail',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'reported' =>
       [
        'setter' => 'setReported',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
    ],
    ],
    'Immunization.ProtocolApplied' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunization\FHIRImmunizationProtocolApplied::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'series' =>
       [
        'setter' => 'setSeries',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'authority' =>
       [
        'setter' => 'setAuthority',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'targetDisease' =>
       [
        'setter' => 'addTargetDisease',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'doseNumberPositiveInt' =>
       [
        'setter' => 'setDoseNumberPositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'doseNumberString' =>
       [
        'setter' => 'setDoseNumberString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'seriesDosesPositiveInt' =>
       [
        'setter' => 'setSeriesDosesPositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'seriesDosesString' =>
       [
        'setter' => 'setSeriesDosesString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ImmunizationStatusCodes' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRImmunizationStatusCodes::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ImmunizationStatusCodes-list',
        'type' => 'string',
      ],
    ],
    ],
    'ImmunizationEvaluation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunizationEvaluation::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ImmunizationEvaluationStatusCodes',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRImmunizationEvaluationStatusCodes::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'authority' =>
       [
        'setter' => 'setAuthority',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'targetDisease' =>
       [
        'setter' => 'setTargetDisease',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'immunizationEvent' =>
       [
        'setter' => 'setImmunizationEvent',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'doseStatus' =>
       [
        'setter' => 'setDoseStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'doseStatusReason' =>
       [
        'setter' => 'addDoseStatusReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'series' =>
       [
        'setter' => 'setSeries',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'doseNumberPositiveInt' =>
       [
        'setter' => 'setDoseNumberPositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'doseNumberString' =>
       [
        'setter' => 'setDoseNumberString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'seriesDosesPositiveInt' =>
       [
        'setter' => 'setSeriesDosesPositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'seriesDosesString' =>
       [
        'setter' => 'setSeriesDosesString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ImmunizationEvaluationStatusCodes' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRImmunizationEvaluationStatusCodes::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ImmunizationEvaluationStatusCodes-list',
        'type' => 'string',
      ],
    ],
    ],
    'ImmunizationRecommendation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImmunizationRecommendation::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'patient' =>
       [
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'authority' =>
       [
        'setter' => 'setAuthority',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'recommendation' =>
       [
        'setter' => 'addRecommendation',
        'element' => 'ImmunizationRecommendation.Recommendation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunizationRecommendation\FHIRImmunizationRecommendationRecommendation::class,
      ],
    ],
    ],
    'ImmunizationRecommendation.Recommendation' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunizationRecommendation\FHIRImmunizationRecommendationRecommendation::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'vaccineCode' =>
       [
        'setter' => 'addVaccineCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'targetDisease' =>
       [
        'setter' => 'setTargetDisease',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'contraindicatedVaccineCode' =>
       [
        'setter' => 'addContraindicatedVaccineCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'forecastStatus' =>
       [
        'setter' => 'setForecastStatus',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'forecastReason' =>
       [
        'setter' => 'addForecastReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'dateCriterion' =>
       [
        'setter' => 'addDateCriterion',
        'element' => 'ImmunizationRecommendation.DateCriterion',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunizationRecommendation\FHIRImmunizationRecommendationDateCriterion::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'series' =>
       [
        'setter' => 'setSeries',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'doseNumberPositiveInt' =>
       [
        'setter' => 'setDoseNumberPositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'doseNumberString' =>
       [
        'setter' => 'setDoseNumberString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'seriesDosesPositiveInt' =>
       [
        'setter' => 'setSeriesDosesPositiveInt',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'seriesDosesString' =>
       [
        'setter' => 'setSeriesDosesString',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'supportingImmunization' =>
       [
        'setter' => 'addSupportingImmunization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'supportingPatientInformation' =>
       [
        'setter' => 'addSupportingPatientInformation',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ImmunizationRecommendation.DateCriterion' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImmunizationRecommendation\FHIRImmunizationRecommendationDateCriterion::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
    ],
    ],
    'ImplementationGuide' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRImplementationGuide::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'packageId' =>
       [
        'setter' => 'setPackageId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'license' =>
       [
        'setter' => 'setLicense',
        'element' => 'SPDXLicense',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSPDXLicense::class,
      ],
      'fhirVersion' =>
       [
        'setter' => 'addFhirVersion',
        'element' => 'FHIRVersion',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRVersion::class,
      ],
      'dependsOn' =>
       [
        'setter' => 'addDependsOn',
        'element' => 'ImplementationGuide.DependsOn',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideDependsOn::class,
      ],
      'global' =>
       [
        'setter' => 'addGlobal',
        'element' => 'ImplementationGuide.Global',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideGlobal::class,
      ],
      'definition' =>
       [
        'setter' => 'setDefinition',
        'element' => 'ImplementationGuide.Definition',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideDefinition::class,
      ],
      'manifest' =>
       [
        'setter' => 'setManifest',
        'element' => 'ImplementationGuide.Manifest',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideManifest::class,
      ],
    ],
    ],
    'ImplementationGuide.DependsOn' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideDependsOn::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'uri' =>
       [
        'setter' => 'setUri',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'packageId' =>
       [
        'setter' => 'setPackageId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ImplementationGuide.Global' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideGlobal::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'profile' =>
       [
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
    ],
    ],
    'ImplementationGuide.Definition' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideDefinition::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'grouping' =>
       [
        'setter' => 'addGrouping',
        'element' => 'ImplementationGuide.Grouping',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideGrouping::class,
      ],
      'resource' =>
       [
        'setter' => 'addResource',
        'element' => 'ImplementationGuide.Resource',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideResource::class,
      ],
      'page' =>
       [
        'setter' => 'setPage',
        'element' => 'ImplementationGuide.Page',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuidePage::class,
      ],
      'parameter' =>
       [
        'setter' => 'addParameter',
        'element' => 'ImplementationGuide.Parameter',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideParameter::class,
      ],
      'template' =>
       [
        'setter' => 'addTemplate',
        'element' => 'ImplementationGuide.Template',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideTemplate::class,
      ],
    ],
    ],
    'ImplementationGuide.Grouping' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideGrouping::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ImplementationGuide.Resource' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideResource::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'fhirVersion' =>
       [
        'setter' => 'addFhirVersion',
        'element' => 'FHIRVersion',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRFHIRVersion::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'exampleBoolean' =>
       [
        'setter' => 'setExampleBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'exampleCanonical' =>
       [
        'setter' => 'setExampleCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'groupingId' =>
       [
        'setter' => 'setGroupingId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
    ],
    ],
    'ImplementationGuide.Page' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuidePage::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'nameUrl' =>
       [
        'setter' => 'setNameUrl',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'nameReference' =>
       [
        'setter' => 'setNameReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'generation' =>
       [
        'setter' => 'setGeneration',
        'element' => 'GuidePageGeneration',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGuidePageGeneration::class,
      ],
      'page' =>
       [
        'setter' => 'addPage',
        'element' => 'ImplementationGuide.Page',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuidePage::class,
      ],
    ],
    ],
    'ImplementationGuide.Parameter' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideParameter::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'GuideParameterCode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGuideParameterCode::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ImplementationGuide.Template' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideTemplate::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'scope' =>
       [
        'setter' => 'setScope',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ImplementationGuide.Manifest' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideManifest::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'rendering' =>
       [
        'setter' => 'setRendering',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
      'resource' =>
       [
        'setter' => 'addResource',
        'element' => 'ImplementationGuide.Resource1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideResource1::class,
      ],
      'page' =>
       [
        'setter' => 'addPage',
        'element' => 'ImplementationGuide.Page1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuidePage1::class,
      ],
      'image' =>
       [
        'setter' => 'addImage',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'other' =>
       [
        'setter' => 'addOther',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'ImplementationGuide.Resource1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuideResource1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'reference' =>
       [
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'exampleBoolean' =>
       [
        'setter' => 'setExampleBoolean',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'exampleCanonical' =>
       [
        'setter' => 'setExampleCanonical',
        'element' => 'canonical',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCanonical::class,
      ],
      'relativePath' =>
       [
        'setter' => 'setRelativePath',
        'element' => 'url',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUrl::class,
      ],
    ],
    ],
    'ImplementationGuide.Page1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRImplementationGuide\FHIRImplementationGuidePage1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'anchor' =>
       [
        'setter' => 'addAnchor',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'GuideParameterCode' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGuideParameterCode::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'GuideParameterCode-list',
        'type' => 'string',
      ],
    ],
    ],
    'SPDXLicense' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRSPDXLicense::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'SPDXLicense-list',
        'type' => 'string',
      ],
    ],
    ],
    'GuidePageGeneration' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRGuidePageGeneration::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'GuidePageGeneration-list',
        'type' => 'string',
      ],
    ],
    ],
    'InsurancePlan' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRInsurancePlan::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'alias' =>
       [
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'period' =>
       [
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'ownedBy' =>
       [
        'setter' => 'setOwnedBy',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'administeredBy' =>
       [
        'setter' => 'setAdministeredBy',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'coverageArea' =>
       [
        'setter' => 'addCoverageArea',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'InsurancePlan.Contact',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanContact::class,
      ],
      'endpoint' =>
       [
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'network' =>
       [
        'setter' => 'addNetwork',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'coverage' =>
       [
        'setter' => 'addCoverage',
        'element' => 'InsurancePlan.Coverage',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanCoverage::class,
      ],
      'plan' =>
       [
        'setter' => 'addPlan',
        'element' => 'InsurancePlan.Plan',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanPlan::class,
      ],
    ],
    ],
    'InsurancePlan.Contact' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanContact::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'HumanName',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRHumanName::class,
      ],
      'telecom' =>
       [
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'address' =>
       [
        'setter' => 'setAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
    ],
    ],
    'InsurancePlan.Coverage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanCoverage::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'network' =>
       [
        'setter' => 'addNetwork',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'benefit' =>
       [
        'setter' => 'addBenefit',
        'element' => 'InsurancePlan.Benefit',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanBenefit::class,
      ],
    ],
    ],
    'InsurancePlan.Benefit' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanBenefit::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'requirement' =>
       [
        'setter' => 'setRequirement',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'limit' =>
       [
        'setter' => 'addLimit',
        'element' => 'InsurancePlan.Limit',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanLimit::class,
      ],
    ],
    ],
    'InsurancePlan.Limit' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanLimit::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'InsurancePlan.Plan' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanPlan::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'coverageArea' =>
       [
        'setter' => 'addCoverageArea',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'network' =>
       [
        'setter' => 'addNetwork',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'generalCost' =>
       [
        'setter' => 'addGeneralCost',
        'element' => 'InsurancePlan.GeneralCost',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanGeneralCost::class,
      ],
      'specificCost' =>
       [
        'setter' => 'addSpecificCost',
        'element' => 'InsurancePlan.SpecificCost',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanSpecificCost::class,
      ],
    ],
    ],
    'InsurancePlan.GeneralCost' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanGeneralCost::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'groupSize' =>
       [
        'setter' => 'setGroupSize',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'cost' =>
       [
        'setter' => 'setCost',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'comment' =>
       [
        'setter' => 'setComment',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
    ],
    ],
    'InsurancePlan.SpecificCost' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanSpecificCost::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'category' =>
       [
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'benefit' =>
       [
        'setter' => 'addBenefit',
        'element' => 'InsurancePlan.Benefit1',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanBenefit1::class,
      ],
    ],
    ],
    'InsurancePlan.Benefit1' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanBenefit1::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'cost' =>
       [
        'setter' => 'addCost',
        'element' => 'InsurancePlan.Cost',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanCost::class,
      ],
    ],
    ],
    'InsurancePlan.Cost' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInsurancePlan\FHIRInsurancePlanCost::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'applicability' =>
       [
        'setter' => 'setApplicability',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'qualifiers' =>
       [
        'setter' => 'addQualifiers',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'Quantity',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRQuantity::class,
      ],
    ],
    ],
    'Invoice' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRInvoice::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'InvoiceStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInvoiceStatus::class,
      ],
      'cancelledReason' =>
       [
        'setter' => 'setCancelledReason',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'recipient' =>
       [
        'setter' => 'setRecipient',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'participant' =>
       [
        'setter' => 'addParticipant',
        'element' => 'Invoice.Participant',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoiceParticipant::class,
      ],
      'issuer' =>
       [
        'setter' => 'setIssuer',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'account' =>
       [
        'setter' => 'setAccount',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'lineItem' =>
       [
        'setter' => 'addLineItem',
        'element' => 'Invoice.LineItem',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoiceLineItem::class,
      ],
      'totalPriceComponent' =>
       [
        'setter' => 'addTotalPriceComponent',
        'element' => 'Invoice.PriceComponent',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoicePriceComponent::class,
      ],
      'totalNet' =>
       [
        'setter' => 'setTotalNet',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'totalGross' =>
       [
        'setter' => 'setTotalGross',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
      'paymentTerms' =>
       [
        'setter' => 'setPaymentTerms',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
    ],
    ],
    'Invoice.Participant' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoiceParticipant::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'role' =>
       [
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'actor' =>
       [
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Invoice.LineItem' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoiceLineItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'sequence' =>
       [
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPositiveInt::class,
      ],
      'chargeItemReference' =>
       [
        'setter' => 'setChargeItemReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'chargeItemCodeableConcept' =>
       [
        'setter' => 'setChargeItemCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'priceComponent' =>
       [
        'setter' => 'addPriceComponent',
        'element' => 'Invoice.PriceComponent',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoicePriceComponent::class,
      ],
    ],
    ],
    'Invoice.PriceComponent' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRInvoice\FHIRInvoicePriceComponent::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'InvoicePriceComponentType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInvoicePriceComponentType::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'factor' =>
       [
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDecimal::class,
      ],
      'amount' =>
       [
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMoney::class,
      ],
    ],
    ],
    'InvoiceStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRInvoiceStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'InvoiceStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'Library' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLibrary::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'url' =>
       [
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'version' =>
       [
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'subtitle' =>
       [
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPublicationStatus::class,
      ],
      'experimental' =>
       [
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subjectCodeableConcept' =>
       [
        'setter' => 'setSubjectCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subjectReference' =>
       [
        'setter' => 'setSubjectReference',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'publisher' =>
       [
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'contact' =>
       [
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'useContext' =>
       [
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUsageContext::class,
      ],
      'jurisdiction' =>
       [
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'purpose' =>
       [
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'usage' =>
       [
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'copyright' =>
       [
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMarkdown::class,
      ],
      'approvalDate' =>
       [
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'lastReviewDate' =>
       [
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDate::class,
      ],
      'effectivePeriod' =>
       [
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRPeriod::class,
      ],
      'topic' =>
       [
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'author' =>
       [
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'editor' =>
       [
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'reviewer' =>
       [
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'endorser' =>
       [
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactDetail::class,
      ],
      'relatedArtifact' =>
       [
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRRelatedArtifact::class,
      ],
      'parameter' =>
       [
        'setter' => 'addParameter',
        'element' => 'ParameterDefinition',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRParameterDefinition::class,
      ],
      'dataRequirement' =>
       [
        'setter' => 'addDataRequirement',
        'element' => 'DataRequirement',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDataRequirement::class,
      ],
      'content' =>
       [
        'setter' => 'addContent',
        'element' => 'Attachment',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAttachment::class,
      ],
    ],
    ],
    'Linkage' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLinkage::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'active' =>
       [
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'author' =>
       [
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'item' =>
       [
        'setter' => 'addItem',
        'element' => 'Linkage.Item',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRLinkage\FHIRLinkageItem::class,
      ],
    ],
    ],
    'Linkage.Item' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRLinkage\FHIRLinkageItem::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'type' =>
       [
        'setter' => 'setType',
        'element' => 'LinkageType',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRLinkageType::class,
      ],
      'resource' =>
       [
        'setter' => 'setResource',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'LinkageType' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRLinkageType::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'LinkageType-list',
        'type' => 'string',
      ],
    ],
    ],
    'List' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRList::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'ListStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRListStatus::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'ListMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRListMode::class,
      ],
      'title' =>
       [
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'code' =>
       [
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'subject' =>
       [
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'encounter' =>
       [
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'source' =>
       [
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'orderedBy' =>
       [
        'setter' => 'setOrderedBy',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'note' =>
       [
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAnnotation::class,
      ],
      'entry' =>
       [
        'setter' => 'addEntry',
        'element' => 'List.Entry',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRList\FHIRListEntry::class,
      ],
      'emptyReason' =>
       [
        'setter' => 'setEmptyReason',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
    ],
    ],
    'List.Entry' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRList\FHIRListEntry::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'flag' =>
       [
        'setter' => 'setFlag',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'deleted' =>
       [
        'setter' => 'setDeleted',
        'element' => 'boolean',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRBoolean::class,
      ],
      'date' =>
       [
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRDateTime::class,
      ],
      'item' =>
       [
        'setter' => 'setItem',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'ListStatus' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRElement\FHIRListStatus::class,
    'extendedElementName' => 'Element',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'value' =>
       [
        'setter' => 'setValue',
        'element' => 'ListStatus-list',
        'type' => 'string',
      ],
    ],
    ],
    'Location' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRDomainResource\FHIRLocation::class,
    'extendedElementName' => 'DomainResource',
    'properties' =>
     [
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'id',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRId::class,
      ],
      'meta' =>
       [
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRMeta::class,
      ],
      'implicitRules' =>
       [
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRUri::class,
      ],
      'language' =>
       [
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCode::class,
      ],
      'text' =>
       [
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRNarrative::class,
      ],
      'contained' =>
       [
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => \OpenEMR\FHIR\R4\FHIRResourceContainer::class,
      ],
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'identifier' =>
       [
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRIdentifier::class,
      ],
      'status' =>
       [
        'setter' => 'setStatus',
        'element' => 'LocationStatus',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRLocationStatus::class,
      ],
      'operationalStatus' =>
       [
        'setter' => 'setOperationalStatus',
        'element' => 'Coding',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCoding::class,
      ],
      'name' =>
       [
        'setter' => 'setName',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'alias' =>
       [
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'description' =>
       [
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'mode' =>
       [
        'setter' => 'setMode',
        'element' => 'LocationMode',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRLocationMode::class,
      ],
      'type' =>
       [
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'telecom' =>
       [
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRContactPoint::class,
      ],
      'address' =>
       [
        'setter' => 'setAddress',
        'element' => 'Address',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRAddress::class,
      ],
      'physicalType' =>
       [
        'setter' => 'setPhysicalType',
        'element' => 'CodeableConcept',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRCodeableConcept::class,
      ],
      'position' =>
       [
        'setter' => 'setPosition',
        'element' => 'Location.Position',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRLocation\FHIRLocationPosition::class,
      ],
      'managingOrganization' =>
       [
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'partOf' =>
       [
        'setter' => 'setPartOf',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
      'hoursOfOperation' =>
       [
        'setter' => 'addHoursOfOperation',
        'element' => 'Location.HoursOfOperation',
        'type' => \OpenEMR\FHIR\R4\FHIRResource\FHIRLocation\FHIRLocationHoursOfOperation::class,
      ],
      'availabilityExceptions' =>
       [
        'setter' => 'setAvailabilityExceptions',
        'element' => 'string',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRString::class,
      ],
      'endpoint' =>
       [
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRReference::class,
      ],
    ],
    ],
    'Location.Position' =>
     [
    'fullClassName' => \OpenEMR\FHIR\R4\FHIRResource\FHIRLocation\FHIRLocationPosition::class,
    'extendedElementName' => 'BackboneElement',
    'properties' =>
     [
      'extension' =>
       [
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => \OpenEMR\FHIR\R4\FHIRElement\FHIRExtension::class,
      ],
      'id' =>
       [
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ],
      'modifierExtension' =>
       [
        'setter' => 'addModifierExtension',
        'element' => '