<?php

/*
 * FhirQuestionnaireFormServiceTest.php
 * TODO: @adunsulag when we have a place to put integration tests, we should move this class.
 *
 * @package openemr
 * @link      http://www.open-emr.org
 * @author    Stephen Nielson <snielson@discoverandchange.com>
 * @copyright Copyright (c) 2025 Stephen Nielson <snielson@discoverandchange.com>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 */

namespace OpenEMR\Tests\Services\FHIR\Questionnaire;

use Monolog\Level;
use OpenEMR\Common\Database\QueryUtils;
use OpenEMR\Common\Logging\SystemLogger;
use OpenEMR\Common\Uuid\UuidRegistry;
use OpenEMR\FHIR\R4\FHIRDomainResource\FHIRQuestionnaire;
use OpenEMR\Services\FHIR\Questionnaire\FhirQuestionnaireFormService;
use OpenEMR\Services\QuestionnaireService;
use PHPUnit\Framework\TestCase;
use Exception;

class FhirQuestionnaireFormServiceIntegrationTest extends TestCase
{
    /**
     * @var array Saved off session storage while we run this test.
     */
    private array $originalSession;

    protected function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        // TODO: When we have a session storage we can mock we want to get away from
        // this session behavior
        $this->originalSession = $_SESSION;
    }

    protected function tearDown(): void
    {
        parent::tearDown();
        $_SESSION = $this->originalSession; // restore the session sadly.
        // need to clean up the database records
        $name = 'PHPUnit Test Questionnaire';
        QueryUtils::sqlStatementThrowException("DELETE FROM uuid_registry WHERE uuid IN (select uuid FROM questionnaire_repository WHERE name =?)", [$name]);
        QueryUtils::sqlStatementThrowException("DELETE FROM questionnaire_repository WHERE name = ? ", [$name]);
    }

    /**
     * @return void
     * @throws Exception
     */
    public function testSearchByIdWillReturnSingleQuestionnaire(): void
    {
        $_SESSION['authUserID'] = QueryUtils::fetchSingleValue('select id FROM users ORDER BY id LIMIT 1', 'id');
        // save the questionnaire we want returned and verify the system returns the questionnaire
        $jsonQuestionnaire = file_get_contents(__DIR__ . '/../../../data/Services/FHIR/Questionnaire/questionnaire-sdc-pathology.json');
        $questionnaireAsJson = json_decode($jsonQuestionnaire, true);
        $questionnaireAsJson['name'] = $questionnaireAsJson['title'] = "PHPUnit Test Questionnaire";
        $questionnaireAsJson['url'] = "Questionnaire/" . $questionnaireAsJson['id']; // not a full URL but good enough for testing
        $questionnaireService = new QuestionnaireService();
        $insertId = $questionnaireService->saveQuestionnaireResource($questionnaireAsJson);
        // need to grab the record because we don't get ANY kind of uuid from this
        $binUuid = QueryUtils::fetchSingleValue('SELECT uuid FROM questionnaire_repository WHERE id = ?', 'uuid', [$insertId]);
        $uuid = UuidRegistry::uuidToString($binUuid);

        // test that an inserted questionnaire form will retrieve the questionnaire via the service
        $service = new FhirQuestionnaireFormService();
        $service->setSystemLogger(new SystemLogger(Level::Critical));
        $processingResult = $service->getOne($uuid);

        $this->assertTrue($processingResult->isValid(), "Processing Result was valid for retrieval");
        $this->assertNotEmpty($processingResult->getData(), "Processing result should have returned a single record");
        $this->assertCount(1, $processingResult->getData(), "Only one record should be returned");
        $questionnaireReturned = $processingResult->getFirstDataResult();
        $this->assertInstanceOf(FHIRQuestionnaire::class, $questionnaireReturned);
        $this->assertEquals($uuid, $questionnaireReturned->getId()->getValue(), "Should return the proper questionnaire id");
        $this->assertEquals('4.0.0', $questionnaireReturned->getVersion());
        // save mechanism lowers everything and removes spaces....
        $this->assertEquals('phpunittestquestionnaire', $questionnaireReturned->getName());
        $this->assertCount(2, $questionnaireReturned->getItem());
        $this->assertEquals("1", $questionnaireReturned->getItem()[0]->getLinkId());
        $this->assertEquals("2", $questionnaireReturned->getItem()[1]->getLinkId());
    }
}
